# Ce fichier est genere par le plugin saveauto
# Base : GNOSIS
# Serveur : pangnosis.bourillon.net
# Date : 25/01/2012 16h36
# OS Serveur : Linux/Unix
# Version PHP : 4.4.9
# Version mySQL : 5.0.90-log
# IP Client : 83.203.13.253
# Version de SPIP : 2.1.12
# 30 plugins utilises :
# - images (1.0.1)
# - msie_compat (1.0.0)
# - porte_plume (1.7.8)
# - safehtml (1.3.7)
# - vertebres (1.0.0)
# - article_pdf (0.4.5)
# - boutonstexte (0.3.3)
# - pb_cesure (1.1.0)
# - cfg (1.16.0)
# - cite (0.4.1)
# - edition_plein_ecran (1.0.0)
# - typoenluminee (3.3.0)
# - facteur (1.8.4)
# - forms (0.4.1)
# - intertitrestdm (0.8.4)
# - couteau_suisse (1.8.56)
# - nyro (0.2.1)
# - spip_bonux (2.3.0)
# - sarkaspip (3.1.0)
# - thumbsites (0.6.1)
# - zengarden (1.1.1)
# - a2a (0.4.3)
# - accesrestreint (3.3.1)
# - agenda (2.3.0)
# - saisies (1.20.2)
# - theme_sarka_ecology (0.1.0)
# - saveauto (0.7.5)
# - fancybox (0.6.1)
# - jqueryui (1.8.16)
# - compresseur (1.0.1)

# Fichier SQL 100% compatible PHPMyadmin

# -------Debut du fichier----------

# Structure de la table kinomichibe_articles
DROP TABLE IF EXISTS `kinomichibe_articles`;

CREATE TABLE `kinomichibe_articles` (
  `id_article` bigint(21) NOT NULL auto_increment,
  `surtitre` text NOT NULL,
  `titre` text NOT NULL,
  `soustitre` text NOT NULL,
  `id_rubrique` bigint(21) NOT NULL default '0',
  `descriptif` text NOT NULL,
  `chapo` mediumtext NOT NULL,
  `texte` longtext NOT NULL,
  `ps` mediumtext NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `statut` varchar(10) NOT NULL default '0',
  `id_secteur` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `export` varchar(10) default 'oui',
  `date_redac` datetime NOT NULL default '0000-00-00 00:00:00',
  `visites` int(11) NOT NULL default '0',
  `referers` int(11) NOT NULL default '0',
  `popularite` double NOT NULL default '0',
  `accepter_forum` char(3) NOT NULL default '',
  `date_modif` datetime NOT NULL default '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `id_trad` bigint(21) NOT NULL default '0',
  `extra` longtext,
  `id_version` int(10) unsigned NOT NULL default '0',
  `nom_site` tinytext NOT NULL,
  `url_site` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id_article`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `id_trad` (`id_trad`),
  KEY `lang` (`lang`),
  KEY `statut` (`statut`,`date`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_articles
INSERT INTO `kinomichibe_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('1', '', 'Accueil', '', '1', '', '', 'Site des pratiquants de Kinomichi en Belgique - Mthode Noro', '', '2010-08-16 22:14:00', 'publie', '1', '2010-08-17 01:33:48', 'oui', '0000-00-00 00:00:00', '1', '0', '0.60679230600948', 'non', '2010-08-16 23:59:35', 'fr', 'non', '0', '', '2', '', '');
INSERT INTO `kinomichibe_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('2', '', 'Dojo de Bruxelles', '', '5', '', '', 'Adresse : Institut Jaques-Dalcroze - 
rue Henri Wafelaerts 52 - 

Bruxelles Belgique 

email : 	[xt_ine@telenet.be->xt_ine@telenet.be]

Tlphone:	32 16 43 31 96  

Responsable :	Lejeune Christine

	
Horaires d\'ouverture :	mardi : 19.30 - 21.30 h', '', '2010-08-17 00:32:12', 'publie', '5', '2010-08-19 13:13:27', 'oui', '0000-00-00 00:00:00', '5', '0', '2.0969033153564e-273', 'non', '2010-08-19 13:13:27', 'fr', 'non', '0', '', '2', '', '');
INSERT INTO `kinomichibe_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('3', '', 'Dojo de Louvain-la-Neuve', '', '7', '', '', 'Centre Universitaire
place des sports 1
Complexe sportif de Blocry
1348 Louvain la Neuve
Belgique 

Email : 	[aland.duray@skynet.be->aland.duray@skynet.be]

Tlphone:	+32 10/45 35 53  +32 478/256417

Responsable :	Duray Aland


Adjointe : 	Anne-sophie Kroonen


Horaires d\'ouverture :
	
- Mercredi de 20h30  22h15 
- Vendredi de 20h30  22h15 
- Dimanche de 9h  13h une fois par mois', '', '2010-08-17 00:31:35', 'publie', '7', '2010-08-19 13:19:34', 'oui', '0000-00-00 00:00:00', '8', '0', '8.38761326142382e-273', 'non', '2010-08-19 13:19:33', 'fr', 'non', '0', '', '2', '', '');
INSERT INTO `kinomichibe_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('4', '', 'Dojo de Lige', '', '6', '', '', 'A.S.B.L Ouverture - Lige - Belgique 


Email : 	[ute_niendieck@skynet.be->ute_niendieck@skynet.be]
	  

Responsable :	Niendieck Ute', '', '2010-08-17 00:35:32', 'publie', '6', '2010-08-19 13:17:34', 'oui', '0000-00-00 00:00:00', '7', '0', '4.1938066307122e-273', 'non', '2010-08-19 13:17:32', 'fr', 'non', '0', '', '2', '', '');
INSERT INTO `kinomichibe_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('5', '', 'Dojo de Jemeppe sur Meuse', '', '8', '', '', 'Ecole de Psychomotricit Lon Troclet - 
avenue Montesquieu,6 - 4101 Jemeppe sur Meuse -  Belgique 


email : 	[henno.willy@gmail.com->henno.willy@gmail.com]

	
Tlphone:	+32 43875024  +32 495622621


Responsable :	Henno Willy

	
Horaires d\'ouverture :	
Variables chaque anne et rpartis sur deux priodes: 
septembre  mi-novembre et janvier  mi-mars. 


L\'atelier s\'organise en trois groupes (45 h./anne chacun). 


L\'accs est priv.', '', '2010-08-17 00:44:40', 'publie', '8', '2010-08-19 13:10:28', 'oui', '0000-00-00 00:00:00', '5', '0', '3.8924371244886e-13', 'non', '2010-08-19 13:10:27', 'fr', 'non', '0', '', '2', '', '');
INSERT INTO `kinomichibe_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('6', '', 'Dojo de Marchin', '', '9', '', '', 'Harmonie du Mouvement - Place Belle Maison - Salle omnisport - 

4570 Marchin - Belgique 


Email : 	[jackydeprins@yahoo.fr->jackydeprins@yahoo.fr]

Tlphone:	+32 85412838  +32 473842372

Responsable :	Deprins Jacqueline

Horaires d\'ouverture :	Jeudi 17 h  19 h.', '', '2010-08-17 00:50:16', 'publie', '9', '2010-08-19 13:23:32', 'oui', '0000-00-00 00:00:00', '4', '0', '3.8918762364739e-13', 'non', '2010-08-19 13:23:32', 'fr', 'non', '0', '', '2', '', '');

# Structure de la table kinomichibe_articles_lies
DROP TABLE IF EXISTS `kinomichibe_articles_lies`;

CREATE TABLE `kinomichibe_articles_lies` (
  `id_article` bigint(21) NOT NULL,
  `id_article_lie` bigint(21) NOT NULL,
  `rang` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_article`,`id_article_lie`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_articles_lies

# Structure de la table kinomichibe_auteurs
DROP TABLE IF EXISTS `kinomichibe_auteurs`;

CREATE TABLE `kinomichibe_auteurs` (
  `id_auteur` bigint(21) NOT NULL auto_increment,
  `nom` text NOT NULL,
  `bio` text NOT NULL,
  `email` tinytext NOT NULL,
  `nom_site` tinytext NOT NULL,
  `url_site` text NOT NULL,
  `login` varchar(255) character set utf8 collate utf8_bin default NULL,
  `pass` tinytext NOT NULL,
  `low_sec` tinytext NOT NULL,
  `statut` varchar(255) NOT NULL default '0',
  `webmestre` varchar(3) NOT NULL default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `pgp` text NOT NULL,
  `htpass` tinytext NOT NULL,
  `en_ligne` datetime NOT NULL default '0000-00-00 00:00:00',
  `imessage` varchar(3) default NULL,
  `messagerie` varchar(3) default NULL,
  `alea_actuel` tinytext,
  `alea_futur` tinytext,
  `prefs` tinytext,
  `cookie_oubli` tinytext,
  `source` varchar(10) NOT NULL default 'spip',
  `lang` varchar(10) NOT NULL default '',
  `extra` longtext,
  PRIMARY KEY  (`id_auteur`),
  KEY `login` (`login`),
  KEY `statut` (`statut`),
  KEY `en_ligne` (`en_ligne`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_auteurs
INSERT INTO `kinomichibe_auteurs` (`id_auteur`, `nom`, `bio`, `email`, `nom_site`, `url_site`, `login`, `pass`, `low_sec`, `statut`, `webmestre`, `maj`, `pgp`, `htpass`, `en_ligne`, `imessage`, `messagerie`, `alea_actuel`, `alea_futur`, `prefs`, `cookie_oubli`, `source`, `lang`, `extra`) values ('1', 'platonas', '', 'jp@bourillon.net', '', '', 'platonas', '23c6ac0e5bcfb6a1409c47b82b5880bad1d41b587063b8a708a951ff7b29f53c', 'Pmye2AT6', '0minirezo', 'oui', '2010-08-19 17:32:46', '', '$1$RK92oNxF$0tSG3L4vX5O3jIVXKOp8A0', '0000-00-00 00:00:00', '', '', '16590735574c6cfeae8b25f1.46504215', '6005848854c6d3e3613b365.53107593', 'a:1:{s:3:\"cnx\";s:0:\"\";}', '', 'spip', '', '');

# Structure de la table kinomichibe_auteurs_articles
DROP TABLE IF EXISTS `kinomichibe_auteurs_articles`;

CREATE TABLE `kinomichibe_auteurs_articles` (
  `id_auteur` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_auteur`,`id_article`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_auteurs_articles
INSERT INTO `kinomichibe_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '1');
INSERT INTO `kinomichibe_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '2');
INSERT INTO `kinomichibe_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '3');
INSERT INTO `kinomichibe_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '4');
INSERT INTO `kinomichibe_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '5');
INSERT INTO `kinomichibe_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '6');

# Structure de la table kinomichibe_auteurs_messages
DROP TABLE IF EXISTS `kinomichibe_auteurs_messages`;

CREATE TABLE `kinomichibe_auteurs_messages` (
  `id_auteur` bigint(21) NOT NULL default '0',
  `id_message` bigint(21) NOT NULL default '0',
  `vu` char(3) default NULL,
  PRIMARY KEY  (`id_auteur`,`id_message`),
  KEY `id_message` (`id_message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_auteurs_messages

# Structure de la table kinomichibe_auteurs_rubriques
DROP TABLE IF EXISTS `kinomichibe_auteurs_rubriques`;

CREATE TABLE `kinomichibe_auteurs_rubriques` (
  `id_auteur` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_auteur`,`id_rubrique`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_auteurs_rubriques

# Structure de la table kinomichibe_breves
DROP TABLE IF EXISTS `kinomichibe_breves`;

CREATE TABLE `kinomichibe_breves` (
  `id_breve` bigint(21) NOT NULL auto_increment,
  `date_heure` datetime NOT NULL default '0000-00-00 00:00:00',
  `titre` text NOT NULL,
  `texte` longtext NOT NULL,
  `lien_titre` text NOT NULL,
  `lien_url` text NOT NULL,
  `statut` varchar(6) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `extra` longtext,
  PRIMARY KEY  (`id_breve`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_breves

# Structure de la table kinomichibe_cm_lists
DROP TABLE IF EXISTS `kinomichibe_cm_lists`;

CREATE TABLE `kinomichibe_cm_lists` (
  `lst_id` int(11) NOT NULL auto_increment,
  `lst_name` varchar(255) NOT NULL,
  `lst_comment` text NOT NULL,
  `lst_moderation` varchar(10) NOT NULL,
  `lst_moderator_email` varchar(255) NOT NULL,
  `lst_subscribe_subject` varchar(255) NOT NULL,
  `lst_subscribe_text` text NOT NULL,
  `lst_subject` varchar(255) NOT NULL,
  `lst_unsubscribe_subject` varchar(255) NOT NULL,
  `lst_unsubscribe_text` text NOT NULL,
  `lst_subject_tag` tinyint(1) NOT NULL default '1',
  `lst_url_html` varchar(255) NOT NULL,
  `lst_url_text` varchar(255) NOT NULL,
  `lst_auto_mode` enum('none','day','week','month') default 'none',
  `lst_auto_hour` tinyint(2) NOT NULL default '8',
  `lst_auto_week_day` tinyint(1) NOT NULL default '1',
  `lst_auto_week_days` varchar(13) NOT NULL default '1',
  `lst_auto_month_day` tinyint(2) NOT NULL default '1',
  `lst_auto_subscribers` varchar(255) NOT NULL,
  `lst_auto_subscribers_mode` tinyint(1) NOT NULL default '0',
  `lst_auto_subscribers_updated` int(11) NOT NULL default '0',
  PRIMARY KEY  (`lst_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_lists
INSERT INTO `kinomichibe_cm_lists` (`lst_id`, `lst_name`, `lst_comment`, `lst_moderation`, `lst_moderator_email`, `lst_subscribe_subject`, `lst_subscribe_text`, `lst_subject`, `lst_unsubscribe_subject`, `lst_unsubscribe_text`, `lst_subject_tag`, `lst_url_html`, `lst_url_text`, `lst_auto_mode`, `lst_auto_hour`, `lst_auto_week_day`, `lst_auto_week_days`, `lst_auto_month_day`, `lst_auto_subscribers`, `lst_auto_subscribers_mode`, `lst_auto_subscribers_updated`) values ('1', 'Kinomichi en Belgique', 'Lettre d\'information des activites liees au Kinomichi en Belgique', 'email', 'jp@bourillon.net', 'Confirmation de votre inscription', 'Bonjour,

Pour confirmer votre inscription &agrave; la lettre d\'information @@NOM_COMPLET@@ au format @@FORMAT_INSCRIPTION@@, veuillez cliquer sur ce lien :

 @@URL_CONFIRMATION@@

Merci
', '', 'Confirmation de votre d&eacute;sinscription', 'Bonjour,

Veuillez confirmer votre d&eacute;sinscription en cliquant sur ce lien :

 @@URL_CONFIRMATION@@

Merci
', '1', 'http://www.kinomichi.be/spip.php?page=clevermail_nouveautes_html', 'http://www.kinomichi.be/spip.php?page=clevermail_nouveautes_text', 'none', '8', '1', '1', '1', '', '0', '0');

# Structure de la table kinomichibe_cm_lists_subscribers
DROP TABLE IF EXISTS `kinomichibe_cm_lists_subscribers`;

CREATE TABLE `kinomichibe_cm_lists_subscribers` (
  `lst_id` int(11) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  `lsr_mode` tinyint(1) NOT NULL,
  `lsr_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`lst_id`,`sub_id`),
  KEY `lst_id` (`lst_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_lists_subscribers
INSERT INTO `kinomichibe_cm_lists_subscribers` (`lst_id`, `sub_id`, `lsr_mode`, `lsr_id`) values ('1', '1', '1', 'a5fc390845e95757d7ce13a519446b90');

# Structure de la table kinomichibe_cm_pending
DROP TABLE IF EXISTS `kinomichibe_cm_pending`;

CREATE TABLE `kinomichibe_cm_pending` (
  `lst_id` int(11) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  `pnd_action` varchar(15) NOT NULL,
  `pnd_mode` tinyint(1) NOT NULL,
  `pnd_action_date` int(11) NOT NULL,
  `pnd_action_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`lst_id`,`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_pending

# Structure de la table kinomichibe_cm_posts
DROP TABLE IF EXISTS `kinomichibe_cm_posts`;

CREATE TABLE `kinomichibe_cm_posts` (
  `pst_id` bigint(20) NOT NULL auto_increment,
  `lst_id` int(11) NOT NULL,
  `pst_date_create` int(11) NOT NULL,
  `pst_date_update` int(11) NOT NULL,
  `pst_date_sent` int(11) NOT NULL,
  `pst_subject` varchar(255) NOT NULL,
  `pst_html` longtext NOT NULL,
  `pst_text` longtext NOT NULL,
  PRIMARY KEY  (`pst_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_posts

# Structure de la table kinomichibe_cm_posts_done
DROP TABLE IF EXISTS `kinomichibe_cm_posts_done`;

CREATE TABLE `kinomichibe_cm_posts_done` (
  `pst_id` bigint(20) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`pst_id`,`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_posts_done

# Structure de la table kinomichibe_cm_posts_links
DROP TABLE IF EXISTS `kinomichibe_cm_posts_links`;

CREATE TABLE `kinomichibe_cm_posts_links` (
  `lnk_id` bigint(20) NOT NULL auto_increment,
  `pst_id` bigint(20) NOT NULL,
  `lnk_name` varchar(255) NOT NULL,
  `lnk_url` text NOT NULL,
  PRIMARY KEY  (`lnk_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_posts_links

# Structure de la table kinomichibe_cm_posts_queued
DROP TABLE IF EXISTS `kinomichibe_cm_posts_queued`;

CREATE TABLE `kinomichibe_cm_posts_queued` (
  `pst_id` bigint(20) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  `psq_date` int(11) NOT NULL,
  PRIMARY KEY  (`pst_id`,`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_posts_queued

# Structure de la table kinomichibe_cm_settings
DROP TABLE IF EXISTS `kinomichibe_cm_settings`;

CREATE TABLE `kinomichibe_cm_settings` (
  `set_name` varchar(15) NOT NULL,
  `set_value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_settings
INSERT INTO `kinomichibe_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_FROM', 'jp@bourillon.net');
INSERT INTO `kinomichibe_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_ADMIN', 'jp@bourillon.net');
INSERT INTO `kinomichibe_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_RETURN', 'jp@bourillon.net');
INSERT INTO `kinomichibe_cm_settings` (`set_name`, `set_value`) values ('CM_SEND_NUMBER', '50');
INSERT INTO `kinomichibe_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_SUBJECT', 'Confirmation de votre inscription');
INSERT INTO `kinomichibe_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_TEXT', '
Bonjour,

Pour confirmer votre inscription aux lettres d\'information suivantes :

 @@NOM_COMPLET@@ 

veuillez cliquer sur ce lien :

 @@URL_CONFIRMATION@@

Merci
');

# Structure de la table kinomichibe_cm_subscribers
DROP TABLE IF EXISTS `kinomichibe_cm_subscribers`;

CREATE TABLE `kinomichibe_cm_subscribers` (
  `sub_id` bigint(20) NOT NULL auto_increment,
  `sub_email` varchar(255) NOT NULL,
  `sub_profile` varchar(32) NOT NULL,
  PRIMARY KEY  (`sub_id`),
  KEY `sub_profile` (`sub_profile`),
  KEY `sub_email` (`sub_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_cm_subscribers
INSERT INTO `kinomichibe_cm_subscribers` (`sub_id`, `sub_email`, `sub_profile`) values ('1', 'jp@bourillon.net', '933fe7c1a7a28a38cf09bf1375fe29e8');

# Structure de la table kinomichibe_documents
DROP TABLE IF EXISTS `kinomichibe_documents`;

CREATE TABLE `kinomichibe_documents` (
  `id_document` bigint(21) NOT NULL auto_increment,
  `id_vignette` bigint(21) NOT NULL default '0',
  `extension` varchar(10) NOT NULL default '',
  `titre` text NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `descriptif` text NOT NULL,
  `fichier` varchar(255) NOT NULL default '',
  `taille` int(11) default NULL,
  `largeur` int(11) default NULL,
  `hauteur` int(11) default NULL,
  `mode` enum('vignette','image','document') NOT NULL default 'document',
  `distant` varchar(3) default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_document`),
  KEY `id_vignette` (`id_vignette`),
  KEY `mode` (`mode`),
  KEY `extension` (`extension`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_documents

# Structure de la table kinomichibe_documents_donnees
DROP TABLE IF EXISTS `kinomichibe_documents_donnees`;

CREATE TABLE `kinomichibe_documents_donnees` (
  `id_document` bigint(21) NOT NULL default '0',
  `id_donnee` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_document`),
  KEY `id_document` (`id_document`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_documents_donnees

# Structure de la table kinomichibe_documents_liens
DROP TABLE IF EXISTS `kinomichibe_documents_liens`;

CREATE TABLE `kinomichibe_documents_liens` (
  `id_document` bigint(21) NOT NULL default '0',
  `id_objet` bigint(21) NOT NULL default '0',
  `objet` varchar(25) NOT NULL default '',
  `vu` enum('non','oui') NOT NULL default 'non',
  PRIMARY KEY  (`id_document`,`id_objet`,`objet`),
  KEY `id_document` (`id_document`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_documents_liens

# Structure de la table kinomichibe_forms
DROP TABLE IF EXISTS `kinomichibe_forms`;

CREATE TABLE `kinomichibe_forms` (
  `id_form` bigint(21) NOT NULL auto_increment,
  `titre` varchar(255) NOT NULL,
  `descriptif` text,
  `type_form` varchar(255) NOT NULL,
  `modifiable` enum('non','oui') default 'non',
  `multiple` enum('non','oui') default 'non',
  `forms_obligatoires` varchar(255) NOT NULL default '',
  `email` text,
  `champconfirm` varchar(255) NOT NULL,
  `texte` text,
  `moderation` varchar(10) default 'posteriori',
  `public` enum('non','oui') NOT NULL default 'non',
  `linkable` enum('non','oui') NOT NULL default 'non',
  `documents` enum('non','oui') NOT NULL default 'non',
  `documents_mail` enum('non','oui') NOT NULL default 'non',
  `arborescent` enum('non','oui') NOT NULL default 'non',
  `html_wrap` text,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_form`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms

# Structure de la table kinomichibe_forms_articles
DROP TABLE IF EXISTS `kinomichibe_forms_articles`;

CREATE TABLE `kinomichibe_forms_articles` (
  `id_form` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_form`,`id_article`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_articles

# Structure de la table kinomichibe_forms_champs
DROP TABLE IF EXISTS `kinomichibe_forms_champs`;

CREATE TABLE `kinomichibe_forms_champs` (
  `id_form` bigint(21) NOT NULL,
  `champ` varchar(100) NOT NULL,
  `rang` bigint(21) NOT NULL,
  `titre` text,
  `type` varchar(100) default NULL,
  `taille` bigint(21) NOT NULL,
  `obligatoire` varchar(3) default NULL,
  `extra_info` text,
  `specifiant` enum('non','oui') NOT NULL default 'non',
  `listable_admin` enum('non','oui') NOT NULL default 'oui',
  `listable` enum('non','oui') NOT NULL default 'oui',
  `public` enum('non','oui') NOT NULL default 'non',
  `saisie` enum('non','oui') NOT NULL default 'oui',
  `aide` text,
  `html_wrap` text,
  PRIMARY KEY  (`id_form`,`champ`),
  KEY `rang` (`rang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_champs

# Structure de la table kinomichibe_forms_champs_choix
DROP TABLE IF EXISTS `kinomichibe_forms_champs_choix`;

CREATE TABLE `kinomichibe_forms_champs_choix` (
  `id_form` bigint(21) NOT NULL,
  `champ` varchar(100) NOT NULL,
  `choix` varchar(100) NOT NULL default '',
  `titre` text,
  `rang` bigint(21) NOT NULL,
  PRIMARY KEY  (`id_form`,`champ`,`choix`),
  KEY `choix` (`choix`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_champs_choix

# Structure de la table kinomichibe_forms_donnees
DROP TABLE IF EXISTS `kinomichibe_forms_donnees`;

CREATE TABLE `kinomichibe_forms_donnees` (
  `id_donnee` bigint(21) NOT NULL auto_increment,
  `id_form` bigint(21) NOT NULL,
  `date` datetime NOT NULL,
  `ip` varchar(255) NOT NULL,
  `id_auteur` bigint(21) NOT NULL,
  `id_article_export` bigint(21) NOT NULL,
  `url` varchar(255) NOT NULL,
  `confirmation` varchar(10) NOT NULL,
  `statut` varchar(10) NOT NULL,
  `cookie` varchar(255) NOT NULL,
  `rang` bigint(21) NOT NULL,
  `bgch` bigint(21) NOT NULL,
  `bdte` bigint(21) NOT NULL,
  `niveau` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_donnee`),
  KEY `id_form` (`id_form`,`date`),
  KEY `date` (`date`),
  KEY `cookie` (`cookie`),
  KEY `id_auteur` (`id_auteur`),
  KEY `statut` (`statut`,`id_form`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_donnees

# Structure de la table kinomichibe_forms_donnees_articles
DROP TABLE IF EXISTS `kinomichibe_forms_donnees_articles`;

CREATE TABLE `kinomichibe_forms_donnees_articles` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  `article_ref` enum('non','oui') NOT NULL default 'non',
  PRIMARY KEY  (`id_donnee`,`id_article`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_donnees_articles

# Structure de la table kinomichibe_forms_donnees_auteurs
DROP TABLE IF EXISTS `kinomichibe_forms_donnees_auteurs`;

CREATE TABLE `kinomichibe_forms_donnees_auteurs` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_auteur`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_donnees_auteurs

# Structure de la table kinomichibe_forms_donnees_champs
DROP TABLE IF EXISTS `kinomichibe_forms_donnees_champs`;

CREATE TABLE `kinomichibe_forms_donnees_champs` (
  `id_donnee` bigint(21) NOT NULL,
  `champ` varchar(255) NOT NULL,
  `valeur` text NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  UNIQUE KEY `champ` (`champ`(128),`id_donnee`,`valeur`(128)),
  KEY `id_donnee` (`id_donnee`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_donnees_champs

# Structure de la table kinomichibe_forms_donnees_donnees
DROP TABLE IF EXISTS `kinomichibe_forms_donnees_donnees`;

CREATE TABLE `kinomichibe_forms_donnees_donnees` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `donnee_ref` enum('non','oui') NOT NULL default 'non',
  `id_donnee_liee` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_donnee_liee`),
  KEY `id_donnee_liee` (`id_donnee_liee`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_donnees_donnees

# Structure de la table kinomichibe_forms_donnees_rubriques
DROP TABLE IF EXISTS `kinomichibe_forms_donnees_rubriques`;

CREATE TABLE `kinomichibe_forms_donnees_rubriques` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_rubrique`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forms_donnees_rubriques

# Structure de la table kinomichibe_forum
DROP TABLE IF EXISTS `kinomichibe_forum`;

CREATE TABLE `kinomichibe_forum` (
  `id_forum` bigint(21) NOT NULL auto_increment,
  `id_parent` bigint(21) NOT NULL default '0',
  `id_thread` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  `id_breve` bigint(21) NOT NULL default '0',
  `date_heure` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_thread` datetime NOT NULL default '0000-00-00 00:00:00',
  `titre` text NOT NULL,
  `texte` mediumtext NOT NULL,
  `auteur` text NOT NULL,
  `email_auteur` text NOT NULL,
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `statut` varchar(8) NOT NULL default '0',
  `ip` varchar(16) NOT NULL default '',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_auteur` bigint(20) NOT NULL default '0',
  `id_message` bigint(21) NOT NULL default '0',
  `id_syndic` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_forum`),
  KEY `id_auteur` (`id_auteur`),
  KEY `id_parent` (`id_parent`),
  KEY `id_thread` (`id_thread`),
  KEY `optimal` (`statut`,`id_parent`,`id_article`,`date_heure`,`id_breve`,`id_syndic`,`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_forum

# Structure de la table kinomichibe_groupes_mots
DROP TABLE IF EXISTS `kinomichibe_groupes_mots`;

CREATE TABLE `kinomichibe_groupes_mots` (
  `id_groupe` bigint(21) NOT NULL auto_increment,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `unseul` varchar(3) NOT NULL default '',
  `obligatoire` varchar(3) NOT NULL default '',
  `tables_liees` text NOT NULL,
  `minirezo` varchar(3) NOT NULL default '',
  `comite` varchar(3) NOT NULL default '',
  `forum` varchar(3) NOT NULL default '',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_groupe`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_groupes_mots
INSERT INTO `kinomichibe_groupes_mots` (`id_groupe`, `titre`, `descriptif`, `texte`, `unseul`, `obligatoire`, `tables_liees`, `minirezo`, `comite`, `forum`, `maj`) values ('1', 'squelette_habillage', '', '', 'non', 'non', 'articles,rubriques', 'oui', 'oui', 'non', '2010-08-16 23:50:55');
INSERT INTO `kinomichibe_groupes_mots` (`id_groupe`, `titre`, `descriptif`, `texte`, `unseul`, `obligatoire`, `tables_liees`, `minirezo`, `comite`, `forum`, `maj`) values ('2', 'Glossaire', '', '', 'non', 'oui', 'articles,rubriques,syndic', 'oui', 'oui', 'non', '2010-08-19 12:49:30');

# Structure de la table kinomichibe_mesabonnes
DROP TABLE IF EXISTS `kinomichibe_mesabonnes`;

CREATE TABLE `kinomichibe_mesabonnes` (
  `id_abonne` bigint(21) NOT NULL auto_increment,
  `nom` text NOT NULL,
  `email` text NOT NULL,
  `lang` tinytext NOT NULL,
  `date_modif` datetime NOT NULL default '0000-00-00 00:00:00',
  `liste` text NOT NULL,
  `statut` varchar(6) NOT NULL default '0',
  PRIMARY KEY  (`id_abonne`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mesabonnes

# Structure de la table kinomichibe_messages
DROP TABLE IF EXISTS `kinomichibe_messages`;

CREATE TABLE `kinomichibe_messages` (
  `id_message` bigint(21) NOT NULL auto_increment,
  `titre` text NOT NULL,
  `texte` longtext NOT NULL,
  `type` varchar(6) NOT NULL default '',
  `date_heure` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_fin` datetime NOT NULL default '0000-00-00 00:00:00',
  `rv` varchar(3) NOT NULL default '',
  `statut` varchar(6) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_message`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_messages

# Structure de la table kinomichibe_meta
DROP TABLE IF EXISTS `kinomichibe_meta`;

CREATE TABLE `kinomichibe_meta` (
  `nom` varchar(255) NOT NULL,
  `valeur` text,
  `impt` enum('non','oui') NOT NULL default 'oui',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_meta
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset_sql_base', 'utf8', 'non', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset_collation_sql_base', 'utf8_general_ci', 'non', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset_sql_connexion', 'utf8', 'non', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('version_installee', '15828', 'non', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('nouvelle_install', '1', 'non', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset', 'utf-8', 'oui', '2010-08-16 21:31:15');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('alea_ephemere_ancien', '36588bb4ccd86c5bf34f847e4c74eac3', 'non', '2010-08-23 20:23:21');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('alea_ephemere', '7eed921e62dc3478fba9f6c53e3c118e', 'non', '2010-08-23 20:23:21');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('alea_ephemere_date', '1282587800', 'non', '2010-08-23 20:23:21');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langues_proposees', 'ar,ast,bg,br,bs,ca,cpf,cpf_hat,cs,da,de,en,eo,es,eu,fa,fon,fr,gl,hu,id,it,it_fem,ja,km,lb,my,nl,oc_auv,oc_gsc,oc_lms,oc_lnc,oc_ni,oc_ni_la,oc_prv,oc_va,pl,pt,pt_br,ro,ru,sv,tr,vi,zh', 'non', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langue_site', 'fr', 'non', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('pcre_u', 'u', 'oui', '2010-08-16 21:31:16');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('email_webmaster', 'jp@bourillon.net', 'oui', '2010-08-16 21:31:16');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('nom_site', 'Kinomichi en Belgique', 'oui', '2010-08-16 21:34:13');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_site', 'http://kinomichi.bourillon.net/index.php', 'non', '2010-08-19 16:23:56');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('descriptif_site', 'Informations sur la pratique du Kinomichi en Belgique - Mthode Noro', 'oui', '2010-08-16 21:34:13');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_breves', 'oui', 'oui', '2010-08-16 21:33:54');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_logos', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_logos_survol', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('config_precise_groupes', 'oui', 'oui', '2010-08-16 21:33:57');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('mots_cles_forums', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_surtitre', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_soustitre', 'oui', 'oui', '2010-08-16 21:34:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_descriptif', 'oui', 'oui', '2010-08-16 21:34:02');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_chapeau', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_texte', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_ps', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_redac', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_mots', 'oui', 'oui', '2010-08-16 21:33:57');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('post_dates', 'oui', 'oui', '2010-08-16 21:34:04');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_urlref', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_redirection', 'oui', 'oui', '2010-08-16 21:34:06');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('creer_preview', 'oui', 'non', '2010-08-16 22:00:21');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('taille_preview', '300', 'non', '2010-08-16 22:00:21');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_modif', 'oui', 'oui', '2010-08-16 21:36:30');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('rubriques_descriptif', 'oui', 'oui', '2010-08-16 21:33:55');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('rubriques_texte', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_titre', 'non', 'oui', '2010-08-16 21:35:10');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_texte', 'non', 'oui', '2010-08-16 21:35:10');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_urlref', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_afficher_barre', 'non', 'oui', '2010-08-16 21:35:10');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('formats_documents_forum', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_sites', 'oui', 'oui', '2010-08-16 21:34:36');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('proposer_sites', '0', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_syndic', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('moderation_sites', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_publics', 'non', 'oui', '2010-08-17 01:33:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('accepter_inscriptions', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('accepter_visiteurs', 'oui', 'oui', '2010-08-16 22:01:14');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('prevenir_auteurs', ',pri,abo,', 'oui', '2010-08-16 21:35:58');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('suivi_edito', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_suivi', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_suivi_inscription', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_neuf', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('jours_neuf', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('quoi_de_neuf', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forum_prive', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forum_prive_objets', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forum_prive_admin', 'oui', 'oui', '2010-08-16 21:35:32');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('messagerie_agenda', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_versions', 'oui', 'oui', '2010-08-16 21:36:36');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_statistiques', 'oui', 'oui', '2010-08-16 21:36:29');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_captures_referers', 'oui', 'oui', '2010-08-16 21:59:04');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('documents_article', 'oui', 'oui', '2010-08-16 21:34:24');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('documents_rubrique', 'oui', 'oui', '2010-08-16 21:34:24');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('documents_date', 'oui', 'oui', '2010-08-16 21:34:24');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('syndication_integrale', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('dir_img', 'IMG/', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('multi_articles', 'oui', 'oui', '2010-08-17 16:11:07');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('multi_rubriques', 'oui', 'oui', '2010-08-17 16:11:07');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('multi_secteurs', 'oui', 'oui', '2010-08-17 16:11:26');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gerer_trad', 'oui', 'oui', '2010-08-17 16:11:26');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langues_multilingue', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('type_urls', 'page', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('email_envoi', '', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_http', 'oui', 'oui', '2010-08-16 21:37:13');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_js', 'oui', 'oui', '2010-08-16 21:37:13');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_css', 'oui', 'oui', '2010-08-16 21:37:13');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('iecompat', 'IE8squish', 'oui', '2010-08-16 21:37:21');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('barre_outils_public', 'oui', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_closure', 'non', 'oui', '2010-08-16 21:31:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langues_utilisees', 'fr', 'oui', '2010-08-16 21:31:19');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugin', 'a:32:{s:6:\"IMAGES\";a:5:{s:3:\"nom\";s:26:\"Filtres Images et Couleurs\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:14:\"filtres_images\";s:7:\"version\";s:5:\"1.0.1\";}s:11:\"MSIE_COMPAT\";a:5:{s:3:\"nom\";s:86:\"<multi>Support vieux navigateurs[de]Unterst&uuml;tzung &auml;lterer Webbrowser</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:11:\"msie_compat\";s:7:\"version\";s:3:\"1.0\";}s:11:\"PORTE_PLUME\";a:5:{s:3:\"nom\";s:100:\"<multi>[fr]Porte plume[en]Quill[ar]&#1575;&#1604;&#1585;&#1610;&#1588;&#1577;[de]Federhalter</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:11:\"porte_plume\";s:7:\"version\";s:5:\"1.7.2\";}s:8:\"SAFEHTML\";a:5:{s:3:\"nom\";s:8:\"SafeHTML\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:8:\"safehtml\";s:7:\"version\";s:5:\"1.3.7\";}s:9:\"VERTEBRES\";a:5:{s:3:\"nom\";s:28:\"Vertebres, lecteur de tables\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:9:\"vertebres\";s:7:\"version\";s:3:\"1.0\";}s:11:\"ARTICLE_PDF\";a:5:{s:3:\"nom\";s:60:\"<multi>
    [fr]Article PDF
    [de]PDF Artikel
    </multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:20:\"auto/article_pdf_2_0\";s:7:\"version\";s:3:\"0.2\";}s:3:\"CFG\";a:5:{s:3:\"nom\";s:90:\"<multi>
    [fr]cfg: moteur de configuration
    [de]CFG: Konfigurationsmodul
    </multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:8:\"auto/cfg\";s:7:\"version\";s:6:\"1.15.2\";}s:13:\"TYPOENLUMINEE\";a:5:{s:3:\"nom\";s:63:\" 
	Enluminures typographiques pour SPIP 2 &amp; Porte plume
	\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:34:\"auto/enluminures_typographiques_v3\";s:7:\"version\";s:5:\"3.1.3\";}s:12:\"ENVIAR_EMAIL\";a:5:{s:3:\"nom\";s:61:\"<multi>
	[es]Enviar email 2
	[fr]Envoyer par mail 2
	</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:14:\"enviar_email_2\";s:7:\"version\";s:3:\"0.2\";}s:7:\"FACTEUR\";a:5:{s:3:\"nom\";s:7:\"Facteur\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:12:\"auto/facteur\";s:7:\"version\";s:5:\"1.5.8\";}s:5:\"FORMS\";a:5:{s:3:\"nom\";s:193:\" 
	<multi>[ar]&#1575;&#1604;&#1575;&#1587;&#1578;&#1605;&#1575;&#1585;&#1575;&#1578;[en]Forms[de]Formulare und Tabellen[fr]Formulaires&amp;Tables[it] Forms[es] Formularios</multi> (SPIP 2.0+)
	\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:24:\"auto/forms_et_tables_2_0\";s:7:\"version\";s:5:\"0.306\";}s:9:\"GCALENDAR\";a:5:{s:3:\"nom\";s:137:\"<multi>[fr]GCalendar, Google Calendar pour SPIP[en]GCalendar, Google Calendar for SPIP[ar]GCalendar, Google Calendar &#1604; SPIP</multi>\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:14:\"auto/gcalendar\";s:7:\"version\";s:5:\"1.0.9\";}s:14:\"COUTEAU_SUISSE\";a:5:{s:3:\"nom\";s:422:\"<multi>Swiss Knife[fr]Le Couteau Suisse[ca]El Ganivet Su&#237;s[ar]&#1587;&#1603;&#1610;&#1606; &#1575;&#1604;&#1580;&#1610;&#1576;[nl]Het Zwitserland Mes[gl]A navalla su&#237;za[es]La Navaja Suiza[de]Schweizer Taschenmesser[tr]&#304;svi&#231;re &#199;ak&#305;s&#305;[br]Ar Gontell Suis[pt_br]Canivete Su&#237;&#231;o[ast]La Navaya Suiza[gl]A navalla su&#237;za[ro]Cu&#355;itul Elve&#355;ian[it]Coltellino Svizzero</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:19:\"auto/couteau_suisse\";s:7:\"version\";s:9:\"1.8.21.01\";}s:6:\"PLAYER\";a:5:{s:3:\"nom\";s:49:\" 
	Lecteur Multim&eacute;dia en Flash (MP3,flv)
	\";s:4:\"etat\";s:3:\"dev\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:23:\"auto/Lecteur_multimedia\";s:7:\"version\";s:4:\"0.73\";}s:10:\"MESABONNES\";a:5:{s:3:\"nom\";s:11:\"Mes abonnes\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:16:\"auto/mes_abonnes\";s:7:\"version\";s:3:\"0.1\";}s:8:\"NOTATION\";a:5:{s:3:\"nom\";s:8:\"Notation\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/notation\";s:7:\"version\";s:5:\"0.7.1\";}s:5:\"NUAGE\";a:5:{s:3:\"nom\";s:5:\"Nuage\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:10:\"auto/nuage\";s:7:\"version\";s:3:\"1.5\";}s:4:\"NYRO\";a:5:{s:3:\"nom\";s:9:\"Nyroceros\";s:4:\"etat\";s:3:\"dev\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:14:\"auto/nyroceros\";s:7:\"version\";s:3:\"0.2\";}s:8:\"RAINETTE\";a:5:{s:3:\"nom\";s:8:\"Rainette\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/rainette\";s:7:\"version\";s:3:\"1.3\";}s:7:\"SAISIES\";a:5:{s:3:\"nom\";s:64:\"<multi>[fr]Saisies pour formulaires[en]Entries for forms</multi>\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:12:\"auto/saisies\";s:7:\"version\";s:5:\"1.7.7\";}s:10:\"SOCIALTAGS\";a:5:{s:3:\"nom\";s:16:\" 
	Social tags
	\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:15:\"auto/socialtags\";s:7:\"version\";s:5:\"0.9.5\";}s:10:\"SPIP_BONUX\";a:5:{s:3:\"nom\";s:10:\"SPIP Bonux\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:15:\"auto/spip-bonux\";s:7:\"version\";s:5:\"2.2.7\";}s:9:\"SARKASPIP\";a:5:{s:3:\"nom\";s:22:\"Squelette Sarka-SPIP 3\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:11:\"sarkaspip_3\";s:7:\"version\";s:5:\"3.0.3\";}s:10:\"THUMBSITES\";a:5:{s:3:\"nom\";s:10:\"Thumbsites\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:15:\"auto/thumbsites\";s:7:\"version\";s:3:\"0.3\";}s:3:\"A2A\";a:5:{s:3:\"nom\";s:3:\"A2A\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:8:\"auto/a2a\";s:7:\"version\";s:3:\"0.3\";}s:14:\"ACCESRESTREINT\";a:5:{s:3:\"nom\";s:97:\"<multi>[fr]Acces Restreint[es]Acceso restringido[en]Restricted Access[de]Zugangskontrolle</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:24:\"auto/acces_restreint_3_0\";s:7:\"version\";s:5:\"3.0.1\";}s:10:\"CLEVERMAIL\";a:5:{s:3:\"nom\";s:24:\"CleverMail pour SPIP 2.0\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:26:\"auto/clevermail_pour_spip2\";s:7:\"version\";s:5:\"2.5.0\";}s:8:\"FANCYBOX\";a:5:{s:3:\"nom\";s:8:\"FancyBox\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/fancybox\";s:7:\"version\";s:3:\"0.5\";}s:7:\"CONTACT\";a:5:{s:3:\"nom\";s:245:\"<multi>[fr]Formulaire de contact avanc&eacute;
	[en]Advanced Contact Form
	[ar]&#1573;&#1587;&#1578;&#1605;&#1575;&#1585;&#1577; &#1575;&#1604;&#1575;&#1578;&#1589;&#1575;&#1604; &#1575;&#1604;&#1605;&#1578;&#1602;&#1583;&#1605;&#1577;
	</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:7:\"contact\";s:7:\"version\";s:4:\"0.62\";}s:12:\"MES_FICHIERS\";a:5:{s:3:\"nom\";s:14:\"Mes fichiers 2\";s:4:\"etat\";s:3:\"dev\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:19:\"auto/mes_fichiers_2\";s:7:\"version\";s:3:\"0.2\";}s:8:\"SAVEAUTO\";a:5:{s:3:\"nom\";s:97:\"<multi>
[fr]Sauvegarde automatique
[it]Salvataggio automatico
[en]Automatic backup
		</multi>\";s:4:\"etat\";s:3:\"dev\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:17:\"auto/saveauto_2_1\";s:7:\"version\";s:5:\"0.7.3\";}s:11:\"COMPRESSEUR\";a:5:{s:3:\"nom\";s:11:\"Compresseur\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:11:\"compresseur\";s:7:\"version\";s:5:\"1.0.1\";}}', 'non', '2010-08-19 12:27:04');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugin_header', 'images(1.0.1),msie_compat(1.0),porte_plume(1.7.2),safehtml(1.3.7),vertebres(1.0),article_pdf(0.2),cfg(1.15.2),typoenluminee(3.1.3),enviar_email(0.2),facteur(1.5.8),forms(0.306),gcalendar(1.0.9),couteau_suisse(1.8.21.01),player(0.73),mesabonnes(0.1),notation(0.7.1),nuage(1.5),nyro(0.2),rainette(1.3),saisies(1.7.7),socialtags(0.9.5),spip_bonux(2.2.7),sarkaspip(3.0.3),thumbsites(0.3),a2a(0.3),accesrestreint(3.0.1),clevermail(2.5.0),fancybox(0.5),contact(0.62),mes_fichiers(0.2),saveauto(0.7.3),compresseur(1.0.1)', 'non', '2010-08-19 12:27:04');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugin_installes', 'a:10:{i:0;s:12:\"auto/facteur\";i:1;s:24:\"auto/forms_et_tables_2_0\";i:2;s:19:\"auto/couteau_suisse\";i:3;s:23:\"auto/Lecteur_multimedia\";i:4;s:16:\"auto/mes_abonnes\";i:5;s:13:\"auto/notation\";i:6;s:8:\"auto/a2a\";i:7;s:24:\"auto/acces_restreint_3_0\";i:8;s:26:\"auto/clevermail_pour_spip2\";i:9;s:17:\"auto/saveauto_2_1\";}', 'non', '2010-08-19 12:27:16');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tour_quota_cache', '11', 'oui', '2011-12-15 21:57:54');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gd_formats_read', 'gif,jpg,png', 'non', '2010-08-16 21:55:41');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gd_formats', 'gif,jpg,png', 'non', '2010-08-16 21:55:41');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('optimiser_table', '6', 'non', '2011-12-15 21:58:24');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('netpbm_formats', '', 'non', '2010-08-16 21:55:41');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('preview', ',0minirezo,1comite,', 'oui', '2010-08-16 21:36:43');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('secret_du_site', '46a81a7b7a8453a3d8f7820aad70846bbaa9a3484af78427ff7d08c3ac04bef6', 'oui', '2010-08-16 21:37:37');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('date_popularites', '1323982714', 'oui', '2011-12-15 21:58:11');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('info_maj_spip', '', 'oui', '2010-08-16 21:39:14');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('syndic_plug', 'a:2:{s:45:\"http://plugins.spip.net/rss-+-selection-2-1-+\";i:106;s:54:\"http://www.spip-contrib.net/?page=rss-plugins-spip-2-1\";i:138;}', 'oui', '2010-08-16 21:40:03');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugins_interessants', 'a:27:{s:8:\"auto/cfg\";i:10;s:34:\"auto/enluminures_typographiques_v3\";i:10;s:14:\"enviar_email_2\";i:10;s:7:\"contact\";i:10;s:15:\"auto/spip-bonux\";i:10;s:11:\"sarkaspip_3\";i:10;s:19:\"auto/couteau_suisse\";i:10;s:8:\"auto/a2a\";i:10;s:24:\"auto/acces_restreint_3_0\";i:10;s:20:\"auto/article_pdf_2_0\";i:10;s:26:\"auto/clevermail_pour_spip2\";i:10;s:12:\"auto/facteur\";i:10;s:13:\"auto/fancybox\";i:10;s:24:\"auto/forms_et_tables_2_0\";i:10;s:14:\"auto/gcalendar\";i:10;s:23:\"auto/Lecteur_multimedia\";i:10;s:16:\"auto/mes_abonnes\";i:10;s:19:\"auto/mes_fichiers_2\";i:10;s:13:\"auto/notation\";i:10;s:10:\"auto/nuage\";i:10;s:14:\"auto/nyroceros\";i:10;s:13:\"auto/rainette\";i:10;s:12:\"auto/saisies\";i:10;s:17:\"auto/saveauto_2_1\";i:10;s:15:\"auto/socialtags\";i:10;s:15:\"auto/thumbsites\";i:10;s:24:\"auto/typographie_avancee\";i:9;}', 'oui', '2010-08-19 12:26:58');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('drapeau_edition', 'a:1:{s:8:\"rubrique\";a:2:{i:10;a:1:{i:1;a:1:{s:8:\"platonas\";i:1282228989;}}i:11;a:1:{i:1;a:1:{s:8:\"platonas\";i:1282229326;}}}}', 'non', '2010-08-19 16:48:46');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_rubrique', '1282229326', 'oui', '2010-08-19 16:48:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif', '1282230251', 'non', '2010-08-19 17:04:12');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_accueil', 'a:1:{s:18:\"rubrique_squelette\";s:1:\"1\";}', 'oui', '2010-08-16 21:48:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_header', 'a:3:{s:11:\"auteur_site\";s:19:\"Jean-Paul BOURILLON\";s:16:\"recurrence_robot\";s:2:\"30\";s:13:\"keywords_site\";s:0:\"\";}', 'oui', '2010-08-16 21:49:37');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_bandeau', 'a:13:{s:4:\"haut\";s:1:\"1\";s:14:\"haut_minheight\";s:3:\"100\";s:11:\"logo_reduit\";s:1:\"1\";s:11:\"taille_logo\";s:3:\"800\";s:10:\"titre_site\";s:1:\"1\";s:6:\"slogan\";s:13:\"Mthode Noro\";s:3:\"bas\";s:1:\"0\";s:13:\"bas_minheight\";s:3:\"100\";s:6:\"chemin\";s:1:\"1\";s:10:\"menu_align\";s:1:\"0\";s:10:\"item_align\";s:4:\"left\";s:12:\"item_largeur\";s:3:\"150\";s:12:\"menu_largeur\";s:3:\"600\";}', 'oui', '2010-08-17 01:26:52');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('formats_graphiques', 'gif,jpg,png', 'non', '2010-08-16 22:00:36');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('image_process', 'convert', 'non', '2010-08-16 22:00:36');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_noisettes', 'a:42:{s:28:\"modele_pagination_navigation\";s:0:\"\";s:25:\"pas_pagination_navigation\";s:2:\"10\";s:24:\"modele_pagination_filtre\";s:0:\"\";s:21:\"pas_pagination_filtre\";s:2:\"10\";s:21:\"position_publications\";s:1:\"0\";s:16:\"max_publications\";s:1:\"5\";s:21:\"position_commentaires\";s:1:\"0\";s:16:\"max_commentaires\";s:1:\"5\";s:17:\"intro_commentaire\";s:3:\"100\";s:17:\"position_messages\";s:1:\"0\";s:12:\"max_messages\";s:1:\"5\";s:13:\"intro_message\";s:3:\"100\";s:12:\"liste_breves\";s:1:\"2\";s:10:\"max_breves\";s:1:\"5\";s:11:\"intro_breve\";s:3:\"100\";s:11:\"liste_sites\";s:1:\"2\";s:9:\"max_sites\";s:1:\"5\";s:10:\"max_syndic\";s:1:\"5\";s:16:\"position_herbier\";s:1:\"1\";s:13:\"liste_herbier\";s:1:\"2\";s:11:\"max_herbier\";s:1:\"5\";s:17:\"position_rechspip\";s:1:\"3\";s:18:\"position_recherche\";s:1:\"2\";s:14:\"moteur_externe\";s:1:\"1\";s:16:\"position_stats_1\";s:1:\"1\";s:16:\"position_stats_2\";s:1:\"2\";s:19:\"composition_stats_2\";s:1:\"1\";s:16:\"max_articles_top\";s:1:\"5\";s:19:\"max_articles_hasard\";s:1:\"5\";s:15:\"position_badges\";s:1:\"0\";s:11:\"badge_xhtml\";N;s:9:\"badge_rss\";N;s:11:\"badge_sarka\";N;s:10:\"badge_spip\";N;s:11:\"badge_perso\";N;s:16:\"lien_badge_perso\";s:7:\"http://\";s:21:\"infobulle_badge_perso\";s:0:\"\";s:16:\"position_annonce\";s:1:\"0\";s:14:\"position_nuage\";s:1:\"2\";s:17:\"position_rainette\";s:1:\"2\";s:14:\"rainette_ville\";s:8:\"BEXX0005\";s:18:\"rainette_prevision\";s:1:\"7\";}', 'oui', '2010-08-19 16:39:04');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_menus', 'a:19:{s:18:\"position_rubriques\";s:1:\"1\";s:16:\"modele_rubriques\";s:1:\"1\";s:16:\"option_rubriques\";s:1:\"2\";s:17:\"position_secteurs\";s:1:\"5\";s:14:\"position_pages\";s:1:\"4\";s:20:\"position_formulaires\";s:1:\"1\";s:9:\"lien_plan\";s:1:\"1\";s:16:\"position_langues\";s:1:\"4\";s:14:\"position_perso\";s:1:\"0\";s:12:\"lien_texte_1\";s:0:\"\";s:10:\"lien_url_1\";s:0:\"\";s:12:\"lien_texte_2\";s:0:\"\";s:10:\"lien_url_2\";s:0:\"\";s:12:\"lien_texte_3\";s:0:\"\";s:10:\"lien_url_3\";s:0:\"\";s:12:\"lien_texte_4\";s:0:\"\";s:10:\"lien_url_4\";s:0:\"\";s:12:\"lien_texte_5\";s:0:\"\";s:10:\"lien_url_5\";s:0:\"\";}', 'oui', '2010-08-19 16:40:31');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_sommaire', 'a:13:{s:13:\"article_edito\";s:1:\"1\";s:11:\"titre_edito\";s:1:\"0\";s:17:\"position_secteurs\";s:1:\"0\";s:25:\"position_articles_recents\";s:1:\"1\";s:20:\"max_articles_recents\";s:1:\"5\";s:13:\"intro_article\";s:3:\"300\";s:15:\"avec_lire_suite\";s:3:\"oui\";s:13:\"logo_rubrique\";s:3:\"oui\";s:11:\"taille_logo\";s:3:\"500\";s:23:\"position_albums_recents\";s:1:\"1\";s:18:\"max_albums_recents\";s:1:\"5\";s:15:\"album_1_colonne\";s:1:\"0\";s:11:\"intro_album\";s:3:\"200\";}', 'oui', '2010-08-17 01:03:16');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('popularite_max', '0.60679230600948', 'oui', '2010-08-17 16:12:18');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_article', '1282217012', 'oui', '2010-08-19 13:23:32');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('popularite_total', '0.606792306010259', 'oui', '2011-12-15 21:58:11');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('date_statistiques', '2011-12-15', 'oui', '2011-12-15 21:58:11');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('saveauto', 'a:12:{s:2:\"gz\";s:5:\"false\";s:9:\"structure\";s:4:\"true\";s:7:\"donnees\";s:4:\"true\";s:13:\"ecrire_succes\";s:4:\"true\";s:4:\"base\";s:12:\"bourillonnet\";s:10:\"jours_obso\";i:15;s:9:\"rep_bases\";s:4:\"tmp/\";s:12:\"prefixe_save\";s:9:\"saveauto_\";s:13:\"frequence_maj\";i:1;s:17:\"destinataire_save\";s:16:\"jp@bourillon.net\";s:6:\"eviter\";s:19:\"_index;_temp;_cache\";s:13:\"mail_max_size\";i:2;}', 'oui', '2010-08-17 02:11:49');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_rubrique', 'a:11:{s:20:\"taille_logo_rubrique\";s:3:\"150\";s:15:\"avec_descriptif\";s:3:\"oui\";s:12:\"mode_galerie\";s:1:\"6\";s:11:\"avec_filles\";s:3:\"oui\";s:17:\"position_articles\";s:1:\"1\";s:13:\"intro_article\";s:3:\"300\";s:15:\"avec_lire_suite\";s:3:\"oui\";s:20:\"taille_logo_articles\";s:3:\"150\";s:17:\"modele_pagination\";s:0:\"\";s:14:\"pas_pagination\";s:1:\"5\";s:19:\"position_pagination\";s:1:\"3\";}', 'oui', '2010-08-19 16:42:08');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('clevermail_base_version', '0.8', 'non', '2010-08-17 02:11:49');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_syndic', '1282001913', 'oui', '2010-08-17 01:38:34');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('notation_base_version', '0.6.1', 'oui', '2010-08-17 02:11:49');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_herbier', 'a:9:{s:5:\"titre\";s:13:\"Sites favoris\";s:10:\"descriptif\";s:0:\"\";s:6:\"modele\";s:5:\"liste\";s:19:\"modele_pagination_1\";s:0:\"\";s:16:\"pas_pagination_1\";s:1:\"5\";s:21:\"position_pagination_1\";s:1:\"3\";s:19:\"modele_pagination_2\";s:0:\"\";s:16:\"pas_pagination_2\";s:2:\"10\";s:21:\"position_pagination_2\";s:1:\"1\";}', 'oui', '2010-08-17 01:40:23');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('bte', 'a:12:{s:5:\"puces\";s:3:\"Oui\";s:14:\"titraille1open\";s:17:\"<h3 class=\"spip\">\";s:15:\"titraille1close\";s:5:\"</h3>\";s:14:\"titraille2open\";s:17:\"<h4 class=\"spip\">\";s:15:\"titraille2close\";s:5:\"</h4>\";s:14:\"titraille3open\";s:17:\"<h5 class=\"spip\">\";s:15:\"titraille3close\";s:5:\"</h5>\";s:14:\"titraille4open\";s:17:\"<h6 class=\"spip\">\";s:15:\"titraille4close\";s:5:\"</h6>\";s:14:\"titraille5open\";s:32:\"<strong class=\"spip titraille5\">\";s:15:\"titraille5close\";s:9:\"</strong>\";s:9:\"insertcss\";s:3:\"Oui\";}', 'oui', '2010-08-17 01:47:44');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_adresse_envoi_nom', '', 'oui', '2010-08-19 16:24:45');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_adresse_envoi_email', '', 'oui', '2010-08-19 16:24:45');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_host', '', 'oui', '2010-08-19 16:24:45');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_port', '25', 'oui', '2010-08-19 16:24:45');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_username', '', 'oui', '2010-08-19 16:24:45');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_password', '', 'oui', '2010-08-19 16:24:45');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_agenda', 'a:13:{s:15:\"rubrique_agenda\";s:2:\"10\";s:5:\"titre\";s:6:\"Agenda\";s:10:\"descriptif\";s:43:\"Agendas des stages de Kinomichi en Belgique\";s:4:\"type\";s:1:\"2\";s:5:\"mois1\";s:1:\"9\";s:17:\"format_pagination\";s:7:\"periode\";s:8:\"sens_tri\";s:6:\"normal\";s:19:\"affichage_hors_mois\";s:3:\"oui\";s:5:\"jour1\";s:1:\"1\";s:11:\"type_resume\";s:3:\"oui\";s:15:\"max_mois_resume\";s:1:\"6\";s:13:\"taille_resume\";s:1:\"5\";s:13:\"format_resume\";s:7:\"d-m H:i\";}', 'oui', '2010-08-19 16:45:53');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_album', 'a:17:{s:13:\"logo_rubrique\";s:3:\"oui\";s:11:\"taille_logo\";s:3:\"150\";s:15:\"avec_popularite\";s:3:\"oui\";s:17:\"position_notation\";s:1:\"0\";s:19:\"position_socialtags\";s:1:\"1\";s:15:\"avec_descriptif\";s:3:\"oui\";s:18:\"position_carrousel\";s:1:\"1\";s:16:\"modele_carrousel\";s:1:\"1\";s:16:\"taille_carrousel\";s:2:\"10\";s:27:\"modele_pagination_carrousel\";s:0:\"\";s:24:\"pas_pagination_carrousel\";s:2:\"20\";s:16:\"survol_carrousel\";s:3:\"non\";s:13:\"afficher_zoom\";s:3:\"oui\";s:12:\"mode_galerie\";s:1:\"5\";s:30:\"modele_pagination_commentaires\";s:0:\"\";s:27:\"pas_pagination_commentaires\";s:2:\"20\";s:32:\"position_pagination_commentaires\";s:1:\"2\";}', 'oui', '2010-08-19 16:47:53');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_galerie', 'a:9:{s:16:\"rubrique_galerie\";s:2:\"11\";s:5:\"titre\";s:7:\"Galerie\";s:10:\"descriptif\";s:17:\"Galerie de photos\";s:15:\"album_1_colonne\";s:1:\"0\";s:11:\"intro_album\";s:3:\"200\";s:19:\"modele_pagination_1\";s:0:\"\";s:16:\"pas_pagination_1\";s:1:\"5\";s:21:\"position_pagination_1\";s:1:\"3\";s:10:\"sens_tri_1\";s:1:\"1\";}', 'oui', '2010-08-19 16:50:28');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_formulaires', 'a:19:{s:14:\"plugin_contact\";s:1:\"1\";s:14:\"auteur_contact\";s:1:\"0\";s:13:\"titre_contact\";s:22:\"Contacter le webmestre\";s:18:\"descriptif_contact\";s:0:\"\";s:16:\"position_extrait\";s:1:\"1\";s:13:\"intro_article\";s:3:\"300\";s:15:\"avec_lire_suite\";s:3:\"oui\";s:21:\"logo_rubrique_extrait\";s:3:\"oui\";s:19:\"taille_logo_extrait\";s:3:\"150\";s:20:\"position_commentaire\";s:1:\"1\";s:12:\"titre_lettre\";s:37:\"S\'inscrire  la lettre d\'information\";s:17:\"descriptif_lettre\";s:0:\"\";s:17:\"titre_inscription\";s:22:\"S\'inscrire sur le site\";s:22:\"descriptif_inscription\";s:0:\"\";s:24:\"descriptif_referencement\";s:0:\"\";s:12:\"titre_login1\";s:33:\"Se connecter comme membre du site\";s:17:\"descriptif_login1\";s:0:\"\";s:12:\"titre_login2\";s:27:\"Accder  l\'espace priv\";s:17:\"descriptif_login2\";s:0:\"\";}', 'oui', '2010-08-19 16:55:33');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_modeles', 'a:3:{s:16:\"mode_galerie_img\";s:1:\"5\";s:12:\"exclusif_img\";s:3:\"oui\";s:12:\"exclusif_doc\";s:3:\"oui\";}', 'oui', '2010-08-19 16:58:51');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gcalendar', 'a:3:{s:6:\"agenda\";s:27:\"jp.bourillon@googlemail.com\";s:4:\"nbev\";s:2:\"10\";s:13:\"affich_agenda\";s:3:\"oui\";}', 'oui', '2010-08-19 17:01:27');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('thumbsites', 'a:7:{s:7:\"serveur\";s:10:\"thumbshots\";s:18:\"girafa_identifiant\";s:0:\"\";s:16:\"girafa_signature\";s:0:\"\";s:13:\"websnapr_clef\";s:0:\"\";s:15:\"websnapr_taille\";s:1:\"T\";s:16:\"robothumb_taille\";s:6:\"100x75\";s:12:\"miwin_taille\";s:5:\"80X60\";}', 'oui', '2010-08-19 17:04:12');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('a2a_base_version', '0.3', 'oui', '2010-08-17 01:50:53');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('accesrestreint_base_version', '0.3.0.2', 'oui', '2010-08-17 01:50:53');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp', 'non', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_auth', 'non', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_secure', 'non', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_sender', '', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_filtre_images', '1', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_filtre_css', '1', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_filtre_iso_8859', '1', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_adresse_envoi', 'non', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_base_version', '1.1', 'oui', '2010-08-17 02:11:47');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forms_base_version', '0.41', 'oui', '2010-08-17 02:11:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forms_et_tables', 'a:3:{s:25:\"associer_donnees_articles\";i:0;s:26:\"associer_donnees_rubriques\";i:0;s:24:\"associer_donnees_auteurs\";i:0;}', 'oui', '2010-08-17 02:11:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('player_preferences', 'a:1:{s:12:\"date_install\";s:19:\"2010-08-17_02:11:48\";}', 'oui', '2010-08-17 02:11:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('mesabonnes_base_version', '0.1', 'oui', '2010-08-17 02:11:49');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_actifs', 'a:33:{s:11:\"set_options\";a:1:{s:5:\"actif\";i:0;}s:12:\"suivi_forums\";a:1:{s:5:\"actif\";i:0;}s:10:\"webmestres\";a:1:{s:5:\"actif\";i:1;}s:4:\"spam\";a:1:{s:5:\"actif\";i:1;}s:8:\"maj_auto\";a:1:{s:5:\"actif\";i:1;}s:18:\"moderation_moderee\";a:1:{s:5:\"actif\";i:1;}s:12:\"paragrapher2\";a:1:{s:5:\"actif\";i:1;}s:12:\"auteur_forum\";a:1:{s:5:\"actif\";i:1;}s:14:\"boites_privees\";a:1:{s:5:\"actif\";i:1;}s:13:\"meme_rubrique\";a:1:{s:5:\"actif\";i:1;}s:7:\"auteurs\";a:1:{s:5:\"actif\";i:1;}s:16:\"previsualisation\";a:1:{s:5:\"actif\";i:1;}s:8:\"brouteur\";a:1:{s:5:\"actif\";i:1;}s:7:\"pucesli\";a:1:{s:5:\"actif\";i:1;}s:10:\"insertions\";a:1:{s:5:\"actif\";i:1;}s:14:\"typo_exposants\";a:1:{s:5:\"actif\";i:1;}s:9:\"glossaire\";a:1:{s:5:\"actif\";i:1;}s:10:\"guillemets\";a:1:{s:5:\"actif\";i:1;}s:9:\"mailcrypt\";a:1:{s:5:\"actif\";i:1;}s:7:\"smileys\";a:1:{s:5:\"actif\";i:1;}s:5:\"blocs\";a:1:{s:5:\"actif\";i:1;}s:9:\"toutmulti\";a:1:{s:5:\"actif\";i:1;}s:7:\"chatons\";a:1:{s:5:\"actif\";i:1;}s:10:\"decoration\";a:1:{s:5:\"actif\";i:1;}s:7:\"decoupe\";a:1:{s:5:\"actif\";i:1;}s:10:\"filets_sep\";a:1:{s:5:\"actif\";i:1;}s:8:\"couleurs\";a:1:{s:5:\"actif\";i:1;}s:13:\"soft_scroller\";a:1:{s:5:\"actif\";i:1;}s:7:\"horloge\";a:1:{s:5:\"actif\";i:1;}s:11:\"orientation\";a:1:{s:5:\"actif\";i:1;}s:15:\"trousse_balises\";a:1:{s:5:\"actif\";i:1;}s:9:\"verstexte\";a:1:{s:5:\"actif\";i:1;}s:15:\"liens_orphelins\";a:1:{s:5:\"actif\";i:1;}}', 'oui', '2010-08-19 13:03:07');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('saveauto_base_version', '0.1.0', 'oui', '2010-08-17 02:11:49');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('saveauto_creation', '1282481583', 'oui', '2010-08-22 14:53:12');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_plugins', 'a:2:{s:16:\"config_nyroceros\";s:9:\"sarkaspip\";s:17:\"config_socialtags\";s:9:\"sarkaspip\";}', 'oui', '2010-08-17 02:13:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('nyroceros', 'a:4:{s:21:\"traiter_toutes_images\";s:3:\"non\";s:16:\"selecteur_commun\";s:10:\".nyroceros\";s:17:\"selecteur_galerie\";s:19:\".galerie .nyroceros\";s:20:\"installer_diapo_auto\";s:3:\"non\";}', 'oui', '2010-08-17 02:13:48');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('socialtags', 'a:5:{s:10:\"jsselector\";s:11:\"#socialtags\";s:4:\"tags\";a:8:{i:0;s:0:\"\";i:1;s:8:\"bookmark\";i:2;s:9:\"delicious\";i:3;s:8:\"facebook\";i:4;s:6:\"google\";i:5;s:4:\"live\";i:6;s:7:\"twitter\";i:7;s:10:\"yahoomyweb\";}s:5:\"badge\";s:0:\"\";s:7:\"badgejs\";s:0:\"\";s:9:\"ifreferer\";N;}', 'oui', '2010-08-19 17:03:52');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_coins', 'a:15:{s:13:\"avec_arrondis\";s:1:\"1\";s:14:\"modele_bandeau\";s:1:\"4\";s:14:\"taille_bandeau\";s:2:\"10\";s:11:\"modele_pied\";s:1:\"2\";s:11:\"taille_pied\";s:2:\"10\";s:10:\"modele_nav\";s:1:\"1\";s:16:\"taille_nav_cadre\";s:2:\"10\";s:16:\"modele_recherche\";s:1:\"1\";s:16:\"taille_recherche\";s:2:\"10\";s:15:\"modele_noisette\";s:1:\"4\";s:15:\"taille_noisette\";s:2:\"10\";s:12:\"modele_edito\";s:1:\"1\";s:12:\"taille_edito\";s:2:\"10\";s:14:\"modele_extrait\";s:1:\"1\";s:14:\"taille_extrait\";s:2:\"10\";}', 'oui', '2010-08-17 02:18:42');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_variables', 'a:35:{s:8:\"_chaines\";a:49:{i:0;s:18:\"dossier_squelettes\";i:1;s:10:\"webmestres\";i:2;s:18:\"suite_introduction\";i:3;s:18:\"radio_set_options4\";i:4;s:11:\"mot_masquer\";i:5;s:19:\"radio_suivi_forums3\";i:6;s:9:\"spam_mots\";i:7;s:8:\"spam_ips\";i:8;s:15:\"message_travaux\";i:9;s:22:\"url_glossaire_externe2\";i:10;s:17:\"decoration_styles\";i:11;s:14:\"couleurs_perso\";i:12;s:17:\"glossaire_groupes\";i:13;s:15:\"jcorner_classes\";i:14;s:10:\"insertions\";i:15;s:12:\"tri_articles\";i:16;s:9:\"tri_perso\";i:17;s:11:\"tri_groupes\";i:18;s:17:\"tri_perso_groupes\";i:19;s:10:\"spip_ecran\";i:20;s:7:\"bloc_h4\";i:21;s:11:\"blocs_slide\";i:22;s:7:\"style_p\";i:23;s:7:\"style_h\";i:24;s:7:\"racc_hr\";i:25;s:7:\"racc_h1\";i:26;s:7:\"racc_h2\";i:27;s:7:\"racc_i1\";i:28;s:7:\"racc_i2\";i:29;s:7:\"racc_g1\";i:30;s:7:\"racc_g2\";i:31;s:9:\"ouvre_ref\";i:32;s:9:\"ferme_ref\";i:33;s:10:\"ouvre_note\";i:34;s:10:\"ferme_note\";i:35;s:4:\"puce\";i:36;s:16:\"radio_type_urls3\";i:37;s:11:\"spip_script\";i:38;s:21:\"terminaison_urls_page\";i:39;s:20:\"separateur_urls_page\";i:40;s:15:\"url_arbo_sep_id\";i:41;s:21:\"terminaison_urls_arbo\";i:42;s:24:\"terminaison_urls_propres\";i:43;s:18:\"debut_urls_propres\";i:44;s:19:\"debut_urls_propres2\";i:45;s:23:\"terminaison_urls_libres\";i:46;s:17:\"debut_urls_libres\";i:47;s:27:\"terminaison_urls_propres_qs\";i:48;s:18:\"urls_id_sauf_liste\";}s:8:\"_nombres\";a:93:{i:0;s:11:\"paragrapher\";i:1;s:16:\"lgr_introduction\";i:2;s:17:\"lien_introduction\";i:3;s:25:\"radio_filtrer_javascript3\";i:4;s:13:\"forum_lgrmaxi\";i:5;s:9:\"logo_Hmax\";i:6;s:9:\"logo_Wmax\";i:7;s:9:\"logo_Smax\";i:8;s:8:\"img_Hmax\";i:9;s:8:\"img_Wmax\";i:10;s:8:\"img_Smax\";i:11;s:8:\"doc_Smax\";i:12;s:9:\"img_GDmax\";i:13;s:10:\"img_GDqual\";i:14;s:10:\"copie_Smax\";i:15;s:16:\"auteur_forum_nom\";i:16;s:18:\"auteur_forum_email\";i:17;s:17:\"auteur_forum_deux\";i:18;s:18:\"log_couteau_suisse\";i:19;s:15:\"spip_options_on\";i:20;s:11:\"distant_off\";i:21;s:18:\"distant_outils_off\";i:22;s:13:\"prive_travaux\";i:23;s:13:\"admin_travaux\";i:24;s:15:\"avertir_travaux\";i:25;s:13:\"titre_travaux\";i:26;s:14:\"bp_tri_auteurs\";i:27;s:15:\"bp_urls_propres\";i:28;s:6:\"cs_rss\";i:29;s:11:\"format_spip\";i:30;s:12:\"stat_auteurs\";i:31;s:14:\"qui_webmasters\";i:32;s:16:\"max_auteurs_page\";i:33;s:9:\"auteurs_0\";i:34;s:9:\"auteurs_1\";i:35;s:9:\"auteurs_5\";i:36;s:9:\"auteurs_6\";i:37;s:9:\"auteurs_n\";i:38;s:17:\"auteurs_tout_voir\";i:39;s:14:\"balise_decoupe\";i:40;s:13:\"prof_sommaire\";i:41;s:12:\"lgr_sommaire\";i:42;s:13:\"auto_sommaire\";i:43;s:13:\"jolies_ancres\";i:44;s:15:\"balise_sommaire\";i:45;s:9:\"i_padding\";i:46;s:9:\"i_hauteur\";i:47;s:9:\"i_largeur\";i:48;s:8:\"i_taille\";i:49;s:19:\"radio_target_blank3\";i:50;s:15:\"enveloppe_mails\";i:51;s:8:\"puceSPIP\";i:52;s:14:\"couleurs_fonds\";i:53;s:12:\"set_couleurs\";i:54;s:11:\"expo_bofbof\";i:55;s:19:\"liens_interrogation\";i:56;s:15:\"liens_orphelins\";i:57;s:16:\"glossaire_limite\";i:58;s:12:\"glossaire_js\";i:59;s:8:\"scrollTo\";i:60;s:11:\"LocalScroll\";i:61;s:14:\"jcorner_plugin\";i:62;s:16:\"moderation_admin\";i:63;s:16:\"moderation_redac\";i:64;s:16:\"moderation_visit\";i:65;s:14:\"titres_etendus\";i:66;s:18:\"arret_optimisation\";i:67;s:17:\"rubrique_brouteur\";i:68;s:13:\"meme_rubrique\";i:69;s:11:\"bloc_unique\";i:70;s:12:\"blocs_cookie\";i:71;s:14:\"blocs_millisec\";i:72;s:22:\"radio_desactive_cache3\";i:73;s:22:\"radio_desactive_cache4\";i:74;s:11:\"duree_cache\";i:75;s:16:\"duree_cache_mutu\";i:76;s:11:\"quota_cache\";i:77;s:23:\"derniere_modif_invalide\";i:78;s:19:\"url_arbo_minuscules\";i:79;s:19:\"urls_arbo_sans_type\";i:80;s:12:\"url_max_arbo\";i:81;s:15:\"url_max_propres\";i:82;s:22:\"marqueurs_urls_propres\";i:83;s:16:\"url_max_propres2\";i:84;s:23:\"marqueurs_urls_propres2\";i:85;s:14:\"url_max_libres\";i:86;s:18:\"url_max_propres_qs\";i:87;s:25:\"marqueurs_urls_propres_qs\";i:88;s:15:\"urls_minuscules\";i:89;s:12:\"urls_avec_id\";i:90;s:13:\"urls_avec_id2\";i:91;s:18:\"urls_id_3_chiffres\";i:92;s:22:\"urls_id_sauf_rubriques\";}s:9:\"spam_mots\";s:131:\"sucking blowjob superbabe ejakulation fucking (asses) pipe chate couilles bite fion pine encule enculer foutre pute hardcore viagra\";s:8:\"spam_ips\";s:0:\"\";s:11:\"paragrapher\";i:1;s:16:\"auteur_forum_nom\";i:1;s:18:\"auteur_forum_email\";i:1;s:17:\"auteur_forum_deux\";i:0;s:16:\"max_auteurs_page\";i:30;s:17:\"auteurs_tout_voir\";i:1;s:9:\"auteurs_0\";i:1;s:9:\"auteurs_1\";i:1;s:9:\"auteurs_5\";i:1;s:9:\"auteurs_6\";i:0;s:9:\"auteurs_n\";i:0;s:8:\"puceSPIP\";i:1;s:11:\"expo_bofbof\";i:1;s:17:\"glossaire_groupes\";s:9:\"Glossaire\";s:16:\"glossaire_limite\";i:3;s:12:\"glossaire_js\";i:1;s:11:\"bloc_unique\";i:1;s:12:\"blocs_cookie\";i:1;s:7:\"bloc_h4\";s:2:\"h5\";s:11:\"blocs_slide\";s:6:\"normal\";s:14:\"blocs_millisec\";i:100;s:16:\"pp_edition_blocs\";s:1:\"1\";s:14:\"pp_forum_blocs\";s:1:\"1\";s:18:\"pp_edition_chatons\";s:1:\"1\";s:16:\"pp_forum_chatons\";s:1:\"1\";s:17:\"decoration_styles\";s:330:\"span.sc = font-variant:small-caps;
span.souligne = text-decoration:underline;
span.barre = text-decoration:line-through;
span.dessus = text-decoration:overline;
span.clignote = text-decoration:blink;
span.surfluo = background-color:#ffff00; padding:0px 2px;
span.surgris = background-color:#EAEAEC; padding:0px 2px;
fluo = surfluo\";s:21:\"pp_edition_decoration\";s:1:\"1\";s:19:\"pp_forum_decoration\";s:1:\"1\";s:14:\"balise_decoupe\";i:1;s:18:\"pp_edition_decoupe\";s:1:\"1\";s:16:\"pp_forum_decoupe\";s:1:\"1\";}', 'oui', '2010-08-19 13:03:14');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_pipelines', 'a:19:{s:6:\"header\";s:5609:\"<script type=\"text/javascript\"><!--
var cs_prive=window.location.pathname.match(/\\/ecrire\\/$/)!=null;
jQuery.fn.cs_todo=function(){return this.not(\'.cs_done\').addClass(\'cs_done\');};
var cs_verif_email = 1;
var cs_verif_nom = 1;
var cs_verif_deux = 0;
function lancerlien(a,b){ x=\'ma\'+\'ilto\'+\':\'+a+\'@\'+b; return x; }
function soft_scroller_init() { if(typeof jQuery.localScroll==\"function\") jQuery.localScroll({hash: true}); }
var blocs_replier_tout = 1;
var blocs_millisec = 100;
var blocs_slide = \'normal\';
var blocs_title_sep = /\\|\\|/g;
var blocs_title_def = \'D\\u00e9plier||Replier\';

// compatibilite Ajax : ajouter \"this\" a \"jQuery\" pour mieux localiser les actions 
// et tagger avec cs_done pour eviter de binder plrs fois le meme bloc
function cs_auteur_forum() {
	// selecteur du bloc de previsualisation
	var sel = jQuery(\'fieldset.previsu\', this);
	if(!sel.length) return;
//	alert(\'previsu OK\');
	var form = sel.parents(\'form\').eq(0);
	if(!form.length) return;
	// SPIP 2.0 remplace \'auteur\' par \'session_nom\'
	var auteur = jQuery(\'#session_nom\', this);
	if(!auteur.length) auteur = jQuery(\'#auteur\', this);
	// SPIP 2.0 remplace \'email_auteur\' par \'session_email\'
	var email = jQuery(\'#session_email\', this);
	if(!email.length) email = jQuery(\'#email_auteur\', this);
	if(auteur.length || email.length)
	// eviter les forums anonymes
	form.cs_todo().bind(\'submit\', function(event){
		var alert_nom = auteur.length && !auteur.val().length;
		var alert_email = email.length && !email.val().length;
		var alert_deux = cs_verif_deux && alert_nom && alert_email;
		if(!cs_verif_deux) {
			alert_nom = alert_nom && cs_verif_nom;
			alert_email = alert_email && cs_verif_email;
		} else if(!alert_deux)
			alert_nom = alert_email = false;
		auteur.css(\'background-color\',\'\').css(\'border\',\'\');
		email.css(\'background-color\',\'\').css(\'border\',\'\');
		if(alert_email) {
			email.focus();
			email.css(\'background-color\',\'#FCC\').css(\'border\',\'solid #C30\');
		}
		if(alert_nom) {
			auteur.focus();
			auteur.css(\'background-color\',\'#FCC\').css(\'border\',\'solid #C30\');
		}
		if(alert_deux) {
			alert(\"Merci de sp\\u00e9cifier votre nom ou votre email !\");
			return false;
		}
		if(alert_nom) {
			alert(\"Merci de sp\\u00e9cifier votre nom !\");
			return false;
		}
		if(alert_email) {
			alert(\"Merci de sp\\u00e9cifier votre email !\");
			return false;
		}
		return true;
	});
}

var cs_init = function() {
	cs_auteur_forum.apply(this);
	onglets_init.apply(this);
	glossaire_init.apply(this);
	jQuery(\'span.spancrypt\', this).attr(\'class\',\'cryptOK\').html(\'&#6\'+\'4;\');
	jQuery(\"a[\"+cs_sel_jQuery+\"title*=\'..\']\", this).each(function () {
		this.title = this.title.replace(/\\.\\..t\\.\\./,\'[@]\');
	});
	soft_scroller_init.apply(this);
	if(window.location.search.match(/page=forum/)!=null) jQuery(\"legend:contains(\'modration  priori\')\", this).next().html(\'Ce forum est mod&eacute;r&eacute; &agrave; priori&nbsp;: votre contribution n\\\'appara&icirc;tra qu\\\'apr&egrave;s avoir &eacute;t&eacute; valid&eacute;e par un administrateur du site, sauf si vous &ecirc;tes identifi&eacute; et autoris&eacute; &agrave; poster directement.\');
	jclock_init.apply(this);
	blocs_init.apply(this);
}
if(typeof onAjaxLoad==\'function\') onAjaxLoad(cs_init);
if(window.jQuery) {
var cs_sel_jQuery=typeof jQuery(document).selector==\'undefined\'?\'@\':\'\';
var cs_CookiePlugin=\"http://kinomichi.bourillon.net/prive/javascript/jquery.cookie.js\";
jQuery(document).ready(function(){
	/* optimisation : \'IF(1)\' */ if(jQuery(\"div.cs_blocs\").length)
		jQuery.getScript(cs_CookiePlugin, cs_blocs_cookie); 
	cs_init.apply(document);
});
}
// --></script>

<style type=\"text/css\">
div.pagination {display:block; text-align:center; }
div.pagination img { border:0pt none; margin:0pt; padding:0pt; }
span.cs_pagination_off {color: lightgrey; font-weight: bold; text-decoration: underline;} 
sup.typo_exposants { font-size:75%; font-variant:normal; vertical-align:super; }
table.cs_smileys td {text-align:center; font-size:90%; font-weight:bold;}
a.cs_glossaire:after {display:none;}
span.spancrypt {background:transparent url(http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/img/mailcrypt/leure.gif) no-repeat scroll 0.1em center; padding-left:12px; text-decoration:none;}
.blocs_titre {
	background:transparent url(http://kinomichi.bourillon.net/prive/images/triangle-bas.gif) no-repeat scroll left center;
	font-weight:normal;
	line-height:1.2em;
	margin-top:4px;
	padding:0pt 0pt 0pt 20px;
	margin-bottom:0.1em;
	clear:left;
	cursor:pointer;
}

.blocs_replie {
	background:transparent url(http://kinomichi.bourillon.net/prive/images/triangle.gif) no-repeat scroll left center;
}

.blocs_title{
	display:none;
}
</style>
<link rel=\"stylesheet\" href=\"http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/outils/decoupe.css\" type=\"text/css\" media=\"projection, screen\" />
<script type=\"text/javascript\" src=\"http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/outils/decoupe.js\"></script>
<link rel=\"stylesheet\" href=\"http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/outils/filets_sep.css\" type=\"text/css\" media=\"projection, screen\" />
<link rel=\"stylesheet\" href=\"http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/outils/glossaire.css\" type=\"text/css\" media=\"projection, screen\" />
<script type=\"text/javascript\" src=\"http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/outils/glossaire.js\"></script>
<script type=\"text/javascript\" src=\"http://kinomichi.bourillon.net/plugins/auto/couteau_suisse/outils/blocs.js\"></script>\";s:21:\"pre_description_outil\";s:1376:\"
# Copie du code utilise en eval() pour le pipeline \'pre_description_outil($flux)\'
include_spip(\'outils/sommaire\');
include_spip(\'outils/couleurs\');
if($id==\"webmestres\")
		$texte=str_replace(array(\"@_CS_LISTE_WEBMESTRES@\",\"@_CS_LISTE_ADMINS@\"),get_liste_administrateurs(),$texte);
if($id==\"auteur_forum\") $texte=str_replace(array(\"@_CS_FORUM_NOM@\",\"@_CS_FORUM_EMAIL@\"),
	array(preg_replace(\',:$,\',\"\",_T(\"forum_votre_nom\")),preg_replace(\',:$,\',\"\",_T(\"forum_votre_email\"))),$texte);
if($id==\"cs_comportement\"){$tmp=(!0||!$flux[\"actif\"]||defined(\"_CS_SPIP_OPTIONS_OK\"))?\"\":\"<span style=\\\"color:red\\\">\"._T(\"couteauprive:cs_spip_options_erreur\").\"</span>\";
$texte=str_replace(array(\"@_CS_FILE_OPTIONS_ERR@\",\"@_CS_DIR_TMP@\",\"@_CS_FILE_OPTIONS@\"),
	array($tmp,cs_canonicalize(_DIR_RESTREINT_ABS._DIR_TMP),show_file_options()),$texte);
}
if($id==\"en_travaux\") $texte=str_replace(array(\"@_CS_TRAVAUX_TITRE@\",\"@_CS_NOM_SITE@\"),
	array(\"[\"._T(\"info_travaux_titre\").\"]\",\"[\".$GLOBALS[\"meta\"][\"nom_site\"].\"]\"),$texte);
if($id==\"titres_typo\")
		$texte=str_replace(\"@_CS_FONTS@\",join(\" - \",get_liste_fonts()),$texte);
function_exists(\'sommaire_description_outil\')?$flux=sommaire_description_outil($flux):cs_deferr(\'sommaire_description_outil\');
function_exists(\'couleurs_pre_description_outil\')?$flux=couleurs_pre_description_outil($flux):cs_deferr(\'couleurs_pre_description_outil\');
\";s:10:\"pre_boucle\";s:263:\"
# Copie du code utilise en eval() pour le pipeline \'pre_boucle($flux)\'
include_spip(\'lib/previsualisation/distant_previsu_redac_pipelines\');
function_exists(\'previsu_redac_pre_boucle\')?$flux=previsu_redac_pre_boucle($flux):cs_deferr(\'previsu_redac_pre_boucle\');
\";s:11:\"boite_infos\";s:267:\"
# Copie du code utilise en eval() pour le pipeline \'boite_infos($flux)\'
include_spip(\'lib/previsualisation/distant_previsu_redac_pipelines\');
function_exists(\'previsu_redac_boite_infos\')?$flux=previsu_redac_boite_infos($flux):cs_deferr(\'previsu_redac_boite_infos\');
\";s:14:\"affiche_milieu\";s:251:\"
# Copie du code utilise en eval() pour le pipeline \'affiche_milieu($flux)\'
include_spip(\'outils/boites_privees\');
function_exists(\'boites_privees_affiche_milieu\')?$flux=boites_privees_affiche_milieu($flux):cs_deferr(\'boites_privees_affiche_milieu\');
\";s:14:\"affiche_droite\";s:251:\"
# Copie du code utilise en eval() pour le pipeline \'affiche_droite($flux)\'
include_spip(\'outils/boites_privees\');
function_exists(\'boites_privees_affiche_droite\')?$flux=boites_privees_affiche_droite($flux):cs_deferr(\'boites_privees_affiche_droite\');
\";s:14:\"affiche_gauche\";s:251:\"
# Copie du code utilise en eval() pour le pipeline \'affiche_gauche($flux)\'
include_spip(\'outils/boites_privees\');
function_exists(\'boites_privees_affiche_gauche\')?$flux=boites_privees_affiche_gauche($flux):cs_deferr(\'boites_privees_affiche_gauche\');
\";s:24:\"nettoyer_raccourcis_typo\";s:464:\"
# Copie du code utilise en eval() pour le pipeline \'nettoyer_raccourcis_typo($flux)\'
include_spip(\'outils/decoupe\');
include_spip(\'outils/couleurs\');
$flux=str_replace(_CS_SANS_GLOSSAIRE, \"\", $flux);
function_exists(\'decoupe_nettoyer_raccourcis\')?$flux=decoupe_nettoyer_raccourcis($flux):cs_deferr(\'decoupe_nettoyer_raccourcis\');
function_exists(\'couleurs_nettoyer_raccourcis\')?$flux=couleurs_nettoyer_raccourcis($flux):cs_deferr(\'couleurs_nettoyer_raccourcis\');
\";s:26:\"porte_plume_cs_pre_charger\";s:374:\"
# Copie du code utilise en eval() pour le pipeline \'porte_plume_cs_pre_charger($flux)\'
include_spip(\'outils/decoupe\');
include_spip(\'outils/blocs\');
function_exists(\'decoupe_CS_pre_charger\')?$flux=decoupe_CS_pre_charger($flux):cs_deferr(\'decoupe_CS_pre_charger\');
function_exists(\'blocs_CS_pre_charger\')?$flux=blocs_CS_pre_charger($flux):cs_deferr(\'blocs_CS_pre_charger\');
\";s:34:\"porte_plume_lien_classe_vers_icone\";s:1037:\"
# Copie du code utilise en eval() pour le pipeline \'porte_plume_lien_classe_vers_icone($flux)\'
include_spip(\'outils/decoupe\');
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
include_spip(\'outils/blocs\');
function_exists(\'decoupe_PP_icones\')?$flux=decoupe_PP_icones($flux):cs_deferr(\'decoupe_PP_icones\');
function_exists(\'decoration_PP_icones\')?$flux=decoration_PP_icones($flux):cs_deferr(\'decoration_PP_icones\');
function_exists(\'couleurs_PP_icones\')?$flux=couleurs_PP_icones($flux):cs_deferr(\'couleurs_PP_icones\');
function_exists(\'filets_PP_icones\')?$flux=filets_PP_icones($flux):cs_deferr(\'filets_PP_icones\');
function_exists(\'cs_smileys_PP_icones\')?$flux=cs_smileys_PP_icones($flux):cs_deferr(\'cs_smileys_PP_icones\');
function_exists(\'chatons_PP_icones\')?$flux=chatons_PP_icones($flux):cs_deferr(\'chatons_PP_icones\');
function_exists(\'blocs_PP_icones\')?$flux=blocs_PP_icones($flux):cs_deferr(\'blocs_PP_icones\');
\";s:8:\"pre_typo\";s:1240:\"
# Copie du code utilise en eval() pour le pipeline \'pre_typo($flux)\'
include_spip(\'outils/toutmulti\');
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/liens_orphelins\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
include_spip(\'outils/blocs\');
if(strpos($flux, \"-\")!==false OR strpos($flux, \"*\")!==false) $flux = cs_echappe_balises(\"\", \"pucesli_remplace\", $flux);
function_exists(\'ToutMulti_pre_typo\')?$flux=ToutMulti_pre_typo($flux):cs_deferr(\'ToutMulti_pre_typo\');
function_exists(\'decoration_pre_typo\')?$flux=decoration_pre_typo($flux):cs_deferr(\'decoration_pre_typo\');
function_exists(\'couleurs_pre_typo\')?$flux=couleurs_pre_typo($flux):cs_deferr(\'couleurs_pre_typo\');
function_exists(\'interro_pre_typo\')?$flux=interro_pre_typo($flux):cs_deferr(\'interro_pre_typo\');
function_exists(\'filets_sep\')?$flux=filets_sep($flux):cs_deferr(\'filets_sep\');
function_exists(\'cs_smileys_pre_typo\')?$flux=cs_smileys_pre_typo($flux):cs_deferr(\'cs_smileys_pre_typo\');
function_exists(\'chatons_pre_typo\')?$flux=chatons_pre_typo($flux):cs_deferr(\'chatons_pre_typo\');
function_exists(\'blocs_pre_typo\')?$flux=blocs_pre_typo($flux):cs_deferr(\'blocs_pre_typo\');
\";s:10:\"bt_toolbox\";s:769:\"
# Copie du code utilise en eval() pour le pipeline \'bt_toolbox($flux)\'
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
function_exists(\'decoration_BarreTypo\')?$flux=decoration_BarreTypo($flux):cs_deferr(\'decoration_BarreTypo\');
function_exists(\'couleurs_BarreTypo\')?$flux=couleurs_BarreTypo($flux):cs_deferr(\'couleurs_BarreTypo\');
function_exists(\'filets_sep_BarreTypo\')?$flux=filets_sep_BarreTypo($flux):cs_deferr(\'filets_sep_BarreTypo\');
function_exists(\'cs_smileys_BarreTypo\')?$flux=cs_smileys_BarreTypo($flux):cs_deferr(\'cs_smileys_BarreTypo\');
function_exists(\'chatons_BarreTypo\')?$flux=chatons_BarreTypo($flux):cs_deferr(\'chatons_BarreTypo\');
\";s:29:\"porte_plume_barre_pre_charger\";s:851:\"
# Copie du code utilise en eval() pour le pipeline \'porte_plume_barre_pre_charger($flux)\'
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
function_exists(\'decoration_PP_pre_charger\')?$flux=decoration_PP_pre_charger($flux):cs_deferr(\'decoration_PP_pre_charger\');
function_exists(\'couleurs_PP_pre_charger\')?$flux=couleurs_PP_pre_charger($flux):cs_deferr(\'couleurs_PP_pre_charger\');
function_exists(\'filets_PP_pre_charger\')?$flux=filets_PP_pre_charger($flux):cs_deferr(\'filets_PP_pre_charger\');
function_exists(\'cs_smileys_PP_pre_charger\')?$flux=cs_smileys_PP_pre_charger($flux):cs_deferr(\'cs_smileys_PP_pre_charger\');
function_exists(\'chatons_PP_pre_charger\')?$flux=chatons_PP_pre_charger($flux):cs_deferr(\'chatons_PP_pre_charger\');
\";s:9:\"post_typo\";s:330:\"
# Copie du code utilise en eval() pour le pipeline \'post_typo($flux)\'
include_spip(\'outils/typo_exposants\');
include_spip(\'outils/guillemets\');
function_exists(\'typo_exposants\')?$flux=typo_exposants($flux):cs_deferr(\'typo_exposants\');
function_exists(\'typo_guillemets\')?$flux=typo_guillemets($flux):cs_deferr(\'typo_guillemets\');
\";s:10:\"pre_propre\";s:233:\"
# Copie du code utilise en eval() pour le pipeline \'pre_propre($flux)\'
include_spip(\'outils/liens_orphelins\');
function_exists(\'liens_orphelins_pipeline\')?$flux=liens_orphelins_pipeline($flux):cs_deferr(\'liens_orphelins_pipeline\');
\";s:11:\"post_propre\";s:300:\"
# Copie du code utilise en eval() pour le pipeline \'post_propre($flux)\'
include_spip(\'outils/liens_orphelins\');
if(strpos($flux, \'@\')!==false) $flux=cs_echappe_balises(\'\', \'mailcrypt\', $flux);
function_exists(\'interro_post_propre\')?$flux=interro_post_propre($flux):cs_deferr(\'interro_post_propre\');
\";s:11:\"insert_head\";s:575:\"
# Copie du code utilise en eval() pour le pipeline \'insert_head($flux)\'
/* optimisation : \'IF(1)\' */ $flux.=\'<script src=\"\'.find_in_path(\"outils/jquery.scrollto.js\").\'\" type=\"text/javascript\"></script>\'.\"\\n\";
/* optimisation : \'IF(1)\' */ $flux.=\'<script src=\"\'.find_in_path(\"outils/jquery.localscroll.js\").\'\" type=\"text/javascript\"></script>\'.\"\\n\";
$flux.=\'<script type=\"text/javascript\" src=\"\'.generer_url_public(\'cout_dates.js\',\'lang=\'.$GLOBALS[\'spip_lang\']).\'\"></script>
<script type=\"text/javascript\" src=\"\'.find_in_path(\"outils/jquery.jclock.js\").\'\"></script>\'.\"\\n\";
\";s:11:\"pre_edition\";s:207:\"
# Copie du code utilise en eval() pour le pipeline \'pre_edition($flux)\'
include_spip(\'outils/moderation_moderee\');
function_exists(\'moderation_vip\')?$flux=moderation_vip($flux):cs_deferr(\'moderation_vip\');
\";s:12:\"header_prive\";s:298:\"
# Copie du code utilise en eval() pour le pipeline \'header_prive($flux)\'
$flux.=\'<script type=\"text/javascript\" src=\"\'.generer_url_public(\'cout_dates.js\',\'lang=\'.$GLOBALS[\'spip_lang\']).\'\"></script>
<script type=\"text/javascript\" src=\"\'.find_in_path(\"outils/jquery.jclock.js\").\'\"></script>\'.\"\\n\";
\";}', 'oui', '2010-08-19 13:03:43');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_contribs', 'a:14:{i:0;s:92:\"<br/> &bull; [@@couteauprive:boites_privees:nom@@->http://www.spip-contrib.net/?article2564]\";i:1;s:85:\"<br/> &bull; [@@couteauprive:decoupe:nom@@->http://www.spip-contrib.net/?article2135]\";i:2;s:88:\"<br/> &bull; [@@couteauprive:decoration:nom@@->http://www.spip-contrib.net/?article2427]\";i:3;s:86:\"<br/> &bull; [@@couteauprive:couleurs:nom@@->http://www.spip-contrib.net/?article2427]\";i:4;s:92:\"<br/> &bull; [@@couteauprive:typo_exposants:nom@@->http://www.spip-contrib.net/?article1564]\";i:5;s:93:\"<br/> &bull; [@@couteauprive:liens_orphelins:nom@@->http://www.spip-contrib.net/?article2443]\";i:6;s:88:\"<br/> &bull; [@@couteauprive:filets_sep:nom@@->http://www.spip-contrib.net/?article1563]\";i:7;s:85:\"<br/> &bull; [@@couteauprive:smileys:nom@@->http://www.spip-contrib.net/?article1561]\";i:8;s:87:\"<br/> &bull; [@@couteauprive:glossaire:nom@@->http://www.spip-contrib.net/?article2206]\";i:9;s:87:\"<br/> &bull; [@@couteauprive:mailcrypt:nom@@->http://www.spip-contrib.net/?article2443]\";i:10;s:93:\"<br/> &bull; [@@couteauprive:trousse_balises:nom@@->http://www.spip-contrib.net/?article3005]\";i:11;s:85:\"<br/> &bull; [@@couteauprive:horloge:nom@@->http://www.spip-contrib.net/?article2998]\";i:12;s:86:\"<br/> &bull; [@@couteauprive:maj_auto:nom@@->http://www.spip-contrib.net/?article3223]\";i:13;s:83:\"<br/> &bull; [@@couteauprive:blocs:nom@@->http://www.spip-contrib.net/?article2583]\";}', 'oui', '2010-08-19 13:03:13');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('couteau_suisse_base_version', '1.0', 'oui', '2010-08-19 12:27:16');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_maj', 'a:2:{i:0;i:1282213674;i:1;s:9:\"1.8.21.01\";}', 'oui', '2010-08-19 12:27:55');
INSERT INTO `kinomichibe_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_maj_auto', 'a:51:{s:32:\"7fc9eb0c763c5aadff6549af60193490\";a:2:{i:0;i:1282213690;i:1;s:5:\"38958\";}s:32:\"2b5c1b630f202b617d8984f783da420a\";a:2:{i:0;i:1282213690;i:1;i:239;}s:32:\"d94d88c6b8ab5dc19c9d4871686c8660\";a:2:{i:0;i:1282213690;i:1;s:5:\"39819\";}s:32:\"dc89ecf271902d5b2e6b2e5df92fff2b\";a:2:{i:0;i:1282213690;i:1;i:238;}s:32:\"85c9be0f5f9fcd0cbc1c20085dce3a0a\";a:2:{i:0;i:1282213691;i:1;s:5:\"39718\";}s:32:\"b9fea0c5dc4e9aa81ece5395f91bdaa3\";a:2:{i:0;i:1282213691;i:1;i:237;}s:32:\"134cee965f497cf243df8e10428ec7b2\";a:2:{i:0;i:1282213691;i:1;s:5:\"34510\";}s:32:\"35e3399cf856f19924169904e68fbb82\";a:2:{i:0;i:1282213691;i:1;s:5:\"39206\";}s:32:\"593ecc74303567d51f8c264633c11c1b\";a:2:{i:0;i:1282213691;i:1;i:239;}s:32:\"4a78765cd270dc81fee51d7eceefe96e\";a:2:{i:0;i:1282213692;i:1;s:5:\"39353\";}s:32:\"a36b2523a94cf50fc0f9137fa83e5a08\";a:2:{i:0;i:1282213692;i:1;i:239;}s:32:\"70d87be6bea0b036cc81147c68eade92\";a:2:{i:0;i:1282213692;i:1;s:5:\"39808\";}s:32:\"e94a4a00e6d15ddbef60290950544e3e\";a:2:{i:0;i:1282213692;i:1;i:237;}s:32:\"73cb62a3c4cf1cea9650dd7e4bc92414\";a:2:{i:0;i:1282213693;i:1;s:5:\"39729\";}s:32:\"57b2acbfc4d6bc30a1cbdb3354569cf7\";a:2:{i:0;i:1282213693;i:1;i:239;}s:32:\"85454867cc60205b2808f7d8c73e80ab\";a:2:{i:0;i:1282213694;i:1;s:5:\"39718\";}s:32:\"dae59f3ed74b51f5a95fc30e5fec5f8c\";a:2:{i:0;i:1282213694;i:1;i:239;}s:32:\"28b4cd91e474beb38a6dcfb27b59ace6\";a:2:{i:0;i:1282213694;i:1;s:5:\"38656\";}s:32:\"5ec43337c7868fd7e14fba3d81f8f1e5\";a:2:{i:0;i:1282213694;i:1;i:237;}s:32:\"bd91e4a471e0e1203e85c1c0216e7ca6\";a:2:{i:0;i:1282213694;i:1;s:5:\"39065\";}s:32:\"772d165f9e9e7f3496c61e826d208d57\";a:2:{i:0;i:1282213694;i:1;i:237;}s:32:\"4563de2a54a9ad944f57da2a202e64ef\";a:2:{i:0;i:1282213694;i:1;s:5:\"38965\";}s:32:\"baaf9415e260738662e4547c00fa959a\";a:2:{i:0;i:1282213694;i:1;i:237;}s:32:\"19fbc32177246093d2b56afeb13b8081\";a:2:{i:0;i:1282213694;i:1;s:5:\"39662\";}s:32:\"5719b33f9e5e9d4d7a3b2940a391e10f\";a:2:{i:0;i:1282213694;i:1;i:237;}s:32:\"7b789e1f0d04dc5e7f85b57e009aa3b0\";a:2:{i:0;i:1282213695;i:1;s:5:\"39742\";}s:32:\"cf6efc0a5b5bf6ae57600b4ec4b4ad40\";a:2:{i:0;i:1282213695;i:1;i:241;}s:32:\"4246204783da28b0f8a63816238ad61d\";a:2:{i:0;i:1282213696;i:1;s:5:\"39828\";}s:32:\"f6529ba59eb8b4056e60bd218927fa63\";a:2:{i:0;i:1282213696;i:1;i:238;}s:32:\"7e63bfa38ea86d4f4dc06764d94062e7\";a:2:{i:0;i:1282213696;i:1;s:5:\"38913\";}s:32:\"8419cacad9ab024ac8edc4c631a80940\";a:2:{i:0;i:1282213696;i:1;i:237;}s:32:\"ea52d1b714f91c4563cd84ed86c3d86b\";a:2:{i:0;i:1282213697;i:1;s:5:\"39842\";}s:32:\"c2b8bad8699020052344a7b29b146302\";a:2:{i:0;i:1282213697;i:1;i:239;}s:32:\"bb78a917c818911d52a88cae7443028e\";a:2:{i:0;i:1282213697;i:1;s:5:\"36479\";}s:32:\"fa1fc022e2b8ca34c2885cae950801e8\";a:2:{i:0;i:1282213698;i:1;s:5:\"36129\";}s:32:\"619271442e22f5c86de95861f7458e71\";a:2:{i:0;i:1282213698;i:1;i:237;}s:32:\"c3d0c6ba9211865a264cc8af2c07d2f0\";a:2:{i:0;i:1282213698;i:1;s:5:\"38280\";}s:32:\"5a7fd1dbf8aa931ac7ed66ae6cc7951f\";a:2:{i:0;i:1282213698;i:1;i:237;}s:32:\"d4661751289b6ad331354c53ec84182e\";a:2:{i:0;i:1282213698;i:1;s:5:\"39212\";}s:32:\"f91a76f8d3bf8c8fc4c1ef8bf69e1b22\";a:2:{i:0;i:1282213698;i:1;i:238;}s:32:\"3bd744523dfebfd49c749054773e3bc1\";a:2:{i:0;i:1282213699;i:1;s:5:\"38330\";}s:32:\"18c737575ed5c2a56029b3e2102f7171\";a:2:{i:0;i:1282213699;i:1;i:239;}s:32:\"602b580ca5fb102a0009980efddfdce2\";a:2:{i:0;i:1282213700;i:1;s:5:\"39097\";}s:32:\"3e62207acf6bb32fc114792d262917bf\";a:2:{i:0;i:1282213700;i:1;i:237;}s:32:\"8e0716a100fdc2aaa2dcdb87e5aa5932\";a:2:{i:0;i:1282213700;i:1;s:5:\"39727\";}s:32:\"da88b11e6c7576dd8258f44ca8e3b383\";a:2:{i:0;i:1282213700;i:1;s:5:\"36834\";}s:32:\"520bdd1e2e050070690076d3fb5bca3c\";a:2:{i:0;i:1282213700;i:1;i:238;}s:32:\"6f96ea7c3d0a866d4324b3ae7cba97fd\";a:2:{i:0;i:1282213701;i:1;s:5:\"39502\";}s:32:\"e9e041c69b767b52f70be570529a34f2\";a:2:{i:0;i:1282213701;i:1;i:237;}s:32:\"49c60717de4ee3847873ebd0f59b88f6\";a:2:{i:0;i:1282213701;i:1;s:5:\"39832\";}s:32:\"90c8622a080f32f2c4fb3e7a02055e9d\";a:2:{i:0;i:1282213701;i:1;i:237;}}', 'oui', '2010-08-19 12:28:22');

# Structure de la table kinomichibe_mots
DROP TABLE IF EXISTS `kinomichibe_mots`;

CREATE TABLE `kinomichibe_mots` (
  `id_mot` bigint(21) NOT NULL auto_increment,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `id_groupe` bigint(21) NOT NULL default '0',
  `type` text NOT NULL,
  `extra` longtext,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_mot`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots
INSERT INTO `kinomichibe_mots` (`id_mot`, `titre`, `descriptif`, `texte`, `id_groupe`, `type`, `extra`, `maj`) values ('1', 'album_une', '', '', '1', 'squelette_habillage', '', '2010-08-16 23:51:43');
INSERT INTO `kinomichibe_mots` (`id_mot`, `titre`, `descriptif`, `texte`, `id_groupe`, `type`, `extra`, `maj`) values ('2', 'article_une', '', '', '1', 'squelette_habillage', '', '2010-08-16 23:52:22');

# Structure de la table kinomichibe_mots_articles
DROP TABLE IF EXISTS `kinomichibe_mots_articles`;

CREATE TABLE `kinomichibe_mots_articles` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_article`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots_articles
INSERT INTO `kinomichibe_mots_articles` (`id_mot`, `id_article`) values ('2', '1');

# Structure de la table kinomichibe_mots_breves
DROP TABLE IF EXISTS `kinomichibe_mots_breves`;

CREATE TABLE `kinomichibe_mots_breves` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_breve` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_breve`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots_breves

# Structure de la table kinomichibe_mots_documents
DROP TABLE IF EXISTS `kinomichibe_mots_documents`;

CREATE TABLE `kinomichibe_mots_documents` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_document` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_document`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots_documents

# Structure de la table kinomichibe_mots_forum
DROP TABLE IF EXISTS `kinomichibe_mots_forum`;

CREATE TABLE `kinomichibe_mots_forum` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_forum` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_forum`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots_forum

# Structure de la table kinomichibe_mots_rubriques
DROP TABLE IF EXISTS `kinomichibe_mots_rubriques`;

CREATE TABLE `kinomichibe_mots_rubriques` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_rubrique`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots_rubriques
INSERT INTO `kinomichibe_mots_rubriques` (`id_mot`, `id_rubrique`) values ('2', '1');

# Structure de la table kinomichibe_mots_syndic
DROP TABLE IF EXISTS `kinomichibe_mots_syndic`;

CREATE TABLE `kinomichibe_mots_syndic` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_syndic` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_syndic`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_mots_syndic

# Structure de la table kinomichibe_notations
DROP TABLE IF EXISTS `kinomichibe_notations`;

CREATE TABLE `kinomichibe_notations` (
  `id_notation` bigint(21) NOT NULL auto_increment,
  `objet` varchar(21) NOT NULL default '',
  `id_objet` bigint(21) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `note` tinyint(1) NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_notation`),
  KEY `objet` (`objet`),
  KEY `id_objet` (`id_objet`),
  KEY `id_auteur` (`id_auteur`),
  KEY `ip` (`ip`),
  KEY `note` (`note`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_notations

# Structure de la table kinomichibe_notations_objets
DROP TABLE IF EXISTS `kinomichibe_notations_objets`;

CREATE TABLE `kinomichibe_notations_objets` (
  `objet` varchar(21) NOT NULL default '',
  `id_objet` bigint(21) NOT NULL default '0',
  `note` double NOT NULL,
  `note_ponderee` double NOT NULL,
  `nombre_votes` bigint(21) NOT NULL,
  PRIMARY KEY  (`objet`,`id_objet`),
  KEY `objet` (`objet`),
  KEY `id_objet` (`id_objet`),
  KEY `note` (`note`),
  KEY `note_ponderee` (`note_ponderee`),
  KEY `nombre_votes` (`nombre_votes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_notations_objets

# Structure de la table kinomichibe_petitions
DROP TABLE IF EXISTS `kinomichibe_petitions`;

CREATE TABLE `kinomichibe_petitions` (
  `id_article` bigint(21) NOT NULL default '0',
  `email_unique` char(3) NOT NULL default '',
  `site_obli` char(3) NOT NULL default '',
  `site_unique` char(3) NOT NULL default '',
  `message` char(3) NOT NULL default '',
  `texte` longtext NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_petitions

# Structure de la table kinomichibe_referers
DROP TABLE IF EXISTS `kinomichibe_referers`;

CREATE TABLE `kinomichibe_referers` (
  `referer_md5` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `referer` varchar(255) default NULL,
  `visites` int(10) unsigned NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `visites_veille` int(10) unsigned NOT NULL default '0',
  `visites_jour` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`referer_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_referers
INSERT INTO `kinomichibe_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('952243865953045031', '2010-08-16', 'http://www.kinomichi.be/', '3', '2010-08-19 12:20:46', '0', '0');
INSERT INTO `kinomichibe_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('677994110525227733', '2010-08-17', 'http://www.kinomichi.be/ecrire', '2', '2010-08-19 12:27:55', '0', '0');
INSERT INTO `kinomichibe_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1118288427284510649', '2010-08-17', 'http://www.kinomichi.be/index.php', '13', '2011-12-15 21:57:46', '5', '0');
INSERT INTO `kinomichibe_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('772899346412791154', '2010-08-19', 'http://www.google.fr/', '1', '2010-08-19 16:48:27', '0', '0');

# Structure de la table kinomichibe_referers_articles
DROP TABLE IF EXISTS `kinomichibe_referers_articles`;

CREATE TABLE `kinomichibe_referers_articles` (
  `id_article` int(10) unsigned NOT NULL,
  `referer_md5` bigint(20) unsigned NOT NULL,
  `referer` varchar(255) NOT NULL default '',
  `visites` int(10) unsigned NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_article`,`referer_md5`),
  KEY `referer_md5` (`referer_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_referers_articles

# Structure de la table kinomichibe_resultats
DROP TABLE IF EXISTS `kinomichibe_resultats`;

CREATE TABLE `kinomichibe_resultats` (
  `recherche` char(16) NOT NULL default '',
  `id` int(10) unsigned NOT NULL,
  `points` int(10) unsigned NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_resultats

# Structure de la table kinomichibe_rubriques
DROP TABLE IF EXISTS `kinomichibe_rubriques`;

CREATE TABLE `kinomichibe_rubriques` (
  `id_rubrique` bigint(21) NOT NULL auto_increment,
  `id_parent` bigint(21) NOT NULL default '0',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `id_secteur` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `export` varchar(10) default 'oui',
  `id_import` bigint(20) default '0',
  `statut` varchar(10) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `extra` longtext,
  `statut_tmp` varchar(10) NOT NULL default '0',
  `date_tmp` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_rubrique`),
  KEY `lang` (`lang`),
  KEY `id_parent` (`id_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_rubriques
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('1', '0', 'SQUELETTE', '', '', '1', '2010-08-16 22:14:01', 'oui', '0', 'publie', '2010-08-16 22:14:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('2', '0', 'Le Kinomichi', '', '', '2', '2010-08-17 01:38:34', 'oui', '0', 'publie', '2010-08-17 01:38:33', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('3', '0', 'Matre Noro', '', '', '3', '2010-08-17 00:02:30', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('10', '0', 'Agenda', '', '', '10', '2010-08-19 16:43:10', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('5', '0', 'Dojo de Bruxelles', '', '', '5', '2010-08-17 00:55:03', 'oui', '0', 'publie', '2010-08-17 00:32:12', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('6', '0', 'Dojo de Lige', '', '', '6', '2010-08-17 00:57:11', 'oui', '0', 'publie', '2010-08-17 00:35:32', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('7', '0', 'Dojo de Louvain-la-Neuve', '', '', '7', '2010-08-17 00:58:07', 'oui', '0', 'publie', '2010-08-17 00:31:35', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('8', '0', 'Dojo de Jemeppe sur Meuse', '', '', '8', '2010-08-17 00:55:54', 'oui', '0', 'publie', '2010-08-17 00:44:40', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('9', '0', 'Dojo de Marchin', '', '', '9', '2010-08-17 00:59:05', 'oui', '0', 'publie', '2010-08-17 00:50:16', 'fr', 'non', '', '0', '0000-00-00 00:00:00');
INSERT INTO `kinomichibe_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`) values ('11', '0', 'Galerie', '', '', '11', '2010-08-19 16:48:46', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00');

# Structure de la table kinomichibe_signatures
DROP TABLE IF EXISTS `kinomichibe_signatures`;

CREATE TABLE `kinomichibe_signatures` (
  `id_signature` bigint(21) NOT NULL auto_increment,
  `id_article` bigint(21) NOT NULL default '0',
  `date_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `nom_email` text NOT NULL,
  `ad_email` text NOT NULL,
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `message` mediumtext NOT NULL,
  `statut` varchar(10) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_signature`),
  KEY `id_article` (`id_article`),
  KEY `statut` (`statut`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_signatures

# Structure de la table kinomichibe_syndic
DROP TABLE IF EXISTS `kinomichibe_syndic`;

CREATE TABLE `kinomichibe_syndic` (
  `id_syndic` bigint(21) NOT NULL auto_increment,
  `id_rubrique` bigint(21) NOT NULL default '0',
  `id_secteur` bigint(21) NOT NULL default '0',
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `url_syndic` text NOT NULL,
  `descriptif` text NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `syndication` varchar(3) NOT NULL default '',
  `statut` varchar(10) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_syndic` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_index` datetime NOT NULL default '0000-00-00 00:00:00',
  `extra` longtext,
  `moderation` varchar(3) default 'non',
  `miroir` varchar(3) default 'non',
  `oubli` varchar(3) default 'non',
  `resume` varchar(3) default 'oui',
  PRIMARY KEY  (`id_syndic`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `statut` (`statut`,`date_syndic`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_syndic
INSERT INTO `kinomichibe_syndic` (`id_syndic`, `id_rubrique`, `id_secteur`, `nom_site`, `url_site`, `url_syndic`, `descriptif`, `maj`, `syndication`, `statut`, `date`, `date_syndic`, `date_index`, `extra`, `moderation`, `miroir`, `oubli`, `resume`) values ('1', '2', '2', 'www-kinomichi-com - Maitre Noro prsente le Kinomichi', 'http://www.kinomichi.com', 'http://', 'Art of movement for the 21st century, Way of Energy - Technique of harmony, of opening, of dynamism in fluidity', '2010-08-17 01:37:04', 'non', 'publie', '2010-08-17 01:37:03', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'non', 'non', 'non', 'oui');
INSERT INTO `kinomichibe_syndic` (`id_syndic`, `id_rubrique`, `id_secteur`, `nom_site`, `url_site`, `url_syndic`, `descriptif`, `maj`, `syndication`, `statut`, `date`, `date_syndic`, `date_index`, `extra`, `moderation`, `miroir`, `oubli`, `resume`) values ('2', '2', '2', 'Kinomichi International Instructors Association (K.I.I.A.) : Prsentation', 'http://www.kiia.net', 'http://', 'Le site de la kiia ( k.i.i.a. ) kinomichi international instructors association ou association des instructeurs internationaux du kinomichi cr par maitre Noro.', '2010-08-17 01:38:34', 'non', 'publie', '2010-08-17 01:38:33', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'non', 'non', 'non', 'oui');

# Structure de la table kinomichibe_syndic_articles
DROP TABLE IF EXISTS `kinomichibe_syndic_articles`;

CREATE TABLE `kinomichibe_syndic_articles` (
  `id_syndic_article` bigint(21) NOT NULL auto_increment,
  `id_syndic` bigint(21) NOT NULL default '0',
  `titre` text NOT NULL,
  `url` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `lesauteurs` text NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `statut` varchar(10) NOT NULL default '0',
  `descriptif` text NOT NULL,
  `lang` varchar(10) NOT NULL default '',
  `url_source` tinytext NOT NULL,
  `source` tinytext NOT NULL,
  `tags` text NOT NULL,
  PRIMARY KEY  (`id_syndic_article`),
  KEY `id_syndic` (`id_syndic`),
  KEY `statut` (`statut`),
  KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_syndic_articles

# Structure de la table kinomichibe_types_documents
DROP TABLE IF EXISTS `kinomichibe_types_documents`;

CREATE TABLE `kinomichibe_types_documents` (
  `extension` varchar(10) NOT NULL default '',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `mime_type` varchar(100) NOT NULL default '',
  `inclus` enum('non','image','embed') NOT NULL default 'non',
  `upload` enum('oui','non') NOT NULL default 'oui',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`extension`),
  KEY `inclus` (`inclus`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_types_documents
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('jpg', 'JPEG', '', 'image/jpeg', 'image', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('png', 'PNG', '', 'image/png', 'image', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('gif', 'GIF', '', 'image/gif', 'image', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('bmp', 'BMP', '', 'image/x-ms-bmp', 'image', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('tif', 'TIFF', '', 'image/tiff', 'image', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('aiff', 'AIFF', '', 'audio/x-aiff', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('asf', 'Windows Media', '', 'video/x-ms-asf', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('avi', 'AVI', '', 'video/x-msvideo', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('anx', 'Annodex', '', 'application/annodex', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('axa', 'Annodex Audio', '', 'audio/annodex', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('axv', 'Annodex Video', '', 'video/annodex', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dv', 'Digital Video', '', 'video/x-dv', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4a', 'Audio for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4b', 'Audio Book for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4p', 'Protected Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4v', 'Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('flac', 'Free Lossless Audio Codec', '', 'audio/x-flac', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('flv', 'Flash Video', '', 'video/x-flv', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4a', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4b', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4p', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4u', 'MPEG4 playliste', '', 'video/vnd.mpegurl', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4v', 'MPEG4 Video', '', 'video/x-m4v', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mid', 'Midi', '', 'audio/midi', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mka', 'Matroska Audio', '', 'audio/mka', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mkv', 'Matroska Video', '', 'video/mkv', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mng', 'MNG', '', 'video/x-mng', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mov', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mp3', 'MP3', '', 'audio/mpeg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mp4', 'MPEG4', '', 'application/mp4', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mpc', 'Musepack', '', 'audio/x-musepack', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mpg', 'MPEG', '', 'video/mpeg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('oga', 'Ogg Audio', '', 'audio/ogg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ogg', 'Ogg Vorbis', '', 'audio/ogg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ogv', 'Ogg Video', '', 'video/ogg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ogx', 'Ogg Multiplex', '', 'application/ogg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('qt', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ra', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ram', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('rm', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('spx', 'Ogg Speex', '', 'audio/ogg', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('svg', 'Scalable Vector Graphics', '', 'image/svg+xml', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('swf', 'Flash', '', 'application/x-shockwave-flash', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('wav', 'WAV', '', 'audio/x-wav', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('webm', 'WebM', '', 'video/webm', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('wmv', 'Windows Media', '', 'video/x-ms-wmv', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('3gp', '3rd Generation Partnership Project', '', 'video/3gpp', 'embed', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ai', 'Adobe Illustrator', '', 'application/illustrator', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('abw', 'Abiword', '', 'application/abiword', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('bin', 'Binary Data', '', 'application/octet-stream', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('blend', 'Blender', '', 'application/x-blender', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('bz2', 'BZip', '', 'application/x-bzip2', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('c', 'C source', '', 'text/x-csrc', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('css', 'Cascading Style Sheet', '', 'text/css', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('csv', 'Comma Separated Values', '', 'text/csv', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('deb', 'Debian', '', 'application/x-debian-package', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('doc', 'Word', '', 'application/msword', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('djvu', 'DjVu', '', 'image/vnd.djvu', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dvi', 'LaTeX DVI', '', 'application/x-dvi', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('eps', 'PostScript', '', 'application/postscript', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('gz', 'GZ', '', 'application/x-gzip', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('h', 'C header', '', 'text/x-chdr', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('html', 'HTML', '', 'text/html', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('kml', 'Keyhole Markup Language', '', 'application/vnd.google-earth.kml+xml', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('kmz', 'Google Earth Placemark File', '', 'application/vnd.google-earth.kmz', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pas', 'Pascal', '', 'text/x-pascal', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pdf', 'PDF', '', 'application/pdf', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pgn', 'Portable Game Notation', '', 'application/x-chess-pgn', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppt', 'PowerPoint', '', 'application/vnd.ms-powerpoint', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ps', 'PostScript', '', 'application/postscript', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('psd', 'Photoshop', '', 'image/x-photoshop', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('rpm', 'RedHat/Mandrake/SuSE', '', 'application/x-redhat-package-manager', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('rtf', 'RTF', '', 'application/rtf', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sdd', 'StarOffice', '', 'application/vnd.stardivision.impress', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sdw', 'StarOffice', '', 'application/vnd.stardivision.writer', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sit', 'Stuffit', '', 'application/x-stuffit', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sxc', 'OpenOffice.org Calc', '', 'application/vnd.sun.xml.calc', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sxi', 'OpenOffice.org Impress', '', 'application/vnd.sun.xml.impress', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sxw', 'OpenOffice.org', '', 'application/vnd.sun.xml.writer', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('tex', 'LaTeX', '', 'text/x-tex', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('tgz', 'TGZ', '', 'application/x-gtar', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('torrent', 'BitTorrent', '', 'application/x-bittorrent', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ttf', 'TTF Font', '', 'application/x-font-ttf', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('txt', 'texte', '', 'text/plain', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xcf', 'GIMP multi-layer', '', 'application/x-xcf', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xls', 'Excel', '', 'application/vnd.ms-excel', 'non', 'oui', '2010-08-16 21:30:01');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xspf', 'XSPF', '', 'application/xspf+xml', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xml', 'XML', '', 'application/xml', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('zip', 'Zip', '', 'application/zip', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odt', 'opendocument text', '', 'application/vnd.oasis.opendocument.text', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ods', 'opendocument spreadsheet', '', 'application/vnd.oasis.opendocument.spreadsheet', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odp', 'opendocument presentation', '', 'application/vnd.oasis.opendocument.presentation', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odg', 'opendocument graphics', '', 'application/vnd.oasis.opendocument.graphics', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odc', 'opendocument chart', '', 'application/vnd.oasis.opendocument.chart', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odf', 'opendocument formula', '', 'application/vnd.oasis.opendocument.formula', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odb', 'opendocument database', '', 'application/vnd.oasis.opendocument.database', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odi', 'opendocument image', '', 'application/vnd.oasis.opendocument.image', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odm', 'opendocument text-master', '', 'application/vnd.oasis.opendocument.text-master', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ott', 'opendocument text-template', '', 'application/vnd.oasis.opendocument.text-template', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ots', 'opendocument spreadsheet-template', '', 'application/vnd.oasis.opendocument.spreadsheet-template', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('otp', 'opendocument presentation-template', '', 'application/vnd.oasis.opendocument.presentation-template', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('otg', 'opendocument graphics-template', '', 'application/vnd.oasis.opendocument.graphics-template', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('cls', 'LaTeX Class', '', 'text/x-tex', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sty', 'LaTeX Style Sheet', '', 'text/x-tex', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('docm', 'Word', '', 'application/vnd.ms-word.document.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('docx', 'Word', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dotm', 'Word template', '', 'application/vnd.ms-word.template.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dotx', 'Word template', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('potm', 'Powerpoint template', '', 'application/vnd.ms-powerpoint.template.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('potx', 'Powerpoint template', '', 'application/vnd.openxmlformats-officedocument.presentationml.template', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppam', 'Powerpoint addin', '', 'application/vnd.ms-powerpoint.addin.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppsm', 'Powerpoint slideshow', '', 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppsx', 'Powerpoint slideshow', '', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pptm', 'Powerpoint', '', 'application/vnd.ms-powerpoint.presentation.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pptx', 'Powerpoint', '', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlam', 'Excel', '', 'application/vnd.ms-excel.addin.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlsb', 'Excel binary', '', 'application/vnd.ms-excel.sheet.binary.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlsm', 'Excel', '', 'application/vnd.ms-excel.sheet.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlsx', 'Excel', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xltm', 'Excel template', '', 'application/vnd.ms-excel.template.macroEnabled.12', 'non', 'oui', '2010-08-16 21:30:02');
INSERT INTO `kinomichibe_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xltx', 'Excel template', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'non', 'oui', '2010-08-16 21:30:02');

# Structure de la table kinomichibe_urls
DROP TABLE IF EXISTS `kinomichibe_urls`;

CREATE TABLE `kinomichibe_urls` (
  `url` varchar(255) NOT NULL,
  `type` varchar(15) NOT NULL default 'article',
  `id_objet` bigint(21) NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`url`),
  KEY `type` (`type`,`id_objet`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_urls

# Structure de la table kinomichibe_versions
DROP TABLE IF EXISTS `kinomichibe_versions`;

CREATE TABLE `kinomichibe_versions` (
  `id_article` bigint(21) NOT NULL,
  `id_version` bigint(21) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_auteur` varchar(23) NOT NULL default '',
  `titre_version` text NOT NULL,
  `permanent` char(3) default NULL,
  `champs` text,
  PRIMARY KEY  (`id_article`,`id_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_versions
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('1', '1', '2010-08-16 22:13:43', '1', '', 'non', 'a:4:{s:5:\"titre\";s:1:\"1\";s:9:\"soustitre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";s:5:\"texte\";s:1:\"2\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('1', '2', '2010-08-16 23:59:35', '1', '', 'non', 'a:2:{s:5:\"titre\";s:1:\"1\";s:5:\"texte\";s:1:\"2\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('2', '1', '2010-08-17 00:23:20', '1', '', 'non', 'a:4:{s:5:\"texte\";s:11:\"2 3 6 4 7 5\";s:5:\"titre\";s:1:\"1\";s:9:\"soustitre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('3', '1', '2010-08-17 00:31:09', '1', '', 'non', 'a:4:{s:5:\"texte\";s:11:\"2 3 4 5 6 7\";s:5:\"titre\";s:1:\"1\";s:9:\"soustitre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('4', '1', '2010-08-17 00:35:18', '1', '', 'non', 'a:4:{s:5:\"titre\";s:1:\"1\";s:9:\"soustitre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";s:5:\"texte\";s:5:\"2 3 4\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('5', '1', '2010-08-17 00:44:25', '1', '', 'non', 'a:4:{s:5:\"texte\";s:13:\"2 8 4 9 5 6 7\";s:5:\"titre\";s:1:\"1\";s:9:\"soustitre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('6', '1', '2010-08-17 00:50:01', '1', '', 'non', 'a:4:{s:5:\"texte\";s:11:\"2 7 3 4 5 6\";s:5:\"titre\";s:1:\"1\";s:9:\"soustitre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('6', '2', '2010-08-19 13:23:32', '1', '', 'non', 'a:1:{s:5:\"texte\";s:11:\"2 7 3 4 5 6\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('5', '2', '2010-08-19 13:10:28', '1', '', 'non', 'a:1:{s:5:\"texte\";s:13:\"2 8 4 9 5 6 7\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('2', '2', '2010-08-19 13:13:27', '1', '', 'non', 'a:1:{s:5:\"texte\";s:11:\"2 3 6 4 7 5\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('4', '2', '2010-08-19 13:17:33', '1', '', 'non', 'a:1:{s:5:\"texte\";s:5:\"2 3 4\";}');
INSERT INTO `kinomichibe_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('3', '2', '2010-08-19 13:19:33', '1', '', 'non', 'a:1:{s:5:\"texte\";s:11:\"2 3 4 5 6 7\";}');

# Structure de la table kinomichibe_versions_fragments
DROP TABLE IF EXISTS `kinomichibe_versions_fragments`;

CREATE TABLE `kinomichibe_versions_fragments` (
  `id_fragment` int(10) unsigned NOT NULL default '0',
  `version_min` int(10) unsigned NOT NULL default '0',
  `version_max` int(10) unsigned NOT NULL default '0',
  `id_article` bigint(21) NOT NULL,
  `compress` tinyint(4) NOT NULL,
  `fragment` longblob,
  PRIMARY KEY  (`id_article`,`id_fragment`,`version_min`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_versions_fragments
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '2', '1', '0', 'a:2:{i:1;s:14:\"Page d\'accueil\";i:2;s:7:\"Accueil\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '2', '1', '1', 'xK2δ2.23R
,IUHI-V((J,,,M+)3s332RsrRsRt|,/Wδ2dHIN9@9,\05f');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '2', '0', 'a:1:{i:1;s:17:\"Dojo de Bruxelles\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '2', '2', '0', 'a:1:{i:1;s:69:\"Adresse : Institut Jaques-Dalcroze - 
rue Henri Wafelaerts 52 - 

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('3', '1', '2', '2', '0', 'a:1:{i:1;s:23:\"Bruxelles Belgique 

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('4', '1', '2', '2', '0', 'a:1:{i:1;s:33:\"Téléphone:	32 16 43 31 96  

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('5', '1', '2', '2', '0', 'a:1:{i:1;s:49:\"	
Horaires d\'ouverture :	mardi : 19.30 - 21.30 h\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('7', '1', '2', '2', '0', 'a:1:{i:1;s:35:\"Responsable :	Lejeune Christine

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('6', '1', '2', '2', '1', 'xK2δ2.2RMQR(Ku(IIK-KJRδ2*45RJPk!^\0;4!');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '3', '0', 'a:1:{i:1;s:24:\"Dojo de Louvain-la-Neuve\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '2', '3', '1', 'x%M
0} wz\"2ݵ[)c\"݂׳㏰ݑf%HG.RdXԯ+
s-䬙#)^\'mL5qÉαu/ӂַ˳f?^(');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('3', '1', '2', '3', '1', 'xK2δ2.26RMQRLIKK)-Jt(ήK-KJRδ2*6Rrƪ\\p,ĘZ\0&A');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('4', '1', '2', '3', '1', 'xK2δ2.21R
92ʂT+NC}ScSScs}#S3Cs^.^.%L+#.4]F
(AzkLk');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('5', '1', '2', '3', '0', 'a:1:{i:1;s:31:\"Responsable :	Duray Aland


\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('6', '1', '2', '3', '0', 'a:1:{i:1;s:37:\"Adjointe : 	Anne-sophie Kroonen


\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('7', '1', '2', '3', '1', 'xK2δ2.246R/J,J-VHQ/-K-*)-JUUM-J.JMTHIU0206P8@(T$G%371/9#$m34P(KUH,V(H,R2k1,');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '4', '0', 'a:1:{i:1;s:14:\"Dojo de Liège\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '2', '4', '0', 'a:1:{i:1;s:44:\"A.S.B.L Ouverture - Liège - Belgique 


\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('3', '1', '2', '4', '1', 'xK2δ2.21RMQR,-ILKLMv(ήK-KJTPRδ21RriơKD,y\0h\"*');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('4', '1', '2', '4', '0', 'a:1:{i:1;s:27:\"Responsable :	Niendieck Ute\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '5', '0', 'a:1:{i:1;s:25:\"Dojo de Jemeppe sur Meuse\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '2', '5', '0', 'a:1:{i:1;s:108:\"Ecole de Psychomotricité Léon Troclet - 
avenue Montesquieu,6 - 4101 Jemeppe sur Meuse -  Belgique 


\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('3', '1', '1', '5', '0', 'a:1:{i:1;s:39:\"4101 Jemeppe sur Meuse -  Belgique 

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('4', '1', '2', '5', '1', 'xK2δ2.2R
92ʂT+Nc#csS#0Ȑ3ph66R@h5\0c');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('5', '1', '2', '5', '1', 'x-A
0EzW
WxS;ILR.ns\\̈Wn4tæQI
m+kʀMH[33P\'Z$fXjQ3B/ԎB\\+UXƓھ
B7g');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('6', '1', '2', '5', '0', 'a:1:{i:1;s:67:\"L\'atelier s\'organise en trois groupes (45 h./année chacun). 


\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('7', '1', '2', '5', '0', 'a:1:{i:1;s:20:\"L\'accès est privé.\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('8', '1', '2', '5', '1', 'xK2δ2.26RMQRH+ɩtH	%rr)YgZZZ)TGcUkU8bL-\0
&y');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('9', '1', '2', '5', '0', 'a:1:{i:1;s:29:\"Responsable :	Henno Willy

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '6', '0', 'a:1:{i:1;s:15:\"Dojo de Marchin\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '2', '6', '0', 'a:1:{i:1;s:67:\"Harmonie du Mouvement - Place Belle Maison - Salle omnisport - 

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('3', '1', '2', '6', '1', 'xK2δ2.26RMQRJLήLI-(+vLK+Rδ2*6Rrƪ\\p,ĘZ\0,\'');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('4', '1', '2', '6', '1', 'xK2δ2.21R
92ʂT+Nc#}SC#c0܈K:MB#\0');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('5', '1', '2', '6', '0', 'a:1:{i:1;s:36:\"Responsable :	Deprins Jacqueline

\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('6', '1', '2', '6', '0', 'a:1:{i:1;s:42:\"Horaires d\'ouverture :	Jeudi 17 h à 19 h.\";}');
INSERT INTO `kinomichibe_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('7', '1', '2', '6', '0', 'a:1:{i:1;s:30:\"4570 Marchin - Belgique 


\";}');

# Structure de la table kinomichibe_visites
DROP TABLE IF EXISTS `kinomichibe_visites`;

CREATE TABLE `kinomichibe_visites` (
  `date` date NOT NULL,
  `visites` int(10) unsigned NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_visites
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-16', '1', '2010-08-16 23:44:35');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-17', '4', '2010-08-19 12:20:46');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-18', '1', '2010-08-19 12:20:46');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-19', '3', '2010-08-21 17:58:05');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-21', '1', '2010-08-22 14:54:08');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-22', '2', '2010-08-23 10:42:17');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-28', '2', '2010-09-04 11:56:50');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-08-23', '2', '2010-08-28 23:01:21');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-10-27', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-09-05', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-09-18', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-09-04', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites` (`date`, `visites`, `maj`) values ('2010-09-10', '1', '2011-12-15 21:57:46');

# Structure de la table kinomichibe_visites_articles
DROP TABLE IF EXISTS `kinomichibe_visites_articles`;

CREATE TABLE `kinomichibe_visites_articles` (
  `date` date NOT NULL,
  `id_article` int(10) unsigned NOT NULL,
  `visites` int(10) unsigned NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`date`,`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_visites_articles
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '1', '1', '2010-08-17 16:07:23');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '2', '1', '2010-08-17 16:07:23');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '5', '1', '2010-08-17 16:07:23');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '4', '1', '2010-08-17 16:07:23');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '3', '1', '2010-08-17 16:07:23');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '6', '1', '2010-08-17 16:07:23');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-19', '6', '1', '2010-08-21 17:58:06');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-19', '5', '1', '2010-08-21 17:58:06');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-19', '4', '1', '2010-08-21 17:58:06');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-19', '2', '1', '2010-08-21 17:58:06');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-19', '3', '1', '2010-08-21 17:58:06');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-21', '4', '1', '2010-08-22 14:54:08');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-22', '5', '1', '2010-08-23 10:42:17');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-23', '6', '1', '2010-08-28 23:01:21');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-23', '3', '1', '2010-08-28 23:01:21');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-23', '4', '1', '2010-08-28 23:01:21');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-23', '2', '1', '2010-08-28 23:01:21');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-23', '5', '1', '2010-08-28 23:01:21');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-28', '2', '1', '2010-09-04 11:56:51');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-28', '6', '1', '2010-09-04 11:56:51');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-28', '3', '1', '2010-09-04 11:56:51');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-28', '4', '1', '2010-09-04 11:56:51');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-28', '5', '1', '2010-09-04 11:56:51');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-27', '3', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-05', '3', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-18', '2', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-18', '4', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-04', '3', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-04', '4', '1', '2011-12-15 21:57:46');
INSERT INTO `kinomichibe_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-10', '3', '1', '2011-12-15 21:57:46');

# Structure de la table kinomichibe_zones
DROP TABLE IF EXISTS `kinomichibe_zones`;

CREATE TABLE `kinomichibe_zones` (
  `id_zone` bigint(21) NOT NULL auto_increment,
  `titre` varchar(255) NOT NULL default '',
  `descriptif` text NOT NULL,
  `publique` enum('non','oui') NOT NULL default 'oui',
  `privee` enum('non','oui') NOT NULL default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_zones

# Structure de la table kinomichibe_zones_auteurs
DROP TABLE IF EXISTS `kinomichibe_zones_auteurs`;

CREATE TABLE `kinomichibe_zones_auteurs` (
  `id_zone` bigint(21) NOT NULL,
  `id_auteur` bigint(21) NOT NULL,
  PRIMARY KEY  (`id_zone`,`id_auteur`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_zones_auteurs

# Structure de la table kinomichibe_zones_rubriques
DROP TABLE IF EXISTS `kinomichibe_zones_rubriques`;

CREATE TABLE `kinomichibe_zones_rubriques` (
  `id_zone` bigint(21) NOT NULL,
  `id_rubrique` bigint(21) NOT NULL,
  PRIMARY KEY  (`id_zone`,`id_rubrique`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de kinomichibe_zones_rubriques

# Structure de la table spip01_articles
DROP TABLE IF EXISTS `spip01_articles`;

CREATE TABLE `spip01_articles` (
  `id_article` bigint(21) NOT NULL auto_increment,
  `surtitre` text NOT NULL,
  `titre` text NOT NULL,
  `soustitre` text NOT NULL,
  `id_rubrique` bigint(21) NOT NULL default '0',
  `descriptif` text NOT NULL,
  `chapo` mediumtext NOT NULL,
  `texte` longtext NOT NULL,
  `ps` mediumtext NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `statut` varchar(10) NOT NULL default '0',
  `id_secteur` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `export` varchar(10) default 'oui',
  `date_redac` datetime NOT NULL default '0000-00-00 00:00:00',
  `visites` int(11) NOT NULL default '0',
  `referers` int(11) NOT NULL default '0',
  `popularite` double NOT NULL default '0',
  `accepter_forum` char(3) NOT NULL default '',
  `date_modif` datetime NOT NULL default '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `id_trad` bigint(21) NOT NULL default '0',
  `extra` longtext,
  `id_version` int(10) unsigned NOT NULL default '0',
  `nom_site` tinytext NOT NULL,
  `url_site` varchar(255) NOT NULL default '',
  `accepter_note` char(3) NOT NULL default '',
  PRIMARY KEY  (`id_article`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `id_trad` (`id_trad`),
  KEY `lang` (`lang`),
  KEY `statut` (`statut`,`date`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

# Donnees de spip01_articles
INSERT INTO `spip01_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`, `accepter_note`) values ('1', '', 'BOURILLON.NET', '', '7', '', '', 'Bienvenue sur Bourillon.net', '', '2010-08-11 12:45:01', 'publie', '7', '2010-08-11 12:45:02', 'oui', '0000-00-00 00:00:00', '14', '0', '0.000161308242477059', 'pos', '2010-08-11 12:44:36', 'fr', 'non', '0', '', '1', '', '', '');
INSERT INTO `spip01_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`, `accepter_note`) values ('2', '', 'pangnosis.com', '', '10', '', '=http://www.pangnosis.com', '', '', '2010-08-16 10:50:09', 'publie', '10', '2010-08-16 10:50:10', 'oui', '0000-00-00 00:00:00', '143', '0', '0.070843529211104', 'pos', '2010-08-16 10:49:50', 'fr', 'non', '0', '', '1', '', '', '');
INSERT INTO `spip01_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`, `accepter_note`) values ('3', '', 'KIM : Kinomichi in Mnchen', '', '1', '', '=http://www.kinomichi-muenchen.de', '', '', '2010-08-16 20:55:52', 'publie', '1', '2010-08-16 20:55:53', 'oui', '0000-00-00 00:00:00', '141', '0', '0.000178917493074643', 'pos', '2010-08-16 20:55:37', 'fr', 'non', '0', '', '1', '', '', '');
INSERT INTO `spip01_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`, `accepter_note`) values ('4', '', 'KEB : Kinomichi en Belgique', '', '1', '', '=http://www.kinomichi.be', '', '', '2010-08-16 20:58:17', 'publie', '1', '2010-08-16 20:58:18', 'oui', '0000-00-00 00:00:00', '151', '0', '0.070843526054316', 'pos', '2010-08-16 20:57:49', 'fr', 'non', '0', '', '1', '', '', '');

# Structure de la table spip01_articles_lies
DROP TABLE IF EXISTS `spip01_articles_lies`;

CREATE TABLE `spip01_articles_lies` (
  `id_article` bigint(21) NOT NULL,
  `id_article_lie` bigint(21) NOT NULL,
  `rang` bigint(21) NOT NULL default '0',
  `type_liaison` tinytext NOT NULL,
  PRIMARY KEY  (`id_article`,`id_article_lie`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_articles_lies

# Structure de la table spip01_auteurs
DROP TABLE IF EXISTS `spip01_auteurs`;

CREATE TABLE `spip01_auteurs` (
  `id_auteur` bigint(21) NOT NULL auto_increment,
  `nom` text NOT NULL,
  `bio` text NOT NULL,
  `email` tinytext NOT NULL,
  `nom_site` tinytext NOT NULL,
  `url_site` text NOT NULL,
  `login` varchar(255) character set utf8 collate utf8_bin default NULL,
  `pass` tinytext NOT NULL,
  `low_sec` tinytext NOT NULL,
  `statut` varchar(255) NOT NULL default '0',
  `webmestre` varchar(3) NOT NULL default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `pgp` text NOT NULL,
  `htpass` tinytext NOT NULL,
  `en_ligne` datetime NOT NULL default '0000-00-00 00:00:00',
  `imessage` varchar(3) default NULL,
  `messagerie` varchar(3) default NULL,
  `alea_actuel` tinytext,
  `alea_futur` tinytext,
  `prefs` tinytext,
  `cookie_oubli` tinytext,
  `source` varchar(10) NOT NULL default 'spip',
  `lang` varchar(10) NOT NULL default '',
  `extra` longtext,
  PRIMARY KEY  (`id_auteur`),
  KEY `login` (`login`),
  KEY `statut` (`statut`),
  KEY `en_ligne` (`en_ligne`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

# Donnees de spip01_auteurs
INSERT INTO `spip01_auteurs` (`id_auteur`, `nom`, `bio`, `email`, `nom_site`, `url_site`, `login`, `pass`, `low_sec`, `statut`, `webmestre`, `maj`, `pgp`, `htpass`, `en_ligne`, `imessage`, `messagerie`, `alea_actuel`, `alea_futur`, `prefs`, `cookie_oubli`, `source`, `lang`, `extra`) values ('1', 'platonas', '', 'jp@bourillon.net', '', '', 'platonas', '51db1a608f5b2b60f86f91edeff0c444a9ac2de39676cb25b62b832eae52d587', '', '0minirezo', 'oui', '2012-01-20 09:05:33', '', '$1$guckmAim$PGeeh4..xswKpNEKjRoe5/', '2012-01-20 09:05:44', '', '', '1250251304ee4993f6b85d3.68255321', '7583252774f188f736f2596.67478011', 'a:3:{s:7:\"couleur\";i:1;s:7:\"display\";s:1:\"2\";s:3:\"cnx\";s:0:\"\";}', '', 'spip', '', '');
INSERT INTO `spip01_auteurs` (`id_auteur`, `nom`, `bio`, `email`, `nom_site`, `url_site`, `login`, `pass`, `low_sec`, `statut`, `webmestre`, `maj`, `pgp`, `htpass`, `en_ligne`, `imessage`, `messagerie`, `alea_actuel`, `alea_futur`, `prefs`, `cookie_oubli`, `source`, `lang`, `extra`) values ('2', 'Jean-Paul BOURILLON', '', 'jp.bourillon@googlemail.com', 'BOURILLON.NET', 'www.bourillon.net', 'polino', '4d60406e9758b825b301d245f7678474fc255f2ced5e968296cc26aee44f99c7', '', '1comite', 'non', '2011-12-11 13:32:59', '', '$1$RyJUwK9u$FwgsQblWdQ2jh7XVASw9e0', '0000-00-00 00:00:00', '', '', '18644622014ee4a30d5d31a3.41794541', '6063383974ee4a30d5d3269.76341069', '', '', 'spip', '', '');

# Structure de la table spip01_auteurs_articles
DROP TABLE IF EXISTS `spip01_auteurs_articles`;

CREATE TABLE `spip01_auteurs_articles` (
  `id_auteur` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_auteur`,`id_article`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_auteurs_articles
INSERT INTO `spip01_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '1');
INSERT INTO `spip01_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '2');
INSERT INTO `spip01_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '3');
INSERT INTO `spip01_auteurs_articles` (`id_auteur`, `id_article`) values ('1', '4');

# Structure de la table spip01_auteurs_messages
DROP TABLE IF EXISTS `spip01_auteurs_messages`;

CREATE TABLE `spip01_auteurs_messages` (
  `id_auteur` bigint(21) NOT NULL default '0',
  `id_message` bigint(21) NOT NULL default '0',
  `vu` char(3) default NULL,
  PRIMARY KEY  (`id_auteur`,`id_message`),
  KEY `id_message` (`id_message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_auteurs_messages

# Structure de la table spip01_auteurs_rubriques
DROP TABLE IF EXISTS `spip01_auteurs_rubriques`;

CREATE TABLE `spip01_auteurs_rubriques` (
  `id_auteur` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_auteur`,`id_rubrique`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_auteurs_rubriques

# Structure de la table spip01_breves
DROP TABLE IF EXISTS `spip01_breves`;

CREATE TABLE `spip01_breves` (
  `id_breve` bigint(21) NOT NULL auto_increment,
  `date_heure` datetime NOT NULL default '0000-00-00 00:00:00',
  `titre` text NOT NULL,
  `texte` longtext NOT NULL,
  `lien_titre` text NOT NULL,
  `lien_url` text NOT NULL,
  `statut` varchar(6) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `extra` longtext,
  PRIMARY KEY  (`id_breve`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_breves

# Structure de la table spip01_cm_lists
DROP TABLE IF EXISTS `spip01_cm_lists`;

CREATE TABLE `spip01_cm_lists` (
  `lst_id` int(11) NOT NULL auto_increment,
  `lst_name` varchar(255) NOT NULL,
  `lst_comment` text NOT NULL,
  `lst_moderation` varchar(10) NOT NULL,
  `lst_moderator_email` varchar(255) NOT NULL,
  `lst_subscribe_subject` varchar(255) NOT NULL,
  `lst_subscribe_text` text NOT NULL,
  `lst_subject` varchar(255) NOT NULL,
  `lst_unsubscribe_subject` varchar(255) NOT NULL,
  `lst_unsubscribe_text` text NOT NULL,
  `lst_subject_tag` tinyint(1) NOT NULL default '1',
  `lst_url_html` varchar(255) NOT NULL,
  `lst_url_text` varchar(255) NOT NULL,
  `lst_auto_mode` enum('none','day','week','month') default 'none',
  `lst_auto_hour` tinyint(2) NOT NULL default '8',
  `lst_auto_week_day` tinyint(1) NOT NULL default '1',
  `lst_auto_week_days` varchar(13) NOT NULL default '1',
  `lst_auto_month_day` tinyint(2) NOT NULL default '1',
  `lst_auto_subscribers` varchar(255) NOT NULL,
  `lst_auto_subscribers_mode` tinyint(1) NOT NULL default '0',
  `lst_auto_subscribers_updated` int(11) NOT NULL default '0',
  PRIMARY KEY  (`lst_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_lists

# Structure de la table spip01_cm_lists_subscribers
DROP TABLE IF EXISTS `spip01_cm_lists_subscribers`;

CREATE TABLE `spip01_cm_lists_subscribers` (
  `lst_id` int(11) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  `lsr_mode` tinyint(1) NOT NULL,
  `lsr_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`lst_id`,`sub_id`),
  KEY `lst_id` (`lst_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_lists_subscribers

# Structure de la table spip01_cm_pending
DROP TABLE IF EXISTS `spip01_cm_pending`;

CREATE TABLE `spip01_cm_pending` (
  `lst_id` int(11) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  `pnd_action` varchar(15) NOT NULL,
  `pnd_mode` tinyint(1) NOT NULL,
  `pnd_action_date` int(11) NOT NULL,
  `pnd_action_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`lst_id`,`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_pending

# Structure de la table spip01_cm_posts
DROP TABLE IF EXISTS `spip01_cm_posts`;

CREATE TABLE `spip01_cm_posts` (
  `pst_id` bigint(20) NOT NULL auto_increment,
  `lst_id` int(11) NOT NULL,
  `pst_date_create` int(11) NOT NULL,
  `pst_date_update` int(11) NOT NULL,
  `pst_date_sent` int(11) NOT NULL,
  `pst_subject` varchar(255) NOT NULL,
  `pst_html` longtext NOT NULL,
  `pst_text` longtext NOT NULL,
  PRIMARY KEY  (`pst_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_posts

# Structure de la table spip01_cm_posts_done
DROP TABLE IF EXISTS `spip01_cm_posts_done`;

CREATE TABLE `spip01_cm_posts_done` (
  `pst_id` bigint(20) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`pst_id`,`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_posts_done

# Structure de la table spip01_cm_posts_links
DROP TABLE IF EXISTS `spip01_cm_posts_links`;

CREATE TABLE `spip01_cm_posts_links` (
  `lnk_id` bigint(20) NOT NULL auto_increment,
  `pst_id` bigint(20) NOT NULL,
  `lnk_name` varchar(255) NOT NULL,
  `lnk_url` text NOT NULL,
  PRIMARY KEY  (`lnk_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_posts_links

# Structure de la table spip01_cm_posts_queued
DROP TABLE IF EXISTS `spip01_cm_posts_queued`;

CREATE TABLE `spip01_cm_posts_queued` (
  `pst_id` bigint(20) NOT NULL,
  `sub_id` bigint(20) NOT NULL,
  `psq_date` int(11) NOT NULL,
  PRIMARY KEY  (`pst_id`,`sub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_posts_queued

# Structure de la table spip01_cm_settings
DROP TABLE IF EXISTS `spip01_cm_settings`;

CREATE TABLE `spip01_cm_settings` (
  `set_name` varchar(15) NOT NULL,
  `set_value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_settings
INSERT INTO `spip01_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_FROM', 'jp@bourillon.net');
INSERT INTO `spip01_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_ADMIN', 'jp@bourillon.net');
INSERT INTO `spip01_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_RETURN', 'jp@bourillon.net');
INSERT INTO `spip01_cm_settings` (`set_name`, `set_value`) values ('CM_SEND_NUMBER', '50');
INSERT INTO `spip01_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_SUBJECT', 'Confirmation de votre inscription');
INSERT INTO `spip01_cm_settings` (`set_name`, `set_value`) values ('CM_MAIL_TEXT', '
Bonjour,

Pour confirmer votre inscription aux lettres d\'information suivantes :

 @@NOM_COMPLET@@ 

veuillez cliquer sur ce lien :

 @@URL_CONFIRMATION@@

Merci
');

# Structure de la table spip01_cm_subscribers
DROP TABLE IF EXISTS `spip01_cm_subscribers`;

CREATE TABLE `spip01_cm_subscribers` (
  `sub_id` bigint(20) NOT NULL auto_increment,
  `sub_email` varchar(255) NOT NULL,
  `sub_profile` varchar(32) NOT NULL,
  PRIMARY KEY  (`sub_id`),
  KEY `sub_profile` (`sub_profile`),
  KEY `sub_email` (`sub_email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_cm_subscribers

# Structure de la table spip01_documents
DROP TABLE IF EXISTS `spip01_documents`;

CREATE TABLE `spip01_documents` (
  `id_document` bigint(21) NOT NULL auto_increment,
  `id_vignette` bigint(21) NOT NULL default '0',
  `extension` varchar(10) NOT NULL default '',
  `titre` text NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `descriptif` text NOT NULL,
  `fichier` varchar(255) NOT NULL default '',
  `taille` int(11) default NULL,
  `largeur` int(11) default NULL,
  `hauteur` int(11) default NULL,
  `mode` enum('vignette','image','document') NOT NULL default 'document',
  `distant` varchar(3) default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_document`),
  KEY `id_vignette` (`id_vignette`),
  KEY `mode` (`mode`),
  KEY `extension` (`extension`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_documents

# Structure de la table spip01_documents_donnees
DROP TABLE IF EXISTS `spip01_documents_donnees`;

CREATE TABLE `spip01_documents_donnees` (
  `id_document` bigint(21) NOT NULL default '0',
  `id_donnee` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_document`),
  KEY `id_document` (`id_document`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_documents_donnees

# Structure de la table spip01_documents_liens
DROP TABLE IF EXISTS `spip01_documents_liens`;

CREATE TABLE `spip01_documents_liens` (
  `id_document` bigint(21) NOT NULL default '0',
  `id_objet` bigint(21) NOT NULL default '0',
  `objet` varchar(25) NOT NULL default '',
  `vu` enum('non','oui') NOT NULL default 'non',
  PRIMARY KEY  (`id_document`,`id_objet`,`objet`),
  KEY `id_document` (`id_document`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_documents_liens

# Structure de la table spip01_evenements
DROP TABLE IF EXISTS `spip01_evenements`;

CREATE TABLE `spip01_evenements` (
  `id_evenement` bigint(21) NOT NULL auto_increment,
  `id_article` bigint(21) NOT NULL default '0',
  `date_debut` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_fin` datetime NOT NULL default '0000-00-00 00:00:00',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `lieu` text NOT NULL,
  `adresse` text NOT NULL,
  `inscription` tinyint(1) NOT NULL default '0',
  `places` int(11) NOT NULL default '0',
  `horaire` varchar(3) NOT NULL default 'oui',
  `id_evenement_source` bigint(21) NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_evenement`),
  KEY `date_debut` (`date_debut`),
  KEY `date_fin` (`date_fin`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_evenements

# Structure de la table spip01_evenements_participants
DROP TABLE IF EXISTS `spip01_evenements_participants`;

CREATE TABLE `spip01_evenements_participants` (
  `id_evenement` bigint(21) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `reponse` char(3) NOT NULL default '?',
  PRIMARY KEY  (`id_evenement`,`id_auteur`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_evenements_participants

# Structure de la table spip01_forms
DROP TABLE IF EXISTS `spip01_forms`;

CREATE TABLE `spip01_forms` (
  `id_form` bigint(21) NOT NULL auto_increment,
  `titre` varchar(255) NOT NULL,
  `descriptif` text,
  `type_form` varchar(255) NOT NULL,
  `modifiable` enum('non','oui') default 'non',
  `multiple` enum('non','oui') default 'non',
  `forms_obligatoires` varchar(255) NOT NULL default '',
  `email` text,
  `champconfirm` varchar(255) NOT NULL,
  `texte` text,
  `moderation` varchar(10) default 'posteriori',
  `public` enum('non','oui') NOT NULL default 'non',
  `linkable` enum('non','oui') NOT NULL default 'non',
  `documents` enum('non','oui') NOT NULL default 'non',
  `documents_mail` enum('non','oui') NOT NULL default 'non',
  `arborescent` enum('non','oui') NOT NULL default 'non',
  `html_wrap` text,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `num_rubrique_export` bigint(21) NOT NULL default '1',
  `champ_titre_export` varchar(100) default 'null',
  PRIMARY KEY  (`id_form`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms

# Structure de la table spip01_forms_articles
DROP TABLE IF EXISTS `spip01_forms_articles`;

CREATE TABLE `spip01_forms_articles` (
  `id_form` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_form`,`id_article`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_articles

# Structure de la table spip01_forms_champs
DROP TABLE IF EXISTS `spip01_forms_champs`;

CREATE TABLE `spip01_forms_champs` (
  `id_form` bigint(21) NOT NULL,
  `champ` varchar(100) NOT NULL,
  `rang` bigint(21) NOT NULL,
  `titre` text,
  `type` varchar(100) default NULL,
  `taille` bigint(21) NOT NULL,
  `obligatoire` varchar(3) default NULL,
  `extra_info` text,
  `specifiant` enum('non','oui') NOT NULL default 'non',
  `listable_admin` enum('non','oui') NOT NULL default 'oui',
  `listable` enum('non','oui') NOT NULL default 'oui',
  `public` enum('non','oui') NOT NULL default 'non',
  `saisie` enum('non','oui') NOT NULL default 'oui',
  `aide` text,
  `html_wrap` text,
  PRIMARY KEY  (`id_form`,`champ`),
  KEY `rang` (`rang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_champs

# Structure de la table spip01_forms_champs_choix
DROP TABLE IF EXISTS `spip01_forms_champs_choix`;

CREATE TABLE `spip01_forms_champs_choix` (
  `id_form` bigint(21) NOT NULL,
  `champ` varchar(100) NOT NULL,
  `choix` varchar(100) NOT NULL default '',
  `titre` text,
  `rang` bigint(21) NOT NULL,
  PRIMARY KEY  (`id_form`,`champ`,`choix`),
  KEY `choix` (`choix`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_champs_choix

# Structure de la table spip01_forms_donnees
DROP TABLE IF EXISTS `spip01_forms_donnees`;

CREATE TABLE `spip01_forms_donnees` (
  `id_donnee` bigint(21) NOT NULL auto_increment,
  `id_form` bigint(21) NOT NULL,
  `date` datetime NOT NULL,
  `ip` varchar(255) NOT NULL,
  `id_auteur` bigint(21) NOT NULL,
  `id_article_export` bigint(21) NOT NULL,
  `url` varchar(255) NOT NULL,
  `confirmation` varchar(10) NOT NULL,
  `statut` varchar(10) NOT NULL,
  `cookie` varchar(255) NOT NULL,
  `rang` bigint(21) NOT NULL,
  `bgch` bigint(21) NOT NULL,
  `bdte` bigint(21) NOT NULL,
  `niveau` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_donnee`),
  KEY `id_form` (`id_form`,`date`),
  KEY `date` (`date`),
  KEY `cookie` (`cookie`),
  KEY `id_auteur` (`id_auteur`),
  KEY `statut` (`statut`,`id_form`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_donnees

# Structure de la table spip01_forms_donnees_articles
DROP TABLE IF EXISTS `spip01_forms_donnees_articles`;

CREATE TABLE `spip01_forms_donnees_articles` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  `article_ref` enum('non','oui') NOT NULL default 'non',
  PRIMARY KEY  (`id_donnee`,`id_article`),
  KEY `id_article` (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_donnees_articles

# Structure de la table spip01_forms_donnees_auteurs
DROP TABLE IF EXISTS `spip01_forms_donnees_auteurs`;

CREATE TABLE `spip01_forms_donnees_auteurs` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_auteur`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_donnees_auteurs

# Structure de la table spip01_forms_donnees_champs
DROP TABLE IF EXISTS `spip01_forms_donnees_champs`;

CREATE TABLE `spip01_forms_donnees_champs` (
  `id_donnee` bigint(21) NOT NULL,
  `champ` varchar(255) NOT NULL,
  `valeur` text NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  UNIQUE KEY `champ` (`champ`(128),`id_donnee`,`valeur`(128)),
  KEY `id_donnee` (`id_donnee`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_donnees_champs

# Structure de la table spip01_forms_donnees_donnees
DROP TABLE IF EXISTS `spip01_forms_donnees_donnees`;

CREATE TABLE `spip01_forms_donnees_donnees` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `donnee_ref` enum('non','oui') NOT NULL default 'non',
  `id_donnee_liee` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_donnee_liee`),
  KEY `id_donnee_liee` (`id_donnee_liee`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_donnees_donnees

# Structure de la table spip01_forms_donnees_rubriques
DROP TABLE IF EXISTS `spip01_forms_donnees_rubriques`;

CREATE TABLE `spip01_forms_donnees_rubriques` (
  `id_donnee` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_donnee`,`id_rubrique`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_forms_donnees_rubriques

# Structure de la table spip01_forum
DROP TABLE IF EXISTS `spip01_forum`;

CREATE TABLE `spip01_forum` (
  `id_forum` bigint(21) NOT NULL auto_increment,
  `id_parent` bigint(21) NOT NULL default '0',
  `id_thread` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  `id_breve` bigint(21) NOT NULL default '0',
  `date_heure` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_thread` datetime NOT NULL default '0000-00-00 00:00:00',
  `titre` text NOT NULL,
  `texte` mediumtext NOT NULL,
  `auteur` text NOT NULL,
  `email_auteur` text NOT NULL,
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `statut` varchar(8) NOT NULL default '0',
  `ip` varchar(16) NOT NULL default '',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_auteur` bigint(20) NOT NULL default '0',
  `id_message` bigint(21) NOT NULL default '0',
  `id_syndic` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_forum`),
  KEY `id_auteur` (`id_auteur`),
  KEY `id_parent` (`id_parent`),
  KEY `id_thread` (`id_thread`),
  KEY `optimal` (`statut`,`id_parent`,`id_article`,`date_heure`,`id_breve`,`id_syndic`,`id_rubrique`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

# Donnees de spip01_forum
INSERT INTO `spip01_forum` (`id_forum`, `id_parent`, `id_thread`, `id_rubrique`, `id_article`, `id_breve`, `date_heure`, `date_thread`, `titre`, `texte`, `auteur`, `email_auteur`, `nom_site`, `url_site`, `statut`, `ip`, `maj`, `id_auteur`, `id_message`, `id_syndic`) values ('1', '0', '1', '0', '1', '0', '2011-10-20 08:12:17', '2011-10-20 08:12:17', 'BOURILLON.NET', 'Was ttolaly stuck until I read this, now back up and running.', 'yKBWGbSvXcE', 'photo@yakimaherald.com', '', '', 'publie', '199.48.178.197', '2011-10-20 08:12:07', '0', '0', '0');

# Structure de la table spip01_groupes_mots
DROP TABLE IF EXISTS `spip01_groupes_mots`;

CREATE TABLE `spip01_groupes_mots` (
  `id_groupe` bigint(21) NOT NULL auto_increment,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `unseul` varchar(3) NOT NULL default '',
  `obligatoire` varchar(3) NOT NULL default '',
  `tables_liees` text NOT NULL,
  `minirezo` varchar(3) NOT NULL default '',
  `comite` varchar(3) NOT NULL default '',
  `forum` varchar(3) NOT NULL default '',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_groupe`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_groupes_mots

# Structure de la table spip01_messages
DROP TABLE IF EXISTS `spip01_messages`;

CREATE TABLE `spip01_messages` (
  `id_message` bigint(21) NOT NULL auto_increment,
  `titre` text NOT NULL,
  `texte` longtext NOT NULL,
  `type` varchar(6) NOT NULL default '',
  `date_heure` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_fin` datetime NOT NULL default '0000-00-00 00:00:00',
  `rv` varchar(3) NOT NULL default '',
  `statut` varchar(6) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_message`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_messages

# Structure de la table spip01_meta
DROP TABLE IF EXISTS `spip01_meta`;

CREATE TABLE `spip01_meta` (
  `nom` varchar(255) NOT NULL,
  `valeur` text,
  `impt` enum('non','oui') NOT NULL default 'oui',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_meta
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset_sql_base', 'utf8', 'non', '2010-08-11 08:42:33');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset_collation_sql_base', 'utf8_general_ci', 'non', '2010-08-11 08:42:33');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset_sql_connexion', 'utf8', 'non', '2010-08-11 08:42:33');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('version_installee', '15828', 'non', '2010-08-11 08:42:33');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('nouvelle_install', '1', 'non', '2010-08-11 08:42:33');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('charset', 'utf-8', 'oui', '2010-08-11 08:43:38');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('alea_ephemere_ancien', 'fe3cca77cea631cc63100d7f840e2e4f', 'non', '2012-01-19 22:44:51');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('alea_ephemere', '25c30f1e6a28e42e07106381ac57714a', 'non', '2012-01-19 22:44:51');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('alea_ephemere_date', '1327009515', 'non', '2012-01-19 22:44:51');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langues_proposees', 'ar,ast,bg,br,bs,ca,cpf,cpf_hat,cs,da,de,en,eo,es,eu,fa,fon,fr,gl,hu,id,it,it_fem,ja,km,lb,my,nl,oc_auv,oc_gsc,oc_lms,oc_lnc,oc_ni,oc_ni_la,oc_prv,oc_va,pl,pt,pt_br,ro,ru,sv,tr,vi,zh', 'non', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langue_site', 'fr', 'non', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('pcre_u', 'u', 'oui', '2010-08-11 08:43:38');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('email_webmaster', 'jp@bourillon.net', 'oui', '2010-08-11 08:43:56');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('nom_site', 'BOURILLON.NET', 'oui', '2010-08-11 17:29:36');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_site', 'http://www.bourillon.net', 'non', '2010-08-12 11:51:33');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('descriptif_site', 'Site personnel de Jean-Paul BOURILLON, Professeur certifi de Lettres et enseignant de Kinomichi, mthode Noro.

     
<!-- ======================================================================================== -->
<!-- Alexandria IS DISTRIBUTED \"AS IS\". NO WARRANTY OF ANY KIND IS EXPRESSED OR IMPLIED.      -->
<!-- YOU USE AT YOUR OWN RISK. THE AUTHOR WILL NOT BE LIABLE FOR DATA LOSS, DAMAGES, LOSS OF  -->
<!-- PROFITS OR ANY OTHER KIND OF LOSS WHILE USING OR MISUSING THIS SOFTWARE.                 -->
<!-- ======================================================================================== -->

<!-- **************************************************************************************** -->
<!-- Alert Alexandria (optional)                                                              -->
<!-- Indicates that Alexandria is available on this page                                      -->
<!-- **************************************************************************************** -->
    <script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria-memodata/alert/alert.fr.js\"></script>

<!-- **************************************************************************************** -->
<!-- Alexandria\'s parameters for Webmasters                                                   -->
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms.     -->
<!-- Customization is only possible for registered customers.                                 -->
<!-- **************************************************************************************** -->
    <script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script>

<!-- **************************************************************************************** -->
<!-- Alexandria\'s engine                                                                      --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. -->
<!-- **************************************************************************************** -->
    <script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria/scripts/alexandria.main.js\"></script>
    <link rel=StyleSheet href=\"http://www.sensagent.com/alexandria/css/alexandria.window.css\" type=\"text/css\">

<!-- ======================================================================================== -->        
       ', 'oui', '2010-09-13 00:24:13');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_breves', 'oui', 'oui', '2010-08-11 17:23:41');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_logos', 'non', 'oui', '2010-08-11 17:24:16');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_logos_survol', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('config_precise_groupes', 'oui', 'oui', '2010-08-11 17:24:01');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('mots_cles_forums', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_surtitre', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_soustitre', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_descriptif', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_chapeau', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_texte', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_ps', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_redac', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_mots', 'oui', 'oui', '2010-08-11 17:24:01');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('post_dates', 'oui', 'oui', '2010-08-11 17:23:21');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_urlref', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_redirection', 'oui', 'oui', '2010-08-11 17:23:27');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('creer_preview', 'non', 'non', '2010-08-11 12:27:15');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('taille_preview', '150', 'non', '2010-08-11 12:27:15');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_modif', 'oui', 'oui', '2010-08-11 12:36:11');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('rubriques_descriptif', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('rubriques_texte', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_titre', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_texte', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_urlref', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_afficher_barre', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('formats_documents_forum', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_sites', 'oui', 'oui', '2010-08-11 12:32:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('proposer_sites', '0', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_syndic', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('moderation_sites', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forums_publics', 'posteriori', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('accepter_inscriptions', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('accepter_visiteurs', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('prevenir_auteurs', ',pos,', 'oui', '2010-08-11 12:35:20');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('suivi_edito', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_suivi', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_suivi_inscription', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('adresse_neuf', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('jours_neuf', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('quoi_de_neuf', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forum_prive', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forum_prive_objets', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forum_prive_admin', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('messagerie_agenda', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('articles_versions', 'oui', 'oui', '2010-08-11 12:36:21');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_statistiques', 'oui', 'oui', '2010-08-11 12:36:03');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('activer_captures_referers', 'oui', 'oui', '2010-08-12 12:00:22');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('documents_article', 'oui', 'oui', '2010-08-11 12:32:10');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('documents_rubrique', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('documents_date', 'oui', 'oui', '2010-08-11 12:32:10');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('syndication_integrale', 'non', 'oui', '2010-08-11 12:32:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('dir_img', 'IMG/', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('multi_articles', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('multi_rubriques', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('multi_secteurs', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gerer_trad', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langues_multilingue', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('type_urls', 'page', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('email_envoi', '', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_http', 'oui', 'oui', '2010-08-11 12:38:16');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_js', 'oui', 'oui', '2010-08-11 12:38:16');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_css', 'oui', 'oui', '2010-08-11 12:38:16');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('iecompat', 'IE8squish', 'oui', '2010-08-11 12:37:56');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('barre_outils_public', 'oui', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('auto_compress_closure', 'non', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('langues_utilisees', 'fr', 'oui', '2010-08-11 08:43:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugin', 'a:31:{s:6:\"IMAGES\";a:5:{s:3:\"nom\";s:26:\"Filtres Images et Couleurs\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:14:\"filtres_images\";s:7:\"version\";s:5:\"1.0.1\";}s:11:\"MSIE_COMPAT\";a:5:{s:3:\"nom\";s:90:\"<multi>[fr]Support vieux navigateurs[de]Unterst&#252;tzung &#228;lterer Webbrowser</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:11:\"msie_compat\";s:7:\"version\";s:5:\"1.0.0\";}s:11:\"PORTE_PLUME\";a:5:{s:3:\"nom\";s:100:\"<multi>[fr]Porte plume[en]Quill[ar]&#1575;&#1604;&#1585;&#1610;&#1588;&#1577;[de]Federhalter</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:11:\"porte_plume\";s:7:\"version\";s:5:\"1.7.8\";}s:8:\"SAFEHTML\";a:5:{s:3:\"nom\";s:8:\"SafeHTML\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:8:\"safehtml\";s:7:\"version\";s:5:\"1.3.7\";}s:9:\"VERTEBRES\";a:5:{s:3:\"nom\";s:14:\"Vert&#232;bres\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:9:\"vertebres\";s:7:\"version\";s:5:\"1.0.0\";}s:3:\"CFG\";a:5:{s:3:\"nom\";s:3:\"CFG\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:8:\"auto/cfg\";s:7:\"version\";s:6:\"1.16.0\";}s:7:\"CRAYONS\";a:5:{s:3:\"nom\";s:180:\"<multi>
	Crayons
	[ar]&#1575;&#1604;&#1602;&#1604;&#1605;
	[it]Pennarelli
	[de]Der Stift
	[en]Pencils
	[ru]&#1050;&#1072;&#1088;&#1072;&#1085;&#1076;&#1072;&#1096;
	</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:12:\"auto/crayons\";s:7:\"version\";s:6:\"1.13.3\";}s:13:\"TYPOENLUMINEE\";a:5:{s:3:\"nom\";s:26:\"Enluminures typographiques\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:34:\"auto/enluminures_typographiques_v3\";s:7:\"version\";s:5:\"3.3.0\";}s:7:\"FACTEUR\";a:5:{s:3:\"nom\";s:51:\"<multi>
			[fr]Facteur
			[en]Postman
		</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:12:\"auto/facteur\";s:7:\"version\";s:5:\"1.8.4\";}s:5:\"FORMS\";a:5:{s:3:\"nom\";s:197:\"<multi>[ar]&#1575;&#1604;&#1575;&#1587;&#1578;&#1605;&#1575;&#1585;&#1575;&#1578;
		[en]Forms
		[de]Formulare und Tabellen
		[fr]Formulaires et Tables
		[it]Forms
		[es]Formularios
		</multi>\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:24:\"auto/forms_et_tables_2_0\";s:7:\"version\";s:5:\"0.4.1\";}s:8:\"GRAVATAR\";a:5:{s:3:\"nom\";s:8:\"Gravatar\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/gravatar\";s:7:\"version\";s:5:\"1.3.0\";}s:14:\"COUTEAU_SUISSE\";a:5:{s:3:\"nom\";s:426:\"<multi>[en]Swiss Knife[fr]Le Couteau Suisse[ca]El Ganivet Su&#237;s[ar]&#1587;&#1603;&#1610;&#1606; &#1575;&#1604;&#1580;&#1610;&#1576;[nl]Het Zwitserland Mes[gl]A navalla su&#237;za[es]La Navaja Suiza[de]Schweizer Taschenmesser[tr]&#304;svi&#231;re &#199;ak&#305;s&#305;[br]Ar Gontell Suis[pt_br]Canivete Su&#237;&#231;o[ast]La Navaya Suiza[gl]A navalla su&#237;za[ro]Cu&#355;itul Elve&#355;ian[it]Coltellino Svizzero</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:19:\"auto/couteau_suisse\";s:7:\"version\";s:6:\"1.8.56\";}s:8:\"NOTATION\";a:5:{s:3:\"nom\";s:37:\"<multi>[fr]Notation[en]Rating</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/notation\";s:7:\"version\";s:5:\"0.9.5\";}s:4:\"NYRO\";a:5:{s:3:\"nom\";s:9:\"Nyroceros\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:14:\"auto/nyroceros\";s:7:\"version\";s:5:\"0.2.1\";}s:8:\"RAINETTE\";a:5:{s:3:\"nom\";s:8:\"Rainette\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/rainette\";s:7:\"version\";s:5:\"1.4.0\";}s:8:\"SHOUTBOX\";a:5:{s:3:\"nom\";s:8:\"Shoutbox\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:13:\"auto/shoutbox\";s:7:\"version\";s:5:\"0.2.0\";}s:10:\"SPIP_BONUX\";a:5:{s:3:\"nom\";s:10:\"SPIP Bonux\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:15:\"auto/spip-bonux\";s:7:\"version\";s:5:\"2.3.0\";}s:9:\"SARKASPIP\";a:5:{s:3:\"nom\";s:22:\"Squelette Sarka-SPIP 3\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:11:\"sarkaspip_3\";s:7:\"version\";s:5:\"3.1.0\";}s:9:\"THICKBOX1\";a:5:{s:3:\"nom\";s:11:\"Thickbox v2\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:14:\"auto/thickbox2\";s:7:\"version\";s:5:\"0.3.0\";}s:10:\"THUMBSITES\";a:5:{s:3:\"nom\";s:10:\"Thumbsites\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:15:\"auto/thumbsites\";s:7:\"version\";s:5:\"0.6.1\";}s:9:\"ZENGARDEN\";a:5:{s:3:\"nom\";s:10:\"Zen-Garden\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:21:\"auto/zen-garden-1.1.1\";s:7:\"version\";s:5:\"1.1.1\";}s:3:\"A2A\";a:5:{s:3:\"nom\";s:3:\"A2A\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:8:\"auto/a2a\";s:7:\"version\";s:5:\"0.4.3\";}s:14:\"ACCESRESTREINT\";a:5:{s:3:\"nom\";s:102:\"<multi>[fr]Acc&#232;s Restreint[es]Acceso restringido[en]Restricted Access[de]Zugangskontrolle</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:24:\"auto/acces_restreint_3_0\";s:7:\"version\";s:5:\"3.3.1\";}s:6:\"AGENDA\";a:5:{s:3:\"nom\";s:6:\"Agenda\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:15:\"auto/agenda_2_0\";s:7:\"version\";s:5:\"2.3.0\";}s:10:\"CLEVERMAIL\";a:5:{s:3:\"nom\";s:10:\"CleverMail\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:26:\"auto/clevermail_pour_spip2\";s:7:\"version\";s:5:\"2.6.0\";}s:7:\"CONTACT\";a:5:{s:3:\"nom\";s:245:\"<multi>[fr]Formulaire de contact avanc&eacute;
	[en]Advanced Contact Form
	[ar]&#1573;&#1587;&#1578;&#1605;&#1575;&#1585;&#1577; &#1575;&#1604;&#1575;&#1578;&#1589;&#1575;&#1604; &#1575;&#1604;&#1605;&#1578;&#1602;&#1583;&#1605;&#1577;
	</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:12:\"auto/contact\";s:7:\"version\";s:4:\"0.62\";}s:12:\"MES_FICHIERS\";a:5:{s:3:\"nom\";s:14:\"Mes fichiers 2\";s:4:\"etat\";s:3:\"dev\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:19:\"auto/mes_fichiers_2\";s:7:\"version\";s:3:\"0.2\";}s:5:\"NUAGE\";a:5:{s:3:\"nom\";s:5:\"Nuage\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:10:\"auto/nuage\";s:7:\"version\";s:5:\"3.2.2\";}s:7:\"SAISIES\";a:5:{s:3:\"nom\";s:64:\"<multi>[fr]Saisies pour formulaires[en]Entries for forms</multi>\";s:4:\"etat\";s:4:\"test\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:12:\"auto/saisies\";s:7:\"version\";s:6:\"1.20.2\";}s:8:\"SAVEAUTO\";a:5:{s:3:\"nom\";s:106:\"<multi>
			[fr]sauvegarde automatique
			[it]Salvataggio automatico
			[en]Automatic backup
		</multi>\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:12:\"_DIR_PLUGINS\";s:3:\"dir\";s:17:\"auto/saveauto_2_1\";s:7:\"version\";s:5:\"0.7.5\";}s:11:\"COMPRESSEUR\";a:5:{s:3:\"nom\";s:11:\"Compresseur\";s:4:\"etat\";s:6:\"stable\";s:8:\"dir_type\";s:15:\"_DIR_EXTENSIONS\";s:3:\"dir\";s:11:\"compresseur\";s:7:\"version\";s:5:\"1.0.1\";}}', 'non', '2012-01-19 23:22:44');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_cc', 'jp@bourillon.net', 'oui', '2011-12-11 13:22:42');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_bcc', '', 'oui', '2011-12-11 13:22:42');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugin_header', 'images(1.0.1),msie_compat(1.0.0),porte_plume(1.7.8),safehtml(1.3.7),vertebres(1.0.0),cfg(1.16.0),crayons(1.13.3),typoenluminee(3.3.0),facteur(1.8.4),forms(0.4.1),gravatar(1.3.0),couteau_suisse(1.8.56),notation(0.9.5),nyro(0.2.1),rainette(1.4.0),shoutbox(0.2.0),spip_bonux(2.3.0),sarkaspip(3.1.0),thickbox1(0.3.0),thumbsites(0.6.1),zengarden(1.1.1),a2a(0.4.3),accesrestreint(3.3.1),agenda(2.3.0),clevermail(2.6.0),contact(0.62),mes_fichiers(0.2),nuage(3.2.2),saisies(1.20.2),saveauto(0.7.5),compresseur(1.0.1)', 'non', '2012-01-19 23:22:44');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugin_installes', 'a:10:{i:0;s:12:\"auto/facteur\";i:1;s:24:\"auto/forms_et_tables_2_0\";i:2;s:19:\"auto/couteau_suisse\";i:3;s:13:\"auto/notation\";i:4;s:13:\"auto/shoutbox\";i:5;s:8:\"auto/a2a\";i:6;s:24:\"auto/acces_restreint_3_0\";i:7;s:15:\"auto/agenda_2_0\";i:8;s:26:\"auto/clevermail_pour_spip2\";i:9;s:17:\"auto/saveauto_2_1\";}', 'non', '2012-01-19 23:22:50');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('secret_du_site', '95fd957cc5037438a4161119e80961ab94ff6a4393a85d4c59badda6dae12c7c', 'oui', '2010-08-11 08:45:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tour_quota_cache', '3', 'oui', '2012-01-20 09:06:22');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_rubrique', '1281684216', 'oui', '2010-08-13 09:23:36');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif', '1323606797', 'non', '2011-12-11 13:32:59');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('optimiser_table', '32', 'non', '2012-01-19 22:51:37');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('info_maj_spip', '', 'non', '2012-01-18 07:09:47');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('syndic_plug', 'a:2:{s:45:\"http://plugins.spip.net/rss-+-selection-2-1-+\";i:608;s:54:\"http://www.spip-contrib.net/?page=rss-plugins-spip-2-1\";i:294;}', 'oui', '2012-01-19 23:02:45');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('plugins_interessants', 'a:29:{s:8:\"auto/cfg\";i:10;s:19:\"auto/couteau_suisse\";i:10;s:34:\"auto/enluminures_typographiques_v3\";i:10;s:11:\"sarkaspip_3\";i:10;s:13:\"auto/rainette\";i:10;s:10:\"auto/nuage\";i:10;s:14:\"auto/nyroceros\";i:10;s:12:\"auto/crayons\";i:10;s:24:\"auto/forms_et_tables_2_0\";i:10;s:17:\"auto/saveauto_2_1\";i:10;s:12:\"auto/facteur\";i:10;s:15:\"auto/spip-bonux\";i:10;s:13:\"auto/annuaire\";i:1;s:13:\"auto/notation\";i:10;s:15:\"auto/thumbsites\";i:10;s:8:\"auto/a2a\";i:10;s:24:\"auto/acces_restreint_3_0\";i:10;s:20:\"auto/article_pdf_2_0\";i:7;s:12:\"auto/contact\";i:10;s:14:\"auto/thickbox2\";i:10;s:13:\"auto/fancybox\";i:8;s:19:\"auto/mes_fichiers_2\";i:10;s:13:\"auto/gravatar\";i:10;s:12:\"auto/saisies\";i:10;s:14:\"enviar_email_2\";i:8;s:15:\"auto/agenda_2_0\";i:10;s:26:\"auto/clevermail_pour_spip2\";i:10;s:21:\"auto/zen-garden-1.1.1\";i:10;s:13:\"auto/shoutbox\";i:10;}', 'oui', '2012-01-19 23:22:42');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_actifs', 'a:50:{s:11:\"set_options\";a:1:{s:5:\"actif\";i:0;}s:12:\"suivi_forums\";a:1:{s:5:\"actif\";i:0;}s:9:\"type_urls\";a:1:{s:5:\"actif\";i:1;}s:9:\"corbeille\";a:1:{s:5:\"actif\";i:1;}s:12:\"SPIP_tailles\";a:1:{s:5:\"actif\";i:1;}s:10:\"webmestres\";a:1:{s:5:\"actif\";i:1;}s:4:\"spam\";a:1:{s:5:\"actif\";i:1;}s:8:\"maj_auto\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:3223;}s:18:\"moderation_moderee\";a:1:{s:5:\"actif\";i:1;}s:12:\"paragrapher2\";a:1:{s:5:\"actif\";i:1;}s:12:\"auteur_forum\";a:1:{s:5:\"actif\";i:1;}s:13:\"forum_lgrmaxi\";a:1:{s:5:\"actif\";i:1;}s:15:\"cs_comportement\";a:0:{}s:14:\"boites_privees\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2564;}s:13:\"meme_rubrique\";a:1:{s:5:\"actif\";i:1;}s:10:\"spip_ecran\";a:1:{s:5:\"actif\";i:1;}s:12:\"tri_articles\";a:1:{s:5:\"actif\";i:1;}s:7:\"auteurs\";a:1:{s:5:\"actif\";i:1;}s:16:\"previsualisation\";a:1:{s:5:\"actif\";i:1;}s:8:\"brouteur\";a:1:{s:5:\"actif\";i:1;}s:15:\"liens_orphelins\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2443;}s:7:\"pucesli\";a:1:{s:5:\"actif\";i:1;}s:12:\"citations_bb\";a:1:{s:5:\"actif\";i:1;}s:10:\"insertions\";a:1:{s:5:\"actif\";i:1;}s:14:\"typo_exposants\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:1564;}s:9:\"glossaire\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2206;}s:10:\"guillemets\";a:1:{s:5:\"actif\";i:1;}s:11:\"titres_typo\";a:1:{s:5:\"actif\";i:1;}s:9:\"mailcrypt\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2443;}s:7:\"smileys\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:1561;}s:8:\"sommaire\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2378;}s:5:\"blocs\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2583;}s:9:\"toutmulti\";a:1:{s:5:\"actif\";i:1;}s:7:\"chatons\";a:1:{s:5:\"actif\";i:1;}s:10:\"decoration\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2427;}s:7:\"decoupe\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2135;}s:10:\"filets_sep\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:1563;}s:8:\"couleurs\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2427;}s:13:\"soft_scroller\";a:1:{s:5:\"actif\";i:1;}s:7:\"jcorner\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2987;}s:19:\"visiteurs_connectes\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:3412;}s:12:\"titre_parent\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2900;}s:7:\"horloge\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2998;}s:14:\"liens_en_clair\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:2443;}s:7:\"masquer\";a:1:{s:5:\"actif\";i:1;}s:11:\"orientation\";a:1:{s:5:\"actif\";i:1;}s:15:\"trousse_balises\";a:2:{s:5:\"actif\";i:1;s:7:\"contrib\";i:3005;}s:9:\"verstexte\";a:1:{s:5:\"actif\";i:1;}s:10:\"SPIP_liens\";a:1:{s:7:\"contrib\";i:2443;}s:8:\"devdebug\";a:1:{s:7:\"contrib\";i:3572;}}', 'oui', '2011-12-11 13:15:21');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_variables', 'a:30:{s:8:\"_chaines\";a:53:{i:0;s:18:\"dossier_squelettes\";i:1;s:10:\"webmestres\";i:2;s:18:\"suite_introduction\";i:3;s:18:\"radio_set_options4\";i:4;s:11:\"mot_masquer\";i:5;s:19:\"radio_suivi_forums3\";i:6;s:9:\"spam_mots\";i:7;s:8:\"spam_ips\";i:8;s:15:\"message_travaux\";i:9;s:9:\"i_couleur\";i:10;s:8:\"i_police\";i:11;s:22:\"url_glossaire_externe2\";i:12;s:17:\"decoration_styles\";i:13;s:14:\"couleurs_perso\";i:14;s:17:\"glossaire_groupes\";i:15;s:15:\"jcorner_classes\";i:16;s:10:\"insertions\";i:17;s:12:\"tri_articles\";i:18;s:9:\"tri_perso\";i:19;s:11:\"tri_groupes\";i:20;s:17:\"tri_perso_groupes\";i:21;s:10:\"spip_ecran\";i:22;s:7:\"bloc_h4\";i:23;s:11:\"blocs_slide\";i:24;s:7:\"style_p\";i:25;s:7:\"style_h\";i:26;s:7:\"racc_hr\";i:27;s:7:\"racc_h1\";i:28;s:7:\"racc_h2\";i:29;s:7:\"racc_i1\";i:30;s:7:\"racc_i2\";i:31;s:7:\"racc_g1\";i:32;s:7:\"racc_g2\";i:33;s:9:\"ouvre_ref\";i:34;s:9:\"ferme_ref\";i:35;s:10:\"ouvre_note\";i:36;s:10:\"ferme_note\";i:37;s:4:\"puce\";i:38;s:15:\"devdebug_espace\";i:39;s:15:\"devdebug_niveau\";i:40;s:16:\"radio_type_urls3\";i:41;s:11:\"spip_script\";i:42;s:21:\"terminaison_urls_page\";i:43;s:20:\"separateur_urls_page\";i:44;s:15:\"url_arbo_sep_id\";i:45;s:21:\"terminaison_urls_arbo\";i:46;s:24:\"terminaison_urls_propres\";i:47;s:18:\"debut_urls_propres\";i:48;s:19:\"debut_urls_propres2\";i:49;s:23:\"terminaison_urls_libres\";i:50;s:17:\"debut_urls_libres\";i:51;s:27:\"terminaison_urls_propres_qs\";i:52;s:18:\"urls_id_sauf_liste\";}s:8:\"_nombres\";a:110:{i:0;s:6:\"alinea\";i:1;s:7:\"alinea2\";i:2;s:11:\"paragrapher\";i:3;s:16:\"lgr_introduction\";i:4;s:17:\"lien_introduction\";i:5;s:25:\"radio_filtrer_javascript3\";i:6;s:13:\"forum_lgrmaxi\";i:7;s:9:\"logo_Hmax\";i:8;s:9:\"logo_Wmax\";i:9;s:9:\"logo_Smax\";i:10;s:8:\"img_Hmax\";i:11;s:8:\"img_Wmax\";i:12;s:8:\"img_Smax\";i:13;s:8:\"doc_Smax\";i:14;s:9:\"img_GDmax\";i:15;s:10:\"img_GDqual\";i:16;s:10:\"copie_Smax\";i:17;s:16:\"auteur_forum_nom\";i:18;s:18:\"auteur_forum_email\";i:19;s:17:\"auteur_forum_deux\";i:20;s:11:\"ecran_actif\";i:21;s:10:\"ecran_load\";i:22;s:18:\"log_couteau_suisse\";i:23;s:15:\"spip_options_on\";i:24;s:11:\"distant_off\";i:25;s:18:\"distant_outils_off\";i:26;s:13:\"prive_travaux\";i:27;s:13:\"admin_travaux\";i:28;s:15:\"avertir_travaux\";i:29;s:13:\"titre_travaux\";i:30;s:13:\"cache_travaux\";i:31;s:14:\"bp_tri_auteurs\";i:32;s:15:\"bp_urls_propres\";i:33;s:6:\"cs_rss\";i:34;s:11:\"format_spip\";i:35;s:12:\"stat_auteurs\";i:36;s:14:\"qui_webmasters\";i:37;s:16:\"max_auteurs_page\";i:38;s:9:\"auteurs_0\";i:39;s:9:\"auteurs_1\";i:40;s:9:\"auteurs_5\";i:41;s:9:\"auteurs_6\";i:42;s:9:\"auteurs_n\";i:43;s:17:\"auteurs_tout_voir\";i:44;s:14:\"balise_decoupe\";i:45;s:13:\"prof_sommaire\";i:46;s:12:\"lgr_sommaire\";i:47;s:13:\"auto_sommaire\";i:48;s:13:\"jolies_ancres\";i:49;s:15:\"balise_sommaire\";i:50;s:9:\"i_padding\";i:51;s:9:\"i_hauteur\";i:52;s:9:\"i_largeur\";i:53;s:8:\"i_taille\";i:54;s:19:\"radio_target_blank3\";i:55;s:15:\"enveloppe_mails\";i:56;s:8:\"tout_rub\";i:57;s:8:\"tout_aut\";i:58;s:8:\"puceSPIP\";i:59;s:14:\"couleurs_fonds\";i:60;s:12:\"set_couleurs\";i:61;s:11:\"expo_bofbof\";i:62;s:19:\"liens_interrogation\";i:63;s:15:\"liens_orphelins\";i:64;s:8:\"long_url\";i:65;s:9:\"coupe_url\";i:66;s:16:\"glossaire_limite\";i:67;s:12:\"glossaire_js\";i:68;s:8:\"scrollTo\";i:69;s:11:\"LocalScroll\";i:70;s:14:\"jcorner_plugin\";i:71;s:16:\"moderation_admin\";i:72;s:16:\"moderation_redac\";i:73;s:16:\"moderation_visit\";i:74;s:14:\"titres_etendus\";i:75;s:18:\"arret_optimisation\";i:76;s:17:\"rubrique_brouteur\";i:77;s:17:\"select_mots_clefs\";i:78;s:18:\"select_min_auteurs\";i:79;s:18:\"select_max_auteurs\";i:80;s:13:\"meme_rubrique\";i:81;s:11:\"bloc_unique\";i:82;s:12:\"blocs_cookie\";i:83;s:14:\"blocs_millisec\";i:84;s:13:\"devdebug_mode\";i:85;s:22:\"radio_desactive_cache3\";i:86;s:22:\"radio_desactive_cache4\";i:87;s:11:\"duree_cache\";i:88;s:16:\"duree_cache_mutu\";i:89;s:11:\"quota_cache\";i:90;s:23:\"derniere_modif_invalide\";i:91;s:13:\"compacte_tout\";i:92;s:14:\"compacte_prive\";i:93;s:12:\"compacte_css\";i:94;s:11:\"compacte_js\";i:95;s:19:\"url_arbo_minuscules\";i:96;s:19:\"urls_arbo_sans_type\";i:97;s:12:\"url_max_arbo\";i:98;s:15:\"url_max_propres\";i:99;s:22:\"marqueurs_urls_propres\";i:100;s:16:\"url_max_propres2\";i:101;s:23:\"marqueurs_urls_propres2\";i:102;s:14:\"url_max_libres\";i:103;s:18:\"url_max_propres_qs\";i:104;s:25:\"marqueurs_urls_propres_qs\";i:105;s:15:\"urls_minuscules\";i:106;s:12:\"urls_avec_id\";i:107;s:13:\"urls_avec_id2\";i:108;s:18:\"urls_id_3_chiffres\";i:109;s:22:\"urls_id_sauf_rubriques\";}s:16:\"radio_type_urls3\";s:8:\"propres2\";s:21:\"terminaison_urls_page\";s:0:\"\";s:20:\"separateur_urls_page\";s:0:\"\";s:24:\"terminaison_urls_propres\";s:5:\".html\";s:18:\"debut_urls_propres\";s:9:\"pangnosis\";s:22:\"marqueurs_urls_propres\";i:1;s:15:\"url_max_propres\";i:40;s:19:\"debut_urls_propres2\";s:0:\"\";s:23:\"marqueurs_urls_propres2\";i:1;s:16:\"url_max_propres2\";i:35;s:23:\"terminaison_urls_libres\";s:0:\"\";s:17:\"debut_urls_libres\";s:0:\"\";s:14:\"url_max_libres\";i:35;s:19:\"url_arbo_minuscules\";i:1;s:19:\"urls_arbo_sans_type\";i:1;s:15:\"url_arbo_sep_id\";s:1:\"-\";s:21:\"terminaison_urls_arbo\";s:5:\".html\";s:12:\"url_max_arbo\";i:35;s:27:\"terminaison_urls_propres_qs\";s:0:\"\";s:18:\"url_max_propres_qs\";i:35;s:25:\"marqueurs_urls_propres_qs\";i:1;s:11:\"spip_script\";s:8:\"spip.php\";s:15:\"urls_minuscules\";i:1;s:12:\"urls_avec_id\";i:0;s:13:\"urls_avec_id2\";i:1;s:18:\"urls_id_3_chiffres\";i:1;s:22:\"urls_id_sauf_rubriques\";i:1;s:18:\"urls_id_sauf_liste\";s:15:\"rubrique:auteur\";}', 'oui', '2011-12-11 13:15:21');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_pipelines', 'a:23:{s:21:\"pre_description_outil\";s:1904:\"
# Copie du code utilise en eval() pour le pipeline \'pre_description_outil($flux)\'
include_spip(\'outils/ecran_securite\');
include_spip(\'outils/sommaire\');
include_spip(\'outils/couleurs\');
if($id==\"autobr\")
		$texte=str_replace(\"@BALISES@\",cs_balises_traitees(\"autobr\"),$texte);
if($id==\"webmestres\")
		$texte=str_replace(array(\"@_CS_LISTE_WEBMESTRES@\",\"@_CS_LISTE_ADMINS@\"),get_liste_administrateurs(),$texte);
if($id==\"auteur_forum\") $texte=str_replace(array(\"@_CS_FORUM_NOM@\",\"@_CS_FORUM_EMAIL@\"),
	array(preg_replace(\',:$,\',\"\",_T(\"forum_votre_nom\")),preg_replace(\',:$,\',\"\",_T(\"forum_votre_email\"))),$texte);
if($id==\"ecran_securite\") $flux[\"non\"] = !1 || !$flux[\"actif\"];
if($id==\"cs_comportement\"){$tmp=(!0||!$flux[\"actif\"]||defined(\"_CS_SPIP_OPTIONS_OK\"))?\"\":\"<span style=\\\"color:red\\\">\"._T(\"couteauprive:cs_spip_options_erreur\").\"</span>\";
$texte=str_replace(array(\"@_CS_FILE_OPTIONS_ERR@\",\"@_CS_DIR_TMP@\",\"@_CS_FILE_OPTIONS@\"),
	array($tmp,cs_canonicalize(_DIR_RESTREINT_ABS._DIR_TMP),show_file_options()),$texte);
}
if($id==\"en_travaux\") $texte=str_replace(array(\"@_CS_TRAVAUX_TITRE@\",\"@_CS_NOM_SITE@\"),
	array(\"[\"._T(\"info_travaux_titre\").\"]\",\"[\".$GLOBALS[\"meta\"][\"nom_site\"].\"]\"),$texte);
if($id==\"titres_typo\")
		$texte=str_replace(\"@_CS_FONTS@\",join(\" - \",get_liste_fonts()),$texte);
if($id==\"visiteurs_connectes\") if($GLOBALS[\"meta\"][\"activer_statistiques\"]!=\"oui\")
		$texte.=\"\\n\\n<span style=\\\"color:red;\\\">\"._T(\"couteauprive:visiteurs_connectes:inactif\").\"</span>\";
function_exists(\'ecran_securite_pre_description_outil\')?$flux=ecran_securite_pre_description_outil($flux):cs_deferr(\'ecran_securite_pre_description_outil\');
function_exists(\'sommaire_description_outil\')?$flux=sommaire_description_outil($flux):cs_deferr(\'sommaire_description_outil\');
function_exists(\'couleurs_pre_description_outil\')?$flux=couleurs_pre_description_outil($flux):cs_deferr(\'couleurs_pre_description_outil\');
\";s:10:\"pre_boucle\";s:509:\"
# Copie du code utilise en eval() pour le pipeline \'pre_boucle($flux)\'
include_spip(\'lib/previsualisation/distant_previsu_redac_pipelines\');
include_spip(\'lib/masquer/distant_masquer_pipelines\');
include_spip(\'outils/boites_privees\');
function_exists(\'previsu_redac_pre_boucle\')?$flux=previsu_redac_pre_boucle($flux):cs_deferr(\'previsu_redac_pre_boucle\');
function_exists(\'masquer_pre_boucle\')?$flux=masquer_pre_boucle($flux):cs_deferr(\'masquer_pre_boucle\');
function_exists(\'\')?$flux=($flux):cs_deferr(\'\');
\";s:11:\"boite_infos\";s:267:\"
# Copie du code utilise en eval() pour le pipeline \'boite_infos($flux)\'
include_spip(\'lib/previsualisation/distant_previsu_redac_pipelines\');
function_exists(\'previsu_redac_boite_infos\')?$flux=previsu_redac_boite_infos($flux):cs_deferr(\'previsu_redac_boite_infos\');
\";s:15:\"fichier_distant\";s:255:\"
# Copie du code utilise en eval() pour le pipeline \'fichier_distant($flux)\'
include_spip(\'outils/ecran_securite\');
function_exists(\'ecran_securite_fichier_distant\')?$flux=ecran_securite_fichier_distant($flux):cs_deferr(\'ecran_securite_fichier_distant\');
\";s:14:\"affiche_milieu\";s:251:\"
# Copie du code utilise en eval() pour le pipeline \'affiche_milieu($flux)\'
include_spip(\'outils/boites_privees\');
function_exists(\'boites_privees_affiche_milieu\')?$flux=boites_privees_affiche_milieu($flux):cs_deferr(\'boites_privees_affiche_milieu\');
\";s:14:\"affiche_droite\";s:251:\"
# Copie du code utilise en eval() pour le pipeline \'affiche_droite($flux)\'
include_spip(\'outils/boites_privees\');
function_exists(\'boites_privees_affiche_droite\')?$flux=boites_privees_affiche_droite($flux):cs_deferr(\'boites_privees_affiche_droite\');
\";s:14:\"affiche_gauche\";s:251:\"
# Copie du code utilise en eval() pour le pipeline \'affiche_gauche($flux)\'
include_spip(\'outils/boites_privees\');
function_exists(\'boites_privees_affiche_gauche\')?$flux=boites_privees_affiche_gauche($flux):cs_deferr(\'boites_privees_affiche_gauche\');
\";s:24:\"nettoyer_raccourcis_typo\";s:630:\"
# Copie du code utilise en eval() pour le pipeline \'nettoyer_raccourcis_typo($flux)\'
include_spip(\'outils/decoupe\');
include_spip(\'outils/sommaire\');
include_spip(\'outils/couleurs\');
$flux=str_replace(_CS_SANS_GLOSSAIRE, \"\", $flux);
function_exists(\'decoupe_nettoyer_raccourcis\')?$flux=decoupe_nettoyer_raccourcis($flux):cs_deferr(\'decoupe_nettoyer_raccourcis\');
function_exists(\'sommaire_nettoyer_raccourcis\')?$flux=sommaire_nettoyer_raccourcis($flux):cs_deferr(\'sommaire_nettoyer_raccourcis\');
function_exists(\'couleurs_nettoyer_raccourcis\')?$flux=couleurs_nettoyer_raccourcis($flux):cs_deferr(\'couleurs_nettoyer_raccourcis\');
\";s:26:\"porte_plume_cs_pre_charger\";s:374:\"
# Copie du code utilise en eval() pour le pipeline \'porte_plume_cs_pre_charger($flux)\'
include_spip(\'outils/decoupe\');
include_spip(\'outils/blocs\');
function_exists(\'decoupe_CS_pre_charger\')?$flux=decoupe_CS_pre_charger($flux):cs_deferr(\'decoupe_CS_pre_charger\');
function_exists(\'blocs_CS_pre_charger\')?$flux=blocs_CS_pre_charger($flux):cs_deferr(\'blocs_CS_pre_charger\');
\";s:34:\"porte_plume_lien_classe_vers_icone\";s:1037:\"
# Copie du code utilise en eval() pour le pipeline \'porte_plume_lien_classe_vers_icone($flux)\'
include_spip(\'outils/decoupe\');
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
include_spip(\'outils/blocs\');
function_exists(\'decoupe_PP_icones\')?$flux=decoupe_PP_icones($flux):cs_deferr(\'decoupe_PP_icones\');
function_exists(\'decoration_PP_icones\')?$flux=decoration_PP_icones($flux):cs_deferr(\'decoration_PP_icones\');
function_exists(\'couleurs_PP_icones\')?$flux=couleurs_PP_icones($flux):cs_deferr(\'couleurs_PP_icones\');
function_exists(\'filets_PP_icones\')?$flux=filets_PP_icones($flux):cs_deferr(\'filets_PP_icones\');
function_exists(\'cs_smileys_PP_icones\')?$flux=cs_smileys_PP_icones($flux):cs_deferr(\'cs_smileys_PP_icones\');
function_exists(\'chatons_PP_icones\')?$flux=chatons_PP_icones($flux):cs_deferr(\'chatons_PP_icones\');
function_exists(\'blocs_PP_icones\')?$flux=blocs_PP_icones($flux):cs_deferr(\'blocs_PP_icones\');
\";s:10:\"pre_propre\";s:612:\"
# Copie du code utilise en eval() pour le pipeline \'pre_propre($flux)\'
include_spip(\'outils/sommaire\');
include_spip(\'outils/titres_typo\');
include_spip(\'outils/liens_orphelins\');
if(strpos($flux, \"<qu\")!==false) $flux=cs_echappe_balises(\"\", \"citations_bb_rempl\", $flux);
function_exists(\'sommaire_intertitres\')?$flux=sommaire_intertitres($flux):cs_deferr(\'sommaire_intertitres\');
function_exists(\'titres_typo_pre_typo\')?$flux=titres_typo_pre_typo($flux):cs_deferr(\'titres_typo_pre_typo\');
function_exists(\'liens_orphelins_pipeline\')?$flux=liens_orphelins_pipeline($flux):cs_deferr(\'liens_orphelins_pipeline\');
\";s:8:\"pre_typo\";s:1240:\"
# Copie du code utilise en eval() pour le pipeline \'pre_typo($flux)\'
include_spip(\'outils/toutmulti\');
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/liens_orphelins\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
include_spip(\'outils/blocs\');
if(strpos($flux, \"-\")!==false OR strpos($flux, \"*\")!==false) $flux = cs_echappe_balises(\"\", \"pucesli_remplace\", $flux);
function_exists(\'ToutMulti_pre_typo\')?$flux=ToutMulti_pre_typo($flux):cs_deferr(\'ToutMulti_pre_typo\');
function_exists(\'decoration_pre_typo\')?$flux=decoration_pre_typo($flux):cs_deferr(\'decoration_pre_typo\');
function_exists(\'couleurs_pre_typo\')?$flux=couleurs_pre_typo($flux):cs_deferr(\'couleurs_pre_typo\');
function_exists(\'interro_pre_typo\')?$flux=interro_pre_typo($flux):cs_deferr(\'interro_pre_typo\');
function_exists(\'filets_sep\')?$flux=filets_sep($flux):cs_deferr(\'filets_sep\');
function_exists(\'cs_smileys_pre_typo\')?$flux=cs_smileys_pre_typo($flux):cs_deferr(\'cs_smileys_pre_typo\');
function_exists(\'chatons_pre_typo\')?$flux=chatons_pre_typo($flux):cs_deferr(\'chatons_pre_typo\');
function_exists(\'blocs_pre_typo\')?$flux=blocs_pre_typo($flux):cs_deferr(\'blocs_pre_typo\');
\";s:10:\"bt_toolbox\";s:769:\"
# Copie du code utilise en eval() pour le pipeline \'bt_toolbox($flux)\'
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
function_exists(\'decoration_BarreTypo\')?$flux=decoration_BarreTypo($flux):cs_deferr(\'decoration_BarreTypo\');
function_exists(\'couleurs_BarreTypo\')?$flux=couleurs_BarreTypo($flux):cs_deferr(\'couleurs_BarreTypo\');
function_exists(\'filets_sep_BarreTypo\')?$flux=filets_sep_BarreTypo($flux):cs_deferr(\'filets_sep_BarreTypo\');
function_exists(\'cs_smileys_BarreTypo\')?$flux=cs_smileys_BarreTypo($flux):cs_deferr(\'cs_smileys_BarreTypo\');
function_exists(\'chatons_BarreTypo\')?$flux=chatons_BarreTypo($flux):cs_deferr(\'chatons_BarreTypo\');
\";s:29:\"porte_plume_barre_pre_charger\";s:851:\"
# Copie du code utilise en eval() pour le pipeline \'porte_plume_barre_pre_charger($flux)\'
include_spip(\'outils/decoration\');
include_spip(\'outils/couleurs\');
include_spip(\'outils/filets_sep\');
include_spip(\'outils/smileys\');
include_spip(\'outils/chatons\');
function_exists(\'decoration_PP_pre_charger\')?$flux=decoration_PP_pre_charger($flux):cs_deferr(\'decoration_PP_pre_charger\');
function_exists(\'couleurs_PP_pre_charger\')?$flux=couleurs_PP_pre_charger($flux):cs_deferr(\'couleurs_PP_pre_charger\');
function_exists(\'filets_PP_pre_charger\')?$flux=filets_PP_pre_charger($flux):cs_deferr(\'filets_PP_pre_charger\');
function_exists(\'cs_smileys_PP_pre_charger\')?$flux=cs_smileys_PP_pre_charger($flux):cs_deferr(\'cs_smileys_PP_pre_charger\');
function_exists(\'chatons_PP_pre_charger\')?$flux=chatons_PP_pre_charger($flux):cs_deferr(\'chatons_PP_pre_charger\');
\";s:9:\"post_typo\";s:330:\"
# Copie du code utilise en eval() pour le pipeline \'post_typo($flux)\'
include_spip(\'outils/typo_exposants\');
include_spip(\'outils/guillemets\');
function_exists(\'typo_exposants\')?$flux=typo_exposants($flux):cs_deferr(\'typo_exposants\');
function_exists(\'typo_guillemets\')?$flux=typo_guillemets($flux):cs_deferr(\'typo_guillemets\');
\";s:11:\"post_propre\";s:466:\"
# Copie du code utilise en eval() pour le pipeline \'post_propre($flux)\'
include_spip(\'outils/liens_orphelins\');
include_spip(\'outils/liens_en_clair\');
if(strpos($flux, \'@\')!==false) $flux=cs_echappe_balises(\'\', \'mailcrypt\', $flux);
function_exists(\'interro_post_propre\')?$flux=interro_post_propre($flux):cs_deferr(\'interro_post_propre\');
function_exists(\'liens_en_clair_post_propre\')?$flux=liens_en_clair_post_propre($flux):cs_deferr(\'liens_en_clair_post_propre\');
\";s:17:\"facteur_pre_envoi\";s:225:\"
# Copie du code utilise en eval() pour le pipeline \'facteur_pre_envoi($flux)\'
include_spip(\"public/parametrer\"); // charger mes_fonctions
$flux->Body = maildecrypt($flux->Body);
$flux->AltBody = maildecrypt($flux->AltBody);
\";s:11:\"insert_head\";s:887:\"
# Copie du code utilise en eval() pour le pipeline \'insert_head($flux)\'
include_spip(\'outils/jcorner\');
/* optimisation : \'IF(1)\' */ $flux.=\'<script src=\"\'.find_in_path(\"outils/jquery.scrollto.js\").\'\" type=\"text/javascript\"></script>\'.\"\\n\";
/* optimisation : \'IF(1)\' */ $flux.=\'<script src=\"\'.find_in_path(\"outils/jquery.localscroll.js\").\'\" type=\"text/javascript\"></script>\'.\"\\n\";
/* optimisation : \'IF(1)\' */ $flux.=\'<script src=\"\'.find_in_path(\"lib/jcorner/distant_jquery.corner.js\").\'\" type=\"text/javascript\"></script>\'.\"\\n\";
$flux.=\'<script type=\"text/javascript\" src=\"\'.generer_url_public(\'cout_dates.js\',\'lang=\'.$GLOBALS[\'spip_lang\']).\'\"></script>
<script type=\"text/javascript\" src=\"\'.find_in_path(\"outils/jquery.jclock.js\").\'\"></script>\'.\"\\n\";
cs_header_hit($flux, \'js\');
function_exists(\'jcorner_insert_head\')?$flux=jcorner_insert_head($flux):cs_deferr(\'jcorner_insert_head\');
\";s:11:\"pre_edition\";s:207:\"
# Copie du code utilise en eval() pour le pipeline \'pre_edition($flux)\'
include_spip(\'outils/moderation_moderee\');
function_exists(\'moderation_vip\')?$flux=moderation_vip($flux):cs_deferr(\'moderation_vip\');
\";s:12:\"header_prive\";s:374:\"
# Copie du code utilise en eval() pour le pipeline \'header_prive($flux)\'
$flux.=\'<script type=\"text/javascript\" src=\"\'.generer_url_public(\'cout_dates.js\',\'lang=\'.$GLOBALS[\'spip_lang\']).\'\"></script>
<script type=\"text/javascript\" src=\"\'.find_in_path(\"outils/jquery.jclock.js\").\'\"></script>\'.\"\\n\";
cs_header_hit($flux, \'css\', \'_prive\');
cs_header_hit($flux, \'js\', \'_prive\');
\";s:21:\"arbo_creer_chaine_url\";s:574:\"
# Copie du code utilise en eval() pour le pipeline \'arbo_creer_chaine_url($flux)\'
$id = $flux[\'objet\'][\'id_objet\']; $ok = true;
/* optimisation : \'IF(1)\' */ $ok = strpos(\':rubrique:auteur:\',\':\'.$flux[\'objet\'][\'type\'].\':\')===false;
/* optimisation : \'IF(1)\' */ $id = sprintf(\'%03d\', $id);
/* optimisation : \'IF(1)\' */ @define(\'_CS_URL_SEP\',\'-\'); if($ok) $flux[\'data\']=$id._CS_URL_SEP.$flux[\'data\'];
/* optimisation : \'IF(0) {@define(\'_CS_URL_SEP\',\',\'); if($ok) $flux[\'data\'].=_CS_URL_SEP.$id;\\}\' */
/* optimisation : \'IF(1)\' */ $flux[\'data\']=strtolower($flux[\'data\']);
\";s:24:\"propres_creer_chaine_url\";s:577:\"
# Copie du code utilise en eval() pour le pipeline \'propres_creer_chaine_url($flux)\'
$id = $flux[\'objet\'][\'id_objet\']; $ok = true;
/* optimisation : \'IF(1)\' */ $ok = strpos(\':rubrique:auteur:\',\':\'.$flux[\'objet\'][\'type\'].\':\')===false;
/* optimisation : \'IF(1)\' */ $id = sprintf(\'%03d\', $id);
/* optimisation : \'IF(1)\' */ @define(\'_CS_URL_SEP\',\'-\'); if($ok) $flux[\'data\']=$id._CS_URL_SEP.$flux[\'data\'];
/* optimisation : \'IF(0) {@define(\'_CS_URL_SEP\',\',\'); if($ok) $flux[\'data\'].=_CS_URL_SEP.$id;\\}\' */
/* optimisation : \'IF(1)\' */ $flux[\'data\']=strtolower($flux[\'data\']);
\";s:15:\"insert_head_css\";s:106:\"
# Copie du code utilise en eval() pour le pipeline \'insert_head_css($flux)\'
cs_header_hit($flux, \'css\');
\";}', 'oui', '2012-01-19 22:52:54');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('clevermail_base_version', '0.8', 'non', '2011-12-11 13:27:23');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_auteur', '1323606797', 'oui', '2011-12-11 13:32:59');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('notations_publics', 'oui', 'oui', '2012-01-19 23:01:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('shoutbox_base_version', '0.1', 'oui', '2012-01-19 23:22:50');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_bandeau', '', 'oui', '2012-01-20 09:05:53');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_coins', '', 'oui', '2012-01-20 09:05:53');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_layout', '', 'oui', '2012-01-20 09:05:53');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_pied', '', 'oui', '2012-01-20 09:05:53');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_styles', '', 'oui', '2012-01-20 09:05:53');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('couteau_suisse_base_version', '1.1', 'oui', '2011-12-11 13:14:51');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_accueil', 'a:1:{s:18:\"rubrique_squelette\";s:1:\"7\";}', 'oui', '2010-08-11 09:17:35');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_header', 'a:3:{s:11:\"auteur_site\";s:19:\"Jean-Paul BOURILLON\";s:16:\"recurrence_robot\";s:2:\"30\";s:13:\"keywords_site\";s:125:\"Kinomichi, Arts martiaux, Akido, Budo, Jo, Boken, Ia, Noro, Matre, enseignement, pdagogie, TICE, uvres littraires\";}', 'oui', '2010-08-11 09:44:23');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_noisettes', 'a:42:{s:28:\"modele_pagination_navigation\";s:0:\"\";s:25:\"pas_pagination_navigation\";s:2:\"10\";s:24:\"modele_pagination_filtre\";s:0:\"\";s:21:\"pas_pagination_filtre\";s:2:\"10\";s:21:\"position_publications\";s:1:\"2\";s:16:\"max_publications\";s:1:\"5\";s:21:\"position_commentaires\";s:1:\"2\";s:16:\"max_commentaires\";s:1:\"5\";s:17:\"intro_commentaire\";s:3:\"100\";s:17:\"position_messages\";s:1:\"1\";s:12:\"max_messages\";s:1:\"5\";s:13:\"intro_message\";s:3:\"100\";s:12:\"liste_breves\";s:1:\"2\";s:10:\"max_breves\";s:1:\"5\";s:11:\"intro_breve\";s:3:\"100\";s:11:\"liste_sites\";s:1:\"2\";s:9:\"max_sites\";s:1:\"5\";s:10:\"max_syndic\";s:1:\"5\";s:16:\"position_herbier\";s:1:\"0\";s:13:\"liste_herbier\";s:1:\"2\";s:11:\"max_herbier\";s:1:\"5\";s:17:\"position_rechspip\";s:1:\"3\";s:18:\"position_recherche\";s:1:\"2\";s:14:\"moteur_externe\";s:1:\"1\";s:16:\"position_stats_1\";s:1:\"1\";s:16:\"position_stats_2\";s:1:\"1\";s:19:\"composition_stats_2\";s:1:\"3\";s:16:\"max_articles_top\";s:1:\"5\";s:19:\"max_articles_hasard\";s:1:\"5\";s:15:\"position_badges\";s:1:\"1\";s:11:\"badge_xhtml\";N;s:9:\"badge_rss\";s:2:\"on\";s:11:\"badge_sarka\";N;s:10:\"badge_spip\";N;s:11:\"badge_perso\";N;s:16:\"lien_badge_perso\";s:7:\"http://\";s:21:\"infobulle_badge_perso\";s:0:\"\";s:16:\"position_annonce\";s:1:\"2\";s:14:\"position_nuage\";s:1:\"2\";s:17:\"position_rainette\";s:1:\"2\";s:14:\"rainette_ville\";s:8:\"BEXX0005\";s:18:\"rainette_prevision\";s:1:\"7\";}', 'oui', '2010-08-12 10:46:15');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gd_formats_read', 'gif,jpg,png', 'non', '2010-08-11 17:22:06');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gd_formats', 'gif,jpg,png', 'non', '2010-08-11 17:22:06');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('netpbm_formats', '', 'non', '2010-08-11 17:22:06');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('preview', ',0minirezo,1comite,', 'oui', '2010-08-11 12:36:29');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_maj', 'a:2:{i:0;i:1327009838;i:1;s:6:\"1.8.56\";}', 'oui', '2012-01-19 22:50:15');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('tweaks_maj_auto', 'a:67:{s:32:\"7fc9eb0c763c5aadff6549af60193490\";a:2:{i:0;i:1327009857;i:1;s:5:\"55814\";}s:32:\"2b5c1b630f202b617d8984f783da420a\";a:2:{i:0;i:1327009857;i:1;i:239;}s:32:\"d94d88c6b8ab5dc19c9d4871686c8660\";a:2:{i:0;i:1327009850;i:1;s:5:\"56455\";}s:32:\"dc89ecf271902d5b2e6b2e5df92fff2b\";a:2:{i:0;i:1327009850;i:1;i:239;}s:32:\"e2e8d394aa2422a4beb536b4d1b8a0d2\";a:2:{i:0;i:1327009851;i:1;s:5:\"57236\";}s:32:\"6a38d082fb922ccc3e6b949ca9dd701b\";a:2:{i:0;i:1327009851;i:1;i:239;}s:32:\"85c9be0f5f9fcd0cbc1c20085dce3a0a\";a:2:{i:0;i:1327009851;i:1;s:5:\"56798\";}s:32:\"b9fea0c5dc4e9aa81ece5395f91bdaa3\";a:2:{i:0;i:1327009851;i:1;i:237;}s:32:\"134cee965f497cf243df8e10428ec7b2\";a:2:{i:0;i:1323604842;i:1;s:5:\"52171\";}s:32:\"35e3399cf856f19924169904e68fbb82\";a:2:{i:0;i:1323604843;i:1;s:5:\"55173\";}s:32:\"593ecc74303567d51f8c264633c11c1b\";a:2:{i:0;i:1327009851;i:1;i:239;}s:32:\"4a78765cd270dc81fee51d7eceefe96e\";a:2:{i:0;i:1327009852;i:1;s:5:\"55897\";}s:32:\"a36b2523a94cf50fc0f9137fa83e5a08\";a:2:{i:0;i:1327009852;i:1;i:239;}s:32:\"3f79f0fe3e0c47ee6db171bc54fee9d2\";a:2:{i:0;i:1327009852;i:1;s:5:\"56656\";}s:32:\"96bbcbe1e927a8b2433742f8d2811a04\";a:2:{i:0;i:1327009852;i:1;i:237;}s:32:\"73cb62a3c4cf1cea9650dd7e4bc92414\";a:2:{i:0;i:1327009852;i:1;s:5:\"56932\";}s:32:\"57b2acbfc4d6bc30a1cbdb3354569cf7\";a:2:{i:0;i:1327009852;i:1;i:239;}s:32:\"bd91e4a471e0e1203e85c1c0216e7ca6\";a:2:{i:0;i:1327009853;i:1;s:5:\"56942\";}s:32:\"772d165f9e9e7f3496c61e826d208d57\";a:2:{i:0;i:1327009853;i:1;i:237;}s:32:\"4563de2a54a9ad944f57da2a202e64ef\";a:2:{i:0;i:1327009853;i:1;s:5:\"56714\";}s:32:\"baaf9415e260738662e4547c00fa959a\";a:2:{i:0;i:1327009853;i:1;i:237;}s:32:\"19fbc32177246093d2b56afeb13b8081\";a:2:{i:0;i:1327009853;i:1;s:5:\"53144\";}s:32:\"5719b33f9e5e9d4d7a3b2940a391e10f\";a:2:{i:0;i:1327009853;i:1;i:237;}s:32:\"7b789e1f0d04dc5e7f85b57e009aa3b0\";a:2:{i:0;i:1327009853;i:1;s:5:\"56488\";}s:32:\"cf6efc0a5b5bf6ae57600b4ec4b4ad40\";a:2:{i:0;i:1327009853;i:1;i:241;}s:32:\"4246204783da28b0f8a63816238ad61d\";a:2:{i:0;i:1327009854;i:1;s:5:\"57193\";}s:32:\"f6529ba59eb8b4056e60bd218927fa63\";a:2:{i:0;i:1327009854;i:1;i:239;}s:32:\"ea52d1b714f91c4563cd84ed86c3d86b\";a:2:{i:0;i:1327009854;i:1;s:5:\"55785\";}s:32:\"c2b8bad8699020052344a7b29b146302\";a:2:{i:0;i:1327009854;i:1;i:239;}s:32:\"099705015e8df1aa8807c97dd9bd1dd8\";a:2:{i:0;i:1323604845;i:1;s:5:\"40664\";}s:32:\"3e02504f0e9fcce9b40477440eec309d\";a:2:{i:0;i:1327009854;i:1;s:5:\"52097\";}s:32:\"6832e113fa6b5796cb88725b2d8caf6e\";a:2:{i:0;i:1327009854;i:1;i:237;}s:32:\"fa1fc022e2b8ca34c2885cae950801e8\";a:2:{i:0;i:1327009855;i:1;s:5:\"56497\";}s:32:\"619271442e22f5c86de95861f7458e71\";a:2:{i:0;i:1327009855;i:1;i:237;}s:32:\"c3d0c6ba9211865a264cc8af2c07d2f0\";a:2:{i:0;i:1327009855;i:1;s:5:\"53136\";}s:32:\"5a7fd1dbf8aa931ac7ed66ae6cc7951f\";a:2:{i:0;i:1327009855;i:1;i:237;}s:32:\"d4661751289b6ad331354c53ec84182e\";a:2:{i:0;i:1323604846;i:1;s:5:\"55313\";}s:32:\"f91a76f8d3bf8c8fc4c1ef8bf69e1b22\";a:2:{i:0;i:1327009855;i:1;i:238;}s:32:\"fa4f3e05b8407f2727a2b940868e3e03\";a:2:{i:0;i:1327009856;i:1;s:5:\"53773\";}s:32:\"74c8f265e334b8d030f521f2f0dd87f5\";a:2:{i:0;i:1327009856;i:1;i:239;}s:32:\"602b580ca5fb102a0009980efddfdce2\";a:2:{i:0;i:1327009856;i:1;s:5:\"55807\";}s:32:\"3e62207acf6bb32fc114792d262917bf\";a:2:{i:0;i:1327009856;i:1;i:237;}s:32:\"8e0716a100fdc2aaa2dcdb87e5aa5932\";a:2:{i:0;i:1327009856;i:1;s:5:\"57188\";}s:32:\"84ed6f01fdc414baa80e8b803121d703\";a:2:{i:0;i:1327009856;i:1;i:237;}s:32:\"da88b11e6c7576dd8258f44ca8e3b383\";a:2:{i:0;i:1327009856;i:1;s:5:\"36834\";}s:32:\"520bdd1e2e050070690076d3fb5bca3c\";a:2:{i:0;i:1327009856;i:1;i:0;}s:32:\"6f96ea7c3d0a866d4324b3ae7cba97fd\";a:2:{i:0;i:1327009857;i:1;s:5:\"56491\";}s:32:\"e9e041c69b767b52f70be570529a34f2\";a:2:{i:0;i:1327009857;i:1;i:237;}s:32:\"3bd744523dfebfd49c749054773e3bc1\";a:2:{i:0;i:1323604847;i:1;s:2:\"-1\";}s:32:\"18c737575ed5c2a56029b3e2102f7171\";a:2:{i:0;i:1327009856;i:1;i:239;}s:32:\"68c8a02b37f180ffd57c21edd5370b81\";a:2:{i:0;i:1327009857;i:1;s:5:\"56979\";}s:32:\"cd0d44510f34f98607479cdc8a98c41e\";a:2:{i:0;i:1327009857;i:1;i:238;}s:32:\"27ac4369b01daf831c3413bba19b3c88\";a:2:{i:0;i:1327009857;i:1;s:5:\"53147\";}s:32:\"f47943b78e1e2bd85b6e291ee4f16942\";a:2:{i:0;i:1327009857;i:1;i:238;}s:32:\"e0ee71a34ad145180077441746535513\";a:2:{i:0;i:1327009858;i:1;s:5:\"52439\";}s:32:\"955ba6e4d7a4ba8fe26144606c5b5bf1\";a:2:{i:0;i:1327009858;i:1;i:237;}s:32:\"f7f10bc7b3c7286cb676d15a19d4fa32\";a:2:{i:0;i:1327009857;i:1;s:5:\"54256\";}s:32:\"41dcb7e53cf046f673ce1015f8bfed42\";a:2:{i:0;i:1327009854;i:1;s:5:\"54368\";}s:32:\"d41d8cd98f00b204e9800998ecf8427e\";a:2:{i:0;i:1327009857;i:1;s:2:\"-1\";}s:32:\"1adf0810662745e5b11ea4d808ef252b\";a:2:{i:0;i:1327009851;i:1;s:5:\"56648\";}s:32:\"b0072e78429f1d26beb2bfdf9310f861\";a:2:{i:0;i:1327009855;i:1;s:5:\"56014\";}s:32:\"d43a40bb989b04182f856f780be9bd56\";a:2:{i:0;i:1327009856;i:1;s:5:\"55169\";}s:32:\"c560515c01d580278ee58e6d971af14f\";a:2:{i:0;i:1327009857;i:1;i:237;}s:32:\"48da0b7c054ca39208feaea3a7e8a2c1\";a:2:{i:0;i:1327009878;i:1;s:5:\"56455\";}s:32:\"757b83865a7b1990e4a46bc81696ecfa\";a:2:{i:0;i:1327010024;i:1;s:5:\"54019\";}s:32:\"332b9e9bdc1a6b1c1d4840c3dd092553\";a:2:{i:0;i:1327010057;i:1;s:5:\"56714\";}s:32:\"2db99daf82a3ba6ae9cf6e4cc1465020\";a:2:{i:0;i:1327010441;i:1;s:5:\"53426\";}}', 'oui', '2012-01-19 23:00:18');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_herbier', 'a:9:{s:5:\"titre\";s:0:\"\";s:10:\"descriptif\";s:0:\"\";s:6:\"modele\";s:5:\"liste\";s:19:\"modele_pagination_1\";s:0:\"\";s:16:\"pas_pagination_1\";s:1:\"0\";s:21:\"position_pagination_1\";s:1:\"3\";s:19:\"modele_pagination_2\";s:0:\"\";s:16:\"pas_pagination_2\";s:2:\"10\";s:21:\"position_pagination_2\";s:1:\"1\";}', 'oui', '2010-08-12 10:50:06');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_article', '1281985097', 'oui', '2010-08-16 20:58:18');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('popularite_max', '0.070843529211104', 'oui', '2012-01-22 02:19:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('popularite_total', '0.142027281000972', 'oui', '2012-01-22 02:19:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('date_statistiques', '2012-01-22', 'oui', '2012-01-22 02:19:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_sommaire', 'a:13:{s:13:\"article_edito\";s:1:\"1\";s:11:\"titre_edito\";s:1:\"1\";s:17:\"position_secteurs\";s:1:\"0\";s:25:\"position_articles_recents\";s:1:\"1\";s:20:\"max_articles_recents\";s:1:\"5\";s:13:\"intro_article\";s:3:\"300\";s:15:\"avec_lire_suite\";s:3:\"oui\";s:13:\"logo_rubrique\";s:3:\"oui\";s:11:\"taille_logo\";s:3:\"150\";s:23:\"position_albums_recents\";s:1:\"1\";s:18:\"max_albums_recents\";s:1:\"5\";s:15:\"album_1_colonne\";s:1:\"0\";s:11:\"intro_album\";s:3:\"200\";}', 'oui', '2010-08-11 17:16:44');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('date_popularites', '1327195169', 'oui', '2012-01-22 02:19:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('drapeau_edition', 'a:0:{}', 'non', '2012-01-19 22:47:16');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('bte', 'a:12:{s:5:\"puces\";s:3:\"Oui\";s:14:\"titraille1open\";s:17:\"<h3 class=\"spip\">\";s:15:\"titraille1close\";s:5:\"</h3>\";s:14:\"titraille2open\";s:17:\"<h4 class=\"spip\">\";s:15:\"titraille2close\";s:5:\"</h4>\";s:14:\"titraille3open\";s:17:\"<h5 class=\"spip\">\";s:15:\"titraille3close\";s:5:\"</h5>\";s:14:\"titraille4open\";s:17:\"<h6 class=\"spip\">\";s:15:\"titraille4close\";s:5:\"</h6>\";s:14:\"titraille5open\";s:32:\"<strong class=\"spip titraille5\">\";s:15:\"titraille5close\";s:9:\"</strong>\";s:9:\"insertcss\";s:3:\"Oui\";}', 'oui', '2010-08-11 17:39:24');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_syndic', '1284331905', 'oui', '2010-09-13 00:51:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_galerie', 'a:9:{s:16:\"rubrique_galerie\";s:1:\"8\";s:5:\"titre\";s:7:\"Galerie\";s:10:\"descriptif\";s:0:\"\";s:15:\"album_1_colonne\";s:1:\"0\";s:11:\"intro_album\";s:3:\"200\";s:19:\"modele_pagination_1\";s:0:\"\";s:16:\"pas_pagination_1\";s:1:\"5\";s:21:\"position_pagination_1\";s:1:\"3\";s:10:\"sens_tri_1\";s:1:\"1\";}', 'oui', '2010-08-11 17:42:20');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('sarkaspip_plugins', 'a:1:{s:16:\"config_nyroceros\";s:9:\"sarkaspip\";}', 'oui', '2010-08-11 17:49:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('nyroceros', 'a:4:{s:21:\"traiter_toutes_images\";s:3:\"non\";s:16:\"selecteur_commun\";s:10:\".nyroceros\";s:17:\"selecteur_galerie\";s:19:\".galerie .nyroceros\";s:20:\"installer_diapo_auto\";s:3:\"non\";}', 'oui', '2010-08-11 17:49:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forms_base_version', '0.42', 'non', '2011-12-11 13:25:13');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forms_et_tables', 'a:5:{s:25:\"associer_donnees_articles\";s:1:\"1\";s:26:\"associer_donnees_rubriques\";s:1:\"1\";s:24:\"associer_donnees_auteurs\";s:1:\"1\";s:12:\"bouton_image\";s:1:\"1\";s:12:\"inserer_head\";s:1:\"1\";}', 'oui', '2010-08-12 10:17:34');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp', 'non', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_auth', 'non', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_secure', 'non', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_sender', '', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_filtre_images', '0', 'oui', '2011-12-11 13:23:52');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_filtre_css', '0', 'oui', '2011-12-11 13:23:52');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_filtre_iso_8859', '1', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_adresse_envoi', 'non', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_base_version', '1.1', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('saveauto', 'a:13:{s:2:\"gz\";s:4:\"true\";s:9:\"structure\";s:4:\"true\";s:7:\"donnees\";s:4:\"true\";s:13:\"ecrire_succes\";s:4:\"true\";s:4:\"base\";s:12:\"bourillonnet\";s:10:\"jours_obso\";s:2:\"60\";s:9:\"rep_bases\";s:8:\"tmp/bckp\";s:12:\"prefixe_save\";s:9:\"saveauto_\";s:13:\"frequence_maj\";s:1:\"7\";s:17:\"destinataire_save\";s:16:\"jp@bourillon.net\";s:6:\"eviter\";s:19:\"_index;_temp;_cache\";s:13:\"mail_max_size\";s:1:\"2\";s:8:\"accepter\";s:0:\"\";}', 'oui', '2010-08-12 10:30:28');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('saveauto_base_version', '0.1.0', 'oui', '2010-08-12 10:25:57');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('saveauto_creation', '1324834880', 'oui', '2011-12-25 18:41:37');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('notation_base_version', '0.6.3', 'oui', '2012-01-19 23:01:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('a2a_base_version', '0.4', 'oui', '2012-01-19 23:01:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('accesrestreint_base_version', '0.3.0.2', 'oui', '2010-08-12 11:13:21');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('gravatar', 'a:2:{s:12:\"image_defaut\";s:9:\"identicon\";s:6:\"taille\";s:3:\"150\";}', 'non', '2012-01-19 22:48:00');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('creer_htaccess', 'oui', 'non', '2010-08-12 16:43:00');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('creer_htpasswd', 'oui', 'non', '2010-08-12 16:43:07');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('contact', 'a:9:{s:19:\"choix_destinataires\";N;s:10:\"type_choix\";s:4:\"tous\";s:1:\"c\";N;s:5:\"barre\";s:19:\"no_previsualisation\";s:12:\"autoriser_pj\";N;s:9:\"nb_max_pj\";s:1:\"1\";s:23:\"champ_civi_mademoiselle\";s:4:\"true\";s:20:\"sauvegarder_contacts\";s:4:\"true\";s:5:\"texte\";s:0:\"\";}', 'oui', '2010-08-12 16:50:32');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('crayons', 'a:9:{s:9:\"barretypo\";s:2:\"on\";s:11:\"msgNoChange\";N;s:10:\"msgAbandon\";N;s:5:\"filet\";s:2:\"on\";s:11:\"yellow_fade\";s:2:\"on\";s:9:\"clickhide\";s:2:\"on\";s:12:\"reduire_logo\";s:3:\"100\";s:11:\"espaceprive\";N;s:13:\"exec_autorise\";s:0:\"\";}', 'oui', '2010-08-12 16:51:58');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('fancybox', 'a:30:{s:16:\"selecteur_commun\";s:9:\".fancybox\";s:17:\"selecteur_galerie\";s:62:\"#documents_portfolio .fancybox, .documents_portfolio .fancybox\";s:15:\"selecteur_frame\";s:7:\".iframe\";s:7:\"padding\";s:2:\"10\";s:6:\"margin\";s:2:\"20\";s:7:\"opacity\";s:5:\"false\";s:6:\"cyclic\";s:5:\"false\";s:7:\"molette\";s:2:\"on\";s:9:\"scrolling\";s:4:\"auto\";s:5:\"width\";s:3:\"560\";s:6:\"height\";s:3:\"340\";s:9:\"autoscale\";s:4:\"true\";s:14:\"autodimensions\";s:4:\"true\";s:14:\"centeronscroll\";s:4:\"true\";s:18:\"hideonoverlayclick\";s:4:\"true\";s:18:\"hideoncontentclick\";s:4:\"true\";s:11:\"overlayshow\";s:4:\"true\";s:14:\"overlayopacity\";s:3:\"0.3\";s:12:\"overlaycolor\";s:4:\"#666\";s:9:\"titleshow\";s:4:\"true\";s:13:\"titleposition\";s:7:\"outside\";s:11:\"titleformat\";s:4:\"null\";s:12:\"transitionin\";s:4:\"fade\";s:13:\"transitionout\";s:4:\"fade\";s:7:\"speedin\";s:3:\"300\";s:8:\"speedout\";s:3:\"300\";s:11:\"changespeed\";s:3:\"300\";s:15:\"showclosebutton\";s:4:\"true\";s:13:\"shownavarrows\";s:4:\"true\";s:18:\"enableescapebutton\";s:4:\"true\";}', 'oui', '2010-08-12 16:53:21');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_password', 'lcactle', 'oui', '2011-12-11 13:22:42');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('forms_types_champs', 'a:2:{s:4:\"date\";i:1280223502;s:5:\"types\";a:3:{s:11:\"code_postal\";a:3:{s:5:\"label\";s:57:\"<multi>[fr]Code Postal[en]Postal Code[nl]Postcode</multi>\";s:5:\"match\";s:14:\"/^[0-9]{4,5}$/\";s:7:\"formate\";a:0:{}}s:5:\"heure\";a:3:{s:5:\"label\";s:40:\"<multi>[fr]Heure[en]Hour[nl]Huur</multi>\";s:5:\"match\";s:37:\"/^\\s*[1-2]?[0-9][:hH][0-5]?[0-9]\\s*$/\";s:7:\"formate\";a:0:{}}s:9:\"telephone\";a:3:{s:5:\"label\";s:76:\"<multi>[fr]T&eacute;l&eacute;phone[en]Phone Number[nl]Telefoonnummer</multi>\";s:5:\"match\";s:104:\"/^(((([\\+])|(00[.-\\s]))?([1-9]){2}[.-\\s]?[1-689][.-\\s]?)|(0[.-\\s]?[1-689][.-\\s]?))([0-9]{2}[.-\\s]?){4}$/\";s:7:\"formate\";a:1:{i:0;a:2:{s:5:\"match\";s:7:\"/[\\s]+/\";s:7:\"replace\";s:1:\".\";}}}}}', 'oui', '2010-08-13 07:32:25');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_adresse_envoi_nom', '', 'oui', '2010-08-12 17:04:52');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_adresse_envoi_email', '', 'oui', '2010-08-12 17:04:52');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_host', '', 'oui', '2010-08-12 17:04:52');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_port', '25', 'oui', '2010-08-12 17:04:52');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('facteur_smtp_username', 'platonas', 'oui', '2011-12-11 13:22:42');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('agenda_base_version', '0.23', 'non', '2012-01-19 23:01:46');
INSERT INTO `spip01_meta` (`nom`, `valeur`, `impt`, `maj`) values ('derniere_modif_forum', '1319091137', 'oui', '2011-10-20 08:12:07');

# Structure de la table spip01_mots
DROP TABLE IF EXISTS `spip01_mots`;

CREATE TABLE `spip01_mots` (
  `id_mot` bigint(21) NOT NULL auto_increment,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `id_groupe` bigint(21) NOT NULL default '0',
  `type` text NOT NULL,
  `extra` longtext,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots

# Structure de la table spip01_mots_articles
DROP TABLE IF EXISTS `spip01_mots_articles`;

CREATE TABLE `spip01_mots_articles` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_article` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_article`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_articles

# Structure de la table spip01_mots_breves
DROP TABLE IF EXISTS `spip01_mots_breves`;

CREATE TABLE `spip01_mots_breves` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_breve` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_breve`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_breves

# Structure de la table spip01_mots_documents
DROP TABLE IF EXISTS `spip01_mots_documents`;

CREATE TABLE `spip01_mots_documents` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_document` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_document`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_documents

# Structure de la table spip01_mots_evenements
DROP TABLE IF EXISTS `spip01_mots_evenements`;

CREATE TABLE `spip01_mots_evenements` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_evenement` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_mot`,`id_evenement`),
  KEY `id_evenement` (`id_evenement`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_evenements

# Structure de la table spip01_mots_forum
DROP TABLE IF EXISTS `spip01_mots_forum`;

CREATE TABLE `spip01_mots_forum` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_forum` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_forum`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_forum

# Structure de la table spip01_mots_rubriques
DROP TABLE IF EXISTS `spip01_mots_rubriques`;

CREATE TABLE `spip01_mots_rubriques` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_rubrique` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_rubrique`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_rubriques

# Structure de la table spip01_mots_syndic
DROP TABLE IF EXISTS `spip01_mots_syndic`;

CREATE TABLE `spip01_mots_syndic` (
  `id_mot` bigint(21) NOT NULL default '0',
  `id_syndic` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`id_syndic`,`id_mot`),
  KEY `id_mot` (`id_mot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_mots_syndic

# Structure de la table spip01_notations
DROP TABLE IF EXISTS `spip01_notations`;

CREATE TABLE `spip01_notations` (
  `id_notation` bigint(21) NOT NULL auto_increment,
  `objet` varchar(21) NOT NULL default '',
  `id_objet` bigint(21) NOT NULL default '0',
  `id_auteur` bigint(21) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `note` tinyint(1) NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_notation`),
  KEY `objet` (`objet`),
  KEY `id_objet` (`id_objet`),
  KEY `id_auteur` (`id_auteur`),
  KEY `ip` (`ip`),
  KEY `note` (`note`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_notations

# Structure de la table spip01_notations_objets
DROP TABLE IF EXISTS `spip01_notations_objets`;

CREATE TABLE `spip01_notations_objets` (
  `objet` varchar(21) NOT NULL default '',
  `id_objet` bigint(21) NOT NULL default '0',
  `note` double NOT NULL,
  `note_ponderee` double NOT NULL,
  `nombre_votes` bigint(21) NOT NULL,
  PRIMARY KEY  (`objet`,`id_objet`),
  KEY `objet` (`objet`),
  KEY `id_objet` (`id_objet`),
  KEY `note` (`note`),
  KEY `note_ponderee` (`note_ponderee`),
  KEY `nombre_votes` (`nombre_votes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_notations_objets

# Structure de la table spip01_petitions
DROP TABLE IF EXISTS `spip01_petitions`;

CREATE TABLE `spip01_petitions` (
  `id_article` bigint(21) NOT NULL default '0',
  `email_unique` char(3) NOT NULL default '',
  `site_obli` char(3) NOT NULL default '',
  `site_unique` char(3) NOT NULL default '',
  `message` char(3) NOT NULL default '',
  `texte` longtext NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_petitions

# Structure de la table spip01_referers
DROP TABLE IF EXISTS `spip01_referers`;

CREATE TABLE `spip01_referers` (
  `referer_md5` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `referer` varchar(255) default NULL,
  `visites` int(10) unsigned NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `visites_veille` int(10) unsigned NOT NULL default '0',
  `visites_jour` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`referer_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_referers
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('207937225632178447', '2010-08-12', 'http://www.bourillon.net/spip.php?page=herbier', '1', '2010-08-12 13:00:18', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('772899346412791154', '2010-08-12', 'http://www.google.fr/', '2', '2010-11-20 21:30:38', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('120460758535219502', '2010-08-12', 'http://www.google.fr/search?hl=fr&source=hp&q=Jean-paul+Bourrillon+&meta=&btnG=Recherche+Google', '1', '2010-08-12 16:48:02', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('110214004908378812', '2010-08-14', 'http://bourillon.name/', '4', '2010-09-13 17:03:50', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('46558788858167960', '2010-08-14', 'http://www.sitetalk-network.eu', '3', '2010-09-13 00:23:05', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('525834399832568876', '2010-08-15', 'http://www.bourillon.name/', '9', '2010-09-14 14:21:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('385494293621630219', '2010-08-24', 'http://search.freecause.com/search?ourmark=1&fr=freecause&ei=utf-8&type=61101&userid=35617859&p=bourillon', '1', '2010-08-28 08:23:57', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('347045915222796039', '2010-08-30', 'http://yandex.ru/yandsearch?text=%e3%ee%f0%ed%fb%e5+%eb%fb%e6%e8', '1', '2010-09-02 10:13:52', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('192462782551886191', '2010-08-29', 'http://www.ihre-werbung-im-internet.com', '1', '2010-09-02 10:13:52', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('323996340238861472', '2010-09-02', 'http://fr.search.yahoo.com/search;_ylt=A0oG73YlXH9MHA4BJIBjAQx.;_ylc=X1MDMjc2NjY3OQRfcgMyBGFvAzEEZnIDeWZwLXQtNzAzBGhvc3RwdmlkA3FUN0xDVW9HNzFSaVppQWRTRlZYQmd1OGJZSUxuRXhfWENVQUN6aFcEbl9ncHMDMARuX3ZwcwMxNgRvcmlnaW4Dc3JwBHF1ZXJ5A2plYW4gcGF1bCBib3VyaWxsb24Ec2', '1', '2010-09-03 15:49:02', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('669827752746107757', '2010-09-10', 'http://www.google.fr/search?hl=fr&q=bourillon+&aq=f&aqi=g4g-s1g5&aql=&oq=&gs_rfai=', '1', '2010-09-12 13:17:21', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('329191325867601119', '2010-09-09', 'http://www.2480.kbvision-info.de', '1', '2010-09-12 13:17:21', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('791579646383799787', '2010-09-12', 'http://www.hk-marketing.eu', '2', '2010-09-23 01:13:25', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('260785505542310088', '2010-09-13', 'http://www.google.com/search?q=pangnosis&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:en-US:official&client=firefox-a', '1', '2010-09-14 14:21:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('459085956923031466', '2010-09-13', 'http://www.google.be/search?hl=fr&client=firefox-a&hs=mCF&rls=org.mozilla:fr:official&&sa=X&ei=NXiOTPGCC4K64AbejMn9Cg&ved=0CBwQBSgA&q=pangnosis&spell=1', '1', '2010-09-14 14:21:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('107945104399959924', '2010-09-16', 'http://www.whoisde.de', '1', '2010-09-23 01:13:25', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1132710653721605150', '2010-09-22', 'http://www.sitetalk-generation.com', '2', '2010-11-04 11:34:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('742567711817222054', '2010-09-23', 'http://www.sitetalk-info.de', '1', '2010-09-23 01:13:25', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('780094166703480443', '2010-09-20', 'http://www.google.fr/search?hl=fr&source=hp&q=bourillon&meta=&aq=f&aqi=g5g-s1g4&aql=&oq=&gs_rfai=', '1', '2010-09-23 01:13:25', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('613041327930606168', '2010-09-17', 'http://www.google.be/search?hl=fr&q=sarka-spip+meteo+belgique&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-09-23 01:13:25', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('171189683056769833', '2010-09-27', 'http://www.google.com.my/search?q=anything&ie=utf-8', '2', '2011-10-01 13:53:26', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('290239788490601234', '2010-09-27', 'http://www.google.com/search?q=kinomichi&hl=fr&prmd=v&ei=3ZegTPrXKaKS4gbfx_HUDg&start=80&sa=N', '1', '2010-09-30 11:10:47', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('940936734610848236', '2010-10-01', 'http://yandex.ru/yandsearch?text=%f1%f3%e1%e0%f0%f3+%e8%ec%ef%f0%e5%e7%e0', '1', '2010-10-03 10:36:36', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('617140204635565888', '2010-10-03', 'http://twitter.com/platonas_fr?utm_campaign=user_discoverability&utm_medium=email&utm_source=discover', '1', '2010-10-03 19:08:37', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('83897047533711699', '2010-10-04', 'http://www.sitetalk-friends.com', '1', '2010-10-06 19:07:47', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('778499273224789519', '2010-10-04', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=bd794', '1', '2010-10-06 19:07:47', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('88498234503399134', '2010-10-03', 'http://twitter.com/platonas_fr?utm_campaign=newfollow20100823&utm_content=profile&utm_medium=email&utm_source=follow', '1', '2010-10-06 19:07:47', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('129487926547651663', '2010-10-03', 'http://twitter.com/', '9', '2011-09-11 19:52:54', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('61907456460248800', '2010-10-08', 'http://www.sitetalk-gigant.com', '2', '2010-10-21 13:45:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1098602900687244747', '2010-10-06', 'http://www.bourillon.net/spip.php?page=recherche&lang=fr&recherche=l%27ecole+des+femmes+moli%C3%A8re', '2', '2010-10-09 03:09:49', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('376285716264250909', '2010-10-07', 'http://search.myway.com/search/GGmain.jhtml?st=site&ptnrS=dr&si=&ss=sub&tpr=sbt&ptb=&searchfor=texte+de+peau+d%27%C3%A2ne+en+prose&x=55&y=15', '1', '2010-10-09 03:09:49', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('572386970458056175', '2010-10-10', 'http://www.sitetalk-revolution.com', '2', '2010-11-04 11:34:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('676965702188239203', '2010-10-10', 'http://yandex.ru/yandsearch?text=%e0%f0', '1', '2010-10-13 08:40:02', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('139135148419005110', '2010-10-12', 'http://www.google.ch/search?source=ig&hl=fr&rlz=1G1GGLQ_FRCH262&=&q=pean+d%27%C3%A2ne+prose&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-10-13 08:40:02', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('965777434099306796', '2010-10-09', 'http://www.lycee-jean-renoir.de/+mise-en-ligne-de-germinal-de-zola,065+.html', '36', '2011-05-24 22:59:04', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('669235618226412723', '2010-10-09', 'http://www.bourillon.name/spip.php?auteur1', '9', '2010-12-31 21:13:46', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('317661459749180646', '2010-10-13', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=95a4c', '1', '2010-10-21 13:45:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('982954797893553259', '2010-10-13', 'http://www.sur-la-toile.com/discussion-156715-1-ecrre-a-la-maniere-de-Zola.html', '19', '2012-01-13 01:54:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('939928141647071170', '2010-10-19', 'http://auto-loan-credit-check.maritimecarloans.com', '1', '2010-10-21 13:45:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('737014938296877396', '2010-10-20', 'http://auto-loan-bad-credit-car-loan.carapprovalnow.com', '1', '2010-10-21 13:45:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('604048572654308822', '2010-10-16', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=b90be', '1', '2010-10-21 13:45:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('743937521584925603', '2010-10-22', 'http://www.google.fr/search?hl=fr&client=firefox-a&hs=Xlu&rls=org.mozilla%3Afr%3Aofficial&q=peau+d%27ane+prose&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-10-24 13:22:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('357612463072868220', '2010-10-21', 'http://www.google.fr/search?hl=fr&rls=com.microsoft%3Afr%3AIE-SearchBox&rlz=1I7GFRD_fr&q=peau+d%27ane+prose&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-10-24 13:22:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('570915192490062528', '2010-10-21', 'http://search.conduit.com/Results.aspx?q=bourillon&ctid=CT2405725&octid=CT2405725&SearchSource=1', '1', '2010-10-24 13:22:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('126956775547959394', '2010-10-24', 'http://www.bourillon.net/spip.php?page=recherche&lang=fr&recherche=moliere+l%27ecole', '1', '2010-10-24 13:22:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('857159769907689', '2010-10-27', 'http://www.lycee-jean-renoir.de/_jean-paul-bourillon,002_.html', '6', '2011-05-15 05:50:45', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1068809609722616219', '2010-10-28', 'http://guide.opendns.com/main?url=pangnosis.bourillon.name', '1', '2010-11-04 11:34:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('605237914833832820', '2010-10-29', 'http://yandex.ru/yandsearch?text=%ea%ee%ed%f1%f2%e8%f2%f3%f6%e8%ee%ed%ed%ee%e5+%ef%f0%e0%e2%ee', '1', '2010-11-04 11:34:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('814508283190732225', '2010-11-04', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=0340b', '1', '2010-11-09 09:43:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('785976383396111047', '2010-11-04', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=9ec05', '1', '2010-11-09 09:43:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('17781792437056408', '2010-11-07', 'http://www.google.be/search?q=bourillon&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:fr:official&client=firefox-a', '1', '2010-11-09 09:43:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('533649821870560750', '2010-11-09', 'http://www.bourillon.net/spip.php?page=recherche&lang=fr&recherche=peau+d%27%C3%A2ne', '1', '2010-11-14 11:24:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('435713955248072408', '2010-11-12', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=91e39', '1', '2010-11-14 11:24:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('106116324925564526', '2010-11-16', 'http://www.bing.com/search?q=pangnosis&src=IE-SearchBox&Form=IE8SRC', '1', '2010-11-17 15:36:30', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('849164294259115837', '2010-11-16', 'http://www.bing.com/search?q=bourillon.+net&src=IE-SearchBox&Form=IE8SRC', '1', '2010-11-17 15:36:30', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('705247083325475503', '2010-11-19', 'http://www.lycee-jean-renoir.de/+mise-en-ligne-de-germinal-de-zola,065+.html?calendrier_mois=11&calendrier_annee=2000&lang=es', '1', '2010-11-20 21:30:38', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1002140702654893041', '2010-11-20', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=f9f98', '1', '2010-11-23 12:21:54', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('920708184043281199', '2010-11-22', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=cbf29', '1', '2010-11-23 12:21:54', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1069361760052924466', '2010-11-23', 'http://www.bing.com/search?q=bourillon&src=IE-SearchBox&FORM=IE8SRC', '1', '2010-11-25 10:33:54', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('48244821985290583', '2010-12-08', 'http://www.friends-talk.eu', '1', '2010-12-10 21:12:15', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('81053351963385704', '2010-12-10', 'http://yandex.ru/yandsearch?text=%ef%f0%e8%f6%e5%ef%fb+%e4%eb%ff+%eb%e5%e3%ea%ee%e2%fb%f5+%e0%e2%f2%ee%ec%ee%e1%e8%eb%e5%e9+%e1+%f3', '1', '2010-12-10 21:12:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1137520047467576802', '2010-12-10', 'http://www.google.fr/url?sa=t&source=web&cd=1&ved=0CBgQFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=peau%20d\\\'ane%20texte%20prose&ei=m_wBTbzEOcSXOoPojacB&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2010-12-10 21:12:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('921690342003907568', '2010-12-07', 'http://www.google.ch/url?sa=t&source=web&cd=8&ved=0CFEQFjAH&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=Peau%20d\\\'ane%20en%20prose%20dans%20recueil&ei=LHH-TPGLL9Ge4QaX1NS4CA&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A&sig2=J2-NSvcQ5jtkWB', '1', '2010-12-10 21:12:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('316879882903794917', '2010-12-06', 'http://www.google.fr/search?hl=fr&source=hp&q=bourillon&aq=f&aqi=g2g-s2g6&aql=&oq=&gs_rfai=', '1', '2010-12-10 21:12:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('185820364050865255', '2010-12-11', 'http://www.google.fr/search?hl=fr&client=safari&rls=en&q=BOURILLON&aq=f&aqi=g3g-s2g5&aql=&oq=&gs_rfai=', '1', '2010-12-15 00:47:10', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('528285640716789895', '2010-12-12', 'http://www.google.fr/search?q=pan+gnosis+bourillon+name+spip&channel=linkdoctor', '1', '2010-12-15 00:47:10', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('416421058695099982', '2010-12-12', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=0f733', '1', '2010-12-15 00:47:10', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('251276007651072631', '2010-12-16', 'http://www.tvolymp.com', '1', '2010-12-17 10:03:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('887739229253970721', '2010-12-15', 'http://www.google.ca/url?sa=t&source=web&cd=1&ved=0CBcQFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=peau%20d\\\'ane%20prose&ei=UwEITayhOcH-8AaO5Lm5Bg&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2010-12-17 10:03:18', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('547178981552137669', '2010-12-17', 'http://www.google.fr/search?hl=fr&source=hp&q=bourillon&aq=f&aqi=g4g-s1g1g-s1g3&aql=&oq=&gs_rfai=', '1', '2010-12-17 10:03:18', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1100301477482900614', '2010-12-17', 'http://www.google.fr/search?q=peau+d%27%C3%A2ne+texte+prose&safe=vss&safe=vss&safe=vss&hl=fr&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-12-20 11:43:04', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1002436357885149813', '2010-12-17', 'http://www.google.fr/search?hl=fr&source=hp&q=peau+ane+texte+prose&meta=&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-12-20 11:43:04', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1033554463272726064', '2010-12-20', 'http://www.bourillon.net/spip.php?page=recherche&lang=fr&recherche=TEXTE+RIQUET+A+LA+HOUPPE', '1', '2010-12-21 16:33:07', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('300199221995105434', '2010-12-20', 'http://www.bourillon.net/spip.php?page=recherche&lang=fr&recherche=TEXTE+RIQUET+A+LA+HOUPPE+17+SIECLE', '2', '2010-12-21 16:33:07', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('142593783439485764', '2010-12-27', 'http://www.google.fr/search?sourceid=navclient&hl=fr&ie=UTF-8&rlz=1T4GGIH_frFR211__212&q=peau+d%27ane+texte+prose', '1', '2010-12-29 02:46:33', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('679932719763353691', '2010-12-29', 'http://www.google.fr/search?hl=fr&rlz=1R2GGIE_fr&q=peau+d%C3%A2ne+texte+en+prose&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2010-12-29 06:51:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('701752507985764281', '2010-12-30', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=b8f18', '1', '2010-12-31 21:13:46', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('139056368733003267', '2011-01-06', 'http://www.google.fr/search?hl=fr&rlz=1T4GGLL_frFR397FR398&q=peau+d%27ane+r%C3%A9cit+en+prose&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2011-01-06 19:43:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('980188972563385116', '2011-01-01', 'http://www.paybox.me/r/web2design', '3', '2011-01-24 19:36:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('248875220488465890', '2011-01-01', 'http://www.google.fr/url?sa=t&source=web&cd=1&ved=0CBgQFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=Peau%20d\\\'Ane%20texte%20en%20prose&ei=n1kfTYCSMc648gP_p4jxBQ&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2011-01-06 19:43:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('315928286507480774', '2011-01-02', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=83ce0', '1', '2011-01-06 19:43:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('773485132765132284', '2011-01-08', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=235a2', '1', '2011-01-08 12:57:23', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('985842894544851580', '2011-01-09', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=9b96a', '1', '2011-01-09 15:24:31', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('296931221222608389', '2011-01-08', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=e8dd7', '1', '2011-01-09 15:24:31', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1133530998461777203', '2011-01-08', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=43892', '1', '2011-01-09 15:24:31', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('371795912208587264', '2011-01-09', 'http://www.google.fr/url?sa=t&source=web&cd=1&ved=0CBgQFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=peau%20d\\\'ane%20en%20prose&ei=fTUqTei3BsS38QPQkuzAAg&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2011-01-10 20:07:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('896417035728167518', '2011-01-09', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=3d1f4', '1', '2011-01-10 20:07:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('519883676089222529', '2011-01-10', 'http://www.google.fr/search?aq=f&sourceid=chrome&ie=UTF-8&q=style+de+vignette', '1', '2011-01-11 09:52:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('730727855137650166', '2011-01-10', 'http://www.google.fr/search?client=safari&rls=en&q=LE+PORTRAIT+OVALE+DE+POE&ie=UTF-8&oe=UTF-8&redir_esc=&ei=Z1grTcPsFs-RswaFgbWwAg', '1', '2011-01-11 09:52:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('50824390211565850', '2011-01-11', 'http://www.google.fr/search?sourceid=navclient&hl=fr&ie=UTF-8&rlz=1T4SUNA_frFR311FR205&q=peu+d+ane+en+prose', '1', '2011-01-11 09:52:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('47418058257751504', '2011-01-11', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=7865c', '1', '2011-01-11 15:40:32', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('220211680555734069', '2011-01-11', 'http://www.linkedin.com/profile/view?id=37199901&snapshotID=29938569&authType=name&authToken=1XMm&trk=EML_nus_prof-F8', '1', '2011-01-11 15:40:32', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('283841471174848628', '2011-01-11', 'http://www.google.fr/search?hl=fr&q=poe+le+portrait+ovale+analyse&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2011-01-12 17:54:12', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('242336350585185154', '2011-01-11', 'http://www.google.fr/search?hl=fr&rls=com.microsoft%3Afr%3AIE-SearchBox&rlz=1I7RNTN_fr&q=texte+peau+d%27%C3%A2ne+en+prose&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2011-01-12 17:54:12', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('13772650281870511', '2011-01-11', 'http://www.kinomichi-muenchen.de/ecrire/?exec=statistiques_visites', '1', '2011-01-12 17:54:12', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('454248341242356421', '2011-01-11', 'http://translate.googleusercontent.com/translate_c?hl=fr&langpair=fr%7Car&u=http://www.lycee-jean-renoir.de/%2Bmise-en-ligne-de-germinal-de-zola,065%2B.html&rurl=translate.google.co.ma&usg=ALkJrhh8Hz2JCodccy8yvY06hxUbhdBhJQ', '1', '2011-01-12 17:54:12', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('807902098232247465', '2011-01-13', 'http://www.google.fr/search?q=edgar+allan+poe+le+portrait+ovale+analyse&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:fr:official&client=firefox-a', '1', '2011-01-13 22:53:45', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('883571702897795173', '2011-01-12', 'http://www.google.fr/search?hl=fr&rlz=1G1SVEA_FRFR414&q=analyse+du+portrait+ovale+de+poe&aq=f&aqi=&aql=&oq=&gs_rfai=', '1', '2011-01-13 22:53:45', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('377768558639445736', '2011-01-12', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=4e41f', '1', '2011-01-13 22:53:45', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('116653727309102887', '2011-01-14', 'http://www.google.com/search?hl=fr&source=hp&biw=1024&bih=578&q=edgar+poe+le+portrait+ovale&aq=8&aqi=g10&aql=&oq=Edgar+Po', '1', '2011-01-15 00:51:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('361885559506183481', '2011-01-14', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=d927c', '1', '2011-01-15 00:51:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('924377926097900370', '2011-01-13', 'http://www.linkedin.com/profile/view?id=37199901&authType=name&authToken=1XMm&goback=%2Eanp_9_1294956205861_1', '1', '2011-01-15 00:51:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('926556838202425423', '2011-01-13', 'http://www.linkedin.com/profile/edit?trk=hb_tab_pro_top', '2', '2011-01-22 01:56:44', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('696967505546494117', '2011-01-15', 'http://www.linkedin.com/profile/view?id=37199901&authType=name&authToken=bxwm&invAcpt=42402314_I1036715076_3&goback=%2Emid_I1036715076*43', '1', '2011-01-15 12:49:32', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1075759863101815382', '2011-01-15', 'http://yandex.ru/yandsearch?text=Vous+avez+demand+%88', '1', '2011-01-15 12:49:32', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('528160677235905661', '2011-01-15', 'http://fr.mg40.mail.yahoo.com/dc/blank.html?bn=555&.intl=fr&.lang=fr-FR', '1', '2011-01-15 12:49:32', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('597309542908169952', '2011-01-16', 'http://to-be-on-top.de/web2design', '3', '2011-01-26 14:49:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('428495607187750591', '2011-01-16', 'http://www.google.fr/url?sa=t&source=web&cd=5&sqi=2&ved=0CDwQFjAE&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=analyse%20de%20portrait%20ovale%20de%20edgar%20allan%20poe&ei=g0ozTeGtL4aSswacnp2eCg&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2', '1', '2011-01-17 00:33:58', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('446443761571243967', '2011-01-16', 'http://www.google.fr/url?sa=t&source=web&cd=5&sqi=2&ved=0CEAQFjAE&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=%C3%A9tude%20portrait%20ovale%20de%20edgar%20allan%20poe&ei=41QzTcGXKoaLswa5kPmfCg&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A&', '1', '2011-01-17 00:33:58', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('838262524571243139', '2011-01-16', 'http://www.denezhki.com/', '7', '2011-01-17 00:33:58', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('747825146302669148', '2011-01-17', 'http://www.google.fr/url?sa=t&source=web&cd=1&ved=0CBgQFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=peau%20d\\\'%C3%A2ne%20prose&ei=eXA0TYfsIJGKhQefrbTrCw&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2011-01-17 19:07:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('286930853399129989', '2011-01-17', 'http://www.google.fr/url?sa=t&source=web&cd=7&ved=0CEwQFjAG&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=r%C3%A9sum%C3%A9%20le%20portrait%20ovale&ei=MXw0TaGzD5GUjAel9ZHaCg&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A&sig2=deYJaRt9ExW1WpBuU', '1', '2011-01-17 19:07:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('458683803326580519', '2011-01-17', 'http://www.google.fr/search?hl=fr&client=firefox-a&hs=E9&rls=org.mozilla%3Afr%3Aofficial&q=le+portrait+oval+poe&aq=f&aqi=g1&aql=&oq=', '1', '2011-01-17 19:07:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('695916264055906857', '2011-01-17', 'http://www.google.fr/url?sa=t&source=web&cd=4&ved=0CDEQFjAD&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=edgar%20allan%20poe%20le%20portrait%20ovale&ei=_oQ0TervI9OQjAeuopnWCg&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A&sig2=Hn2AFAqr2a7kju', '1', '2011-01-22 01:56:44', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('385513576526459877', '2011-01-19', 'http://www.google.fr/url?sa=t&source=web&cd=7&ved=0CD8QFjAG&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=le%20portrait%20ovale%20poe&ei=t642TZGKEI-z8QPDg6W-Aw&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2011-01-22 01:56:44', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('930307211006512193', '2011-01-20', 'http://www.google.fr/search?hl=fr&source=hp&q=portrait+ovale+edgar+allan+poe&meta=&aq=2&aqi=g10&aql=&oq=portrait+ovale', '1', '2011-01-22 01:56:44', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('449991275472375947', '2011-01-24', 'http://www.google.fr/search?q=le+portrait+ovale&hl=fr&client=firefox-a&hs=Rgh&rls=org.mozilla:fr:official&prmd=ivns&ei=g3o9TcyjM4ah8QO-ruHpCA&start=10&sa=N', '1', '2011-01-24 19:36:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('602132949023114178', '2011-01-24', 'http://www.bourillon.net/spip.php?page=recherche&recherche=le+portrait+ovale', '2', '2011-02-02 09:14:19', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('14914453348410245', '2011-01-24', 'http://www.bourillon.net/spip.php?page=recherche&recherche=Edgar+poe', '1', '2011-01-24 19:36:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('102172758488788969', '2011-01-23', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=88dd5', '1', '2011-01-24 19:36:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('15848047676227704', '2011-01-23', 'http://www.google.fr/url?sa=t&source=web&cd=1&ved=0CB4QFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=edgar%20poe%20portait%20ovale&ei=55w8TbORHsSg8QPN0e29CA&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A&sig2=ObsiylI52eYdXMBnxwYQ9g', '1', '2011-01-24 19:36:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('589901658457990219', '2011-01-25', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=47be4', '1', '2011-01-26 14:49:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('40613627139621621', '2011-01-25', 'http://www.google.fr/url?sa=t&source=web&cd=1&ved=0CBgQFjAA&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=texte%20peau%20d\\\'%C3%A2ne%20prose&ei=Ar8-TY_9CYql8QOG0vmZCA&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2011-01-26 14:49:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('175233029010891771', '2011-01-24', 'http://www.google.ch/url?sa=t&source=web&cd=2&ved=0CCAQFjAB&url=http%3A%2F%2Fwww.bourillon.name%2Fspip.php%3Farticle45&rct=j&q=le%20portrait%20ovale%20edgar%20allan%20poe%20analyse&ei=pMY9TY3TMYyq8AOrk9ztCA&usg=AFQjCNHMyP4rrPLsu8P5LX7HCvdykQtr2A', '1', '2011-01-26 14:49:13', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('446090654459371728', '2011-01-28', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=fc4dd', '1', '2011-01-29 06:04:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('626278698033892429', '2011-01-27', 'http://web2design.myprivatetrade.com', '1', '2011-01-29 06:04:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('540257526255917669', '2011-01-27', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=6b012', '1', '2011-01-29 06:04:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1035641293597011774', '2011-01-31', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=8656b', '1', '2011-01-31 22:28:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('685551390291279373', '2011-01-30', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=5123b', '1', '2011-01-31 22:28:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('240963256450661995', '2011-01-31', 'http://webcache.googleusercontent.com/search?q=cache:8tD7kTuxot8J:www.bourillon.name/spip.php%3Farticle45+poe,+le+portrait+oval&cd=7&hl=fr&ct=clnk&gl=fr&client=safari&source=www.google.fr', '1', '2011-02-02 09:14:19', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1028184041567625831', '2011-02-02', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=3f148', '1', '2011-02-03 18:21:08', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('268689410784606896', '2011-02-03', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=c916d', '1', '2011-02-04 02:17:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('835002003880159493', '2011-02-03', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=867fa', '1', '2011-02-04 02:17:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1058384158311918812', '2011-02-03', 'http://ac.toolbarhome.com/search.aspx?q=pension%20bourgeoise&srch=eac&si=3104&bi=4948172&bounce=true&cc=FR', '1', '2011-02-04 02:17:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('115981136952247492', '2011-02-03', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=25286', '1', '2011-02-04 02:17:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('584749354421657533', '2011-02-04', 'http://www.google.fr/search?aq=1&oq=le+portrait+oval+de&sourceid=chrome&ie=UTF-8&q=le+portrait+oval+de+edgar+allan+poe', '1', '2011-02-06 13:44:21', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('199624302449603273', '2011-02-07', 'http://www.google.be/search?sourceid=navclient&hl=fr&ie=UTF-8&rlz=1T4MEDC_frBE340BE340&q=r%c3%a9sum%c3%a9+le+portrait+ovale', '1', '2011-02-08 22:47:15', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1126236686477636474', '2011-02-09', 'http://www.google.fr/search?sourceid=navclient&hl=fr&ie=UTF-8&rlz=1T4GGLL_frFR398FR398&q=peau+d%27ane+texte+en+prose', '1', '2011-02-10 16:00:22', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('536354273975997832', '2011-02-08', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=42e65', '1', '2011-02-10 16:00:22', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('186009799819657937', '2011-02-13', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=3cec6', '1', '2011-02-14 22:29:06', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1025406037129423429', '2011-02-15', 'http://www.google.fr/search?hl=fr&client=safari&rls=en&&sa=X&ei=wZNaTdChL-OAhAfN5KzRDQ&ved=0CF8QBSgA&q=r%C3%A9sum%C3%A9+le+portrait+ovale+poe&spell=1', '1', '2011-02-15 20:16:14', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('873754878093733251', '2011-02-15', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=e9ddb', '1', '2011-02-17 10:46:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('727035663508382637', '2011-02-17', 'http://www.google.fr/search?sourceid=navclient&aq=35h&oq=&hl=fr&ie=UTF-8&rlz=1T4SNYK_frBE288BE288&q=kinomichi+belgique', '1', '2011-02-18 17:23:29', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('825708471979681558', '2011-02-17', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=6c845', '1', '2011-02-18 17:23:29', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('29523178607801916', '2011-02-19', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=e096f', '1', '2011-02-20 17:55:07', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('637901879575753771', '2011-02-18', 'http://www.google.fr/search?hl=fr&client=firefox-a&hs=RE9&rls=org.mozilla%3Afr%3Aofficial&channel=s&q=le+portrait+ovale+edgar+poe+analyse&aq=f&aqi=&aql=&oq=', '1', '2011-02-20 17:55:07', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('52438705692425803', '2011-02-20', 'http://www.google.fr/search?client=safari&rls=en&q=edgar+poe+le+portrait+ovale+analyse&ie=UTF-8&oe=UTF-8&redir_esc=&ei=TkdhTbaoJMmp8APF28hZ', '1', '2011-02-20 19:06:44', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('230615725978061810', '2011-02-20', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=aa635', '1', '2011-02-21 22:44:16', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1087655011533275804', '2011-02-23', 'http://www.google.ca/search?q=le+portrait+ovale&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:fr:official&client=firefox-a', '1', '2011-02-23 15:29:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('891783620256718392', '2011-02-23', 'http://www.google.ca/search?hl=fr&client=firefox-a&hs=2Zu&rls=org.mozilla%3Afr%3Aofficial&q=le+portrait+ovale&aq=f&aqi=g10&aql=&oq=', '1', '2011-02-23 15:29:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('141607622934865823', '2011-02-22', 'http://www.google.fr/search?hl=fr&source=hp&q=le+portrait+ovale+de+poe+r%C3%A9sum%C3%A9&meta=&btnG=Recherche+Google', '1', '2011-02-23 15:29:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('363521002025912596', '2011-02-21', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=b8175', '1', '2011-02-23 15:29:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('676959186646995157', '2011-02-23', 'http://www.google.ca/search?hl=fr&client=safari&rls=en&q=portrait+ovale+edgar+poe&aq=1&aqi=g10&aql=&oq=portrait+oval', '1', '2011-02-24 23:18:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1111507133846035930', '2011-02-23', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=0b19f', '1', '2011-02-24 23:18:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('805999671146400342', '2011-02-23', 'http://www.google.fr/search?hl=fr&client=firefox-a&hs=tsv&rls=org.mozilla%3Afr%3Aofficial&q=edgar+poe+le+portrait+ovale+analyse&aq=0&aqi=g1&aql=&oq=edgar+poe+le+portrait+ovale+ana', '1', '2011-02-24 23:18:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('918368315596676068', '2011-03-01', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=a597b', '1', '2011-03-02 12:58:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('63357191788230969', '2011-03-01', 'http://www.google.fr/search?sourceid=navclient&aq=0h&oq=p&hl=fr&ie=UTF-8&rlz=1T4SUNC_frFR361FR361&q=portrait+ovale+poe', '1', '2011-03-02 12:58:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('81958263333936708', '2011-03-02', 'http://www.google.com/search?q=edgar+allan+poe+le+portrait+ovale&hl=fr&safe=vss&client=firefox-a&hs=FRZ&rls=org.mozilla:fr:official&prmd=ivnso&ei=hbFuTbTvOJGyvgP86fm9AQ&start=10&sa=N', '1', '2011-03-06 10:42:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('537407367156441791', '2011-03-02', 'http://www.linkedin.com/pub/jean-paul-bourillon/10/55b/879', '2', '2011-03-06 10:42:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('569104626288369887', '2011-03-06', 'http://yandex.ru/yandsearch?text=Structure+des+m+tamorphoses+d', '2', '2011-03-10 00:26:00', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1152198120923065508', '2011-03-09', 'http://www.google.fr/search?q=moralit%C3%A9+de+peau+d%27ane&hl=fr&client=firefox-a&rls=org.mozilla:fr:official&prmd=ivns&ei=tG13TcDTAsmbhQf58ez9Bg&start=10&sa=N', '1', '2011-03-10 00:26:00', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('634013581958682869', '2011-03-07', 'http://www.bourillon.name', '3', '2011-09-11 19:52:54', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('852081080391531151', '2011-03-06', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=b191c', '1', '2011-03-10 00:26:00', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('545629236702610551', '2011-03-14', 'http://yandex.ru/yandsearch?text=Le+but+de+cette+rubrique', '2', '2011-03-16 03:06:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1131001519410651845', '2011-03-11', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=ce7fd', '1', '2011-03-16 03:06:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('94776252942651400', '2011-03-16', 'http://www.google.fr/search?hl=fr&rlz=1W1DVXA_fr&q=peau+d%27%C3%A2ne+conte+en+proses&aq=f&aqi=&aql=&oq=', '1', '2011-03-18 11:42:40', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('88874544143629765', '2011-03-17', 'http://www.google.fr/search?q=texte+de+peau+d%27ane+prose&rls=com.microsoft:fr:IE-SearchBox&ie=UTF-8&oe=UTF-8&sourceid=ie7&rlz=1I7SKPB_fr', '1', '2011-03-18 11:42:40', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('763414977733241441', '2011-03-18', 'http://aolrecherche.aol.fr/aol/search?s_it=aolfr-homePage&q=bourillon&rp=', '1', '2011-03-21 17:38:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('512754741554589012', '2011-03-18', 'http://www.facebook.com/l.php?u=http%3A%2F%2Fwww.bourillon.name%2F&h=26b52', '1', '2011-03-21 17:38:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('784231570481743681', '2011-03-21', 'http://www.google.fr/search?hl=fr&rls=com.microsoft%3Afr%3AIE-ContextMenu&rlz=1I7ADBF_fr&q=Jean-Paul+Bourrillon+lyon&btnG=Rechercher&aq=f&aqi=&aql=&oq=', '1', '2011-03-23 01:43:58', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('74727975234200407', '2011-03-22', 'http://www.google.fr/search?hl=&q=vocabulaire+du+printemps+en+ce2&sourceid=navclient-ff&rlz=1B3GGLL_fr___FR379&ie=UTF-8', '1', '2011-03-23 01:43:58', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('682733784577015777', '2011-03-22', 'http://www.google.fr/search?hl=fr&rlz=1T4GGHP_frFR424&sa=X&ei=4g6JTdz4IJOXhQeKvP2-Dg&ved=0CBoQvgUoAA&q=r%C3%A9sum%C3%A9+histoire+vraie+guy+de+mapassant&nfpr=1', '1', '2011-03-23 01:43:58', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('398780893656432706', '2011-03-23', 'http://www.google.fr/search?q=le+portrait+ovale+edgar+allan+poe&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:fr:official&client=firefox-a', '1', '2011-03-24 00:45:43', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('929534392959610110', '2011-03-23', 'http://www.google.fr/search?hl=fr&rls=com.microsoft%3Afr%3AIE-SearchBox&rlz=1I7ACPW_frFR395FR395&q=texte+peau+d%27ane+prose&aq=f&aqi=&aql=&oq=', '1', '2011-03-24 00:45:43', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('330039023521929501', '2011-03-23', 'http://www.google.fr/search?sourceid=navclient&aq=0h&oq=peau+d%27&hl=fr&ie=UTF-8&rlz=1T4ACPW_fr___FR395&q=peau+d%27ane+prose', '1', '2011-03-24 00:45:43', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('794807054642332718', '2011-03-24', 'http://www.google.fr/search?q=texte+peau+d%27%C3%A2ne+en+prose+1781&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:fr:official&client=firefox-a', '1', '2011-03-26 01:06:28', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1014574155246873130', '2011-03-24', 'http://www.bourillon.net/spip.php?page=recherche&recherche=peau+d%27%C3%A2ne', '1', '2011-03-26 01:06:28', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('442215290279780764', '2011-03-30', 'http://www.google.fr/search?hl=fr&client=firefox-a&hs=1fx&rls=org.mozilla:fr:official&sa=X&ei=iESTTd2oBYKYhQeenIWkDw&ved=0CBgQvwUoAQ&q=le+portrait+oval+sch%C3%A9ma+narratif&spell=1', '1', '2011-03-31 23:02:23', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('206605259003903414', '2011-03-29', 'http://www.linkedin.com/profile/view?id=37199901&pid=45616641&authType=name&authToken=1XMm&goback=%2Ebcc_111740077_1_*1_*1_*1_*1_*1&trk=pbmap', '1', '2011-03-31 23:02:23', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('941970311356673652', '2011-04-03', 'http://www.google.fr/search?q=bourillon&ie=UTF-8&oe=UTF-8&hl=fr&client=safari', '1', '2011-04-04 04:57:14', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1084151379813822342', '2011-04-07', 'http://www.linkedin.com/profile/view?id=37199901&snapshotID=30854107&authType=name&authToken=1XMm&goback=%2Enmp_*1_*1_*1_*1_*1_*1&trk=NUS_PROF-nw_pos', '1', '2011-04-07 17:30:20', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('640662531894235024', '2011-04-07', 'http://www.google.ca/search?hl=fr&sa=X&ei=ecKdTdyKEcrz0gGl4MW6BA&ved=0CBcQvwUoAQ&q=le+portrait+ovale&spell=1', '1', '2011-04-07 17:30:20', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('49851060548497888', '2011-04-07', 'http://www.linkedin.com/profile/view?id=37199901&goback=%2Enmp_*1_*1_*1_*1_*1_*1%2Enpv_37944879_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1%2Ebcc_37944879_1_*1_*1_*1_*1_*1', '1', '2011-04-10 02:47:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('880302512595026184', '2011-04-07', 'http://www.google.fr/search?q=vocabulaire+printempes+ce2&ie=utf-8&oe=utf-8&aq=t&rls=com.yahoo:fr:official&client=firefox', '1', '2011-04-10 02:47:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('625488716848888100', '2011-04-07', 'http://www.google.fr/search?hl=fr&rls=com.microsoft%3Aen-US&rlz=1I7ADSA_fr&q=edgar+poe+le+portrait+ovale+analyse&aq=8&aqi=g10&aql=&oq=edgar+poe+le+', '1', '2011-04-10 02:47:53', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('358211619095783986', '2011-04-11', 'http://www.google.fr/m/search?pbx=1&aq=f&oq=&aqi=-k0d0t0&fkt=1882&fsdt=22344&htf=&his=&q=histoire+vraie+guy+de+maupassant+fait+divers+ou+fiction', '1', '2011-04-12 16:25:43', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('515592420277140668', '2011-04-18', 'http://www.google.fr/search?q=analyse+psychologique+portrait+ovale+de+poe&rls=com.microsoft:fr:IE-SearchBox&ie=UTF-8&oe=UTF-8&sourceid=ie7&rlz=1I7SKPB_fr', '1', '2011-04-24 18:35:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('860650284397667476', '2011-04-26', 'http://www.google.ca/search?q=le+portrait+ovale&rls=com.microsoft:fr-ca&ie=UTF-8&oe=UTF-8&startIndex=&startPage=1&redir_esc=&ei=5eq2TfeHNsy_gQeXwv16', '1', '2011-04-26 19:00:26', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('281407196146273503', '2011-04-26', 'http://www.google.com/search?client=ubuntu&channel=fs&q=jean-paul+bourillon&ie=utf-8&oe=utf-8', '1', '2011-04-26 19:00:26', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1142618261684490928', '2011-04-26', 'http://be.linkedin.com/pub/jean-paul-bourillon/10/55b/879', '1', '2011-04-26 19:00:26', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1027073201842126677', '2011-04-26', 'http://fr.mg40.mail.yahoo.com/dc/blank.html?bn=559&.intl=fr&.lang=fr-FR', '1', '2011-04-26 19:00:26', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('264931315510001499', '2011-05-01', 'http://www.lycee-jean-renoir.de/ecrire/?exec=breves_voir&id_breve=65', '1', '2011-05-01 17:50:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('618123359400732566', '2011-05-08', 'http://www.designs-studio.com', '3', '2011-10-30 14:21:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('374255813584844194', '2011-05-10', 'http://dom-v-anape.ru/', '1', '2011-05-10 19:27:18', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1025023400539286941', '2011-05-12', 'http://www.bourillon.net/spip.php?page=recherche&recherche=l%27%C3%A9clairage+f%C3%A9erique+du+magasin', '1', '2011-05-12 16:54:49', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('503771321522093717', '2011-05-12', 'http://www.bourillon.net/spip.php?page=recherche&recherche=Au+bonheur+des+damesu+magasin', '1', '2011-05-12 16:54:49', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('118214362137314192', '2011-05-22', 'http://www.google.fr/search?hl=fr&client=safari&rls=en&sa=X&ei=3C7ZTeP3A5So8AP-z_2DBQ&ved=0CB0QvwUoAQ&q=r%C3%A9sum%C3%A9+des+histoires+vrais+de+maupassant&spell=1', '1', '2011-05-24 22:59:04', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('686907915275841933', '2011-05-23', 'http://www.google.be/search?q=extraits+de+zola&hl=fr&client=firefox-a&hs=PnF&rls=org.mozilla:fr:official&prmd=ivns&ei=tKLaTeylNsigOvuyueEP&start=10&sa=N&biw=1403&bih=613', '1', '2011-05-24 22:59:04', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('568839665281279372', '2011-05-24', 'http://www.linkedin.com/profile/view?id=37199901&goback=%2Enpv_48432347_*1_*1_*1_*1_*1_fr*4FR_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1_*1%2Ebcc_48432347_1_*1_*1_*1_*1_*1', '1', '2011-05-24 22:59:04', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('691774394736621915', '2011-05-25', 'http://www.google.fr/search?q=le%20portrait%20oval%20edgar%20allan%20poe&ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:fr:official&client=firefox-a&source=hp&channel=np', '1', '2011-05-27 19:13:24', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('678241680688377520', '2011-05-30', 'http://www.google.be/search?hl=fr&client=firefox-a&hs=Fnk&rls=org.mozilla%3Afr%3Aofficial&biw=1600&bih=755&q=texte+en+prose+peau+d%27%C3%A2ne+gallica&oq=texte+en+prose+peau+d%27%C3%A2ne+gallica&aq=f&aqi=&aql=&gs_sm=e&gs_upl=2227l3315l0l8l8l0l7l0l0l92l92l1', '1', '2011-06-05 22:26:36', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1068377339986522558', '2011-06-08', 'http://www.pearltrees.com/', '4', '2011-12-19 19:04:46', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('81771452990802778', '2011-07-10', 'http://moskva.tiu.ru/p1486228-kosmetika-lechebnaya-gel-kollagenovyj-dlya-problemnoj-kozhi-30ml-emanal.html', '1', '2011-07-10 11:02:42', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('887733554445337976', '2011-07-11', 'http://moskva.tiu.ru/p1516162-zenslim.html', '1', '2011-07-18 10:07:47', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('749392116501329562', '2011-08-02', 'http://www.bing.com/search?q=kinomichi&src=IE-SearchBox&lf=1&first=11&FORM=PERE', '1', '2011-08-16 19:24:38', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('651649433957568178', '2011-07-28', 'http://www.whirpoolduet9400.info/', '1', '2011-08-16 19:24:38', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('563948355869045747', '2011-08-24', 'http://www.lycee-jean-renoir.de/spip.php?page=herbier', '1', '2011-09-07 14:50:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('710385738018070408', '2011-08-30', 'http://www.linkedin.com/profile/view?id=37199901&goback=%2Efps_PBCK_angelika+kurz_*1_*1_*1_*1_*1_*1_*2_*1_Y_*1_*1_*1_false_1_R_true_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2_*2%2Enpe_*1_*1_*1_*1_*1_*1%2Enpc_64725713_*1_*1_*1', '1', '2011-09-07 14:50:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('287766468306681687', '2011-09-06', 'http://www.pearltrees.com/s/login/token/1323fc0835a.4a383.27a31325f59b406dc9d95735ed231944.ad52163dc2d2a1b192ed0b128eb90a7d', '1', '2011-09-07 14:50:11', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('855974093545197754', '2011-09-12', 'http://www.google.com/url?sa=D&q=http://www.bourillon.name/&usg=AFQjCNG3E8Nveps8nwdUPrHgtf0pJELGMA', '3', '2012-01-06 18:08:03', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('471558112399336489', '2011-09-17', 'http://search.babylon.com/?s=web&babsrc=browsersearch&q=Le%2Bcolonel%2Bchabert&start=130', '1', '2011-09-24 23:54:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1086155369526776851', '2011-09-25', 'http://www.bourillon.net/spip.php?page=recherche&recherche=', '1', '2011-09-28 14:36:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('540289537145789031', '2011-09-25', 'http://www.bourillon.net/spip.php?page=recherche&recherche=gueux', '1', '2011-09-28 14:36:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1091241772839172328', '2011-09-25', 'http://www.bourillon.name/spip.php?article47/wp-login.php', '1', '2011-09-28 14:36:17', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('349390402532823858', '2011-09-30', 'http://dumas.ccsd.cnrs.fr/docs/00/43/94/51/PDF/Rigaud_M._memoire.pdf', '2', '2012-01-17 19:47:49', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('995802200713286471', '2011-09-30', 'http://www.bourillon.net/spip.php?page=recherche&recherche=peau+d%27ane', '1', '2011-10-01 13:53:26', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('906702396647131935', '2011-10-01', 'http://www.bourillon.net/spip.php?page=recherche&recherche=claude+gueux', '3', '2011-10-09 19:29:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('758559931919384427', '2011-10-06', 'http://www.bourillon.net/spip.php?page=recherche&recherche=claude', '1', '2011-10-09 19:29:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('746377102277949434', '2011-10-13', 'http://be.bing.com/search?q=pangnosis.bourilon.net&src=IE-SearchBox&FORM=IE8SRC', '1', '2011-10-15 12:22:55', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('1143252085497598303', '2011-10-13', 'http://be.bing.com/search?q=PANGNOSIS&src=IE-SearchBox&FORM=IE8SRC', '1', '2011-10-15 12:22:55', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('539652224978240312', '2011-10-21', 'http://www.webmasters-paradise.com', '6', '2011-10-30 14:21:39', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('848422263330646516', '2011-11-11', 'http://www.scroogle.org/cgi-bin/nbbw.cgi', '1', '2011-11-14 18:32:20', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('997708136840771989', '2011-11-13', 'http://www.bourillon.net/spip.php?page=recherche&recherche=colonel+chabert', '3', '2011-11-16 08:51:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('480226681827126032', '2011-11-15', 'http://www.pearltrees.com/s/login/token/133a406136e.4a383.c60f2f4efb6c941f23d7e26f2695c8a4.7bc4cecb345343f1b16019fb67ab6eaf', '1', '2011-11-16 08:51:48', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('370782283903257965', '2011-11-24', 'http://bourillon.net/spip.php?page=recherche&recherche=le+colonel+chabert', '1', '2011-12-01 20:46:10', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('234235803106092409', '2011-12-11', 'http://36ohk6dgmcd1n-c.c.yom.mail.yahoo.net/om/api/1.0/openmail.app.invoke/36ohk6dgmcd1n/9/1.0.35/fr/fr-FR/view.html', '1', '2011-12-12 21:15:30', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('678837564358525760', '2012-01-10', 'http://bourillon.org/', '3', '2012-01-17 19:47:49', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('891918224060487554', '2012-01-12', 'http://yandex.ru/', '1', '2012-01-13 01:54:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('471501264210109784', '2012-01-08', 'http://www.bing.com/search?q=bourillon&form=ASUMHP&mkt=fr-fr&qs=AS&sk=&pq=bourill&sp=1&sc=8-7', '1', '2012-01-13 01:54:56', '0', '0');
INSERT INTO `spip01_referers` (`referer_md5`, `date`, `referer`, `visites`, `maj`, `visites_veille`, `visites_jour`) values ('456530494314841438', '2012-01-19', 'http://www.twikeo.com/bourillon-nom.html', '1', '2012-01-19 22:50:56', '1', '0');

# Structure de la table spip01_referers_articles
DROP TABLE IF EXISTS `spip01_referers_articles`;

CREATE TABLE `spip01_referers_articles` (
  `id_article` int(10) unsigned NOT NULL,
  `referer_md5` bigint(20) unsigned NOT NULL,
  `referer` varchar(255) NOT NULL default '',
  `visites` int(10) unsigned NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_article`,`referer_md5`),
  KEY `referer_md5` (`referer_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_referers_articles
INSERT INTO `spip01_referers_articles` (`id_article`, `referer_md5`, `referer`, `visites`, `maj`) values ('4', '300199221995105434', 'http://www.bourillon.net/spip.php?page=recherche&lang=fr&recherche=TEXTE+RIQUET+A+LA+HOUPPE+17+SIECLE', '1', '2010-12-21 16:33:07');
INSERT INTO `spip01_referers_articles` (`id_article`, `referer_md5`, `referer`, `visites`, `maj`) values ('4', '838262524571243139', 'http://www.denezhki.com/', '1', '2011-01-17 00:33:58');
INSERT INTO `spip01_referers_articles` (`id_article`, `referer_md5`, `referer`, `visites`, `maj`) values ('3', '838262524571243139', 'http://www.denezhki.com/', '1', '2011-01-17 00:33:58');
INSERT INTO `spip01_referers_articles` (`id_article`, `referer_md5`, `referer`, `visites`, `maj`) values ('2', '838262524571243139', 'http://www.denezhki.com/', '1', '2011-01-17 00:33:58');

# Structure de la table spip01_resultats
DROP TABLE IF EXISTS `spip01_resultats`;

CREATE TABLE `spip01_resultats` (
  `recherche` char(16) NOT NULL default '',
  `id` int(10) unsigned NOT NULL,
  `points` int(10) unsigned NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_resultats

# Structure de la table spip01_rubriques
DROP TABLE IF EXISTS `spip01_rubriques`;

CREATE TABLE `spip01_rubriques` (
  `id_rubrique` bigint(21) NOT NULL auto_increment,
  `id_parent` bigint(21) NOT NULL default '0',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `id_secteur` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `export` varchar(10) default 'oui',
  `id_import` bigint(20) default '0',
  `statut` varchar(10) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `extra` longtext,
  `statut_tmp` varchar(10) NOT NULL default '0',
  `date_tmp` datetime NOT NULL default '0000-00-00 00:00:00',
  `agenda` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id_rubrique`),
  KEY `lang` (`lang`),
  KEY `id_parent` (`id_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

# Donnees de spip01_rubriques
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('1', '0', 'KINOMICHI ', '', '', '1', '2010-08-16 20:58:18', 'oui', '0', 'publie', '2010-08-16 20:58:17', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('2', '0', 'MORIAS', '', '', '2', '2010-08-11 08:47:58', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('3', '0', 'SYSTEMES d\'ECHANGES LOCAUX', '', 'SEL = SYSTEME d\'ECHANGE LOCAL', '3', '2010-08-11 08:49:30', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('4', '0', 'ENSEIGNEMENT', '', '', '4', '2010-09-13 00:51:47', 'oui', '0', 'publie', '2010-09-13 00:51:45', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('5', '0', 'TICE', '', '', '5', '2010-08-11 08:52:11', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('6', '0', 'VOYAGES', '', '', '6', '2010-08-11 08:53:19', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('7', '0', 'SQUELETTE', '', '', '7', '2010-08-11 12:45:02', 'oui', '0', 'publie', '2010-08-11 12:45:01', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('8', '0', 'GALERIE', '', '', '8', '2010-08-11 17:41:33', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('9', '0', 'THEODORE TROUPIS', '', 'La vie et l\'uvre de l\'crivain grec Thodore Troupis', '9', '2010-08-11 17:47:01', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('10', '0', 'PANGNOSIS', '', 'Site pdagogique ddi  la mise en ligne d\'uvres littraires libres de droit.', '10', '2010-08-16 10:50:10', 'oui', '0', 'publie', '2010-08-16 10:50:09', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');
INSERT INTO `spip01_rubriques` (`id_rubrique`, `id_parent`, `titre`, `descriptif`, `texte`, `id_secteur`, `maj`, `export`, `id_import`, `statut`, `date`, `lang`, `langue_choisie`, `extra`, `statut_tmp`, `date_tmp`, `agenda`) values ('11', '0', 'Moodle : cours en ligne', '', '', '11', '2010-08-13 09:23:36', 'oui', '0', 'new', '0000-00-00 00:00:00', 'fr', 'non', '', '0', '0000-00-00 00:00:00', '0');

# Structure de la table spip01_shoutbox
DROP TABLE IF EXISTS `spip01_shoutbox`;

CREATE TABLE `spip01_shoutbox` (
  `id_shoutbox` bigint(21) NOT NULL auto_increment,
  `objet` varchar(25) NOT NULL default '',
  `id_auteur` bigint(21) default NULL,
  `auteur` text NOT NULL,
  `texte` longtext NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_shoutbox`),
  KEY `objet` (`objet`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_shoutbox

# Structure de la table spip01_signatures
DROP TABLE IF EXISTS `spip01_signatures`;

CREATE TABLE `spip01_signatures` (
  `id_signature` bigint(21) NOT NULL auto_increment,
  `id_article` bigint(21) NOT NULL default '0',
  `date_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `nom_email` text NOT NULL,
  `ad_email` text NOT NULL,
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `message` mediumtext NOT NULL,
  `statut` varchar(10) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_signature`),
  KEY `id_article` (`id_article`),
  KEY `statut` (`statut`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_signatures

# Structure de la table spip01_syndic
DROP TABLE IF EXISTS `spip01_syndic`;

CREATE TABLE `spip01_syndic` (
  `id_syndic` bigint(21) NOT NULL auto_increment,
  `id_rubrique` bigint(21) NOT NULL default '0',
  `id_secteur` bigint(21) NOT NULL default '0',
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `url_syndic` text NOT NULL,
  `descriptif` text NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `syndication` varchar(3) NOT NULL default '',
  `statut` varchar(10) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_syndic` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_index` datetime NOT NULL default '0000-00-00 00:00:00',
  `extra` longtext,
  `moderation` varchar(3) default 'non',
  `miroir` varchar(3) default 'non',
  `oubli` varchar(3) default 'non',
  `resume` varchar(3) default 'oui',
  PRIMARY KEY  (`id_syndic`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `statut` (`statut`,`date_syndic`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

# Donnees de spip01_syndic
INSERT INTO `spip01_syndic` (`id_syndic`, `id_rubrique`, `id_secteur`, `nom_site`, `url_site`, `url_syndic`, `descriptif`, `maj`, `syndication`, `statut`, `date`, `date_syndic`, `date_index`, `extra`, `moderation`, `miroir`, `oubli`, `resume`) values ('1', '1', '1', 'www-kinomichi-com - Maitre Noro prsente le Kinomichi', 'http://www.kinomichi.com', 'http://', 'Art of movement for the 21st century, Way of Energy - Technique of harmony, of opening, of dynamism in fluidity', '2010-08-12 09:44:45', 'non', 'publie', '2010-08-12 09:44:44', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'non', 'non', 'non', 'oui');
INSERT INTO `spip01_syndic` (`id_syndic`, `id_rubrique`, `id_secteur`, `nom_site`, `url_site`, `url_syndic`, `descriptif`, `maj`, `syndication`, `statut`, `date`, `date_syndic`, `date_index`, `extra`, `moderation`, `miroir`, `oubli`, `resume`) values ('2', '1', '1', 'Kinomichi International Instructors Association (K.I.I.A.) : Prsentation', 'http://www.kiia.net', 'http://', 'Le site de la kiia ( k.i.i.a. ) kinomichi international instructors association ou association des instructeurs internationaux du kinomichi cr par maitre Noro.', '2010-08-12 10:00:48', 'non', 'publie', '2010-08-12 10:00:47', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'non', 'non', 'non', 'oui');
INSERT INTO `spip01_syndic` (`id_syndic`, `id_rubrique`, `id_secteur`, `nom_site`, `url_site`, `url_syndic`, `descriptif`, `maj`, `syndication`, `statut`, `date`, `date_syndic`, `date_index`, `extra`, `moderation`, `miroir`, `oubli`, `resume`) values ('3', '4', '4', 'Accueil - EduSCOL', 'http://eduscol.education.fr', 'http://eduscol.education.fr/rid271/l-actualite.rss?xtdate=20100913', 'Le ministre de l\'ducation nationale propose aux professionnels de l\'ducation des informations et des ressources.', '2012-01-20 09:05:47', 'oui', 'publie', '2010-09-13 00:51:45', '2012-01-20 09:05:57', '0000-00-00 00:00:00', '', 'non', 'oui', 'oui', 'non');

# Structure de la table spip01_syndic_articles
DROP TABLE IF EXISTS `spip01_syndic_articles`;

CREATE TABLE `spip01_syndic_articles` (
  `id_syndic_article` bigint(21) NOT NULL auto_increment,
  `id_syndic` bigint(21) NOT NULL default '0',
  `titre` text NOT NULL,
  `url` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `lesauteurs` text NOT NULL,
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `statut` varchar(10) NOT NULL default '0',
  `descriptif` text NOT NULL,
  `lang` varchar(10) NOT NULL default '',
  `url_source` tinytext NOT NULL,
  `source` tinytext NOT NULL,
  `tags` text NOT NULL,
  PRIMARY KEY  (`id_syndic_article`),
  KEY `id_syndic` (`id_syndic`),
  KEY `statut` (`statut`),
  KEY `url` (`url`)
) ENGINE=MyISAM AUTO_INCREMENT=220 DEFAULT CHARSET=utf8;

# Donnees de spip01_syndic_articles
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('181', '3', 'Journe de sensibilisation au handicap : ressources - Actualits', 'http://eduscol.education.fr/cid58564/journee-de-sensibilisation-au-handicap-ressources.html', '2011-11-25 04:07:59', '', '2011-11-30 19:25:00', 'off', '<p>Pour animer la journ&eacute;e de sensibilisation au handicap, les &eacute;quipes p&eacute;dagogiques et &eacute;ducatives des &eacute;coles, coll&egrave;ges et lyc&eacute;es peuvent utiliser des ressources en ligne, vid&eacute;o ou texte, pour animer des s&eacute;ances d&eacute;di&eacute;es. Ils peuvent aussi organiser des sorties p&eacute;dagogiques, pour faire d&eacute;couvrir aux &eacute;l&egrave;ves comment se vit le handicap dans le monde du travail, par exemple.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('180', '3', 'Journe de sensibilisation au handicap - Agenda', 'http://eduscol.education.fr/cid58563/journee-de-sensibilisation-au-handicap.html', '2011-11-25 06:26:11', '', '2011-11-30 19:25:00', 'off', '<p>Pour changer le regard collectif sur le handicap &agrave; l\'&Eacute;cole, une journ&eacute;e de sensibilisation est programm&eacute;e dans tous les &eacute;tablissements scolaires le 2 d&eacute;cembre, veille de la journ&eacute;e mondiale du handicap.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('164', '3', 'Le site Jeunes.gouv - Ressources', 'http://eduscol.education.fr/cid58450/le-site-jeunes.gouv.html', '2011-11-18 08:02:49', '', '2011-11-20 18:52:47', 'off', '', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('165', '3', 'Mieux soutenir l\'engagement des lycens - Ressources', 'http://eduscol.education.fr/cid58419/mieux-soutenir-l-engagement-des-lyceens.html', '2011-11-18 05:21:25', '', '2011-11-20 18:52:47', 'off', '<p>Permettre aux &eacute;l&egrave;ves de prendre plus facilement des responsabilit&eacute;s, d\'acc&eacute;der progressivement &agrave; l\'autonomie, de d&eacute;velopper leur l\'esprit d\'initiative... La r&eacute;forme du lyc&eacute;e donne les outils aux &eacute;l&egrave;ves pour participer plus efficacement &agrave; la vie de leur lyc&eacute;e.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('66', '3', 'Les coliers vous proposent leur dictionnaire - Actualits', 'http://eduscol.education.fr/cid56561/les-ecoliers-vous-proposent-leur-dictionnaire.html', '2011-06-15 05:37:10', '', '2011-11-30 19:25:00', 'off', '<p>Depuis le 28 septembre, les classes de la grande section de maternelle au CM2 peuvent s\'inscrire pour compl&eacute;ter le dictionnaire num&eacute;rique des &eacute;coliers. En 2010-2011, plus de 5000 classes ont particip&eacute; &agrave; la cr&eacute;ation de ce dictionnaire en ligne, qui compte aujourd\'hui plus de 17000 d&eacute;finitions.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/180/52/2/dictionnaire-des-ecoliers_163162_190718_191522.jpg\" type=\"image/jpeg\">dictionnaire-des-ecoliers_163162_190718_191522.jpg</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('178', '3', 'Publication de la nouvelle circulaire - Actualits', 'http://eduscol.education.fr/cid58551/publication-de-la-nouvelle-circulaire.html', '2011-11-30 04:40:07', '', '2011-11-30 19:25:00', 'off', '<p>La troisi&egrave;me circulaire pour la g&eacute;n&eacute;ralisation de l\'&eacute;ducation au d&eacute;veloppement durable est parue le 24 octobre 2011. Elle insiste plus pr&eacute;cis&eacute;ment sur trois points qui doivent porter cette g&eacute;n&eacute;ralisation : renforcer la gouvernance et le pilotage au niveau acad&eacute;mique et des &eacute;tablissements ; &eacute;largir les partenariats ; mieux diffuser les informations pour partager les actions mises en place.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('179', '3', 'Innover pour une cole des russites : vade-mecum - Actualits', 'http://eduscol.education.fr/cid58593/innover-pour-une-ecole-des-reussites-vade-mecum.html', '2011-11-29 03:26:32', '', '2011-11-30 19:25:00', 'off', '<p>Pour accompagner les &eacute;quipes &eacute;ducatives et &eacute;tayer leur action innovante sur le terrain, le minist&egrave;re propose un vade-mecum, con&ccedil;u comme un guide m&eacute;thodologique.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/280/97/8/vade-mecum_innovation_-_couverture_200978.jpg\" type=\"image/jpeg\">vade-mecum_innovation_-_couverture_200978.jpg</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('177', '3', 'Concours national eTwinning : liste des projets prims en 2011 - Actualits', 'http://eduscol.education.fr/cid58457/concours-national-etwinning-liste-des-projets-primes-en-2011.html', '2011-11-18 10:54:18', '', '2011-12-15 20:00:09', 'off', '<p>eTwinning est une action europ&eacute;enne du programme Education Formation Tout au Long de la Vie, qui offre aux enseignants des 32 pays participant la possibilit&eacute; d\'entrer en contact afin de mener avec leurs &eacute;l&egrave;ves des projets collaboratifs &agrave; distance &agrave; l\'aide des TICE. Un concours national annuel r&eacute;compense chaque ann&eacute;e les meilleurs projets de coop&eacute;ration dans cinq cat&eacute;gories.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('176', '3', 'Plan numrique : le calendrier du deuxime appel  projet avanc - Actualits du numrique', 'http://eduscol.education.fr/cid58469/plan-numerique-le-calendrier-du-deuxieme-appel-a-projet-avance.html', '2011-11-21 09:15:46', '', '2011-11-30 19:25:00', 'off', '<p>A la veille du salon Educatec-Educatice, le minist&egrave;re a d&eacute;cid&eacute; d\'avancer le lancement du second appel &agrave; projet du plan de d&eacute;veloppement des usages du num&eacute;rique &agrave; l\'&Eacute;cole ; un courrier vient d\'&ecirc;tre adress&eacute; aux 17 acad&eacute;mies concern&eacute;es afin de profiter de la dynamique enclench&eacute;e avec les collectivit&eacute;s territoriales dont l\'appui est indispensable &agrave; la r&eacute;alisation de ce Plan.<br />Les acad&eacute;mies doivent d&eacute;poser leur r&eacute;ponse avant la fin du mois de janvier 2012.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Grande_taille/21/7/IMG_0094_191217.JPG\" type=\"image/jpeg\">IMG_0094_191217.JPG</a>, <a rel=\'directory\'>Actualits du numrique</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('174', '3', 'Je filme le mtier qui me plat - Agenda', 'http://eduscol.education.fr/cid58462/je-filme-le-metier-qui-me-plait.html', '2011-11-21 10:44:32', '', '2011-11-24 20:37:05', 'off', '<p>Filmer un m&eacute;tier pour mieux le comprendre : c\'est ce que propose aux &eacute;l&egrave;ves le concours vid&eacute;o \"Je filme le m&eacute;tier qui me pla&icirc;t\". Accompagn&eacute;s d\'un enseignant r&eacute;f&eacute;rent, ils peuvent s\'inscrire jusqu\'au 17 d&eacute;cembre 2011.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('175', '3', 'L\'accompagnement personnalis en classe de sixime - Ressources', 'http://eduscol.education.fr/cid46791/l-accompagnement-personnalise-en-classe-de-sixieme.html', '2011-11-21 04:30:24', '', '2011-11-24 20:37:05', 'off', '<p>&Agrave; leur entr&eacute;e au coll&egrave;ge, certains &eacute;l&egrave;ves ont encore des acquis fragiles, d\'autres sont d&eacute;sireux d\'approfondir leurs savoirs et savoir-faire. Tous ont encore besoin de dispositifs d\'aide adapt&eacute;s &agrave; leur profil, &eacute;troitement articul&eacute;s au travail conduit &agrave; l\'&eacute;cole, qui doivent pouvoir commencer d&egrave;s leur entr&eacute;e en sixi&egrave;me. L\'accompagnement personnalis&eacute; est le cadre de mise en &oelig;uvre de ces aides. Il se substitue &agrave; l\'aide au travail personnel (ATP).</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('172', '3', 'Concours \"Posie en libert\" 2011 : remise des prix - Agenda', 'http://eduscol.education.fr/cid54688/concours-poesie-en-liberte-2011-remise-des-prix.html', '2011-11-21 10:40:49', '', '2011-11-24 20:37:05', 'off', '<p>Le 25 novembre 2011, les laur&eacute;ats de l\'&eacute;dition 2011 de Po&eacute;sie en libert&eacute; re&ccedil;oivent leurs prix &agrave; l\'h&ocirc;tel de ville de Versailles. Ce concours international en ligne est ouvert &agrave; tous les lyc&eacute;ens et &eacute;tudiants de 15 &agrave; 25 ans.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('173', '3', 'Echanges et actions de formation 2012-2013 - Ressources', 'http://eduscol.education.fr/cid48299/echanges-et-actions-de-formation-2012-2013.html', '2011-11-21 10:49:24', '', '2011-11-24 20:37:05', 'off', '<p>L\'ensemble des actions propos&eacute;es permet aux enseignants d\'acqu&eacute;rir, par une relation directe avec des formateurs, des enseignants, des familles et divers responsables, une meilleure connaissance de la culture, de la langue, de la p&eacute;dagogie des pays d\'accueil et d\'enrichir significativement leurs pratiques d\'enseignement.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('170', '3', 'Description fonctionnelle du service numrique de baladodiffusion - Actualits du numrique', 'http://eduscol.education.fr/cid58506/description-fonctionnelle-du-service-numerique-de-baladodiffusion.html', '2011-11-22 01:39:02', '', '2011-11-30 19:25:00', 'off', '', '', '', '', '<a rel=\'directory\'>Actualits du numrique</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('171', '3', 'Mdias sociaux et usages pdagogiques - Actualits du numrique', 'http://eduscol.education.fr/cid58481/medias-sociaux-et-usages-pedagogiques.html', '2011-11-22 01:17:27', '', '2011-11-24 20:37:05', 'off', '<p>Les m&eacute;dias sociaux utilisent des techniques de communication ais&eacute;ment accessibles pour faciliter les interactions sociales, interaction sociales qui se fondent sur l\'id&eacute;ologie et la technologie du Web 2.0. Ces technologies permettent en particulier la cr&eacute;ation et l\'&eacute;change de contenus g&eacute;n&eacute;r&eacute;s par les utilisateurs. C\'est &agrave; ce titre qu\'ils entrent peu &agrave; peu dans la classe, pour des usages num&eacute;riques p&eacute;dagogiques ou comme objet de r&eacute;flexion.</p>', '', '', '', '<a rel=\'directory\'>Actualits du numrique</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('169', '3', 'Journe mondiale de lutte contre le sida - Agenda', 'http://eduscol.education.fr/cid54062/journee-mondiale-de-lutte-contre-le-sida.html', '2011-11-23 05:46:52', '', '2011-11-24 20:37:05', 'off', '<p>La Journ&eacute;e mondiale de lutte contre le sidaa lieu le 1er d&eacute;cembre de chaque ann&eacute;e. Elle vise &agrave;rappeler l\'importance de la pr&eacute;vention, de l\'acc&egrave;s au d&eacute;pistage, aux traitements et aux soins. Les partenaires du minist&egrave;re proposent gratuitement des ressources pour les &eacute;quipes &eacute;ducatives des coll&egrave;ges et des lyc&eacute;es. Cette journ&eacute;e s\'inscrit dans le cadre d\'une campagne mondiale. En 2011, elle s\'organiseautour du th&egrave;me \"Objectif : z&eacute;ro. Z&eacute;ro nouvelle infection au VIH. Z&eacute;ro discrimination. Z&eacute;ro d&eacute;c&egrave;s li&eacute; au sida\".</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('168', '3', 'Cin-lyce au Salon de l\'ducation - Agenda', 'http://eduscol.education.fr/cid56059/cine-lycee-au-salon-de-l-education.html', '2011-11-24 05:59:07', '', '2011-11-24 20:37:05', 'off', '<p>Le minist&egrave;re propose une Master class autour de Cin&eacute;-lyc&eacute;e aux lyc&eacute;ens, au Salon de l\'&eacute;ducation, le 24 novembre 2011. La s&eacute;anceexplore les possibilit&eacute;s d\'utilisation de la plateforme dans les &eacute;tablissements, en s\'appuyant sur le film <em>Le voyage extraordinaire</em>, pr&eacute;sent&eacute; par le cin&eacute;aste Serge Bromberg.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('166', '3', 'Territoires d\'Ecole - Ressources', 'http://eduscol.education.fr/cid58387/territoires-d-ecole.html', '2011-11-18 11:02:21', '', '2011-11-20 18:52:47', 'off', '<p>Une nouvelle collection :une cartographie des espaces professionnels de l\'innovation en &eacute;ducation, produite parla DGESCO, &eacute;dit&eacute;e par le CNDP, esten train de na&icirc;tre, inaugur&eacute;e par une carte de l\'innovation.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('167', '3', 'Sminaire national des IEN ASH - Actualits', 'http://eduscol.education.fr/cid58366/seminaire-national-des-ien-ash.html', '2011-11-17 01:11:38', '', '2011-11-20 18:52:47', 'off', '<p>Depuis la loi de 2005, la scolarisation des &eacute;l&egrave;ves handicap&eacute;s est en progression. La r&eacute;union le 17 octobre des 142 inspecteurs de l\'&Eacute;ducation nationale et des 30 conseillers techniques de recteur en charge de l\'adaptation scolaire et de la scolarisation des &eacute;l&egrave;ves handicap&eacute;s, a &eacute;t&eacute; l\'occasion de faire le point sur les grands chiffres de la rentr&eacute;e.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('189', '3', 'La collection Territoires d\'Ecole - Ressources', 'http://eduscol.education.fr/cid58387/la-collection-territoires-d-ecole.html', '2011-11-18 11:01:46', '', '2011-12-06 21:32:20', 'off', '<p>Une nouvelle collection :une cartographie des espaces professionnels de l\'innovation en &eacute;ducation, produite parla DGESCO, &eacute;dit&eacute;e par le CNDP, esten train de na&icirc;tre, inaugur&eacute;e par une carte de l\'innovation.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('188', '3', 'Journe de sensibilisation au handicap du 2 dcembre : ressources - Actualits', 'http://eduscol.education.fr/cid58564/journee-de-sensibilisation-au-handicap-du-2-decembre-ressources.html', '2011-11-25 04:36:23', '', '2011-12-06 21:32:20', 'off', '<p>Pour animer la journ&eacute;e de sensibilisation au handicap, les &eacute;quipes p&eacute;dagogiques et &eacute;ducatives des &eacute;coles, coll&egrave;ges et lyc&eacute;es peuvent utiliser des ressources en ligne, vid&eacute;o ou texte, pour animer des s&eacute;ances d&eacute;di&eacute;es. Ils peuvent aussi organiser des sorties p&eacute;dagogiques, pour faire d&eacute;couvrir aux &eacute;l&egrave;ves comment se vit le handicap dans le monde du travail, par exemple.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/280/03/5/lecture_braille_201035.jpg\" type=\"image/jpeg\">lecture_braille_201035.jpg</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('186', '3', 'Exprimentation manuels numriques via l\'ENT : des rsultats relativement positifs pour la ...', 'http://eduscol.education.fr/cid58607/experimentation-manuels-numeriques-via-l-ent-des-resultats-relativement-positifs-pour-la-seconde-annee-d-evaluation.html', '2011-12-01 09:43:27', '', '2011-12-06 21:32:20', 'off', '<p>Men&eacute;e depuis 2009 dans douze acad&eacute;mies, l\'exp&eacute;rimentation manuels num&eacute;riques via l\'ENT concerne 69 coll&egrave;ges. Elle s\'adresse &agrave; toutes les classes de sixi&egrave;me et de cinqui&egrave;me et &agrave; certaines classes de quatri&egrave;me. L\'&eacute;valuation de ces deux ann&eacute;es d\'exp&eacute;rimentation a &eacute;t&eacute; confi&eacute;e par le minist&egrave;re &agrave; un cabinet ext&eacute;rieur.</p>', '', '', '', '<a rel=\'directory\'>Actualits du numrique</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('187', '3', 'Vademecum Innover pour une cole des russites - Actualits', 'http://eduscol.education.fr/cid58582/vademecum-innover-pour-une-ecole-des-reussites.html', '2011-11-29 04:17:54', '', '2011-12-06 21:32:20', 'off', '<p>La tr&egrave;s grande majorit&eacute; des innovations et exp&eacute;rimentations proviennent des &eacute;quipes &eacute;ducatives elles-m&ecirc;mes. Pour les accompagner dans la mise en oeuvre de leur d&eacute;marche de changement, et partager une m&eacute;thodologie de l\'accompagnement &agrave; l\'innovation avec les corps d\'inspection et les chefs d\'&eacute;tablissement, la direction g&eacute;n&eacute;rale de l\'enseignement scolaire publie <strong>le Vade-mecum, \"Innover pour une &eacute;cole des r&eacute;ussites\", </strong>fruit d\'un groupe de travail interacad&eacute;mique et intercat&eacute;goriel.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('185', '3', 'Sminaire de rflexion sur la lacit - Agenda', 'http://eduscol.education.fr/cid58612/seminaire-de-reflexion-sur-la-laicite.html', '2011-12-02 07:44:53', '', '2011-12-06 21:32:20', 'off', '<p>Proposer une d&eacute;finition de la la&iuml;cit&eacute;, dans son application &agrave; l\'&eacute;cole, &agrave; l\'universit&eacute;, dans la fonction publique hospitali&egrave;re et dans les arm&eacute;es fran&ccedil;aises est l\'objectif fix&eacute; au s&eacute;minaire \"La&iuml;cit&eacute; : de la d&eacute;finition du principe &agrave; son application pratique dans la fonction publique\". Cadres et responsables de formation des fonctions publiques d\'&Eacute;tat s\'y retrouvent les 8 et 9 d&eacute;cembre 2011, &agrave; Paris.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('183', '3', 'Aide  l\'auto-valuation - Ressources', 'http://eduscol.education.fr/cid58628/aide-a-l-auto-evaluation.html', '2011-12-05 08:31:59', '', '2011-12-06 21:32:20', 'off', '<p>Lepilotage p&eacute;dagogique d\'un &eacute;cole ou d\'un &eacute;tablissement repose sur un diagnostic en termes de moyens, de r&eacute;sultats mais aussi de pratiques.Depuis 30 ans, les recherches sur l\'efficacit&eacute; scolaire ont permis de construire une base de connaissances sur le degr&eacute; d\'efficacit&eacute; des diff&eacute;rentes pratiques p&eacute;dagogiques.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('184', '3', 'Guides Scolariser les lves handicaps - Ressources', 'http://eduscol.education.fr/cid47791/guides-scolariser-les-eleves-handicapes.html', '2011-12-02 00:45:44', '', '2011-12-06 21:32:20', 'off', '<p>La scolarisation des &eacute;l&egrave;ves handicap&eacute;s constitue une priorit&eacute; nationale. Dans ce domaine, des progr&egrave;s consid&eacute;rables ont &eacute;t&eacute; accomplis depuis plusieurs ann&eacute;es et, notamment, depuis la publication et la mise en &oelig;uvre des textes d\'application de la loi du 11 f&eacute;vrier 2005, le nombre d\'&eacute;l&egrave;ves accueillis dans les &eacute;coles et les &eacute;tablissements scolaires a connu une augmentation significative. Pour autant, beaucoup reste &agrave; faire pour ajuster au mieux les besoins de chaque &eacute;l&egrave;ve handicap&eacute; avec son environnement scolaire.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('182', '3', 'Rnovation des B2i cole et collge - Actualits du numrique', 'http://eduscol.education.fr/cid58653/renovation-des-b2i-ecole-et-college.html', '2011-12-06 03:39:57', '', '2011-12-06 21:32:20', 'publie', '<p>Les &eacute;volutions d\'Internet et le d&eacute;veloppement des usages p&eacute;dagogiques du num&eacute;rique ont conduit &agrave; la r&eacute;novation des r&eacute;f&eacute;rentiels de comp&eacute;tences du B2i &eacute;cole et du B2i coll&egrave;ge afin de mieux pr&eacute;parer les &eacute;l&egrave;ves &agrave; un usage responsable de ces technologies.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/secondaire_usage/97/6/865021-type_178976.jpg\" type=\"image/jpeg\">865021-type_178976.jpg</a>, <a rel=\'directory\'>Actualits du numrique</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('195', '3', 'OAPE - Ressources', 'http://eduscol.education.fr/cid58628/oape.html', '2011-12-05 08:50:35', '', '2011-12-15 20:00:09', 'publie', '<p>Lepilotage p&eacute;dagogique d\'une &eacute;cole ou d\'un &eacute;tablissement repose sur un diagnostic en termes de moyens, de r&eacute;sultats mais aussi de pratiques.Depuis 30 ans, les recherches sur l\'efficacit&eacute; scolaire ont permis de construire une base de connaissances sur le degr&eacute; d\'efficacit&eacute; des diff&eacute;rentes pratiques p&eacute;dagogiques.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Innovation_experimentation/15/6/OAPE_captureEcranV4_201156.JPG\" type=\"image/jpeg\">OAPE_captureEcranV4_201156.JPG</a>, <a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('194', '3', 'Vade-mecum Innover pour une cole des russites - Ressources', 'http://eduscol.education.fr/cid58582/vade-mecum-innover-pour-une-ecole-des-reussites.html', '2011-12-07 11:35:11', '', '2011-12-11 12:49:32', 'off', '<p>La tr&egrave;s grande majorit&eacute; des innovations et exp&eacute;rimentations proviennent des &eacute;quipes &eacute;ducatives elles-m&ecirc;mes. Pour les accompagner dans la mise en oeuvre de leur d&eacute;marche de changement, et partager une m&eacute;thodologie de l\'accompagnement &agrave; l\'innovation avec les corps d\'inspection et les chefs d\'&eacute;tablissement, la direction g&eacute;n&eacute;rale de l\'enseignement scolaire publie <strong>le Vade-mecum, \"Innover pour une &eacute;cole des r&eacute;ussites\", </strong>fruit d\'un groupe de travail interacad&eacute;mique et intercat&eacute;goriel.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('193', '3', 'Prfets des tudes : le vade-mecum - Actualits', 'http://eduscol.education.fr/cid58656/prefets-des-etudes-le-vade-mecum.html', '2011-12-07 10:07:45', '', '2011-12-11 12:49:32', 'publie', '<p>La nomination d\'un pr&eacute;fet des &eacute;tudes par niveau au coll&egrave;ge et en seconde au lyc&eacute;e est une des innovations majeures du programme &Eacute;CLAIR. Un vade-mecum vise &agrave; aider les chefs d\'&eacute;tablissement et les &eacute;quipes &eacute;ducatives du programme &agrave; s\'approprier cette fonction cr&eacute;&eacute;e &agrave; la rentr&eacute;e 2010. Il combine t&eacute;moignages et pistes d\'action.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('192', '3', 'Accompagnement des porteurs de projets ENT, runions des 23 et 24 novembre 2011 - Actualits ...', 'http://eduscol.education.fr/cid58665/accompagnement-des-porteurs-de-projets-ent-reunions-des-23-et-24-novembre-2011.html', '2011-12-07 03:40:20', '', '2011-12-11 12:49:32', 'publie', '<p>Les 23 et 24 novembre 2011 ont eu lieu, en marge du salon Educatec-Educatice, des &laquo;r&eacute;unions porteurs de projet <acronym xml:lang=\"fr\" title=\"Espace ou Environnement num&eacute;rique de travail\" lang=\"fr\">ENT</acronym>&raquo; rassemblant les repr&eacute;sentants des collectivit&eacute;s et des acad&eacute;mies impliqu&eacute;es dans les projets d\'espaces num&eacute;riques de travail.</p>', '', '', '', '<a rel=\'directory\'>Actualits du numrique</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('190', '3', 'Le calendrier des examens - Actualits', 'http://eduscol.education.fr/cid58696/le-calendrier-des-examens.html', '2011-12-09 10:33:09', '', '2011-12-11 12:49:32', 'publie', '<p>Le dipl&ocirc;me national du brevet aura lieu les 28 et 29 juin 2012 et le baccalaur&eacute;at &agrave; partir du 18 juin 2012. Ce calendrier, paru dans le Bulletin Officiel du 8 d&eacute;cembre, s\'int&egrave;gre dans la reconqu&ecirc;te du mois de juin et fixe les dates principales de l\'orientation, de l\'affectation des &eacute;l&egrave;ves et des examens.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('191', '3', 'Remise de prix du concours national eTwinning - Agenda', 'http://eduscol.education.fr/cid58687/remise-de-prix-du-concours-national-etwinning.html', '2011-12-08 02:30:27', '', '2011-12-29 20:17:42', 'publie', '<p>Le ministre de l\'&eacute;ducation nationale, de la jeunesse et de la vie associative remet leurs prix aux 9 classes laur&eacute;ates du concours national eTwinning le 14 d&eacute;cembre.Le concours r&eacute;compense les meilleurs projets de coop&eacute;ration internationale entre enseignants qui d&eacute;bouchent sur des projets collaboratifs avec les &eacute;l&egrave;ves. Il permet aux &eacute;l&egrave;ves de d&eacute;velopper des comp&eacute;tences li&eacute;es auxTice etau langage. 32 pays y participent, dans 23 langues diff&eacute;rentes.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('198', '3', 'Les 41 Greta GretaPlus - Ressources', 'http://eduscol.education.fr/cid47009/les-41-greta-gretaplus.html', '2011-12-14 05:14:51', '', '2011-12-15 20:00:09', 'publie', '<p>Les Greta ont le label pour tout ou partie de leurs formations.Deplus en plus les Greta sont labellis&eacute;s pour l\'ensemble de leurs formations. En 2011, 41 Greta ont le label GretaPlus.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('199', '3', 'Partenariats avec le mouvement sportif - Ressources', 'http://eduscol.education.fr/cid58447/partenariats-avec-le-mouvement-sportif.html', '2011-12-14 10:43:07', '', '2011-12-15 20:00:09', 'publie', '<p>Le sport a progressivement gagn&eacute; tous les domaines de la soci&eacute;t&eacute; fran&ccedil;aise. Les valeurs &eacute;ducatives et sociales qu\'il v&eacute;hicule le placent au croisement de diff&eacute;rents lieux d\'&eacute;ducation : &agrave; l\'&eacute;cole, il s\'inscrit dans le cadre de l\'&eacute;ducation formelle en mobilisant des connaissances et comp&eacute;tences disciplinaires et transversales ; hors de l\'&eacute;cole, un large r&eacute;seau associatif permet &agrave; chacun de d&eacute;couvrir et pratiquer une multitude d\'activit&eacute;s dans leur dimension de loisir ou de comp&eacute;tition.</p>
<p>Le sport s\'appuie sur des valeurs qui sont aussi celles de l\'&eacute;cole : le go&ucirc;t de l\'effort, la pers&eacute;v&eacute;rance, la volont&eacute; de progresser, le respect des autres, de soi et des r&egrave;gles, etc.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('197', '3', 'La politique ducative de sant - Ressources', 'http://eduscol.education.fr/cid54929/la-politique-educative-de-sante.html', '2011-12-15 11:01:28', '', '2011-12-15 20:00:09', 'publie', '<p>La politique &eacute;ducative de sant&eacute;constitueun facteur essentiel de bien-&ecirc;tre des &eacute;l&egrave;ves, de r&eacute;ussite scolaire et d\'&eacute;quit&eacute;. Dans ce cadre, l\'&Eacute;cole joue un r&ocirc;le essentiel dans l\'&eacute;ducation &agrave; la sant&eacute;, le rep&eacute;rage, la pr&eacute;vention, l\'information et l\'orientation.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('196', '3', 'Remise des prix 2011 du Concours national de la Rsistance et de la Dportation - Agenda', 'http://eduscol.education.fr/cid58660/remise-des-prix-2011-du-concours-national-de-la-resistance-et-de-la-deportation.html', '2011-12-12 07:03:23', '', '2011-12-12 21:53:05', 'publie', '<p>La remise des prix du Concours national de la R&eacute;sistance et de la D&eacute;portation (CNRD) a lieu le 16 d&eacute;cembre 2011.Pour donnerau 50e anniversaire du concours un caract&egrave;re particuli&egrave;rement solennel, elle se d&eacute;roule au Palais de l\'&Eacute;lys&eacute;e. Cet &eacute;v&egrave;nement est organis&eacute; en collaboration avec le concours du minist&egrave;re de la d&eacute;fense et des anciens combattants et de la Fondation de la R&eacute;sistance.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('204', '3', 'Prsidences tournantes du Conseil de l\'Union Europenne - Ressources', 'http://eduscol.education.fr/cid58642/presidences-tournantes-du-conseil-de-l-union-europeenne.html', '2011-12-20 04:37:22', '', '2011-12-29 20:17:42', 'publie', '<p>Le Conseil de l\'Union Europ&eacute;enne, ou Conseil de l\'UE, est l\'instance qui r&eacute;unit les ministres des gouvernements de chaque pays membre de l\'UE pour adopter des actes l&eacute;gislatifs et coordonner les politiques.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Europe_et_international/68/9/Conseil_de_l_union_europenne_200689.jpg\" type=\"image/jpeg\">Conseil_de_l_union_europenne_200689.jpg</a>, <a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('203', '3', 'Organisation de coopration et de dveloppement conomiques : OCDE - Ressources', 'http://eduscol.education.fr/cid58794/organisation-de-cooperation-et-de-developpement-economiques-ocde.html', '2011-12-21 10:54:33', '', '2011-12-29 20:17:42', 'publie', '<p>L\'OCDE est n&eacute;e en 1960 lorsque 18 pays europ&eacute;ens, les &Eacute;tats-Unis et le Canada ont uni leurs forces pour fonder une organisation vou&eacute;e au d&eacute;veloppement mondial. Aujourd\'hui, l\'OCDE compte 34 pays membres &agrave; travers le monde, de l\'Am&eacute;rique du Nord et du Sud &agrave; l\'Europe, en passant par la r&eacute;gion Asie-Pacifique. En font partie beaucoup des pays les plus avanc&eacute;s, mais aussi des pays &eacute;mergents comme la Chine, l\'Inde, le Br&eacute;sil, le Mexique, le Chili et la Turquie ainsi que des &eacute;conomies en d&eacute;veloppement d\'Afrique, d\'Asie, d\'Am&eacute;rique latine et des Cara&iuml;bes.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Europe_et_international/62/7/Logo_OCDE_202627.jpg\" type=\"image/jpeg\">Logo_OCDE_202627.jpg</a>, <a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('202', '3', 'Enseignants, participez  la Semaine de la presse et des mdias dans l\'cole - Actualits', 'http://eduscol.education.fr/cid58870/enseignants-participez-a-la-semaine-de-la-presse-et-des-medias-dans-l-ecole.html', '2011-12-22 11:02:41', '', '2011-12-29 20:17:42', 'publie', '<p>La 23e Semaine de la presse et des m&eacute;dias dans l\'&eacute;cole&reg; a lieu du 19 au 24 mars 2012. Vous pouvez inscrire votre classe du 5 janvier au 11 f&eacute;vrier 2012. Vous recevez ensuite un dossier p&eacute;dagogique, des journaux et des magazines.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/agenda_2010_-_trimestre_1/56/1/logo_semaine_de_la_presse_131561.jpg\" type=\"image/jpeg\">logo_semaine_de_la_presse_131561.jpg</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('200', '3', 'Enseigner les lettres avec le numrique - Ressources', 'http://eduscol.education.fr/cid58809/enseigner-les-lettres-avec-le-numerique.html', '2011-12-16 09:07:18', '', '2011-12-29 20:17:42', 'publie', '<p>La brochure \"Enseigner les lettres avec le num&eacute;rique\" r&eacute;unit sous forme de fiches une dizaine de parcours p&eacute;dagogiques illustrant l\'utilisation des technologies num&eacute;riques et l\'&eacute;volution des pratiques. Elle propose un choix de r&eacute;f&eacute;rences bibliographiques et sitographiques (Minist&egrave;re de l\'&Eacute;ducation nationale, novembre 2010, 70 pages).</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('201', '3', 'Colloque \"Chimie et nature\" - Agenda', 'http://eduscol.education.fr/cid58807/colloque-chimie-et-nature.html', '2011-12-15 08:25:04', '', '2011-12-18 20:39:30', 'publie', '<p>Experts scientifiques, industriels, chimistes d&eacute;battent de l\'apport de la chimie &agrave; la compr&eacute;hension de la nature : comment la prot&eacute;ger, &eacute;conomiser ses ressources et s\'en inspirer au service de l\'homme ? Les conf&eacute;renciers, choisis parmi les meilleurs sp&eacute;cialistes de leur domaine, proposent des interventions accessibles aux lyc&eacute;ens, &eacute;tudiants et &agrave; leurs enseignants, le 25 janvier 2012 &agrave; la Maison de la chimie.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('129', '3', 'Dernires actualits du DRDIE - Ressources', 'http://eduscol.education.fr/cid55138/dernieres-actualites-du-drdie.html', '2011-10-21 03:39:19', '', '2011-11-20 18:52:47', 'off', '<ul>
<li>\"Territoires d\'&eacute;cole\" : une nouvelle collection de ressources innovantes</li>
<li>Prix Jacqueline de Romilly pour les innovations en \"langues et cultures de l\'antiquit&eacute;\": envoyer les candidatures avant le 12 f&eacute;vrier 2012</li>
<li>Appel &agrave; projet duFonds d\'exp&eacute;rimentation pour la jeunesse (FEJ): \"Pr&eacute;vention etlutte contre le harc&egrave;lement &agrave; l\'&eacute;cole\" : r&eacute;pondre avant le 21 novembre 2011 </li>
<li>Regroupement national des CARDIE le 18 octobre 2011 &agrave; la DGESCO</li>
<li>Journ&eacute;es de l\'innovation, les 31 mai et 1er juin 2011&agrave; l\'UNESCO - les temps forts</li>
</ul>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('211', '3', 'Progressions pour l\'cole lmentaire - Actualits', 'http://eduscol.education.fr/cid58402/progressions-pour-l-ecole-elementaire.html', '2012-01-05 01:11:37', '', '2012-01-10 11:18:29', 'publie', '<p>Des progressions pour les domaines d\'enseignement de l\'&eacute;cole &eacute;l&eacute;mentaire sont publi&eacute;es au bulletin officiel du 5 janvier 2012. Con&ccedil;ues &agrave; partir des programmes, elles aident les &eacute;quipes &agrave; organiser la progressivit&eacute; des apprentissages pour chaque ann&eacute;e des cycles 2 et 3. Ces documents de r&eacute;f&eacute;rence viennent compl&eacute;ter les progressions d&eacute;j&agrave; publi&eacute;es pour le fran&ccedil;ais et les math&eacute;matiques.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Grande_taille/20/2/PH022-025_191202.jpg\" type=\"image/jpeg\">PH022-025_191202.jpg</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('210', '3', 'Un vade-mecum sur les quipes mobiles de scurit - Actualits', 'http://eduscol.education.fr/cid58969/un-vade-mecum-sur-les-equipes-mobiles-de-securite.html', '2012-01-09 11:19:16', '', '2012-01-10 11:18:29', 'publie', '<p>Dans chaque acad&eacute;mie, une &eacute;quipe mobile de s&eacute;curit&eacute; (EMS) accompagne les &eacute;tablissements en cas de forte tension, assure la protection des biens et des personnes dans les &eacute;tablissements et am&eacute;liore la prise en charge des &eacute;l&egrave;ves qui ont des conduites probl&eacute;matiques. Pour aider leur pilotage acad&eacute;mique, &eacute;duscol propose un vade-mecum.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('209', '3', 'L\'ducation aux mdia  travers les programmes - Actualits', 'http://eduscol.education.fr/cid58985/l-education-aux-media-a-travers-les-programmes.html', '2012-01-09 05:19:42', '', '2012-01-10 11:18:29', 'publie', '<p>Le Clemi propose en ligne une lecture exhaustive des programmes scolaires sous l\'angle de l\'&eacute;ducation aux m&eacute;dia. Cette mise &agrave; jour effectu&eacute;e en septembre 2011 tient compte des &eacute;volutions apport&eacute;es notamment par le Socle commun de connaissances et de comp&eacute;tences. Le corpus des textes officiels a &eacute;t&eacute; principalement &eacute;tabli &agrave; partir de trois sites : &Eacute;duscol, CNDP et Bulletin officiel.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('207', '3', 'Enseignement technologique et professionnel - Ressources', 'http://eduscol.education.fr/cid48237/enseignement-technologique-et-professionnel.html', '2012-01-02 10:24:26', '', '2012-01-05 01:42:14', 'publie', '', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('208', '3', 'Brevet session 2012 - Ressources', 'http://eduscol.education.fr/cid46834/brevet-session-2012.html', '2012-01-09 03:40:00', '', '2012-01-10 11:18:29', 'publie', '', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('206', '3', 'Consultation sur les projets de programmes - srie STMG - Ressources', 'http://eduscol.education.fr/cid55534/consultation-sur-les-projets-de-programmes-serie-stmg.html', '2012-01-02 10:30:20', '', '2012-01-05 01:42:14', 'publie', '', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Moyenne_taille/10/0/066945_191100.JPG\" type=\"image/jpeg\">066945_191100.JPG</a>, <a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('205', '3', 'Journe franco-allemande - Agenda', 'http://eduscol.education.fr/cid54455/journee-franco-allemande.html', '2012-01-03 03:37:08', '', '2012-01-19 22:50:16', 'publie', '<p>&Agrave; l\'occasion de la c&eacute;l&eacute;bration par le pr&eacute;sident de la R&eacute;publique fran&ccedil;aise et par le chancelier de la R&eacute;publique f&eacute;d&eacute;rale d\'Allemagne du quaranti&egrave;me anniversaire du Trait&eacute; de l\'&Eacute;lys&eacute;e, le 22 janvier 2003, il a &eacute;t&eacute; d&eacute;cid&eacute; que cette date serait la Journ&eacute;e franco-allemande, chaque ann&eacute;eetdans les deux pays. En 2012, &eacute;coles, coll&egrave;ges et lyc&eacute;es fran&ccedil;ais et allemands sont invit&eacute;s &agrave; organiser des activit&eacute;s pluridisciplinaires autour de la langue du partenaire :</p>
<ul>
<li>en France \"L\'allemand, passeport pour l\'avenir\" ;</li>
<li>en Allemagne : \"Franz&ouml;sisch, dein Weg zum Erfolg\".</li>
</ul>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Vignettes_videos/70/9/Journee_Franco-Allemande_2012_204709.jpg\" type=\"image/jpeg\">Journee_Franco-Allemande_2012_204709.jpg</a>, <a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('217', '3', 'Un quatrime vade-mecum - Ressources', 'http://eduscol.education.fr/cid58582/un-quatrieme-vade-mecum.html', '2011-12-07 01:12:15', '', '2012-01-19 22:50:16', 'publie', '<p>\"Innover pour une &eacute;cole des r&eacute;ussites\"<br /> \"Les pr&eacute;fets des &eacute;tudes\"<br />\"Programme ECLAIR\"<br /> \"Le projet p&eacute;dagogique et &eacute;ducatif en internat d\'excellence\"<br /></p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Innovation_experimentation/16/4/CouvertureVademecumInnovation_201164.jpg\" type=\"image/jpeg\">CouvertureVademecumInnovation_201164.jpg</a>, <a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('215', '3', 'Calendrier du programme national de pilotage 2011-2012 - Ressources', 'http://eduscol.education.fr/cid56906/calendrier-du-programme-national-de-pilotage-2011-2012.html', '2012-01-11 09:38:17', '', '2012-01-17 19:46:11', 'publie', '', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('216', '3', 'Assr 2012 : ce qu\'il faut retenir - Actualits', 'http://eduscol.education.fr/cid58988/assr-2012-ce-qu-il-faut-retenir.html', '2012-01-10 01:10:33', '', '2012-01-17 19:46:11', 'publie', '<p>La campagne Assr 2012 est ouverte jusqu\'au 31 mai. Vous pouvez trouver dans cet article tous les &eacute;l&eacute;ments &agrave; retenir pour la mettre en oeuvre de la pr&eacute;paration des &eacute;preuves &agrave; la correction d&eacute;taill&eacute;e. Vous pourrez aussi acc&eacute;der &agrave; un forum technique r&eacute;unissant les questions les plus fr&eacute;quentes.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('214', '3', 'Internet responsable - Actualits', 'http://eduscol.education.fr/cid58727/internet-responsable.html', '2012-01-12 03:14:19', '', '2012-01-17 19:46:11', 'publie', '<p>Afin d\'accompagner les enseignants et les &eacute;l&egrave;ves dans les nouveaux usages de l\'internet, le minist&egrave;re de l\'&eacute;ducation nationale, de la jeunesse et de la vie associative a d&eacute;cid&eacute; de lancer un site fournissant un point d\'entr&eacute;e unique vers des ressources destin&eacute;es &agrave; favoriser la ma&icirc;trise et l\'usage responsable des r&eacute;seaux et des services num&eacute;riques.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/280/31/6/portail-internet-responsable-vignette_204316.png\" type=\"image/jpeg\">portail-internet-responsable-vignette_204316.png</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('213', '3', 'Srie technologique STMG : sminaire national sur les nouveaux programmes - Agenda', 'http://eduscol.education.fr/cid59030/serie-technologique-stmg-seminaire-national-sur-les-nouveaux-programmes.html', '2012-01-13 08:31:52', '', '2012-01-17 19:46:11', 'publie', '<p>Le minist&egrave;re organise un s&eacute;minaire sur les nouveaux programmes de la s&eacute;rie technologique consacr&eacute;e aux sciences et technologies du management et de la gestion, les 24 et 25 janvier 2012 &agrave; Paris. Ce s&eacute;minaire accompagne la r&eacute;forme de la s&eacute;rie STG, \"sciences et technologies de la gestion\", qui entre en application en premi&egrave;re &agrave; la rentr&eacute;e 2012.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('212', '3', 'Le harclement en milieu scolaire - Ressources', 'http://eduscol.education.fr/cid55921/le-harcelement-en-milieu-scolaire.html', '2012-01-16 02:52:21', '', '2012-01-17 19:46:11', 'publie', '<p>Le harc&egrave;lement en milieu scolaire ou \"micro-violence\" constitue une forme de la violence en milieu scolaire. Moins visible que les violences verbales, physiques, d\'atteinte aux biens ou d\'intrusions, le harc&egrave;lement mine, de mani&egrave;re insidieuse et durable, le climat au sein des &eacute;coles et des &eacute;tablissements scolaires, avec des cons&eacute;quences extr&ecirc;mement dommageables, tant pour les victimes que pour les auteurs.</p>', '', '', '', '<a rel=\'directory\'>Ressources</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('154', '3', 'Travailler les capacits en histoire-gographie-ducation civique - Actualits', 'http://eduscol.education.fr/cid58375/travailler-les-capacites-en-histoire-geographie-education-civique.html', '2011-11-09 10:08:16', '', '2011-11-30 19:25:00', 'off', '<p>&Eacute;duscol propose 8 fiches pour travailler les capacit&eacute;s en histoire - g&eacute;ographie - &eacute;ducation civique au coll&egrave;ge, de la sixi&egrave;me &agrave; la troisi&egrave;me.</p>', '', '', '', '<a rel=\"enclosure\" href=\"http://media.eduscol.education.fr/image/Grande_taille/17/5/067906_191175.JPG\" type=\"image/jpeg\">067906_191175.JPG</a>, <a rel=\'directory\'>Actualits</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('219', '3', 'Rencontre autour des langues et cultures de l\'Antiquit - Agenda', 'http://eduscol.education.fr/cid59068/rencontre-autour-des-langues-et-cultures-de-l-antiquite.html', '2012-01-18 04:45:06', '', '2012-01-19 22:50:16', 'publie', '<p>Le minist&egrave;re organise une rencontre autour de l\'enseignement des langues et cultures de l\'Antiquit&eacute; : \"Langues anciennes, mondes modernes : refonder l\'enseignement du latin et du grec\", les 31 janvier et 1er f&eacute;vrier 2012 &agrave; Paris.</p>', '', '', '', '<a rel=\'directory\'>Agenda</a>');
INSERT INTO `spip01_syndic_articles` (`id_syndic_article`, `id_syndic`, `titre`, `url`, `date`, `lesauteurs`, `maj`, `statut`, `descriptif`, `lang`, `url_source`, `source`, `tags`) values ('218', '3', 'Le jeu d\'checs  l\'cole, une autre approche des apprentissages - Actualits', 'http://eduscol.education.fr/cid59057/le-jeu-d-echecs-a-l-ecole-une-autre-approche-des-apprentissages.html', '2012-01-19 10:59:44', '', '2012-01-19 22:50:16', 'publie', '<p>Le plan pour les sciences et technologies &agrave; l\'&Eacute;cole, lanc&eacute; en janvier 2011, incite &agrave; d&eacute;velopper l\'usage des jeux pour apprendre. Il r&eacute;serve une place particuli&egrave;re au jeu d\'&eacute;checs. La pratique de ce jeu conduit &agrave; d&eacute;velopper des comp&eacute;tences, toutes facteurs de r&eacute;ussite, qui mobilisent logique, strat&eacute;gie, rigueur et capacit&eacute; d\'abstraction. Elle facilite aussi l\'apprentissage de la citoyennet&eacute; par le respect des r&egrave;gles et d\'autrui.</p>', '', '', '', '<a rel=\'directory\'>Actualits</a>');

# Structure de la table spip01_types_documents
DROP TABLE IF EXISTS `spip01_types_documents`;

CREATE TABLE `spip01_types_documents` (
  `extension` varchar(10) NOT NULL default '',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `mime_type` varchar(100) NOT NULL default '',
  `inclus` enum('non','image','embed') NOT NULL default 'non',
  `upload` enum('oui','non') NOT NULL default 'oui',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`extension`),
  KEY `inclus` (`inclus`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_types_documents
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('jpg', 'JPEG', '', 'image/jpeg', 'image', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('png', 'PNG', '', 'image/png', 'image', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('gif', 'GIF', '', 'image/gif', 'image', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('bmp', 'BMP', '', 'image/x-ms-bmp', 'image', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('tif', 'TIFF', '', 'image/tiff', 'image', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('aiff', 'AIFF', '', 'audio/x-aiff', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('asf', 'Windows Media', '', 'video/x-ms-asf', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('avi', 'AVI', '', 'video/x-msvideo', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('anx', 'Annodex', '', 'application/annodex', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('axa', 'Annodex Audio', '', 'audio/annodex', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('axv', 'Annodex Video', '', 'video/annodex', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dv', 'Digital Video', '', 'video/x-dv', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4a', 'Audio for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4b', 'Audio Book for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4p', 'Protected Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('f4v', 'Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('flac', 'Free Lossless Audio Codec', '', 'audio/x-flac', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('flv', 'Flash Video', '', 'video/x-flv', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4a', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4b', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4p', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4u', 'MPEG4 playliste', '', 'video/vnd.mpegurl', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('m4v', 'MPEG4 Video', '', 'video/x-m4v', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mid', 'Midi', '', 'audio/midi', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mka', 'Matroska Audio', '', 'audio/mka', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mkv', 'Matroska Video', '', 'video/mkv', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mng', 'MNG', '', 'video/x-mng', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mov', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mp3', 'MP3', '', 'audio/mpeg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mp4', 'MPEG4', '', 'application/mp4', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mpc', 'Musepack', '', 'audio/x-musepack', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('mpg', 'MPEG', '', 'video/mpeg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('oga', 'Ogg Audio', '', 'audio/ogg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ogg', 'Ogg Vorbis', '', 'audio/ogg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ogv', 'Ogg Video', '', 'video/ogg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ogx', 'Ogg Multiplex', '', 'application/ogg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('qt', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ra', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ram', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('rm', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('spx', 'Ogg Speex', '', 'audio/ogg', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('svg', 'Scalable Vector Graphics', '', 'image/svg+xml', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('swf', 'Flash', '', 'application/x-shockwave-flash', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('wav', 'WAV', '', 'audio/x-wav', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('webm', 'WebM', '', 'video/webm', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('wmv', 'Windows Media', '', 'video/x-ms-wmv', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('3gp', '3rd Generation Partnership Project', '', 'video/3gpp', 'embed', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ai', 'Adobe Illustrator', '', 'application/illustrator', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('abw', 'Abiword', '', 'application/abiword', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('bin', 'Binary Data', '', 'application/octet-stream', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('blend', 'Blender', '', 'application/x-blender', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('bz2', 'BZip', '', 'application/x-bzip2', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('c', 'C source', '', 'text/x-csrc', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('css', 'Cascading Style Sheet', '', 'text/css', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('csv', 'Comma Separated Values', '', 'text/csv', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('deb', 'Debian', '', 'application/x-debian-package', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('doc', 'Word', '', 'application/msword', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('djvu', 'DjVu', '', 'image/vnd.djvu', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dvi', 'LaTeX DVI', '', 'application/x-dvi', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('eps', 'PostScript', '', 'application/postscript', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('gz', 'GZ', '', 'application/x-gzip', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('h', 'C header', '', 'text/x-chdr', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('html', 'HTML', '', 'text/html', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('kml', 'Keyhole Markup Language', '', 'application/vnd.google-earth.kml+xml', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('kmz', 'Google Earth Placemark File', '', 'application/vnd.google-earth.kmz', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pas', 'Pascal', '', 'text/x-pascal', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pdf', 'PDF', '', 'application/pdf', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pgn', 'Portable Game Notation', '', 'application/x-chess-pgn', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppt', 'PowerPoint', '', 'application/vnd.ms-powerpoint', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ps', 'PostScript', '', 'application/postscript', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('psd', 'Photoshop', '', 'image/x-photoshop', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('rpm', 'RedHat/Mandrake/SuSE', '', 'application/x-redhat-package-manager', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('rtf', 'RTF', '', 'application/rtf', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sdd', 'StarOffice', '', 'application/vnd.stardivision.impress', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sdw', 'StarOffice', '', 'application/vnd.stardivision.writer', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sit', 'Stuffit', '', 'application/x-stuffit', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sxc', 'OpenOffice.org Calc', '', 'application/vnd.sun.xml.calc', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sxi', 'OpenOffice.org Impress', '', 'application/vnd.sun.xml.impress', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sxw', 'OpenOffice.org', '', 'application/vnd.sun.xml.writer', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('tex', 'LaTeX', '', 'text/x-tex', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('tgz', 'TGZ', '', 'application/x-gtar', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('torrent', 'BitTorrent', '', 'application/x-bittorrent', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ttf', 'TTF Font', '', 'application/x-font-ttf', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('txt', 'texte', '', 'text/plain', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xcf', 'GIMP multi-layer', '', 'application/x-xcf', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xls', 'Excel', '', 'application/vnd.ms-excel', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xspf', 'XSPF', '', 'application/xspf+xml', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xml', 'XML', '', 'application/xml', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('zip', 'Zip', '', 'application/zip', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odt', 'opendocument text', '', 'application/vnd.oasis.opendocument.text', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ods', 'opendocument spreadsheet', '', 'application/vnd.oasis.opendocument.spreadsheet', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odp', 'opendocument presentation', '', 'application/vnd.oasis.opendocument.presentation', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odg', 'opendocument graphics', '', 'application/vnd.oasis.opendocument.graphics', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odc', 'opendocument chart', '', 'application/vnd.oasis.opendocument.chart', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odf', 'opendocument formula', '', 'application/vnd.oasis.opendocument.formula', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odb', 'opendocument database', '', 'application/vnd.oasis.opendocument.database', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odi', 'opendocument image', '', 'application/vnd.oasis.opendocument.image', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('odm', 'opendocument text-master', '', 'application/vnd.oasis.opendocument.text-master', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ott', 'opendocument text-template', '', 'application/vnd.oasis.opendocument.text-template', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ots', 'opendocument spreadsheet-template', '', 'application/vnd.oasis.opendocument.spreadsheet-template', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('otp', 'opendocument presentation-template', '', 'application/vnd.oasis.opendocument.presentation-template', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('otg', 'opendocument graphics-template', '', 'application/vnd.oasis.opendocument.graphics-template', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('cls', 'LaTeX Class', '', 'text/x-tex', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('sty', 'LaTeX Style Sheet', '', 'text/x-tex', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('docm', 'Word', '', 'application/vnd.ms-word.document.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('docx', 'Word', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dotm', 'Word template', '', 'application/vnd.ms-word.template.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('dotx', 'Word template', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('potm', 'Powerpoint template', '', 'application/vnd.ms-powerpoint.template.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('potx', 'Powerpoint template', '', 'application/vnd.openxmlformats-officedocument.presentationml.template', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppam', 'Powerpoint addin', '', 'application/vnd.ms-powerpoint.addin.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppsm', 'Powerpoint slideshow', '', 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('ppsx', 'Powerpoint slideshow', '', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pptm', 'Powerpoint', '', 'application/vnd.ms-powerpoint.presentation.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('pptx', 'Powerpoint', '', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlam', 'Excel', '', 'application/vnd.ms-excel.addin.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlsb', 'Excel binary', '', 'application/vnd.ms-excel.sheet.binary.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlsm', 'Excel', '', 'application/vnd.ms-excel.sheet.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xlsx', 'Excel', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xltm', 'Excel template', '', 'application/vnd.ms-excel.template.macroEnabled.12', 'non', 'oui', '2010-08-11 08:42:33');
INSERT INTO `spip01_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`) values ('xltx', 'Excel template', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'non', 'oui', '2010-08-11 08:42:33');

# Structure de la table spip01_urls
DROP TABLE IF EXISTS `spip01_urls`;

CREATE TABLE `spip01_urls` (
  `url` varchar(255) NOT NULL,
  `type` varchar(15) NOT NULL default 'article',
  `id_objet` bigint(21) NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`url`),
  KEY `type` (`type`,`id_objet`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_urls
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('002-pangnosis-com', 'article', '2', '2010-08-16 20:51:24');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('platonas', 'auteur', '1', '2010-08-16 20:51:25');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('pangnosis', 'rubrique', '10', '2010-08-16 20:51:25');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('kinomichi', 'rubrique', '1', '2010-08-16 20:51:25');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('003-kim-kinomichi-in-munchen', 'article', '3', '2010-08-16 20:54:31');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('004-keb-kinomichi-en-belgique', 'article', '4', '2010-08-16 20:57:14');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('squelette', 'rubrique', '7', '2010-08-17 06:05:26');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('001-bourillon-net', 'article', '1', '2010-08-17 06:05:26');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('003-accueil-eduscol', 'syndic', '3', '2010-09-13 00:51:09');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('003-accueil-eduscol,3', 'site', '3', '2010-09-13 00:51:51');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('enseignement', 'rubrique', '4', '2010-09-13 00:51:53');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('jean-paul-bourillon', 'auteur', '2', '2011-12-11 13:33:19');
INSERT INTO `spip01_urls` (`url`, `type`, `id_objet`, `date`) values ('systemes-d-echanges-locaux', 'rubrique', '3', '2012-01-19 23:21:07');

# Structure de la table spip01_versions
DROP TABLE IF EXISTS `spip01_versions`;

CREATE TABLE `spip01_versions` (
  `id_article` bigint(21) NOT NULL,
  `id_version` bigint(21) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_auteur` varchar(23) NOT NULL default '',
  `titre_version` text NOT NULL,
  `permanent` char(3) default NULL,
  `champs` text,
  PRIMARY KEY  (`id_article`,`id_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_versions
INSERT INTO `spip01_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('1', '1', '2010-08-11 12:44:36', '1', '', 'non', 'a:2:{s:5:\"titre\";s:1:\"1\";s:5:\"texte\";s:1:\"2\";}');
INSERT INTO `spip01_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('2', '1', '2010-08-16 10:48:32', '1', '', 'non', 'a:2:{s:5:\"titre\";s:1:\"1\";s:5:\"texte\";s:0:\"\";}');
INSERT INTO `spip01_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('3', '1', '2010-08-16 20:54:24', '1', '', 'non', 'a:2:{s:5:\"titre\";s:1:\"1\";s:5:\"texte\";s:0:\"\";}');
INSERT INTO `spip01_versions` (`id_article`, `id_version`, `date`, `id_auteur`, `titre_version`, `permanent`, `champs`) values ('4', '1', '2010-08-16 20:57:11', '1', '', 'non', 'a:2:{s:5:\"titre\";s:1:\"1\";s:5:\"texte\";s:0:\"\";}');

# Structure de la table spip01_versions_fragments
DROP TABLE IF EXISTS `spip01_versions_fragments`;

CREATE TABLE `spip01_versions_fragments` (
  `id_fragment` int(10) unsigned NOT NULL default '0',
  `version_min` int(10) unsigned NOT NULL default '0',
  `version_max` int(10) unsigned NOT NULL default '0',
  `id_article` bigint(21) NOT NULL,
  `compress` tinyint(4) NOT NULL,
  `fragment` longblob,
  PRIMARY KEY  (`id_article`,`id_fragment`,`version_min`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_versions_fragments
INSERT INTO `spip01_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '1', '0', 'a:1:{i:1;s:13:\"BOURILLON.NET\";}');
INSERT INTO `spip01_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('2', '1', '1', '1', '0', 'a:1:{i:1;s:27:\"Bienvenue sur Bourillon.net\";}');
INSERT INTO `spip01_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '2', '0', 'a:1:{i:1;s:13:\"pangnosis.com\";}');
INSERT INTO `spip01_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '3', '0', 'a:1:{i:1;s:27:\"KIM : Kinomichi in München\";}');
INSERT INTO `spip01_versions_fragments` (`id_fragment`, `version_min`, `version_max`, `id_article`, `compress`, `fragment`) values ('1', '1', '1', '4', '0', 'a:1:{i:1;s:27:\"KEB : Kinomichi en Belgique\";}');

# Structure de la table spip01_visites
DROP TABLE IF EXISTS `spip01_visites`;

CREATE TABLE `spip01_visites` (
  `date` date NOT NULL,
  `visites` int(10) unsigned NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_visites
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-12', '8', '2010-08-13 07:32:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-11', '1', '2010-08-12 09:41:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-13', '5', '2010-08-14 12:08:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-14', '5', '2010-08-14 21:56:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-15', '2', '2010-08-16 10:40:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-16', '8', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-20', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-22', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-17', '3', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-19', '2', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-23', '2', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-18', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-24', '5', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-28', '5', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-26', '7', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-25', '3', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-27', '6', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-30', '4', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-29', '3', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-08-31', '2', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-01', '2', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-02', '8', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-03', '6', '2010-09-06 14:07:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-04', '1', '2010-09-06 14:07:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-06', '4', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-05', '4', '2010-09-06 14:07:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-11', '7', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-12', '8', '2010-09-13 00:23:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-10', '4', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-07', '9', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-08', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-09', '5', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-13', '7', '2010-09-14 14:21:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-14', '5', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-15', '1', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-16', '3', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-22', '2', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-23', '2', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-20', '3', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-19', '4', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-21', '1', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-17', '1', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-26', '1', '2010-09-27 15:29:09');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-25', '1', '2010-09-27 15:29:09');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-27', '3', '2010-09-30 11:10:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-28', '1', '2010-09-30 11:10:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-09-29', '1', '2010-09-30 11:10:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-01', '1', '2010-10-03 10:36:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-03', '5', '2010-10-06 19:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-04', '3', '2010-10-06 19:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-05', '1', '2010-10-06 19:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-08', '3', '2010-10-09 03:09:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-06', '1', '2010-10-09 03:09:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-07', '1', '2010-10-09 03:09:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-10', '6', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-13', '4', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-12', '2', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-11', '2', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-09', '3', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-17', '2', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-14', '1', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-19', '4', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-20', '2', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-16', '3', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-21', '5', '2010-10-24 13:22:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-15', '1', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-22', '4', '2010-10-24 13:22:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-23', '1', '2010-10-24 13:22:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-24', '4', '2010-10-27 15:03:58');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-25', '4', '2010-10-27 15:03:58');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-27', '2', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-26', '2', '2010-10-27 15:03:58');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-01', '7', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-04', '8', '2010-11-09 09:43:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-02', '3', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-31', '3', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-28', '3', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-10-29', '4', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-03', '1', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-06', '4', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-05', '2', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-09', '4', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-07', '2', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-08', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-10', '2', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-13', '3', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-11', '2', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-12', '4', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-16', '5', '2010-11-17 15:36:30');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-14', '4', '2010-11-17 15:36:30');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-17', '5', '2010-11-20 21:30:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-18', '2', '2010-11-20 21:30:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-20', '4', '2010-11-23 12:21:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-19', '3', '2010-11-20 21:30:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-21', '2', '2010-11-23 12:21:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-23', '3', '2010-11-25 10:33:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-22', '3', '2010-11-23 12:21:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-25', '5', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-24', '4', '2010-11-25 10:33:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-26', '2', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-29', '2', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-27', '2', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-28', '1', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-11-30', '3', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-04', '6', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-01', '3', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-05', '4', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-03', '1', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-02', '1', '2010-12-06 20:49:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-06', '3', '2010-12-10 21:12:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-08', '4', '2010-12-10 21:12:15');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-10', '6', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-07', '3', '2010-12-10 21:12:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-09', '3', '2010-12-10 21:12:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-11', '5', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-14', '3', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-12', '3', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-13', '2', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-16', '2', '2010-12-17 10:03:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-15', '4', '2010-12-17 10:03:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-17', '7', '2010-12-20 11:43:04');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-18', '2', '2010-12-20 11:43:04');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-20', '5', '2010-12-21 16:33:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-19', '3', '2010-12-20 11:43:04');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-21', '3', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-24', '3', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-22', '3', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-25', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-23', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-27', '7', '2010-12-29 02:46:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-26', '2', '2010-12-29 02:46:33');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-28', '1', '2010-12-29 02:46:33');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-29', '4', '2010-12-31 21:13:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-31', '6', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2010-12-30', '3', '2010-12-31 21:13:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-06', '5', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-01', '2', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-05', '2', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-04', '1', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-02', '3', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-03', '1', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-08', '6', '2011-01-09 15:24:31');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-07', '3', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-09', '7', '2011-01-10 20:07:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-10', '5', '2011-01-11 09:52:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-11', '9', '2011-01-12 17:54:12');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-12', '4', '2011-01-13 22:53:45');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-13', '6', '2011-01-15 00:51:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-14', '5', '2011-01-15 00:51:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-15', '11', '2011-01-17 00:33:58');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-16', '9', '2011-01-17 00:33:57');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-17', '7', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-19', '3', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-21', '3', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-18', '5', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-20', '5', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-23', '5', '2011-01-24 19:36:48');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-22', '2', '2011-01-23 21:50:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-24', '5', '2011-01-26 14:49:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-25', '7', '2011-01-26 14:49:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-26', '3', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-28', '4', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-27', '3', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-29', '1', '2011-01-31 22:28:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-31', '4', '2011-02-02 09:14:19');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-01-30', '2', '2011-01-31 22:28:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-01', '1', '2011-02-02 09:14:19');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-02', '7', '2011-02-03 18:21:08');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-03', '5', '2011-02-04 02:17:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-04', '6', '2011-02-06 13:44:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-05', '7', '2011-02-06 13:44:21');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-06', '3', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-07', '6', '2011-02-08 22:47:15');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-08', '4', '2011-02-10 16:00:22');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-10', '5', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-09', '4', '2011-02-10 16:00:22');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-11', '8', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-14', '5', '2011-02-15 20:16:14');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-13', '2', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-15', '2', '2011-02-17 10:46:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-16', '3', '2011-02-17 10:46:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-18', '4', '2011-02-20 17:55:07');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-17', '6', '2011-02-18 17:23:29');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-19', '6', '2011-02-20 17:55:07');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-20', '6', '2011-02-21 22:44:16');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-21', '2', '2011-02-23 15:29:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-23', '6', '2011-02-24 23:18:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-22', '2', '2011-02-23 15:29:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-24', '2', '2011-02-24 23:18:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-26', '4', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-25', '4', '2011-02-26 18:24:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-02', '7', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-01', '6', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-28', '3', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-02-27', '2', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-03', '3', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-04', '3', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-05', '1', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-06', '4', '2011-03-10 00:26:00');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-08', '1', '2011-03-10 00:26:00');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-09', '4', '2011-03-10 00:26:00');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-07', '5', '2011-03-10 00:26:00');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-14', '3', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-12', '4', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-11', '6', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-15', '1', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-10', '4', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-13', '2', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-16', '6', '2011-03-18 11:42:40');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-17', '1', '2011-03-18 11:42:40');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-18', '11', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-19', '2', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-21', '7', '2011-03-23 01:43:58');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-20', '1', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-22', '9', '2011-03-23 01:43:58');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-23', '4', '2011-03-24 00:45:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-24', '8', '2011-03-26 01:06:28');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-25', '2', '2011-03-26 01:06:28');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-28', '1', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-30', '4', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-26', '3', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-29', '7', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-31', '3', '2011-04-02 07:39:33');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-03-27', '2', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-01', '4', '2011-04-02 07:39:33');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-02', '3', '2011-04-04 04:57:14');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-03', '3', '2011-04-04 04:57:14');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-05', '7', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-07', '10', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-04', '2', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-06', '5', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-09', '9', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-10', '5', '2011-04-12 16:25:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-08', '2', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-11', '3', '2011-04-12 16:25:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-12', '4', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-13', '4', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-14', '3', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-22', '2', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-18', '3', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-19', '1', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-16', '4', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-23', '1', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-15', '2', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-20', '2', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-26', '8', '2011-04-29 01:22:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-25', '2', '2011-04-26 19:00:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-24', '2', '2011-04-26 19:00:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-28', '3', '2011-04-29 01:22:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-27', '1', '2011-04-29 01:22:02');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-29', '5', '2011-05-01 17:50:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-04-30', '3', '2011-05-01 17:50:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-01', '7', '2011-05-04 18:11:34');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-02', '4', '2011-05-04 18:11:34');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-03', '2', '2011-05-04 18:11:34');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-04', '2', '2011-05-05 22:49:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-05', '10', '2011-05-08 00:25:27');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-06', '4', '2011-05-08 00:25:27');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-08', '11', '2011-05-10 19:27:18');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-09', '3', '2011-05-10 19:27:18');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-10', '4', '2011-05-12 16:54:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-12', '7', '2011-05-15 05:50:45');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-11', '1', '2011-05-12 16:54:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-13', '2', '2011-05-15 05:50:45');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-14', '2', '2011-05-15 05:50:45');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-20', '4', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-15', '5', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-19', '2', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-17', '4', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-18', '3', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-16', '1', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-22', '3', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-23', '3', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-24', '3', '2011-05-27 19:13:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-25', '4', '2011-05-27 19:13:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-27', '3', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-26', '2', '2011-05-27 19:13:24');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-28', '1', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-29', '1', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-05', '3', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-03', '3', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-30', '3', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-05-31', '1', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-01', '1', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-08', '11', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-07', '3', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-27', '1', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-17', '2', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-21', '2', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-06', '4', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-19', '3', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-20', '2', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-15', '1', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-16', '1', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-14', '1', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-22', '1', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-18', '1', '2011-06-29 00:27:43');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-04', '4', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-03', '2', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-29', '2', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-06-30', '4', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-07', '2', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-09', '3', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-05', '2', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-01', '1', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-10', '4', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-08', '1', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-02', '1', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-13', '2', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-18', '3', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-12', '3', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-11', '3', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-15', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-02', '3', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-04', '2', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-07', '3', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-03', '2', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-29', '2', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-26', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-11', '5', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-05', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-09', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-25', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-01', '2', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-24', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-13', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-28', '2', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-15', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-20', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-27', '2', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-21', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-23', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-07-31', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-16', '3', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-17', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-05', '2', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-21', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-19', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-22', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-01', '4', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-31', '3', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-04', '2', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-02', '2', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-07', '5', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-03', '4', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-24', '2', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-18', '2', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-30', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-06', '4', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-28', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-08-25', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-11', '3', '2011-09-17 08:10:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-10', '4', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-08', '3', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-13', '5', '2011-09-17 08:10:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-16', '1', '2011-09-17 08:10:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-17', '6', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-14', '4', '2011-09-17 08:10:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-12', '2', '2011-09-17 08:10:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-15', '3', '2011-09-17 08:10:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-22', '1', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-23', '2', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-18', '2', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-21', '1', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-20', '3', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-24', '1', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-19', '1', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-25', '4', '2011-09-28 14:36:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-28', '3', '2011-10-01 13:53:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-26', '1', '2011-09-28 14:36:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-27', '2', '2011-09-28 14:36:17');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-30', '4', '2011-10-01 13:53:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-09-29', '5', '2011-10-01 13:53:26');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-01', '7', '2011-10-02 11:00:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-02', '5', '2011-10-03 17:48:23');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-03', '4', '2011-10-06 17:50:12');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-06', '4', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-05', '1', '2011-10-06 17:50:12');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-04', '3', '2011-10-06 17:50:12');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-09', '3', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-07', '3', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-08', '1', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-12', '5', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-10', '4', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-11', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-13', '2', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-14', '2', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-15', '4', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-20', '6', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-18', '3', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-16', '4', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-22', '5', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-19', '4', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-21', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-23', '3', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-17', '1', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-30', '2', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-28', '6', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-24', '5', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-29', '2', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-25', '4', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-26', '2', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-27', '2', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-09', '7', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-03', '3', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-06', '4', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-08', '6', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-05', '2', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-10-31', '3', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-01', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-04', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-02', '3', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-10', '5', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-12', '6', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-11', '6', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-14', '5', '2011-11-16 08:51:48');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-13', '3', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-15', '2', '2011-11-16 08:51:48');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-16', '4', '2011-11-19 12:36:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-17', '3', '2011-11-19 12:36:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-18', '2', '2011-11-19 12:36:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-19', '4', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-21', '3', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-22', '4', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-23', '4', '2011-11-24 20:37:30');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-20', '6', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-24', '5', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-28', '3', '2011-12-01 20:46:09');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-30', '4', '2011-12-01 20:46:09');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-01', '5', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-26', '3', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-25', '1', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-27', '2', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-11-29', '1', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-06', '5', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-04', '2', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-03', '4', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-09', '3', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-02', '2', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-08', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-10', '5', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-11', '4', '2011-12-12 21:15:30');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-12', '6', '2011-12-15 20:00:01');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-14', '1', '2011-12-15 20:00:01');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-13', '3', '2011-12-15 20:00:01');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-15', '4', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-17', '4', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-18', '5', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-16', '4', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-19', '4', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-21', '7', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-22', '5', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-30', '2', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-23', '3', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-20', '3', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-28', '5', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-27', '2', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-25', '4', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-24', '2', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-29', '2', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-26', '2', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-02', '2', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-04', '3', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-05', '2', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-06', '8', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-03', '4', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-01', '4', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2011-12-31', '4', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-10', '6', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-12', '3', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-08', '7', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-09', '4', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-07', '5', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-11', '2', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-13', '5', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-15', '3', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-14', '3', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-17', '4', '2012-01-19 22:50:56');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-16', '1', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites` (`date`, `visites`, `maj`) values ('2012-01-19', '3', '2012-01-20 09:05:55');

# Structure de la table spip01_visites_articles
DROP TABLE IF EXISTS `spip01_visites_articles`;

CREATE TABLE `spip01_visites_articles` (
  `date` date NOT NULL,
  `id_article` int(10) unsigned NOT NULL,
  `visites` int(10) unsigned NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`date`,`id_article`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_visites_articles
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-16', '4', '2', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-16', '2', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-16', '3', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-17', '3', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-23', '4', '1', '2010-08-24 12:01:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-26', '3', '1', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-26', '4', '1', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-25', '2', '1', '2010-08-28 08:23:57');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-08-28', '4', '1', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-01', '2', '1', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-01', '3', '1', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-01', '4', '1', '2010-09-02 10:13:52');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-02', '4', '2', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-02', '3', '2', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-02', '2', '2', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-03', '4', '2', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-03', '3', '2', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-03', '2', '2', '2010-09-03 15:49:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-11', '4', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-11', '3', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-11', '2', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-07', '2', '2', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-07', '3', '2', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-07', '4', '2', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-06', '4', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-06', '3', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-06', '2', '1', '2010-09-12 13:17:21');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-12', '1', '1', '2010-09-13 00:23:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-12', '2', '1', '2010-09-13 00:23:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-12', '3', '1', '2010-09-13 00:23:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-12', '4', '1', '2010-09-13 00:23:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-13', '4', '1', '2010-09-13 17:03:50');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-13', '3', '1', '2010-09-13 17:03:50');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-13', '2', '1', '2010-09-13 17:03:50');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-14', '4', '1', '2010-09-23 01:13:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-27', '4', '1', '2010-09-30 11:10:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-09-27', '3', '1', '2010-09-30 11:10:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-03', '3', '3', '2010-10-06 19:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-03', '4', '3', '2010-10-06 19:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-03', '2', '1', '2010-10-06 19:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-06', '2', '1', '2010-10-09 03:09:49');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-10', '1', '2', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-10', '4', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-10', '3', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-10', '2', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-13', '4', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-13', '3', '2', '2010-10-21 13:45:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-13', '2', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-11', '4', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-11', '3', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-11', '2', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-09', '4', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-09', '3', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-09', '2', '1', '2010-10-13 08:40:02');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-24', '2', '1', '2010-10-27 15:03:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-25', '2', '1', '2010-10-27 15:03:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-02', '4', '1', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-02', '3', '1', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-02', '2', '1', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-10-28', '3', '1', '2010-11-04 11:34:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-04', '2', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-06', '3', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-06', '2', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-06', '4', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-05', '2', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-05', '4', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-05', '3', '1', '2010-11-09 09:43:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-09', '12', '1', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-11', '4', '1', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-11', '3', '1', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-11', '2', '1', '2010-11-14 11:24:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-16', '2', '2', '2010-11-17 15:36:30');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-21', '4', '1', '2010-11-23 12:21:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-21', '2', '1', '2010-11-23 12:21:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-21', '3', '1', '2010-11-23 12:21:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-23', '4', '1', '2010-11-25 10:33:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-23', '3', '1', '2010-11-25 10:33:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-23', '2', '1', '2010-11-25 10:33:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-26', '2', '1', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-26', '3', '1', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-11-26', '4', '1', '2010-11-29 08:58:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-10', '3', '2', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-10', '4', '2', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-10', '2', '2', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-12', '3', '1', '2010-12-15 00:47:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-15', '3', '1', '2010-12-17 10:03:18');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-15', '2', '1', '2010-12-17 10:03:18');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-20', '4', '1', '2010-12-21 16:33:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-22', '4', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-22', '3', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-22', '2', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-21', '4', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-21', '3', '1', '2010-12-26 02:08:36');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-27', '2', '2', '2010-12-29 02:46:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-27', '3', '2', '2010-12-29 02:46:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-27', '4', '2', '2010-12-29 02:46:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-30', '4', '1', '2010-12-31 21:13:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2010-12-30', '3', '1', '2010-12-31 21:13:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-06', '3', '1', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-06', '2', '1', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-06', '4', '1', '2011-01-06 19:43:16');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-08', '2', '1', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-08', '3', '1', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-08', '4', '1', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-07', '4', '1', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-07', '3', '1', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-07', '2', '1', '2011-01-08 12:57:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-11', '3', '1', '2011-01-12 17:54:12');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-11', '4', '1', '2011-01-12 17:54:12');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-12', '4', '1', '2011-01-13 22:53:45');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-15', '3', '4', '2011-01-17 00:33:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-15', '4', '2', '2011-01-17 00:33:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-15', '2', '2', '2011-01-17 00:33:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-16', '4', '1', '2011-01-17 00:33:57');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-16', '3', '1', '2011-01-17 00:33:57');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-16', '2', '1', '2011-01-17 00:33:57');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-19', '3', '1', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-19', '2', '1', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-19', '4', '1', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-18', '3', '1', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-18', '4', '1', '2011-01-22 01:56:44');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-23', '1', '1', '2011-01-23 21:50:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-25', '4', '2', '2011-01-26 14:49:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-25', '1', '1', '2011-01-26 14:49:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-25', '2', '1', '2011-01-26 14:49:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-25', '3', '1', '2011-01-26 14:49:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-28', '4', '2', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-28', '3', '1', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-28', '2', '1', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-01-27', '3', '1', '2011-01-29 06:04:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-02', '3', '2', '2011-02-03 18:21:08');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-02', '4', '3', '2011-02-03 18:21:08');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-02', '2', '2', '2011-02-03 18:21:08');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-07', '2', '1', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-07', '3', '1', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-07', '4', '1', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-06', '2', '1', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-06', '3', '1', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-06', '4', '1', '2011-02-07 15:02:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-09', '4', '1', '2011-02-10 16:00:22');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-09', '3', '1', '2011-02-10 16:00:22');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-08', '4', '1', '2011-02-10 16:00:22');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-11', '2', '2', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-11', '3', '2', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-11', '4', '2', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-13', '3', '1', '2011-02-14 22:29:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-15', '3', '1', '2011-02-17 10:46:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-17', '4', '1', '2011-02-18 17:23:29');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-17', '3', '1', '2011-02-18 17:23:29');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-19', '4', '1', '2011-02-20 17:55:07');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-20', '3', '1', '2011-02-20 17:55:07');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-20', '4', '1', '2011-02-21 22:44:16');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-02-21', '3', '1', '2011-02-23 15:29:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-02', '4', '2', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-02', '3', '1', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-02', '2', '1', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-01', '2', '1', '2011-03-02 12:58:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-05', '4', '1', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-05', '3', '1', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-05', '2', '1', '2011-03-06 10:42:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-12', '4', '1', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-12', '3', '1', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-12', '2', '1', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-11', '4', '1', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-11', '2', '1', '2011-03-16 03:06:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-16', '4', '1', '2011-03-18 11:42:40');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-16', '3', '1', '2011-03-18 11:42:40');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-16', '2', '1', '2011-03-18 11:42:40');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-18', '2', '1', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-21', '4', '1', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-21', '3', '1', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-21', '2', '1', '2011-03-21 17:38:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-22', '4', '2', '2011-03-23 01:43:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-22', '3', '2', '2011-03-23 01:43:58');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-24', '4', '1', '2011-03-26 01:06:28');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-24', '2', '1', '2011-03-26 01:06:28');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-29', '3', '1', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-03-27', '3', '1', '2011-03-31 23:02:23');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-01', '4', '1', '2011-04-02 07:39:33');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-03', '4', '1', '2011-04-04 04:57:14');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-05', '1', '1', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-05', '8', '1', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-04', '4', '1', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-06', '4', '2', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-06', '3', '2', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-06', '2', '2', '2011-04-07 17:30:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-09', '1', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-09', '4', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-09', '3', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-09', '2', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-10', '4', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-10', '3', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-10', '2', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-07', '3', '3', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-07', '4', '2', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-07', '2', '2', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-08', '2', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-08', '3', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-08', '4', '1', '2011-04-10 02:47:53');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-12', '4', '1', '2011-04-12 16:25:43');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-12', '3', '1', '2011-04-12 16:25:43');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-12', '2', '1', '2011-04-12 16:25:43');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-13', '4', '1', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-13', '3', '1', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-13', '2', '1', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-14', '4', '1', '2011-04-15 18:31:01');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-20', '2', '1', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-20', '3', '1', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-20', '4', '1', '2011-04-24 18:35:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-26', '2', '1', '2011-04-26 19:00:26');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-26', '3', '1', '2011-04-26 19:00:26');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-04-29', '2', '1', '2011-05-01 17:50:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-11', '3', '1', '2011-05-12 16:54:49');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-12', '3', '1', '2011-05-15 05:50:45');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-20', '4', '1', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-20', '3', '1', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-20', '2', '2', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-15', '4', '1', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-15', '3', '1', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-15', '2', '1', '2011-05-20 15:21:35');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-22', '4', '1', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-22', '3', '1', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-22', '2', '1', '2011-05-24 22:59:04');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-25', '2', '2', '2011-05-27 19:13:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-24', '2', '1', '2011-05-27 19:13:24');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-05-31', '3', '1', '2011-06-05 22:26:36');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-06-29', '2', '1', '2011-07-10 11:02:42');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-13', '4', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-13', '3', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-13', '2', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-18', '4', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-18', '3', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-18', '2', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-10', '3', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-11', '4', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-11', '3', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-11', '2', '1', '2011-07-18 10:07:47');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-01', '2', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-24', '8', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-24', '4', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-24', '3', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-24', '2', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-31', '4', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-07-31', '3', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-16', '4', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-16', '3', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-16', '2', '1', '2011-08-16 19:24:38');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-01', '4', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-01', '3', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-01', '2', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-02', '2', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-02', '4', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-24', '2', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-30', '4', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-08-30', '3', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-06', '2', '1', '2011-09-07 14:50:11');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-08', '4', '1', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-08', '3', '1', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-08', '2', '1', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-07', '2', '2', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-07', '3', '1', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-07', '4', '1', '2011-09-11 19:52:54');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-17', '3', '2', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-17', '2', '1', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-17', '4', '1', '2011-09-24 23:54:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-25', '4', '1', '2011-09-28 14:36:17');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-25', '2', '1', '2011-09-28 14:36:17');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-09-29', '2', '1', '2011-10-01 13:53:26');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-02', '2', '1', '2011-10-02 21:42:29');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-06', '2', '2', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-06', '3', '1', '2011-10-06 17:50:12');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-06', '4', '1', '2011-10-06 17:50:12');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-03', '2', '1', '2011-10-06 17:50:12');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-07', '3', '1', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-07', '2', '1', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-07', '4', '1', '2011-10-09 19:29:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-12', '3', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-12', '2', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-12', '4', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-10', '4', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-10', '3', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-10', '2', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-11', '4', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-13', '2', '1', '2011-10-15 12:22:55');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-20', '1', '4', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-20', '2', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-20', '4', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-20', '3', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-22', '1', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-22', '2', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-22', '4', '3', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-22', '3', '2', '2011-10-23 14:36:25');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-28', '4', '1', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-28', '3', '1', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-28', '2', '1', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-23', '4', '1', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-25', '4', '1', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-10-25', '2', '1', '2011-10-30 14:21:39');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-09', '4', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-09', '3', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-09', '2', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-08', '2', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-08', '3', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-08', '4', '1', '2011-11-10 10:56:32');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-10', '4', '1', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-10', '3', '1', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-10', '2', '1', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-11', '2', '1', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-13', '2', '2', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-13', '4', '1', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-13', '3', '1', '2011-11-14 18:32:20');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-15', '4', '1', '2011-11-16 08:51:48');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-15', '3', '1', '2011-11-16 08:51:48');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-20', '4', '2', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-20', '2', '1', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-20', '3', '1', '2011-11-23 19:53:59');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-30', '4', '1', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-30', '3', '1', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-11-30', '2', '1', '2011-12-01 20:46:10');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-06', '4', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-06', '3', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-06', '2', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-01', '4', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-01', '3', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-01', '2', '2', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-04', '2', '1', '2011-12-09 22:38:13');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-10', '4', '1', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-10', '3', '1', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-10', '2', '1', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-11', '3', '1', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-11', '2', '1', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-11', '4', '1', '2011-12-11 12:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-12', '4', '1', '2011-12-12 21:15:30');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-12', '3', '1', '2011-12-12 21:15:30');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-12', '2', '1', '2011-12-12 21:15:30');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-12', '7', '1', '2011-12-12 21:15:30');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-17', '4', '1', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-17', '3', '1', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-17', '2', '1', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-15', '4', '1', '2011-12-19 19:04:46');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-21', '4', '1', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-22', '3', '1', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-20', '2', '1', '2011-12-30 09:59:05');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-28', '4', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-28', '3', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-28', '2', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-27', '4', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-27', '3', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-27', '2', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-25', '3', '2', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-25', '4', '2', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-25', '2', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-24', '4', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-24', '3', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2011-12-24', '2', '1', '2011-12-30 09:59:06');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-04', '4', '1', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-06', '4', '2', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-06', '3', '1', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-06', '2', '1', '2012-01-06 18:08:03');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-10', '3', '2', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-10', '2', '3', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-10', '1', '1', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-10', '4', '2', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-08', '2', '3', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-08', '4', '2', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-08', '3', '2', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-09', '2', '1', '2012-01-13 01:54:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-15', '4', '1', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-15', '3', '1', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-15', '2', '1', '2012-01-17 19:47:49');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-17', '2', '1', '2012-01-19 22:50:56');
INSERT INTO `spip01_visites_articles` (`date`, `id_article`, `visites`, `maj`) values ('2012-01-19', '4', '1', '2012-01-19 22:50:56');

# Structure de la table spip01_zones
DROP TABLE IF EXISTS `spip01_zones`;

CREATE TABLE `spip01_zones` (
  `id_zone` bigint(21) NOT NULL auto_increment,
  `titre` varchar(255) NOT NULL default '',
  `descriptif` text NOT NULL,
  `publique` enum('non','oui') NOT NULL default 'oui',
  `privee` enum('non','oui') NOT NULL default 'non',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id_zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_zones

# Structure de la table spip01_zones_auteurs
DROP TABLE IF EXISTS `spip01_zones_auteurs`;

CREATE TABLE `spip01_zones_auteurs` (
  `id_zone` bigint(21) NOT NULL,
  `id_auteur` bigint(21) NOT NULL,
  PRIMARY KEY  (`id_zone`,`id_auteur`),
  KEY `id_auteur` (`id_auteur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_zones_auteurs

# Structure de la table spip01_zones_rubriques
DROP TABLE IF EXISTS `spip01_zones_rubriques`;

CREATE TABLE `spip01_zones_rubriques` (
  `id_zone` bigint(21) NOT NULL,
  `id_rubrique` bigint(21) NOT NULL,
  PRIMARY KEY  (`id_zone`,`id_rubrique`),
  KEY `id_rubrique` (`id_rubrique`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Donnees de spip01_zones_rubriques

# Structure de la table spip_articles
DROP TABLE IF EXISTS `spip_articles`;

CREATE TABLE `spip_articles` (
  `id_article` bigint(21) NOT NULL auto_increment,
  `surtitre` text NOT NULL,
  `titre` text NOT NULL,
  `soustitre` text NOT NULL,
  `id_rubrique` bigint(21) NOT NULL default '0',
  `descriptif` text NOT NULL,
  `chapo` mediumtext NOT NULL,
  `texte` longtext NOT NULL,
  `ps` mediumtext NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `statut` varchar(10) NOT NULL default '0',
  `id_secteur` bigint(21) NOT NULL default '0',
  `maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `export` varchar(10) default 'oui',
  `date_redac` datetime NOT NULL default '0000-00-00 00:00:00',
  `visites` int(11) NOT NULL default '0',
  `referers` int(11) NOT NULL default '0',
  `popularite` double NOT NULL default '0',
  `accepter_forum` char(3) NOT NULL default '',
  `date_modif` datetime NOT NULL default '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL default '',
  `langue_choisie` varchar(3) default 'non',
  `id_trad` bigint(21) NOT NULL default '0',
  `extra` longtext,
  `id_version` int(10) unsigned NOT NULL default '0',
  `nom_site` tinytext NOT NULL,
  `url_site` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id_article`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `id_trad` (`id_trad`),
  KEY `lang` (`lang`),
  KEY `statut` (`statut`,`date`)
) ENGINE=MyISAM AUTO_INCREMENT=80 DEFAULT CHARSET=latin1;

# Donnees de spip_articles
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('1', '', 'Théodore Troupis', '', '2', '', '', '[?Théodore Troupis] est né dans un petit village montagnard d\'Arcadie du nom de Servou en 1932. A 9 mois, il perd son père. Plus tard, il étudie tout en travaillant. Il poursuit ses études dans l\'école primaire de son village natal, puis ses études secondaires au collège de Lakadie. Enfin, il se rend à l\'Académie pédagogique de Tripoli pour y suivre la formation d\'Instituteur.

En 1955, il fait son service militaire.

En 1957, il est nommé instituteur dans la région de Lassona. Puis il est muté dans la région de Patras et a enseigné à l\'Ecole de Metochion et de Kato Achaia d\'où il prend sa retraite le 31 août 1988.

Ses supérieurs hiérarchiques l\'ont toujours considéré comme un excellent enseignant en lui attribuant toujours la note d\'évaluation pédagogique maximale.

Il a publié de nombreux articles dans des revues pédagogiques.

Marié depuis 1964, il a deux fils et une fille. 

Il apparaît en 1952 dans le monde littéraire en publiant ses vers dans différentes revues.

En 1957, il publie son premier recueil poétique.

Le 29 novembre 1959, il donne sa première conférence intitulée \"Kostis Palamas, centième anniversaire de  sa naissance\". La même année, il reçoit le premier prix de l\'Académie d\'Athènes et de l\'Académie des Langues pour son travail ethnographique. La même année, il publie à Larissa sa nouvelle {Les hommes de l\'échaffaudage}, bien reçu par la critique et qui a été depuis réédité trois fois.

Ses oeuvres couvrent tous les genres littéraires. Demothènes Zadès l\'a caractérisé ainsi : \"virtuose du récit bref.\" Christos Katsiyianis s\'adresse à lui ainsi : \"la réalisation de vos interrogations intellectuelles et émotionnelles est  réussie et même bouleversante.\"

Giorgos Papastamos a écrit que {Les hommes de l\'échaffaudage} est un livre polysémique et important.

Il dirige et publie la revue \"Morias\" depuis 1986.

Des extraits de ses oeuvres ont été publiés dans différentes encyclopédies et anthologies. La plus grande partie de son oeuvre n\'a pas encore été publiée.', '', '2005-12-17 13:11:51', 'publie', '2', '2010-08-14 22:30:37', 'oui', '0000-00-00 00:00:00', '2637', '0', '0.543594015976413', 'non', '2008-01-03 22:01:02', 'fr', 'non', '0', '', '3', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('11', '<multi>[fr]Les métamorphoses, Ovide[en]Les métamorphoses, Ovide[de]Les métamorphoses, Ovide</multi>', '<multi>[fr]Orphée et Eurydice[en]Orphée et Eurydice[de]Orphée et Eurydice</multi>', '<multi>[fr]Traduction  de G.T. Villenave, Paris, 1806 [en]Traduction  de G.T. Villenave, Paris, 1806 [de]Traduction  de G.T. Villenave, Paris, 1806 </multi>', '60', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', '<multi>[fr][10,0] LIVRE DIX. 

[10,1] L\'Hymen, vêtu d\'une robe de pourpre, s\'élève des champs de Crète, dans les airs, et vole vers la Thrace, où la voix d\'Orphée l\'appelle en vain à ses autels. L\'Hymen est présent à son union avec Eurydice, mais il ne profère point les mots sacrés; il ne porte ni visage serein, ni présages heureux. La torche qu\'il tient pétille, répand une fumée humide, et le dieu qui l\'agite ne peut ranimer ses mourantes clartés. Un affreux événement suit de près cet augure sinistre. Tandis que la nouvelle épouse court sur l\'herbe fleurie, 

[10,10] un serpent la blesse au talon elle pâlit, tombe et meurt au milieu de ses compagnes. 
Après avoir longtemps imploré par ses pleurs les divinités de l\'Olympe, le chantre du Rhodope osa franchir les portes du Ténare, et passer les noirs torrents du Styx, pour fléchir les dieux du royaume des morts. Il marche à travers les ombres légères, fantômes errants dont les corps ont reçu les honneurs du tombeau. Il arrive au pied du trône de Proserpine et de Pluton, souverains de ce triste et ténébreux empire. Là, unissant sa voix plaintive aux accords de sa lyre, il fait entendre ces chants : \"Divinités du monde souterrain où descendent successivement tous les mortels, 

[10,20] souffrez que je laisse les vains détours d\'une éloquence trompeuse. Ce n\'est ni pour visiter le sombre Tartare, ni pour enchaîner le monstre à trois têtes, né du sang de Méduse, et gardien des Enfers, que je suis descendu dans votre empire. Je viens chercher mon épouse. La dent d\'une vipère me l\'a ravie au printemps de ses jours. 
J\'ai voulu supporter cette perte; j\'ai voulu, je l\'avoue, vaincre ma douleur. L\'Amour a triomphé. La puissance de ce dieu est établie sur la terre et dans le ciel; je ne sais si elle l\'est aux enfers : mais je crois qu\'elle n\'y est pas inconnue; et, si la renommée d\'un enlèvement antique n\'a rien de mensonger, c\'est l\'amour qui vous a soumis; c\'est lui qui vous unit. Je vous en conjure donc 

[10,30] par ces lieux pleins d\'effroi, par ce chaos immense, par le vaste silence de ces régions de la Nuit, rendez-moi mon Eurydice; renouez le fil de ses jours trop tôt par la Parque coupé. 
\"Les mortels vous sont tous soumis. Après un court séjour sur la terre un peu plus tôt ou un peu plus tard, nous arrivons dans cet asile ténébreux; nous y tendons tous également; c\'est ici notre dernière demeure. Vous tenez sous vos lois le vaste empire du genre humain. Lorsque Eurydice aura rempli la mesure ordinaire de la vie, elle rentrera sous votre puissance. Hélas ! c\'est un simple délai que je demande; et si les Destins s\'opposent à mes vœux, je renonce moi-même à retourner sur la terre. Prenez aussi ma vie, et réjouissez-vous d\'avoir deux ombres à la fois.\" 

[10,40] Aux tristes accents de sa voix, accompagnés des sons plaintifs de sa lyre, les ombres et les mânes pleurent attendris. Tantale cesse de poursuivre l\'onde qui le fuit. Ixion s\'arrête sur sa roue. Les vautours ne rongent plus les entrailles de Tityos. L\'urne échappe aux mains des filles de Bélus, et toi, Sisyphe, tu t\'assieds sur ta roche fatale. On dit même que, vaincues par le charme des vers, les inflexibles Euménides s\'étonnèrent de pleurer pour la première fois. Ni le dieu de l\'empire des morts, ni son épouse, ne peuvent résister aux accords puissants du chantre de la Thrace. 
Ils appellent Eurydice. Elle était parmi les ombres récemment arrivées au ténébreux séjour. Elle s\'avance d\'un pas lent, retardé par sa blessure. 

[10,50] Elle est rendue à son époux : mais, telle est la loi qu\'il reçoit : si, avant d\'avoir franchi les sombres détours de l\'Averne, il détourne la tête pour regarder Eurydice, sa grâce est révoquée; Eurydice est perdue pour lui sans retour. À travers le vaste silence du royaume des ombres, ils remontent par un sentier escarpé, tortueux, couvert de longues ténèbres. Ils approchaient des portes du Ténare. Orphée, impatient de crainte et d\'amour, se détourne, regarde, et soudain Eurydice lui est encore ravie. 
Le malheureux Orphée lui tend les bras, Il veut se jeter dans les siens : il n\'embrasse qu\'une vapeur légère. 

[10,60] Eurydice meurt une seconde fois, mais sans se plaindre; et quelle plainte eût-elle pu former ? Était-ce pour Orphée un crime de l\'avoir trop aimée ! Adieu, lui dit-elle d\'une voix faible qui fut à peine entendue; et elle rentre dans les abîmes du trépas. 
Privé d\'une épouse qui lui est deux fois ravie, Orphée est immobile, étonné, tel que ce berger timide qui voyant le triple Cerbère, chargé de chaînes, traîné par le grand Alcide jusqu\'aux portes du jour, ne cessa d\'être frappé de stupeur que lorsqu\'il fut transformé en rocher. Tel encore Olénus, ce tendre époux qui voulut se charger de ton crime, 

[10,70] infortunée Léthéa, trop vaine de ta beauté. Jadis unis par l\'hymen, ils ne font qu\'un même rocher, soutenu par l\'Ida sur son humide sommet. 
En vain le chantre de la Thrace veut repasser le Styx et fléchir l\'inflexible Charon. Toujours refusé, il reste assis sur la rive infernale, ne se nourrissant que de ses larmes, du trouble de son âme, et de sa douleur. Enfin, las d\'accuser la cruauté des dieux de l\'Érèbe, il se retire sur le mont Rhodope, et sur l\'Hémus battu des Aquilons. Trois fois le soleil avait ramené les saisons. 

[10,80] Orphée fuyait les femmes et l\'amour : soit qu\'il déplorât le sort de sa première flamme, soit qu\'il eût fait serment d\'être fidèle à Eurydice. 
En vain pour lui mille beautés soupirent; toutes se plaignent de ses refus. Mais ce fut lui qui, par son exemple, apprit aux Thraces à rechercher ce printemps fugitif de l\'âge placé entre l\'enfance et la jeunesse, et à s\'égarer dans des amours que la nature désavoue. 
Une colline à son sommet se terminait en plaine. Elle était couverte d\'un gazon toujours vert; mais c\'était un lieu sans ombre. Dès que le chantre immortel, fils des dieux, s\'y fut assis, et qu\'il eut agité les cordes de sa lyre, 
[en][10,0] LIVRE DIX. 

[10,1] L\'Hymen, vêtu d\'une robe de pourpre, s\'élève des champs de Crète, dans les airs, et vole vers la Thrace, où la voix d\'Orphée l\'appelle en vain à ses autels. L\'Hymen est présent à son union avec Eurydice, mais il ne profère point les mots sacrés; il ne porte ni visage serein, ni présages heureux. La torche qu\'il tient pétille, répand une fumée humide, et le dieu qui l\'agite ne peut ranimer ses mourantes clartés. Un affreux événement suit de près cet augure sinistre. Tandis que la nouvelle épouse court sur l\'herbe fleurie, 

[10,10] un serpent la blesse au talon elle pâlit, tombe et meurt au milieu de ses compagnes. 
Après avoir longtemps imploré par ses pleurs les divinités de l\'Olympe, le chantre du Rhodope osa franchir les portes du Ténare, et passer les noirs torrents du Styx, pour fléchir les dieux du royaume des morts. Il marche à travers les ombres légères, fantômes errants dont les corps ont reçu les honneurs du tombeau. Il arrive au pied du trône de Proserpine et de Pluton, souverains de ce triste et ténébreux empire. Là, unissant sa voix plaintive aux accords de sa lyre, il fait entendre ces chants : \"Divinités du monde souterrain où descendent successivement tous les mortels, 

[10,20] souffrez que je laisse les vains détours d\'une éloquence trompeuse. Ce n\'est ni pour visiter le sombre Tartare, ni pour enchaîner le monstre à trois têtes, né du sang de Méduse, et gardien des Enfers, que je suis descendu dans votre empire. Je viens chercher mon épouse. La dent d\'une vipère me l\'a ravie au printemps de ses jours. 
J\'ai voulu supporter cette perte; j\'ai voulu, je l\'avoue, vaincre ma douleur. L\'Amour a triomphé. La puissance de ce dieu est établie sur la terre et dans le ciel; je ne sais si elle l\'est aux enfers : mais je crois qu\'elle n\'y est pas inconnue; et, si la renommée d\'un enlèvement antique n\'a rien de mensonger, c\'est l\'amour qui vous a soumis; c\'est lui qui vous unit. Je vous en conjure donc 

[10,30] par ces lieux pleins d\'effroi, par ce chaos immense, par le vaste silence de ces régions de la Nuit, rendez-moi mon Eurydice; renouez le fil de ses jours trop tôt par la Parque coupé. 
\"Les mortels vous sont tous soumis. Après un court séjour sur la terre un peu plus tôt ou un peu plus tard, nous arrivons dans cet asile ténébreux; nous y tendons tous également; c\'est ici notre dernière demeure. Vous tenez sous vos lois le vaste empire du genre humain. Lorsque Eurydice aura rempli la mesure ordinaire de la vie, elle rentrera sous votre puissance. Hélas ! c\'est un simple délai que je demande; et si les Destins s\'opposent à mes vœux, je renonce moi-même à retourner sur la terre. Prenez aussi ma vie, et réjouissez-vous d\'avoir deux ombres à la fois.\" 

[10,40] Aux tristes accents de sa voix, accompagnés des sons plaintifs de sa lyre, les ombres et les mânes pleurent attendris. Tantale cesse de poursuivre l\'onde qui le fuit. Ixion s\'arrête sur sa roue. Les vautours ne rongent plus les entrailles de Tityos. L\'urne échappe aux mains des filles de Bélus, et toi, Sisyphe, tu t\'assieds sur ta roche fatale. On dit même que, vaincues par le charme des vers, les inflexibles Euménides s\'étonnèrent de pleurer pour la première fois. Ni le dieu de l\'empire des morts, ni son épouse, ne peuvent résister aux accords puissants du chantre de la Thrace. 
Ils appellent Eurydice. Elle était parmi les ombres récemment arrivées au ténébreux séjour. Elle s\'avance d\'un pas lent, retardé par sa blessure. 

[10,50] Elle est rendue à son époux : mais, telle est la loi qu\'il reçoit : si, avant d\'avoir franchi les sombres détours de l\'Averne, il détourne la tête pour regarder Eurydice, sa grâce est révoquée; Eurydice est perdue pour lui sans retour. À travers le vaste silence du royaume des ombres, ils remontent par un sentier escarpé, tortueux, couvert de longues ténèbres. Ils approchaient des portes du Ténare. Orphée, impatient de crainte et d\'amour, se détourne, regarde, et soudain Eurydice lui est encore ravie. 
Le malheureux Orphée lui tend les bras, Il veut se jeter dans les siens : il n\'embrasse qu\'une vapeur légère. 

[10,60] Eurydice meurt une seconde fois, mais sans se plaindre; et quelle plainte eût-elle pu former ? Était-ce pour Orphée un crime de l\'avoir trop aimée ! Adieu, lui dit-elle d\'une voix faible qui fut à peine entendue; et elle rentre dans les abîmes du trépas. 
Privé d\'une épouse qui lui est deux fois ravie, Orphée est immobile, étonné, tel que ce berger timide qui voyant le triple Cerbère, chargé de chaînes, traîné par le grand Alcide jusqu\'aux portes du jour, ne cessa d\'être frappé de stupeur que lorsqu\'il fut transformé en rocher. Tel encore Olénus, ce tendre époux qui voulut se charger de ton crime, 

[10,70] infortunée Léthéa, trop vaine de ta beauté. Jadis unis par l\'hymen, ils ne font qu\'un même rocher, soutenu par l\'Ida sur son humide sommet. 
En vain le chantre de la Thrace veut repasser le Styx et fléchir l\'inflexible Charon. Toujours refusé, il reste assis sur la rive infernale, ne se nourrissant que de ses larmes, du trouble de son âme, et de sa douleur. Enfin, las d\'accuser la cruauté des dieux de l\'Érèbe, il se retire sur le mont Rhodope, et sur l\'Hémus battu des Aquilons. Trois fois le soleil avait ramené les saisons. 

[10,80] Orphée fuyait les femmes et l\'amour : soit qu\'il déplorât le sort de sa première flamme, soit qu\'il eût fait serment d\'être fidèle à Eurydice. 
En vain pour lui mille beautés soupirent; toutes se plaignent de ses refus. Mais ce fut lui qui, par son exemple, apprit aux Thraces à rechercher ce printemps fugitif de l\'âge placé entre l\'enfance et la jeunesse, et à s\'égarer dans des amours que la nature désavoue. 
Une colline à son sommet se terminait en plaine. Elle était couverte d\'un gazon toujours vert; mais c\'était un lieu sans ombre. Dès que le chantre immortel, fils des dieux, s\'y fut assis, et qu\'il eut agité les cordes de sa lyre, 
[de][10,0] LIVRE DIX. 

[10,1] L\'Hymen, vêtu d\'une robe de pourpre, s\'élève des champs de Crète, dans les airs, et vole vers la Thrace, où la voix d\'Orphée l\'appelle en vain à ses autels. L\'Hymen est présent à son union avec Eurydice, mais il ne profère point les mots sacrés; il ne porte ni visage serein, ni présages heureux. La torche qu\'il tient pétille, répand une fumée humide, et le dieu qui l\'agite ne peut ranimer ses mourantes clartés. Un affreux événement suit de près cet augure sinistre. Tandis que la nouvelle épouse court sur l\'herbe fleurie, 

[10,10] un serpent la blesse au talon elle pâlit, tombe et meurt au milieu de ses compagnes. 
Après avoir longtemps imploré par ses pleurs les divinités de l\'Olympe, le chantre du Rhodope osa franchir les portes du Ténare, et passer les noirs torrents du Styx, pour fléchir les dieux du royaume des morts. Il marche à travers les ombres légères, fantômes errants dont les corps ont reçu les honneurs du tombeau. Il arrive au pied du trône de Proserpine et de Pluton, souverains de ce triste et ténébreux empire. Là, unissant sa voix plaintive aux accords de sa lyre, il fait entendre ces chants : \"Divinités du monde souterrain où descendent successivement tous les mortels, 

[10,20] souffrez que je laisse les vains détours d\'une éloquence trompeuse. Ce n\'est ni pour visiter le sombre Tartare, ni pour enchaîner le monstre à trois têtes, né du sang de Méduse, et gardien des Enfers, que je suis descendu dans votre empire. Je viens chercher mon épouse. La dent d\'une vipère me l\'a ravie au printemps de ses jours. 
J\'ai voulu supporter cette perte; j\'ai voulu, je l\'avoue, vaincre ma douleur. L\'Amour a triomphé. La puissance de ce dieu est établie sur la terre et dans le ciel; je ne sais si elle l\'est aux enfers : mais je crois qu\'elle n\'y est pas inconnue; et, si la renommée d\'un enlèvement antique n\'a rien de mensonger, c\'est l\'amour qui vous a soumis; c\'est lui qui vous unit. Je vous en conjure donc 

[10,30] par ces lieux pleins d\'effroi, par ce chaos immense, par le vaste silence de ces régions de la Nuit, rendez-moi mon Eurydice; renouez le fil de ses jours trop tôt par la Parque coupé. 
\"Les mortels vous sont tous soumis. Après un court séjour sur la terre un peu plus tôt ou un peu plus tard, nous arrivons dans cet asile ténébreux; nous y tendons tous également; c\'est ici notre dernière demeure. Vous tenez sous vos lois le vaste empire du genre humain. Lorsque Eurydice aura rempli la mesure ordinaire de la vie, elle rentrera sous votre puissance. Hélas ! c\'est un simple délai que je demande; et si les Destins s\'opposent à mes vœux, je renonce moi-même à retourner sur la terre. Prenez aussi ma vie, et réjouissez-vous d\'avoir deux ombres à la fois.\" 

[10,40] Aux tristes accents de sa voix, accompagnés des sons plaintifs de sa lyre, les ombres et les mânes pleurent attendris. Tantale cesse de poursuivre l\'onde qui le fuit. Ixion s\'arrête sur sa roue. Les vautours ne rongent plus les entrailles de Tityos. L\'urne échappe aux mains des filles de Bélus, et toi, Sisyphe, tu t\'assieds sur ta roche fatale. On dit même que, vaincues par le charme des vers, les inflexibles Euménides s\'étonnèrent de pleurer pour la première fois. Ni le dieu de l\'empire des morts, ni son épouse, ne peuvent résister aux accords puissants du chantre de la Thrace. 
Ils appellent Eurydice. Elle était parmi les ombres récemment arrivées au ténébreux séjour. Elle s\'avance d\'un pas lent, retardé par sa blessure. 

[10,50] Elle est rendue à son époux : mais, telle est la loi qu\'il reçoit : si, avant d\'avoir franchi les sombres détours de l\'Averne, il détourne la tête pour regarder Eurydice, sa grâce est révoquée; Eurydice est perdue pour lui sans retour. À travers le vaste silence du royaume des ombres, ils remontent par un sentier escarpé, tortueux, couvert de longues ténèbres. Ils approchaient des portes du Ténare. Orphée, impatient de crainte et d\'amour, se détourne, regarde, et soudain Eurydice lui est encore ravie. 
Le malheureux Orphée lui tend les bras, Il veut se jeter dans les siens : il n\'embrasse qu\'une vapeur légère. 

[10,60] Eurydice meurt une seconde fois, mais sans se plaindre; et quelle plainte eût-elle pu former ? Était-ce pour Orphée un crime de l\'avoir trop aimée ! Adieu, lui dit-elle d\'une voix faible qui fut à peine entendue; et elle rentre dans les abîmes du trépas. 
Privé d\'une épouse qui lui est deux fois ravie, Orphée est immobile, étonné, tel que ce berger timide qui voyant le triple Cerbère, chargé de chaînes, traîné par le grand Alcide jusqu\'aux portes du jour, ne cessa d\'être frappé de stupeur que lorsqu\'il fut transformé en rocher. Tel encore Olénus, ce tendre époux qui voulut se charger de ton crime, 

[10,70] infortunée Léthéa, trop vaine de ta beauté. Jadis unis par l\'hymen, ils ne font qu\'un même rocher, soutenu par l\'Ida sur son humide sommet. 
En vain le chantre de la Thrace veut repasser le Styx et fléchir l\'inflexible Charon. Toujours refusé, il reste assis sur la rive infernale, ne se nourrissant que de ses larmes, du trouble de son âme, et de sa douleur. Enfin, las d\'accuser la cruauté des dieux de l\'Érèbe, il se retire sur le mont Rhodope, et sur l\'Hémus battu des Aquilons. Trois fois le soleil avait ramené les saisons. 

[10,80] Orphée fuyait les femmes et l\'amour : soit qu\'il déplorât le sort de sa première flamme, soit qu\'il eût fait serment d\'être fidèle à Eurydice. 
En vain pour lui mille beautés soupirent; toutes se plaignent de ses refus. Mais ce fut lui qui, par son exemple, apprit aux Thraces à rechercher ce printemps fugitif de l\'âge placé entre l\'enfance et la jeunesse, et à s\'égarer dans des amours que la nature désavoue. 
Une colline à son sommet se terminait en plaine. Elle était couverte d\'un gazon toujours vert; mais c\'était un lieu sans ombre. Dès que le chantre immortel, fils des dieux, s\'y fut assis, et qu\'il eut agité les cordes de sa lyre, 
</multi>', '', '2007-02-25 14:54:02', 'publie', '53', '2010-08-14 22:30:37', 'oui', '0000-00-00 00:00:00', '3850', '0', '0.693244404246711', 'non', '2007-09-12 23:15:27', 'fr', 'oui', '0', '', '1', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('12', '', 'Peau d\'âne en prose de Charles Perrault', 'TL 2007', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en avoir la définition.} }}} 


Il était une fois un roi si grand, si aimé de ses peuples, si respecté de tous ses voisins et de ses alliés, qu\'on pouvait dire qu\'il était le plus heureux de tous les monarques.

Son bonheur était encore confirmé par le choix qu\'il avait fait d\'une princesse aussi belle que vertueuse ; et ces heureux époux vivaient dans une union parfaite. De leur mariage était née une fille, douée de tant de grâce et de charmes, qu\'ils ne regrettaient pas de n\'avoir pas une plus grande lignée. 

La magnificence, le goût et l\'abondance régnaient dans son palais ; les ministres étaient sages et habiles ; les courtisans, vertueux et attachés ; les domestiques, fidèles et laborieux ; les écuries, vastes et remplies des plus beaux chevaux du monde, couverts de riches caparaçons : mais ce qui étonnait les étrangers qui venaient admirer ces belles écuries, c\'est qu\'au lieu le plus apparent un maître d\'âne étalait de longues et grandes oreilles.

Ce n\'était pas par fantaisie, mais avec raison, que le roi lui avait donné une place particulière et distinguée. Les vertus de ce rare animal méritaient cette distinction, puisque la nature l\'avait formé si extraordinaire, que sa litière, au lieu d\'être malpropre, était couverte, tous les matins, avec profusion, de beaux écus au soleil et de louis d\'or de toute espèce, qu\'on allait recueillir à son réveil.

Or, comme les vicissitudes de la vie s\'étendent aussi bien sur les rois que sur les sujets, et que toujours les biens sont mêlés de quelques maux, le ciel permit que la reine fût tout à coup attaquée d\'une âpre maladie, pour laquelle, malgré la science et l\'habileté des médecins, on ne put trouver aucun secours. 

La désolation fut générale. Le roi, sensible et amoureux, malgré le proverbe fameux qui dit que le mariage est le tombeau de l\'amour, s\'affligeait sans modération, faisait des voeux ardents à tous les temples de son royaume, offrait sa vie pour celle d\'une épouse si chère, mais les dieux et les fées étaient invoqués en vain. La reine, sentant sa dernière heure approcher, dit à son époux qui fondait en larmes : 

\" Trouvez bon, avant que je meure, que j\'exige une chose de vous : c\'est que s\'il vous prenait envie de vous remarier ... \" 

A ces mots, le roi fit des cris pitoyables, prit les mains de sa femme, les baigna de pleurs, et, l\'assurant qu\'il était superflu de lui parler d\'un second mariage : 

\" Non, non, dit-il enfin, ma chère reine, parlez-moi plutôt de vous suivre. 

- L\'Etat, reprit la reine avec une fermeté qui augmentait les regrets de ce prince, l\'Etat doit exiger des successeurs et, comme je ne vous ai donné qu\'une fille, vous presser d\'avoir des fils qui vous ressemblent : mais je vous demande instamment, par tout l\'amour que vous avez eu pour moi, de ne céder à l\'empressement de vos peuples que lorsque vous aurez trouvé une princesse plus belle et mieux faite que moi ; j\'en veux votre serment, et alors je mourrai contente. \" 

On présume que la reine, qui ne manquait pas d\'amour-propre, avait exigé ce serment, ne croyant pas qu\'il fût au monde personne qui pût l\'égaler, pensant bien que c\'était s\'assurer que le roi ne se remarierait jamais. Enfin elle mourut. Jamais mari ne fit tant de vacarme : pleurer, sangloter jour et nuit, menus droits du veuvage, furent son unique occupation. 

Les grandes douleurs ne durent pas. D\'ailleurs, les grands de l\'Etat s\'assemblèrent, et vinrent en corps prier le roi de se remarier. Cette première proposition lui parut dure, et lui fit répandre de nouvelles larmes. Il allégua le serment qu\'il avait fait à la reine, défiant tous ses conseillers de pouvoir trouver une princesse plus belle et mieux faite que feu sa femme, pensant que cela était impossible. Mais le conseil traita de babiole une telle promesse et dit qu\'il importait peu de la beauté, pourvu qu\'une reine fût vertueuse ; que l\'Etat demandait des princes pour son repos et sa tranquillité ; qu\'à la vérité, l\'Infante avait toutes les qualités requises pour faire une grande reine, mais qu\'il fallait lui choisir un époux ; et qu\'alors ou cet étranger l\'emmènerait chez lui, ou que, s\'il régnait avec elle, ses enfants ne seraient plus réputés du même sang ; et que, n\'y ayant point de prince de son nom, les peuples voisins pourraient lui susciter des guerres qui entraîneraient la ruine du royaume. 

Le roi, frappé de ces considérations, promit qu\'il songerait à les contenter. Effectivement, il chercha, parmi les princesses à marier, qui serait celle qui pourrait lui convenir. Chaque jour on lui apportait des portraits charmants, mais aucun n\'avait les grâces de la feue reine : ainsi il ne se déterminait point. 

Malheureusement il s\'avisa de trouver que l\'Infante surpassait encore de beaucoup la reine sa mère en esprit et en agréments. Sa jeunesse, l\'agréable fraîcheur de ce beau teint enflammèrent le roi d\'un ton si violent, qu\'il ne put le cacher à l\'Infante, et il lui dit qu\'il avait résolu de l\'épouser, puisqu\'elle-seule pouvait le dégager de son serment. 

La jeune princesse, remplie de vertu et de pudeur, pensa s\'évanouir à cette horrible proposition. Elle se jeta aux pieds du roi son père, et le conjura, avec toute la force qu\'elle put trouver dans son esprit, de ne la pas contraindre à commettre un tel crime. 

Le roi, qui s\'était mis en tête ce bizarre projet, avait consulté un vieux druide pour mettre la conscience de la princesse en repos. Ce druide, moins religieux qu\'ambitieux, sacrifia, à l\'honneur d\'être confident d\'un grand roi, l\'intérêt et l\'innocence de la vertu, et s\'insinua avec tant d\'adresse dans l\'esprit du roi, lui adoucit tellement le crime qu\'il allait commettre, qu\'il lui persuada même que c\'était une oeuvre pie que d\'épouser sa fille. 

Ce prince, flatté par les discours de ce scélérat, l\'embrassa et revint d\'avec lui plus entêté que jamais dans son projet: il fit donc ordonner à l\'Infante de se préparer à lui obéir. La jeune princesse, outrée d\'une vive douleur, n\'imagina rien d\'autre chose que d\'aller trouver la Fée des Lilas, sa marraine. Pour cet effet, elle partit la même nuit dans un joli cabriolet attelé d\'un gros mouton qui savait tous les chemins. Elle y arriva heureusement. La fée, qui aimait l\'Infante, lui dit qu\'elle savait tout ce qu\'elle venait lui dire, mais qu\'elle n\'eût aucun souci, rien ne pouvant lui nuire si elle exécutait fidèlement ce qu\'elle allait lui prescrire. 

\" Car, ma chère enfant, lui dit-elle, ce serait une grande faute que d\'épouser votre père, mais, sans le contredire, vous pouvez l\'éviter : dites-lui que, pour remplir une fantaisie que vous avez, il faut qu\'il vous donne une robe de la couleur du temps ; jamais, avec tout son amour et son pouvoir, il ne pourra y parvenir. \"

La princesse remercia bien sa marraine ; et dès le lendemain matin, elle dit au roi son père ce que la fée lui avait conseillé, et protesta qu\'on ne tirerait d\'elle aucun aveu qu\'elle n\'eût une robe couleur du temps. Le roi, ravi de l\'espérance qu\'elle lui donnait, assembla les plus fameux ouvriers, et leur commanda cette robe, sous la consigne que, s\'ils ne pouvaient réussir, il les ferait tous pendre. 

Il n\'eut pas le chagrin d\'en venir à cette extrémité, dès le second jour ils apportèrent la robe si désirée. L\'empyrée n\'est pas d\'un plus beau bleu lorsqu\'il est ceint de nuages d\'or, que cette belle robe lorsqu\'elle fut étalée. L\'Infante en fut toute contrastée et ne savait comment se tirer d\'embarras.

Le roi pressait la conclusion. Il fallut recourir encore à la marraine, qui, étonnée de ce que son secret n\'avait pas réussi, lui dit d\'essayer d\'en demander une de la couleur de la lune. Le roi, qui ne pouvait lui rien refuser, envoya chercher les plus habiles ouvriers, et leur commanda si expressément une robe couleur de la lune, qu\'entre ordonner et apporter il n\'y eut pas vingt-quatre heures ... 

L\'Infante, plus charmée de cette superbe robe que des soins du roi son père, s\'affligea immodérément lorsqu\'elle fut avec ses femmes et sa nourrice. La Fée des Lilas, qui savait tout, vint au secours de l\'affligée princesse, et lui dit : 

\" Ou je me trompe fort, ou je crois que, si vous demandez une robe couleur du soleil, ou nous viendrons à bout de dégoûter le roi votre père, car jamais on ne pourra parvenir à faire une pareille robe, ou nous gagnerons au moins du temps.\" 

L\'Infante en convint, demanda la robe et l\'amoureux roi donna, sans regret, tous les diamants et les rubis de sa couronne pour aider à ce superbe ouvrage, avec l\'ordre de ne rien épargner pour rendre cette robe égale au soleil. Aussi, dès qu\'elle parut, tous ceux qui la virent déployée furent obligés de fermer les yeux, tant ils furent éblouis. C\'est de ce temps que datent les lunettes vertes et les verres noirs. 

Que devient l\'Infante à cette vue ? Jamais on n\'avait rien vu de si beau et de si artistement ouvré. Elle était confondue ; et sous prétexte d\'avoir mal aux yeux, elle se retira dans sa chambre où la fée l\'attendait, plus honteuse qu\'on ne peut dire. Ce fut bien pis : car, en voyant la robe du soleil, elle devint rouge. de colère. 

\" Oh ! pour le coup, ma fille, dit-elle à l\'Infante, nous allons mettre l\'indigne amour de votre père à une terrible épreuve. Je le crois bien entété de ce mariage qu\'il croit si prochain, mais je pense qu\'il sera un peu étourdi de la demande que je vous conseille de lui faire : C\'est la peau de cet âne qu\'il aime si passionnément, et qui fournit à toutes ses dépenses avec tant de profusion ; allez, et ne manquez pas de lui dire que vous désirez cette peau. \" 

L\'Infante, ravie de trouver encore un moyen d\'éluder un mariage qu\'elle détestait, et qui pensait en même temps que son père ne pourrait jamais se résoudre à sacrifier son âne, vint le trouver et lui exposa son désir pour la peau de ce bel animal. Quoique le roi fût étonné de cette fantaisie, il ne balança pas à la satisfaire ; Le pauvre âne fut sacrifié, et la peau galamment apportée à l\'Infante, qui, ne voyant plus aucun moyen d\'éluder son malheur, s\'allait désespéré lorsque sa marraine accourut. 

\" Que faites-vous, ma fille ? dit-elle, voyant la princesse déchirant ses cheveux et meurtrissant ses belles joues ; voici le moment le plus heureux de votre vie. Enveloppez-vous de cette peau, sortez de ce palais, et allez tant que la terre pourra vous porter : lorsqu\'on sacrifie tout à la vertu, les dieux savent en récompenser. Allez, j\'aurai soin que votre toilette vous suive partout ; en quelque lieu que vous vous arrêtiez, votre cassette, où seront vos habits et vos bijoux, suivra vos pas sous terre ; et voici ma baguette que je vous donne : en frappant la terre, quand vous aurez besoin de cette cassette, elle paraîtra à vos yeux : mais hâtez-vous de partir, et ne tardez pas.\" 

L\'Infante embrassa mille fois sa marraine, la pria de ne pas l\'abandonner, s\'affubla de cette vilaine peau, après s\'être barbouillée de suie de cheminée, et sortit de ce riche palais sans être reconnue de personne. 

L\'absence de l\'Infante causa une grande rumeur. Le roi, au désespoir, qui avait fait préparer une fête magnifique, était inconsolable. Il fit partir plus de cent gendarmes et plus de mille mousquetaires pour aller à la recherche de sa fille ; mais la fée, qui la protégeait, la rendait invisible aux plus habiles recherches : ainsi il fallut s\'en consoler. 

Pendant ce temps, l\'Infante cheminait. Elle alla bien loin, encore plus loin, et cherchait partout une place ; mais quoique par charité on lui donnât à manger, on la trouvait si crasseuse que personne n\'en voulait. Cependant, elle entra dans une belle ville, à la porte de laquelle était une métairie, dont la fermière avait besoin d\'un souillon pour laver les torchons, nettoyer les dindons et l\'auge des cochons. Cette femme, voyant cette voyageuse si malpropre, lui proposa d\'entrer chez elle ; ce que l\'Infante accepta de grand coeur, tant elle était lasse d\'avoir tant marché. On la mit dans un coin reculé de la cuisine, où elle fut, les premiers jours, en butte aux plaisanteries grossières de la valetaille, tant sa peau d\'âne la rendait sale et dégoûtante. Enfin, on s\'y accoutuma ; d\'ailleurs elle était si soigneuse de remplir ses devoirs, que la fermière la prit sous sa protection. Elle conduisait les moutons, les faisait parquer au temps où il le fallait; elle menait les dindons paître avec une telle intelligence, qu\'il semblait qu\'elle n\'eût jamais fait autre chose : aussi tout fructifiait sous ses belles mains. 

Un jour qu\'assise près d\'une claire fontaine, où elle déplorait souvent sa triste condition, elle s\'avisa de s\'y mirer, l\'effroyable peau d\'âne, qui faisait sa coiffure et son habillement, l\'épouvanta. Honteuse de cet ajustement, elle se décrassa le visage et les mains, qui devinrent plus blanches que l\'ivoire, et son beau teint reprit sa fraîcheur naturelle. La joie de se trouver si belle lui donna envie de se baigner, ce qu\'elle exécuta; mais il lui fallut remettre son indigne peau pour retourner à la métairie. 

Heureusement, le lendemain était un jour de fête ; ainsi elle eut le loisir de tirer sa cassette, d\'arranger sa toilette, de poudrer ses beaux cheveux, et de mettre sa belle robe couleur du temps. Sa chambre était si petite, que la queue de cette belle robe ne pouvait pas s\'étendre. La belle princesse se mira et s\'admira elle-même avec raison, si bien qu\'elle résolut, pour se désennuyer, de mettre tour à tour ses belles robes, les fêtes et les dimanches ; ce qu\'elle exécuta ponctuellement. Elle mêlait des fleurs et des diamants dans ses beaux cheveux, avec un art admirable et souvent elle soupirait de n\'avoir pour témoins de sa beauté que ses moutons et ses dindons, qui l\'aimaient autant avec son horrible peau d\'âne, dont on lui avait donné le nom dans cette ferme. 

Un jour de fête, que Peau d\'Ane avait mis la robe couleur du soleil, le fils du roi, à qui cette ferme appartenait, vint y descendre pour se reposer, en revenant de la chasse. Ce prince était jeune, beau et admirablement bien fait, l\'amour de son père et de la reine sa mère, adoré des peuples. On offrit à ce jeune prince une collation champêtre qu\'il accepta : puis il se mit à parcourir les basses-cours et tous les recoins. En courant ainsi de lieu en lieu, il entra dans une sombre allée, au bord de laquelle il vit une porte fermée. La curiosité lui fit mettre l\'oeil à la serrure ; mais que devint-il en apercevant la princesse si belle et si richement vêtue, qu\'à son air noble et modeste, il la prit pour une divinité. 

L\'impétuosité du sentiment qu\'il éprouva dans ce moment l\'aurait porté à enfoncer la porte, sans le respect que lui inspira cette ravissante personne. Il sortit avec peine de cette allée sombre et obscure, mais ce fut pour s\'informer qui était la personne qui demeurait dans cette petite chambre. On lui répondit que c\'était une souillon, qu\'on nommait Peau d\'Ane à cause de la peau dont elle s\'habillait, et qu\'elle était si sale et si crasseuse, que personne ne la regardait ni lui parlait et qu\'on ne l\'avait prise que par pitié, pour garder les moutons et les dindons. 

Le prince, peu satisfait de cet éclaircissement, vit bien que ces gens grossiers n\'en savaient pas davantage, et qu\'il était inutile de les questionner. Il revint au palais du roi son Père, plus amoureux qu\'on ne peut dire, ayant continuellement devant les yeux la belle image de cette divinité qu\'il avait vue par le trou de la serrure. Il se repentit de n\'avoir pas heurté à la porte et se promit bien de n\'y pas manquer une autre fois. 

Mais l\'agitation de son sang, causée par l\'ardeur de son amour, lui donna, dans la même nuit, une fièvre si terrible, que bientôt il fut réduit à l\'extrémité. La reine, sa mère, qui n\'avait que lui d\'enfant, se désespérait de ce que tous les remèdes étaient inutiles. Elle promettait en vain les plus grandes récompenses aux médecins ; ils y employèrent tout leur art, mais rien ne guérissait le prince. Enfin, ils devinèrent qu\'un mortel chagrin causait tout ce ravage ; ils en avertirent la reine, qui, toute pleine de tendresse pour son fils, vint le conjurer de dire la cause de son mal et que, quand il s\'agirait de lui céder la couronne, le roi son père descendrait de son trône sans regret, pour l\'y faire monter ; que s\'il désirait quelque princesse, quand même on serait en guerre avec le roi son père, et qu\'on eût de justes sujets pour s\'en plaindre, on sacrifierait tout pour obtenir ce qu\'il désirait ; mais qu\'elle le conjurait de ne pas se laisser mourir, puisque de sa vie dépendait la leur. 

La reine n\'acheva pas ce touchant discours sans mouiller le visage du prince d\'un torrent de larmes. 

\" Madame, lui dit enfin le prince avec une voix très faible, je ne suis pas assez dénaturé pour désirer la couronne de mon père ; plaise au ciel qu\'il vive de longues années, et qu\'il veuille bien que je sois longtemps le plus fidèle et le plus respectueux de ses sujets. Quant aux princesses que vous m\'offrez, je n\'ai point encore pensé à me marier et vous pensez bien que, soumis comme je le suis à vos volontés, je vous obéirai toujours, quoi qu\'il m\'en coûte. 

- Ah, mon fils, reprit la reine, rien ne me coûtera pour te sauver la vie, mais, mon cher fils, sauve la mienne et celle du roi ton père en me déclarant ce que tu désires et sois bien assuré qu\'il te sera accordé. 

- Eh bien, madame, dit-il, puisqu\'il faut vous déclarer ma pensée, je vais vous obéir ; je me ferais un crime de mettre en danger deux êtres qui me sont si chers. Oui, ma mère, je désire que Peau d\'Ane me fasse un gâteau, et que, dès qu\'il sera fait, on me l\'apporte. \" 

La reine, étonnée de ce nom bizarre, demanda qui était cette Peau d\'Ane. 

\" C\'est, Madame, reprit un de ses officiers qui par hasard avait vu cette fille, c\'est la plus vilaine bête après le loup ; une peau noire, une crasseuse qui loge dans votre métairie et qui garde vos dindons. 

- N\'importe, dit la reine, mon fils, au retour de la chasse, a peut-être mangé de sa pâtisserie ; c\'est une fantaisie de malade ; en un mot, je veux que Peau d\'Ane (puisque Peau d\'Ane, il y a) lui fasse promptement un gâteau. \" 

On courut à la métairie, et l\'on fit venir Peau d\'Ane, pour lui ordonner de faire de son mieux un gâteau pour le prince. 

Quelques auteurs ont assuré que Peau d\'Ane, au moment que ce prince avait mis l\'oeil à la serrure, les siens l\'avaient aperçu ; et puis que, regardant par sa petite fenêtre, elle avait vu ce prince si jeune, si beau et si bien fait, que l\'idée lui en était restée, et que souvent ce souvenir lui avait coûté quelques soupirs. Quoi qu\'il en soit, Peau d\'Ane l\'ayant vu, ou en ayant beaucoup entendu parler avec éloge, ravie de pouvoir trouver un moyen d\'être connue, s\'enferma dans sa chambre, jeta sa vilaine peau, se décrassa le visage et les mains, se coiffa de ses blonds cheveux, mit un beau corset d\'argent brillant, un jupon pareil, et se mit à faire le gâteau tant désiré : elle prit de la plus pure farine, des oeufs et du beurre bien frais. En travaillant, soit de dessein ou autrement, une bague qu\'elle avait au doigt tomba dans la pâte, s\'y mêla ; et dès que le gâteau fut cuit, s\'affublant de son horrible peau, elle donna le gâteau à l\'officier, à qui elle demanda des nouvelles du prince ; mais cet homme, ne daignant pas lui répondre, courut chez le prince lui apporter ce gâteau. 

Le prince le prit avidement des mains de cet homme, et le mangea avec une telle vivacité, que les médecins, qui étaient présents, ne manquèrent pas de dire que cette fureur n\'était pas un bon signe : effectivement, le prince pensa s\'étrangler par la bague qu\'il trouva dans un morceau du gâteau ; mais il la tira adroitement de sa bouche et son ardeur à dévorer ce gâteau se ralentit, en examinant cette fine émeraude, montée sur un jonc d\'or dont le cercle était si étroit, qu\'il jugea ne pouvoir servir qu\'au plus joli doigt du monde. Il baisa mille fois cette bague, la mit sous son chevet et l\'en tirait à tout moment quand il croyait n\'être vu de personne. 

Le tourment qu\'il se donna pour imaginer comment il pourrait voir celle à qui cette bague pouvait aller et n\'osant croire, s\'il demandait Peau d\'Ane, qui avait fait ce gâteau qu\'il avait demandé, qu\'on lui accordât de la faire venir, n\'osant non plus croire ce qu\'il avait vu par le trou de la serrure, de crainte qu\'on se moquât de lui et qu\'on le prît pour un visionnaire, toutes ces idées le tourmentant à la fois, la fièvre le reprit fortement et les médecins ne sachant plus que faire, déclarèrent à la reine que le prince était malade d\'amour. 

La reine accourut chez son fils, avec le roi, qui se désolait : 

\" Mon fils, mon cher fils, s\'écria le monarque affligé, nomme-nous celle que tu veux ; nous jurons que nous te la donnerons, fût-elle la plus vile des esclaves. \" 

La reine, en l\'embrassant, lui confirma le serment du roi. Le prince, attendri par les larmes et les caresses des auteurs de ses jours, leur dit : 

\" Mon père et ma mère, je n\'ai point dessein de faire une alliance qui vous déplaise et pour preuve de cette vérité, dit-il en tirant l\'émeraude de dessous son chevet, c\'est que j\'épouserai la personne à qui cette bague ira, telle qu\'elle soit ; et il n\'y a pas apparence que celle qui aura ce joli doigt soit une rustaude ou une paysanne. \" 

Le roi et la reine prirent la bague, l\'examinèrent curieusement et jugèrent, ainsi que le prince, que cette bague ne pouvait aller qu\'à quelque fille de bonne maison. Alors, le roi, ayant embrassé son fils en le conjurant de guérir, sortit, fit sonner les tambours, les fifres et les trompettes par toute la ville et crier par ses hérauts que l\'on n\'avait qu\'à venir au palais essayer une bague et que celle à qui elle irait juste, épouserait l\'héritier du trône. 

Les princesses d\'abord arrivèrent, puis les duchesses, les marquises et les baronnes mais elles eurent beau toutes s\'amenuiser les doigts, aucune ne put mettre la bague. Il en fallut venir aux grisettes, qui toutes jolies qu\'elles étaient, avaient toutes les doigts trop gros. Le prince, qui se portait mieux, faisait lui-même l\'essai. Enfin, on en vint aux filles de chambre ; elles ne réussirent pas mieux. Il n\'y avait plus personne qui n\'eût essayé cette bague sans succès, lorsque le prince demanda les cuisinières, les marmitonnes, les gardeuses de moutons : on amena tout cela ; mais leurs gros doigts rouges et courts ne purent seulement aller par-delà de l\'ongle. 

\" A-t-on fait venir cette Peau d\'Ane, qui m\'a fait un gâteau ces jours derniers ? \" dit le prince. 

Chacun se prit à rire, et lui dit que non, tant elle était sale et crasseuse. 

\" Qu\'on l\'aille chercher sur l\'heure, dit le roi ; il ne sera pas dit que j\'aie excepté quelqu\'un.\" 

On courut, en riant et se moquant, chercher la dindonniêre. 

L\'Infante, qui avait entendu les tambours et les cris des hérauts d\'armes, s\'était bien doutée que sa bague faisait ce tintamarre : elle aimait le prince et, comme le véritable amour est craintif et n\'a point de vanité, elle était dans la crainte continuelle que quelque dame n\'eût le doigt aussi menu que le sien. Elle eut donc une grande joie quand on vint la chercher et qu\'on heurta à sa porte. Depuis qu\'elle avait su qu\'on cherchait un doigt propre à mettre sa bague, je ne sais quel espoir l\'avait portée à se coiffer plus soigneusement, et à mettre son beau corsage d\'argent, avec le jupon plein de falbalas de dentelle d\'argent, semés d\'émeraudes. 

Sitôt qu\'elle entendit qu\'on heurtait à la porte et qu\'on l\'appelait pour aller chez le prince, elle remit promptement sa peau d\'Ane, ouvrit sa porte ; et ces gens, en se moquant d\'elle, lui dirent que le roi la demandait pour lui faire épouser son fils, puis avec de longs éclats de rire, ils la menèrent chez le prince, qui, lui-même, étonné de l\'accoutrement de cette fille, n\'osa croire que ce fût elle qu\'il avait vue si pompeuse et si belle. Triste et confondu de s\'être si lourdement trompé : 

\"Est-ce vous, lui dit-il, qui logez au fond de cette allée obscure, dans la troisième basse-cour de la métairie ?

- Oui, seigneur, répondit-elle. 

- Montrez-moi votre main. \" dit-il en tremblant et poussant un profond soupir ... 

Dame, qui fut bien surpris ? Ce furent le roi et la reine, ainsi que tous les chambellans et les grands de la cour, lorsque de dessous cette peau noire et crasseuse sortit une petite main délicate, blanche et couleur de rose, où la bague s\'ajusta sans peine au plus joli petit doigt du monde et par un petit mouvement que l\'Infante se donna, la peau tomba, et elle parut d\'une beauté si ravissante, que le prince, tout faible qu\'il était, se mit à ses genoux et les serra avec une ardeur qui la fit rougir ; mais, on ne s\'en aperçut presque pas, parce que le roi et la reine vinrent l\'embrasser de toute leur force et lui demander si elle voulait bien épouser leur fils. 

La princesse, confuse, de tant de caresses et de l\'amour que lui marquait ce beau jeune prince, allait cependant les en remercier, lorsque le plafond s\'ouvrit et que la Fée des Lilas, descendant dans un char fait de branches et de fleurs de son nom, conta, avec une grâce infinie, l\'histoire de l\'Infante. 

Le roi et la reine, charmés de voir que Peau d\'Ane était une grande princesse, redoublèrent leurs caresses, mais le prince fut encore plus sensible à la vertu de la princesse et son amour s\'accrut par cette connaissance. L\'impatience du prince, pour épouser la princesse, fut telle, qu\'à peine donna-t-il le temps de faire les préparatifs convenables pour cet auguste mariage. Le roi et la reine, qui étaient affolés de leur belle-fille, lui faisaient mille caresses et la tenaient incessamment dans leurs bras ; elle avait déclaré qu\'elle ne pouvait épouser le prince sans le consentement du roi son père : aussi fut-il le premier à qui on envoya une invitation, sans lui dire quelle était l\'épousée ; la Fée des Lilas, qui présidait à tout, comme de raison, l\'avait exigé, à cause des conséquences. 

Il vint des rois de tous les pays ; les uns en chaise à porteurs, d\'autres en cabriolet, de plus éloignés, montés sur des éléphants, sur des tigres, sur des aigles, mais le plus magnifique et le plus puissant fut le père de l\'Infante, qui heureusement avait oublié son amour impossible et avait épousé une reine veuve, fort belle, dont il n\'avait point eu d\'enfant. 

L\'Infante courut au-devant de lui ; il la reconnut aussitôt, et l\'embrassa avec une grande tendresse, avant qu\'elle eût le temps de se jeter à ses genoux. Le roi et la reine lui présentèrent leur fils, qu\'il combla d\'amitiés. Les noces se firent avec toute la pompe imaginable. Les jeunes époux, peu sensibles à ces magnificences, ne virent et ne regardèrent qu\'eux. Le roi, père du prince, fit couronner son fils ce même jour, et, lui baisant la main, le plaça sur son trône. Malgré la résistance de ce fils si bien né, il lui fallut obéir. Les fêtes de cet illustre mariage durèrent près de trois mois ; mais l\'amour des deux époux durerait encore, tant ils s\'aimaient, s\'ils n\'étaient pas morts cent ans après.

MORALITE

<poesie>Le conte de Peau d\'Ane est difficile à croire ; 
Mais tant que dans le monde on aura des enfants, 
Des mères et des mères-grands, 
On en gardera la mémoire</poesie>
 

', '', '2007-05-13 13:55:58', 'publie', '26', '2011-04-28 21:35:41', 'oui', '0000-00-00 00:00:00', '8430', '0', '1.72742808508483', 'non', '2011-04-28 21:35:28', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('19', '', 'Le petit chaperon rouge, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition.} }}} 


Il était une fois une petite fille de village, la plus jolie qu\'on eût su voir : sa mère en était folle, et sa mère--grand plus folle encore. Cette bonne femme lui fit faire un petit chaperon rouge qui lui seyait si bien, que partout on l\'appelait le Petit Chaperon rouge.

Un jour, sa mère, ayant cuit et fait des galettes, lui dit :

\" Va voir comment se porte ta mère--grand, car on m\'a dit qu\'elle était malade. Porte--lui une galette et ce petit pot de beurre.\"

Le Petit Chaperon rouge partit aussitôt pour aller chez sa mère--grand, qui demeurait dans un autre village. En passant dans un bois, elle rencontra compère le Loup, qui eut bien envie de la manger ; mais il n\'osa, à cause de quelques bûcherons qui étaient dans la forêt. Il lui demanda où elle allait. La pauvre enfant, qui ne savait pas qu\'il était dangereux de s\'arrêter à écouter un loup, lui dit :

\" Je vais voir ma mère--grand, et lui porter une galette, avec un petit pot de beurre, que ma mère lui envoie.

-- Demeure--t--elle bien loin ? lui dit le Loup

-- Oh oui, dit le Petit Chaperon rouge ; c\'est par--delà le moulin que vous voyez tout là--bas, à la première maison du village.

-- Eh bien ! dit le Loup, je veux l\'aller voir aussi, je my en vais par ce chemin--ci, et toi par ce chemin--là, et nous verrons à qui plus tôt y sera.\"

Le loup se mit à courir de toute sa force par le chemin qui était le plus court, et la petite fille s\'en alla par le chemin le plus long, s\'amusant à cueillir des noisettes, à courir après les papillons, et à faire des bouquets des petites fleurs qu\'elle rencontrait.

Le loup ne fut pas longtemps à arriver à la maison de la mère--grand ; il heurte : toc, toc.

\" Qui est là ?

-- C\'est votre fille, le Petit Chaperon rouge, dit le Loup en contrefaisant sa voix, qui vous apporte une galette et un petit pot de beurre, que ma mère vous envoie.\"

La bonne mère--grand, qui était dans son lit, à cause qu\'elle se trouvait un peu mal, lui cria :

\" Tire la chevillette, la bobinette cherra.\"

Le Loup tira la chevillette, et la porte s\'ouvrit. Il se jeta sur la bonne femme, et la dévora en moins de rien, car il y avait plus de trois jours qu\'il n\'avait pas manger. Ensuite il ferma la porte, et s\'alla coucher dans le lit de la mère--grand, en attendant le Petit Chaperon rouge, qui quelques temps après, vint heurter à la porte : toc, toc.

\" Qui est là ?\"

Le Petit Chaperon rouge, qui entendit la grosse voix du Loup, eut peur d\'abord, mais, croyant que sa mère--grand était enrhumée, répondit :

\" C\'est votre fille, le Petit Chaperon rouge, qui vous apporte une galette et un petit pot de beurre, que ma mère vous envoie.\"

Le Loup lui cria en adoucissant un peu sa voix :

\" Tire la chevillette, la bobinette cherra.\"

Le Petit Chaperon rouge tira la chevillette, et la porte s\'ouvrit. Le Loup, la voyant entrer, lui dit en se cachant dans le lit, sous la couverture :

\" Mets la galette et le petit pot de beurre sur la huche, et viens te coucher avec moi.\"

Le Petit Chaperon rouge se déshabille, et va se mettre dans le lit, où elle fut bien étonné de voir comment sa mère--grand était faite en son déshabillé. Elle lui dit :

\" Ma mère--grand, que vous avez de grands bras !

-- C\'est pour mieux t\'embrasser, ma fille !

-- Ma mère--grand, que vous avez de grandes jambes !

-- C\'est pour mieux courir, mon enfant !

-- Ma mère--grand, que vous avez de grandes oreilles !

-- C\'est pour mieux écouter, mon enfant !

-- Ma mère--grand, que vous avez de grands yeux !

-- C\'est pour mieux te voir, mon enfant !

-- Ma mère--grand, que vous avez de grandes dents !

-- C\'est pour te manger !\"

Et, en disant ces mots, le méchant Loup se jeta sur le Petit Chaperon rouge, et le mangea.


MORALITE


<poesie>On voit ici que de jeunes enfants,
Surtout de jeunes filles,
Belles, bien faites et gentilles
Font très mal d\'écouter toutes sortes de gens,
Et que ce n\'est pas chose étrange,
S\'il en est tant que le loup mange.
Je dis le loup, car tous les loups
Ne sont pas de la même sorte :
Il en est d\'une humeur accorte,
Sans bruit, sans fiel et sans courroux,
Qui, privés, complaisants et doux,
Suivent les jeunes demoiselles
Jusque dans les maisons, jusque dans les ruelles.
Mais, hélas ! qui ne sait que ces loups doucereux,
De tous les loups sont les plus dangereux !</poesie>', '', '2007-05-22 22:09:13', 'publie', '26', '2011-04-28 21:00:25', 'oui', '0000-00-00 00:00:00', '4907', '0', '0.752578499967425', 'non', '2007-05-22 22:27:25', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('13', '', 'Riquet à la houppe, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en avoir la définition.} }}} 



Il était une fois une reine qui accoucha d\'un fils, si laid et si mal fait, qu\'on douta longtemps s\'il avait forme humaine. Une fée qui se trouva à sa naissance assura qu\'il ne laisserait pas d\'être aimable, parce qu\'il aurait beaucoup d\'esprit; elle ajouta même qu\'il pourrait, en vertu du don qu\'elle venait de lui faire, donner autant d\'esprit qu\'il en aurait à celle qu\'il aimerait le mieux.

Tout cela consola un peu la pauvre reine, qui était bien affligée d\'avoir mis au monde un si vilain marmot. Il est vrai que cet enfant ne commença pas plus tôt à parler qu\'il dit mille jolies choses, et qu\'il avait dans toutes ses actions je ne sais quoi de si spirituel, qu\'on en était charmé. J\'oubliais de dire qu\'il vint au monde avec une petite houppe de cheveux sur la tête, ce qui fit qu\'on le nomma Riquet à la houppe, car Riquet était le nom de la famille. Au bout de sept ou huit ans la reine d\'un royaume voisin accoucha de deux filles. La première qui vint au monde était plus belle que le jour : la reine en fut si aise, qu\'on appréhenda que la trop grande joie qu\'elle en avait ne lui fit mal. La même fée qui avait assisté à la naissance du petit Riquet à la houppe était présente, et pour modérer la joie de la reine, elle lui déclara que cette petite princesse n\'aurait point d\'esprit, et qu\'elle serait aussi stupide qu\'elle était belle. Cela mortifia beaucoup la Reine; mais elle eut quelques moments après un bien plus grand chagrin, car la seconde fille dont elle accoucha se trouva extrêmement laide. \"Ne vous affligez point tant, Madame\" , lui dit la fée ; \" votre fille sera récompensée d\'ailleurs, et elle aura tant d\'esprit, qu\'on ne s\'apercevra presque pas qu\'il lui manque de la beauté. - Dieu le veuille , répondit la Reine, mais n\'y aurait-il point moyen de faire avoir un peu d\'esprit à l\'aînée qui est si belle ? - Je ne puis rien pour elle, Madame, du côté de l\'esprit, lui dit la fée, mais je puis tout du côté de la beauté; et comme il n\'y a rien que je ne veuille faire pour votre satisfaction, je vais lui donner pour don de pouvoir rendre beau qui lui plaira.\"

A mesure que ces deux princesses devinrent grandes, leurs perfections crûrent aussi avec elles, et on ne parlait partout que de la beauté de l\'aînée, et de l\'esprit de la cadette. Il est vrai aussi que leurs défauts augmentèrent beaucoup avec l\'âge. La cadette enlaidissait à vue d\'oeil, et l\'aînée devenait plus stupide de jour en jour. Ou elle ne répondait rien à ce qu\'on lui demandait, ou elle disait une sottise. Elle était avec cela si maladroite qu\'elle n\'eût pu ranger quatre Porcelaines sur le bord d\'une cheminée sans en casser une, ni boire un verre d\'eau sans en répandre la moitié sur ses habits.

Quoique la beauté soit un grand avantage chez une jeune femme, cependant la cadette l\'emportait presque toujours sur son aînée dans toutes les Compagnies. D\'abord on allait du côté de la plus belle pour la voir et pour l\'admirer, mais bientôt après, on allait à celle qui avait le plus d\'esprit, pour lui entendre dire mille choses agréables, et on était étonné qu\'en moins d\'un quart d\'heure l\'aînée n\'avait plus personne auprès d\'elle, et que tout le monde s\'était rangé autour de la cadette. L\'aînée, quoique fort stupide, le remarqua bien, et elle eût donné sans regret toute sa beauté pour avoir la moitié de l\'esprit de sa soeur. La Reine, toute sage qu\'elle était, ne put s\'empêcher de lui reprocher plusieurs fois sa bêtise, ce qui pensa faire mourir de douleur cette pauvre Princesse.

Un jour qu\'elle s\'était retirée dans un bois pour y plaindre son malheur, elle vit venir à elle un petit homme fort laid et fort désagréable, mais vêtu très magnifiquement. C\'était le jeune Prince Riquet à la houppe, qui étant devenu amoureux d\'elle d\'après ses portraits qui circulaient par tout le monde, avait quitté le royaume de son père pour avoir le plaisir de la voir et de lui parler.

Ravi de la rencontrer ainsi toute seule, il l\'aborde avec tout le respect et toute la politesse imaginables. Ayant remarqué, après lui avoir fait les compliments ordinaires, qu\'elle était fort mélancolique, il lui dit : \"Je ne comprends point, Madame, comment quelqu\'un aussi belle que vous l\'êtes peut être aussi triste que vous le paraissez; car, quoique je puisse me vanter d\'avoir vu une infinité de belles dames, je puis dire que je n\'en ai jamais vu dont la beauté approche de la vôtre. - Cela vous plaît à dire, Monsieur\", lui répondit la Princesse, et en demeure là. - La beauté, reprit Riquet à la houppe, est un si grand avantage qu\'il doit tenir lieu de tout le reste; et quand on le possède, je ne vois pas qu\'il y ait rien qui puisse nous affliger beaucoup. - J\'aimerais mieux, dit la Princesse, être aussi laide que vous et avoir de l\'esprit, que d\'avoir de la beauté comme j\'en ai, et être bête autant que je le suis. - Il n\'y a rien, Madame, qui marque davantage qu\'on a de l\'esprit, que de croire n\'en pas avoir, et il est de la nature de ce bien-là, que plus on en a, plus on croit en manquer. - Je ne sais pas cela , dit la Princesse, mais je sais bien que je suis fort bête, et c\'est de là que vient le chagrin qui me tue. - Si ce n\'est que cela, Madame, qui vous afflige, je puis aisément mettre fin à votre douleur.\" - Et comment ferez-vous ? dit la Princesse. - J\'ai le pouvoir, Madame, dit Riquet à la houppe, de donner de l\'esprit autant qu\'on en saurait avoir à celle que je dois aimer le plus; et comme vous êtes, Madame, celle-là, il n\'en tiendra qu\'à vous que vous n\'ayez autant d\'esprit qu\'on en peut avoir, pourvu que vous vouliez bien m\'épouser.\"

La Princesse demeura toute interdite, et ne répondit rien. \"Je vois\" , reprit Riquet à la houppe, que cette proposition vous fait de la peine, et je ne m\'en étonne pas; mais je vous donne un an tout entier pour vous y résoudre.\" La Princesse avait si peu d\'esprit, et en même temps une si grande envie d\'en avoir, qu\'elle s\'imagina que la fin de cette année ne viendrait jamais; de sorte qu\'elle accepta la proposition qui lui était faite.

Elle n\'eut pas plus tôt promis à Riquet à la houppe qu\'elle l\'épouserait dans un an à pareil jour, qu\'elle se sentit tout autre qu\'elle n\'était auparavant; elle se trouva une facilité incroyable à dire tout ce qui lui plaisait, et à le dire d\'une manière fine, aisée et naturelle. Elle commença dès ce moment une conversation galante et soutenue avec Riquet à la houppe, où elle brilla d\'une telle force que Riquet à la houppe crut lui avoir donné plus d\'esprit qu\'il ne s\'en était réservé pour lui-même.

Quand elle fut retournée au Palais, toute la Cour ne savait que penser d\'un changement si subit et si extraordinaire, car autant qu\'on lui avait entendu dire d\'impertinences auparavant, autant lui entendait-on dire des choses bien sensées et infiniment spirituelles. Toute la Cour en eut une joie qui ne peut s\'imaginer; il n\'y eut que sa cadette qui n\'en fut pas bien aise, parce que n\'ayant plus sur son aînée l\'avantage de l\'esprit, elle ne paraissait plus auprès d\'elle qu\'une guenon fort désagréable. Le roi se conduisait selon ses avis, et allait même quelquefois tenir le conseil dans son Appartement.

Le bruit de ce changement s\'étant répandu, tous les jeunes Princes des Royaumes voisins firent grands efforts pour s\'en faire aimer, et presque tous la demandèrent en Mariage; mais elle n\'en trouvait point qui eût assez d\'esprit, et elle les écoutait tous sans s\'engager avec l\'un d\'eux. Cependant il en vint un si puissant, si riche, si spirituel et si bien fait, qu\'elle ne put s\'empêcher d\'avoir de la bonne volonté pour lui. Son père s\'en étant aperçu lui dit qu\'il la faisait la maîtresse sur le choix d\'un époux, et qu\'elle n\'avait qu\'à se déclarer. Comme plus on a d\'esprit et plus on a de peine à prendre une ferme résolution sur cette affaire, elle demanda, après avoir remercié son père, qu\'il lui donnât du temps pour y penser.

Elle alla par hasard se promener dans le même bois où elle avait trouvé Riquet à la houppe, pour rêver plus commodément à ce qu\'elle avait à faire. Dans le temps qu\'elle se promenait, rêvant profondément, elle entendit un bruit sourd sous ses pieds, comme de plusieurs gens qui vont et viennent et qui agissent. Ayant prêté l\'oreille plus attentivement, elle entendit que l\'un disait : \"Apporte-moi cette marmite\"; l\'autre : \"Donne-moi cette chaudière\"; l\'autre : \"Mets du bois dans ce feu.\" La terre s\'ouvrit dans le même temps, et elle vit sous ses pieds comme une grande Cuisine pleine de Cuisiniers, de Marmitons et de toutes sortes d\'Officiers nécessaires pour faire un festin magnifique. Il en sortit une bande de vingt ou trente Rôtisseurs, qui allèrent se camper dans une allée du bois autour d\'une table fort longue, et qui tous, la lardoire à la main, et la queue de renard sur l\'oreille, se mirent à travailler en cadence au son d\'une chanson harmonieuse.

La Princesse, étonnée de ce spectacle, leur demanda pour qui ils travaillaient. C\'est, Madame, lui répondit le plus apparent de la bande, pour le prince Riquet à la houppe, dont les noces se feront demain.\" La Princesse, encore plus surprise qu\'elle ne l\'avait été, et se ressouvenant tout à coup qu\'il y avait un an qu\'à pareil jour elle avait promis d\'épouser le prince Riquet à la houppe, elle pensa tomber de son haut. Ce qui faisait qu\'elle ne s\'en souvenait pas, c\'est que, quand elle fit cette promesse, elle était bête, et qu\'en prenant le nouvel esprit que le prince lui avait donné, elle avait oublié toutes ses sottises. Elle n\'eut pas fait trente pas en continuant sa promenade, que Riquet à la houppe se présenta à elle, brave, magnifique, et comme un Prince qui va se marier. \"Vous me voyez, dit-il, Madame, exact à tenir ma parole, et je ne doute point que vous ne veniez ici pour exécuter la vôtre, et me rendre, en me donnant la main, le plus heureux de tous les hommes.\" - Je vous avouerai franchement, \" répondit la princesse, \" que je n\'ai pas encore pris ma décision là-dessus, et que je ne crois pas pouvoir jamais la prendre comme vous la souhaitez. - Vous m\'étonnez, Madame, lui dit Riquet à la houppe. - Je le crois, dit la Princesse, et assurément si j\'avais affaire à un brutal, à un homme sans esprit, je me trouverais bien embarrassée. Une Princesse n\'a que sa parole, me dirait-il, et il faut que vous m\'épousiez, puisque vous me l\'avez promis; mais comme celui à qui je parle est l\'homme du monde qui a le plus d\'esprit, je suis sûre qu\'il entendra raison. Vous savez que, quand j\'étais bête, je ne pouvais néanmoins me résoudre à vous épouser; comment voulez-vous qu\'ayant l\'esprit que vous m\'avez donné, qui me rend encore plus difficile en gens que je n\'étais, je prenne aujourd\'hui une .décision que je n\'ai pu prendre dans ce temps-là ? Si vous pensiez tout de bon à m\'épouser, vous avez eu grand tort de m\'ôter ma bêtise, et de me faire voir plus clair que je ne voyais. - Si un homme sans esprit, répondit Riquet à la houppe, serait bien reçu, comme vous venez de le dire, à vous reprocher votre manque de parole, pourquoi voulez-vous, Madame, que je n\'en use pas de même, dans une chose où il y va de tout le bonheur de ma vie ? Est-il raisonnable que ceux qui ont de l\'esprit soient d\'une pire condition que ceux qui n\'en ont pas ? Pouvez-vous le prétendre, vous qui en avez tant, et qui avez tant souhaité d\'en avoir ? Mais venons au fait, s\'il vous plaît : à la réserve de ma laideur, y a-t-il quelque chose en moi qui vous déplaise ? Etes-vous mal contente de ma naissance, de mon esprit, de mon humeur, et de mes manières ? - Nullement , répondit la Princesse, j\'aime en vous tout ce que vous venez de me dire. - Si cela est ainsi, reprit Riquet à la houppe, je vais être heureux, puisque vous pouvez me rendre le plus aimable de tous les hommes. - Comment cela se peut-il ? lui dit la Princesse. - Cela se fera, répondit Riquet à la houppe, si vous m\'aimez assez pour souhaiter que cela soit; et afin, Madame, que vous n\'en doutiez pas, sachez que la même fée qui au jour de ma naissance me fit le don de pouvoir rendre spirituelle qui me plairait, vous a aussi fait le don de pouvoir rendre beau celui que vous aimerez, et à qui vous voudrez bien faire cette faveur.\" - Si la chose est ainsi, dit la Princesse, je souhaite de tout mon coeur que vous deveniez le prince du monde le plus beau et le plus aimable; et je vous en fais le don autant qu\'il est en moi.\"

La Princesse n\'eut pas plus tôt prononcé ces paroles, que Riquet à la houppe parut à ses yeux l\'homme du monde le plus beau, le mieux fait, et le plus aimable qu\'elle eût jamais vu.

Quelques-uns assurent que ce ne furent point les charmes de la fée qui opérèrent, mais que l\'amour seul fit cette Métamorphose. Ils disent que la Princesse ayant fait réflexion sur la persévérance de son amant, sur sa discrétion, et sur toutes les bonnes qualités de son âme et de son esprit, ne vit plus la difformité de son corps, ni la laideur de son visage, que sa bosse ne lui sembla plus que le bon air d\'un homme qui fait le gros dos; et qu\'au lieu que jusqu\'alors elle l\'avait vu boiter effroyablement, elle ne lui trouva plus qu\'un certain air penché qui la charmait; ils disent encore que ses yeux, qui étaient louches, ne lui en parurent que plus brillants, que leur dérèglement passa dans son esprit pour la marque d\'un violent excès d\'amour, et qu\'enfin son gros nez rouge eut pour elle quelque chose de martial et d\'héroïque.

Quoi qu\'il en soit, la Princesse lui promit sur-le-champ de l\'épouser, pourvu qu\'il en obtint le consentement du roi son père. Le roi ayant su que sa fille avait beaucoup d\'estime pour Riquet à la houppe, qu\'il connaissait d\'ailleurs pour un prince très spirituel et très sage, le reçut avec plaisir pour son gendre. Dès le lendemain les noces furent faites, ainsi que Riquet à la houppe l\'avait prévu, et selon les ordres qu\'il en avait donnés longtemps auparavant.


MORALITE

Ce que l\'on voit dans cet écrit, 
Est moins un conte en l\'air que la vérité même; 
Tout est beau dans ce que l\'on aime, 
Tout ce qu\'on aime a de l\'esprit. 

AUTRE MORALITE

<poesie>Dans un objet où la Nature, 
Aura mis de beaux traits, et la vive peinture 
D\'un teint où jamais l\'Art ne saurait arriver, 
Tous ces dons pourront moins pour rendre un coeur sensible, 
Qu\'un seul agrément invisible 
Que l\'Amour y fera trouver. </poesie>


Récupérée de « http://fr.wikisource.org/wiki/Riquet_%C3%A0_la_houppe »
', '', '2007-05-22 17:27:40', 'publie', '26', '2011-04-28 21:32:02', 'oui', '0000-00-00 00:00:00', '29024', '0', '0.042939360300337', 'non', '2007-05-22 18:49:15', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('14', '', 'Peau d\'âne, Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition.} }}} 


À Madame la marquise de L*** [1]



<poesie>Il est des gens de qui l’esprit guindé,
Sous un front jamais déridé,
Ne souffre, n’approuve et n’estime
Que le pompeux et le sublime ;
Pour moi, j’ose poser en fait
Qu’en de certains moments l’esprit le plus parfait
Peut aimer sans rougir jusqu’aux Marionnettes ;
Et qu’il est des temps et des lieux
Où le grave et le sérieux
Ne valent pas d’agréables sornettes.
Pourquoi faut-il s’émerveiller
Que la Raison la mieux sensée,
Lasse souvent de trop veiller,
Par des contes d’Ogre et de Fée
Ingénieusement bercée,
Prenne plaisir à sommeiller ?
Sans craindre donc qu’on me condamne
De mal employer mon loisir,
Je vais, pour contenter votre juste désir,
Vous conter tout au long l’histoire de Peau-d’Âne.

Il était une fois un Roi,
Le plus grand qui fût sur la Terre,
Aimable en Paix, terrible en Guerre,
Seul enfin comparable à soi :
Ses voisins le craignaient, ses États étaient calmes,
Et l’on voyait de toutes parts
Fleurir, à l’ombre de ses palmes,
Et les Vertus et les beaux Arts.
Son aimable Moitié, sa Compagne fidèle,
Était si charmante et si belle,
Avait l’esprit si commode et si doux
Qu’il était encor avec elle
Moins heureux Roi qu’heureux époux.
De leur tendre et chaste Hyménée
Pleine de douceur et d’agrément,
Avec tant de vertus une fille était née
Qu’ils se consolaient aisément
De n’avoir pas de plus ample lignée.

Dans son vaste et riche Palais
Ce n’était que magnificence ;
Partout y fourmillait une vive abondance
De Courtisans et de Valets ;
Il avait dans son Écurie
Grands et petits chevaux de toutes les façons ;
Couverts de beaux caparaçons
Roides d’or et de broderie ;
Mais ce qui surprenait tout le monde en entrant,
C’est qu’au lieu le plus apparent,
Un maître Âne étalait ses deux grandes oreilles.
Cette injustice vous surprend,
Mais lorsque vous saurez ses vertus nonpareilles,
Vous ne trouverez pas que l’honneur fût trop grand.
Tel et si net le forma la Nature
Qu’il ne faisait jamais d’ordure,
Mais bien beaux Écus au soleil
Et Louis de toute manière,
Qu’on allait recueillir sur la blonde litière
Tous les matins à son réveil.

Or le Ciel qui parfois se lasse
De rendre les hommes contents,
Qui toujours à ses biens mêle quelque disgrâce,
Ainsi que la pluie au beau temps,
Permit qu’une âpre maladie
Tout à coup de la Reine attaquât les beaux jours.
Partout on cherche du secours ;
Mais ni la Faculté qui le Grec étudie,
Ni les Charlatans ayant cours,
Ne purent tous ensemble arrêter l’incendie
Que la fièvre allumait en s’augmentant toujours.

Arrivée à sa dernière heure
Elle dit au Roi son Époux :
« Trouvez bon qu’avant que je meure
J’exige une chose de vous ;
C’est que s’il vous prenait envie
De vous remarier quand je n’y serai plus…
— Ah! dit le Roi, ces soins sont superflus,
Je n’y songerai de ma vie,
Soyez en repos là-dessus.
— Je le crois bien, reprit la Reine,
Si j’en prends à témoin votre amour véhément ;
Mais pour m’en rendre plus certaine,
Je veux avoir votre serment,
Adouci toutefois par ce tempérament
Que si vous rencontrez une femme plus belle,
Mieux faite et plus sage que moi,
Vous pourrez franchement lui donner votre foi
Et vous marier avec elle. »
Sa confiance en ses attraits
Lui faisait regarder une telle promesse
Comme un serment, surpris avec adresse,
De ne se marier jamais.
Le Prince jura donc, les yeux baignés de larmes,
Tout ce que la Reine voulut ;
La Reine entre ses bras mourut,
Et jamais un Mari ne fit tant de vacarmes.
À l’ouïr sangloter et les nuits et les jours,
On jugea que son deuil ne lui durerait guère,
Et qu’il pleurait ses défuntes Amours
Comme un homme pressé qui veut sortir d’affaire.

On ne se trompa point. Au bout de quelques mois
Il voulut procéder à faire un nouveau choix ;
Mais ce n’était pas chose aisée,
Il fallait garder son serment
Et que la nouvelle Épousée
Eût plus d’attraits et d’agrément
Que celle qu’on venait de mettre au monument.

Ni la Cour en beautés fertile,
Ni la Campagne, ni la Ville,
Ni les Royaumes d’alentour
Dont on alla faire le tour,
N’en purent fournir une telle ;
L’Infante seule était plus belle
Et possédait certains tendres appas
Que la défunte n’avait pas.
Le Roi le remarqua lui-même
Et brûlant d’un amour extrême
Alla follement s’aviser
Que par cette raison il devait l’épouser.
Il trouva même un Casuiste
Qui jugea que le cas se pouvait proposer.
Mais la jeune Princesse triste
D’ouïr parler d’un tel amour,
Se lamentait et pleurait nuit et jour.

De mille chagrins l’âme pleine,
Elle alla trouver sa Marraine,
Loin, dans une grotte à l’écart
De Nacre et de Corail richement étoffée.
C’était une admirable Fée
Qui n’eut jamais de pareille en son Art.
Il n’est pas besoin qu’on vous die
Ce qu’était une Fée en ces bienheureux temps ;
Car je suis sûr que votre Mie
Vous l’aura dit dès vos plus jeunes ans.

« Je sais, dit-elle, en voyant la Princesse,
Ce qui vous fait venir ici,
Je sais de votre cœur la profonde tristesse ;
Mais avec moi n’ayez plus de souci.
Il n’est rien qui vous puisse nuire
Pourvu qu’à mes conseils vous vous laissiez conduire.
Votre Père, il est vrai, voudrait vous épouser ;
Écouter sa folle demande
Serait une faute bien grande,
Mais sans le contredire on le peut refuser.

Dites-lui qu’il faut qu’il vous donne
Pour rendre vos désirs contents,
Avant qu’à son amour votre cœur s’abandonne,
Une Robe qui soit de la couleur du Temps.
Malgré tout son pouvoir et toute sa richesse,
Quoique le Ciel en tout favorise ses vœux,
Il ne pourra jamais accomplir sa promesse. »

Aussitôt la jeune Princesse
L’alla dire en tremblant à son Père amoureux
Qui dans le moment fit entendre
Aux Tailleurs les plus importants
Que s’ils ne lui faisaient, sans trop le faire attendre,
Une Robe qui fût de la couleur du Temps,
Ils pouvaient s’assurer qu’il les ferait tous pendre.

Le second jour ne luisait pas encor
Qu’on apporta la Robe désirée ;
Le plus beau bleu de l’Empyrée
N’est pas, lorsqu’il est ceint de gros nuage d’or
D’une couleur plus azurée.
De joie et de douleur l’Infante pénétrée
Ne sait que dire ni comment
Se dérober à son engagement.
« Princesse, demandez-en une,
Lui dit sa Marraine tout bas,
Qui plus brillante et moins commune,
Soit de la couleur de la Lune.
Il ne vous la donnera pas. »
À peine la Princesse en eut fait la demande
Que le Roi dit à son Brodeur :
« Que l’astre de la Nuit n’ait pas plus de splendeur
Et que dans quatre jours sans faute on me la rende. »

Le riche habillement fut fait au jour marqué,
Tel que le Roi s’en était expliqué.
Dans les Cieux où la Nuit a déployé ses voiles,
La Lune est moins pompeuse en sa robe d’argent
Lors même qu’au milieu de son cours diligent
Sa plus vive clarté fait pâlir les étoiles.

La Princesse admirant ce merveilleux habit,
Était à consentir presque délibérée ;
Mais par sa Marraine inspirée,
Au Prince amoureux elle dit :
« Je ne saurais être contente
Que je n’aie une Robe encore plus brillante
Et de la couleur du Soleil. »
Le Prince qui l’aimait d’un amour sans pareil,
Fit venir aussitôt un riche Lapidaire
Et lui commanda de la faire
D’un superbe tissu d’or et de diamants,
Disant que s’il manquait à le bien satisfaire,
Il le ferait mourir au milieu des tourments.

Le Prince fut exempt de s’en donner la peine,
Car l’ouvrier industrieux,
Avant la fin de la semaine,
Fit apporter l’ouvrage précieux,
Si beau, si vif, si radieux,
Que le blond Amant de Clymène,
Lorsque sur la voûte des Cieux
Dans son char d’or il se promène,
D’un plus brillant éclat n’éblouit pas les yeux.

L’Infante que ces dons achèvent de confondre,
À son Père, à son Roi ne sait plus que répondre.
Sa Marraine aussitôt la prenant par la main :
« Il ne faut pas, lui dit-elle à l’oreille,
Demeurer en si beau chemin ;
Est-ce une si grande merveille
Que tous ces dons que vous en recevez,
Tant qu’il aura l’Âne que vous savez,
Qui d’écus d’or sans cesse emplit sa bourse?
Demandez-lui la peau de ce rare Animal.
Comme il est toute sa ressource,
Vous ne l’obtiendrez pas, ou je raisonne mal. »

Cette Fée était bien savante,
Et cependant elle ignorait encor
Que l’amour violent pourvu qu’on le contente,
Compte pour rien l’argent et l’or ;
La peau fut galamment aussitôt accordée
Que l’Infante l’eut demandée.

Cette Peau quand on l’apporta
Terriblement l’épouvanta
Et la fit de son sort amèrement se plaindre.
Sa Marraine survint et lui représenta
Que quand on fait le bien on ne doit jamais craindre :
Qu’il faut laisser penser au Roi
Qu’elle est tout à fait disposée
À subir avec lui la conjugale Loi,
Mais qu’au même moment, seule et bien déguisée,
Il faut qu’elle s’en aille en quelque État lointain
Pour éviter un mal si proche et si certain.

« Voici, poursuivit-elle, une grande cassette
Où nous mettrons tous vos habits,
Votre miroir votre toilette,
Vos diamants et vos rubis.
Je vous donne encor ma Baguette ;
En la tenant en votre main,
La cassette suivra votre même chemin
Toujours sous la Terre cachée ;
Et lorsque vous voudrez l’ouvrir,
À peine mon bâton la Terre aura touchée
Qu’aussitôt à vos yeux elle viendra s’offrir.

Pour vous rendre méconnaissable,
La dépouille de l’âne est un masque admirable.
Cachez-vous bien dans cette peau,
On ne croira jamais, tant elle est effroyable,
Qu’elle renferme rien de beau. »

La Princesse ainsi travestie
De chez la sage Fée à peine fut sortie,
Pendant la fraîcheur du matin,
Que le Prince qui pour la Fête
De son heureux Hymen s’apprête,
Apprend tout effrayé son funeste destin.
Il n’est point de maison, de chemin, d’avenue,
Qu’on ne parcoure promptement ;
Mais on s’agite vainement,
On ne peut deviner ce qu’elle est devenue.

Partout se répandit un triste et noir chagrin ;
Plus de Noces, plus de Festin,
Plus de Tarte, plus de Dragées ;
Les Dames de la Cour toutes découragées,
N’en dînèrent point la plupart ;
Mais du Curé surtout la tristesse fut grande,
Car il en déjeuna fort tard,
Et qui pis est n’eut point d’offrande.

L’Infante cependant poursuivait son chemin,
Le visage couvert d’une vilaine crasse ;
À tous Passants elle tendait la main,
Et tâchait pour servir de trouver une place.
Mais les moins délicats et les plus malheureux
La voyant si maussade et si pleine d’ordure,
Ne voulaient écouter ni retirer chez eux
Une si sale créature.

Elle alla donc bien loin, bien loin, encor plus loin ;
Enfin elle arriva dans une Métairie
Où la Fermière avait besoin
D’une souillon, dont l’industrie
Allât jusqu’à savoir bien laver des torchons
Et nettoyer l’auge aux Cochons.

On la mit dans un coin au fond de la cuisine
Où les Valets, insolente vermine,
Ne faisaient que la tirailler
La contredire et la railler ;
Ils ne savaient quelle pièce lui faire,
La harcelant à tout propos ;
Elle était la butte ordinaire
De tous leurs quolibets et de tous leurs bons mots.

Elle avait le Dimanche un peu plus de repos ;
Car ayant du matin fait sa petite affaire,
Elle entrait dans sa chambre en tenant son huis clos,
Elle se décrassait, puis ouvrait sa cassette,
Mettait proprement sa toilette,
Rangeait dessus ses petits pots.
Devant son grand miroir, contente et satisfaite,
De la Lune tantôt la robe elle mettait,
Tantôt celle où le feu du Soleil éclatait,
Tantôt la belle robe bleue
Que tout l’azur des Cieux ne saurait égaler,
Avec ce chagrin seul que leur traînante queue
Sur le plancher trop court ne pouvait s’étaler.
Elle aimait à se voir jeune, vermeille et blanche
Et plus brave cent fois que nulle autre n’était ;
Ce doux plaisir la sustentait
Et la menait jusqu’à l’autre Dimanche.

J’oubliais à dire en passant
Qu’en cette grande Métairie
D’un Roi magnifique et puissant
Se faisait la Ménagerie,
Que là, Poules de Barbarie,
Râles, Pintades, Cormorans,
Oisons musqués, Canes Petières,
Et mille autres oiseaux de bizarres manières,
Entre eux presque tous différents,
Remplissaient à l’envi dix cours toutes entières.

Le Fils du Roi dans ce charmant séjour
Venait souvent au retour de la Chasse
Se reposer boire à la glace
Avec les Seigneurs de sa Cour.
Tel ne fut point le beau Céphale :
Son air était Royal, sa mine martiale,
Propre à faire trembler les plus fiers bataillons.
Peau d’Âne de fort loin le vit avec tendresse,
Et reconnut par cette hardiesse
Que sous sa crasse et ses haillons
Elle gardait encor le cœur d’une Princesse.

« Qu’il a l’air grand, quoiqu’il l’ait négligé,
Qu’il est aimable, disait-elle,
Et que bienheureuse est la belle
À qui son cœur est engagé !
D’une robe de rien s’il m’avait honorée,
Je m’en trouverais plus parée
Que de toutes celles que j’ai. »

Un jour le jeune Prince errant à l’aventure
De basse-cour en basse-cour,
Passa dans une allée obscure
Où de Peau d’Âne était l’humble séjour.
Par hasard il mit l’œil au trou de la serrure.
Comme il était fête ce jour,
Elle avait pris une riche parure
Et ses superbes vêtements
Qui, tissus de fin or et de gros diamants,
Égalaient du Soleil la clarté la plus pure.
Le Prince au gré de son désir
La contemple et ne peut qu’à peine,
En la voyant, reprendre haleine,
Tant il est comblé de plaisir.
Quels que soient les habits, la beauté du visage,
Son beau tour, sa vive blancheur,
Ses traits fins, sa jeune fraîcheur
Le touchent cent fois davantage ;
Mais un certain air de grandeur,
Plus encore une sage et modeste pudeur,
Des beautés de son âme assuré témoignage,
S’emparèrent de tout son cœur.

Trois fois, dans la chaleur du feu qui le transporte,
Il voulut enfoncer la porte ;
Mais croyant voir une Divinité,
Trois fois par le respect son bras fut arrêté.

Dans le Palais, pensif il se retire,
Et là, nuit et jour il soupire ;
Il ne veut plus aller au Bal
Quoiqu’on soit dans le Carnaval.
Il hait la Chasse, il hait la Comédie,
Il n’a plus d’appétit, tout lui fait mal au cœur,
Et le fond de sa maladie
Est une triste et mortelle langueur.

Il s’enquit quelle était cette Nymphe admirable
Qui demeurait dans une basse-cour,
Au fond d’une allée effroyable,
Où l’on ne voit goutte en plein jour.
« C’est, lui dit-on, Peaud’Âne, en rien Nymphe ni belle
Et que Peau d’Âne l’on appelle,
À cause de la Peau qu’elle met sur son cou ;
De l’Amour c’est le vrai remède,
La bête en un mot la plus laide,
Qu’on puisse voir après le Loup. »
On a beau dire, il ne saurait le croire ;
Les traits que l’amour a tracés
Toujours présents à sa mémoire
N’en seront jamais effacés.

Cependant la Reine sa Mère
Qui n’a que lui d’enfant pleure et se désespère ;
De déclarer son mal elle le presse en vain,
Il gémit, il pleure, il soupire,
Il ne dit rien, si ce n’est qu’il désire
Que Peau d’Âne lui fasse un gâteau de sa main ;
Et la Mère ne sait ce que son Fils veut dire.
« Ô Ciel ! Madame, lui dit-on,
Cette Peau d’Âne est une noire Taupe
Plus vilaine encore et plus gaupe
Que le plus sale Marmiton.
— N’importe, dit la Reine, il le faut satisfaire
Et c’est à cela seul que nous devons songer. »
Il aurait eu de l’or, tant l’aimait cette Mère,
S’il en avait voulu manger.

Peau d’Âne donc prend sa farine
Qu’elle avait fait bluter exprès
Pour rendre sa pâte plus fine,
Son sel, son beurre et ses œufs frais ;
Et pour bien faire sa galette,
S’enferme seule en sa chambrette.

D’abord elle se décrassa
Les mains, les bras et le visage,
Et prit un corps d’argent que vite elle laça
Pour dignement faire l’ouvrage
Qu’aussitôt elle commença.

On dit qu’en travaillant un peu trop à la hâte,
De son doigt par hasard il tomba dans la pâte
Un de ses anneaux de grand prix ;
Mais ceux qu’on tient savoir le fin de cette histoire
Assurent que par elle exprès il y fut mis ;
Et pour moi franchement je l’oserais bien croire,
Fort sûr que, quand le Prince à sa porte aborda
Et par le trou la regarda,
Elle s’en était aperçue :
Sur ce point la femme est si drue
Et son œil va si promptement
Qu’on ne peut la voir un moment
Qu’elle ne sache qu’on l’a vue.
Je suis bien sûr encor et j’en ferais serment,
Qu’elle ne douta point que de son jeune Amant
La Bague ne fût bien reçue.

On ne pétrit jamais un si friand morceau,
Et le Prince trouva la galette si bonne
Qu’il ne s’en fallut rien que d’une faim gloutonne
Il n’avalât aussi l’anneau.
Quand il en vit l’émeraude admirable,
Et du jonc d’or le cercle étroit,
Qui marquait la forme du doigt,
Son cœur en fut touché d’une joie incroyable ;
Sous son chevet il le mit à l’instant,
Et son mal toujours augmentant,
Les Médecins sages d’expérience,
En le voyant maigrir de jour en jour,
Jugèrent tous, par leur grande science,
Qu’il était malade d’amour.

Comme l’Hymen, quelque mal qu’on en die,
Est un remède exquis pour cette maladie,
On conclut à le marier ;
Il s’en fit quelque temps prier
Puis dit : « Je le veux bien, pourvu que l’on me donne
En mariage la personne
Pour qui cet anneau sera bon. »
À cette bizarre demande,
De la Reine et du Roi la surprise fut grande ;
Mais il était si mal qu’on n’osa dire non.

Voilà donc qu’on se met en quête
De celle que l’anneau, sans nul égard du sang,
Doit placer dans un si haut rang ;
Il n’en est point qui ne s’apprête
À venir présenter son doigt
Ni qui veuille céder son droit.

Le bruit ayant couru que pour prétendre au Prince,
Il faut avoir le doigt bien mince,
Tout Charlatan, pour être bienvenu,
Dit qu’il a le secret de le rendre menu ;
L’une, en suivant son bizarre caprice,
Comme une rave le ratisse ;
L’autre en coupe un petit morceau ;
Une autre en le pressant croit qu’elle l’apetisse ;
Et l’autre, avec de certaine eau,
Pour le rendre moins gros en fait tomber la peau ;
Il n’est enfin point de manœuvre
Qu’une Dame ne mette en œuvre,
Pour faire que son doigt cadre bien à l’anneau.

L’essai fut commencé par les jeunes Princesses,
Les Marquises et les Duchesses ;
Mais leurs doigts quoique délicats,
Étaient trop gros et n’entraient pas.
Les Comtesses, et les Baronnes,
Et toutes les nobles Personnes,
Comme elles tour à tour présentèrent leur main
Et la présentèrent en vain.

Ensuite vinrent les Grisettes
Dont les jolis et menus doigts,
Car il en est de très bien faites,
Semblèrent à l’anneau s’ajuster quelquefois.
Mais la Bague toujours trop petite ou trop ronde
D’un dédain presque égal rebutait tout le monde.

Il fallut en venir enfin
Aux Servantes, aux Cuisinières,
Aux Tortillons, aux Dindonnières,
En un mot à tout le fretin,
Dont les rouges et noires pattes,
Non moins que les mains délicates,
Espéraient un heureux destin.
Il s’y présenta mainte fille
Dont le doigt, gros et ramassé,
Dans la Bague du Prince eût aussi peu passé
Qu’un câble au travers d’une aiguille.

On crut enfin que c’était fait,
Car il ne restait en effet,
Que la pauvre Peau d’Âne au fond de la cuisine.
Mais comment croire, disait-on,
Qu’à régner le ciel la destine !
Le Prince dit: « Et pourquoi non ?
Qu’on la fasse venir. » Chacun se prit à rire,
Criant tout haut : « Que veut-on dire,
De faire entrer ici cette sale guenon ? »
Mais lorsqu’elle tira de dessous sa peau noire
Une petite main qui semblait de l’ivoire
Qu’un peu de pourpre a coloré,
Et que de la Bague fatale,
D’une justesse sans égale
Son petit doigt fut entouré,
La Cour fut dans une surprise
Qui ne peut pas être comprise.

On la menait au Roi dans ce transport subit ;
Mais elle demanda qu’avant que de paraître
Devant son Seigneur et son Maître,
On lui donnât le temps de prendre un autre habit.
De cet habit, pour la vérité dire,
De tous côtés on s’apprêtait à rire ;
Mais lorsqu’elle arriva dans les Appartements,
Et qu’elle eut traversé les salles
Avec ses pompeux vêtements
Dont les riches beautés n’eurent jamais d’égales ;
Que ses aimables cheveux blonds
Mêlés de diamants dont la vive lumière
En faisait autant de rayons,
Que ses yeux bleus, grands, doux et longs,
Qui pleins d’une Majesté fière
Ne regardent jamais sans plaire et sans blesser,
Et que sa taille enfin si menue et si fine
Qu’avec que ses deux mains on eût pu l’embrasser,
Montrèrent leurs appas et leur grâce divine,
Des Dames de la Cour, et de leurs ornements
Tombèrent tous les agréments.

Dans la joie et le bruit de toute l’Assemblée,
Le bon Roi ne se sentait pas
De voir sa Bru posséder tant d’appas ;
La Reine en était affolée,
Et le Prince son cher Amant,
De cent plaisirs l’âme comblée,
Succombait sous le poids de son ravissement.
Pour l’Hymen aussitôt chacun prit ses mesures ;
Le Monarque en pria tous les Rois d’alentour,
Qui, tous brillants de diverses parures,
Quittèrent leurs États pour être à ce grand jour.
On en vit arriver des climats de l’Aurore,
Montés sur de grands Éléphants ;
Il en vint du rivage More,
Qui, plus noirs et plus laids encore,
Faisaient peur aux petits enfants ;
Enfin de tous les coins du Monde,
Il en débarque et la Cour en abonde.

Mais nul Prince, nul Potentat,
N’y parut avec tant d’éclat
Que le père de l’Épousée,
Qui d’elle autrefois amoureux
Avait avec le temps purifié les feux
Dont son âme était embrasée.
Il en avait banni tout désir criminel
Et de cette odieuse flamme
Le peu qui restait dans son âme
N’en rendait que plus vif son amour paternel.
Dès qu’il la vit : « Que béni soit le Ciel
Qui veut bien que je te revoie,
Ma chère enfant », dit-il, et tout pleurant de joie,
Courut tendrement l’embrasser ;
Chacun à son bonheur voulut s’intéresser,
Et le futur Époux était ravi d’apprendre
Que d’un Roi si puissant il devenait le Gendre.

Dans ce moment la Marraine arriva
Qui raconta toute l’histoire,
Et par son récit acheva
De combler Peau d’Âne de gloire.

Il n’est pas malaisé de voir
Que le but de ce Conte est qu’un Enfant apprenne
Qu’il vaut mieux s’exposer à la plus rude peine
Que de manquer à son devoir ;

Que la Vertu peut être infortunée
Mais qu’elle est toujours couronnée ;
Que contre un fol amour et ses fougueux transports
La Raison la plus forte est une faible digue,
Et qu’il n’est point de riches trésors
Dont un Amant ne soit prodigue ;

Que de l’eau claire et du pain bis
Suffisent pour la nourriture
De toute jeune Créature,
Pourvu qu’elle ait de beaux habits ;
Que sous le Ciel il n’est point de femelle
Qui ne s’imagine être belle,
Et qui souvent ne s’imagine encor
Que si des trois Beautés la fameuse querelle
S’était démêlée avec elle,
Elle aurait eu la pomme d’or.

Le Conte de Peau d’Âne est difficile à croire,
Mais tant que dans le Monde on aura des Enfants,
Des Mères et des Mères-grands,
On en gardera la mémoire.</poesie>', '', '2007-05-22 21:27:11', 'publie', '26', '2011-04-28 21:28:40', 'oui', '0000-00-00 00:00:00', '7870', '0', '0.218578179299207', 'non', '2007-05-22 21:26:49', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('15', '', 'La belle au bois dormant, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition.} }}} 

La belle au bois dormant

Il était une fois un Roi et une Reine qui étaient si fâchés de n\'avoir point d\'enfants, si fâchés qu\'on ne saurait dire. Ils allèrent à toutes les eaux du monde, voeux, pèlerinages, menues dévotions; tout fut mis en oeuvre, et rien n\'y faisait.

Enfin pourtant la Reine devint grosse, et accoucha d\'une fille: on fit un beau Baptême; on donna pour Marraines à la petite Princesse toutes les Fées qu\'on pût trouver dans le Pays (il s\'en trouva sept), afin que chacune d\'elles lui faisant un don, comme c\'était la coutume des Fées en ce temps-là, la Princesse eût par ce moyen toutes les perfections imaginables.

Après les cérémonies du Baptême toute la compagnie revint au Palais du Roi, où il y avait un grand festin pour les Fées. On mit devant chacune d\'elles un couvert magnifique, avec un étui d\'or massif, où il y avait une cuiller, une fourchette, et un couteau de fin or, garni de diamants et de rubis. Mais comme chacun prenait sa place à table. On vit entrer une vieille Fée qu\'on n\'avait point priée parce qu\'il y avait plus de cinquante ans qu\'elle n\'était sortie d\'une Tour et qu\'on la croyait morte, ou enchantée.

Le Roi lui fit donner un couvert, mais il n\'y eut pas moyen de lui donner un étui d\'or massif, comme aux autres, parce que l\'on n\'en avait fait faire que sept pour les sept Fées. La vieille crut qu\'on la méprisait, et grommela quelques menaces entre ses dents.

Une des jeunes Fées qui se trouva auprès d\'elle l\'entendit, et jugeant qu\'elle pourrait donner quelque fâcheux don à la petite Princesse, alla, dès qu\'on fut sorti de table, se cacher derrière la tapisserie, afin de parler la dernière, et de pouvoir réparer autant qu\'il lui serait possible le mal que la vieille aurait fait.

Cependant les Fées commencèrent à faire leurs dons à la Princesse. La plus jeune lui donna pour don qu\'elle serait la plus belle du monde, celle d\'après qu\'elle aurait de l\'esprit comme un Ange, la troisième qu\'elle aurait une grâce admirable à tout ce qu\'elle ferait, la quatrième qu\'elle danserait parfaitement bien, la cinquième qu\'elle chanterait comme un Rossignol, et la sixième qu\'elle jouerait de toutes sortes d\'instruments à la perfection.

Le rang de la vieille Fée étant venu, elle dit en branlant la tête, encore plus de dépit que de vieillesse, que la princesse se percerait la main d\'un fuseau, et qu\'elle en mourrait.

Ce terrible don fit frémir toute la compagnie, et il n\'y eut personne qui ne pleurât.

Dans ce moment la jeune Fée sortit de derrière la tapisserie, et dit tout haut ces paroles:

\'\'Rassurez-vous, Roi et Reine, votre fille n\'en mourra pas: il est vrai que je n\'ai pas assez de puissance pour défaire entièrement ce que mon ancienne a fait. La Princesse se percera la main d\'un fuseau; mais au lieu d\'en mourir, elle tombera seulement dans un profond sommeil qui durera cent ans, au bout desquels le fils d\'un Roi viendra la réveiller.\'\'

Le Roi, pour tâcher d\'éviter le malheur annoncé par la vieille, fit publier aussitôt un Edit, par lequel il défendait à tous de filer au fuseau, ni d\'avoir des fuseaux chez soi sous peine de mort.

Au bout de quinze ou seize ans, le Roi et la Reine étant allés à une de leurs Maisons de plaisance, il arriva que la jeune Princesse courant un jour dans le Château, et montant de chambre en chambre, alla jusqu\'au haut d\'un donjon dans un petit galetas, où une bonne Vieille était seule à filer sa quenouille. Cette bonne femme n\'avait point entendu parler des défenses que le Roi avait faites de filer au fuseau.

\'\'Que faites-vous là, ma bonne femme? dit la Princesse.

- Je file, ma belle enfant, lui répondit la vieille qui ne la connaissait pas.

- Ha! que cela est joli, reprit la Princesse, comment faites-vous? Donnez-moi que je voie si j\'en ferais bien autant.\'\'

Elle n\'eut pas plus tôt pris le fuseau, que comme elle était fort vive, un peu étourdie, et que d\'ailleurs l\'Arrêt des Fées l\'ordonnait ainsi, elle s\'en perça la main, et tomba évanouie.

La bonne vieille, bien embarrassée, crie au secours: on vient de tous côtés, on jette de l\'eau au visage de la Princesse, on la délace, on lui frappe dans les mains, on lui frotte les tempes avec de l\'eau de la Reine de Hongrie; mais rien ne la faisait revenir.

Alors le Roi, qui était monté au bruit, se souvint de la prédiction des fées, et jugeant bien qu\'il fallait que cela arrivât, puisque les fées l\'avaient dit, fit mettre la Princesse dans le plus bel appartement du Palais, sur un lit en broderie d\'or et d\'argent. On eût dit d\'un Ange, tant elle était belle; car son évanouissement n\'avait pas ôté les couleurs vives de son teint: ses joues étaient incarnates, et ses lèvres comme du corail; elle avait seulement les yeux fermés, mais on l\'entendait respirer doucement, ce qui montrait bien qu\'elle n\'était pas morte.

Le Roi ordonna qu\'on la laissât dormir, jusqu\'à ce que son heure de se réveiller fût venue.

La bonne Fée qui lui avait sauvé la vie, en la condamnant à dormir cent ans, était dans le Royaume de Mataquin, à douze mille lieues de là, lorsque l\'accident arriva à la Princesse; mais elle en fut avertie en un instant par un petit Nain, qui avait des bottes de sept lieues (c\'était des bottes avec lesquelles on faisait sept lieues d\'une seule enjambée).

La Fée partit aussitôt, et on la vit au bout d\'une heure arriver dans un chariot tout de feu, traîné par des dragons. Le Roi lui alla présenter la main à la descente du chariot. Elle approuva tout ce qu\'il avait fait; mais comme elle était grandement prévoyante, elle pensa que quand la Princesse viendrait à se réveiller, elle serait bien embarrassée toute seule dans ce vieux Château.

Voici ce qu\'elle fit: elle toucha de sa baguette tout ce qui était dans ce Château (hors le Roi et la Reine), Gouvernantes, Filles d\'Honneur, Femmes de Chambre, Gentilshommes, Officiers, Maîtres d\'Hôtel, Cuisiniers, Marmitons, Galopins, Gardes, Suisses, Pages, Valets de pied; elle toucha aussi tous les chevaux qui étaient dans les Ecuries, avec les Palefreniers, les gros mâtins de basse-cour, et Pouffe, la petite chienne de la Princesse, qui était auprès d\'elle sur son lit.

Dès qu\'elle les eut touchés, ils s\'endormirent tous, pour ne se réveiller qu\'en même temps que leur Maîtresse, afin d\'être tout prêts à la servir quand elle en aurait besoin: les broches mêmes qui étaient au feu toutes pleines de perdrix et de faisans s\'endormirent, et le feu aussi. Tout cela se fit en un moment; les Fées n\'étaient pas longues à leur besogne.

Alors le Roi et la Reine, après avoir embrassé leur chère enfant sans qu\'elle s\'éveillât, sortirent du Château, et firent publier des défenses à qui que ce soit d\'en approcher. Ces défenses n\'étaient pas nécessaires, car il crût dans un quart d\'heure tout autour du parc une si grande quantité de grands arbres et de petits, de ronces et d\'épines entrelacées les unes dans les autres, que bête ni homme n\'y aurait pu passer: en sorte qu\'on ne voyait plus que le haut des Tours du Château, encore n\'était-ce que de bien loin. On ne douta point que la fée n\'eût encore fait là un tour de son métier, afin que la princesse, pendant qu\'elle dormirait, n\'eût rien à craindre des Curieux.

Au bout de cent ans, le Fils du Roi qui régnait alors, et qui était d\'une autre famille que la Princesse endormie, étant allé à la chasse de ce côté-là, demanda ce que c\'était que ces Tours qu\'il voyait au-dessus d\'un grand bois fort épais; chacun lui répondit selon qu\'il en avait ouï parler.

Les uns disaient que c\'était un vieux Château où il revenait des Esprits; les autres que tous les Sorciers de la contrée y faisaient leur sabbat. La plus commune opinion était qu\'un Ogre y demeurait, et que là il emportait tous les enfants qu\'il pouvait attraper, pour pouvoir les manger à son aise, et sans qu\'on le pût suivre, ayant seul le pouvoir de se faire un passage au travers du bois.

Le Prince ne savait qu\'en croire, lorsqu\'un vieux Paysan prit la parole, et lui dit:

\'\'Mon Prince, il y a plus de cinquante ans que j\'ai entendu dire de mon père qu\'il y avait dans ce Château une Princesse, la plus belle du monde; qu\'elle devait y dormir cent ans, et qu\'elle serait réveillée par le fils d\'un Roi, à qui elle était réservée.\'\'

Le jeune Prince à ce discours se sentit tout de feu; il crut sans hésiter qu\'il mettrait fin à une si belle aventure; et poussé par l\'amour et par la gloire, il résolut de voir sur-le-champ ce qu\'il en était.

A peine s\'avança-t-il vers le bois, que tous ces grands arbres, ces ronces et ces épines s\'écartèrent d\'eux-mêmes pour le laisser passer: il marcha vers le Château qu\'il voyait au bout d\'une grande avenue où il entra, et ce qui le surprit un peu, il vit que personne de ses gens ne l\'avait pu suivre, parce que les arbres s\'étaient rapprochés dès qu\'il avait été passé.

Il continua donc son chemin: un Prince jeune et amoureux est toujours vaillant. Il entra dans une grande avant-cour où tout ce qu\'il vit d\'abord était capable de le glacer de crainte: c\'était un silence affreux, l\'image de la mort s\'y présentait partout, et ce n\'était que des corps étendus d\'hommes et d\'animaux, qui paraissaient morts. Il reconnut pourtant bien au nez bourgeonné et à la face vermeille des Suisses qu\'ils n\'étaient qu\'endormis, et leurs tasses, où il y avait encore quelques gouttes de vin, montraient assez qu\'ils s\'étaient endormis en buvant.

Il passe une grande cour pavée de marbre, il monte l\'escalier, il entre dans la salle des Gardes qui étaient rangés en haie, l\'arme sur l\'épaule, et ronflants de leur mieux. Il traverse plusieurs chambres pleines de Gentilshommes et de Dames, dormant tous, les uns debout, les autres assis; il entre dans une chambre toute dorée, et il vit sur un lit, dont les rideaux étaient ouverts de tous côtés, le plus beau spectacle qu\'il eût jamais vu: une Princesse qui paraissait avoir quinze ou seize ans, et dont l\'éclat resplendissant avait quelque chose de lumineux et de divin.

Il s\'approcha en tremblant et en admirant, et se mit à genoux auprès d\'elle. Alors comme la fin de l\'enchantement était venue, la Princesse s\'éveilla; et le regardant avec des yeux plus tendres qu\'une première vue ne semblait le permettre:

\'\'Est-ce vous, mon Prince? Lui dit-elle, vous vous êtes bien fait attendre.\'\'

Le prince, charmé de ces paroles, et plus encore de la manière dont elles étaient dites, ne savait comment lui témoigner sa joie et sa reconnaissance; il l\'assura qu\'il l\'aimait plus que lui-même. Ses discours furent mal rangés, ils en plurent davantage: peu d\'éloquence, beaucoup d\'amour. Il était plus embarrassé qu\'elle, et l\'on ne doit pas s\'en étonner; elle avait eu le temps de songer à ce qu\'elle aurait à lui dire, car il y a apparence (l\'Histoire n\'en dit pourtant rien) que la bonne fée, pendant un si long sommeil, lui avait procuré le plaisir des songes agréables. Enfin il y avait quatre heures qu\'ils se parlaient, et ils ne s\'étaient pas encore dit la moitié des choses qu\'ils avaient à se dire.

Cependant tout le Palais s\'était réveillé avec la princesse; chacun songeait à faire sa charge, et comme ils n\'étaient pas tous amoureux, ils mouraient de faim; la Dame d\'honneur, pressée comme les autres, s\'impatienta, et dit tout haut à la Princesse que la viande était servie.

Le Prince aida la Princesse à se lever; elle était tout habillée et fort magnifiquement; mais il se garda bien de lui dire qu\'elle était habillée comme ma grand-mère, et qu\'elle avait un collet monté: elle n\'en était pas moins belle.

Ils passèrent dans un Salon de miroirs, et y soupèrent, servis par les Officiers de la Princesse; les Violons et les Hautbois jouèrent de vieilles pièces, mais excellentes, quoiqu\'il y eût près de cent ans qu\'on ne les jouât plus; et après souper, sans perdre de temps, le grand Aumônier les maria dans la Chapelle du Château, et la Dame d\'honneur leur tira le rideau: ils dormirent peu, la Princesse n\'en avait pas grand besoin, et le Prince la quitta dès le matin pour retourner à la Ville, où son Père devait être en peine de lui.

Le Prince lui dit qu\'en chassant il s\'était perdu dans la forêt, et qu\'il avait couché dans la hutte d\'un Charbonnier, qui lui avait fait manger du pain noir et du fromage. Le Roi son père, qui était bon homme, le crut, mais sa Mère n\'en fut pas bien persuadée, et voyant qu\'il allait presque tous les jours à la chasse, et qu\'il avait toujours une raison pour s\'excuser, quand il avait couché deux ou trois nuits dehors, elle ne douta plus qu\'il n\'eût quelque amourette: car il vécut avec la princesse plus de deux ans entiers, et en eut deux enfants, dont le premier, qui fut une fille, fut nommée l\'Aurore, et le second un fils, qu\'on nomma le Jour, parce qu\'il paraissait encore plus beau que sa soeur.

La Reine dit plusieurs fois à son fils, pour le faire s\'expliquer, qu\'il fallait se contenter dans la vie, mais il n\'osa jamais lui confier son secret; il la craignait quoiqu\'il l\'aimât, car elle était de race Ogresse, et le roi ne l\'avait épousée qu\'à cause de ses grands biens; on disait même tout bas à la Cour qu\'elle avait les inclinations des Ogres, et qu\'en voyant passer de petits enfants, elle avait toutes les peines du monde à se retenir de se jeter sur eux; ainsi le Prince ne voulut jamais rien dire.

Mais quand le Roi fut mort, ce qui arriva au bout de deux ans, et qu\'il se vit le maître, il déclara publiquement son Mariage, et alla en grande cérémonie chercher la Reine sa femme dans son Château.

On lui fit une entrée magnifique dans la Ville Capitale, où elle entra au milieu de ses deux enfants. Quelque temps après, le Roi alla faire la guerre à l\'Empereur Cantalabutte son voisin. Il laissa la Régence du Royaume à la Reine sa mère, et lui recommanda vivement sa femme et ses enfants: il devait être à la guerre tout l\'Eté, et dès qu\'il fut parti, la Reine-Mère envoya sa Bru et ses enfants à une maison de campagne dans les bois, pour pouvoir plus aisément assouvir son horrible envie.

Elle y alla quelques jours après, et dit un soir à son Maître d\'Hôtel:

\'\'Je veux manger demain à mon dîner la petite Aurore.

- Ah! Madame, dit le Maître d\'Hôtel.

- Je le veux, dit la Reine (et elle le dit d\'un ton d\'Ogresse qui a envie de manger de la chair fraîche), et je veux la manger à la Sauce-robert.\'\'

Ce pauvre homme, voyant bien qu\'il ne fallait pas se jouer d\'une Ogresse, prit son grand couteau, et monta à la chambre de la petite Aurore: elle avait alors quatre ans, et vint en sautant et en riant se jeter à son cou, et lui demander du bonbon.

Il se mit à pleurer, le couteau lui tomba des mains, et il alla dans la basse-cour couper la gorge à un petit agneau, et lui fit une si bonne sauce que sa Maîtresse l\'assura qu\'elle n\'avait jamais rien mangé de si bon. Il avait emporté en même temps la petite Aurore, et l\'avait donnée à sa femme pour la cacher dans le logement qu\'elle avait au fond de la basse-cour.

Huit jours après, la méchante Reine dit à son Maître d\'Hôtel:

\"Je veux manger à mon souper le petit Jour.\'\'

Il ne répliqua pas, résolu de la tromper comme l\'autre fois; il alla chercher le petit Jour, et le trouva avec un petit fleuret à la main, dont il faisait des armes avec un gros Singe: il n\'avait pourtant que trois ans. Il le porta à sa femme qui le cacha avec la petite Aurore, et donna à la place du petit Jour un petit chevreau fort tendre, que l\'Ogresse trouva admirablement bon.

Cela avait fort bien été jusque-là, mais un soir cette méchante Reine dit au Maître d\'Hôtel: \'\'Je veux manger la Reine à la même sauce que ses enfants.\'\' Ce fut alors que le pauvre maître d\'hôtel désespéra de pouvoir encore la tromper. La jeune Reine avait vingt ans passés, sans compter les cent ans qu\'elle avait dormi: sa peau était un peu dure, quoique belle et blanche; et le moyen de trouver dans la Ménagerie une bête aussi dure que cela?

Il prit la résolution, pour sauver sa vie, de couper la gorge à la reine, et monta dans sa chambre, dans l\'intention de n\'en pas faire à deux fois; il s\'excitait à la fureur, et entra le poignard à la main dans la chambre de la jeune reine. Il ne voulut pourtant point la surprendre, et il lui dit avec beaucoup de respect l\'ordre qu\'il avait reçu de la Reine-Mère.

\'\'Faites votre devoir, lui dit-elle, en lui tendant le cou; exécutez l\'ordre qu\'on vous a donné; j\'irai revoir mes enfants, mes pauvres enfants que j\'ai tant aimés\'\'; car elle les croyait morts depuis qu\'on les avait enlevés sans rien lui dire.

\'\'Non, non, Madame, lui répondit le pauvre maître d\'hôtel tout attendri, vous ne mourrez point, et vous pourrez revoir vos chers enfants, mais ce sera chez moi où je les ai cachés, et je tromperai encore la Reine, en lui faisant manger une jeune biche en votre place.\'\'

Il la mena aussitôt à sa chambre, où la laissant embrasser ses enfants et pleurer avec eux, il alla accommoder une biche, que la Reine mangea à son souper, avec le même appétit que si c\'eût été la jeune Reine. Elle était bien contente de sa cruauté, et elle se préparait à dire au Roi, à son retour, que les loups enragés avaient mangé la Reine sa femme et ses deux enfants.

Un soir qu\'elle rôdait comme d\'habitude dans les cours et basses-cours du Château pour y humer quelque viande fraîche, elle entendit dans une salle basse le petit Jour qui pleurait, parce que la Reine sa mère le voulait faire fouetter, parce qu\'il avait été méchant, et elle entendit aussi la petite Aurore qui demandait pardon pour son frère.

L\'Ogresse reconnut la voix de la Reine et de ses enfants, et furieuse d\'avoir été trompée, elle commande dès le lendemain au matin, avec une voix épouvantable, qui faisait trembler tout le monde, qu\'on apportât au milieu de la cour une grande cuve, qu\'elle fit remplir de crapauds, de vipères, de couleuvres et de serpents, pour y faire jeter la Reine et ses enfants, le Maître d\'Hôtel, sa femme et sa servante: elle avait donné ordre de les amener les mains liées derrière le dos.

Ils étaient là, et les bourreaux se préparaient à les jeter dans la cuve, Lorsque le Roi, qu\'on n\'attendait pas si tôt, entra dans la cour à cheval; il était venu en poste, et demanda tout étonné ce que voulait dire cet horrible spectacle; personne n\'osait l\'en instruire, quand l\'Ogresse, enragée de voir ce qu\'elle voyait, se jeta elle-même la tête la première dans la cuve, et fut dévorée en un instant par les vilaines bêtes qu\'elle y avait fait mettre.

Le Roi ne put s\'empêcher d\'en être fâché, car elle était sa mère; mais il s\'en consola bientôt avec sa belle femme et ses enfants.

MORALITE

<poesie>Attendre quelque temps pour avoir un Epoux,
Riche, bien fait, galant et doux,
La chose est assez naturelle,
Mais l\'attendre cent ans, et toujours en dormant,
On ne trouve plus de femelle,
Qui dormit si tranquillement.
La Fable semble encor vouloir nous faire entendre
Que souvent de l\'Hymen les agréables noeuds,
Pour être différés, n\'en sont pas moins heureux,
Et qu\'on ne perd rien pour attendre;
Mais le sexe avec tant d\'ardeur,
Aspire à la foi conjugale,
Que je n\'ai pas la force ni le coeur,
De lui prêcher cette morale.<poesie>', '', '2007-05-22 21:39:54', 'publie', '26', '2011-04-28 21:20:05', 'oui', '0000-00-00 00:00:00', '2765', '0', '0.212936870545474', 'non', '2007-05-22 21:39:35', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('16', '', 'Le petit poucet, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition.} }}} 


Il était une fois un bûcheron et une bûcheronne qui avaient sept enfants, tous garçons; l\'aîné n\'avait que dix ans, et le plus jeune n\'en avait que sept.

On s\'étonnera que le bûcheron ait eu tant d\'enfants en si peu de temps ; mais c\'est que sa femme allait vite en besogne, et n\'en avait pas moins de deux à la fois.

Ils étaient fort pauvres, et leurs sept enfants les incommodaient beaucoup, parce qu\'aucun d\'eux ne pouvait encore gagner sa vie. Ce qui les chagrinait encore, c\'est que le plus jeune était fort délicat et ne disait mot : prenant pour bêtise ce qui était une marque de la bonté de son esprit.

Il était fort petit, et, quand il vint au monde, il n\'était guère plus gros que le pouce, ce qui fit qu\'on l\'appela le petit Poucet. Ce pauvre enfant était le souffre-douleur de la maison, et on lui donnait toujours tort. Cependant il était le plus fin et le plus avisé de tous ses frères, et, s\'il parlait peu, il écoutait beaucoup. Il vint une année très fâcheuse, et la famine fut si grande que ces pauvres gens résolurent de se défaire de leurs enfants.

Un soir que ces enfants étaient couchés, et que le bûcheron était auprès du feu avec sa femme, il lui dit, le cœur serré de douleur :

\" Tu vois bien que nous ne pouvons plus nourrir nos enfants; je ne saurais les voir mourir de faim devant mes yeux, et je suis résolu de les mener perdre demain au bois, ce qui sera bien aisé, car, tandis qu\'ils s\'amuseront à fagoter, nous n\'avons qu\'à nous enfuir sans qu\'ils nous voient.

- Ah! s\'écria la bûcheronne, pourrais-tu toi-même mener perdre tes enfants ? \"

Son mari avait beau lui représenter leur grande pauvreté, elle ne pouvait y consentir; elle était pauvre, mais elle était leur mère. Cependant, ayant considéré quelle douleur ce lui serait de les voir mourir de faim, elle y consentit, et alla se coucher en pleurant. Le petit Poucet ouït tout ce qu\'ils dirent, car ayant entendu, de dedans son lit, qu\'ils parlaient d\'affaires, il s\'était levé doucement et s\'était glissé sous l\'escabelle de son père, pour les écouter sans être vu. Il alla se recoucher et ne dormit point du reste de la nuit, songeant à ce qu\'il avait à faire.

Il se leva de bon matin, et alla au bord d\'un ruisseau, où il emplit ses poches de petits cailloux blancs, et ensuite revint à la maison. On partit, et le petit Poucet ne découvrit rien de tout ce qu\'il savait à ses frères. Ils allèrent dans une forêt fort épaisse, où à dix pas de distance, on ne se voyait pas l\'un l\'autre. Le bûcheron se mit à couper du bois, et ses enfants à ramasser des broutilles pour faire des fagots. Le père et la mère, les voyant occupés à travailler, s\'éloignèrent d\'eux insensiblement, et puis s\'enfuirent tout à coup par un petit sentier détourné.

Lorsque ces enfants se virent seuls, ils se mirent à crier et à pleurer de toute leur force.

Le petit Poucet les laissait crier, sachant bien par où il reviendrait à la maison, car en marchant il avait laissé tomber le long du chemin les petits cailloux blancs qu\'il avait dans ses poches. Il leur dit donc :

\" Ne craignez point, mes frères; mon père et ma mère nous ont laissés ici, mais je vous ramènerai bien au logis: suivez-moi seulement. \"

Ils le suivirent, et il les mena jusqu\'à leur maison, par le même chemin qu\'ils étaient venus dans la forêt. Ils n\'osèrent d\'abord entrer, mais ils se mirent tous contre la porte, pour écouter ce que disaient leur père et leur mère.

Dans le moment que le bûcheron et la bûcheronne arrivèrent chez eux, le seigneur du village leur envoya dix écus, qu\'il leur devait il y avait longtemps, et dont ils n\'espéraient plus rien.

Cela leur redonna la vie, car les pauvres gens mouraient de faim. Le bûcheron envoya sur l\'heure sa femme à la boucherie. Comme il y avait longtemps qu\'elle n\'avait mangé, elle acheta trois fois plus de viande qu\'il n\'en fallait pour le souper de deux personnes. Lorsqu\'ils furent rassasiés, la bûcheronne dit :

\" Hélas ! où sont maintenant nos pauvres enfants ? Ils feraient bonne chère de ce qui nous reste là. Mais aussi, Guillaume, c\'est toi qui les as voulu perdre ; j\'avais bien dit que nous nous en repentirions. Que font-ils maintenant dans cette forêt ? Hélas! mon Dieu, les loups les ont peut-être déjà mangés! Tu es bien inhumain d\'avoir perdu ainsi tes enfants ! \"

Le bûcheron s\'impatienta à la fin ; car elle redit plus de vingt fois qu\'ils s\'en repentiraient, et qu\'elle l\'avait bien dit. Il la menaça de la battre si elle ne se taisait.

Ce n\'est pas que le bûcheron ne fût peut-être encore plus fâché que sa femme, mais c\'est qu\'elle lui rompait la tête, et qu\'il était de l\'humeur de beaucoup d\'autres gens, qui aiment fort les femmes qui disent bien, mais qui trouvent très importunes celles qui ont toujours bien dit. La bûcheronne était tout en pleurs :

\" Hélas! où sont maintenant mes enfants, mes pauvres enfants! \"

Elle le dit une fois si haut, que les enfants, qui étaient à la porte, l\'ayant entendue, se mirent à crier tous ensemble:

\" Nous voilà! nous voilà! \"

Elle courut vite leur ouvrir la porte, et leur dit en les embrassant :

\" Que je suis aise de vous revoir, mes chers enfants ! Vous êtes bien las, et vous avez bien faim ; et toi, Pierrot, comme te voilà crotté, viens que je te débarbouille.\"

Ce Pierrot était son fils aîné, qu\'elle aimait plus que tous les autres, parce qu\'il était un peu rousseau, et qu\'elle était un peu rousse. Ils se mirent à table, et mangèrent d\'un appétit qui faisait plaisir au père et à la mère, à qui ils racontaient la peur qu\'ils avaient eue dans la forêt, en parlant presque toujours tous ensemble. Ces bonnes gens étaient ravis de revoir leurs enfants avec eux, et cette joie dura tant que les dix écus durèrent.

Mais, lorsque l\'argent fut dépensé, ils retombèrent dans leur premier chagrin, et résolurent de les perdre encore ; et, pour ne pas manquer leur coup, de les mener bien plus loin que la première fois. Ils ne purent parler de cela si secrètement qu\'ils ne fussent entendus par le petit Poucet, qui fit son compte de sortir d\'affaire comme il avait déjà fait ; mais, quoiqu\'il se fût levé de grand matin pour aller ramasser de petits cailloux, il ne put en venir à bout, car il trouva la porte de la maison fermée à double tour.

Il ne savait que faire, lorsque, la bûcheronne leur ayant donné à chacun un morceau de pain pour leur déjeuner, il songea qu\'il pourrait se servir de son pain au lieu de cailloux, en rejetant par miettes le long des chemins où ils passeraient: il le serra donc dans sa poche.

Le père et la mère les menèrent dans l\'endroit de la forêt le plus épais et le plus obscur; et, dès qu\'ils y furent, ils gagnèrent un faux-fuyant, et les laissèrent là.

Le petit Poucet ne s\'en chagrina pas beaucoup, parce qu\'il croyait retrouver aisément son chemin, par le moyen de son pain qu\'il avait semé partout où il avait passé ; mais il fut bien surpris lorsqu\'il ne put en retrouver une seule miette; les oiseaux étaient venus qui avaient tout mangé.

Les voilà donc bien affligés ; car, plus ils marchaient, plus ils s\'égaraient et s\'enfonçaient dans la forêt.

La nuit vint, et il s\'éleva un grand vent qui leur faisait des peurs épouvantables. Ils croyaient n\'entendre de tous côtés que les hurlements de loups qui venaient à eux pour les manger. Ils n\'osaient presque se parler, ni tourner la tête. Il survint une grosse pluie, qui les perça jusqu\'aux os ; ils glissaient à chaque pas, et tombaient dans la boue, d\'où ils se relevaient tout crottés, ne sachant que faire de leurs mains.

Le petit Poucet grimpa au haut d\'un arbre, pour voir s\'il ne découvrirait rien ; ayant tourné la tête de tous côtés, il vit une petite lueur comme d\'une chandelle, mais qui était bien loin, par delà la forêt. Il descendit de l\'arbre, et lorsqu\'il fut à terre, il ne vit plus rien: cela le désola. Cependant, ayant marché quelque temps avec ses frères, du côté qu\'il avait vu la lumière, il la revit en sortant du bois. Ils arrivèrent enfin à la maison où était cette chandelle, non sans bien des frayeurs : car souvent ils la perdaient de vue; ce qui leur arrivait toutes les fois qu\'ils descendaient dans quelque fond.

Ils heurtèrent à la porte, et une bonne femme vint leur ouvrir. Elle leur demanda ce qu\'ils voulaient. Le petit Poucet lui dit qu\'ils étaient de pauvres enfants qui s\'étaient perdus dans la forêt, et qui demandaient à coucher par charité. Cette femme, les voyant tous si jolis, se mit à pleurer, et leur dit :

\" Hélas ! mes pauvres enfants, où êtes-vous venus ? Savez-vous bien que c\'est ici la maison d\'un Ogre qui mange les petits enfants ?

- Hélas ! madame, lui répondit le petit Poucet, qui tremblait de toute sa force, aussi bien que ses frères, que ferons-nous ? Il est bien sûr que les loups de la forêt ne manqueront pas de nous manger cette nuit si vous ne voulez pas nous retirer chez vous, et cela étant, nous aimons mieux que ce soit Monsieur qui nous mange ; peut-être qu\'il aura pitié de nous si vous voulez bien l\'en prier.\"

La femme de l\'Ogre, qui crut qu\'elle pourrait les cacher à son mari j usqu\'au lendemain matin, les laissa entrer, et les mena se chauffer auprès d\'un bon feu ; car il y avait un mouton tout entier à la broche, pour le souper de l\'Ogre.

Comme ils commençaient à se chauffer, ils entendirent heurter trois ou quatre grands coups à la porte : c\'était l\'Ogre qui revenait. Aussitôt sa femme les fit cacher sous le lit, et alla ouvrir la porte. L\'Ogre demanda d\'abord si le souper était prêt, et si on avait tiré du vin, et aussitôt se mit à table. Le mouton était encore tout sanglant, mais il ne lui en sembla que meilleur. Il flairait à droite et à gauche, disant qu\'il sentait la chair fraîche.

\" Il faut, lui dit sa femme, que ce soit ce veau que je viens d\'habiller*, que vous sentez.

- Je sens la chair fraiche, te dis-je encore une fois, reprit l\'Ogre, en regardant sa femme de travers, et il y a ici quelque chose que je n\'entends pas. \"

En disant ces mots, il se leva de table, et alla droit au lit.

\" Ah! dit-il, voilà donc comme tu veux me tromper, maudite femme! Je ne sais à quoi il tient que je ne te mange aussi : bien t\'en prend d\'être une vieille bête. Voilà du gibier qui me vient bien à propos pour traiter trois ogres de mes amis, qui doivent me venir voir ces jours-ci. \"

Il les tira de dessous le lit, l\'un après l\'autre. Ces pauvres enfants se mirent à genoux, en lui demandant pardon; mais ils avaient affaire au plus cruel de tous les ogres, qui, bien loin d\'avoir de la pitié, les dévorait déjà des yeux, et disait à sa femme que ce seraient là de friands morceaux, lorsqu\'elle leur aurait fait une bonne sauce. Il alla prendre un grand couteau ; et en approchant de ces pauvres enfants, il l\'aiguisait sur une longue pierre, qu\'il tenait à sa main gauche. Il en avait déjà empoigné un, lorsque sa femme lui dit :

\" Que voulez-vous faire à l\'heure qu\'il est ? n\'aurez-vous pas assez de temps demain ?

- Tais-toi, reprit l\'Ogre, ils en seront plus mortifiés.

- Mais vous avez encore là tant de viande, reprit sa femme : voilà un veau, deux moutons et la moitié d\'un cochon !

- Tu as raison, dit l\'Ogre : donne-leur bien à souper afin qu\'ils ne maigrissent pas, et va les mener coucher. \"

La bonne femme fut ravie de joie, et leur porta bien à souper; mais ils ne purent manger, tant ils étaient saisis de peur. Pour l\'Ogre, il se remit à boire, ravi d\'avoir de quoi si bien régaler ses amis. Il but une douzaine de coups de plus qu\'à l\'ordinaire : ce qui lui donna un peu dans la tête, et l\'obligea de s\'aller coucher.

L\'Ogre avait sept filles, qui n\'étaient encore que des enfants. Ces petites ogresses avaient toutes le teint fort beau, parce qu\'elles mangeaient de la chair fraîche, comme leur père ; mais elles avaient de petits yeux gris et tout ronds, le nez crochu, et une fort grande bouche, avec de longues dents fort aiguës et fort éloignées l\'une de l\'autre. Elles n\'étaient pas encore fort méchantes; mais elles promettaient beaucoup, car elles mordaient déjà les petits enfants pour en sucer le sang.

On les avait fait coucher de bonne heure, et elles étaient toutes sept dans un grand lit, ayant chacune une couronne d\'or sur la tête. Il y avait dans la même chambre un autre lit de la même grandeur: ce fut dans ce lit que la femme de l\'Ogre mit coucher les sept petits garçons; après quoi, elle s\'alla coucher auprès de son mari.

Le petit Poucet, qui avait remarqué que les filles de l\'Ogre avaient des couronnes d\'or sur la tête, et qui craignait qu\'il ne prît à l\'Ogre quelques remords de ne les avoir pas égorgés dès le soir même, se leva vers le milieu de la nuit, et prenant les bonnets de ses frères et le sien, il alla tout doucement les mettre sur la tête des sept filles de l\'Ogre, après leur avoir ôté leurs couronnes d\'or, qu\'il mit sur la tête de ses frères, et sur la sienne afin que l\'Ogre les prît pour ses filles, et ses filles pour les garçons qu\'il voulait égorger.

La chose réussit comme il l\'avait pensé ; car l\'Ogre, s\'étant éveillé sur le minuit, eut regret d\'avoir différé au lendemain ce qu\'il pouvait exécuter la veille. Il se jeta donc brusquement hors du lit, et, prenant son grand couteau:

\" Allons voir, dit-il, comment se portent nos petits drôles; n\'en faisons pas à deux fois. \"

Il monta donc à tâtons à la chambre de ses filles, et s\'approcha du lit où étaient les petits garçons, qui dormaient tous, excepté le petit Poucet, qui eut bien peur lorsqu\'il sentit la main de l\'Ogre qui lui tâtait la tête, comme il avait tâté celles de tous ses frères. L\'Ogre, qui sentit les couronnes d\'or :

\" Vraiment, dit- il, j\'allais faire là un bel ouvrage; je vois bien que je bus trop hier au soir. \"

Il alla ensuite au lit de ses filles, où ayant senti les petits bonnets des garçons:

\" Ah ! les voilà, dit-il, nos gaillards ; travaillons hardiment. \"

En disant ces mots, il coupa, sans balancer, la gorge à ses sept filles. Fort content de cette expédition, il alla se recoucher auprès de sa femme. Aussitôt que le petit Poucet entendit ronfler l\'Ogre, il réveilla ses frères, et leur dit de s\'habiller promptement et de le suivre. Ils descendirent doucement dans le jardin et sautèrent par-dessus les murailles. Ils coururent presque toute la nuit, toujours en tremblant, et sans savoir où ils allaient.

L\'Ogre, s\'étant éveillé, dit à sa femme :

\" Va-t\'en là-haut habiller ces petits drôles d\'hier au soir. \"

L\'Ogresse fut fort étonnée de la bonté de son mari, ne se doutant point de la manière qu\'il entendait qu\'elle les habillât, et croyant qu\'il lui ordonnait de les aller vêtir, elle monta en haut, où elle fut bien surprise, lorsqu\'elle aperçut ses sept filles égorgées et nageant dans leur sang. Elle commença par s\'évanouir, car c\'est le premier expédient que trouvent presque toutes les femmes en pareilles rencontres.

L\'Ogre, craignant que sa femme ne fût trop longtemps à faire la besogne dont il l\'avait chargée, monta en haut pour lui aider. Il ne fut pas moins étonné que sa femme lorsqu\'il vit cet affreux spectacle.

\"Ah ! qu\'ai-je fait là ? s\'écria-t-il. Ils me le payeront, les malheureux, et tout à l\'heure. \"

Il jeta aussitôt une potée d\'eau dans le nez de sa femme ; et, l\'ayant fait revenir:

\" Donne-moi vite mes bottes de sept lieues, lui dit-il, afin que j\'aille les attraper. \"

Il se mit en campagne, et après avoir couru bien loin de tous les côtés, enfin il entra dans le chemin où marchaient ces pauvres enfants, qui n\'étaient plus qu\'à cent pas du logis de leur père. Ils virent l\'Ogre qui allait de montagne en montagne, et qui traversait des rivières aussi aisément qu\'il aurait fait le moindre ruisseau.

Le petit Poucet qui vit un rocher creux proche le lieu où ils étaient, y fit cacher ses six frères et s\'y fourra aussi, regardant toujours ce que l\' Ogre deviendrait. L\'Ogre, qui se trouvait fort las du long chemin qu\'il avait fait inutilement (car les bottes de sept lieues fatiguent fort leur homme), voulut se reposer; et, par hasard, il alla s\'asseoir sur la roche où les petits garçons s\'étaient cachés. Comme il n\'en pouvait plus de fatigue, il s\'endormit après s\'être reposé quelque temps, et vint à ronfler si effroyablement, que les pauvres enfants n\'eurent pas moins de peur que quand il tenait son grand couteau pour leur couper la gorge.

Le petit Poucet en eut moins de peur, et dit à ses frères de s\'enfuir promptement à la maison pendant que l\'Ogre dormait bien fort, et qu\'ils ne se missent point en peine de lui. Ils crurent son conseil, et gagnèrent vite la maison.

Le petit Poucet, s\'étant approché de l\'Ogre, lui tira doucement ses bottes, et les mit aussitôt. Les bottes étaient fort grandes et fort larges ; mais, comme elles étaient fées, elles avaient le don de s\'agrandir et de se rapetisser selon la jambe de celui qui les chaussait; de sorte qu\'elles se trouvèrent aussi justes à ses pieds et à ses jambes que si elles eussent été faites pour lui. Il alla droit à la maison de l\'Ogre, où il trouva sa femme qui pleurait auprès de ses filles égorgées.

\" Votre mari, lui dit le petit Poucet, est en grand danger; car il a été pris par une troupe de voleurs, qui ont juré de le tuer s\'il ne leur donne tout son or et tout son argent. Dans le moment qu\'ils lui tenaient le poignard sur la gorge, il m\'a aperçu et m\'a prié de vous venir avertir de l\'état où il est, et de vous dire de me donner tout ce qu\'il a de vaillant, sans en rien retenir, parce qu\'autrement ils le tueront sans miséricorde. Comme la chose presse beaucoup, il a voulu que je prisse ses bottes de sept lieues que voilà, pour faire diligence, et aussi afin que vous ne croyiez pas que je sois un affronteur. \"

La bonne femme, fort effrayée, lui donna aussitôt tout ce qu\'elle avait; car cet Ogre ne laissait pas d\'être fort bon mari, quoiqu\'il mangeât les petits enfants.

Le petit Poucet, étant donc chargé de toutes les richesses de l\'Ogre, s\'en revint au logis de son père, où il fut reçu avec bien de la joie. Il y a bien des gens qui ne demeurent pas d\'accord de cette dernière circonstance, et qui prétendent que le petit Poucet n\'a jamais fait ce vol à l\'Ogre; qu\'à la vérité il n\'avait pas fait conscience de lui prendre ses bottes de sept lieues, parce qu\'il ne s\'en servait que pour courir après les petits enfants. Ces gens là assurent le savoir de bonne part, et même pour avoir bu et mangé dans la maison du bûcheron.

Ils assurent que lorsque le petit Poucet eut chaussé les bottes de l\'Ogre, il s\'en alla à la cour, où il savait qu\'on était fort en peine d\'une armée qui était à deux cents lieues de là, et du succès d\'une bataille qu\'on avait donnée. Il alla, disent-ils, trouver le roi et lui dit que, s\'il le souhaitait il lui rapporterait des nouvelles de l\'armée avant la fin du jour. Le roi lui promit une grosse somme d\'argent s\'il en venait à bout.

Le petit Poucet rapporta des nouvelles, dès le soir même; et cette première course l\'ayant fait connaître, il gagnait tout ce qu\'il voulait; car le roi le payait parfaitement bien pour porter ses ordres à l\'armée ; et une infinité de demoiselles lui donnaient tout ce qu\'il voulait, pour avoir des nouvelles de leurs fiancés et ce fut là son plus grand gain.

Il se trouvait quelques femmes qui le chargeaient de lettres pour leurs maris; mais elles le payaient si mal, et cela allait à si peu de chose qu\'il ne daignait mettre en ligne de compte ce qu\'il gagnait de ce côté-là. Après avoir fait pendant quelque temps le métier de courrier, et y avoir amassé beaucoup de biens, il revint chez son père, où il n\'est pas possible d\'imaginer la joie qu\'on eut de le revoir. Il mit toute sa famille à son aise. Il acheta des offices de nouvelle création pour son père et pour ses frères ; et par là il les établit tous, et fit parfaitement bien sa cour en même temps.

MORALITE

<poesie>On ne s\'afflige point d\'avoir beaucoup d\'enfants,
Quand ils sont tous beaux, bien faits et bien grands,
Et d\'un extérieur qui brille;
Mais si l\'un d\'eux est faible, ou ne dit mot,
On le méprise, on le raille, on le pille :
Quelquefois, cependant, c\'est ce petit marmot
Qui fera le bonheur de toute la famille. </poesie>', '', '2007-05-22 21:46:59', 'publie', '26', '2011-04-28 21:07:51', 'oui', '0000-00-00 00:00:00', '2233', '0', '0.0121213312073407', 'non', '2011-04-28 21:07:38', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('17', '', 'La Barbe Bleue, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition.} }}} 

Il était une fois un homme qui avait de belles maisons à la ville et à la campagne, de la vaisselle d\'or et d\'argent, des meubles en broderies et des carrosses tout dorés. Mais, par malheur, cet homme avait la barbe bleue : cela le rendait si laid et si terrible, qu\'il n\'était ni femme ni fille qui ne s\'enfuît de devant lui.

Une de ses voisines, dame de qualité, avait deux filles parfaitement belles. Il lui en demanda une en mariage, et lui laissa le choix de celle qu\'elle voudrait lui donner. Elles n\'en voulaient point toutes deux, et se le renvoyaient l\'une à l\'autre, ne pouvant se résoudre à prendre un homme qui eût la barbe bleue. Ce qui les dégoûtait encore, c\'est qu\'il avait déjà épousé plusieurs femmes, et qu\'on ne savait ce que ces femmes étaient devenues.

La Barbe bleue, pour faire connaissance, les mena, avec leur mère et trois ou quatre de leurs meilleures amies et quelques jeunes gens du voisinage, à une de ses maisons de campagne, où on demeura huit jours entiers. Ce n\'étaient que promenades, que parties de chasse et de pêche, que danses et festins, que collations : on ne dormait point et on passait toute la nuit à se faire des malices les uns aux autres ; enfin tout alla si bien que la cadette commença à trouver que le maître du logis n\'avait plus la barbe si bleue, et que c\'était un fort honnête homme.

Dès qu\'on fut de retour à la ville, le mariage se conclut. Au bout d\'un mois, la Barbe bleue dit à sa femme qu\'il était obligé de faire un voyage en province, de six semaines au moins, pour une affaire de conséquence; qu\'il la priait de se bien divertir pendant son absence ; qu\'elle fit venir ses bonnes amies ; qu\'elle les menât à la campagne, si elle voulait ; que partout elle fît bonne chère.

\"Voilà, dit-il, les clefs des deux grands garde-meubles ; voilà celles de la vaisselle d\'or et d\'argent, qui ne sert pas tous les jours ; voilà celles de mes coffres-forts où est mon or et mon argent ; celles des cassettes où sont mes pierreries, et voilà le passe-partout de tous les appartements. Pour cette petite clef-ci, c\'est la clef du cabinet au bout de la grande galerie de l\'appartement bas : ouvrez tout, allez partout ; mais, pour ce petit cabinet, je vous défends d\'y entrer, et je vous le défends de telle sorte que s\'il vous arrive de l\'ouvrir, il n\'y a rien que vous ne deviez attendre de ma colère.\"

Elle promit d\'observer exactement tout ce qui lui venait d\'être ordonné, et lui, après l\'avoir embrassée, il monte dans son carrosse, et part pour son voyage. Les voisines et les bonnes amies n\'attendirent pas qu\'on les envoyât quérir pour aller chez la jeune mariée, tant elles avaient d\'impatience de voir toutes les richesses de sa maison, n\'ayant osé y venir pendant que le mari y était, à cause de sa barbe bleue, qui leur faisait peur.

Les voilà aussitôt à parcourir les chambres, les cabinets, les garde-robes, toutes plus belles et plus riches les unes que les autres. Elles montèrent ensuite aux garde-meubles, où elles ne pouvaient assez admirer le nombre et la beauté des tapisseries, des lits, des sofas, des cabinets, des guéridons, des tables et des miroirs où l\'on se voyait depuis les pieds jusqu\'à la tête, et dont les bordures, les unes de glace, les autres d\'argent et de vermeil doré, étaient les plus belles et les plus magnifiques qu\'on eût jamais vues. Elles ne cessaient d\'exagérer et d\'envier le bonheur de leur amie, qui cependant, ne se divertissait point à voir toutes ces richesses, à cause de l\'impatience qu\'elle avait d\'aller ouvrir le cabinet de l\'appartement bas.

Elle fut si pressée de sa curiosité, que sans considérer qu\'il était malhonnête de quitter sa compagnie, elle y descendit par un petit escalier dérobé, et avec tant de précipitation qu\'elle pensa se rompre le cou deux ou trois fois.

Etant arrivée à la porte du cabinet, elle s\'y arrêta quelque temps, songeant à la défense que son mari lui avait faite, et considérant qu\'il pourrait lui arriver malheur d\'avoir été désobéissante ; mais la tentation était si forte qu\'elle ne put la surmonter : elle prit donc la petite clef, et ouvrit en tremblant la porte du cabinet.

D\'abord elle ne vit rien, parce que les fenêtres étaient fermées. Après quelques moments, elle commença à voir que le plancher était tout couvert de sang caillé, et que dans ce sang, se miraient les corps de plusieurs femmes mortes et attachées le long des murs : c\'était toutes les femmes que la Barbe bleue avait épousées, et qu\'il avait égorgées l\'une après l\'autre.

Elle pensa mourir de peur, et la clef du cabinet, qu\'elle venait de retirer de la serrure, lui tomba de la main. Après avoir un peu repris ses sens, elle ramassa la clef, referma la porte, et monta à sa chambre pour se remettre un peu ; mais elle n\'en pouvait venir à bout, tant elle était émue. Ayant remarqué que la clef du cabinet était tachée de sang, elle l\'essuya deux ou trois fois ; mais le sang ne s\'en allait point : elle eut beau la laver, et même la frotter avec du sablon et avec du grès, il demeura toujours du sang, car la clef était fée, et il n\'y avait pas moyen de la nettoyer tout à fait : quand on ôtait le sang d\'un côté, il revenait de l\'autre.

La Barbe bleue revint de son voyage dès le soir-même, et dit qu\'il avait reçu des lettres, dans le chemin, qui lui avaient appris que l\'affaire pour laquelle il était parti venait d\'être terminée à son avantage. Sa femme fit tout ce qu\'elle put pour lui témoigner qu\'elle était ravie de son prompt retour.

Le lendemain, il lui redemanda les clefs ; et elle les lui donna, mais d\'une main si tremblante, qu\'il devina sans peine tout ce qui s\'était passé.

\" D\'où vient, lui dit-il, que la clef du cabinet n\'est point avec les autres ?

- Il faut, dit-elle, que je l\'aie laissée là-haut sur ma table.

- Ne manquez pas, dit la Barbe bleue, de me la donner tantôt.

Après plusieurs remises, il fallut apporter la clef. La Barbe bleue, l\'ayant considérée, dit à sa femme :

\" Pourquoi y a-t-il du sang sur cette clef ?

- Je n\'en sais rien, répondit la pauvre femme, plus pâle que la mort.

- Vous n\'en savez rien ! reprit la Barbe bleue ; je le sais bien, moi. Vous avez voulu entrer dans le cabinet ! Eh bien, madame, vous y entrerez et irez prendre votre place auprès des dames que vous y avez vues. \"

Elle se jeta aux pieds de son mari en pleurant, et en lui demandant pardon, avec toutes les marques d\'un vrai repentir, de n\'avoir pas été obéissante. Elle aurait attendri un rocher, belle et affligée comme elle était mais la Barbe bleue avait le coeur plus dur qu\'un rocher.

\" Il faut mourir, madame, lui dit-il, et tout à l\'heure.

- Puisqu\'il faut mourir, répondit-elle en le regardant les yeux baignés de larmes, donnez-moi un peu de temps pour prier Dieu.

- Je vous donne un demi-quart d\'heure, reprit la Barbe bleue ; mais pas un moment davantage. \"

Lorsqu\'elle fut seule, elle appela sa soeur, et lui dit

\" Ma soeur Anne, car elle s\'appelait ainsi, monte, je te prie, sur le haut de la tour pour voir si mes frères ne viennent point : ils m\'ont promis qu\'ils me viendraient voir aujourd\'hui ; et si tu les vois, fais-leur signe de se hâter. \"

La soeur Anne monta sur le haut de la tour ; et la pauvre affligée lui criait de temps en temps :

\" Anne, ma soeur Anne, ne vois-tu rien venir ? \"

Et la soeur Anne, lui répondait :

\" Je ne vois rien que le soleil qui poudroie, et l\'herbe qui verdoie. \"

Cependant, la Barbe bleue, tenant un grand coutelas à sa main, criait de toute sa force à sa femme :

\" Descends vite ou je monterai là-haut.\"

\"Encore un moment, s\'il vous plaît \", lui répondait sa femme.

Et aussitôt elle criait tout bas :

\"Anne, ma soeur Anne, ne vois-tu rien venir ? \"

Et la soeur Anne répondait : \" Je ne vois rien que le soleil qui poudroie, et l\'herbe qui verdoie. \"

- Descends donc vite, criait la Barbe bleue, ou je monterai là-haut.

- \"Je m\'en vais \", répondait la femme et puis elle criait :

\" Anne, ma soeur Anne, ne vois-tu rien venir ?

- Je vois, répondit la soeur Anne, une grosse poussière qui vient de ce côté-ci ...

- Sont-ce mes frères ?

- Hélas ! non, ma soeur : c\'est un troupeau de moutons ...

- Ne veux-tu pas descendre ? criait la Barbe bleue.

- Encore un moment \", répondait sa femme, et puis elle criait :

\" Anne, ma soeur Anne, ne vois-tu rien venir ?

- Je vois, répondit-elle, deux cavaliers qui viennent de ce côté, mais ils sont bien loin encore.

- Dieu soit loué ! s\'écria-t-elle un moment après, ce sont mes frères. je leur fais signe tant que je puis de se hâter. \"

La Barbe bleue se mit à crier si fort que toute la maison en trembla. La pauvre femme descendit, et alla se jeter à ses pieds tout épleurée et tout échevelée.

\" Cela ne sert à rien, dit la Barbe bleue ; il faut mourir. \"

Puis, la prenant d\'une main par les cheveux, et de l\'autre, levant le coutelas en l\'air, il allait lui abattre la tête. La pauvre femme, se tournant vers lui, et le regardant avec des yeux mourants, le pria de lui donner un petit moment pour se recueillir.

\" Non, non, dit-il, recommande-toi bien à Dieu \" et, levant son bras ...

Dans ce moment, on heurta si fort à la porte que la Barbe bleue s\'arrêta tout court. On l\'ouvrit, et aussitôt on vit entrer deux cavaliers, qui mettant l\'épée à la main, coururent droit à la Barbe bleue.

Il reconnut que c\'étaient les frères de sa femme, l\'un dragon et l\'autre mousquetaire, de sorte qu\'il s\'enfuit aussitôt pour se sauver ; mais les deux frères le poursuivirent de si près qu\'ils l\'attrapèrent avant qu\'il pût gagner le perron. Ils lui passèrent leur épée au travers du corps, et le laissèrent mort. La pauvre femme était presque aussi morte que son mari, et n\'avait pas la force de se lever pour embrasser ses frères.

Il se trouva que la Barbe bleue n\'avait point d\'héritiers, et qu\'ainsi sa femme demeura maîtresse de tous ses biens. Elle en employa une partie à marier sa soeur Anne avec un jeune gentilhomme dont elle était aimée depuis longtemps ; une autre partie à acheter des charges de capitaines à ses deux frères, et le reste à se marier elle-même à un fort honnête homme, qui lui fit oublier le mauvais temps qu\'elle avait passé avec la Barbe bleue.

<poesie>MORALITE

La curiosité, malgré tous ses attraits,
Coûte souvent bien des regrets ;
On en voit, tous les jours, mille exemples paraître.
C\'est, n\'en déplaise au sexe, un plaisir bien léger ;
Dès qu\'on le prend, il cesse d\'être.
Et toujours il coûte trop cher.

AUTRE MORALITE

Pour peu qu\'on ait l\'esprit sensé
Et que du monde on sache le grimoire,
On voit bientôt que cette histoire
Est un conte du temps passé.
Il n\'est plus d\'époux si terrible,
Ni qui demande l\'impossible,
Fût-il malcontent et jaloux.
Près de sa femme on le voit filer doux ;
Et, de quelque couleur que sa barbe puisse être,
On a peine à juger qui des deux est le maître. </poesie>', '', '2007-05-22 21:54:33', 'publie', '26', '2011-04-28 21:06:08', 'oui', '0000-00-00 00:00:00', '1238', '0', '0.879949424083886', 'non', '2007-05-22 21:54:13', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('18', '', 'Griselidis, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition.} }}}  	



<poesie>Au pied des célèbres montagnes
Où le Pô s\'échappant de dessous ses roseaux,
Va dans le sein des prochaines campagnes
Promener ses naissantes eaux,
vivait un jeune et vaillant Prince,
Les délices de sa Province:
Le ciel, en le formant, sur lui tout à la fois
Versa ce qu\'il a de plus rare,
Ce qu\'entre ses amis d\'ordinaire il sépare,
Et qu\'il ne donne qu\'aux grands Rois.

Comblé de tous les dons et du corps et de l\'âme,
Il fut robuste, adroit, propre au métier de Mars,
Et par l\'instinct secret d\'une divine flamme,
Avec ardeur il aima les beaux Arts.
Il aima les combats, il aima la victoire,
Les grands projets, les actes valeureux,
Et tout ce qui fait vivre un beau nom dans l\'histoire;
Mais son coeur tendre et généreux
Fut encor plus sensible à la solide gloire
De rendre ses Peuples heureux.

Ce tempérament héroïque
Fut obscurci d\'une sombre vapeur
Qui, chagrine et mélancolique,
Lui faisait voir dans le fond de son coeur
Tout le beau sexe infidèle et trompeur:

Dans la femme où brillait le plus rare mérite,
Il voyait une âme hypocrite,
Un esprit d\'orgueil enivré,
Un cruel ennemi qui sans cesse n\'aspire
Qu\'à prendre un souverain empire
Sur l\'homme malheureux qui lui sera livré.


Le fréquent usage du monde,
Où l\'on ne voit qu\'Époux subjugués ou trahis,
Joint à l\'air jaloux du Pays,
Accrut encor cette haine profonde.
Il jura donc plus d\'une fois
Que quand même le Ciel pour lui plein de tendresse
Formerait une autre Lucrèce,
Jamais de l\'hyménée il ne suivrait les lois.

Ainsi, quand le matin, qu\'il donnait aux affaires,
Il avait réglé sagement
Toutes les choses nécessaires
Au bonheur du gouvernement,
Que du faible orphelin, de la veuve oppressée,
Il avait conservé les droits,
Ou banni quelque impôt qu\'une guerre forcée
Avait introduit autrefois,
L\'autre moitié de la journée
À la chasse était destinée,
Où les Sangliers et les Ours,
Malgré leur fureur et leurs armes
Lui donnaient encor moins d\'alarmes
Que le sexe charmant qu\'il évitait toujours.

Cependant ses sujets que leur intérêt presse
De s\'assurer d\'un successeur
Qui les gouverne un jour avec même douceur,
À leur donner un fils le conviaient sans cesse.
Un jour dans le Palais ils vinrent tous en corps
Pour faire leurs derniers efforts;
Un Orateur d\'une grave apparence,
Et le meilleur qui fût alors,
Dit tout ce qu\'on peut dire en pareille occurrence.
Il marqua leur désir pressant
De voir sortir du Prince une heureuse lignée
Qui rendît à jamais leur État florissant;
Il lui dit même en finissant
Qu\'il voyait un Astre naissant
Issu de son chaste hyménée
Qui faisait pâlir le Croissant.

D\'un ton plus simple et d\'une voix moins forte,
Le Prince à ses sujets répondit de la sorte:

Le zèle ardent, dont je vois qu\'en ce jour
Vous me portez aux noeuds du mariage,
Me fait plaisir et m\'est de votre amour
Un agréable témoignage;
J\'en suis sensiblement touché,
Et voudrais dès demain pouvoir vous satisfaire:
Mais à mon sens l\'hymen est une affaire
Où plus l\'homme est prudent, plus il est empêché.

Observez bien toutes les jeunes filles;
Tant qu\'elles sont au sein de leurs familles,
Ce n\'est que vertu, que bonté,
Que pudeur que sincérité,
Mais sitôt que le mariage
Au déguisement a mis fin
Et qu\'ayant fixé leur destin
Il n\'importe plus d\'être sage,
Elles quittent leur personnage,
Non sans avoir beaucoup pâti,
Et chacune dans son ménage
Selon son gré prend son parti.

L\'une d\'humeur chagrine, et que rien ne récrée,
Devient une Dévote outrée,
Qui crie et gronde à tous moments;
L\'autre se façonne en Coquette
Qui sans cesse écoute ou caquette,
Et n\'a jamais assez d\'Amants;
Celle-ci des beaux Arts follement curieuse,
De tout décide avec hauteur
Et critiquant le plus habile Auteur
Prend la forme de Précieuse;
Cette autre s\'érige en Joueuse,
Perd tout, argent, bijoux, bagues, meubles de prix,
Et même jusqu\'à ses habits.

Dans la diversité des routes qu\'elles tiennent,
Il n\'est qu\'une chose où je vois
Qu\'enfin toutes elles conviennent,
C\'est de vouloir donner la loi.
Or je suis convaincu que dans le mariage
On ne peut jamais vivre heureux,
Quand on y commande tous deux;
Si donc vous souhaitez qu\'à l\'hymen je m\'engage,
Cherchez une jeune beauté
Sans orgueil et sans vanité,
D\'une obéissance achevée,
D\'une patience éprouvée,
Et qui n\'ait point de volonté,
Je la prendrai quand vous l\'aurez trouvée.
Le Prince ayant mis fin à ce discours moral,
Monte brusquement à cheval,
Et court joindre à perte d\'haleine
Sa meute qui l\'attend au milieu de la plaine.

Après avoir passé des prés et des guérets,
Il trouve ses Chasseurs couchés sur l\'herbe verte;
Tous se lèvent et tous alertes
Font trembler de leurs cors les hôtes des forêts.
Des chiens courants l\'aboyante famille,
Deçà, delà, parmi le chaume brille,
Et les limiers à l\'oeil ardent
Qui du fort de la Bête à leur poste reviennent,
Entraînent en les regardant
Les forts valets qui les retiennent.

S\'étant instruit par un des siens
Si tout est prêt, si l\'on est sur la trace,
Il ordonne aussitôt qu\'on commence la chasse,
Et fait donner le Cerf aux chiens.
Le son des cors qui retentissent,
Le bruit des chevaux qui hennissent
Et des chiens animés les pénétrants abois,
Remplissent la forêt de tumulte et de trouble,
Et pendant que l\'écho sans cesse les redouble,
S\'enfoncent avec eux dans les plus creux du bois.

Le Prince, par hasard ou par sa destinée,
Prit une route détournée
Où nul des Chasseurs ne le suit;
Plus il court, plus il s\'en sépare:
Enfin à tel point il s\'égare
Que des chiens et des cors il n\'entend plus le bruit.

L\'endroit où le mena sa bizarre aventure,
Clair de ruisseaux et sombre de verdure,
Saisissait les esprits d\'une secrète horreur;
La simple et naïve Nature
S\'y faisait voir et si belle et si pure,
Que mille fois il bénit son erreur

Rempli des douces rêveries
Qu\'inspirent les grands bois, les eaux et les prairies,
Il sent soudain frapper et son coeur et ses yeux
Par l\'objet le plus agréable,
Le plus doux et le plus aimable
Qu\'il eût jamais vu sous les Cieux.

C\'était une jeune Bergère
Qui filait aux bords d\'un ruisseau,
Et qui conduisant son troupeau,
D\'une main sage et ménagère
Tournait son agile fuseau.

Elle aurait pu dompter les coeurs les plus sauvages;
Des lys, son teint a la blancheur
Et sa naturelle fraîcheur
S\'était toujours sauvée à l\'ombre des bocages:
Sa bouche, de l\'enfance avait tout l\'agrément,
Et ses yeux qu\'adoucit une brune paupière,
Plus bleus que n\'est le firmament,
Avaient aussi plus de lumière.

Le Prince, avec transport, dans le bois se glissant,
Contemple les beautés dont son âme est émue,
Mais le bruit qu\'il fait en passant
De la Belle sur lui fit détourner la vue;
Dès qu\'elle se vit aperçue,
D\'un brillant incarnat la prompte et vive ardeur
De son beau teint redoubla la splendeur,
Et sur son visage épandue,
Y fit triompher la pudeur.

Sous le voile innocent de cette honte aimable,
Le Prince découvrit une simplicité,
Une douceur, une sincérité,
Dont il croyait le beau sexe incapable,
Et qu\'il voit là dans toute leur beauté.

Saisi d\'une frayeur pour lui toute nouvelle,
Il s\'approche interdit, et plus timide qu\'elle,
Lui dit d\'une tremblante voix,
Que de tous ses veneurs il a perdu la trace,
Et lui demande si la chasse
N\'a point passé quelque part dans le bois.

Rien na paru, Seigneur dans cette solitude,
Dit-elle, et nul ici que vous seul n\'est venu;
Mais n\'ayez point d\'inquiétude,
Je remettrai vos pas sur un chemin connu.

De mon heureuse destinée
Je ne puis, lui dit-il, trop rendre grâce aux Dieux;
Depuis longtemps je fréquente ces lieux,
Mais j\'avais ignoré jusqu\'à cette journée
Ce qu\'ils ont de plus précieux.

Dans ce temps elle voit que le Prince se baisse
Sur le moite bord du ruisseau,
Pour étancher dans le cours de son eau
La soif ardente qui le presse.
Seigneur, attendez un moment,
Dit-elle, et courant promptement
Vers sa cabane, elle y prend une tasse
Qu\'avec joie et de bonne grâce,
Elle présente à ce nouvel Amant.

Les vases précieux de cristal et d\'agate
Où l\'or en mille endroits éclate,
Et qu\'un Art curieux avec soin façonna,
N\'eurent jamais pour lui, dans leur pompe inutile,
Tant de beauté que le vase d\'argile
Que la Bergère lui donna.

Cependant pour trouver une route facile
Qui mène le Prince à la Ville,
Ils traversent des bois, des rochers escarpés
Et de torrents entrecoupés;
Le Prince n\'entre point dans de route nouvelle
Sans en bien observer tous les lieux d\'alentour
Et son ingénieux Amour
Qui songeait au retour
En fit une carte fidèle.

Dans un bocage sombre et frais
Enfin la Bergère le mène,
Où de dessous ses branchages épais
Il voit au loin dans le sein de la plaine
Les toits dorés de son riche Palais.

S\'étant séparé de la Belle,
Touché d\'une vive douleur,
À pas lents il s\'éloigne d\'Elle,
Chargé du trait qui lui perce le coeur;
Le souvenir de sa tendre aventure
Avec plaisir le conduisit chez lui.
Mais dès le lendemain il sentit sa blessure,
Et se vit accablé de tristesse et d\'ennui.

Dès qu\'il le peut il retourne à la chasse,
Où de sa suite adroitement
Il s\'échappe et se débarrasse
Pour s\'égarer heureusement.
Des arbres et des monts les cimes élevées,
Qu\'avec grand soin il avait observées,
Et les avis secrets de son fidèle Amour,
Le guidèrent si bien que malgré les traverses
De cent routes diverses,
De sa jeune Bergère il trouva le séjour.

Il sut qu\'elle n\'a plus que son Père avec elle,
Que Griselidis on l\'appelle,
Qu\'ils vivent doucement du lait de leurs brebis,
Et que de leur toison qu\'elle seule elle file,
Sans avoir recours à la ville,
Ils font eux-mêmes leurs habits.

Plus il la voit, plus il s\'enflamme
Des vives beautés de son âme
Il connaît en voyant tant de dons précieux,
Que si la Bergère est si belle,
C\'est qu\'une légère étincelle
De l\'esprit qui l\'anime a passé dans ses yeux.

Il ressent une joie extrême
D\'avoir si bien placé ses premières amours;
Ainsi sans plus tarder il fit dès le jour même
Assembler son Conseil et lui tint ce discours:

Enfin aux Lois de l\'Hyménée
Suivant vos voeux je me vais engager;
Je ne prends point ma femme en Pays étranger,
Je la prends parmi vous, belle, sage, bien née,
Ainsi que mes aïeux ont fait plus d\'une fois.

Mais j\'attendrai cette grande journée
A vous informer de mon choix.
Dès que la nouvelle fut sue,
Partout elle fut répandue.
On ne peut dire avec combien d\'ardeur
L\'allégresse publique
De tous côtés s\'explique;
Le plus content fut l\'Orateur,
Qui par son discours pathétique
Croyait d\'un si grand bien être l\'unique Auteur
Qu\'il se trouvait homme de conséquence!
Rien ne peut résister à la grande éloquence,
Disait-il sans cesse en son coeur

Le plaisir fut de voir le travail inutile
Des Belles de toute la Ville
Pour s\'attirer et mériter le choix
Du Prince leur Seigneur qu\'un air chaste et modeste
Charmait uniquement et plus que tout le reste,
Ainsi qu\'il l\'avait dit cent fois.

D\'habit et de maintien toutes elles changèrent,
D\'un ton dévot elles toussèrent,
Elles radoucirent leurs voix,
De demi-pied les coiffures baissèrent,
La gorge se couvrit, les manches s\'allongèrent,
À peine on leur voyait le petit bout des doigts.

Dans la Ville avec diligence,
Pour l\'Hymen dont le jour s\'avance,
On voit travailler tous les Arts:
Ici se font de magnifiques chars
D\'une forme toute nouvelle,
Si beaux et si bien inventés,
Que l\'or qui partout étincelle
En fait la moindre des beautés.
Là pour voir aisément et sans aucun obstacle
Toute la pompe du spectacle,
On dresse de longs échafauds,
Ici de grands Arcs triomphaux
Où du Prince guerrier se célèbre la gloire,
Et de l\'Amour sur lui l\'éclatante victoire.

Là, sont forgés d\'un art industrieux,
Ces feux qui par les coups d\'un innocent tonnerre,
En effrayant la Terre,
De mille astres nouveaux embellissent les Cieux.
Là d\'un ballet ingénieux
Se concerte avec soin l\'agréable folie,
Et là d\'un Opéra peuplé de mille Dieux,
Le plus beau que jamais ait produit l\'Italie,
On entend répéter les airs mélodieux.

Enfin, du fameux Hyménée,
Arriva la grande journée.

Sur le fond d\'un Ciel vif et pur
À peine l\'Aurore vermeille
Confondait l\'or avec l\'azur,
Que partout en sursaut le beau sexe s\'éveille;
Le Peuple curieux s\'épand de tous côtés,
En différents endroits des Gardes sont postés
Pour contenir la Populace,
Et la contraindre à faire place.
Tout le Palais retentit de clairons,
De flûtes, de hautbois, de rustiques musettes,
Et l\'on n\'entend aux environs
Que des tambours et des trompettes.

Enfin le Prince sort entouré de sa Cour
Il s\'élève un long cri de joie,
Mais on est bien surpris quand au premier détour,
De la Forêt prochaine on voit qu\'il prend la voie,
Ainsi qu\'il faisait chaque jour.
Voilà, dit-on, son penchant qui l\'emporte,
Et de ses passions, en dépit de l\'Amour,
La Chasse est toujours la plus forte.

Il traverse rapidement
Les guérets de la plaine et gagnant la montagne,
Il entre dans le bois au grand étonnement
De la Troupe qui l\'accompagne.

Après avoir passé par différents détours,
Que son coeur amoureux se plaît à reconnaître,
Il trouve enfin la cabane champêtre,
Où logent ses tendres amours.

Griselidis de l\'Hymen informée,
Par la voix de la Renommée,
En avait pris son bel habillement;
Et pour en aller voir la pompe magnifique,
De dessous sa case rustique
Sortait en ce même moment.

Où courez-vous si prompte et si légère?
Lui dit le Prince en l\'abordant
Et tendrement la regardant;
Cessez de vous hâter trop aimable Bergère:
La noce où vous allez, et dont je suis l\'Epoux,
Ne saurait se faire sans vous.

Oui, je vous aime, et je vous ai choisie
Entre mille jeunes beautés,
Pour passer avec vous le reste de ma vie,
Si toutefois mes voeux ne sont pas rejetés.
Ah! dit-elle, Seigneur je n\'ai garde de croire
Que je sois destinée à ce comble de gloire;
Vous cherchez à vous divertir.
Non, non, dit-il, je suis sincère,
J\'ai déjà pour moi votre Père
(Le Prince avait eu soin de l\'en faire avertir).
Daignez, Bergère, y consentir,
C\'est là tout ce qui reste à faire.
Mais afin qu\'entre nous une solide paix
Éternellement se maintienne,
Il faudrait me jurer que vous n\'aurez jamais
D\'autre volonté que la mienne.

Je le jure, dit-elle, et je vous le promets;
Si j\'avais épousé le moindre du Village,
J\'obéirais, son joug me serait doux;
Hélas! combien donc davantage,
Si je viens à trouver en vous
Et mon Seigneur et mon Epoux.

Ainsi le Prince se déclare,
Et pendant que la Cour applaudit à son choix,
Il porte la Bergère à souffrir qu\'on la pare
Des ornements qu\'on donne aux Épouses des Rois.
Celles qu\'à cet emploi leur devoir intéresse
Entrent dans la cabane, et là diligemment
Mettent tout leur savoir et toute leur adresse
À donner de la grâce à chaque ajustement.

Dans cette Hutte où l\'on se presse
Les Dames admirent sans cesse
Avec quel art la Pauvreté
S\'y cache sous la Propreté;
Et cette rustique Cabane,

Que couvre et rafraîchit un spacieux Platane,
Leur semble un séjour enchanté.

Enfin, de ce Réduit sort pompeuse et brillante
La Bergère charmante;
Ce ne sont qu\'applaudissements
Sur sa beauté, sur ses habillements;
Mais sous cette pompe étrangère
Déjà plus d\'une fois le Prince a regretté
Des ornements de la Bergère
L\'innocente simplicité.

Sur un grand char d\'or et d\'ivoire,
La Bergère s\'assied pleine de majesté;
Le Prince y monte avec fierté,
Et ne trouve pas moins de gloire
À se voir comme Amant assis à son côté
Qu\'à marcher en triomphe après une victoire;
La Cour les suit et tous gardent leur rang
Que leur donne leur charge ou l\'éclat de leur sang.
La ville dans les champs presque toute sortie
Couvrait les plaines d\'alentour
Et du choix du Prince avertie,
Avec impatience attendait son retour.
Il paraît, on le joint. Parmi l\'épaisse foule
Du Peuple qui se fend le char à peine roule;
Par les longs cris de joie à tout coup redoublés
Les chevaux émus et troublés
Se cabrent, trépignent, s\'élancent,
Et reculent plus qu\'ils n\'avancent.

Dans le Temple on arrive enfin,
Et là par la chaîne éternelle
D\'une promesse solennelle,
Les deux Époux unissent leur destin;
Ensuite au Palais ils se rendent,
Où mille plaisirs les attendent,
Où la Danse, les Jeux, les Courses, les Tournois,

Répandent l\'allégresse en différents endroits;
Sur le soir le blond Hyménée
De ses chastes douceurs couronna la journée.

Le lendemain, les différents États
De toute la Province
Accourent haranguer la Princesse et le Prince
Par la voix de leurs Magistrats.

De ses Dames environnée,
Griselidis, sans paraître étonnée,
En Princesse les entendit,
En Princesse leur répondit.
Elle fit toute chose avec tant de prudence,
Qu\'il sembla que le Ciel eût versé ses trésors
Avec encor plus d\'abondance
Sur son âme que sur son corps.
Par son esprit, par ses vives lumières,
Du grand monde aussitôt elle prit les manières,
Et même dès le premier jour.
Des talents, de l\'humeur des Dames de sa Cour,
Elle se fit si bien instruire,
Que son bon sens jamais embarrassé
Eut moins de peine à les conduire
Que ses brebis du temps passé.

Avant la fin de l\'an, des fruits de l\'Hyménée
Le Ciel bénit leur couche fortunée;
Ce ne fut pas un Prince, on l\'eût bien souhaité;
Mais la jeune Princesse avait tant de beauté
Que l\'on ne songea plus qu\'à conserver sa vie;
Le Père qui lui trouve un air doux et charmant
La venait voir de moment en moment,
Et la Mère encor plus ravie
La regardait incessamment.

Elle voulut la nourrir elle-même:
Ah! dit-elle, comment m\'exempter de l\'emploi

Que ses cris demandent de moi
Sans une ingratitude extrême?
Par un motif de Nature ennemi
Pourrais-je bien vouloir de mon Enfant que j\'aime
N\'être la Mère qu\'à demi?

Soit que le Prince eût l\'âme un peu mois enflammée
Qu\'aux premiers jours de son ardeur,
Soit que de sa maligne humeur
La masse se fût rallumée,
Et de son épaisse fumée
Eût obscurci ses sens et corrompu son coeur
Dans tout ce que fait la Princesse,
Il s\'imagine voir peu de sincérité.
Sa trop grande vertu le blesse,
C\'est un piège qu\'on tend à sa crédulité;
Son esprit inquiet et de trouble agité
Croit tous les soupçons qu\'il écoute,
Et prend plaisir à révoquer en doute
L\'excès de sa félicité.

Pour guérir les chagrins dont son âme est atteinte,
Il la suit, il l\'observe, il aime à la troubler
Par les ennuis de la contrainte,
Par les alarmes de la crainte,
Par tout ce qui peut démêler
La vérité d\'avec la feinte.
C\'est trop, dit-il, me laisser endormir;
Si ses vertus sont véritables,
Les traitements les plus insupportables
Ne feront que les affermir.

Dans son Palais il la tient resserrée,
Loin de tous les plaisirs qui naissent à la Cour
Et dans sa chambre, où seule elle vit retirée,
À peine il laisse entrer le jour
Persuadé que la Parure
Et le superbe Ajustement

Du sexe que pour plaire a formé la Nature
Est le plus doux enchantement
Il lui demande avec rudesse
Les perles, les rubis, les bagues, les bijoux
Qu\'il lui donna pour marque de tendresse,
Lorsque de son Amant il devint son Époux.

Elle dont la vie est sans tache,
Et qui n\'a jamais eu d\'attache
Qu\'à s\'acquitter de son devoir,
Les lui donne sans s\'émouvoir
Et même, le voyant se plaire à les reprendre,
N\'a pas moins de joie à les rendre
Qu\'elle en eut à les recevoir

Pour m\'éprouver mon Époux me tourmente,
Dit-elle, et je vois bien qu\'il ne me fait souffrir
Qu\'afin de réveiller ma vertu languissante,
Qu\'un doux et long repos pourrait faire périr.
S\'il n\'a pas ce dessein, du moins suis-je assurée
Que telle est du Seigneur la conduite sur moi
Et que de tant de maux l\'ennuyeuse durée
N\'est que pour exercer ma constance et ma foi.

Pendant que tant de malheureuses
Errent au gré de leurs désirs
Par mille routes dangereuses,
Après de faux et vains plaisirs;
Pendant que le Seigneur dans sa lente justice
Les laisse aller aux bords du précipice
Sans prendre part à leur danger,
Par un pur mouvement de sa bonté suprême,
Il me choisit comme un enfant qu\'il aime,
Et s\'applique à me corriger.

Aimons donc sa rigueur utilement cruelle,
On n\'est heureux qu\'autant qu\'on a souffert,
Aimons sa bonté paternelle
Et la main dont elle se sert.

Le Prince a beau la voir obéir sans contrainte
À tous ses ordres absolus:
Je vois le fondement de cette vertu feinte,
Dit-il, et ce qui rend tous mes coups superflus,
C\'est qu\'ils n\'ont porté leur atteinte
Qu\'à des endroits où son amour n\'est plus.

Dans son Enfant, dans la jeune Princesse,
Elle a mis toute sa tendresse;
À l\'éprouver si je veux réussir,
C\'est là qu\'il faut que je m\'adresse,
C\'est là que je puis m\'éclaircir

Elle venait de donner la mamelle
Au tendre objet de son amour ardent,
Qui couché sur son sein se jouait avec elle,
Et riait en la regardant:
Je vois que vous l\'aimez, lui dit-il, cependant
Il faut que je vous l\'ôte en cet âge encor tendre,
Pour lui former les moeurs et pour la préserver
De certains mauvais airs qu\'avec vous l\'on peut prendre;
Mon heureux sort m\'a fait trouver
Une Dame d\'esprit qui saura l\'élever
Dans toutes les vertus et dans la politesse
Que doit avoir une Princesse.
Disposez-vous à la quitter,
On va venir pour l\'emporter

Il la laisse à ces mots, n\'ayant pas le courage,
Ni les yeux assez inhumains,
Pour voir arracher de ses mains
De leur amour l\'unique gage;
Elle de mille pleurs se baigne le visage,
Et dans un morne accablement
Attend de son malheur le funeste moment.

Dès que d\'une action si triste et si cruelle
Le ministre odieux à ses yeux se montra,

Il faut obéir lui dit-elle;
Puis prenant son Enfant qu\'elle considéra,
Qu\'elle baisa d\'une ardeur maternelle,
Qui de ses petits bras tendrement la serra,
Toute en pleurs elle le livra.
Ah! que sa douleur fut amère!
Arracher l\'enfant ou le coeur
Du sein d\'une si tendre Mère,
C\'est la même douleur

Près de la Ville était un Monastère,
Fameux par son antiquité,
Où des Vierges vivaient dans une règle austère,
Sous les yeux d\'une Abbesse illustre en piété.
Ce fut là que dans le silence,
Et sans déclarer sa naissance,
On déposa l\'Enfant, et des bagues de prix,
Sous l\'espoir d\'une récompense
Digne des soins que l\'on en aurait pris.

Le Prince qui tâchait d\'éloigner par la chasse
Le vif remords qui l\'embarrasse
Sur l\'excès de sa cruauté,
Craignait de revoir la Princesse,
Comme on craint de revoir une fière Tigresse
À qui son faon vient d\'être ôté;
Cependant il en fut traité
Avec douceur avec caresse,
Et même avec cette tendresse
Qu\'elle eut aux plus beaux jours de sa prospérité.

Par cette complaisance et si grande et si prompte,
Il fut touché de regret et de honte;
Mais son chagrin demeura le plus fort:
Ainsi, deux jours après, avec des larmes feintes,
Pour lui porter encor de plus vives atteintes,
Il lui vint dire que la Mort
De leur aimable Enfant avait fini le sort.

Ce coup inopiné mortellement la blesse,
Cependant malgré sa tristesse,
Ayant vu son Époux qui changeait de couleur
Elle parut oublier son malheur
Et n\'avoir même de tendresse
Que pour le consoler de sa fausse douleur

Cette bonté, cette ardeur sans égale
D\'amitié conjugale,
Du Prince tout à coup désarmant la rigueur
Le touche, le pénètre et lui change le coeur
Jusque-là qu\'il lui prend envie
De déclarer que leur Enfant
Jouit encore de la vie;
Mais sa bile s\'élève et fière lui défend
De rien découvrir du mystère
Qu\'il peut être utile de taire.

Dès ce bienheureux jour telle des deux Époux
Fut la mutuelle tendresse,
Qu\'elle n\'est point plus vive aux moments les plus doux
Entre l\'Amant et la Maîtresse.

Quinze fois le Soleil, pour former les saisons,
Habita tour à tour dans ses douze maisons,
Sans rien voir qui les désunisse;
Que si quelquefois par caprice
Il prend plaisir à la fâcher
C\'est seulement pour empêcher
Que l\'amour ne se ralentisse,
Tel que le Forgeron qui pressant son labeur
Répand un peu d\'eau sur la braise
De sa languissante fournaise
Pour en redoubler la chaleur

Cependant la jeune Princesse
Croissait en esprit et en sagesse;
À la douceur à la naïveté

Qu\'elle tenait de son aimable Mère,
Elle joignit de son illustre Père
L\'agréable et noble fierté;
L\'amas de ce qui plaît dans chaque caractère
Fit une parfaite beauté.

Partout comme un Astre elle brille;
Et par hasard un Seigneur de la Cour
Jeune, bien fait et plus beau que le jour
L\'ayant vu paraître à la grille,
Conçut pour elle un violent amour
Par l\'instinct qu\'au beau sexe a donné la Nature,

Et que toutes les beautés ont
De voir l\'invisible blessure
Que font leurs yeux, au moment qu\'ils la font,
La Princesse fut informée
Qu\'elle était tendrement aimée.

Après avoir quelque temps résisté
Comme on le doit avant que de se rendre,
D\'un amour également tendre
Elle l\'aima de son côté.

Dans cet Amant, rien n\'était à reprendre,
Il était beau, vaillant, né d\'illustres aïeux
Et dès longtemps pour en faire son Gendre.
Sur lui le Prince avait jeté les yeux.
Ainsi donc avec joie il apprit la nouvelle
De l\'ardeur tendre et mutuelle
Dont brûlaient ces jeunes Amants;
Mais il lui prit une bizarre envie
De leur faire acheter par de cruels tourments
Le plus grand bonheur de leur vie.

Je me plairai, dit-il, à les rendre contents;
Mais il faut que l\'Inquiétude,
Par tout ce qu\'elle a de plus rude,

Rende encor leurs feux plus constants;
De mon Épouse en même temps
J\'exercerai la patience,
Non point, comme jusqu\'à ce jour,
Pour assurer ma folle défiance,
Je ne dois plus douter de son amour;
Mais pour faire éclater aux yeux de tout le Monde
Sa Bonté, sa Douceur sa Sagesse profonde,
Afin que de ces dons si grands, si précieux,
La Terre se voyant parée,
En soit de respect pénétrée,
Et par reconnaissance en rende grâce aux Cieux.

Il déclare en public que manquant de lignée,
En qui l\'État un jour retrouve son Seigneur,
Que la fille qu\'il eut de son fol hyménée
Étant morte aussitôt que née,
Il doit ailleurs chercher plus de bonheur;
Que l\'Épouse qu\'il prend est d\'illustre naissance,
Qu\'en un Couvent on l\'a jusqu\'à ce jour
Fait élever dans l\'innocence,
Et qu\'il va par l\'hymen couronner son amour.

On peut juger à quel point fut cruelle
Aux deux jeunes Amants cette affreuse nouvelle;
Ensuite, sans marquer ni chagrin, ni douleur,
Il avertit son Épouse fidèle
Qu\'il faut qu\'il se sépare d\'elle
Pour éviter un extrême malheur;
Que le Peuple indigné de sa basse naissance
Le force à prendre ailleurs une digne alliance.

Il faut, dit-il, vous retirer
Sous votre toit de chaume et de fougère
Après avoir repris vos habits de Bergère
Que je vous ai fait préparer

Avec une tranquille et muette constance,
La Princesse entendit prononcer sa sentence;
Sous les dehors d\'un visage serein
Elle dévorait son chagrin,
Et sans que la douleur diminuât ses charmes,
De ses beaux yeux tombaient de grosses larmes,
Ainsi que quelquefois au retour du Printemps,
Il fait Soleil et pleut en même temps.

Vous êtes mon Époux, mon Seigneur et mon Maître
(Dit-elle en soupirant, prête à s\'évanouir),
Et quelque affreux que soit ce que je viens d\'ouïr
Je saurai vous faire connaître
Que rien ne m\'est si cher que de vous obéir

Dans sa chambre aussitôt seule elle se retire,
Et là se dépouillant de ses riches habits,
Elle reprend paisible et sans rien dire,
Pendant que son coeur en soupire,
Ceux qu\'elle avait en gardant ses brebis.
En cet humble et simple équipage,
Elle aborde le Prince et lui tient ce langage:

Je ne puis m\'éloigner de vous
Sans le pardon d\'avoir su vous déplaire;
Je puis souffrir le poids de ma misère,
Mais je ne puis, Seigneur, souffrir votre courroux;
Accordez cette grâce à mon regret sincère,
Et je vivrai contente en mon triste séjour
Sans que jamais le Temps altère
Ni mon humble respect, ni mon fidèle amour.

Tant de soumission et tant de grandeur d\'âme
Sous un si vil habillement,
Qui dans le coeur du Prince en ce même moment
Réveilla tous les traits de sa première flamme,
Allaient casser l\'arrêt de son bannissement.
Ému par de si puissants charmes,

Et prêt à répandre des larmes,
Il commençait à s\'avancer
Pour l\'embrasser,
Quant tout à coup l\'impérieuse gloire
D\'être ferme en son sentiment
Sur son amour remporta la victoire,
Et le fit en ces mots répondre durement:

De tout le temps passé j\'ai perdu la mémoire,
Je suis content de votre repentir
Allez, il est temps de partir

Elle part aussitôt, et regardant son Père
Qu\'on avait revêtu de son rustique habit,
Et qui, le coeur percé d\'une douleur amère,
Pleurait un changement si prompt et si subit:
Retournons, lui dit-elle, en nos sombres bocages,
Retournons habiter nos demeures sauvages,
Et quittons sans regret la pompe des Palais;
Nos cabanes n\'ont pas tant de magnificence,
Mais on y trouve avec plus d\'innocence,
Un plus ferme repos, une plus douce paix.

Dans son désert à grand-peine arrivée,
Elle reprend et quenouille et fuseaux,
Et va filer au bord des mêmes eaux
Où le Prince l\'avait trouvée.
Là son coeur tranquille et sans fiel
Cent fois le jour demande au Ciel
Qu\'il comble son poux de gloire, de richesses,
Et qu\'à tous ses désirs il ne refuse rien;
Un amour nourri de caresses
N\'est pas plus ardent que le sien.

Ce cher Époux qu\'elle regrette
Voulant encore l\'éprouver
Lui fait dire dans sa retraite
Qu\'elle ait à venir le trouver.

Griselidis, dit-il, dès qu\'elle se présente,
Il faut que la Princesse à qui je dois demain
Dans le Temple donner la main,
De vous et de moi soit contente.
Je vous demande ici tous vos soins, et je veux
Que vous m\'aidiez à plaire à l\'objet de mes voeux;
Vous savez de quel air il faut que l\'on me serve,
Point d\'épargne, point de réserve;
Que tout sente le Prince, et le Prince amoureux.

Employez toute votre adresse
À parer son appartement,
Que l\'abondance, la richesse,
La propreté, la politesse
S\'y fassent voir également;
Enfin songez incessamment
Que c\'est une jeune Princesse
Que j\'aime tendrement.

Pour vous faire entrer davantage
Dans les soins de votre devoir,
Je veux ici vous faire voir
Celle qu\'à bien servir mon ordre vous engage.

Telle qu\'aux Portes du Levant
Se montre la naissante Aurore,
Telle parut en arrivant
La Princesse plus belle encore.
Griselidis à son abord
Dans le fond de son coeur sentit un doux transport
De la tendresse maternelle;
Du temps passé, de ses jours bienheureux,
Le souvenir en son coeur se rappelle.
Hélas! ma fille, en soi-même dit-elle,
Si le Ciel favorable eût écouté mes voeux,
Serait presque aussi grande, et peut-être aussi belle.

Pour la jeune Princesse en ce même moment
Elle prit un amour si vif, si véhément,
Qu\'aussitôt qu\'elle fut absente,
En cette sorte au Prince elle parla,
Suivant, sans le savoir, l\'instinct qui s\'en mêla:

Souffrez, Seigneur, que je vous représente
Que cette Princesse charmante,
Dont vous allez être l\'Époux,
Dans l\'aise, dans l\'éclat, dans la pourpre nourrie,
Ne pourra supporter sans en perdre la vie,
Les mêmes traitements que j\'ai reçus de vous.
Le besoin, ma naissance obscure,
M\'avaient endurcie aux travaux.
Et je pouvais souffrir toutes sortes de maux
Sans peine et même sans murmure;
Mais elle qui jamais n\'a connu la douleur
Elle mourra dès la moindre rigueur,
Dès la moindre parole un peu sèche, un peu dure.
Hélas! Seigneur je vous conjure
De la traiter avec douceur.

Songez, lui dit le Prince avec un ton sévère,
A me servir selon votre pouvoir;
Il ne faut pas qu\'une simple Bergère
Fasse des leçons, et s\'ingère
De m\'avertir de mon devoir
Griselidis, à ces mots, sans rien dire,
Baisse les yeux et se retire.

Cependant pour l\'Hymen les Seigneurs invités,
Arrivèrent de tous côtés;
Dans une magnifique salle
Où le Prince les assembla
Avant que d\'allumer la torche nuptiale,
En cette sorte il leur parla:

Rien au monde, après l\'Espérance,
N\'est plus trompeur que l\'Apparence;
Ici l\'on en peut voir un exemple éclatant.
Qui ne croirait que ma jeune Maîtresse,
Que l\'Hymen va rendre Princesse,
Ne soit heureuse et n\'ait le coeur content?
Il n\'en est rien pourtant.

Qui pourrait s\'empêcher de croire
Que ce jeune Guerrier amoureux de la gloire
N\'aime à voir cet Hymen, lui qui dans les Tournois
Va sur tous ses Rivaux remporter la victoire?
Cela n\'est pas vrai toutefois.

Qui ne croirait encor qu\'en sa juste colère,
Griselidis ne pleure et ne se désespère?
Elle ne se plaint point, elle consent à tout,
Et rien n\'à pu pousser sa patience à bout.

Qui ne croirait enfin que de ma destinée
Rien ne peut égaler la course fortunée,
En voyant les appas de l\'objet de mes voeux?
Cependant si l\'Hymen me liait de ses noeuds,
J\'en concevrais une douleur profonde,
Et de tous les Princes du Monde
Je serais le plus malheureux.

L\'Énigme vous paraît difficile à comprendre;
Deux mots vont vous la faire entendre,
Et ces deux mots feront évanouir
Tous les malheurs que vous venez d\'ouïr.

Sachez, poursuivit-il, que l\'aimable Personne
Que vous croyez m\'avoir blessé le coeur,
Est ma Fille, et que je la donne
Pour Femme à ce jeune Seigneur
Qui l\'aime d\'un amour extrême
Et dont il est aimé de même.

Sachez encor que touché vivement
De la patience et du zèle
De l\'Épouse sage et fidèle
Que j\'ai chassée indignement,
Je la reprends, afin que je répare,
Par tout ce que l\'amour peut avoir de plus doux,
Le traitement dur et barbare
Qu\'elle a reçu de mon esprit jaloux.

Plus grande sera mon étude
À prévenir tous ses désirs,
Qu\'elle ne fut dans mon inquiétude
À l\'accabler de déplaisirs;
Et si dans tous les temps doit vivre la mémoire
Des ennuis dont son coeur ne fut point abattu,
Je veux que plus encore on parle de la gloire
Dont j\'aurai couronné sa suprême vertu.

Comme quand un épais nuage
A le jour obscurci,
Et que le Ciel de toutes parts noirci,
Menace d\'un affreux orage;
Si de ce voile obscur par les vents écarté
Un brillant rayon de clarté
Se répand sur le paysage,
Tout rit et reprend sa beauté;
Telle, dans tous les yeux où régnait la tristesse,
Éclate tout à coup une vive allégresse.

Par ce prompt éclaircissement,
La jeune Princesse ravie
D\'apprendre que du Prince elle a reçu la vie
Se jette à ses genoux qu\'elle embrasse ardemment.
Son père qu\'attendrit une fille si chère,
La relève, la baise, et la mène à sa mère,
À qui trop de plaisir en un même moment
Était presque tout sentiment.
Son coeur, qui tant de fois en proie

Aux plus cuisants traits du malheur,
Supporta si bien la douleur,
Succombe au doux poids de la joie;
À peine de ses bras pouvait-elle serrer
L\'aimable Enfant que le ciel lui renvoie,
Elle ne pouvait que pleurer.

Assez dans d\'autres temps vous pourrez satisfaire,
Lui dit le Prince, aux tendresses du sang;
Reprenez les habits qu\'exige votre rang,
Nous avons des noces à faire.

Au Temple on conduisit les deux jeunes Amants,
Où la mutuelle promesse
De se chérir avec tendresse
Affermit pour jamais leurs doux engagements.
Ce ne sont que Plaisirs, que Tournois magnifiques,
Que Jeux, que Danses, que Musiques,
Et que Festins délicieux,
Où sur Griselidis se tournent tous les yeux,
Où sa patience éprouvée
Jusque au Ciel est élevée
Par mille éloges glorieux:
Des Peuples réjouis la complaisance est telle
Pour leur Prince capricieux,
Qu\'ils vont jusqu\'à louer son épreuve cruelle,
À qui d\'une vertu si belle,
Si séante au beau sexe, et si rare en tous lieux,
On doit un si parfait modèle.</poesie>', '', '2007-05-22 22:03:18', 'publie', '26', '2011-04-28 21:02:08', 'oui', '0000-00-00 00:00:00', '5413', '0', '0.00593452654043369', 'non', '2007-05-22 22:02:53', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('37', '', 'Création de l\'agenda', '', '74', '', '', '', '', '2007-09-26 23:32:15', 'publie', '74', '2010-08-14 22:30:37', 'oui', '2007-12-31 00:00:00', '150', '0', '1.63681349204735e-69', 'non', '2007-09-26 23:30:35', 'fr', 'oui', '0', '', '0', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('38', 'Pangnosis', 'Site de partage de documents pédagogiques', '', '83', '', '', 'Bonjour,

Constatant la difficulté grandissante des élèves à aborder des textes littéraires en raison de la pauvreté de leur vocabulaire, j\'ai créé ce site, afin d\'apporter cette modeste contribution à la remédiation de ce grave problème.

Il s\'agit donc d\'un site à caractère pédagogique, qui ne contient que les textes, libres de droits, des grands classiques de la littérature française ou francophone.

Sa particularité est de permettre au lecteur, et plus particulièrement aux élèves de lire des textes difficiles, comportant de nombreux mots inconnus, en pouvant, grâce à Alexandria, d\'un clic de souris, obtenir instantanément leur définition sans couper outre mesure le flux normal de la lecture. Pour les élèves étrangers, il permet en outre, d\'obtenir très rapidement la traduction dans leur langue des mots inconnus. 

Tout enseignant ou formateur est vivement invité à me faire part de ses remarques ou même à contribuer à l\'élaboration de ce site.

Bonne lecture.

Jean-Paul BOURILLON

Professeur au Lycée Jean Monnet de Bruxelles

Créateur et Webmestre de pangnosis.com

', 'Vous pouvez demander l\'intégration de textes littéraires libres de droits en remplissant le formulaire ci-dessous : 

<form1>', '2007-09-26 23:45:56', 'publie', '83', '2012-01-19 17:14:35', 'oui', '0000-00-00 00:00:00', '228', '0', '0.165380154896572', 'non', '2012-01-19 17:14:58', 'fr', 'oui', '0', '', '2', 'PANGNOSIS ', 'http://www.pangnosis.com/');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('8', '', 'Charles Perrault , Les contes, Cendrillon', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', 'Grâce à Alexandria, cliquez sur n\'importe quel mot du texte pour en avoir la définition.

 {{{ {[?Cendrillon]} de [?Charles Perrault]}}}


Il était une fois un gentilhomme qui épousa en secondes noces une femme, la plus hautaine et la plus fière qu\'on eût jamais vue. Elle avait deux filles de son humeur, et qui lui ressemblaient en toutes choses. Le mari avait de son côté une jeune fille, mais d\'une douceur et d\'une bonté sans exemple; elle tenait cela de sa mère, qui était la meilleure personne du monde.

 

Les noces ne furent pas plus tôt faites, que la belle--mère fit éclater sa mauvaise humeur; elle ne put souffrir les bonnes qualités de cette jeune enfant, qui rendaient ses filles encore plus haïssables. Elle la chargea des plus viles occupations de la maison : c\'était elle qui nettoyait la vaisselle et les montées, qui frottait la chambre de madame, et celles de mesdemoiselles ses filles. Elle couchait tout en haut de la maison, dans un grenier, sur une méchante paillasse, pendant que ses sœurs étaient dans des chambres parquetées, où elles avaient des lits des plus à la mode, et des miroirs où elles se voyaient depuis les pieds jusqu\'à la tête. La pauvre fille souffrait tout avec patience, et n\'osait s\'en plaindre à son père qui l\'aurait grondée, parce que sa femme le gouvernait entièrement.

 

Lorsqu\'elle avait fait son ouvrage, elle s\'en allait au coin de la cheminée, et s\'asseoir dans les cendres, ce qui faisait qu\'on l\'appelait communément dans le logis Cucendron. La cadette, qui n\'était pas si malhonnête que son aînée, l\'appelait Cendrillon; cependant Cendrillon, avec ses méchants habits, ne laissait pas d\'être cent fois plus belle que ses sœurs, quoique vêtues très magnifiquement. 

 

Il arriva que le fils du roi donna un bal, et qu\'il y invita toutes les personnes de qualité : nos deux demoiselles en furent aussi invitées, car elles faisaient grande figure dans le pays. Les voilà bien aises et bien occupées à choisir les habits et les coiffures qui leur siéraient le mieux; nouvelle peine pour Cendrillon, car c\'était elle qui repassait le linge de ses sœurs et qui godronnait leurs manchettes : on ne parlait que de la manière dont on s\'habillerait. 

-- Moi, dit l\'aînée, je mettrai mon habit de velours rouge et ma garniture d\'Angleterre. 

-- Moi, dit la cadette, je n\'aurai que ma jupe ordinaire; mais par contre, je mettrai mon manteau à fleurs d\'or, et ma barrière de diamants, qui n\'est pas des plus indifférentes. 

On envoya chercher la bonne coiffeuse, pour dresser les cornettes à deux rangs, et on fit acheter des mouches de la bonne faiseuse : elles appelèrent Cendrillon pour lui demander son avis, car elle avait bon goût. Cendrillon les conseilla le mieux du monde, et s\'offrit même à les coiffer; ce qu\'elles voulurent bien. En les coiffant, elles lui disaient : 

-- Cendrillon, serais--tu bien aise d\'aller au bal ? 

-- Hélas, mesdemoiselles, vous vous moquez de moi, ce n\'est pas là ce qu\'il me faut. 

-- Tu as raison, on rirait bien si on voyait un Cucendron aller au bal. 

Une autre que Cendrillon les aurait coiffées de travers; mais elle était bonne, et elle les coiffa parfaitement bien. Elles furent près de deux jours sans manger, tant elles étaient emplies de joie. On rompit plus de douze lacets à force de les serrer pour leur rendre la taille plus menue, et elles étaient toujours devant leur miroir. Enfin l\'heureux jour arriva, on partit, et Cendrillon les suivit des yeux le plus longtemps qu\'elle put; lorsqu\'elle ne les vit plus, elle se mit à pleurer. Sa marraine, qui la vit tout en pleurs, lui demanda ce qu\'elle avait : 

-- Je voudrais bien... je voudrais bien... 

Elle pleurait si fort qu\'elle ne put achever. Sa marraine, qui était fée, lui dit : 

-- Tu voudrais bien aller au bal, n\'est--ce pas ? 

-- Hélas oui dit Cendrillon en soupirant. 

-- Hé bien, seras--tu bonne fille ? dit sa marraine, je t\'y ferai aller. 

Elle la mena dans sa chambre, et lui dit : 

-- Va dans le jardin et apporte--moi une citrouille. 

 

Cendrillon alla aussitôt cueillir la plus belle qu\'elle put trouver, et la porta à sa marraine, ne pouvant deviner comment cette citrouille pourrait la faire aller au bal. Sa marraine la creusa, et n\'ayant laissé que l\'écorce, la frappa de sa baguette, et la citrouille fut aussitôt changée en un beau carrosse tout doré. Ensuite elle alla regarder dans sa souricière, où elle trouva six souris toutes en vie ; elle dit à Cendrillon de lever un peu la trappe de la souricière, et à chaque souris qui sortait, elle lui donnait un coup de sa baguette, et la souris était aussitôt changée en un beau cheval; ce qui fit un bel attelage de six chevaux, d\'un beau gris de souris pommelé. Comme elle était en peine de quoi elle ferait un cocher : 

-- Je vais voir, dit Cendrillon, s\'il n\'y a point quelque rat dans la ratière, nous en ferons un cocher. 

-- Tu as raison, dit sa marraine  va voir. 

Cendrillon lui apporta la ratière, où il y avait trois gros rats. La fée en prit un d\'entre les trois, à cause de sa maîtresse barbe, et l\'ayant touché, il fut changé en un gros cocher, qui avait une des plus belles moustaches qu\'on ait jamais vues. Ensuite elle lui dit : 

-- Va dans le jardin, tu y trouveras six lézards derrière l\'arrosoir, apporte--les--moi. 

Elle ne les eut pas plus tôt apportés, que la marraine les changea en six laquais, qui montèrent aussitôt derrière le carrosse avec leurs habits chamarrés, et qui s\'y tenaient accrochés, comme s\'ils n\'eussent fait autre chose toute leur vie. La fée dit alors à 

Cendrillon : 

-- Hé bien, voilà de quoi aller au bal, n\'es--tu pas bien aise ? 

-- Oui, mais est--ce que j\'irai comme ça avec mes vilains habits ? 

Sa marraine ne fit que la toucher avec sa baguette, et en même temps ses habits furent changés en des habits de drap d\'or et d\'argent tout chamarrés de pierreries; elle lui donna ensuite une paire de pantoufles de verre, les plus jolies du monde. Quand elle fut ainsi parée, elle monta en carrosse; mais sa marraine lui recommanda instamment de ne pas dépasser minuit, l\'avertissant que si elle demeurait au bal un moment de plus, son carrosse redeviendrait citrouille, ses chevaux des souris, ses laquais des lézards, et que ses vieux habits reprendraient leur première forme. Elle promit à sa marraine qu\'elle ne manquerait pas de sortir du bal avant minuit. 

 

Elle part, ne se sentant pas de joie. Le fils du roi, qu\'on alla avertir qu\'il venait d\'arriver une grande princesse qu\'on ne connaissait point, courut la recevoir; il lui donna la main à la descente du carrosse, et la mena dans la salle où était la compagnie. Il se fit alors un grand silence; on cessa de danser, et les violons ne jouèrent plus, tant on était attentif à contempler les grandes beautés de cette inconnue. On n\'entendait qu\'un bruit confus : 

-- Ha, qu\'elle est belle ! 

Le roi même, tout vieux qu\'il était, ne lassait pas de la regarder, et de dire tout bas à la reine qu\'il y avait longtemps qu\'il n\'avait vu une si belle et si aimable dame. Toutes les dames étaient attentives à considérer sa coiffure et ses habits, pour en avoir dès le lendemain de semblables, pourvu qu\'il se trouvât des étoffes assez belles, et des ouvriers assez habiles.

 

Le fils du roi la mit à la place d\'honneur, et ensuite la prit pour la mener danser : elle dansa avec tant de grâce, qu\'on l\'admira encore davantage. On apporta une fort belle collation, dont le jeune prince ne mangea point, tant il était occupé à la contempler. Elle alla s\'asseoir auprès de ses sœurs, et leur fit mille honnêtetés : elle leur fit part des oranges et des citrons que le Prince lui avait donnés, ce qui les étonna fort, car elles ne la connaissaient point. Lorsqu\'elles causaient ainsi, Cendrillon entendit sonner onze heures trois quarts : elle fit aussitôt une grande révérence à la compagnie, et s\'en alla le plus vite qu\'elle put. 

 

Dès qu\'elle fut arrivée, elle alla trouver sa marraine, et après l\'avoir remerciée, elle lui dit qu\'elle souhaiterait bien aller encore le lendemain au bal, parce que le fils du roi l\'en avait priée. Comme elle était occupée à raconter à sa marraine tout ce qui s\'était passé au bal, les deux sœurs frappèrent à la porte; Cendrillon alla leur ouvrir : 

-- Que vous avez mis longtemps à revenir ! leur dit--elle en bâillant, en se frottant les yeux, et en s\'étendant comme si elle n\'eût fait que de se réveiller; elle n\'avait cependant pas eu envie de dormir depuis qu\'elles s\'étaient quittées. 

-- Si tu étais venue au bal, lui dit une de ses sœurs, tu ne t\'y serais pas ennuyée : il y est venu la plus belle princesse, la plus belle qu\'on puisse jamais voir; elle nous a fait mille civilités, elle nous a donné des oranges et des citrons. 

 

Cendrillon ne se sentait pas de joie : elle leur demanda le nom de cette princesse; mais elles lui répondirent qu\'on ne la connaissait pas, que le fils du roi en était fort en peine, et qu\'il donnerait toutes choses au monde pour savoir qui elle était. Cendrillon sourit et leur dit : 

-- Elle était donc bien belle ? Mon Dieu, que vous êtes heureuses, ne pourrais--je point la voir ? Hélas ! Mademoiselle Javotte, prêtez--moi votre habit jaune que vous mettez tous les jours. 

-- Vraiment, dit Mademoiselle Javotte,  je suis de cet avis ! Prêtez votre habit à un vilain Cucendron comme cela, il faudrait que je fusse bien folle. 

 

Cendrillon s\'attendait bien à ce refus, et elle en fut bien aise, car elle aurait été grandement embarrassée si sa sœur eût bien voulu lui prêter son habit.Le lendemain les deux sœurs furent au bal, et Cendrillon aussi, mais encore plus parée que la première fois. Le fils du roi fut toujours auprès d\'elle, et ne cessa de lui conter des douceurs; la jeune demoiselle ne s\'ennuyait point, et oublia ce que sa marraine lui avait recommandé; de sorte qu\'elle entendit sonner le premier coup de minuit, lorsqu\'elle ne croyait pas qu\'il fût encore onze heures : elle se leva et s\'enfuit aussi légèrement qu\'aurait fait une biche. Le prince la suivit, mais il ne put l\'attraper; elle laissa tomber une de ses pantoufles de verre, que le prince ramassa bien soigneusement. Cendrillon arriva chez elle bien essoufflée, sans carrosse, sans laquais, et avec ses méchants habits, rien ne lui étant resté de toute sa magnificence qu\'une de ses petites pantoufles, la pareille de celle qu\'elle avait laissée tomber. On demanda aux gardes de la porte du palais s\'ils n\'avaient point vu sortir une princesse; ils dirent qu\'ils n\'avaient vu sortir personne, qu\'une jeune fille fort mal vêtue, et qui avait plus l\'air d\'une paysanne que d\'une demoiselle.

 

Quand ses deux sœurs revinrent du bal, Cendrillon leur demanda si elles s\'étaient encore bien diverties, et si belle dame y avait été. Elles lui dirent que oui, mais qu\'elle s\'était enfuie lorsque minuit avait sonné, et si promptement qu\'elle avait laissé tomber une de ses petites pantoufles de verre, la plus jolie du monde; que le fils du roi l\'avait ramassée, et qu\'il n\'avait fait que la regarder pendant tout le reste du bal, et qu\'assurément il était fort amoureux de la belle dame à qui appartenait la petite pantoufle. Elles dirent vrai, car peu de jours après, le fils du roi fit publier à son de trompe qu\'il épouserait celle dont le pied serait bien juste à la pantoufle. On commença à l\'essayer aux princesses, ensuite aux duchesses, et à toute la cour, mais inutilement. On la porta chez les deux sœurs, qui firent tout leur possible pour faire entrer leur pied dans la pantoufle, mais elles ne purent en venir à bout. Cendrillon qui les regardait, et qui reconnut sa pantoufle, dit en riant : 

-- Que je voie si elle ne me serait pas bonne ! 

Ses sœurs se mirent à rire et à se moquer d\'elle. Le gentilhomme qui faisait l\'essai de la pantoufle, ayant regardé attentivement Cendrillon, et la trouvant fort belle, dit que cela était juste, et qu\'il avait ordre de l\'essayer à toutes les filles. Il fit asseoir Cendrillon, et approchant la pantoufle de son petit pied, il vit qu\'elle y entrait sans peine, et qu\'elle y était juste comme de cire. L\'étonnement des deux sœurs fut grand, mais plus grand encore quand Cendrillon tira de sa poche l\'autre petite pantoufle qu\'elle mit à son pied. Là--dessus arriva la marraine qui, ayant donné un coup de sa baguette sur les habits de Cendrillon, les fit devenir encore plus magnifiques que tous les autres. 

 

Alors ses deux sœurs la reconnurent pour la belle dame qu\'elles avaient vue au bal. Elles se jetèrent à ses pieds pour lui demander pardon de tous les mauvais traitements qu\'elles lui avaient fait souffrir. Cendrillon les releva, et leur dit, en les embrassant, qu\'elle leur pardonnait de bon cœur, et qu\'elle les priait de l\'aimer bien toujours. On la mena chez le jeune prince, parée comme elle était : il la trouva encore plus belle que jamais, et peu de jours après il l\'épousa. Cendrillon, qui était aussi bonne que belle, fit loger ses deux sœurs au palais, et les maria dès le jour même à deux grands seigneurs de la cour.

 

Charles Perrault

', '', '2007-02-10 16:33:03', 'publie', '26', '2011-04-28 21:40:45', 'oui', '0000-00-00 00:00:00', '6795', '0', '0.181877005117633', 'non', '2007-02-10 20:03:21', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('9', '', 'Les Contes, Le chat botté, Charles Perrault', '', '42', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', '{{ {Grâce à Alexandria, vous pouvez cliquer sur n\'importe quel mot du texte pour en obtenir immédiatement la définition.}}
Bonne lecture.}



{{{ {{[?Le chat botté]}} }}}




Un meunier ne laissa pour tous biens à trois enfants qu\'il avait, que son moulin, son âne et son chat. Les partages furent bientôt faits, ni le notaire, ni le procureur n\'y furent point appelés. Ils auraient eu bientôt mangé tout le pauvre patrimoine. L\'aîné eut le moulin, le second eut l\'âne, et le plus jeune n\'eut que le chat. Ce dernier ne pouvait se consoler d\'avoir un si pauvre lot : 

-- Mes frères, disait-il, pourront gagner leur vie honnêtement en se mettant ensemble; quant à moi, lorsque j\'aurai mangé mon chat, et que je me serai fait un manchon de sa peau, il faudra que je meure de faim.\" 

Le chat qui entendait ce discours, mais qui n\'en fit pas semblant, lui dit d\'un air posé et sérieux : 

-- Ne vous affligez point, mon maître, vous n\'avez qu\'à me donner un sac, et me faire faire une paire de bottes pour aller dans les broussailles, et vous verrez que vous n\'êtes pas si mal partagé que vous croyez.\" 

Quoique le maître du chat n\'y croyait guère, il lui avait vu faire tant de tours de souplesse, pour prendre des rats et des souris, comme quand il se pendait par les pieds, ou qu\'il se cachait dans la farine pour faire le mort, qu\'il ne désespéra pas d\'en être secouru dans sa misère. 

Lorsque le chat eut ce qu\'il avait demandé, il se botta bravement et, mettant son sac à son cou, il en prit les cordons avec ses deux pattes de devant, et s\'en alla dans une garenne où il y avait grand nombre de lapins. Il mit du son et des lasserons dans son sac, et s\'étendant comme s\'il eût été mort, il attendit que quelque jeune lapin peu instruit encore des ruses de ce monde, vint se fourrer dans son sac pour manger ce qu\'il y avait mis. A peine fut-il couché, qu\'il eut satisfaction; un jeune étourdi de lapin entra dans son sac, et le maître chat tirant aussitôt les cordons le prit et le tua sans miséricorde. 

Tout fier de sa proie, il s\'en alla chez le roi et demanda à lui parler. On le fit monter à l\'appartement de sa majesté où, étant entré il fit une grande révérence au roi, et lui dit : 

-- Voilà, sire, un lapin de garenne que monsieur le Marquis de Carabas (c\'était le nom qu\'il lui prit en gré de donner à son maître), m\'a chargé de vous présenter de sa part. Dis à ton maître, répondit le roi, que je le remercie, et qu\'il me fait plaisir.

Une autre fois, il alla se cacher dans du blé, tenant toujours son sac ouvert; et lorsque deux perdrix y furent entrées, il tira les cordons, et les prit toutes deux. Il alla ensuite les présenter au roi, comme il avait fait avec le lapin de garenne. Le roi reçut encore avec plaisir les deux perdrix, et lui fit donner à boire. Le chat continua ainsi pendant deux ou trois mois à porter de temps en temps au roi du gibier de la chasse de son maître. 

Un jour qu\'il sut que le roi devait aller à la promenade sur le bord de la rivière avec sa fille, la plus belle princesse du monde, il dit à son maître : 

-- Si vous voulez suivre mon conseil, votre fortune est faite; vous n\'avez qu\'à vous baigner dans la rivière à l\'endroit que je vous montrerai, et ensuite me laisser faire.\" Le Marquis de Carabas fit ce que son chat lui conseillait, sans savoir à quoi cela serait bon. Pendant qu\'il se baignait, le roi vint à passer, et le chat se mit à crier de toutes ses forces : 

-- Au secours, au secours, voilà Monsieur le Marquis de Carabas qui se noie !\" 

A ce cri, le roi mit la tête à la portière, et, reconnaissant le chat qui lui avait apporté tant de fois du gibier, il ordonna à ses gardes qu\'on allât vite au secours de Monsieur le Marquis de Carabas. Pendant qu\'on retirait le pauvre marquis de la rivière, le chat s\'approcha du carrosse, et dit au roi que dans le temps que son maître se baignait, il était venu des voleurs qui avaient emporté ses habits, quoiqu\'il eût crié au voleur de toute ses forces; le drôle les avait cachés sous une grosse pierre. 

Le roi ordonna aussitôt aux officiers de sa garde-robe d\'aller chercher un de ses plus beaux habits pour monsieur le Marquis de Carabas. Le roi lui fit mille caresses, et comme les beaux habits qu\'on venait de lui donner relevaient sa bonne mine (car il était beau, et bien fait de sa personne), la fille du roi le trouva fort à son gré, et le Marquis de Carabas ne lui eut pas jeté deux ou trois regards fort respectueux, et un peu tendres, qu\'elle en devint amoureuse à la folie. 

Le roi voulut qu\'il montât dans son carrosse, et qu\'il fût de la promenade. Le chat ravi de voir que son dessein commençait à réussir, prit les devants, et ayant rencontré des paysans qui fauchaient un pré, il leur dit : 

-- Bonnes gens qui fauchez, si vous ne dites au roi que le pré que vous fauchez appartient à Monsieur le Marquis de Carabas, vous serez tous hachés menu comme chair à pâté.\" 

-- C\'est à Monsieur le Marquis de Carabas\", dirent-ils tous ensemble, car la menace du chat leur avait fait peur. 

-- Vous avez là un bel héritage, dit le roi au Marquis de Carabas. 

-- Vous voyez, sire, répondit le marquis, c\'est un pré qui ne manque point de rapporter abondamment toutes les années.\" 

Le maître chat, qui allait toujours devant, rencontra des moissonneurs, et leur dit : 

-- Bonnes gens qui moissonnez, si vous ne dites que tous ce blé appartient à Monsieur le Marquis de Carabas, vous serez tous hachés menu comme chair à pâté.\" 

Le roi, qui passa un moment après, voulut savoir à qui appartenaient tout ce blé qu\'il voyait. 

-- C\'est à monsieur le Marquis de Carabas\", répondirent les moissonneurs, et le roi s\'en réjouit encore avec le marquis. </SPAN><o:p></o:p></P><P class=MsoNormal style=\"MARGIN: 0cm 0cm 0pt; TEXT-ALIGN: justify\"><SPAN style=\"FONT-SIZE: 10pt; COLOR: black; FONT-FAMILY: Verdana\">Le chat, qui allait devant le carrosse, disait toujours la même chose à tous ceux qu\'il rencontrait; et le roi était étonné des grands biens de monsieur le Marquis de Carabas. Le maître chat arriva enfin dans un beau château dont le maître était un ogre, le plus riche qu\'on ait jamais vu, car toutes les terres par où le roi avait passé étaient sous la dépendance de ce château. Le chat, qui eut soin de s\'informer qui était cet ogre, et ce qu\'il savait faire, demanda à lui parler, disant qu\'il n\'avait pas voulu passer si près de son château, sans avoir l\'honneur de lui faire la révérence. L\'ogre le reçut aussi civilement que le peut un ogre, et le fit reposer. <o:p></o:p></SPAN></P><P class=MsoNormal style=\"MARGIN: 0cm 0cm 0pt; TEXT-ALIGN: justify\"><SPAN style=\"FONT-SIZE: 10pt; COLOR: black; FONT-FAMILY: Verdana\">-- On m\'a assuré, dit le chat, que vous aviez le don de vous changer en toute sorte d\'animaux, que vous pouviez, par exemple, vous transformer en lion, en éléphant ? -- <SPAN style=\"mso-spacerun: yes\"></SPAN>Cela est vrai, répondit l\'ogre brusquement, et pour vous le montrer, vous allez me voir devenir lion.\" 

Le chat fut si effrayé de voir un lion devant lui, qu\'il gagna aussitôt les gouttières, non sans peine et sans péril, car ses bottes ne valaient rien pour marcher sur les tuiles. Quelques temps après le chat, ayant vu que l\'ogre avait quitté sa première forme, descendit, et avoua qu\'il avait eu bien peur. 

-- On m\'a assuré encore, dit le chat, mais je ne saurais le croire, que vous aviez aussi le pouvoir de prendre la forme des plus petits animaux, par exemple, de vous changer en un rat, en une souris; je vous avoue que je tiens cela tout à fait impossible. 

-- Impossible ? reprit l\'ogre, vous allez voir\", et aussitôt il se changea en une souris qui se mit à courir sur le plancher. Le chat ne l\'eut pas plus tôt aperçue qu\'il se jeta dessus et la mangea. </SPAN><o:p></o:p></P><P class=MsoNormal style=\"MARGIN: 0cm 0cm 0pt; TEXT-ALIGN: justify\"><SPAN style=\"FONT-SIZE: 10pt; COLOR: black; FONT-FAMILY: Verdana\">Cependant le roi, qui vit en passant le beau château de l\'ogre, voulut y entrer. Le chat, qui entendit le bruit du carrosse qui passait sur le pont-levis, courut au-devant, et dit au roi : \"Votre majesté soit la bienvenue dans le château de Monsieur le Marquis de Carabas. 

-- Comment Monsieur le Marquis, s\'écria le roi, ce château est encore à vous ! Il n\'y a rien de plus beau que cette cour et que tous ces bâtiments qui l\'environnent : voyons-en l\'intérieur, s\'il vous plaît.\" Le marquis donna la main à la jeune princesse, et suivant le roi qui montait le premier, ils entrèrent dans une grande salle où ils trouvèrent une magnifique collation que l\'ogre avait fait préparer pour ses amis qui devaient venir le voir ce même jour, mais qui n\'avaient pas osé entrer, sachant que le roi y était. Le roi, charmé des bonnes qualités de monsieur le Marquis de Carabas, de même que sa fille qui en était folle, et voyant les grands biens qu\'il possédait, lui dit, après avoir bu cinq ou six coupes : <o:p></o:p></SPAN></P><P class=MsoNormal style=\"MARGIN: 0cm 0cm 0pt; TEXT-ALIGN: justify\"><SPAN style=\"FONT-SIZE: 10pt; COLOR: black; FONT-FAMILY: Verdana\">-- Il ne tiendra qu\'à vous, Monsieur le Marquis, que vous ne soyez mon gendre.\" 

Le marquis, faisant de grandes révérences, accepta l\'honneur que lui faisait le roi; et le même jour épousa la princesse. Le chat devint grand seigneur, et ne courut plus après les souris que pour se divertir.



Charles Perrault', '', '2007-02-10 19:51:01', 'publie', '26', '2011-04-28 21:39:35', 'oui', '0000-00-00 00:00:00', '11816', '0', '0.0565753672009913', 'non', '2007-05-22 22:04:53', 'fr', 'oui', '0', '', '2', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('10', 'Ovide, Les métamorphoses', 'Myrrha et Cyniras', 'Traduction  de G.T. Villenave, Paris, 1806 ', '60', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>
', '[[10,290] Il rend grâces à Vénus. Sa bouche ne presse plus une bouche insensible. Ses baisers sont sentis. La statue animée rougit, ouvre les yeux, et voit en même temps le ciel et son amant. La déesse préside à leur hymen; il était son ouvrage. Quand la lune eut rempli neuf fois son croissant, Paphus naquit de l\'union de ces nouveaux époux; et c\'est de Paphus que Chypre a reçu le nom de Paphos. 


Cinyras fut aussi le fruit de cet hymen : Cinyras qu\'on eût pu dire heureux, s\'il n\'eût pas été père. 

[10,300] Je vais chanter un crime affreux. Jeunes filles, et vous, pères, éloignez-vous et ne m\'écoutez pas; ou si mes vers ont pour vous quelques charmes, doutez du fait que je vais raconter : ou, si vous le croyez, croyez aussi et gravez dans vos cœurs le châtiment qui l\'a suivi. Je félicite les peuples de la Thrace, et ce ciel, et ma patrie, d\'être éloignés des climats qui furent témoins d\'un forfait aussi odieux. Que l\'heureuse Arabie soit féconde en amome; que l\'encens, des parfums précieux, des plantes rares, des fleurs odoriférantes, croissent dans son sein : 

[10,310] elle voit naître aussi la myrrhe, et l\'arbre qui la porte est trop cher acheté par le crime qui l\'a produit. 

Myrrha ! l\'Amour même se défend de t\'avoir blessée de ses traits, d\'avoir allumé de son flambeau tes feux criminels. Ce fut une des Furies, armée de sa torche infernale, qui souffla sur toi les poisons dont ses affreux serpents étaient gonflés. La haine pour un père est un crime dans ses enfants; mais l\'amour que tu sens est cent fois plus détestable. Tous les princes de l\'Orient se disputent et ton cœur et ta main. Parmi tous ces amants, choisis un époux : n\'excepte que celui qui t\'a donné le jour. 

Cependant Myrrha connaît le trouble de son cœur, la honte et l\'horreur de sa flamme. 

[10,320] \"Quelle fureur m\'entraîne, dit-elle, et qu\'est-ce que je veux ? Ô dieux immortels ! ô piété filiale ! droits sacrés du sang ! étouffez mon amour, et prévenez un si grand crime, si c\'est un crime en effet. Mais la nature ne paraît pas condamner mon penchant. Les animaux s\'unissent indistinctement et sans choix. Le taureau, le cheval, le bélier fécondent le sein qui les a nourris. L\'oiseau couve avec sa mère dans le nid qui fut son berceau. Ah ! l\'homme est moins heureux. 

[10,330] Il s\'est enchaîné par des lois cruelles qui condamnent ce que permet la nature. 

On dit pourtant qu\'il existe des nations où le père et la fille, où le fils et la mère, unis par l\'hymen, voient leur amour croître par un double lien. 

\"Pourquoi chez ces peuples heureux n\'ai-je reçu le jour, loin de la terre où je suis née, et dont les lois condamnent mon amour ? Mais pourquoi me retracer ces objets ? Fuyez, vains désirs, faux espoir ! Cinyras mérite mon amour, mais je ne dois aimer Cinyras que comme on aime un père. Ainsi donc, si je n\'étais sa fille, je pourrais aspirer à lui plaire ! Ainsi si j\'étais moins à lui, il serait plus à moi ! 

[10,340] Le lien qui nous unit s\'oppose à mon bonheur. Étrangère à Cinyras, ah ! je serais plus heureuse. 

\"Fuyons de ces lieux. Ce n\'est qu\'en abandonnant ma patrie que je pourrai triompher d\'un penchant criminel. Mais, hélas ! une erreur funeste me retient et m\'arrête. Que du moins je puisse voir Cinyras, me placer à ses côtés; que je puisse lui parler, recevoir ses baisers et les lui rendre, s\'il ne m\'est permis d\'espérer rien de plus. Eh ! que peux-tu, fille impie, prétendre plus encore ? Veux-tu confondre ensemble tous les noms et tous les droits; être la rivale de ta mère, et la fille de ton époux, et la sœur de ton fils, et la mère de ton frère? Ne crains-tu pas les sombres déités, aux cheveux de serpents, 

[10,350] qui, à la lueur de leurs torches sanglantes, voient et épouvantent le crime dans le cœur des mortels. Ah ! tandis que ton corps est pur encore du crime, garde-toi d\'en souiller ton esprit. Ne cherche point à violer les droits sacrés de la nature. 

Quand ton père partagerait ton funeste délire, ce délire trouve en lui-même sa condamnation. 

Mais Cinyras a trop de vertu. Il connaît et respecte les droits du sang. Malheureuse ! ah ! pourquoi ne brûle-t-il pas des mêmes feux que moi\" ! 

Ainsi parlait Myrrha. Cependant Cinyras, hésitant sur le choix qu\'il doit faire dans le grand nombre d\'illustres amants qui recherchent la main de sa fille, l\'interroge elle-même, lui nomme ces amants, et consulte son cœur. Elle se tait, elle rougit en regardant son père, 

[10,360] et ses yeux enflammés se remplissent de larmes. Cinyras croit que ces larmes et ce silence expriment la pudeur et l\'embarras d\'une vierge timide. Il lui défend de s\'affliger, il essuie ses pleurs, il l\'embrasse; et ce baiser paternel est pour elle plein de charmes. Il l\'interroge encore sur le choix qu\'elle doit faire : \"Puisse mon époux, dit-elle, être semblable à vous\" ! Cinyras loue cette réponse, qu\'il est loin de comprendre : \"Ô ma fille ! s\'écrie-t-il, conserve toujours pour ton père la même piété\" ! À ce saint nom, Myrrha baisse les yeux et reconnaît son crime. 

Le char de la Nuit roulait dans l\'ombre et le silence. Le sommeil suspendait les travaux et les peines des mortels. La fille de Cinyras veille, 

[10,370] et brûle d\'un feu qu\'elle ne peut dompter. En proie à cette passion fatale, tantôt elle désespère, et tantôt elle veut tout oser. Elle rougit, elle désire, et ne sait à quel parti s\'arrêter. Comme, près de sa racine, profondément par la hache entamé, l\'arbre qui n\'attend plus qu\'un dernier coup, gémit, chancelle, ne sait de quel côté son poids va l\'entraîner, et de tous côtés fait craindre son immense ruine: telle, profondément blessée, Myrrha sent s\'égarer son esprit agité de mouvements divers. Elle forme tantôt un dessein, tantôt un autre : enfin, elle ne voit plus de repos pour elle et de remède a son mal que dans la mort. Elle se lève, elle veut de ses propres mains terminer sa triste destinée; et soudain à une poutre attachant sa ceinture : 

[10,380] \"Adieu, dit-elle, cher Cinyras ! Puissiez-vous ne pas ignorer la cause de ma mort\" ! Elle dit, et déjà elle attachait à son cou le funeste tissu. 

Mais des murmures confus ont frappé les oreilles de sa nourrice, qui repose près de son appartement. La vieille se lève, ouvre la porte, voit les funèbres apprêts, s\'écrie, meurtrit son sein, arrache et déchire la ceinture fatale. Elle pleure ensuite, embrasse Myrrha, et veut enfin connaître la cause de son désespoir. Myrrha se tait, immobile, et les yeux baissés, 

[10,390] accusant en secret le zèle pieux qui vient retarder son trépas. La nourrice redouble ses prières, et découvrant sa tête blanchie par les ans, son sein aride et flétri, elle la conjure par les soins qu\'elle prit d\'elle au berceau, par ce sein dont le lait fut son premier aliment, de confier son secret à son amour, à sa foi. Myrrha soupire, se détourne, et gémit. La nourrice la presse encore de rompre le silence : \"Parlez, dit-elle, et souffrez que je vous sois utile. 

Ma vieillesse, encore active, ne peut m\'empêcher de vous servir. Si l\'amour est le mal qui fait votre tourment, je trouverai dans les plantes et dans des paroles magiques un remède certain. Si par quelque maléfice vos esprits sont troublés, j\'emploierai pour vous guérir les charmes les plus puissants. Si la colère des dieux s\'est appesantie sur vous, on peut les apaiser par des sacrifices. 

[10,400] Que dois-je craindre encore, et qui peut vous affliger ? 

Tout vous rit; la fortune de votre maison est à l\'abri des revers. Votre mère vit, ainsi que votre père heureux de votre amour \". 

Au nom de son père, Myrrha pousse un profond soupir. La nourrice ne soupçonne encore aucun crime; mais elle attribue ce soupir à l\'amour. Elle insiste, elle conjure Myrrha de rompre le silence. Elle la prend en pleurant sur ses genoux chancelants; elle la serre dans ses bras par l\'âge affaiblis. 

\"Je le vois, dit-elle, vous aimez. Mes services vous seront utiles; bannissez toute crainte. Je saurai vous cacher de votre père\". 

[10,410] À ces mots, furieuse, égarée, Myrrha s\'arrache des bras de sa nourrice, et pressant son lit de son front : \"Éloigne-toi, s\'écrie-t-elle, et respecte la honte qui m\'accable. Éloigne-toi, ou cesse de me demander la cause de ma douleur ! Ce que tu veux savoir est un crime odieux\". 

La nourrice frémit, et lui tendant des bras de vieillesse et de crainte tremblants, elle se prosterne suppliante à ses pieds. Elle emploie tour à tour la prière et la crainte. Elle menace de révéler ce qu\'elle a vu, le lien fatal à la poutre attaché; elle promet au contraire de servir l\'amour dont le secret lui sera confié. Myrrha lève la tête, 

[10,420] elle baigne de ses pleurs le sein de sa nourrice, elle veut parler, et sa voix se refuse au pénible aveu qu\'elle va faire. Enfin, couvrant son front de sa robe, elle dit : \"Ô trop heureuse ma mère, épouse de Cinyras\" ! Elle s\'arrête, et gémit. Mais la nourrice n\'a que trop entendu cet aveu commencé. Tous ses membres frémissent d\'horreur, et ses cheveux blanchis se hérissent sur sa tête. Elle épuise tous les raisonnements pour vaincre une passion si détestable. Myrrha reconnaît la vérité, la sagesse de ses avis; mais elle est sûre de mourir, si elle renonce à son amour : \"Vivez donc, dit enfin la nourrice ! Oui, vous posséderez ---.\" Elle n\'ose ajouter votre père; 

[10,430] elle se tait, et confirme sa promesse en attestant les dieux. 

C\'était le temps où les femmes, en longs habits de lin, célébraient les fêtes de Cérès, et offraient à la déesse les prémices des fruits et les premiers épis. Pendant les neuf jours de ces solennités, elles devaient s\'abstenir de la couche nuptiale. Avec elles Cenchréis, épouse de Cinyras, assistait à la célébration des mystères sacrés. Tandis que la reine abandonnait ainsi le lit de son époux, l\'artificieuse nourrice, trouvant le roi échauffé des vapeurs du vin, lui peint sous un nom supposé une amante réelle, 

[10,440] et vante ses attraits. Interrogée sur son âge : \"C\'est, dit-elle, celui de Myrrha\". Elle reçoit l\'ordre de l\'amener. Elle rejoint Myrrha : \"Réjouissez-vous, ma fille, s\'écrie-t-elle, la victoire est à nous\" ! Mais une joie parfaite ne remplit point le cœur de la triste Myrrha. Il est troublé de sinistres présages, et cependant elle se réjouit : tant sont grands le désordre et la confusion de ses sens ! 

La nuit avait ramené le silence et les ombres. Le Bouvier roulait obliquement son char entre les étoiles de l\'Ourse. Myrrha marche à son crime. La lune, au front d\'argent, la voit, se, détourne, et s\'enfuit. De sombres nuages voilent les astres, 

[10,450] et la nuit a caché tous ses feux. Icare, le premier, tu couvris ton visage, ainsi que ta fille Ërigone, qu\'auprès de toi plaça sa piété. 

Trois fois en marchant le pied de Myrrha tremble et chancelle. Trois fois un hibou funèbre semble l\'avertir et la rappeler par ses cris. Sans écouter ce sinistre présage, elle avance et poursuit. L\'obscurité profonde l\'encourage. 

Ce qui lui reste de pudeur dans les ténèbres s\'évanouit. D\'une main, elle s\'appuie sur sa nourrice; de l\'autre, qui se meut en avant dans l\'ombre, elle interroge le chemin. Elle touche enfin la porte de l\'appartement où repose son père : elle l\'ouvre, elle entre, elle frémit. Ses genoux tremblants fléchissent : son sang s\'arrête dans ses veines; elle pâlit; son courage l\'abandonne. 

[10,460] Plus elle est près du crime, plus le crime lui fait horreur. Elle se repent d\'avoir trop osé. Elle voudrait pouvoir, sans être reconnue, revenir sur ses pas; mais, tandis qu\'elle hésite, la vieille l\'entraîne par le bras, et, la conduisant près du lit de Cinyras : \"Je vous la livre, elle est à vous\", dit-elle, et sa main les unit. 

Cinyras reçoit ainsi sa fille dans son lit incestueux. Il attribue la frayeur qui l\'agite aux combats de la pudeur. Elle tremblait : il la rassure. Peut-être aussi, par un nom à son âge permis, il l\'appelle : ma fille; elle répond : mon père ! afin que rien, pas même ces noms sacrés, ne manque à leur forfait. Myrrha sort du lit de son père, 

[10,470] portant dans son flanc le fruit d\'un inceste odieux. 

La nuit du lendemain voit renouveler son crime; plusieurs autres nuits en sont les complices et les témoins. Enfin Cinyras veut voir cette amante inconnue. Un flambeau qu\'il tient lui montre et sa fille et son crime. Saisi d\'horreur, la parole expire sur ses lèvres; soudain il saisit son épée suspendue auprès de son lit. Le fer brille. 

Myrrha fuit épouvantée. Les ténèbres la protègent; elle échappe à la mort. Elle erre dans les campagnes; elle traverse celles de l\'Arabie fertile en palmiers, celles de Panchaïe. Elle voit neuf fois croître et décroître le disque de Phébé. 

[10,480] Enfin, succombant sous le poids de son sein et de ses longues courses, elle s\'arrête aux champs de la Sabée. Incertaine dans les vœux qu\'elle a formés, lasse de vivre, et craignant la mort, elle s\'écrie : 

\"Ô dieux ! si vous êtes touchés de l\'aveu des fautes des mortels et de leur repentir, je reconnais avoir mérité ma peine, je me soumets au châtiment que m\'a réservé votre colère. Mais, afin que ma vue ne souille pas les yeux des humains, si je reste sur la terre; ni les regards des ombres, si je descends dans leur triste séjour, sauvez-moi de la vie, sauvez-moi de la mort; et, changeant ma forme et ma figure, faites qu\'en même temps je sois et ne sois plus !\" 

Le coupable qui se repent trouve toujours quelque divinité propice. Du moins les derniers vœux de Myrrha furent exaucés par des dieux bienfaisants. 

[10,490] Elle parlait encore, et ses pieds s\'enfoncent dans la terre; des racines en sortent, serpentent, affermissent son corps. Nouvel arbre, ses os en font la force : leur moelle est moelle encore; la sève monte et circule dans les canaux du sang. Ses bras s\'étendent en longues branches, ses doigts en légers rameaux; sa peau se durcit en écorce. Déjà l\'arbre pressait son flanc, couvrait son sein, et, croissant par degrés, s\'élevait au-dessus de ses épaules. Myrrha, impatiente, penche son cou, plonge sa tête dans l\'écorce, et y cache sa douleur. 

Mais, quoique en perdant sa forme, elle ait aussi perdu le sentiment, 

[10,500] elle pleure encore; un parfum précieux distille de l\'arbre qui porte son nom, et le rendra célèbre jusque dans les siècles à venir. Cependant le fruit d\'un coupable amour avait crû, et cherchait à s\'ouvrir le tronc qui renferme sa mère. Le tronc s\'enfle; Myrrha sent les douleurs de l\'enfantement; mais elle n\'a plus de voix pour les exprimer, pour appeler Lucine à son secours. L\'arbre en travail se recourbe, gémit, et des larmes plus abondantes semblent couler de son écorce. 

[10,510] La compatissante Lucine approche des rameaux; elle y porte les mains, et prononce des mots puissants et favorables. L\'arbre se fend, l\'écorce s\'ouvre, il en sort un enfant. À ses premiers cris, les Naïades accourent, le couchent sur l\'herbe molle, arrosent son corps, et l\'embaument des pleurs de sa mère. Il pourrait plaire même aux yeux de l\'Envie. Il est semblable à ces Amours que l\'art peint nus sur la toile animée; et si l\'on veut que l\'œil trompé s\'y méprenne, qu\'on donne un carquois à Adonis, ou qu\'on l\'ôte aux Amours. 



', '', '2007-02-25 13:30:54', 'publie', '53', '2010-08-14 22:30:37', 'oui', '0000-00-00 00:00:00', '4780', '0', '2.91914084940252e-09', 'non', '2007-02-25 14:46:58', 'fr', 'oui', '0', '', '1', '', '');
INSERT INTO `spip_articles` (`id_article`, `surtitre`, `titre`, `soustitre`, `id_rubrique`, `descriptif`, `chapo`, `texte`, `ps`, `date`, `statut`, `id_secteur`, `maj`, `export`, `date_redac`, `visites`, `referers`, `popularite`, `accepter_forum`, `date_modif`, `lang`, `langue_choisie`, `id_trad`, `extra`, `id_version`, `nom_site`, `url_site`) values ('20', '', 'Le tour du monde en 80 jours de Jules Verne', '', '45', '', '<!-- **************************************************************************************** --> 
<!-- Alexandria\'s parameters for Webmasters --> 
<!-- Download and place on your site the \"alexandria.wm.js\" to update your special terms. --> 
<!-- Customization is only possible for registered customers. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.memodata.com/alexandria/alexandria.wm.fr.js\"></script> 
<link rel=StyleSheet href=\"http://www.memodata.com/alexandria/alexandria.wm.css\" type=\"text/css\"> 
<!-- **************************************************************************************** --> 
<!-- Alexandria\'s engine --> 
<!-- Copy the lines below in each page you want Alexandria\'s functionalities to be available. --> 
<!-- **************************************************************************************** --> 
<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://www.sensagent.com/alexandria-v1/scripts/alexandriaMemodata.v1.js\"></script> 
<link rel=StyleSheet href=\"http://www.sensagent.com/alexandria-v1/css/alexandriaMemodata.css\" type=\"text/css\"> 
<!-- ======================================================================================== --> 

</head>', '{{{{Grâce à Alexandria, cliquez sur n’importe quel mot du texte pour en obtenir sa définition ou sa traduction.} }}} 



{{{I
_ DANS LEQUEL PHILEAS FOGG ET PASSEPARTOUT S’ACCEPTENT RÉCIPROQUEMENT L’UN COMME MAÎTRE, L’AUTRE COMME DOMESTIQUE}}}
{{}}

En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington Gardens – maison dans laquelle Sheridan mourut en 1814 –, était habitée par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche de ne rien faire qui pût attirer l’attention.



À l’un des plus grands orateurs qui honorent l’Angleterre, succédait donc ce Phileas Fogg, personnage énigmatique, dont on ne savait rien, sinon que c’était un fort galant homme et l’un des plus beaux gentlemen de la haute société anglaise.



On disait qu’il ressemblait à Byron – par la tête, car il était irréprochable quant aux pieds –, mais un Byron à moustaches et à favoris, un Byron impassible, qui aurait vécu mille ans sans vieillir.



Anglais, à coup sûr, Phileas Fogg n’était peut-être pas Londonner. On ne l’avait jamais vu ni à la Bourse, ni à la Banque, ni dans aucun des comptoirs de la Cité. Ni les bassins ni les docks de Londres n’avaient jamais reçu un navire ayant pour armateur Phileas Fogg. Ce gentleman ne figurait dans aucun comité d’administration. Son nom n’avait jamais retenti dans un collège d’avocats, ni au Temple, ni à Lincoln’s-inn, ni à Gray’s-inn. Jamais il ne plaida ni à la Cour du chancelier, ni au Banc de la Reine, ni à l’Échiquier, ni en Cour ecclésiastique. Il n’était ni industriel, ni négociant, ni marchand, ni agriculteur. Il ne faisait partie ni de l’{Institution royale de la Grande-Bretagne}, ni de l’{Institution de Londres}, ni de l’{Institution des Artisans}, ni de l’{Institution Russell}, ni de l’{Institution littéraire de l’Ouest}, ni de l’{Institution du Droit}, ni de cette {Institution des Arts et des Sciences réunis}, qui est placée sous le patronage direct de Sa Gracieuse Majesté. Il n’appartenait enfin à aucune des nombreuses sociétés qui pullulent dans la capitale de l’Angleterre, depuis la {Société de l’Armonica} jusqu’à la {Société entomologique}, fondée principalement dans le but de détruire les insectes nuisibles.



Phileas Fogg était membre du Reform-Club, et voilà tout.



À qui s’étonnerait de ce qu’un gentleman aussi mystérieux comptât parmi les membres de cette honorable association, on répondra qu’il passa sur la recommandation de MM.Baring frères, chez lesquels il avait un crédit ouvert. De là une certaine «surface», due à ce que ses chèques étaient régulièrement payés à vue par le débit de son compte courant invariablement créditeur.



Ce Phileas Fogg était-il riche? Incontestablement. Mais comment il avait fait fortune, c’est ce que les mieux informés ne pouvaient dire, et Mr. Fogg était le dernier auquel il convînt de s’adresser pour l’apprendre. En tout cas, il n’était prodigue de rien, mais non avare, car partout où il manquait un appoint pour une chose noble, utile ou généreuse, il l’apportait silencieusement et même anonymement.



En somme, rien de moins communicatif que ce gentleman. Il parlait aussi peu que possible, et semblait d’autant plus mystérieux qu’il était silencieux. Cependant sa vie était à jour, mais ce qu’il faisait était si mathématiquement toujours la même chose, que l’imagination, mécontente, cherchait au-delà.



Avait-il voyagé? C’était probable, car personne ne possédait mieux que lui la carte du monde. Il n’était endroit si reculé dont il ne parût avoir une connaissance spéciale. Quelquefois, mais en peu de mots, brefs et clairs, il redressait les mille propos qui circulaient dans le club au sujet des voyageurs perdus ou égarés; il indiquait les vraies probabilités, et ses paroles s’étaient trouvées souvent comme inspirées par une seconde vue, tant l’événement finissait toujours par les justifier. C’était un homme qui avait dû voyager partout, – en esprit, tout au moins.



Ce qui était certain toutefois, c’est que, depuis de longues années, Phileas Fogg n’avait pas quitté Londres. Ceux qui avaient l’honneur de le connaître un peu plus que les autres attestaient que – si ce n’est sur ce chemin direct qu’il parcourait chaque jour pour venir de sa maison au club – personne ne pouvait prétendre l’avoir jamais vu ailleurs. Son seul passe-temps était de lire les journaux et de jouer au whist. À ce jeu du silence, si bien approprié à sa nature, il gagnait souvent, mais ses gains n’entraient jamais dans sa bourse et figuraient pour une somme importante à son budget de charité. D’ailleurs, il faut le remarquer, Mr. Fogg jouait évidemment pour jouer, non pour gagner. Le jeu était pour lui un combat, une lutte contre une difficulté, mais une lutte sans mouvement, sans déplacement, sans fatigue, et cela allait à son caractère.



On ne connaissait à Phileas Fogg ni femme ni enfants, – ce qui peut arriver aux gens les plus honnêtes, – ni parents ni amis, – ce qui est plus rare en vérité. Phileas Fogg vivait seul dans sa maison de Saville-row, où personne ne pénétrait. De son intérieur, jamais il n’était question. Un seul domestique suffisait à le servir. Déjeunant, dînant au club à des heures chronométriquement déterminées, dans la même salle, à la même table, ne traitant point ses collègues, n’invitant aucun étranger, il ne rentrait chez lui que pour se coucher, à minuit précis, sans jamais user de ces chambres confortables que le Reform-Club tient à la disposition des membres du cercle. Sur vingt-quatre heures, il en passait dix à son domicile, soit qu’il dormît, soit qu’il s’occupât de sa toilette. S’il se promenait, c’était invariablement, d’un pas égal, dans la salle d’entrée parquetée en marqueterie, ou sur la galerie circulaire, au-dessus de laquelle s’arrondit un dôme à vitraux bleus, que supportent vingt colonnes ioniques en porphyre rouge. S’il dînait ou déjeunait, c’étaient les cuisines, le garde-manger, l’office, la poissonnerie, la laiterie du club, qui fournissaient à sa table leurs succulentes réserves; c’étaient les domestiques du club, graves personnages en habit noir, chaussés de souliers à semelles de molleton, qui le servaient dans une porcelaine spéciale et sur un admirable linge en toile de Saxe; c’étaient les cristaux à moule perdu du club qui contenaient son sherry, son porto ou son claret mélangé de cannelle, de capillaire et de cinnamome; c’était enfin la glace du club – glace venue à grands frais des lacs d’Amérique – qui entretenait ses boissons dans un satisfaisant état de fraîcheur.



Si vivre dans ces conditions, c’est être un excentrique, il faut convenir que l’excentricité a du bon!



La maison de Saville-row, sans être somptueuse, se recommandait par un extrême confort. D’ailleurs, avec les habitudes invariables du locataire, le service s’y réduisait à peu. Toutefois, Phileas Fogg exigeait de son unique domestique une ponctualité, une régularité extraordinaires. Ce jour-là même, 2 octobre, Phileas Fogg avait donné son congé à James Forster – ce garçon s’étant rendu coupable de lui avoir apporté pour sa barbe de l’eau à quatre-vingt-quatre degrés Fahrenheit au lieu de quatre-vingt-six –, et il attendait son successeur, qui devait se présenter entre onze heures et onze heures et demie.



Phileas Fogg, carrément assis dans son fauteuil, les deux pieds rapprochés comme ceux d’un soldat à la parade, les mains appuyées sur les genoux, le corps droit, la tête haute, regardait marcher l’aiguille de la pendule, – appareil compliqué qui indiquait les heures, les minutes, les secondes, les jours, les quantièmes et l’année. À onze heures et demie sonnant, Mr. Fogg devait, suivant sa quotidienne habitude, quitter la maison et se rendre au Reform-Club.



En ce moment, on frappa à la porte du petit salon dans lequel se tenait Phileas Fogg.



James Forster, le congédié, apparut.



«Le nouveau domestique», dit-il, 



Un garçon âgé d’une trentaine d’années se montra et salua.



«Vous êtes Français et vous vous nommez John? lui demanda Phileas Fogg.



– Jean, n’en déplaise à monsieur, répondit le nouveau venu, Jean Passepartout, un surnom qui m’est resté, et que justifiait mon aptitude naturelle à me tirer d’affaire. Je crois être un honnête garçon, monsieur, mais, pour être franc, j’ai fait plusieurs métiers. J’ai été chanteur ambulant, écuyer dans un cirque, faisant de la voltige comme Léotard, et dansant sur la corde comme Blondin; puis je suis devenu professeur de gymnastique, afin de rendre mes talents plus utiles, et, en dernier lieu, j’étais sergent de pompiers, à Paris. J’ai même dans mon dossier des incendies remarquables. Mais voilà cinq ans que j’ai quitté la France et que, voulant goûter de la vie de famille, je suis valet de chambre en Angleterre. Or, me trouvant sans place et ayant appris que M.Phileas Fogg était l’homme le plus exact et le plus sédentaire du Royaume-Uni, je me suis présenté chez monsieur avec l’espérance d’y vivre tranquille et d’oublier jusqu’à ce nom de Passepartout…



– Passepartout me convient, répondit le gentleman. Vous m’êtes recommandé. J’ai de bons renseignements sur votre compte. Vous connaissez mes conditions?



– Oui, monsieur.



– Bien. Quelle heure avez-vous?



– Onze heures vingt-deux, répondit Passepartout, en tirant des profondeurs de son gousset une énorme montre d’argent.



– Vous retardez, dit Mr. Fogg.



– Que monsieur me pardonne, mais c’est impossible.



– Vous retardez de quatre minutes. N’importe. Il suffit de constater l’écart. Donc, à partir de ce moment, onze heures vingt-neuf du matin, ce mercredi 2 octobre 1872, vous êtes à mon service.»



Cela dit, Phileas Fogg se leva, prit son chapeau de la main gauche, le plaça sur sa tête avec un mouvement d’automate et disparut sans ajouter une parole.



Passepartout entendit la porte de la rue se fermer une première fois: c’était son nouveau maître qui sortait; puis une seconde fois: c’était son prédécesseur, James Forster, qui s’en allait à son tour.



Passepartout demeura seul dans la maison de Saville-row.


{{{II
_ OU PASSEPARTOUT EST CONVAINCU QU’IL A ENFIN TROUVE SON IDEAL}}}


«Sur ma foi, se dit Passepartout, un peu ahuri tout d’abord, j’ai connu chez MmeTussaud des bonshommes aussi vivants que mon nouveau maître!»



Il convient de dire ici que les «bonshommes» de MmeTussaud sont des figures de cire, fort visitées à Londres, et auxquelles il ne manque vraiment que la parole.



Pendant les quelques instants qu’il venait d’entrevoir Phileas Fogg, Passepartout avait rapidement, mais soigneusement examiné son futur maître. C’était un homme qui pouvait avoir quarante ans, de figure noble et belle, haut de taille, que ne déparait pas un léger embonpoint, blond de cheveux et de favoris, front uni sans apparences de rides aux tempes, figure plutôt pâle que colorée, dents magnifiques. Il paraissait posséder au plus haut degré ce que les physionomistes appellent «le repos dans l’action», faculté commune à tous ceux qui font plus de besogne que de bruit. Calme, flegmatique, l’œil pur, la paupière immobile, c’était le type achevé de ces Anglais à sang-froid qui se rencontrent assez fréquemment dans le Royaume-Uni, et dont Angelica Kauffmann a merveilleusement rendu sous son pinceau l’attitude un peu académique. Vu dans les divers actes de son existence, ce gentleman donnait l’idée d’un être bien équilibré dans toutes ses parties, justement pondéré, aussi parfait qu’un chronomètre de Leroy ou de Earnshaw. C’est qu’en effet, Phileas Fogg était l’exactitude personnifiée, ce qui se voyait clairement à «l’expression de ses pieds et de ses mains», car chez l’homme, aussi bien que chez les animaux, les membres eux-mêmes sont des organes expressifs des passions.



Phileas Fogg était de ces gens mathématiquement exacts, qui, jamais pressés et toujours prêts, sont économes de leurs pas et de leurs mouvements. Il ne faisait pas une enjambée de trop, allant toujours par le plus court. Il ne perdait pas un regard au plafond. Il ne se permettait aucun geste superflu. On ne l’avait jamais vu ému ni troublé. C’était l’homme le moins hâté du monde, mais il arrivait toujours à temps. Toutefois, on comprendra qu’il vécût seul et pour ainsi dire en dehors de toute relation sociale. Il savait que dans la vie il faut faire la part des frottements, et comme les frottements retardent, il ne se frottait à personne.



Quant à Jean, dit Passepartout, un vrai Parisien de Paris, depuis cinq ans qu’il habitait l’Angleterre et y faisait à Londres le métier de valet de chambre, il avait cherché vainement un maître auquel il pût s’attacher.



Passepartout n’était point un de ces Frontins ou Mascarilles qui, les épaules hautes, le nez au vent, le regard assuré, l’œil sec, ne sont que d’impudents drôles. Non. Passepartout était un brave garçon, de physionomie aimable, aux lèvres un peu saillantes, toujours prêtes à goûter ou à caresser, un être doux et serviable, avec une de ces bonnes têtes rondes que l’on aime à voir sur les épaules d’un ami. Il avait les yeux bleus, le teint animé, la figure assez grasse pour qu’il pût lui-même voir les pommettes de ses joues, la poitrine large, la taille forte, une musculature vigoureuse, et il possédait une force herculéenne que les exercices de sa jeunesse avaient admirablement développée. Ses cheveux bruns étaient un peu rageurs. Si les sculpteurs de l’Antiquité connaissaient dix-huit façons d’arranger la chevelure de Minerve, Passepartout n’en connaissait qu’une pour disposer la sienne: trois coups de démêloir, et il était coiffé.



De dire si le caractère expansif de ce garçon s’accorderait avec celui de Phileas Fogg, c’est ce que la prudence la plus élémentaire ne permet pas. Passepartout serait-il ce domestique foncièrement exact qu’il fallait à son maître? On ne le verrait qu’a l’user. Après avoir eu, on le sait, une jeunesse assez vagabonde, il aspirait au repos. Ayant entendu vanter le méthodisme anglais et la froideur proverbiale des gentlemen, il vint chercher fortune en Angleterre. Mais, jusqu’alors, le sort l’avait mal servi. Il n’avait pu prendre racine nulle part. Il avait fait dix maisons. Dans toutes, on était fantasque, inégal, coureur d’aventures ou coureur de pays, – ce qui ne pouvait plus convenir à Passepartout. Son dernier maître, le jeune Lord Longsferry, membre du Parlement, après avoir passé ses nuits dans les «oysters-rooms» d’Hay-Market, rentrait trop souvent au logis sur les épaules des policemen. Passepartout, voulant avant tout pouvoir respecter son maître, risqua quelques respectueuses observations qui furent mal reçues, et il rompit. Il apprit, sur les entrefaites, que Phileas Fogg, esq., cherchait un domestique. Il prit des renseignements sur ce gentleman. Un personnage dont l’existence était si régulière, qui ne découchait pas, qui ne voyageait pas, qui ne s’absentait jamais, pas même un jour, ne pouvait que lui convenir. Il se présenta et fut admis dans les circonstances que l’on sait.



Passepartout – onze heures et demie étant sonnées – se trouvait donc seul dans la maison de Saville-row. Aussitôt il en commença l’inspection. Il la parcourut de la cave au grenier. Cette maison propre, rangée, sévère, puritaine, bien organisée pour le service, lui plut. Elle lui fit l’effet d’une belle coquille de colimaçon, mais d’une coquille éclairée et chauffée au gaz, car l’hydrogène carburé y suffisait à tous les besoins de lumière et de chaleur. Passepartout trouva sans peine, au second étage, la chambre qui lui était destinée. Elle lui convint. Des timbres électriques et des tuyaux acoustiques la mettaient en communication avec les appartements de l’entresol et du premier étage. Sur la cheminée, une pendule électrique correspondait avec la pendule de la chambre à coucher de Phileas Fogg, et les deux appareils battaient au même instant, la même seconde.



«Cela me va, cela me va!» se dit Passepartout.



Il remarqua aussi, dans sa chambre, une notice affichée au-dessus de la pendule. C’était le programme du service quotidien. Il comprenait – depuis huit heures du matin, heure réglementaire à laquelle se levait Phileas Fogg, jusqu’à onze heures et demie, heure à laquelle il quittait sa maison pour aller déjeuner au Reform-Club – tous les détails du service, le thé et les rôties de huit heures vingt-trois, l’eau pour la barbe de neuf heures trente-sept, la coiffure de dix heures moins vingt, etc. Puis de onze heures et demie du matin à minuit – heure à laquelle se couchait le méthodique gentleman –, tout était noté, prévu, régularisé. Passepartout se fit une joie de méditer ce programme et d’en graver les divers articles dans son esprit.



Quant à la garde-robe de monsieur, elle était fort bien montée et merveilleusement comprise. Chaque pantalon, habit ou gilet portait un numéro d’ordre reproduit sur un registre d’entrée et de sortie, indiquant la date à laquelle, suivant la saison, ces vêtements devaient être tour à tour portés. Même réglementation pour les chaussures.



En somme, dans cette maison de Saville-row qui devait être le temple du désordre à l’époque de l’illustre mais dissipé Sheridan –, ameublement confortable, annonçant une belle aisance. Pas de bibliothèque, pas de livres, qui eussent été sans utilité pour Mr. Fogg, puisque le Reform-Club mettait à sa disposition deux bibliothèques, l’une consacrée aux lettres, l’autre au droit et à la politique. Dans la chambre à coucher, un coffre-fort de moyenne grandeur, que sa construction défendait aussi bien de l’incendie que du vol. Point d’armes dans la maison, aucun ustensile de chasse ou de guerre. Tout y dénotait les habitudes les plus pacifiques.



Après avoir examiné cette demeure en détail, Passepartout se frotta les mains, sa large figure s’épanouit, et il répéta joyeusement:



«Cela me va! voilà mon affaire! Nous nous entendrons parfaitement, Mr. Fogg et moi! Un homme casanier et régulier! Une véritable mécanique! Eh bien, je ne suis pas fâché de servir une mécanique!»




{{{III
_ OU S’ENGAGE UNE CONVERSATION QUI POURRA COUTER CHER À PHILEAS FOGG}}}


Phileas Fogg avait quitté sa maison de Saville-row à onze heures et demie, et, après avoir placé cinq cent soixante-quinze fois son pied droit devant son pied gauche et cinq cent soixante-seize fois son pied gauche devant son pied droit, il arriva au Reform-Club, vaste édifice, élevé dans Pall-Mall, qui n’a pas coûté moins de trois millions à bâtir.



Phileas Fogg se rendit aussitôt à la salle à manger, dont les neuf fenêtres s’ouvraient sur un beau jardin aux arbres déjà dorés par l’automne. Là, il prit place à la table habituelle où son couvert l’attendait. Son déjeuner se composait d’un hors-d’œuvre, d’un poisson bouilli relevé d’une «reading sauce» de premier choix, d’un roastbeef écarlate agrémenté de condiments «mushroom», d’un gâteau farci de tiges de rhubarbe et de groseilles vertes, d’un morceau de chester, – le tout arrosé de quelques tasses de cet excellent thé, spécialement recueilli pour l’office du Reform-Club.



À midi quarante-sept, ce gentleman se leva et se dirigea vers le grand salon, somptueuse pièce, ornée de peintures richement encadrées. Là, un domestique lui remit le {Times} non coupé, dont Phileas Fogg opéra le laborieux dépliage avec une sûreté de main qui dénotait une grande habitude de cette difficile opération. La lecture de ce journal occupa Phileas Fogg jusqu’à trois heures quarante-cinq, et celle du {Standard} – qui lui succéda – dura jusqu’au dîner. Ce repas s’accomplit dans les mêmes conditions que le déjeuner, avec adjonction de «royal british sauce».



À six heures moins vingt, le gentleman reparut dans le grand salon et s’absorba dans la lecture du {Morning Chronicle}.



Une demi-heure plus tard, divers membres du Reform-Club faisaient leur entrée et s’approchaient de la cheminée, où brûlait un feu de houille. C’étaient les partenaires habituels de Mr. Phileas Fogg, comme lui enragés joueurs de whist: l’ingénieur Andrew Stuart, les banquiers John Sullivan et Samuel Fallentin, le brasseur Thomas Flanagan, Gauthier Ralph, un des administrateurs de la Banque d’Angleterre, – personnages riches et considérés, même dans ce club qui compte parmi ses membres les sommités de l’industrie et de la finance.



«Eh bien, Ralph, demanda Thomas Flanagan, où en est cette affaire de vol?



– Eh bien, répondit Andrew Stuart, la Banque en sera pour son argent.



– J’espère, au contraire, dit Gauthier Ralph, que nous mettrons la main sur l’auteur du vol. Des inspecteurs de police, gens fort habiles, ont été envoyés en Amérique et en Europe, dans tous les principaux ports d’embarquement et de débarquement, et il sera difficile à ce monsieur de leur échapper.



– Mais on a donc le signalement du voleur? demanda Andrew Stuart.



– D’abord, ce n’est pas un voleur, répondit sérieusement Gauthier Ralph.



– Comment, ce n’est pas un voleur, cet individu qui a soustrait cinquante-cinq mille livres en bank-notes (1 million 375 000 francs)?



– Non, répondit Gauthier Ralph.



– C’est donc un industriel? dit John Sullivan.



– Le {Morning Chronicle} assure que c’est un gentleman.»



Celui qui fit cette réponse n’était autre que Phileas Fogg, dont la tête émergeait alors du flot de papier amassé autour de lui. En même temps, Phileas Fogg salua ses collègues, qui lui rendirent son salut.



Le fait dont il était question, que les divers journaux du Royaume-Uni discutaient avec ardeur, s’était accompli trois jours auparavant, le 29 septembre. Une liasse de bank-notes, formant l’énorme somme de cinquante-cinq mille livres, avait été prise sur la tablette du caissier principal de la Banque d’Angleterre.



À qui s’étonnait qu’un tel vol eût pu s’accomplir aussi facilement, le sous-gouverneur Gauthier Ralph se bornait à répondre qu’à ce moment même, le caissier s’occupait d’enregistrer une recette de trois shillings six pence, et qu’on ne saurait avoir l’œil à tout.



Mais il convient de faire observer ici – ce qui rend le fait plus explicable – que cet admirable établissement de «Bank of England» paraît se soucier extrêmement de la dignité du public. Point de gardes, point d’invalides, point de grillages! L’or, l’argent, les billets sont exposés librement et pour ainsi dire à la merci du premier venu. On ne saurait mettre en suspicion l’honorabilité d’un passant quelconque. Un des meilleurs observateurs des usages anglais raconte même ceci: Dans une des salles de la Banque où il se trouvait un jour, il eut la curiosité de voir de plus pris un lingot d’or pesant sept à huit livres, qui se trouvait exposé sur la tablette du caissier; il prit ce lingot, l’examina, le passa à son voisin, celui-ci à un autre, si bien que le lingot, de main en main, s’en alla jusqu’au fond d’un corridor obscur, et ne revint qu’une demi-heure après reprendre sa place, sans que le caissier eût seulement levé la tête.



Mais, le 29 septembre, les choses ne se passèrent pas tout à fait ainsi. La liasse de bank-notes ne revint pas, et quand la magnifique horloge, posée au-dessus du «drawing-office», sonna à cinq heures la fermeture des bureaux, la Banque d’Angleterre n’avait plus qu’à passer cinquante-cinq mille livres par le compte de profits et pertes.



Le vol bien et dûment reconnu, des agents, des «détectives», choisis parmi les plus habiles, furent envoyés dans les principaux ports, à Liverpool, à Glasgow, au Havre, à Suez, à Brindisi, à New York, etc., avec promesse, en cas de succès, d’une prime de deux mille livres (50 000 F) et cinq pour cent de la somme qui serait retrouvée. En attendant les renseignements que devait fournir l’enquête immédiatement commencée, ces inspecteurs avaient pour mission d’observer scrupuleusement tous les voyageurs en arrivée ou en partance.



Or, précisément, ainsi que le disait le {Morning Chronicle}, on avait lieu de supposer que l’auteur du vol ne faisait partie d’aucune des sociétés de voleurs d’Angleterre. Pendant cette journée du 29 septembre, un gentleman bien mis, de bonnes manières, l’air distingué, avait été remarqué, qui allait et venait dans la salle des paiements, théâtre du vol. L’enquête avait permis de refaire assez exactement le signalement de ce gentleman, signalement qui fut aussitôt adressé à tous les détectives du Royaume-Uni et du continent quelques bons esprits – et Gauthier Ralph était du nombre – se croyaient donc fondés à espérer que le voleur n’échapperait pas.



Comme on le pense, ce fait était à l’ordre du jour à Londres et dans toute l’Angleterre. On discutait, on se passionnait pour ou contre les probabilités du succès de la police métropolitaine. On ne s’étonnera donc pas d’entendre les membres du Reform-Club traiter la même question, d’autant plus que l’un des sous-gouverneurs de la Banque se trouvait parmi eux.



L’honorable Gauthier Ralph ne voulait pas douter du résultat des recherches, estimant que la prime offerte devrait singulièrement aiguiser le zèle et l’intelligence des agents. Mais son collègue, Andrew Stuart, était loin de partager cette confiance. La discussion continua donc entre les gentlemen, qui s’étaient assis à une table de whist, Stuart devant Flanagan, Fallentin devant Phileas Fogg. Pendant le jeu, les joueurs ne parlaient pas, mais entre les robres, la conversation interrompue reprenait de plus belle.



«Je soutiens, dit Andrew Stuart, que les chances sont en faveur du voleur, qui ne peut manquer d’être un habile homme!



– Allons donc! répondit Ralph, il n’y a plus un seul pays dans lequel il puisse se réfugier.



– Par exemple!



– Où voulez-vous qu’il aille?



– Je n’en sais rien, répondit Andrew Stuart, mais, après tout, la terre est assez vaste.



– Elle l’était autrefois…», dit à mi-voix Phileas Fogg. Puis: « À vous de couper, monsieur», ajouta-t-il en présentant les cartes à Thomas Flanagan.



La discussion fut suspendue pendant le robre. Mais bientôt Andrew Stuart la reprenait, disant:



«Comment, autrefois! Est-ce que la terre a diminué, par hasard?



– Sans doute, répondit Gauthier Ralph. Je suis de l’avis de Mr. Fogg. La terre a diminué, puisqu’on la parcourt maintenant dix fois plus vite qu’il y a cent ans. Et c’est ce qui, dans le cas dont nous nous occupons, rendra les recherches plus rapides.



– Et rendra plus facile aussi la fuite du voleur!



– À vous de jouer, monsieur Stuart!» dit Phileas Fogg.



Mais l’incrédule Stuart n’était pas convaincu, et, la partie achevée:



«Il faut avouer, monsieur Ralph, reprit-il, que vous avez trouvé là une manière plaisante de dire que la terre a diminué! Ainsi parce qu’on en fait maintenant le tour en trois mois…



– En quatre-vingts jours seulement, dit Phileas Fogg.



– En effet, messieurs, ajouta John Sullivan, quatre-vingts jours, depuis que la section entre Rothal et Allahabad a été ouverte sur le «Great-Indian peninsular railway», et voici le calcul établi par le {Morning Chronicle}:

De Londres à Suez par le Mont-Cenis et Brindisi, railways et paquebots: 7 jours

De Suez à Bombay, paquebot: 13 jours

De Bombay à Calcutta, railway: 3 jours

De Calcutta à Hong-Kong (Chine), paquebot: 13 jours

De Hong-Kong à Yokohama (Japon), paquebot: 6 jours

De Yokohama à San Francisco, paquebot: 22 jours

De San Francisco New York, railroad: 7 jours

De New York à Londres, paquebot et railway: 9 jours

Total:80 jours



– Oui, quatre-vingts jours! s’écria, Andrew Stuart, qui par inattention, coupa une carte maîtresse, mais non compris le mauvais temps, les vents contraires, les naufrages, les déraillements, etc.



– Tout compris, répondit Phileas Fogg en continuant de jouer, car, cette fois, la discussion ne respectait plus le whist.



– Même si les Indous ou les Indiens enlèvent les rails! s’écria Andrew Stuart, s’ils arrêtent les trains, pillent les fourgons, scalpent les voyageurs!



– Tout compris», répondit Phileas Fogg, qui, abattant son jeu, ajouta: «Deux atouts maîtres.»



Andrew Stuart, à qui c’était le tour de «faire», ramassa les cartes en disant:



«Théoriquement, vous avez raison, monsieur Fogg, mais dans la pratique…



– Dans la pratique aussi, monsieur Stuart.



– Je voudrais bien vous y voir.



– Il ne tient qu’à vous. Partons ensemble.



– Le Ciel m’en préserve! s’écria Stuart, mais je parierais bien quatre mille livres (100 000 F) qu’un tel voyage, fait dans ces conditions, est impossible.



– Très possible, au contraire, répondit Mr. Fogg.



– Eh bien, faites-le donc!



– Le tour du monde en quatre-vingts jours?



– Oui.



– Je le veux bien.



– Quand?



– Tout de suite.



– C’est de la folie! s’écria Andrew Stuart, qui commençait à se vexer de l’insistance de son partenaire. Tenez! jouons plutôt.



– Refaites alors, répondit Phileas Fogg, car il y a maldonne.»



Andrew Stuart reprit les cartes d’une main fébrile; puis, tout à coup, les posant sur la table:



«Eh bien, oui, monsieur Fogg, dit-il, oui, je parie quatre mille livres!…



– Mon cher Stuart, dit Fallentin, calmez-vous. Ce n’est pas sérieux.



– Quand je dis: je parie, répondit Andrew Stuart, c’est toujours sérieux.



– Soit!» dit Mr. Fogg. Puis, se tournant vers ses collègues:



«J’ai vingt mille livres (500 000 F) déposées chez Baring frères. Je les risquerai volontiers…



– Vingt mille livres! s’écria John Sullivan. Vingt mille livres qu’un retard imprévu peut vous faire perdre!



– L’imprévu n’existe pas, répondit simplement Phileas Fogg.



– Mais, monsieur Fogg, ce laps de quatre-vingts jours n’est calculé que comme un minimum de temps!



– Un minimum bien employé suffit à tout.



– Mais pour ne pas le dépasser, il faut sauter mathématiquement des railways dans les paquebots, et des paquebots dans les chemins de fer!



– Je sauterai mathématiquement.



– C’est une plaisanterie!



– Un bon Anglais ne plaisante jamais, quand il s’agit d’une chose aussi sérieuse qu’un pari, répondit Phileas Fogg. Je parie vingt mille livres contre qui voudra que je ferai le tour de la terre en quatre-vingts jours ou moins, soit dix-neuf cent vingt heures ou cent quinze mille deux cents minutes. Acceptez-vous?



– Nous acceptons, répondirent MM.Stuart, Fallentin, Sullivan, Flanagan et Ralph, après s’être entendus.



– Bien, dit Mr. Fogg. Le train de Douvres part à huit heures quarante-cinq. Je le prendrai.



– Ce soir même? demanda Stuart.



– Ce soir même, répondit Phileas Fogg. Donc, ajouta-t-il en consultant un calendrier de poche, puisque c’est aujourd’hui mercredi 2 octobre, je devrai être de retour à Londres, dans ce salon même du Reform-Club, le samedi 21 décembre, à huit heures quarante-cinq du soir, faute de quoi les vingt mille livres déposées actuellement à mon crédit chez Baring frères vous appartiendront de fait et de droit, messieurs. – Voici un chèque de pareille somme.»



Un procès-verbal du pari fut fait et signé sur-le-champ par les six co-intéressés. Phileas Fogg était demeuré froid. Il n’avait certainement pas parié pour gagner, et n’avait engagé ces vingt mille livres – la moitié de sa fortune – que parce qu’il prévoyait qu’il pourrait avoir à dépenser l’autre pour mener à bien ce difficile, pour ne pas dire inexécutable projet. Quant à ses adversaires, eux, ils paraissaient émus, non pas à cause de la valeur de l’enjeu, mais parce qu’ils se faisaient une sorte de scrupule de lutter dans ces conditions.



Sept heures sonnaient alors. On offrit à Mr. Fogg de suspendre le whist afin qu’il pût faire ses préparatifs de départ.



«Je suis toujours prêt!» répondit cet impassible gentleman, et donnant les cartes:



«Je retourne carreau, dit-il. À vous de jouer, monsieur Stuart.»




{{{IV
_ DANS LEQUEL PHILEAS FOGG STUPEFIE PASSEPARTOUT, SON DOMESTIQUE}}}


À sept heures vingt-cinq, Phileas Fogg, après avoir gagné une vingtaine de guinées au whist, prit congé de ses honorables collègues, et quitta le Reform-Club. À sept heures cinquante, il ouvrait la porte de sa maison et rentrait chez lui.



Passepartout, qui avait consciencieusement étudié son programme, fut assez surpris en voyant Mr. Fogg, coupable d’inexactitude, apparaître à cette heure insolite. Suivant la notice, le locataire de Saville-row ne devait rentrer qu’à minuit précis.



Phileas Fogg était tout d’abord monté à sa chambre, puis il appela:



«Passepartout.»



Passepartout ne répondit pas. Cet appel ne pouvait s’adresser à lui. Ce n’était pas l’heure.



«Passepartout», reprit Mr. Fogg sans élever la voix davantage.



Passepartout se montra.



«C’est la deuxième fois que je vous appelle, dit Mr. Fogg.



– Mais il n’est pas minuit, répondit Passepartout, sa montre à la main.



– Je le sais, reprit Phileas Fogg, et je ne vous fais pas de reproche. Nous partons dans dix minutes pour Douvres et Calais.»



Une sorte de grimace s’ébaucha sur la ronde face du Français. Il était évident qu’il avait mal entendu.



«Monsieur se déplace? demanda-t-il.



– Oui, répondit Phileas Fogg. Nous allons faire le tour du monde.»



Passepartout, l’œil démesurément ouvert, la paupière et le sourcil surélevés, les bras détendus, le corps affaissé, présentait alors tous les symptômes de l’étonnement poussé jusqu’à la stupeur.



«Le tour du monde! murmura-t-il.



– En quatre-vingts jours, répondit Mr. Fogg. Ainsi, nous n’avons pas un instant à perdre.



– Mais les malles?… dit Passepartout, qui balançait inconsciemment sa tête de droite et de gauche.



– Pas de malles. Un sac de nuit seulement. Dedans, deux chemises de laine, trois paires de bas. Autant pour vous. Nous achèterons en route. Vous descendrez mon mackintosh et ma couverture de voyage. Ayez de bonnes chaussures. D’ailleurs, nous marcherons peu ou pas. Allez.»



Passepartout aurait voulu répondre. Il ne put. Il quitta la chambre de Mr. Fogg, monta dans la sienne, tomba sur une chaise, et employant une phrase assez vulgaire de son pays:



«Ah! bien se dit-il, elle est forte, celle-là! Moi qui voulais rester tranquille!…»



Et, machinalement, il fit ses préparatifs de départ. Le tour du monde en quatre-vingts jours! Avait-il affaire à un fou? Non… C’était une plaisanterie? On allait à Douvres, bien. À Calais, soit. Après tout, cela ne pouvait notablement contrarier le brave garçon, qui, depuis cinq ans, n’avait pas foulé le sol de la patrie. Peut-être même irait-on jusqu’à Paris, et, ma foi, il reverrait avec plaisir la grande capitale. Mais, certainement, un gentleman aussi ménager de ses pas s’arrêterait là… Oui, sans doute, mais il n’en était pas moins vrai qu’il partait, qu’il se déplaçait, ce gentleman, si casanier jusqu’alors!



À huit heures, Passepartout avait préparé le modeste sac qui contenait sa garde-robe et celle de son maître; puis, l’esprit encore troublé, il quitta sa chambre, dont il ferma soigneusement la porte, et il rejoignit Mr. Fogg.



Mr. Fogg était prêt. Il portait sous son bras le {Bradshaw’s continental railway steam transit and general guide}, qui devait lui fournir toutes les indications nécessaires à son voyage. Il prit le sac des mains de Passepartout, l’ouvrit et y glissa une forte liasse de ces belles bank-notes qui ont cours dans tous les pays.



«Vous n’avez rien oublié? demanda-t-il.



– Rien, monsieur.



– Mon mackintosh et ma couverture?



– Les voici.



– Bien, prenez ce sac.»



Mr. Fogg remit le sac à Passepartout.



«Et ayez-en soin, ajouta-t-il. Il y a vingt mille livres dedans (500 000 F).»



Le sac faillit s’échapper des mains de Passepartout, comme si les vingt mille livres eussent été en or et pesé considérablement.



Le maître et le domestique descendirent alors, et la porte de la rue fut fermée à double tour.



Une station de voitures se trouvait à l’extrémité de Saville-row. Phileas Fogg et son domestique montèrent dans un cab, qui se dirigea rapidement vers la gare de Charing-Cross, à laquelle aboutit un des embranchements du South-Eastern-railway.



À huit heures vingt, le cab s’arrêta devant la grille de la gare. Passepartout sauta à terre. Son maître le suivit et paya le cocher.



En ce moment, une pauvre mendiante, tenant un enfant à la main, pieds nus dans la boue, coiffée d’un chapeau dépenaillé auquel pendait une plume lamentable, un châle en loques sur ses haillons, s’approcha de Mr. Fogg et lui demanda l’aumône.



Mr. Fogg tira de sa poche les vingt guinées qu’il venait de gagner au whist, et, les présentant à la mendiante:



«Tenez, ma brave femme, dit-il, je suis content de vous avoir rencontrée!»



Puis il passa.



Passepartout eut comme une sensation d’humidité autour de la prunelle. Son maître avait fait un pas dans son cœur.



Mr. Fogg et lui entrèrent aussitôt dans la grande salle de la gare. Là, Phileas Fogg donna à Passepartout l’ordre de prendre deux billets de première classe pour Paris. Puis, se retournant, il aperçut ses cinq collègues du Reform-Club.



«Messieurs, je pars, dit-il, et les divers visas apposés sur un passeport que j’emporte à cet effet vous permettront, au retour, de contrôler mon itinéraire.



– Oh! monsieur Fogg, répondit poliment Gauthier Ralph, c’est inutile. Nous nous en rapporterons à votre honneur de gentleman!



– Cela vaut mieux ainsi, dit Mr. Fogg.



– Vous n’oubliez pas que vous devez être revenu?… fit observer Andrew Stuart.



– Dans quatre-vingts jours, répondit Mr. Fogg, le samedi 21 décembre 1872, à huit heures quarante-cinq minutes du soir. Au revoir, messieurs.»



À huit heures quarante, Phileas Fogg et son domestique prirent place dans le même compartiment. À huit heures quarante-cinq, un coup de sifflet retentit, et le train se mit en marche.



La nuit était noire. Il tombait une pluie fine. Phileas Fogg, accoté dans son coin, ne parlait pas. Passepartout, encore abasourdi, pressait machinalement contre lui le sac aux bank-notes.



Mais le train n’avait pas dépassé Sydenham, que Passepartout poussait un véritable cri de désespoir!



«Qu’avez-vous? demanda Mr. Fogg.



– Il y a… que… dans ma précipitation… mon trouble… j’ai oublié…



– Quoi?



– D’éteindre le bec de gaz de ma chambre!



– Eh bien, mon garçon, répondit froidement Mr. Fogg, il brûle à votre compte!»




{{{V
_ DANS LEQUEL UNE NOUVELLE VALEUR APPARAÎT SUR LA PLACE DE LONDRES}}}


Phileas Fogg, en quittant Londres, ne se doutait guère, sans doute, du grand retentissement qu’allait provoquer son départ. La nouvelle du pari se répandit d’abord dans le Reform-Club, et produisit une véritable émotion parmi les membres de l’honorable cercle. Puis, du club, cette émotion passa aux journaux par la voie des reporters, et des journaux au public de Londres et de tout le Royaume-Uni.



Cette «question du tour du monde» fut commentée, discutée, disséquée, avec autant de passion et d’ardeur que s’il se fût agi d’une nouvelle affaire de l’{Alabama}. Les uns prirent parti pour Phileas Fogg, les autres – et ils formèrent bientôt une majorité considérable – se prononcèrent contre lui. Ce tour du monde à accomplir, autrement qu’en théorie et sur le papier, dans ce minimum de temps, avec les moyens de communication actuellement en usage, ce n’était pas seulement impossible, c’était insensé!



Le {Times}, le {Standard}, l’{Evening Star}, le {Morning Chronicle}, et vingt autres journaux de grande publicité, se déclarèrent contre Mr. Fogg. Seul, le {Daily Telegraph} le soutint dans une certaine mesure. Phileas Fogg fut généralement traité de maniaque, de fou, et ses collègues du Reform-Club furent blâmés d’avoir tenu ce pari, qui accusait un affaiblissement dans les facultés mentales de son auteur.



Des articles extrêmement passionnés, mais logiques, parurent sur la question. On sait l’intérêt que l’on porte en Angleterre à tout ce qui touche à la géographie. Aussi n’était-il pas un lecteur, à quelque classe qu’il appartînt, qui ne dévorât les colonnes consacrées au cas de Phileas Fogg.



Pendant les premiers jours, quelques esprits audacieux – les femmes principalement – furent pour lui, surtout quand l’{Illustrated London News} eut publié son portrait d’après sa photographie déposée aux archives du Reform-Club. Certains gentlemen osaient dire: «Hé! hé! pourquoi pas, après tout? On a vu des choses plus extraordinaires!» C’étaient surtout les lecteurs du {Daily Telegraph}. Mais on sentit bientôt que ce journal lui-même commençait à faiblir.



En effet, un long article parut le 7 octobre dans le Bulletin de la Société royale de géographie. Il traita la question à tous les points de vue, et démontra clairement la folie de l’entreprise. D’après cet article, tout était contre le voyageur, obstacles de l’homme, obstacles de la nature. Pour réussir dans ce projet, il fallait admettre une concordance miraculeuse des heures de départ et d’arrivée, concordance qui n’existait pas, qui ne pouvait pas exister. À la rigueur, et en Europe, où il s’agit de parcours d’une longueur relativement médiocre, on peut compter sur l’arrivée des trains à heure fixe; mais quand ils emploient trois jours à traverser l’Inde, sept jours à traverser les États-Unis, pouvait-on fonder sur leur exactitude les éléments d’un tel problème? Et les accidents de machine, les déraillements, les rencontres, la mauvaise saison, l’accumulation des neiges, est-ce que tout n’était pas contre Phileas Fogg? Sur les paquebots, ne se trouverait-il pas, pendant l’hiver, à la merci des coups de vent ou des brouillards? Est-il donc si rare que les meilleurs marcheurs des lignes transocéaniennes éprouvent des retards de deux ou trois jours? Or, il suffisait d’un retard, un seul, pour que la chaîne de communications fût irréparablement brisée. Si Phileas Fogg manquait, ne fût-ce que de quelques heures, le départ d’un paquebot, il serait forcé d’attendre le paquebot suivant, et par cela même son voyage était compromis irrévocablement.



L’article fit grand bruit. Presque tous les journaux le reproduisirent, et les actions de Phileas Fogg baissèrent singulièrement.



Pendant les premiers jours qui suivirent le départ du gentleman, d’importantes affaires s’étaient engagées sur «l’aléa» de son entreprise. On sait ce qu’est le monde des parieurs en Angleterre, monde plus intelligent, plus relevé que celui des joueurs. Parier est dans le tempérament anglais. Aussi, non seulement les divers membres du Reform-Club établirent-ils des paris considérables pour ou contre Phileas Fogg, mais la masse du public entra dans le mouvement. Phileas Fogg fut inscrit comme un cheval de course, à une sorte de studbook. On en fit aussi une valeur de bourse, qui fut immédiatement cotée sur la place de Londres. On demandait, on offrait du «Phileas Fogg» ferme ou à prime, et il se fit des affaires énormes. Mais cinq jours après son départ, après l’article du Bulletin de la Société de géographie, les offres commencèrent à affluer. Le Phileas Fogg baissa. On l’offrit par paquets. Pris d’abord à cinq, puis à dix, on ne le prit plus qu’à vingt, à cinquante, à cent!



Un seul partisan lui resta. Ce fut le vieux paralytique, Lord Albermale. L’honorable gentleman, cloué sur son fauteuil, eût donné sa fortune pour pouvoir faire le tour du monde, même en dix ans! et il paria cinq mille livres (100 000 F) en faveur de Phileas Fogg. Et quand, en même temps que la sottise du projet, on lui en démontrait l’inutilité, il se contentait de répondre: «Si la chose est faisable, il est bon que ce soit un Anglais qui le premier l’ait faite!»



Or, on en était là, les partisans de Phileas Fogg se raréfiaient de plus en plus; tout le monde, et non sans raison, se mettait contre lui; on ne le prenait plus qu’à cent cinquante, à deux cents contre un, quand, sept jours après son départ, un incident, complètement inattendu, fit qu’on ne le prit plus du tout.



En effet, pendant cette journée, à neuf heures du soir, le directeur de la police métropolitaine avait reçu une dépêche télégraphique ainsi conçue:



«Suez à Londres.



«Rowan, directeur police, administration centrale, Scotland place.



«Je file voleur de Banque, Phileas Fogg. Envoyez sans retard mandat d’arrestation à Bombay (Inde anglaise).



«Fix, détective.»



L’effet de cette dépêche fut immédiat. L’honorable gentleman disparut pour faire place au voleur de bank-notes. Sa photographie, déposée au Reform-Club avec celles de tous ses collègues, fut examinée. Elle reproduisait trait pour trait l’homme dont le signalement avait été fourni par l’enquête. On rappela ce que l’existence de Phileas Fogg avait de mystérieux, son isolement, son départ subit, et il parut évident que ce personnage, prétextant un voyage autour du monde et l’appuyant sur un pari insensé, n’avait eu d’autre but que de dépister les agents de la police anglaise.




{{{VI
_ DANS LEQUEL L’AGENT FIX MONTRE UNE IMPATIENCE BIEN LEGITIME}}}


Voici dans quelles circonstances avait été lancée cette dépêche concernant le sieur Phileas Fogg.



Le mercredi 9 octobre, on attendait pour onze heures du matin, à Suez, le paquebot {Mongolia}, de la Compagnie péninsulaire et orientale, steamer en fer à hélice et à spardeck, jaugeant deux mille huit cents tonnes et possédant une force nominale de cinq cents chevaux. Le {Mongolia} faisait régulièrement les voyages de Brindisi à Bombay par le canal de Suez. C’était un des plus rapides marcheurs de la Compagnie, et les vitesses réglementaires, soit dix milles à l’heure entre Brindisi et Suez, et neuf milles cinquante-trois centièmes entre Suez et Bombay, il les avait toujours dépassées.



En attendant l’arrivée du {Mongolia}, deux hommes se promenaient sur le quai au milieu de la foule d’indigènes et d’étrangers qui affluent dans cette ville, naguère une bourgade, à laquelle la grande œuvre de M.deLesseps assure un avenir considérable.



De ces deux hommes, l’un était l’agent consulaire du Royaume-Uni, établi à Suez, qui – en dépit des fâcheux pronostics du gouvernement britannique et des sinistres prédictions de l’ingénieur Stephenson – voyait chaque jour des navires anglais traverser ce canal, abrégeant ainsi de moitié l’ancienne route de l’Angleterre aux Indes par le cap de Bonne-Espérance.



L’autre était un petit homme maigre, de figure assez intelligente, nerveux, qui contractait avec une persistance remarquable ses muscles sourciliers. À travers ses longs cils brillait un œil très vif, mais dont il savait à volonté éteindre l’ardeur. En ce moment, il donnait certaines marques d’impatience, allant, venant, ne pouvant tenir en place.



Cet homme se nommait Fix, et c’était un de ces «détectives» ou agents de police anglais, qui avaient été envoyés dans les divers ports, après le vol commis à la Banque d’Angleterre. Ce Fix devait surveiller avec le plus grand soin tous les voyageurs prenant la route de Suez, et si l’un d’eux lui semblait suspect, le «filer» en attendant un mandat d’arrestation.



Précisément, depuis deux jours, Fix avait reçu du directeur de la police métropolitaine le signalement de l’auteur présumé du vol. C’était celui de ce personnage distingué et bien mis que l’on avait observé dans la salle des paiements de la Banque.



Le détective, très alléché évidemment par la forte prime promise en cas de succès, attendait donc avec une impatience facile à comprendre l’arrivée du {Mongolia}.



«Et vous dites, monsieur le consul, demanda-t-il pour la dixième fois, que ce bateau ne peut tarder?



– Non, monsieur Fix, répondit le consul. Il a été signalé hier au large de Port-Saïd, et les cent soixante kilomètres du canal ne comptent pas pour un tel marcheur. Je vous répète que le {Mongolia} a toujours gagné la prime de vingt-cinq livres que le gouvernement accorde pour chaque avance de vingt-quatre heures sur les temps réglementaires.



– Ce paquebot vient directement de Brindisi? demanda Fix.



– De Brindisi même, où il a pris la malle des Indes, de Brindisi qu’il a quitté samedi à cinq heures du soir. Ainsi ayez patience, il ne peut tarder à arriver. Mais je ne sais vraiment pas comment, avec le signalement que vous avez reçu, vous pourrez reconnaître votre homme, s’il est à bord du {Mongolia}.



– Monsieur le consul, répondit Fix, ces gens-là, on les sent plutôt qu’on ne les reconnaît. C’est du flair qu’il faut avoir, et le flair est comme un sens spécial auquel concourent l’ouïe, la vue et l’odorat. J’ai arrêté dans ma vie plus d’un de ces gentlemen, et pourvu que mon voleur soit à bord, je vous réponds qu’il ne me glissera pas entre les mains.



– Je le souhaite, monsieur Fix, car il s’agit d’un vol important.



– Un vol magnifique, répondit l’agent enthousiasmé. Cinquante-cinq mille livres! Nous n’avons pas souvent de pareilles aubaines! Les voleurs deviennent mesquins! La race des Sheppard s’étiole! On se fait pendre maintenant pour quelques shillings!



– Monsieur Fix, répondit le consul, vous parlez d’une telle façon que je vous souhaite vivement de réussir; mais, je vous le répète, dans les conditions où vous êtes, je crains que ce ne soit difficile. Savez-vous bien que, d’après le signalement que vous avez reçu, ce voleur ressemble absolument à un honnête homme.



– Monsieur le consul, répondit dogmatiquement l’inspecteur de police, les grands voleurs ressemblent toujours à d’honnêtes gens. Vous comprenez bien que ceux qui ont des figures de coquins n’ont qu’un parti à prendre, c’est de rester probes, sans cela ils se feraient arrêter. Les physionomies honnêtes, ce sont celles-là qu’il faut dévisager surtout. Travail difficile, j’en conviens, et qui n’est plus du métier, mais de l’art.»



On voit que ledit Fix ne manquait pas d’une certaine dose d’amour-propre.



Cependant le quai s’animait peu à peu. Marins de diverses nationalités, commerçants, courtiers, portefaix, fellahs, y affluaient. L’arrivée du paquebot était évidemment prochaine.



Le temps était assez beau, mais l’air froid, par ce vent d’est. Quelques minarets se dessinaient au-dessus de la ville sous les pâles rayons du soleil. Vers le sud, une jetée longue de deux mille mètres s’allongeait comme un bras sur la rade de Suez. À la surface de la mer Rouge roulaient plusieurs bateaux de pêche ou de cabotage, dont quelques-uns ont conservé dans leurs façons l’élégant gabarit de la galère antique.



Tout en circulant au milieu de ce populaire, Fix, par une habitude de sa profession, dévisageait les passants d’un rapide coup d’œil.



Il était alors dix heures et demie.



«Mais il n’arrivera pas, ce paquebot! s’écria-t-il en entendant sonner l’horloge du port.



– Il ne peut être éloigné, répondit le consul.



– Combien de temps stationnera-t-il à Suez? demanda Fix.



– Quatre heures. Le temps d’embarquer son charbon. De Suez à Aden, à l’extrémité de la mer Rouge, on compte treize cent dix milles, et il faut faire provision de combustible.



– Et de Suez, ce bateau va directement à Bombay? demanda Fix.



– Directement, sans rompre charge.



– Eh bien, dit Fix, si le voleur a pris cette route et ce bateau, il doit entrer dans son plan de débarquer à Suez, afin de gagner par une autre voie les possessions hollandaises ou françaises de l’Asie. Il doit bien savoir qu’il ne serait pas en sûreté dans l’Inde, qui est une terre anglaise.



– À moins que ce ne soit un homme très fort, répondit le consul. Vous le savez, un criminel anglais est toujours mieux caché à Londres qu’il ne le serait à l’étranger.»



Sur cette réflexion, qui donna fort à réfléchir à l’agent, le consul regagna ses bureaux, situés à peu de distance. L’inspecteur de police demeura seul, pris d’une impatience nerveuse, avec ce pressentiment assez bizarre que son voleur devait se trouver à bord du {Mongolia}, – et en vérité, si ce coquin avait quitté l’Angleterre avec l’intention de gagner le Nouveau Monde, la route des Indes, moins surveillée ou plus difficile à surveiller que celle de l’Atlantique, devait avoir obtenu sa préférence.



Fix ne fut pas longtemps livré à ses réflexions. De vifs coups de sifflet annoncèrent l’arrivée du paquebot. Toute la horde des portefaix et des fellahs se précipita vers le quai dans un tumulte un peu inquiétant pour les membres et les vêtements des passagers. Une dizaine de canots se détachèrent de la rive et allèrent au-devant du {Mongolia}.



Bientôt on aperçut la gigantesque coque du {Mongolia}, passant entre les rives du canal, et onze heures sonnaient quand le steamer vint mouiller en rade, pendant que sa vapeur fusait à grand bruit par les tuyaux d’échappement.



Les passagers étaient assez nombreux à bord. Quelques-uns restèrent sur le spardeck à contempler le panorama pittoresque de la ville; mais la plupart débarquèrent dans les canots qui étaient venus accoster le {Mongolia}.



Fix examinait scrupuleusement tous ceux qui mettaient pied à terre.



En ce moment, l’un d’eux s’approcha de lui, après avoir vigoureusement repoussé les fellahs qui l’assaillaient de leurs offres de service, et il lui demanda fort poliment s’il pouvait lui indiquer les bureaux de l’agent consulaire anglais. Et en même temps ce passager présentait un passeport sur lequel il désirait sans doute faire apposer le visa britannique.



Fix, instinctivement, prit le passeport, et, d’un rapide coup d’œil, il en lut le signalement.



Un mouvement involontaire faillit lui échapper. La feuille trembla dans sa main. Le signalement libellé sur le passeport était identique à celui qu’il avait reçu du directeur de la police métropolitaine.



«Ce passeport n’est pas le vôtre? dit-il au passager.



– Non, répondit celui-ci, c’est le passeport de mon maître.



– Et votre maître?



– Il est resté à bord.



– Mais, reprit l’agent, il faut qu’il se présente en personne aux bureaux du consulat afin d’établir son identité.



– Quoi! cela est nécessaire?



– Indispensable.



– Et où sont ces bureaux?



– Là, au coin de la place, répondit l’inspecteur en indiquant une maison éloignée de deux cents pas.

– Alors, je vais aller chercher mon maître, à qui pourtant cela ne plaira guère de se déranger!»



Là-dessus, le passager salua Fix et retourna à bord du steamer.




{{{VII
_ QUI TÉMOIGNE UNE FOIS DE PLUS DE L’INUTILITÉ DES PASSEPORTS EN MATIÈRE DE POLICE}}}


L’inspecteur redescendit sur le quai et se dirigea rapidement vers les bureaux du consul. Aussitôt, et sur sa demande pressante, il fut introduit près de ce fonctionnaire.



«Monsieur le consul, lui dit-il sans autre préambule, j’ai de fortes présomptions de croire que notre homme a pris passage à bord du {Mongolia}.»



Et Fix raconta ce qui s’était passé entre ce domestique et lui à propos du passeport.



«Bien, monsieur Fix, répondit le consul, je ne serais pas fâché de voir la figure de ce coquin. Mais peut-être ne se présentera-t-il pas à mon bureau, s’il est ce que vous supposez. Un voleur n’aime pas à laisser derrière lui des traces de son passage, et d’ailleurs la formalité des passeports n’est plus obligatoire.



– Monsieur le consul, répondit l’agent, si c’est un homme fort comme on doit le penser, il viendra!



– Faire viser son passeport?



– Oui. Les passeports ne servent jamais qu’à gêner les honnêtes gens et à favoriser la fuite des coquins. Je vous affirme que celui-ci sera en règle, mais j’espère bien que vous ne le viserez pas…



– Et pourquoi pas? Si ce passeport est régulier, répondit le consul, je n’ai pas le droit de refuser mon visa.



– Cependant, monsieur le consul, il faut bien que je retienne ici cet homme jusqu’à ce que j’aie reçu de Londres un mandat d’arrestation.



– Ah! cela, monsieur Fix, c’est votre affaire, répondit le consul, mais moi, je ne puis…»



Le consul n’acheva pas sa phrase. En ce moment, on frappait à la porte de son cabinet, et le garçon de bureau introduisit deux étrangers, dont l’un était précisément ce domestique qui s’était entretenu avec le détective.



C’étaient, en effet, le maître et le serviteur. Le maître présenta son passeport, en priant laconiquement le consul de vouloir bien y apposer son visa.



Celui-ci prit le passeport et le lut attentivement, tandis que Fix, dans un coin du cabinet, observait ou plutôt dévorait l’étranger des yeux.



Quand le consul eut achevé sa lecture:



«Vous êtes Phileas Fogg, esquire? demanda-t-il.



– Oui, monsieur, répondit le gentleman.



– Et cet homme est votre domestique?



– Oui. Un Français nommé Passepartout.



– Vous venez de Londres?



– Oui.



– Et vous allez?



– À Bombay.



– Bien, monsieur. Vous savez que cette formalité du visa est inutile, et que nous n’exigeons plus la présentation du passeport?



– Je le sais, monsieur, répondit Phileas Fogg, mais je désire constater par votre visa mon passage à Suez.



– Soit, monsieur.»



Et le consul, ayant signé et daté le passeport, y apposa son cachet. Mr. Fogg acquitta les droits de visa, et, après avoir froidement salué, il sortit, suivi de son domestique.



«Eh bien? demanda l’inspecteur.



– Eh bien, répondit le consul, il a l’air d’un parfait honnête homme!



– Possible, répondit Fix, mais ce n’est point ce dont il s’agit. Trouvez-vous, monsieur le consul, que ce flegmatique gentleman ressemble trait pour trait au voleur dont j’ai reçu le signalement?



– J’en conviens, mais vous le savez, tous les signalements…



– J’en aurai le cœur net, répondit Fix. Le domestique me paraît être moins indéchiffrable que le maître. De plus, c’est un Français, qui ne pourra se retenir de parler. À bientôt, monsieur le consul.»



Cela dit, l’agent sortit et se mit à la recherche de Passepartout.



Cependant Mr. Fogg, en quittant la maison consulaire, s’était dirigé vers le quai. Là, il donna quelques ordres à son domestique; puis il s’embarqua dans un canot, revint à bord du {Mongolia} et rentra dans sa cabine. Il prit alors son carnet, qui portait les notes suivantes:



«Quitté Londres, mercredi 2 octobre, 8 heures 45 soir.



«Arrivé à Paris, jeudi 3 octobre, 7 heures 20 matin.



«Quitté Paris, jeudi, 8 heures 40 matin.



«Arrivé par le Mont-Cenis à Turin, vendredi 4 octobre, 6 heures 35 matin.



«Quitté Turin, vendredi, 7 heures 20 matin.



«Arrivé à Brindisi, samedi 5 octobre, 4 heures soir.



«Embarqué sur le {Mongolia}, samedi, 5 heures soir.



«Arrivé à Suez, mercredi 9 octobre, 11 heures matin.



«Total des heures dépensées: 158 1/2, soit en jours: 6 jours 1/2.»



Mr. Fogg inscrivit ces dates sur un itinéraire disposé par colonnes, qui indiquait – depuis le 2 octobre jusqu’au 21 décembre – le mois, le quantième, le jour, les arrivées réglementaires et les arrivées effectives en chaque point principal, Paris, Brindisi, Suez, Bombay, Calcutta, Singapore, Hong-Kong, Yokohama, San Francisco, New York, Liverpool, Londres, et qui permettait de chiffrer le gain obtenu où la perte éprouvée à chaque endroit du parcours.



Ce méthodique itinéraire tenait ainsi compte de tout, et Mr. Fogg savait toujours s’il était en avance ou en retard.



Il inscrivit donc, ce jour-là, mercredi 9 octobre, son arrivée à Suez, qui, concordant avec l’arrivée réglementaire, ne le constituait ni en gain ni en perte.



Puis il se fit servir à déjeuner dans sa cabine. Quant à voir la ville, il n’y pensait même pas, étant de cette race d’Anglais qui font visiter par leur domestique les pays qu’ils traversent.




{{{VIII
_ DANS LEQUEL PASSEPARTOUT PARLE UN PEU PLUS PEUT-ÊTRE QU’IL NE CONVIENDRAIT}}}


Fix avait en peu d’instants rejoint sur le quai Passepartout, qui flânait et regardait, ne se croyant pas, lui, obligé à ne point voir.



«Eh bien, mon ami, lui dit Fix en l’abordant, votre passeport est-il visé?



– Ah! c’est vous, monsieur, répondit le Français. Bien obligé. Nous sommes parfaitement en règle.



– Et vous regardez le pays?



– Oui, mais nous allons si vite qu’il me semble que je voyage en rêve. Et comme cela, nous sommes à Suez?



– À Suez.



– En Égypte?



– En Égypte, parfaitement.



– Et en Afrique?



– En Afrique.



– En Afrique! répéta Passepartout. Je ne peux y croire. Figurez-vous, monsieur, que je m’imaginais ne pas aller plus loin que Paris, et cette fameuse capitale, je l’ai revue tout juste de sept heures vingt du matin à huit heures quarante, entre la gare du Nord et la gare de Lyon, à travers les vitres d’un fiacre et par une pluie battante! Je le regrette! J’aurais aimé à revoir le Père-Lachaise et le Cirque des Champs-Élysées!



– Vous êtes donc bien pressé? demanda l’inspecteur de police.



– Moi, non, mais c’est mon maître. À propos, il faut que j’achète des chaussettes et des chemises! Nous sommes partis sans malles, avec un sac de nuit seulement.



– Je vais vous conduire à un bazar où vous trouverez tout ce qu’il faut.



– Monsieur, répondit Passepartout, vous êtes vraiment d’une complaisance!…»



Et tous deux se mirent en route. Passepartout causait toujours.



«Surtout, dit-il, que je prenne bien garde de ne pas manquer le bateau!



– Vous avez le temps, répondit Fix, il n’est encore que midi!»



Passepartout tira sa grosse montre.



«Midi, dit-il. Allons donc! il est neuf heures cinquante-deux minutes!



– Votre montre retarde, répondit Fix.



– Ma montre! Une montre de famille, qui vient de mon arrière-grand-père! Elle ne varie pas de cinq minutes par an. C’est un vrai chronomètre!



– Je vois ce que c’est, répondit Fix. Vous avez gardé l’heure de Londres, qui retarde de deux heures environ sur Suez. Il faut avoir soin de remettre votre montre au midi de chaque pays.



– Moi! toucher à ma montre! s’écria Passepartout, jamais!



– Eh bien, elle ne sera plus d’accord avec le soleil.



– Tant pis pour le soleil, monsieur! C’est lui qui aura tort!»



Et le brave garçon remit sa montre dans sou gousset avec un geste superbe.



Quelques instants après, Fix lui disait:



«Vous avez donc quitté Londres précipitamment?



– Je le crois bien! Mercredi dernier, à huit heures du soir, contre toutes ses habitudes, Mr. Fogg revint de son cercle, et trois quarts d’heure après nous étions partis.



– Mais où va-t-il donc, votre maître?



– Toujours devant lui! Il fait le tour du monde!



– Le tour du monde? s’écria Fix.



– Oui, en quatre-vingts jours! Un pari, dit-il, mais, entre nous, je n’en crois rien. Cela n’aurait pas le sens commun. Il y a autre chose.



– Ah! c’est un original, ce Mr. Fogg?



– Je le crois.



– Il est donc riche?



– Évidemment, et il emporte une jolie somme avec lui, en bank-notes toutes neuves! Et il n’épargne pas l’argent en route! Tenez! il a promis une prime magnifique au mécanicien du {Mongolia}, si nous arrivons à Bombay avec une belle avance!



– Et vous le connaissez depuis longtemps, votre maître?



– Moi! répondit Passepartout, je suis entré à son service le jour même de notre départ.»



On s’imagine aisément l’effet que ces réponses devaient produire sur l’esprit déjà surexcité de l’inspecteur de police.



Ce départ précipité de Londres, peu de temps après le vol, cette grosse somme emportée, cette hâte d’arriver en des pays lointains, ce prétexte d’un pari excentrique, tout confirmait et devait confirmer Fix dans ses idées. Il fit encore parler le Français et acquit la certitude que ce garçon ne connaissait aucunement son maître, que celui-ci vivait isolé à Londres, qu’on le disait riche sans savoir l’origine de sa fortune, que c’était un homme impénétrable, etc. Mais, en même temps, Fix put tenir pour certain que Phileas Fogg ne débarquait point à Suez, et qu’il allait réellement à Bombay.



«Est-ce loin Bombay? demanda Passepartout.



– Assez loin, répondit l’agent. Il vous faut encore une dizaine de jours de mer.



– Et où prenez-vous Bombay?



– Dans l’Inde.



– En Asie?



– Naturellement.



– Diable! C’est que je vais vous dire… il y a une chose qui me tracasse… c’est mon bec!



– Quel bec?



– Mon bec de gaz que j’ai oublié d’éteindre et qui brûle à mon compte. Or, j’ai calculé que j’en avais pour deux shillings par vingt-quatre heures, juste six pence de plus que je ne gagne, et vous comprenez que pour peu que le voyage se prolonge…»



Fix comprit-il l’affaire du gaz? C’est peu probable. Il n’écoutait plus et prenait un parti. Le Français et lui étaient arrivés au bazar. Fix laissa son compagnon y faire ses emplettes, il lui recommanda de ne pas manquer le départ du {Mongolia}, et il revint en toute hâte aux bureaux de l’agent consulaire.



Fix, maintenant que sa conviction était faite, avait repris tout son sang-froid.



«Monsieur, dit-il au consul, je n’ai plus aucun doute. Je tiens mon homme. Il se fait passer pour un excentrique qui veut faire le tour du monde en quatre-vingts jours.



– Alors c’est un malin, répondit le consul, et il compte revenir à Londres, après avoir dépisté toutes les polices des deux continents!



– Nous verrons bien, répondit Fix.



– Mais ne vous trompez-vous pas? demanda encore une fois le consul.



– Je ne me trompe pas.



– Alors, pourquoi ce voleur a-t-il tenu à faire constater par un visa son passage à Suez?



– Pourquoi?… je n’en sais rien, monsieur le consul, répondit le détective, mais écoutez-moi.»



Et, en quelques mots, il rapporta les points saillants de sa conversation avec le domestique dudit Fogg.



«En effet, dit le consul, toutes les présomptions sont contre cet homme. Et qu’allez-vous faire?



– Lancer une dépêche à Londres avec demande instante de m’adresser un mandat d’arrestation à Bombay, m’embarquer sur le {Mongolia}, filer mon voleur jusqu’aux Indes, et là, sur cette terre anglaise, l’accoster poliment, mon mandat à la main et la main sur l’épaule.»



Ces paroles prononcées froidement, l’agent prit congé du consul et se rendit au bureau télégraphique. De là, il lança au directeur de la police métropolitaine cette dépêche que l’on connaît.



Un quart d’heure plus tard, Fix, son léger bagage à la main, bien muni d’argent, d’ailleurs, s’embarquait à bord du {Mongolia}, et bientôt le rapide steamer filait à toute vapeur sur les eaux de la mer Rouge.




{{{IX
_ OÙ LA MER ROUGE ET LA MER DES INDES SE MONTRENT PROPICES AUX DESSEINS DE PHILEAS FOGG}}}


La distance entre Suez et Aden est exactement de treize cent dix milles, et le cahier des charges de la Compagnie alloue à ses paquebots un laps de temps de cent trente-huit heures pour la franchir. Le {Mongolia}, dont les feux étaient activement poussés, marchait de manière à devancer l’arrivée réglementaire.



La plupart des passagers embarqués à Brindisi avaient presque tous l’Inde pour destination. Les uns se rendaient à Bombay, les autres à Calcutta, mais via Bombay, car depuis qu’un chemin de fer traverse dans toute sa largeur la péninsule indienne, il n’est plus nécessaire de doubler la pointe de Ceylan.



Parmi ces passagers du {Mongolia}, on comptait divers fonctionnaires civils et des officiers de tout grade. De ceux-ci, les uns appartenaient à l’armée britannique proprement dite, les autres commandaient les troupes indigènes de cipayes, tous chèrement appointés, même à présent que le gouvernement s’est substitué aux droits et aux charges de l’ancienne Compagnie des Indes: sous-lieutenants à 7 000 F, brigadiers à 60 000, généraux à 100 000. [Le traitement des fonctionnaires civils est encore plus élevé. Les simples assistants, au premier degré de la hiérarchie, ont 12 000 francs; les juges, 60 000 F; les présidents de cour, 250 000 F; les gouverneurs, 300 000 F, et le gouverneur général, plus de 600 000 F. (Note de l’auteur).]



On vivait donc bien à bord du {Mongolia}, dans cette société de fonctionnaires, auxquels se mêlaient quelques jeunes Anglais, qui, le million en poche, allaient fonder au loin des comptoirs de commerce. Le «purser», l’homme de confiance de la Compagnie, l’égal du capitaine à bord, faisait somptueusement les choses. Au déjeuner du matin, au lunch de deux heures, au dîner de cinq heures et demie, au souper de huit heures, les tables pliaient sous les plats de viande fraîche et les entremets fournis par la boucherie et les offices du paquebot. Les passagères – il y en avait quelques-unes – changeaient de toilette deux fois par jour. On faisait de la musique, on dansait même, quand la mer le permettait.



Mais la mer Rouge est fort capricieuse et trop souvent mauvaise, comme tous ces golfes étroits et longs. Quand le vent soufflait soit de la côte d’Asie, soit de la côte d’Afrique, le {Mongolia}, long fuseau à hélice, pris par le travers, roulait épouvantablement. Les dames disparaissaient alors; les pianos se taisaient; chants et danses cessaient à la fois. Et pourtant, malgré la rafale, malgré la houle, le paquebot, poussé par sa puissante machine, courait sans retard vers le détroit de Bab-el-Mandeb.



Que faisait Phileas Fogg pendant ce temps? On pourrait croire que, toujours inquiet et anxieux, il se préoccupait des changements de vent nuisibles à la marche du navire, des mouvements désordonnés de la houle qui risquaient d’occasionner un accident à la machine, enfin de toutes les avaries possibles qui, en obligeant le {Mongolia} à relâcher dans quelque port, auraient compromis son voyage?



Aucunement, ou tout au moins, si ce gentleman songeait à ces éventualités, il n’en laissait rien paraître. C’était toujours l’homme impassible, le membre imperturbable du Reform-Club, qu’aucun incident ou accident ne pouvait surprendre. Il ne paraissait pas plus ému que les chronomètres du bord. On le voyait rarement sur le pont. Il s’inquiétait peu d’observer cette mer Rouge, si féconde en souvenirs, ce théâtre des premières scènes historiques de l’humanité. Il ne venait pas reconnaître les curieuses villes semées sur ses bords, et dont la pittoresque silhouette se découpait quelquefois à l’horizon. Il ne rêvait même pas aux dangers de ce golfe Arabique, dont les anciens historiens, Strabon, Arrien, Arthémidore, Edrisi, ont toujours parlé avec épouvante, et sur lequel les navigateurs ne se hasardaient jamais autrefois sans avoir consacré leur voyage par des sacrifices propitiatoires.



Que faisait donc cet original, emprisonné dans le {Mongolia}? D’abord il faisait ses quatre repas par jour, sans que jamais ni roulis ni tangage pussent détraquer une machine si merveilleusement organisée. Puis il jouait au whist.



Oui! il avait rencontré des partenaires, aussi enragés que lui: un collecteur de taxes qui se rendait à son poste à Goa, un ministre, le révérend Décimus Smith, retournant à Bombay, et un brigadier général de l’armée anglaise, qui rejoignait son corps à Bénarès. Ces trois passagers avaient pour le whist la même passion que Mr. Fogg, et ils jouaient pendant des heures entières, non moins silencieusement que lui.



Quant à Passepartout, le mal de mer n’avait aucune prise sur lui. Il occupait une cabine à l’avant et mangeait, lui aussi, consciencieusement. Il faut dire que, décidément, ce voyage, fait dans ces conditions, ne lui déplaisait plus. Il en prenait son parti. Bien nourri, bien logé, il voyait du pays et d’ailleurs il s’affirmait à lui-même que toute cette fantaisie finirait à Bombay.



Le lendemain du départ de Suez, le 10 octobre, ce ne fut pas sans un certain plaisir qu’il rencontra sur le pont l’obligeant personnage auquel il s’était adressé en débarquant en Égypte.



«Je ne me trompe pas, dit-il en l’abordant avec son plus aimable sourire, c’est bien vous, monsieur, qui m’avez si complaisamment servi de guide à Suez?



– En effet, répondit le détective, je vous reconnais! Vous êtes le domestique de cet Anglais original…



– Précisément, monsieur…?



– Fix.



– Monsieur Fix, répondit Passepartout. Enchanté de vous retrouver à bord. Et où allez-vous donc?



– Mais, ainsi que vous, à Bombay.



– C’est au mieux! Est-ce que vous avez déjà fait ce voyage?



– Plusieurs fois, répondit Fix. Je suis un agent de la Compagnie péninsulaire.



– Alors vous connaissez l’Inde?



– Mais… oui…, répondit Fix, qui ne voulait pas trop s’avancer.



– Et c’est curieux, cette Inde-là?



– Très curieux! Des mosquées, des minarets, des temples, des fakirs, des pagodes, des tigres, des serpents, des bayadères! Mais il faut espérer que vous aurez le temps de visiter le pays?



– Je l’espère, monsieur Fix. Vous comprenez bien qu’il n’est pas permis à un homme sain d’esprit de passer sa vie à sauter d’un paquebot dans un chemin de fer et d’un chemin de fer dans un paquebot, sous prétexte de faire le tour du monde en quatre-vingts jours! Non. Toute cette gymnastique cessera à Bombay, n’en doutez pas.



– Et il se porte bien, Mr. Fogg? demanda Fix du ton le plus naturel.



– Très bien, monsieur Fix. Moi aussi, d’ailleurs. Je mange comme un ogre qui serait à jeun. C’est l’air de la mer.



– Et votre maître, je ne le vois jamais sur le pont.



– Jamais. Il n’est pas curieux.



– Savez-vous, monsieur Passepartout, que ce prétendu voyage en quatre-vingts jours pourrait bien cacher quelque mission secrète… une mission diplomatique, par exemple!



– Ma foi, monsieur Fix, je n’en sais rien, je vous l’avoue, et, au fond, je ne donnerais pas une demi-couronne pour le savoir.»



Depuis cette rencontre, Passepartout et Fix causèrent souvent ensemble. L’inspecteur de police tenait à se lier avec le domestique du sieur Fogg. Cela pouvait le servir à l’occasion. Il lui offrait donc souvent, au bar-room du {Mongolia}, quelques verres de whisky ou de pale-ale, que le brave garçon acceptait sans cérémonie et rendait même pour ne pas être en reste, – trouvant, d’ailleurs, ce Fix un gentleman bien honnête.



Cependant le paquebot s’avançait rapidement. Le 13, on eut connaissance de Moka, qui apparut dans sa ceinture de murailles ruinées, au-dessus desquelles se détachaient quelques dattiers verdoyants. Au loin, dans les montagnes, se développaient de vastes champs de caféiers. Passepartout fut ravi de contempler cette ville célèbre, et il trouva même qu’avec ces murs circulaires et un fort démantelé qui se dessinait comme une anse, elle ressemblait à une énorme demi-tasse.



Pendant la nuit suivante, le {Mongolia} franchit le détroit de Bab-el-Mandeb, dont le nom arabe signifie {la Porte des Larmes}, et le lendemain, 14, il faisait escale à Steamer-Point, au nord-ouest de la rade d’Aden. C’est là qu’il devait se réapprovisionner de combustible.



Grave et importante affaire que cette alimentation du foyer des paquebots à de telles distances des centres de production. Rien que pour la Compagnie péninsulaire, c’est une dépense annuelle qui se chiffre par huit cent mille livres (20 millions de francs). Il a fallu, en effet, établir des dépôts en plusieurs ports, et, dans ces mers éloignées, le charbon revient à quatre-vingts francs la tonne.



Le {Mongolia} avait encore seize cent cinquante milles à faire avant d’atteindre Bombay, et il devait rester quatre heures à Steamer-Point, afin de remplir ses soutes.



Mais ce retard ne pouvait nuire en aucune façon au programme de Phileas Fogg. Il était prévu. D’ailleurs le {Mongolia}, au lieu d’arriver à Aden le 15 octobre seulement au matin, y entrait le 14 au soir. C’était un gain de quinze heures.



Mr. Fogg et son domestique descendirent à terre. Le gentleman voulait faire viser son passeport. Fix le suivit sans être remarqué. La formalité du visa accomplie, Phileas Fogg revint à bord reprendre sa partie interrompue.



Passepartout, lui, flâna, suivant sa coutume, au milieu de cette population de Somanlis, de Banians, de Parsis, de Juifs, d’Arabes, d’Européens, composant les vingt-cinq mille habitants d’Aden. Il admira les fortifications qui font de cette ville le Gibraltar de la mer des Indes, et de magnifiques citernes auxquelles travaillaient encore les ingénieurs anglais, deux mille ans après les ingénieurs du roi Salomon.



«Très curieux, très curieux! se disait Passepartout en revenant à bord. Je m’aperçois qu’il n’est pas inutile de voyager, si l’on veut voir du nouveau.»



À six heures du soir, le {Mongolia} battait des branches de son hélice les eaux de la rade d’Aden et courait bientôt sur la mer des Indes. Il lui était accordé cent soixante-huit heures pour accomplir la traversée entre Aden et Bombay. Du reste, cette mer indienne lui fut favorable. Le vent tenait dans le nord-ouest. Les voiles vinrent en aide à la vapeur.



Le navire, mieux appuyé, roula moins. Les passagères, en fraîches toilettes, reparurent sur le pont. Les chants et les danses recommencèrent.



Le voyage s’accomplit donc dans les meilleures conditions. Passepartout était enchanté de l’aimable compagnon que le hasard lui avait procuré en la personne de Fix.



Le dimanche 20 octobre, vers midi, on eut connaissance de la côte indienne. Deux heures plus tard, le pilote montait à bord du {Mongolia}. À l’horizon, un arrière-plan de collines se profilait harmonieusement sur le fond du ciel. Bientôt, les rangs de palmiers qui couvrent la ville se détachèrent vivement. Le paquebot pénétra dans cette rade formée par les îles Salcette, Colaba, Éléphanta, Butcher, et à quatre heures et demie il accostait les quais de Bombay.



Phileas Fogg achevait alors le trente-troisième robre de la journée, et son partenaire et lui, grâce à une manœuvre audacieuse, ayant fait les treize levées, terminèrent cette belle traversée par un chelem admirable.



Le {Mongolia} ne devait arriver que le 22 octobre à Bombay. Or, il y arrivait le 20. C’était donc, depuis son départ de Londres, un gain de deux jours, que Phileas Fogg inscrivit méthodiquement sur son itinéraire à la colonne des bénéfices.




{{{X
_ OÙ PASSEPARTOUT EST TROP HEUREUX D’EN ÊTRE QUITTE EN PERDANT SA CHAUSSURE}}}


Personne n’ignore que l’Inde – ce grand triangle renversé dont la base est au nord et la pointe au sud – comprend une superficie de quatorze cent mille milles carrés, sur laquelle est inégalement répandue une population de cent quatre-vingts millions d’habitants. Le gouvernement britannique exerce une domination réelle sur une certaine partie de cet immense pays. Il entretient un gouverneur général à Calcutta, des gouverneurs à Madras, à Bombay, au Bengale, et un lieutenant-gouverneur à Agra.



Mais l’Inde anglaise proprement dite ne compte qu’une superficie de sept cent mille milles carrés et une population de cent à cent dix millions d’habitants. C’est assez dire qu’une notable partie du territoire échappe encore à l’autorité de la reine; et, en effet, chez certains rajahs de l’intérieur, farouches et terribles, l’indépendance indoue est encore absolue.



Depuis 1756 – époque à laquelle fut fondé le premier établissement anglais sur l’emplacement aujourd’hui occupé par la ville de Madras – jusqu’à cette année dans laquelle éclata la grande insurrection des cipayes, la célèbre Compagnie des Indes fut toute-puissante. Elle s’annexait peu à peu les diverses provinces, achetées aux rajahs au prix de rentes qu’elle payait peu ou point; elle nommait son gouverneur général et tous ses employés civils ou militaires; mais maintenant elle n’existe plus, et les possessions anglaises de l’Inde relèvent directement de la couronne.



Aussi l’aspect, les mœurs, les divisions ethnographiques de la péninsule tendent à se modifier chaque jour. Autrefois, on y voyageait par tous les antiques moyens de transport, à pied, à cheval, en charrette, en brouette, en palanquin, à dos d’homme, en coach, etc. Maintenant, des steamboats parcourent à grande vitesse l’Indus, le Gange, et un chemin de fer, qui traverse l’Inde dans toute sa largeur en se ramifiant sur son parcours, met Bombay à trois jours seulement de Calcutta.



Le tracé de ce chemin de fer ne suit pas la ligne droite à travers l’Inde. La distance à vol d’oiseau n’est que de mille à onze cents milles, et des trains, animés d’une vitesse moyenne seulement, n’emploieraient pas trois jours à la franchir; mais cette distance est accrue d’un tiers, au moins, par la corde que décrit le railway en s’élevant jusqu’à Allahabad dans le nord de la péninsule.



Voici, en somme, le tracé à grands points du «Great Indian peninsular railway». En quittant l’île de Bombay, il traverse Salcette, saute sur le continent en face de Tannah, franchit la chaîne des Ghâtes-Occidentales, court au nord-est jusqu’à Burhampour, sillonne le territoire à peu près indépendant du Bundelkund, s’élève jusqu’à Allahabad, s’infléchit vers l’est, rencontre le Gange à Bénarès, s’en écarte légèrement, et, redescendant au sud-est par Burdivan et la ville française de Chandernagor, il fait tête de ligne à Calcutta.



C’était à quatre heures et demie du soir que les passagers du {Mongolia} avaient débarqué à Bombay, et le train de Calcutta partait à huit heures précises.



Mr. Fogg prit donc congé de ses partenaires, quitta le paquebot, donna à son domestique le détail de quelques emplettes à faire, lui recommanda expressément de se trouver avant huit heures à la gare, et, de son pas régulier qui battait la seconde comme le pendule d’une horloge astronomique, il se dirigea vers le bureau des passeports.

Ainsi donc, des merveilles de Bombay, il ne songeait à rien voir, ni l’hôtel de ville, ni la magnifique bibliothèque, ni les forts, ni les docks, ni le marché au coton, ni les bazars, ni les mosquées, ni les synagogues, ni les églises arméniennes, ni la splendide pagode de Malebar-Hill, ornée de deux tours polygones. Il ne contemplerait ni les chefs-d’œuvre d’Éléphanta, ni ses mystérieux hypogées, cachés au sud-est de la rade, ni les grottes Kanhérie de l’île Salcette, ces admirables restes de l’architecture bouddhiste!



Non! rien. En sortant du bureau des passeports, Phileas Fogg se rendit tranquillement à la gare, et là il se fit servir à dîner. Entre autres mets, le maître d’hôtel crut devoir lui recommander une certaine gibelotte de «lapin du pays», dont il lui dit merveille.



Phileas Fogg accepta la gibelotte et la goûta consciencieusement; mais, en dépit de sa sauce épicée, il la trouva détestable.



Il sonna le maître d’hôtel.



«Monsieur, lui dit-il en le regardant fixement, c’est du lapin, cela?



– Oui, mylord, répondit effrontément le drôle, du lapin des jungles.



– Et ce lapin-là n’a pas miaulé quand on l’a tué?



– Miaulé! Oh! mylord! un lapin! Je vous jure…



– Monsieur le maître d’hôtel, reprit froidement Mr. Fogg, ne jurez pas et rappelez-vous ceci: autrefois, dans l’Inde, les chats étaient considérés comme des animaux sacrés. C’était le bon temps.



– Pour les chats, mylord?



– Et peut-être aussi pour les voyageurs!»



Cette observation faite, Mr. Fogg continua tranquillement à dîner.



Quelques instants après Mr. Fogg, l’agent Fix avait, lui aussi, débarqué du {Mongolia} et couru chez le directeur de la police de Bombay. Il fit reconnaître sa qualité de détective, la mission dont il était chargé, sa situation vis-à-vis de l’auteur présumé du vol. Avait-on reçu de Londres un mandat d’arrêt?… On n’avait rien reçu. Et, en effet, le mandat, parti après Fogg, ne pouvait être encore arrivé.



Fix resta fort décontenancé. Il voulut obtenir du directeur un ordre d’arrestation contre le sieur Fogg. Le directeur refusa. L’affaire regardait l’administration métropolitaine, et celle-ci seule pouvait légalement délivrer un mandat. Cette sévérité de principes, cette observance rigoureuse de la légalité est parfaitement explicable avec les mœurs anglaises, qui, en matière de liberté individuelle, n’admettent aucun arbitraire.



Fix n’insista pas et comprit qu’il devait se résigner à attendre son mandat. Mais il résolut de ne point perdre de vue son impénétrable coquin, pendant tout le temps que celui-ci demeurerait à Bombay. Il ne doutait pas que Phileas Fogg n’y séjournât, et, on le sait, c’était aussi la conviction de Passepartout, – ce qui laisserait au mandat d’arrêt le temps d’arriver.



Mais depuis les derniers ordres que lui avait donnés son maître en quittant le {Mongolia}, Passepartout avait bien compris qu’il en serait de Bombay comme de Suez et de Paris, que le voyage ne finirait pas ici, qu’il se poursuivrait au moins jusqu’à Calcutta, et peut-être plus loin. Et il commença à se demander si ce pari de Mr. Fogg n’était pas absolument sérieux, et si la fatalité ne l’entraînait pas, lui qui voulait vivre en repos, à accomplir le tour du monde en quatre-vingts jours!



En attendant, et après avoir fait acquisition de quelques chemises et chaussettes, il se promenait dans les rues de Bombay. Il y avait grand concours de populaire, et, au milieu d’Européens de toutes nationalités, des Persans à bonnets pointus, des Bunhyas à turbans ronds, des Sindes à bonnets carrés, des Arméniens en longues robes, des Parsis à mitre noire. C’était précisément une fête célébrée par ces Parsis ou Guèbres, descendants directs des sectateurs de Zoroastre, qui sont les plus industrieux, les plus civilisés, les plus intelligents, les plus austères des Indous, – race à laquelle appartiennent actuellement les riches négociants indigènes de Bombay. Ce jour-là, ils célébraient une sorte de carnaval religieux, avec processions et divertissements, dans lesquels figuraient des bayadères vêtues de gazes roses brochées d’or et d’argent, qui, au son des violes et au bruit des tam-tams, dansaient merveilleusement, et avec une décence parfaite, d’ailleurs.



Si Passepartout regardait ces curieuses cérémonies, si ses yeux et ses oreilles s’ouvraient démesurément pour voir et entendre, si son air, sa physionomie était bien celle du «booby» le plus neuf qu’on pût imaginer, il est superflu d’y insister ici.



Malheureusement pour lui et pour son maître, dont il risqua de compromettre le voyage, sa curiosité l’entraîna plus loin qu’il ne convenait.



En effet, après avoir entrevu ce carnaval parsi, Passepartout se dirigeait vers la gare, quand, passant devant l’admirable pagode de Malebar-Hill, il eut la malencontreuse idée d’en visiter l’intérieur.



Il ignorait deux choses: d’abord que l’entrée de certaines pagodes indoues est formellement interdite aux chrétiens, et ensuite que les croyants eux-mêmes ne peuvent y pénétrer sans avoir laissé leurs chaussures à la porte. Il faut remarquer ici que, par raison de saine politique, le gouvernement anglais, respectant et faisant respecter jusque dans ses plus insignifiants détails la religion du pays, punit sévèrement quiconque en viole les pratiques.



Passepartout, entré là, sans penser à mal, comme un simple touriste, admirait, à l’intérieur de Malebar-Hill, ce clinquant éblouissant de l’ornementation brahmanique, quand soudain il fut renversé sur les dalles sacrées. Trois prêtres, le regard plein de fureur, se précipitèrent sur lui, arrachèrent ses souliers et ses chaussettes, et commencèrent à le rouer de coups, en proférant des cris sauvages.



Le Français, vigoureux et agile, se releva vivement. D’un coup de poing et d’un coup de pied, il renversa deux de ses adversaires, fort empêtrés dans leurs longues robes, et, s’élançant hors de la pagode de toute la vitesse de ses jambes, il eut bientôt distancé le troisième Indou, qui s’était jeté sur ses traces, en ameutant la foule.



À huit heures moins cinq, quelques minutes seulement avant le départ du train, sans chapeau, pieds nus, ayant perdu dans la bagarre le paquet contenant ses emplettes, Passepartout arrivait à la gare du chemin de fer.



Fix était là, sur le quai d’embarquement. Ayant suivi le sieur Fogg à la gare, il avait compris que ce coquin allait quitter Bombay. Son parti fut aussitôt pris de l’accompagner jusqu’à Calcutta et plus loin s’il le fallait. Passepartout ne vit pas Fix, qui se tenait dans l’ombre, mais Fix entendit le récit de ses aventures, que Passepartout narra en peu de mots à son maître.



«J’espère que cela ne vous arrivera plus», répondit simplement Phileas Fogg, en prenant place dans un des wagons du train.



Le pauvre garçon, pieds nus et tout déconfit, suivit son maître sans mot dire.



Fix allait monter dans un wagon séparé, quand une pensée le retint et modifia subitement son projet de départ.



«Non, je reste, se dit-il. Un délit commis sur le territoire indien… Je tiens mon homme.»



En ce moment, la locomotive lança un vigoureux sifflet, et le train disparut dans la nuit.




{{{XI
_ OÙ PHILEAS FOGG ACHÈTE UNE MONTURE À UN PRIX FABULEUX}}}


Le train était parti à l’heure réglementaire. Il emportait un certain nombre de voyageurs, quelques officiers, des fonctionnaires civils et des négociants en opium et en indigo, que leur commerce appelait dans la partie orientale de la péninsule.



Passepartout occupait le même compartiment que son maître. Un troisième voyageur se trouvait placé dans le coin opposé.



C’était le brigadier général, Sir Francis Cromarty, l’un des partenaires de Mr. Fogg pendant la traversée de Suez à Bombay, qui rejoignait ses troupes cantonnées auprès de Bénarès.



Sir Francis Cromarty, grand, blond, âgé de cinquante ans environ, qui s’était fort distingué pendant la dernière révolte des cipayes, eût véritablement mérité la qualification d’indigène. Depuis son jeune âge, il habitait l’Inde et n’avait fait que de rares apparitions dans son pays natal. C’était un homme instruit, qui aurait volontiers donné des renseignements sur les coutumes, l’histoire, l’organisation du pays indou, si Phileas Fogg eût été homme à les demander. Mais ce gentleman ne demandait rien. Il ne voyageait pas, il décrivait une circonférence. C’était un corps grave, parcourant une orbite autour du globe terrestre, suivant les lois de la mécanique rationnelle. En ce moment, il refaisait dans son esprit le calcul des heures dépensées depuis son départ de Londres, et il se fût frotté les mains, s’il eût été dans sa nature de faire un mouvement inutile.



Sir Francis Cromarty n’était pas sans avoir reconnu l’originalité de son compagnon de route, bien qu’il ne l’eût étudié que les cartes à la main et entre deux robres. Il était donc fondé à se demander si un cœur humain battait sous cette froide enveloppe, si Phileas Fogg avait une âme sensible aux beautés de la nature, aux aspirations morales. Pour lui, cela faisait question. De tous les originaux que le brigadier général avait rencontrés, aucun n’était comparable à ce produit des sciences exactes.



Phileas Fogg n’avait point caché à Sir Francis Cromarty son projet de voyage autour du monde, ni dans quelles conditions il l’opérait. Le brigadier général ne vit dans ce pari qu’une excentricité sans but utile et à laquelle manquerait nécessairement le {transire benefaciendo} qui doit guider tout homme raisonnable. Au train dont marchait le bizarre gentleman, il passerait évidemment sans «rien faire», ni pour lui, ni pour les autres.



Une heure après avoir quitté Bombay, le train, franchissant les viaducs, avait traversé l’île Salcette et courait sur le continent. À la station de Callyan, il laissa sur la droite l’embranchement qui, par Kandallah et Pounah, descend vers le sud-est de l’Inde, et il gagna la station de Pauwell. À ce point, il s’engagea dans les montagnes très ramifiées des Ghâtes-Occidentales, chaînes à base de trapp et de basalte, dont les plus hauts sommets sont couverts de bois épais.



De temps à autre, Sir Francis Cromarty et Phileas Fogg échangeaient quelques paroles, et, à ce moment, le brigadier général, relevant une conversation qui tombait souvent, dit:



«Il y a quelques années, monsieur Fogg, vous auriez éprouvé en cet endroit un retard qui eût probablement compromis votre itinéraire.



– Pourquoi cela, Sir Francis?



– Parce que le chemin de fer s’arrêtait à la base de ces montagnes, qu’il fallait traverser en palanquin ou à dos de poney jusqu’à la station de Kandallah, située sur le versant opposé.



– Ce retard n’eût aucunement dérangé l’économie de mon programme, répondit Mr. Fogg. Je ne suis pas sans avoir prévu l’éventualité de certains obstacles.



– Cependant, monsieur Fogg, reprit le brigadier général, vous risquiez d’avoir une fort mauvaise affaire sur les bras avec l’aventure de ce garçon.»



Passepartout, les pieds entortillés dans sa couverture de voyage, dormait profondément et ne rêvait guère que l’on parlât de lui.



«Le gouvernement anglais est extrêmement sévère et avec raison pour ce genre de délit, reprit Sir Francis Cromarty. Il tient par-dessus tout à ce que l’on respecte les coutumes religieuses des Indous, et si votre domestique eût été pris…



– Eh bien, s’il eût été pris, Sir Francis, répondit Mr. Fogg, il aurait été condamné, il aurait subi sa peine, et puis il serait revenu tranquillement en Europe. Je ne vois pas en quoi cette affaire eût pu retarder son maître!»



Et, là-dessus, la conversation retomba. Pendant la nuit, le train franchit les Ghâtes, passa à Nassik, et le lendemain, 21 octobre, il s’élançait à travers un pays relativement plat, formé par le territoire du Khandeish. La campagne, bien cultivée, était semée de bourgades, au-dessus desquelles le minaret de la pagode remplaçait le clocher de l’église européenne. De nombreux petits cours d’eau, la plupart affluents ou sous-affluents du Godavery, irriguaient cette contrée fertile.



Passepartout, réveillé, regardait, et ne pouvait croire qu’il traversait le pays des Indous dans un train du «Great peninsular railway». Cela lui paraissait invraisemblable. Et cependant rien de plus réel! La locomotive, dirigée par le bras d’un mécanicien anglais et chauffée de houille anglaise, lançait sa fumée sur les plantations de caféiers, de muscadiers, de girofliers, de poivriers rouges. La vapeur se contournait en spirales autour des groupes de palmiers, entre lesquels apparaissaient de pittoresques bungalows, quelques viharis, sortes de monastères abandonnés, et des temples merveilleux qu’enrichissait l’inépuisable ornementation de l’architecture indienne. Puis, d’immenses étendues de terrain se dessinaient à perte de vue, des jungles où ne manquaient ni les serpents ni les tigres qu’épouvantaient les hennissements du train, et enfin des forêts, fendues par le tracé de la voie, encore hantées d’éléphants, qui, d’un œil pensif, regardaient passer le convoi échevelé.



Pendant cette matinée, au-delà de la station de Malligaum, les voyageurs traversèrent ce territoire funeste, qui fut si souvent ensanglanté par les sectateurs de la déesse Kâli. Non loin s’élevaient Ellora et ses pagodes admirables, non loin la célèbre Aurungabad, la capitale du farouche Aureng-Zeb, maintenant simple chef-lieu de l’une des provinces détachées du royaume du Nizam. C’était sur cette contrée que Feringhea, le chef des Thugs, le roi des Étrangleurs, exerçait sa domination. Ces assassins, unis dans une association insaisissable, étranglaient, en l’honneur de la déesse de la Mort, des victimes de tout âge, sans jamais verser de sang, et il fut un temps où l’on ne pouvait fouiller un endroit quelconque de ce sol sans y trouver un cadavre. Le gouvernement anglais a bien pu empêcher ces meurtres dans une notable proportion, mais l’épouvantable association existe toujours et fonctionne encore.



À midi et demi, le train s’arrêta à la station de Burhampour, et Passepartout put s’y procurer à prix d’or une paire de babouches, agrémentées de perles fausses, qu’il chaussa avec un sentiment d’évidente vanité.



Les voyageurs déjeunèrent rapidement, et repartirent pour la station d’Assurghur, après avoir un instant côtoyé la rive du Tapty, petit fleuve qui va se jeter dans le golfe de Cambaye, près de Surate.



Il est opportun de faire connaître quelles pensées occupaient alors l’esprit de Passepartout. Jusqu’à son arrivée à Bombay, il avait cru et pu croire que ces choses en resteraient là. Mais maintenant, depuis qu’il filait à toute vapeur à travers l’Inde, un revirement s’était fait dans son esprit. Son naturel lui revenait au galop. Il retrouvait les idées fantaisistes de sa jeunesse, il prenait au sérieux les projets de son maître, il croyait à la réalité du pari, conséquemment à ce tour du monde et à ce maximum de temps, qu’il ne fallait pas dépasser. Déjà même, il s’inquiétait des retards possibles, des accidents qui pouvaient survenir en route. Il se sentait comme intéressé dans cette gageure, et tremblait à la pensée qu’il avait pu la compromettre la veille par son impardonnable badauderie. Aussi, beaucoup moins flegmatique que Mr. Fogg, il était beaucoup plus inquiet. Il comptait et recomptait les jours écoulés, maudissait les haltes du train, l’accusait de lenteur et blâmait {in petto} Mr. Fogg de n’avoir pas promis une prime au mécanicien. Il ne savait pas, le brave garçon, que ce qui était possible sur un paquebot ne l’était plus sur un chemin de fer, dont la vitesse est réglementée.



Vers le soir, on s’engagea dans les défilés des montagnes de Sutpour, qui séparent le territoire du Khandeish de celui du Bundelkund.



Le lendemain, 22 octobre, sur une question de Sir Francis Cromarty, Passepartout, ayant consulté sa montre, répondit qu’il était trois heures du matin. Et, en effet, cette fameuse montre, toujours réglée sur le méridien de Greenwich, qui se trouvait à près de soixante-dix-sept degrés dans l’ouest, devait retarder et retardait en effet de quatre heures.



Sir Francis rectifia donc l’heure donnée par Passepartout, auquel il fit la même observation que celui-ci avait déjà reçue de la part de Fix. Il essaya de lui faire comprendre qu’il devait se régler sur chaque nouveau méridien, et que, puisqu’il marchait constamment vers l’est, c’est-à-dire au-devant du soleil, les jours étaient plus courts d’autant de fois quatre minutes qu’il y avait de degrés parcourus. Ce fut inutile. Que l’entêté garçon eût compris ou non l’observation du brigadier général, il s’obstina à ne pas avancer sa montre, qu’il maintint invariablement à l’heure de Londres. Innocente manie, d’ailleurs, et qui ne pouvait nuire à personne.



À huit heures du matin et à quinze milles en avant de la station de Rothal, le train s’arrêta au milieu d’une vaste clairière, bordée de quelques bungalows et de cabanes d’ouvriers. Le conducteur du train passa devant la ligne des wagons en disant:



«Les voyageurs descendent ici.»



Phileas Fogg regarda Sir Francis Cromarty, qui parut ne rien comprendre à cette halte au milieu d’une forêt de tamarins et de khajours.



Passepartout, non moins surpris, s’élança sur la voie et revint presque aussitôt, s’écriant:



«Monsieur, plus de chemin de fer!



– Que voulez-vous dire? demanda Sir Francis Cromarty.



– Je veux dire que le train ne continue pas!»



Le brigadier général descendit aussitôt de wagon. Phileas Fogg le suivit, sans se presser. Tous deux s’adressèrent au conducteur:



«Où sommes-nous? demanda Sir Francis Cromarty.



– Au hameau de Kholby, répondit le conducteur.



– Nous nous arrêtons ici?



– Sans doute. Le chemin de fer n’est point achevé…



– Comment! il n’est point achevé?



– Non! il y a encore un tronçon d’une cinquantaine de milles à établir entre ce point et Allahabad, où la voie reprend.



– Les journaux ont pourtant annoncé l’ouverture complète du railway!



– Que voulez-vous, mon officier, les journaux se sont trompés.



– Et vous donnez des billets de Bombay à Calcutta! reprit Sir Francis Cromarty, qui commençait à s’échauffer.



– Sans doute, répondit le conducteur, mais les voyageurs savent bien qu’ils doivent se faire transporter de Kholby jusqu’à Allahabad.»



Sir Francis Cromarty était furieux. Passepartout eût volontiers assommé le conducteur, qui n’en pouvait mais. Il n’osait regarder son maître.



«Sir Francis, dit simplement Mr. Fogg, nous allons, si vous le voulez bien, aviser au moyen de gagner Allahabad.



– Monsieur Fogg, il s’agit ici d’un retard absolument préjudiciable à vos intérêts?



– Non, Sir Francis, cela était prévu.



– Quoi! vous saviez que la voie…



– En aucune façon, mais je savais qu’un obstacle quelconque surgirait tôt ou tard sur ma route. Or, rien n’est compromis. J’ai deux jours d’avance à sacrifier. Il y a un steamer qui part de Calcutta pour Hong-Kong le 25 à midi. Nous ne sommes qu’au 22, et nous arriverons à temps à Calcutta.»



Il n’y avait rien à dire à une réponse faite avec une si complète assurance.



Il n’était que trop vrai que les travaux du chemin de fer s’arrêtaient à ce point. Les journaux sont comme certaines montres qui ont la manie d’avancer, et ils avaient prématurément annoncé l’achèvement de la ligne. La plupart des voyageurs connaissaient cette interruption de la voie, et, en descendant du train, ils s’étaient emparés des véhicules de toutes sortes que possédait la bourgade, palkigharis à quatre roues, charrettes traînées par des zébus, sortes de bœufs à bosses, chars de voyage ressemblant à des pagodes ambulantes, palanquins, poneys, etc. Aussi Mr. Fogg et Sir Francis Cromarty, après avoir cherché dans toute la bourgade, revinrent-ils sans avoir rien trouvé.



«J’irai à pied», dit Phileas Fogg.



Passepartout qui rejoignait alors son maître, fit une grimace significative, en considérant ses magnifiques mais insuffisantes babouches. Fort heureusement il avait été de son côté à la découverte, et en hésitant un peu:



«Monsieur, dit-il, je crois que j’ai trouvé un moyen de transport.



– Lequel?



– Un éléphant! Un éléphant qui appartient à un Indien logé à cent pas d’ici.



– Allons voir l’éléphant», répondit Mr. Fogg.



Cinq minutes plus tard, Phileas Fogg, Sir Francis Cromarty et Passepartout arrivaient près d’une hutte qui attenait à un enclos fermé de hautes palissades. Dans la hutte, il y avait un Indien, et dans l’enclos, un éléphant. Sur leur demande, l’Indien introduisit Mr. Fogg et ses deux compagnons dans l’enclos.



Là, ils se trouvèrent en présence d’un animal, à demi domestiqué, que son propriétaire élevait, non pour en faire une bête de somme, mais une bête de combat. Dans ce but, il avait commencé à modifier le caractère naturellement doux de l’animal, de façon à le conduire graduellement à ce paroxysme de rage appelé «mutsh» dans la langue indoue, et cela, en le nourrissant pendant trois mois de sucre et de beurre. Ce traitement peut paraître impropre à donner un tel résultat, mais il n’en est pas moins employé avec succès par les éleveurs. Très heureusement pour Mr. Fogg, l’éléphant en question venait à peine d’être mis à ce régime, et le «mutsh» ne s’était point encore déclaré.



Kiouni – c’était le nom de la bête – pouvait, comme tous ses congénères, fournir pendant longtemps une marche rapide, et, à défaut d’autre monture, Phileas Fogg résolut de l’employer.



Mais les éléphants sont chers dans l’Inde, où ils commencent à devenir rares. Les mâles, qui seuls conviennent aux luttes des cirques, sont extrêmement recherchés. Ces animaux ne se reproduisent que rarement, quand ils sont réduits à l’état de domesticité, de telle sorte qu’on ne peut s’en procurer que par la chasse. Aussi sont-ils l’objet de soins extrêmes, et lorsque Mr. Fogg demanda à l’Indien s’il voulait lui louer son éléphant, l’Indien refusa net.



Fogg insista et offrit de la bête un prix excessif, dix livres (250 F) l’heure. Refus. Vingt livres? Refus encore. Quarante livres? Refus toujours. Passepartout bondissait à chaque surenchère. Mais l’Indien ne se laissait pas tenter.



La somme était belle, cependant. En admettant que l’éléphant employât quinze heures à se rendre à Allahabad, c’était six cents livres (15 000 F) qu’il rapporterait à son propriétaire.



Phileas Fogg, sans s’animer en aucune façon, proposa alors à l’Indien de lui acheter sa bête et lui en offrit tout d’abord mille livres (25 000 F).



L’Indien ne voulait pas vendre! Peut-être le drôle flairait-il une magnifique affaire.



Sir Francis Cromarty prit Mr. Fogg à part et l’engagea à réfléchir avant d’aller plus loin. Phileas Fogg répondit à son compagnon qu’il n’avait pas l’habitude d’agir sans réflexion, qu’il s’agissait en fin de compte d’un pari de vingt mille livres, que cet éléphant lui était nécessaire, et que, dût-il le payer vingt fois sa valeur, il aurait cet éléphant.



Mr. Fogg revint trouver l’Indien, dont les petits yeux, allumés par la convoitise, laissaient bien voir que pour lui ce n’était qu’une question de prix. Phileas Fogg offrit successivement douze cents livres, puis quinze cents, puis dix-huit cents, enfin deux mille (50 000 F). Passepartout, si rouge d’ordinaire, était pâle d’émotion.



À deux mille livres, l’Indien se rendit.



«Par mes babouches, s’écria Passepartout, voilà qui met à un beau prix la viande d’éléphant!»



L’affaire conclue, il ne s’agissait plus que de trouver un guide. Ce fut plus facile. Un jeune Parsi, à la figure intelligente, offrit ses services. Mr. Fogg accepta et lui promit une forte rémunération, qui ne pouvait que doubler son intelligence.



L’éléphant fut amené et équipé sans retard. Le Parsi connaissait parfaitement le métier de «mahout» ou cornac. Il couvrit d’une sorte de housse le dos de l’éléphant et disposa, de chaque côté sur ses flancs, deux espèces de cacolets assez peu confortables.



Phileas Fogg paya l’Indien en bank-notes qui furent extraites du fameux sac. Il semblait vraiment qu’on les tirât des entrailles de Passepartout. Puis Mr. Fogg offrit à Sir Francis Cromarty de le transporter à la station d’Allahabad. Le brigadier général accepta. Un voyageur de plus n’était pas pour fatiguer le gigantesque animal.



Des vivres furent achetées à Kholby. Sir Francis Cromarty prit place dans l’un des cacolets, Phileas Fogg dans l’autre. Passepartout se mit à califourchon sur la housse entre son maître et le brigadier général. Le Parsi se jucha sur le cou de l’éléphant, et à neuf heures l’animal, quittant la bourgade, s’enfonçait par le plus court dans l’épaisse forêt de lataniers.




{{{[{XII
_ OÙ PHILEAS FOGG ET SES COMPAGNONS S’AVENTURENT À TRAVERS LES FORÊTS DE L’INDE ET CE QUI S’ENSUIT}}}}


Le guide, afin d’abréger la distance à parcourir, laissa sur sa droite le tracé de la voie dont les travaux étaient en cours d’exécution. Ce tracé, très contrarié par les capricieuses ramifications des monts Vindhias, ne suivait pas le plus court chemin, que Phileas Fogg avait intérêt à prendre. Le Parsi, très familiarisé avec les routes et sentiers du pays, prétendait gagner une vingtaine de milles en coupant à travers la forêt, et on s’en rapporta à lui.



Phileas Fogg et Sir Francis Cromarty, enfouis jusqu’au cou dans leurs cacolets, étaient fort secoués par le trot raide de l’éléphant, auquel son mahout imprimait une allure rapide. Mais ils enduraient la situation avec le flegme le plus britannique, causant peu d’ailleurs, et se voyant à peine l’un l’autre.



Quant à Passepartout, posté sur le dos de la bête et directement soumis aux coups et aux contrecoups, il se gardait bien, sur une recommandation de son maître, de tenir sa langue entre ses dents, car elle eût été coupée net. Le brave garçon, tantôt lancé sur le cou de l’éléphant, tantôt rejeté sur la croupe, faisait de la voltige, comme un clown sur un tremplin. Mais il plaisantait, il riait au milieu de ses sauts de carpe, et, de temps en temps, il tirait de son sac un morceau de sucre, que l’intelligent Kiouni prenait du bout de sa trompe, sans interrompre un instant son trot régulier.



Après deux heures de marche, le guide arrêta l’éléphant et lui donna une heure de repos. L’animal dévora des branchages et des arbrisseaux, après s’être d’abord désaltéré à une mare voisine. Sir Francis Cromarty ne se plaignit pas de cette halte. Il était brisé. Mr. Fogg paraissait être aussi dispos que s’il fût sorti de son lit.



«Mais il est donc de fer! dit le brigadier général en le regardant avec admiration.



– De fer forgé», répondit Passepartout, qui s’occupa de préparer un déjeuner sommaire.



À midi, le guide donna le signal du départ. Le pays prit bientôt un aspect très sauvage. Aux grandes forêts succédèrent des taillis de tamarins et de palmiers nains, puis de vastes plaines arides, hérissées de maigres arbrisseaux et semées de gros blocs de syénites. Toute cette partie du haut Bundelkund, peu fréquentée des voyageurs, est habitée par une population fanatique, endurcie dans les pratiques les plus terribles de la religion indoue. La domination des Anglais n’a pu s’établir régulièrement sur un territoire soumis à l’influence des rajahs, qu’il eût été difficile d’atteindre dans leurs inaccessibles retraites des Vindhias.

Plusieurs fois, on aperçut des bandes d’Indiens farouches, qui faisaient un geste de colère en voyant passer le rapide quadrupède. D’ailleurs, le Parsi les évitait autant que possible, les tenant pour des gens de mauvaise rencontre. On vit peu d’animaux pendant cette journée, à peine quelques singes, qui fuyaient avec mille contorsions et grimaces dont s’amusait fort Passepartout.



Une pensée au milieu de bien d’autres inquiétait ce garçon. Qu’est-ce que Mr. Fogg ferait de l’éléphant, quand il serait arrivé à la station d’Allahabad? L’emmènerait-il? Impossible! Le prix du transport ajouté au prix d’acquisition en ferait un animal ruineux. Le vendrait-on, le rendrait-on à la liberté? Cette estimable bête méritait bien qu’on eût des égards pour elle. Si, par hasard, Mr. Fogg lui en faisait cadeau, à lui, Passepartout, il en serait très embarrassé. Cela ne laissait pas de le préoccuper.



À huit heures du soir, la principale chaîne des Vindhias avait été franchie, et les voyageurs firent halte au pied du versant septentrional, dans un bungalow en ruine.



La distance parcourue pendant cette journée était d’environ vingt-cinq milles, et il en restait autant à faire pour atteindre la station d’Allahabad.



La nuit était froide. À l’intérieur du bungalow, le Parsi alluma un feu de branches sèches, dont la chaleur fut très appréciée. Le souper se composa des provisions achetées à Kholby. Les voyageurs mangèrent en gens harassés et moulus. La conversation, qui commença par quelques phrases entrecoupées, se termina bientôt par des ronflements sonores. Le guide veilla près de Kiouni, qui s’endormit debout, appuyé au tronc d’un gros arbre.



Nul incident ne signala cette nuit. Quelques rugissements de guépards et de panthères troublèrent parfois le silence, mêlés à des ricanements aigus de singes. Mais les carnassiers s’en tinrent à des cris et ne firent aucune démonstration hostile contre les hôtes du bungalow. Sir Francis Cromarty dormit lourdement comme un brave militaire rompu de fatigues. Passepartout, dans un sommeil agité, recommença en rêve la culbute de la veille, quant à Mr. Fogg, il reposa aussi paisiblement que s’il eût été dans sa tranquille maison de Saville-row.



À six heures du matin, on se remit en marche. Le guide espérait arriver à la station d’Allahabad le soir même. De cette façon, Mr. Fogg ne perdrait qu’une partie des quarante-huit heures économisées depuis le commencement du voyage.



On descendit les dernières rampes des Vindhias. Kiouni avait repris son allure rapide. Vers midi, le guide tourna la bourgade de Kallenger, située sur le Cani, un des sous-affluents du Gange. Il évitait toujours les lieux habités, se sentant plus en sûreté dans ces campagnes désertes, qui marquent les premières dépressions du bassin du grand fleuve. La station d’Allahabad n’était pas à douze milles dans le nord-est. On fit halte sous un bouquet de bananiers, dont les fruits, aussi sains que le pain, «aussi succulents que la crème», disent les voyageurs, furent extrêmement appréciés.



À deux heures, le guide entra sous le couvert d’une épaisse forêt, qu’il devait traverser sur un espace de plusieurs milles. Il préférait voyager ainsi à l’abri des bois. En tout cas, il n’avait fait jusqu’alors aucune rencontre fâcheuse, et le voyage semblait devoir s’accomplir sans accident, quand l’éléphant, donnant quelques signes d’inquiétude, s’arrêta soudain.



Il était quatre heures alors.



«Qu’y a-t-il? demanda Sir Francis Cromarty, qui releva la tête au-dessus de son cacolet.



– Je ne sais, mon officier», répondit le Parsi, en prêtant l’oreille à un murmure confus qui passais sous l’épaisse ramure.



Quelques instants après, ce murmure devint plus définissable. On eût dit un concert, encore fort éloigné, de voix humaines et d’instruments de cuivre.



Passepartout était tout yeux, tout oreilles. Mr. Fogg attendait patiemment, sans prononcer une parole.



Le Parsi sauta à terre, attacha l’éléphant à un arbre et s’enfonça au plus épais du taillis. Quelques minutes plus tard, il revint, disant:



«Une procession de brahmanes qui se dirige de ce côté. S’il est possible, évitons d’être vus.»



Le guide détacha l’éléphant et le conduisit dans un fourré, en recommandant aux voyageurs de ne point mettre pied à terre. Lui-même se tint prêt à enfourcher rapidement sa monture, si la fuite devenait nécessaire. Mais il pensa que la troupe des fidèles passerait sans l’apercevoir, car l’épaisseur du feuillage le dissimulait entièrement.



Le bruit discordant des voix et des instruments se rapprochait. Des chants monotones se mêlaient au son des tambours et des cymbales. Bientôt la tête de la procession apparut sous les arbres, à une cinquantaine de pas du poste occupé par Mr. Fogg et ses compagnons. Ils distinguaient aisément à travers les branches le curieux personnel de cette cérémonie religieuse.



En première ligne s’avançaient des prêtres, coiffés de mitres et vêtus de longues robes chamarrées. Ils étaient entourés d’hommes, de femmes, d’enfants, qui faisaient entendre une sorte de psalmodie funèbre, interrompue à intervalles égaux par des coups de tam-tams et de cymbales. Derrière eux, sur un char aux larges roues dont les rayons et la jante figuraient un entrelacement de serpents, apparut une statue hideuse, traînée par deux couples de zébus richement caparaçonnés. Cette statue avait quatre bras; le corps colorié d’un rouge sombre, les yeux hagards, les cheveux emmêlés, la langue pendante, les lèvres teintes de henné et de bétel. À son cou s’enroulait un collier de têtes de mort, à ses flancs une ceinture de mains coupées. Elle se tenait debout sur un géant terrassé auquel le chef manquait.



Sir Francis Cromarty reconnut cette statue.



«La déesse Kâli, murmura-t-il, la déesse de l’amour et de la mort.



– De la mort, j’y consens, mais de l’amour, jamais! dit Passepartout. La vilaine bonne femme!»



Le Parsi lui fit signe de se taire.



Autour de la statue s’agitait, se démenait, se convulsionnait un groupe de vieux fakirs, zébrés de bandes d’ocre, couverts d’incisions cruciales qui laissaient échapper leur sang goutte à goutte, énergumènes stupides qui, dans les grandes cérémonies indoues, se précipitent encore sous les roues du char de Jaggernaut.



Derrière eux, quelques brahmanes, dans toute la somptuosité de leur costume oriental, traînaient une femme qui se soutenait à peine.



Cette femme était jeune, blanche comme une Européenne. Sa tête, son cou, ses épaules, ses oreilles, ses bras, ses mains, ses orteils étaient surchargés de bijoux, colliers, bracelets, boucles et bagues. Une tunique lamée d’or, recouverte d’une mousseline légère, dessinait les contours de sa taille.



Derrière cette jeune femme – contraste violent pour les yeux –, des gardes armés de sabres nus passés à leur ceinture et de longs pistolets damasquinés, portaient un cadavre sur un palanquin.



C’était le corps d’un vieillard, revêtu de ses opulents habits de rajah, ayant, comme en sa vie, le turban brodé de perles, la robe tissue de soie et d’or, la ceinture de cachemire diamanté, et ses magnifiques armes de prince indien.



Puis des musiciens et une arrière-garde de fanatiques, dont les cris couvraient parfois l’assourdissant fracas des instruments, fermaient le cortège.



Sir Francis Cromarty regardait toute cette pompe d’un air singulièrement attristé, et se tournant vers le guide:



«Un sutty!» dit-il.



Le Parsi fit un signe affirmatif et mit un doigt sur ses lèvres. La longue procession se déroula lentement sous les arbres, et bientôt ses derniers rangs disparurent dans la profondeur de la forêt.



Peu à peu, les chants s’éteignirent. Il y eut encore quelques éclats de cris lointains, et enfin à tout ce tumulte succéda un profond silence.



Phileas Fogg avait entendu ce mot, prononcé par Sir Francis Cromarty, et aussitôt que la procession eut disparu:



«Qu’est-ce qu’un sutty? demanda-t-il.



– Un sutty, monsieur Fogg, répondit le brigadier général, c’est un sacrifice humain, mais un sacrifice volontaire. Cette femme que vous venez de voir sera brûlée demain aux premières heures du jour.



– Ah! les gueux! s’écria Passepartout, qui ne put retenir ce cri d’indignation.



– Et ce cadavre? demanda Mr. Fogg.



– C’est celui du prince, son mari, répondit le guide, un rajah indépendant du Bundelkund.



– Comment! reprit Phileas Fogg, sans que sa voix trahît la moindre émotion, ces barbares coutumes subsistent encore dans l’Inde, et les Anglais n’ont pu les détruire?



– Dans la plus grande partie de l’Inde, répondit Sir Francis Cromarty, ces sacrifices ne s’accomplissent plus, mais nous n’avons aucune influence sur ces contrées sauvages, et principalement sur ce territoire du Bundelkund. Tout le revers septentrional des Vindhias est le théâtre de meurtres et de pillages incessants.



– La malheureuse! murmurait Passepartout, brûlée vive!



– Oui, reprit le brigadier général, brûlée, et si elle ne l’était pas, vous ne sauriez croire à quelle misérable condition elle se verrait réduite par ses proches. On lui raserait les cheveux, on la nourrirait à peine de quelques poignées de riz, on la repousserait, elle serait considérée comme une créature immonde et mourrait dans quelque coin comme un chien galeux. Aussi la perspective de cette affreuse existence pousse-t-elle souvent ces malheureuses au supplice, bien plus que l’amour ou le fanatisme religieux. Quelquefois, cependant, le sacrifice est réellement volontaire, et il faut l’intervention énergique du gouvernement pour l’empêcher. Ainsi, il y a quelques années, je résidais à Bombay, quand une jeune veuve vint demander au gouverneur l’autorisation de se brûler avec le corps de son mari. Comme vous le pensez bien, le gouverneur refusa. Alors la veuve quitta la ville, se réfugia chez un rajah indépendant, et là elle consomma son sacrifice.»



Pendant le récit du brigadier général, le guide secouait la tête, et, quand le récit fut achevé:



«Le sacrifice qui aura lieu demain au lever du jour n’est pas volontaire, dit-il.



– Comment le savez-vous?



– C’est une histoire que tout le monde connaît dans le Bundelkund, répondit le guide.



– Cependant cette infortunée ne paraissait faire aucune résistance, fit observer Sir Francis Cromarty.



– Cela tient à ce qu’on l’a enivrée de la fumée du chanvre et de l’opium.



– Mais où la conduit-on?



– À la pagode de Pillaji, à deux milles d’ici. Là, elle passera la nuit en attendant l’heure du sacrifice.



– Et ce sacrifice aura lieu?…



– Demain, dès la première apparition du jour.»



Après cette réponse, le guide fit sortir l’éléphant de l’épais fourré et se hissa sur le cou de l’animal. Mais au moment où il allait l’exciter par un sifflement particulier, Mr. Fogg l’arrêta, et, s’adressant à Sir Francis Cromarty:



«Si nous sauvions cette femme? dit-il.



– Sauver cette femme, monsieur Fogg!… s’écria le brigadier général.



– J’ai encore douze heures d’avance. Je puis les consacrer à cela.



– Tiens! Mais vous êtes un homme de cœur! dit Sir Francis Cromarty.



– Quelquefois, répondit simplement Phileas Fogg. quand j’ai le temps.»




{{{XIII
_ DANS LEQUEL PASSEPARTOUT PROUVE UNE FOIS DE PLUS QUE LA FORTUNE SOURIT AUX AUDACIEUX}}}


Le dessein était hardi, hérissé de difficultés, impraticable peut-être Mr. Fogg allait risquer sa vie, ou tout au moins sa liberté, et par conséquent la réussite de ses projets, mais il n’hésita pas. Il trouva, d’ailleurs, dans Sir Francis Cromarty, un auxiliaire décidé.



Quant à Passepartout, il était prêt, on pouvait disposer de lui. L’idée de son maître l’exaltait. Il sentait un cœur, une âme sous cette enveloppe de glace. Il se prenait à aimer Phileas Fogg.



Restait le guide. Quel parti prendrait-il dans l’affaire? Ne serait-il pas porté pour les hindous? À défaut de son concours, il fallait au moins s’assurer sa neutralité.



Sir Francis Cromarty lui posa franchement la question.



«Mon officier, répondit le guide, je suis Parsi, et cette femme est Parsie. Disposez de moi.



– Bien, guide, répondit Mr. Fogg.



– Toutefois, sachez-le bien, reprit le Parsi, non seulement nous risquons notre vie, mais des supplices horribles, si nous sommes pris. Ainsi, voyez.



– C’est vu, répondit Mr. Fogg. Je pense que nous devrons attendre la nuit pour agir?



– Je le pense aussi», répondit le guide.



Ce brave Indou donna alors quelques détails sur la victime. C’était une Indienne d’une beauté célèbre, de race parsie, fille de riches négociants de Bombay. Elle avait reçu dans cette ville une éducation absolument anglaise, et à ses manières, à son instruction, on l’eût crue Européenne. Elle se nommait Aouda.



Orpheline, elle fut mariée malgré elle à ce vieux rajah du Bundelkund. Trois mois après, elle devint veuve. Sachant le sort qui l’attendait, elle s’échappa, fut reprise aussitôt, et les parents du rajah, qui avaient intérêt à sa mort, la vouèrent à ce supplice auquel il ne semblait pas qu’elle pût échapper.



Ce récit ne pouvait qu’enraciner Mr. Fogg et ses compagnons dans leur généreuse résolution. Il fut décidé que le guide dirigerait l’éléphant vers la pagode de Pillaji, dont il se rapprocherait autant que possible.



Une demi-heure après, halte fut faite sous un taillis, à cinq cents pas de la pagode, que l’on ne pouvait apercevoir; mais les hurlements des fanatiques se laissaient entendre distinctement.



Les moyens de parvenir jusqu’à la victime furent alors discutés. Le guide connaissait cette pagode de Pillaji, dans laquelle il affirmait que la jeune femme était emprisonnée. Pourrait-on y pénétrer par une des portes, quand toute la bande serait plongée dans le sommeil de l’ivresse, ou faudrait-il pratiquer un trou dans une muraille? C’est ce qui ne pourrait être décidé qu’au moment et au lieu mêmes. Mais ce qui ne fit aucun doute, c’est que l’enlèvement devait s’opérer cette nuit même, et non quand, le jour venu, la victime serait conduite au supplice. À cet instant, aucune intervention humaine n’eût pu la sauver.



Mr. Fogg et ses compagnons attendirent la nuit. Dès que l’ombre se fit, vers six heures du soir, ils résolurent d’opérer une reconnaissance autour de la pagode. Les derniers cris des fakirs s’éteignaient alors. Suivant leur habitude, ces Indiens devaient être plongés dans l’épaisse ivresse du «hang» – opium liquide, mélangé d’une infusion de chanvre –, et il serait peut-être possible de se glisser entre eux jusqu’au temple.



Le Parsi, guidant Mr. Fogg, Sir Francis Cromarty et Passepartout, s’avança sans bruit à travers la forêt. Après dix minutes de reptation sous les ramures, ils arrivèrent au bord d’une petite rivière, et là, à la lueur de torches de fer à la pointe desquelles brûlaient des résines, ils aperçurent un monceau de bois empilé. C’était le bûcher, fait de précieux santal, et déjà imprégné d’une huile parfumée. À sa partie supérieure reposait le corps embaumé du rajah, qui devait être brûlé en même temps que sa veuve. À cent pas de ce bûcher s’élevait la pagode, dont les minarets perçaient dans l’ombre la cime des arbres.



«Venez!» dit le guide à voix basse.



Et, redoublant de précaution, suivi de ses compagnons, il se glissa silencieusement à travers les grandes herbes.



Le silence n’était plus interrompu que par le murmure du vent dans les branches.



Bientôt le guide s’arrêta à l’extrémité d’une clairière. Quelques résines éclairaient la place. Le sol était jonché de groupes de dormeurs, appesantis par l’ivresse. On eût dit un champ de bataille couvert de morts. Hommes, femmes, enfants, tout était confondu. Quelques ivrognes râlaient encore çà et là.



À l’arrière-plan, entre la masse des arbres, le temple de Pillaji se dressait confusément. Mais au grand désappointement du guide, les gardes des rajahs, éclairés par des torches fuligineuses, veillaient aux portes et se promenaient, le sabre nu. On pouvait supposer qu’à l’intérieur les prêtres veillaient aussi.



Le Parsi ne s’avança pas plus loin. Il avait reconnu l’impossibilité de forcer l’entrée du temple, et il ramena ses compagnons en arrière.



Phileas Fogg et Sir Francis Cromarty avaient compris comme lui qu’ils ne pouvaient rien tenter de ce côté.



Ils s’arrêtèrent et s’entretinrent à voix basse.



«Attendons, dit le brigadier général, il n’est que huit heures encore, et il est possible que ces gardes succombent aussi au sommeil.



– Cela est possible, en effet», répondit le Parsi.



Phileas Fogg et ses compagnons s’étendirent donc au pied d’un arbre et attendirent.



Le temps leur parut long! Le guide les quittait parfois et allait observer la lisière du bois. Les gardes du rajah veillaient toujours à la lueur des torches, et une vague lumière filtrait à travers les fenêtres de la pagode.



On attendit ainsi jusqu’à minuit. La situation ne changea pas. Même surveillance au-dehors. Il était évident qu’on ne pouvait compter sur l’assoupissement des gardes. L’ivresse du «hang» leur avait été probablement épargnée. Il fallait donc agir autrement et pénétrer par une ouverture pratiquée aux murailles de la pagode. Restait la question de savoir si les prêtres veillaient auprès de leur victime avec autant de soin que les soldats à la porte du temple.



Après une dernière conversation, le guide se dit prêt à partir. Mr. Fogg, Sir Francis et Passepartout le suivirent. Ils firent un détour assez long, afin d’atteindre la pagode par son chevet.



Vers minuit et demi, ils arrivèrent au pied des murs sans avoir rencontré personne. Aucune surveillance n’avait été établie de ce côté, mais il est vrai de dire que fenêtres et portes manquaient absolument.



Là nuit était sombre. La lune, alors dans son dernier quartier, quittait à peine l’horizon, encombré de gros nuages. La hauteur des arbres accroissait encore l’obscurité.



Mais il ne suffisait pas d’avoir atteint le pied des murailles, il fallait encore y pratiquer une ouverture. Pour cette opération, Phileas Fogg et ses compagnons n’avaient absolument que leurs couteaux de poche. Très heureusement, les parois du temple se composaient d’un mélange de briques et de bois qui ne pouvait être difficile à percer. La première brique une fois enlevée, les autres viendraient facilement.



On se mit à la besogne, en faisant le moins de bruit possible. Le Parsi d’un côté, Passepartout, de l’autre, travaillaient à desceller les briques, de manière à obtenir une ouverture large de deux pieds.



Le travail avançait, quand un cri se fit entendre à l’intérieur du temple, et presque aussitôt d’autres cris lui répondirent du dehors.



Passepartout et le guide interrompirent leur travail. Les avait-on surpris? L’éveil était-il donné? La plus vulgaire prudence leur commandait de s’éloigner, – ce qu’ils firent en même temps que Phileas Fogg et sir Francis Cromarty. Ils se blottirent de nouveau sous le couvert du bois, attendant que l’alerte, si c’en était une, se fût dissipée, et prêts, dans ce cas, à reprendre leur opération.



Mais – contretemps funeste – des gardes se montrèrent au chevet de la pagode, et s’y installèrent de manière à empêcher toute approche.



Il serait difficile de décrire le désappointement de ces quatre hommes, arrêtés dans leur œuvre. Maintenant qu’ils ne pouvaient plus parvenir jusqu’à la victime, comment la sauveraient-ils? Sir Francis Cromarty se rongeait les poings. Passepartout était hors de lui, et le guide avait quelque peine à le contenir. L’impassible Fogg attendait sans manifester ses sentiments.



«N’avons-nous plus qu’à partir? demanda le brigadier général à voix basse.



– Nous n’avons plus qu’à partir, répondit le guide.



– Attendez, dit Fogg. Il suffit que je sois demain à Allahabad avant midi.



– Mais qu’espérez-vous? répondit Sir Francis Cromarty. Dans quelques heures le jour va paraître, et…



– La chance qui nous échappe peut se représenter au moment suprême.»



Le brigadier général aurait voulu pouvoir lire dans les yeux de Phileas Fogg.



Sur quoi comptait donc ce froid Anglais? Voulait-il, au moment du supplice, se précipiter vers la jeune femme et l’arracher ouvertement à ses bourreaux?



C’eût été une folie, et comment admettre que cet homme fût fou à ce point? Néanmoins, Sir Francis Cromarty consentit à attendre jusqu’au dénouement de cette terrible scène. Toutefois, le guide ne laissa pas ses compagnons à l’endroit où ils s’étaient réfugiés, et il les ramena vers la partie antérieure de la clairière. Là, abrités par un bouquet d’arbres, ils pouvaient observer les groupes endormis.



Cependant Passepartout, juché sur les premières branches d’un arbre, ruminait une idée qui avait d’abord traversé son esprit comme un éclair, et qui finit par s’incruster dans son cerveau.



Il avait commencé par se dire: «Quelle folie!» et maintenant il répétait: «Pourquoi pas, après tout? C’est une chance, peut-être la seule, et avec de tels abrutis!…»



En tout cas, Passepartout ne formula pas autrement sa pensée, mais il ne tarda pas à se glisser avec la souplesse d’un serpent sur les basses branches de l’arbre dont l’extrémité se courbait vers le sol.



Les heures s’écoulaient, et bientôt quelques nuances moins sombres annoncèrent l’approche du jour. Cependant l’obscurité était profonde encore.



C’était le moment. Il se fit comme une résurrection dans cette foule assoupie. Les groupes s’animèrent. Des coups de tam-tam retentirent. Chants et cris éclatèrent de nouveau. L’heure était venue à laquelle l’infortunée allait mourir.



En effet, les portes de la pagode s’ouvrirent. Une lumière plus vive s’échappa de l’intérieur. Mr. Fogg et Sir Francis Cromarty purent apercevoir la victime, vivement éclairée, que deux prêtres traînaient au-dehors. Il leur sembla même que, secouant l’engourdissement de l’ivresse par un suprême instinct de conservation, la malheureuse tentait d’échapper à ses bourreaux. Le cœur de Sir Francis Cromarty bondit, et par un mouvement convulsif, saisissant la main de Phileas Fogg, il sentit que cette main tenait un couteau ouvert.



En ce moment, la foule s’ébranla. La jeune femme était retombée dans cette torpeur provoquée par les fumées du chanvre. Elle passa à travers les fakirs, qui l’escortaient de leurs vociférations religieuses.



Phileas Fogg et ses compagnons, se mêlant aux derniers rangs de la foule, la suivirent.



Deux minutes après, ils arrivaient sur le bord de la rivière et s’arrêtaient à moins de cinquante pas du bûcher, sur lequel était couché le corps du rajah. Dans la demi-obscurité, ils virent la victime absolument inerte, étendue auprès du cadavre de son époux.



Puis une torche fut approchée et le bois imprégné d’huile, s’enflamma aussitôt.



À ce moment, Sir Francis Cromarty et le guide retinrent Phileas Fogg, qui dans un moment de folie généreuse, s’élançait vers le bûcher…



Mais Phileas Fogg les avait déjà repoussés, quand la scène changea soudain. Un cri de terreur s’éleva. Toute cette foule se précipita à terre, épouvantée.



Le vieux rajah n’était donc pas mort, qu’on le vît se redresser tout à coup, comme un fantôme, soulever la jeune femme dans ses bras, descendre du bûcher au milieu des tourbillons de vapeurs qui lui donnaient une apparence spectrale?



Les fakirs, les gardes, les prêtres, pris d’une terreur subite, étaient là, face à terre, n’osant lever les yeux et regarder un tel prodige!



La victime inanimée passa entre les bras vigoureux qui la portaient, et sans qu’elle parût leur peser. Mr. Fogg et Sir Francis Cromarty étaient demeurés debout. Le Parsi avait courbé la tête, et Passepartout, sans doute, n’était pas moins stupéfié!…



Ce ressuscité arriva ainsi près de l’endroit où se tenaient Mr. Fogg et Sir Francis Cromarty, et là, d’une voix brève:



«Filons!…» dit-il.



C’était Passepartout lui-même qui s’était glissé vers le bûcher au milieu de la fumée épaisse! C’était Passepartout qui, profitant de l’obscurité profonde encore, avait arraché la jeune femme à la mort! C’était Passepartout qui, jouant son rôle avec un audacieux bonheur, passait au milieu de l’épouvante générale!



Un instant après, tous quatre disparaissaient dans le bois, et l’éléphant les emportait d’un trot rapide. Mais des cris, des clameurs et même une balle, perçant le chapeau de Phileas Fogg, leur apprirent que la ruse était découverte.



En effet, sur le bûcher enflammé se détachait alors le corps du vieux rajah. Les prêtres, revenus de leur frayeur, avaient compris qu’un enlèvement venait de s’accomplir.



Aussitôt ils s’étaient précipités dans la forêt. Les gardes les avaient suivis. Une décharge avait eu lieu, mais les ravisseurs fuyaient rapidement, et, en quelques instants, ils se trouvaient hors de la portée des balles et des flèches.




{{{XIV
_ DANS LEQUEL PHILEAS FOGG DESCEND TOUTE L’ADMIRABLE VALLÉE DU GANGE SANS MÊME SONGER À LA VOIR}}}


Le hardi enlèvement avait réussi. Une heure après, Passepartout riait encore de son succès. Sir Francis Cromarty avait serré la main de l’intrépide garçon. Son maître lui avait dit: «Bien», ce qui, dans la bouche de ce gentleman, équivalait à une haute approbation. À quoi Passepartout avait répondu que tout l’honneur de l’affaire appartenait à son maître. Pour lui, il n’avait eu qu’une idée «drôle», et il riait en songeant que, pendant quelques instants, lui, Passepartout, ancien gymnaste, ex-sergent de pompiers, avait été le veuf d’une charmante femme, un vieux rajah embaumé!



Quant à la jeune Indienne, elle n’avait pas eu conscience de ce qui s’était passé. Enveloppée dans les couvertures de voyage, elle reposait sur l’un des cacolets.



Cependant l’éléphant, guidé avec une extrême sûreté par le Parsi, courait rapidement dans la forêt encore obscure. Une heure après avoir quitté la pagode de Pillaji, il se lançait à travers une immense plaine. À sept heures, on fit halte. La jeune femme était toujours dans une prostration complète. Le guide lui fit boire quelques gorgées d’eau et de brandy, mais cette influence stupéfiante qui l’accablait devait se prolonger quelque temps encore.



Sir Francis Cromarty, qui connaissait les effets de l’ivresse produite par l’inhalation des vapeurs du chanvre, n’avait aucune inquiétude sur son compte.



Mais si le rétablissement de la jeune Indienne ne fit pas question dans l’esprit du brigadier général, celui-ci se montrait moins rassuré pour l’avenir. Il n’hésita pas à dire à Phileas Fogg que si Mrs. Aouda restait dans l’Inde, elle retomberait inévitablement entre les mains de ses bourreaux. Ces énergumènes se tenaient dans toute la péninsule, et certainement, malgré la police anglaise, ils sauraient reprendre leur victime, fût-ce à Madras, à Bombay, à Calcutta. Et Sir Francis Cromarty citait, à l’appui de ce dire, un fait de même nature qui s’était passé récemment. À son avis, la jeune femme ne serait véritablement en sûreté qu’après avoir quitté l’Inde.



Phileas Fogg répondit qu’il tiendrait compte de ces observations et qu’il aviserait.

Vers dix heures, le guide annonçait la station d’Allahabad. Là reprenait la voie interrompue du chemin de fer, dont les trains franchissent, en moins d’un jour et d’une nuit, la distance qui sépare Allahabad de Calcutta.



Phileas Fogg devait donc arriver à temps pour prendre un paquebot qui ne partait que le lendemain seulement, 25 octobre, à midi, pour Hong-Kong.



La jeune femme fut déposée dans une chambre de la gare. Passepartout fut chargé d’aller acheter pour elle divers objets de toilette, robe, châle, fourrures, etc., ce qu’il trouverait. Son maître lui ouvrait un crédit illimité.



Passepartout partit aussitôt et courut les rues de la ville. Allahabad, c’est la cité de Dieu, l’une des plus vénérées de l’Inde, en raison de ce qu’elle est bâtie au confluent de deux fleuves sacrés, le Gange et la Jumna, dont les eaux attirent les pèlerins de toute la péninsule. On sait d’ailleurs que, suivant les légendes du Ramayana, le Gange prend sa source dans le ciel, d’où, grâce à Brahma, il descend sur la terre.



Tout en faisant ses emplettes, Passepartout eut bientôt vu la ville, autrefois défendue par un fort magnifique qui est devenu une prison d’État. Plus de commerce, plus d’industrie dans cette cité, jadis industrielle et commerçante. Passepartout, qui cherchait vainement un magasin de nouveautés, comme s’il eût été dans Regent-street à quelques pas de Farmer et Co., ne trouva que chez un revendeur, vieux juif difficultueux, les objets dont il avait besoin, une robe en étoffe écossaise, un vaste manteau, et une magnifique pelisse en peau de loutre qu’il n’hésita pas à payer soixante-quinze livres (1 875 F). Puis, tout triomphant, il retourna à la gare.



Mrs. Aouda commençait à revenir à elle. Cette influence à laquelle les prêtres de Pillaji l’avaient soumise se dissipait peu à peu, et ses beaux yeux reprenaient toute leur douceur indienne.



Lorsque le roi-poète, Uçaf Uddaul, célèbre les charmes de la reine d’Ahméhnagara, il s’exprime ainsi:



«Sa luisante chevelure, régulièrement divisée en deux parts, encadre les contours harmonieux de ses joues délicates et blanches, brillantes de poli et de fraîcheur. Ses sourcils d’ébène ont la forme et la puissance de l’arc de Kama, dieu d’amour, et sous ses longs cils soyeux, dans la pupille noire de ses grands yeux limpides, nagent comme dans les lacs sacrés de l’Himalaya les reflets les plus purs de la lumière céleste. Fines, égales et blanches, ses dents resplendissent entre ses lèvres souriantes, comme des gouttes de rosée dans le sein mi-clos d’une fleur de grenadier. Ses oreilles mignonnes aux courbes symétriques, ses mains vermeilles, ses petits pieds bombés et tendres comme les bourgeons du lotus, brillent de l’éclat des plus belles perles de Ceylan, des plus beaux diamants de Golconde. Sa mince et souple ceinture, qu’une main suffit à enserrer, rehausse l’élégante cambrure de ses reins arrondis et la richesse de son buste où la jeunesse en fleur étale ses plus parfaits trésors, et, sous les plis soyeux de sa tunique, elle semble avoir été modelée en argent pur de la main divine de Vicvacarma, l’éternel statuaire.»



Mais, sans toute cette amplification, il suffit de dire que Mrs. Aouda, la veuve du rajah du Bundelkund, était une charmante femme dans toute l’acception européenne du mot. Elle parlait l’anglais avec une grande pureté, et le guide n’avait point exagéré en affirmant que cette jeune Parsie avait été transformée par l’éducation.



Cependant le train allait quitter la station d’Allahabad. Le Parsi attendait. Mr. Fogg lui régla son salaire au prix convenu, sans le dépasser d’un farthing. Ceci étonna un peu Passepartout, qui savait tout ce que son maître devait au dévouement du guide. Le Parsi avait, en effet, risqué volontairement sa vie dans l’affaire de Pillaji, et si, plus tard, les Indous l’apprenaient, il échapperait difficilement à leur vengeance.



Restait aussi la question de Kiouni. Que ferait-on d’un éléphant acheté si cher?



Mais Phileas Fogg avait déjà pris une résolution à cet égard.



«Parsi, dit-il au guide, tu as été serviable et dévoué. J’ai payé ton service, mais non ton dévouement. Veux-tu cet éléphant? Il est à toi.»



Les yeux du guide brillèrent.



«C’est une fortune que Votre Honneur me donne! s’écria-t-il.



– Accepte, guide, répondit Mr. Fogg, et c’est moi qui serai encore ton débiteur.



– À la bonne heure! s’écria Passepartout. Prends, ami! Kiouni est un brave et courageux animal!»



Et, allant à la bête, il lui présenta quelques morceaux de sucre, disant:



«Tiens, Kiouni, tiens, tiens!»



L’éléphant fit entendre quelques grognements de satisfaction. Puis, prenant Passepartout par la ceinture et l’enroulant de sa trompe, il l’enleva jusqu’à la hauteur de sa tête. Passepartout, nullement effrayé, fit une bonne caresse à l’animal, qui le replaça doucement à terre, et, à la poignée de trompe de l’honnête Kiouni, répondit une vigoureuse poignée de main de l’honnête garçon.



Quelques instants après, Phileas Fogg, Sir Francis Cromarty et Passepartout, installés dans un confortable wagon dont Mrs. Aouda occupait la meilleure place, couraient à toute vapeur vers Bénarès.



Quatre-vingts milles au plus séparent cette ville d’Allahabad, et ils furent franchis en deux heures.



Pendant ce trajet, la jeune femme revint complètement à elle; les vapeurs assoupissantes du hang se dissipèrent.



Quel fut son étonnement de se trouver sur le railway, dans ce compartiment, recouverte de vêtements européens, au milieu de voyageurs qui lui étaient absolument inconnus!



Tout d’abord, ses compagnons lui prodiguèrent leurs soins et la ranimèrent avec quelques gouttes de liqueur; puis le brigadier général lui raconta son histoire. Il insista sur le dévouement de Phileas Fogg, qui n’avait pas hésité à jouer sa vie pour la sauver, et sur le dénouement de l’aventure, dû à l’audacieuse imagination de Passepartout.



Mr. Fogg laissa dire sans prononcer une parole. Passepartout, tout honteux, répétait que «ça n’en valait pas la peine»!



Mrs. Aouda remercia ses sauveurs avec effusion, par ses larmes plus que par ses paroles. Ses beaux yeux, mieux que ses lèvres, furent les interprètes de sa reconnaissance. Puis, sa pensée la reportant aux scènes du sutty, ses regards revoyant cette terre indienne où tant de dangers l’attendaient encore, elle fut prise d’un frisson de terreur.



Phileas Fogg comprit ce qui se passait dans l’esprit de Mrs. Aouda, et, pour la rassurer, il lui offrit, très froidement d’ailleurs, de la conduire à Hong-Kong, où elle demeurerait jusqu’à ce que cette affaire fût assoupie.



Mrs. Aouda accepta l’offre avec reconnaissance. Précisément, à Hong-Kong, résidait un de ses parents, Parsi comme elle, et l’un des principaux négociants de cette ville, qui est absolument anglaise, tout en occupant un point de la côte chinoise.



À midi et demi, le train s’arrêtait à la station de Bénarès. Les légendes brahmaniques affirment que cette ville occupe l’emplacement de l’ancienne Casi, qui était autrefois suspendue dans l’espace, entre le zénith et le nadir, comme la tombe de Mahomet. Mais, à cette époque plus réaliste, Bénarès, Athènes de l’Inde au dire des orientalistes, reposait tout prosaïquement sur le sol, et Passepartout put un instant entrevoir ses maisons de briques, ses huttes en clayonnage, qui lui donnaient un aspect absolument désolé, sans aucune couleur locale.



C’était là que devait s’arrêter Sir Francis Cromarty. Les troupes qu’il rejoignait campaient à quelques milles au nord de la ville. Le brigadier général fit donc ses adieux à Phileas Fogg, lui souhaitant tout le succès possible, et exprimant le vœu qu’il recommençât ce voyage d’une façon moins originale, mais plus profitable. Mr. Fogg pressa légèrement les doigts de son compagnon. Les compliments de Mrs. Aouda furent plus affectueux. Jamais elle n’oublierait ce qu’elle devait à Sir Francis Cromarty. Quant à Passepartout, il fut honoré d’une vraie poignée de main de la part du brigadier général. Tout ému, il se demanda où et quand il pourrait bien se dévouer pour lui. Puis on se sépara.



À partir de Bénarès, la voie ferrée suivait en partie la vallée du Gange. À travers les vitres du wagon, par un temps assez clair, apparaissait le paysage varié du Béhar, puis des montagnes couvertes de verdure, les champs d’orge, de maïs et de froment, des rios et des étangs peuplés d’alligators verdâtres, des villages bien entretenus, des forêts encore verdoyantes. Quelques éléphants, des zébus à grosse bosse venaient se baigner dans les eaux du fleuve sacré, et aussi, malgré la saison avancée et la température déjà froide, des bandes d’Indous des deux sexes, qui accomplissaient pieusement leurs saintes ablutions. Ces fidèles, ennemis acharnés du bouddhisme, sont sectateurs fervents de la religion brahmanique, qui s’incarne en ces trois personnes: Whisnou, la divinité solaire, Shiva, la personnification divine des forces naturelles, et Brahma, le maître suprême des prêtres et des législateurs. Mais de quel œil Brahma, Shiva et Whisnou devaient-ils considérer cette Inde, maintenant «britannisée», lorsque quelque steam-boat passait en hennissant et troublait les eaux consacrées du Gange, effarouchant les mouettes qui volaient à sa surface, les tortues qui pullulaient sur ses bords, et les dévots étendus au long de ses rives!



Tout ce panorama défila comme un éclair, et souvent un nuage de vapeur blanche en cacha les détails. À peine les voyageurs purent-ils entrevoir le fort de Chunar, à vingt milles au sud-est de Bénarès, ancienne forteresse des rajahs du Béhar, Ghazepour et ses importantes fabriques d’eau de rose, le tombeau de Lord Cornwallis qui s’élève sur la rive gauche du Gange, la ville fortifiée de Buxar, Patna, grande cité industrielle et commerçante, où se tient le principal marché d’opium de l’Inde, Monghir, ville plus qu’européenne, anglaise comme Manchester ou Birmingham, renommée pour ses fonderies de fer, ses fabriques de taillanderie et d’armes blanches, et dont les hautes cheminées encrassaient d’une fumée noire le ciel de Brahma, – un véritable coup de poing dans le pays du rêve!



Puis la nuit vint et, au milieu des hurlements des tigres, des ours, des loups qui fuyaient devant la locomotive, le train passa à toute vitesse, et on n’aperçut plus rien des merveilles du Bengale, ni Golgonde, ni Gour en ruine, ni Mourshedabad, qui fut autrefois capitale, ni Burdwan, ni Hougly, ni Chandernagor, ce point français du territoire indien sur lequel Passepartout eût été fier de voir flotter le drapeau de sa patrie!



Enfin, à sept heures du matin, Calcutta était atteint. Le paquebot, en partance pour Hong-Kong, ne levait l’ancre qu’à midi. Phileas Fogg avait donc cinq heures devant lui.



D’après son itinéraire, ce gentleman devait arriver dans la capitale des Indes le 25 octobre, vingt-trois jours après avoir quitté Londres, et il y arrivait au jour fixé. Il n’avait donc ni retard ni avance. Malheureusement, les deux jours gagnés par lui entre Londres et Bombay avaient été perdus, on sait comment, dans cette traversée de la péninsule indienne, – mais il est à supposer que Phileas Fogg ne les regrettait pas.




{{{XV
_ OÙ LE SAC AUX BANK-NOTES S’ALLÈGE ENCORE DE QUELQUES MILLIERS DE LIVRES}}}


Le train s’était arrêté en gare. Passepartout descendit le premier du wagon, et fut suivi de Mr. Fogg, qui aida sa jeune compagne à mettre pied sur le quai. Phileas Fogg comptait se rendre directement au paquebot de Hong-Kong, afin d’y installer confortablement Mrs. Aouda, qu’il ne voulait pas quitter, tant qu’elle serait en ce pays si dangereux pour elle.



Au moment où Mr. Fogg allait sortir de la gare, un policeman s’approcha de lui et dit:



«Monsieur Phileas Fogg?



– C’est moi.



– Cet homme est votre domestique? ajouta le policeman en désignant Passepartout.



– Oui.



– Veuillez me suivre tous les deux.»



Mr. Fogg ne fit pas un mouvement qui pût marquer en lui une surprise quelconque. Cet agent était un représentant de la loi, et, pour tout Anglais, la loi est sacrée. Passepartout, avec ses habitudes françaises, voulut raisonner, mais le policeman le toucha de sa baguette, et Phileas Fogg lui fit signe d’obéir.



«Cette jeune dame peut nous accompagner? demanda Mr. Fogg.



– Elle le peut», répondit le policeman.



Le policeman conduisit Mr. Fogg, Mrs. Aouda et Passepartout vers un palki-ghari, sorte de voiture à quatre roues et à quatre places, attelée de deux chevaux. On partit. Personne ne parla pendant le trajet, qui dura vingt minutes environ.



La voiture traversa d’abord la «ville noire», aux rues étroites, bordées de cahutes dans lesquelles grouillait une population cosmopolite, sale et déguenillée; puis elle passa à travers la ville européenne, égayée de maisons de briques, ombragée de cocotiers, hérissée de mâtures, que parcouraient déjà, malgré l’heure matinale, des cavaliers élégants et de magnifiques attelages.



Le palki-ghari s’arrêta devant une habitation d’apparence simple, mais qui ne devait pas être affectée aux usages domestiques. Le policeman fit descendre ses prisonniers – on pouvait vraiment leur donner ce nom –, et il les conduisit dans une chambre aux fenêtres grillées, en leur disant:



«C’est à huit heures et demie que vous comparaîtrez devant le juge Obadiah.»



Puis il se retira et ferma la porte.



«Allons! nous sommes pris!» s’écria Passepartout, en se laissant aller sur une chaise.



Mrs. Aouda, s’adressant aussitôt à Mr. Fogg, lui dit d’une voix dont elle cherchait en vain à déguiser l’émotion:



«Monsieur, il faut m’abandonner! C’est pour moi que vous êtes poursuivi! C’est pour m’avoir sauvée!»



Phileas Fogg se contenta de répondre que cela n’était pas possible. Poursuivi pour cette affaire du sutty! Inadmissible! Comment les plaignants oseraient-ils se présenter? Il y avait méprise. Mr. Fogg ajouta que, dans tous les cas, il n’abandonnerait pas la jeune femme, et qu’il la conduirait à Hong-Kong.



«Mais le bateau part à midi! fit observer Passepartout.



– Avant midi nous serons à bord», répondit simplement l’impassible gentleman.



Cela fut affirmé si nettement, que Passepartout ne put s’empêcher de se dire à lui-même:



«Parbleu! cela est certain! avant midi nous serons à bord!» Mais il n’était pas rassuré du tout.



À huit heures et demie, la porte de la chambre s’ouvrit. Le policeman reparut, et il introduisit les prisonniers dans la salle voisine. C’était une salle d’audience, et un public assez nombreux, composé d’Européens et d’indigènes, en occupait déjà le prétoire.



Mr. Fogg, Mrs. Aouda et Passepartout s’assirent sur un banc en face des sièges réservés au magistrat et au greffier.



Ce magistrat, le juge Obadiah, entra presque aussitôt, suivi du greffier. C’était un gros homme tout rond. Il décrocha une perruque pendue à un clou et s’en coiffa lestement.



«La première cause», dit-il.



Mais, portant la main à sa tête:



«Hé! ce n’est pas ma perruque!



– En effet, monsieur Obadiah, c’est la mienne, répondit le greffier.



– Cher monsieur Oysterpuf, comment voulez-vous qu’un juge puisse rendre une bonne sentence avec la perruque d’un greffier!»



L’échange des perruques fut fait. Pendant ces préliminaires, Passepartout bouillait d’impatience, car l’aiguille lui paraissait marcher terriblement vite sur le cadran de la grosse horloge du prétoire.



«La première cause, reprit alors le juge Obadiah.



– Phileas Fogg? dit le greffier Oysterpuf.



– Me voici, répondit Mr. Fogg.



– Passepartout?



– Présent! répondit Passepartout.



– Bien! dit le juge Obadiah. Voilà deux jours, accusés, que l’on vous guette à tous les trains de Bombay.



– Mais de quoi nous accuse-t-on? s’écria Passepartout, impatienté.



– Vous allez le savoir, répondit le juge.



– Monsieur, dit alors Mr. Fogg, je suis citoyen anglais, et j’ai droit…



– Vous a-t-on manqué d’égards? demanda Mr. Obadiah.



– Aucunement.



– Bien! faites entrer les plaignants.»



Sur l’ordre du juge, une porte s’ouvrit, et trois prêtres indous furent introduits par un huissier.



«C’est bien cela! murmura Passepartout, ce sont ces coquins qui voulaient brûler notre jeune dame!»



Les prêtres se tinrent debout devant le juge, et le greffier lut à haute voix une plainte en sacrilège, formulée contre le sieur Phileas Fogg et son domestique, accusés d’avoir violé un lieu consacré par la religion brahmanique.



«Vous avez entendu? demanda le juge à Phileas Fogg.



– Oui, monsieur, répondit Mr. Fogg en consultant sa montre, et j’avoue.



– Ah! vous avouez?…



– J’avoue et j’attends que ces trois prêtres avouent à leur tour ce qu’ils voulaient faire à la pagode de Pillaji.»



Les prêtres se regardèrent. Ils semblaient ne rien comprendre aux paroles de l’accusé.



«Sans doute! s’écria impétueusement Passepartout, à cette pagode de Pillaji, devant laquelle ils allaient brûler leur victime!»



Nouvelle stupéfaction des prêtres, et profond étonnement du juge Obadiah.



«Quelle victime? demanda-t-il. Brûler qui! En pleine ville de Bombay?



– Bombay? s’écria Passepartout.



– Sans doute. Il ne s’agit pas de la pagode de Pillaji, mais de la pagode de Malebar-Hill, à Bombay.



– Et comme pièce de conviction, voici les souliers du profanateur, ajouta le greffier, en posant une paire de chaussures sur son bureau.



– Mes souliers!» s’écria Passepartout, qui, surpris au dernier chef, ne put retenir cette involontaire exclamation.



On devine la confusion qui s’était opérée dans l’esprit du maître et du domestique. Cet incident de la pagode de Bombay, ils l’avaient oublié, et c’était celui-là même qui les amenait devant le magistrat de Calcutta.



En effet, l’agent Fix avait compris tout le parti qu’il pouvait tirer de cette malencontreuse affaire. Retardant son départ de douze heures, il s’était fait le conseil des prêtres de Malebar-Hill; il leur avait promis des dommages-intérêts considérables, sachant bien que le gouvernement anglais se montrait très sévère pour ce genre de délit; puis, par le train suivant, il les avait lancés sur les traces du sacrilège. Mais, par suite du temps employé à la délivrance de la jeune veuve, Fix et les Indous arrivèrent à Calcutta avant Phileas Fogg et son domestique, que les magistrats, prévenus par dépêche, devaient arrêter à leur descente du train. Que l’on juge du désappointement de Fix, quand il apprit que Phileas Fogg n’était point encore arrivé dans la capitale de l’Inde. Il dut croire que son voleur, s’arrêtant à une des stations du Peninsular-railway, s’était réfugié dans les provinces septentrionales. Pendant vingt-quatre heures, au milieu de mortelles inquiétudes, Fix le guetta à la gare. Quelle fut donc sa joie quand, ce matin même, il le vit descendre du wagon, en compagnie, il est vrai, d’une jeune femme dont il ne pouvait s’expliquer la présence. Aussitôt il lança sur lui un policeman, et voilà comment Mr. Fogg, Passepartout et la veuve du rajah du Bundelkund furent conduits devant le juge Obadiah.



Et si Passepartout eût été moins préoccupé de son affaire, il aurait aperçu, dans un coin du prétoire, le détective, qui suivait le débat avec un intérêt facile à comprendre, – car à Calcutta, comme à Bombay, comme à Suez, le mandat d’arrestation lui manquait encore!



Cependant le juge Obadiah avait pris acte de l’aveu échappé à Passepartout, qui aurait donné tout ce qu’il possédait pour reprendre ses imprudentes paroles.



«Les faits sont avoués? dit le juge.



– Avoués, répondit froidement Mr. Fogg.



– Attendu, reprit le juge, attendu que la loi anglaise entend protéger également et rigoureusement toutes les religions des populations de l’Inde, le délit étant avoué par le sieur Passepartout, convaincu d’avoir violé d’un pied sacrilège le pavé de la pagode de Malebar-Hill, à Bombay, dans la journée du 20 octobre, condamne ledit Passepartout à quinze jours de prison et à une amende de trois cents livres (7 500 F).



– Trois cents livres? s’écria Passepartout, qui n’était véritablement sensible qu’à l’amende.



– Silence! fit l’huissier d’une voix glapissante.



– Et, ajouta le juge Obadiah, attendu qu’il n’est pas matériellement prouvé qu’il n’y ait pas connivence entre le domestique et le maître, qu’en tout cas celui-ci doit être tenu responsable des gestes d’un serviteur à ses gages, retient ledit Phileas Fogg et le condamne à huit jours de prison et cent cinquante livres d’amende. Greffier, appelez une autre cause!»



Fix, dans son coin, éprouvait une indicible satisfaction. Phileas Fogg retenu huit jours à Calcutta, c’était plus qu’il n’en fallait pour donner au mandat le temps de lui arriver.



Passepartout était abasourdi. Cette condamnation ruinait son maître. Un pari de vingt mille livres perdu, et tout cela parce que, en vrai badaud, il était entré dans cette maudite pagode!



Phileas Fogg, aussi maître de lui que si cette condamnation ne l’eût pas concerné, n’avait pas même froncé le sourcil. Mais au moment où le greffier appelait une autre cause, il se leva et dit:



«J’offre caution.



– C’est votre droit», répondit le juge.



Fix se sentit froid dans le dos, mais il reprit son assurance, quand il entendit le juge, «attendu la qualité d’étrangers de Phileas Fogg et de son domestique», fixer la caution pour chacun d’eux à la somme énorme de mille livres (25 000 F).



C’était deux mille livres qu’il en coûterait à Mr. Fogg, s’il ne purgeait pas sa condamnation.



«Je paie», dit ce gentleman.



Et du sac que portait Passepartout, il retira un paquet de bank-notes qu’il déposa sur le bureau du greffier.



«Cette somme vous sera restituée à votre sortie de prison, dit le juge. En attendant, vous êtes libres sous caution.



– Venez, dit Phileas Fogg à son domestique.



– Mais, au moins, qu’ils rendent les souliers!» s’écria Passepartout avec un mouvement de rage.



On lui rendit ses souliers.



«En voilà qui coûtent cher! murmura-t-il. Plus de mille livres chacun! Sans compter qu’ils me gênent!»



Passepartout, absolument piteux, suivit Mr. Fogg, qui avait offert son bras à la jeune femme. Fix espérait encore que son voleur ne se déciderait jamais à abandonner cette somme de deux mille livres et qu’il ferait ses huit jours de prison. Il se jeta donc sur les traces de Fogg.



Mr. Fogg prit une voiture, dans laquelle Mrs. Aouda, Passepartout et lui montèrent aussitôt. Fix courut derrière la voiture, qui s’arrêta bientôt sur l’un des quais de la ville.



À un demi-mille en rade, le {Rangoon} était mouillé, son pavillon de partance hissé en tête de mât. Onze heures sonnaient. Mr. Fogg était en avance d’une heure. Fix le vit descendre de voiture et s’embarquer dans un canot avec Mrs. Aouda et son domestique. Le détective frappa la terre du pied.



«Le gueux! s’écria-t-il, il part! Deux mille livres sacrifiées! Prodigue comme un voleur! Ah! je le filerai jusqu’au bout du monde s’il le faut; mais du train dont il va, tout l’argent du vol y aura passé!»



L’inspecteur de police était fondé à faire cette réflexion. En effet, depuis qu’il avait quitté Londres, tant en frais de voyage qu’en primes, en achat d’éléphant, en cautions et en amendes, Phileas Fogg avait déjà semé plus de cinq mille livres (125 000 F) sur sa route, et le tant pour cent de la somme recouvrée, attribué aux détectives, allait diminuant toujours.




{{{XVI
_ OÙ FIX N’A PAS L’AIR DE CONNAÎTRE DU TOUT LES CHOSES DONT ON LUI PARLE}}}


Le {Rangoon}, l’un des paquebots que la Compagnie péninsulaire et orientale emploie au service des mers de la Chine et du Japon, était un steamer en fer, à hélice, jaugeant brut dix-sept cent soixante-dix tonnes, et d’une force nominale de quatre cents chevaux. Il égalait le {Mongolia} en vitesse, mais non en confortable. Aussi Mrs. Aouda ne fut-elle point aussi bien installée que l’eût désiré Phileas Fogg. Après tout, il ne s’agissait que d’une traversée de trois mille cinq cents milles, soit de onze à douze jours, et la jeune femme ne se montra pas une difficile passagère.



Pendant les premiers jours de cette traversée, Mrs. Aouda fit plus ample connaissance avec Phileas Fogg. En toute occasion, elle lui témoignait la plus vive reconnaissance. Le flegmatique gentleman l’écoutait, en apparence au moins, avec la plus extrême froideur, sans qu’une intonation, un geste décelât en lui la plus légère émotion. Il veillait à ce que rien ne manquât à la jeune femme. À de certaines heures il venait régulièrement, sinon causer, du moins l’écouter. Il accomplissait envers elle les devoirs de la politesse la plus stricte, mais avec la grâce et l’imprévu d’un automate dont les mouvements auraient été combinés pour cet usage. Mrs. Aouda ne savait trop que penser, mais Passepartout lui avait un peu expliqué l’excentrique personnalité de son maître. Il lui avait appris quelle gageure entraînait ce gentleman autour du monde. Mrs. Aouda avait souri; mais après tout, elle lui devait la vie, et son sauveur ne pouvait perdre à ce qu’elle le vît à travers sa reconnaissance.



Mrs. Aouda confirma le récit que le guide indou avait fait de sa touchante histoire. Elle était, en effet, de cette race qui tient le premier rang parmi les races indigènes. Plusieurs négociants parsis ont fait de grandes fortunes aux Indes, dans le commerce des cotons. L’un d’eux, Sir James Jejeebhoy, a été anobli par le gouvernement anglais, et Mrs. Aouda était parente de ce riche personnage qui habitait Bombay. C’était même un cousin de Sir Jejeebhoy, l’honorable Jejeeh, qu’elle comptait rejoindre à Hong-Kong. Trouverait-elle près de lui refuge et assistance? Elle ne pouvait l’affirmer. À quoi Mr. Fogg répondait qu’elle n’eût pas à s’inquiéter, et que tout s’arrangerait mathématiquement! Ce fut son mot.



La jeune femme comprenait-elle cet horrible adverbe? On ne sait. Toutefois, ses grands yeux se fixaient sur ceux de Mr. Fogg, ses grands yeux «limpides comme les lacs sacrés de l’Himalaya»! Mais l’intraitable Fogg, aussi boutonné que jamais, ne semblait point homme à se jeter dans ce lac.



Cette première partie de la traversée du {Rangoon} s’accomplit dans des conditions excellentes. Le temps était maniable. Toute cette portion de l’immense baie que les marins appellent les «brasses du Bengale» se montra favorable à la marche du paquebot. Le {Rangoon} eut bientôt connaissance du Grand-Andaman, la principale du groupe, que sa pittoresque montagne de Saddle-Peak, haute de deux mille quatre cents pieds, signale de fort loin aux navigateurs.



La côte fut prolongée d’assez près. Les sauvages Papouas de l’île ne se montrèrent point. Ce sont des êtres placés au dernier degré de l’échelle humaine, mais dont on fait à tort des anthropophages.



Le développement panoramique de ces îles était superbe. D’immenses forêts de lataniers, d’arecs, de bambousiers, de muscadiers, de tecks, de gigantesques mimosées, de fougères arborescentes, couvraient le pays en premier plan, et en arrière se profilait l’élégante silhouette des montagnes. Sur la côte pullulaient par milliers ces précieuses salanganes, dont les nids comestibles forment un mets recherché dans le Céleste Empire. Mais tout ce spectacle varié, offert aux regards par le groupe des Andaman, passa vite, et le {Rangoon} s’achemina rapidement vers le détroit de Malacca, qui devait lui donner accès dans les mers de la Chine.

Que faisait pendant cette traversée l’inspecteur Fix, si malencontreusement entraîné dans un voyage de circumnavigation? Au départ de Calcutta, après avoir laissé des instructions pour que le mandat, s’il arrivait enfin, lui fût adressé à Hong-Kong, il avait pu s’embarquer à bord du {Rangoon} sans avoir été aperçu de Passepartout, et il espérait bien dissimuler sa présence jusqu’à l’arrivée du paquebot. En effet, il lui eût été difficile d’expliquer pourquoi il se trouvait à bord, sans éveiller les soupçons de Passepartout, qui devait le croire à Bombay. Mais il fut amené à renouer connaissance avec l’honnête garçon par la logique même des circonstances. Comment? On va le voir.



Toutes les espérances, tous les désirs de l’inspecteur de police, étaient maintenant concentrés sur un unique point du monde, Hong-Kong, car le paquebot s’arrêtait trop peu de temps à Singapore pour qu’il pût opérer en cette ville. C’était donc à Hong-Kong que l’arrestation du voleur devait se faire, ou le voleur lui échappait, pour ainsi dire, sans retour.



En effet, Hong-Kong était encore une terre anglaise, mais la dernière qui se rencontrât sur le parcours. Au-delà, la Chine, le Japon, l’Amérique offraient un refuge à peu près assuré au sieur Fogg. À Hong-Kong, s’il y trouvait enfin le mandat d’arrestation qui courait évidemment après lui, Fix arrêtait Fogg et le remettait entre les mains de la police locale. Nulle difficulté. Mais après Hong-Kong, un simple mandat d’arrestation ne suffirait plus. Il faudrait un acte d’extradition. De là retards, lenteurs, obstacles de toute nature, dont le coquin profiterait pour échapper définitivement. Si l’opération manquait à Hong-Kong, il serait, sinon impossible, du moins bien difficile, de la reprendre avec quelque chance de succès.



«Donc, se répétait Fix pendant ces longues heures qu’il passait dans sa cabine, donc, ou le mandat sera à Hong-Kong, et j’arrête mon homme, ou il n’y sera pas, et cette fois il faut à tout prix que je retarde son départ! J’ai échoué à Bombay, j’ai échoué à Calcutta! Si je manque mon coup à Hong-Kong, je suis perdu de réputation! Coûte que coûte, il faut réussir. Mais quel moyen employer pour retarder, si cela est nécessaire, le départ de ce maudit Fogg?»



En dernier ressort, Fix était bien décidé à tout avouer à Passepartout, à lui faire connaître ce maître qu’il servait et dont il n’était certainement pas le complice. Passepartout, éclairé par cette révélation, devant craindre d’être compromis, se rangerait sans doute à lui, Fix. Mais enfin c’était un moyen hasardeux, qui ne pouvait être employé qu’à défaut de tout autre. Un mot de Passepartout à son maître eût suffi à compromettre irrévocablement l’affaire.



L’inspecteur de police était donc extrêmement embarrassé, quand la présence de Mrs. Aouda à bord du {Rangoon}, en compagnie de Phileas Fogg, lui ouvrit de nouvelles perspectives.



Quelle était cette femme? Quel concours de circonstances en avait fait la compagne de Fogg? C’était évidemment entre Bombay et Calcutta que la rencontre avait eu lieu. Mais en quel point de la péninsule? Était-ce le hasard qui avait réuni Phileas Fogg et la jeune voyageuse? Ce voyage à travers l’Inde, au contraire, n’avait-il pas été entrepris par ce gentleman dans le but de rejoindre cette charmante personne? car elle était charmante! Fix l’avait bien vu dans la salle d’audience du tribunal de Calcutta.



On comprend à quel point l’agent devait être intrigué. Il se demanda s’il n’y avait pas dans cette affaire quelque criminel enlèvement. Oui! cela devait être! Cette idée s’incrusta dans le cerveau de Fix, et il reconnut tout le parti qu’il pouvait tirer de cette circonstance. Que cette jeune femme fût mariée ou non, il y avait enlèvement, et il était possible, à Hong-Kong, de susciter au ravisseur des embarras tels, qu’il ne pût s’en tirer à prix d’argent.



Mais il ne fallait pas attendre l’arrivée du {Rangoon} à Hong-Kong. Ce Fogg avait la détestable habitude de sauter d’un bateau dans un autre, et, avant que l’affaire fût entamée, il pouvait être déjà loin.



L’important était donc de prévenir les autorités anglaises et de signaler le passage du {Rangoon} avant son débarquement. Or, rien n’était plus facile, puisque le paquebot faisait escale à Singapore, et que Singapore est reliée à la côte chinoise par un fil télégraphique.



Toutefois, avant d’agir et pour opérer plus sûrement, Fix résolut d’interroger Passepartout. Il savait qu’il n’était pas très difficile de faire parler ce garçon, et il se décida à rompre l’incognito qu’il avait gardé jusqu’alors. Or, il n’y avait pas de temps à perdre. On était au 30 octobre, et le lendemain même le {Rangoon} devait relâcher à Singapore.



Donc, ce jour-là, Fix, sortant de sa cabine, monta sur le pont, dans l’intention d’aborder Passepartout «le premier» avec les marques de la plus extrême surprise. Passepartout se promenait à l’avant, quand l’inspecteur se précipita vers lui, s’écriant:



«Vous, sur le {Rangoon}!



– Monsieur Fix à bord! répondit Passepartout, absolument surpris, en reconnaissant son compagnon de traversée du {Mongolia}. Quoi! je vous laisse à Bombay, et je vous retrouve sur la route de Hong-Kong! Mais vous faites donc, vous aussi, le tour du monde?



– Non, non, répondit Fix, et je compte m’arrêter à Hong-Kong, – au moins quelques jours.



– Ah! dit Passepartout, qui parut un instant étonné. Mais comment ne vous ai-je pas aperçu à bord depuis notre départ de Calcutta?



– Ma foi, un malaise… un peu de mal de mer… Je suis resté couché dans ma cabine… Le golfe du Bengale ne me réussit pas aussi bien que l’océan Indien. Et votre maître, Mr. Phileas Fogg?



– En parfaite santé, et aussi ponctuel que son itinéraire! Pas un jour de retard! Ah! monsieur Fix, vous ne savez pas cela, vous, mais nous avons aussi une jeune dame avec nous.



– Une jeune dame?» répondit l’agent, qui avait parfaitement l’air de ne pas comprendre ce que son interlocuteur voulait dire.



Mais Passepartout l’eut bientôt mis au courant de son histoire. Il raconta l’incident de la pagode de Bombay, l’acquisition de l’éléphant au prix de deux mille livres, l’affaire du sutty, l’enlèvement d’Aouda, la condamnation du tribunal de Calcutta, la liberté sous caution. Fix, qui connaissait la dernière partie de ces incidents, semblait les ignorer tous, et Passepartout se laissait aller au charme de narrer ses aventures devant un auditeur qui lui marquait tant d’intérêt.



«Mais, en fin de compte, demanda Fix, est-ce que votre maître a l’intention d’emmener cette jeune femme en Europe?



– Non pas, monsieur Fix, non pas! Nous allons tout simplement la remettre aux soins de l’un de ses parents, riche négociant de Hong-Kong.»



«Rien à faire!» se dit le détective en dissimulant son désappointement. «Un verre de gin, monsieur Passepartout?



– Volontiers, monsieur Fix. C’est bien le moins que nous buvions à notre rencontre à bord du {Rangoon}!»




{{{XVII
_ OÙ IL EST QUESTION DE CHOSES ET D’AUTRES PENDANT LA TRAVERSÉE DE SINGAPORE À HONG-KONG}}}


Depuis ce jour, Passepartout et le détective se rencontrèrent fréquemment, mais l’agent se tint dans une extrême réserve vis-à-vis de son compagnon, et il n’essaya point de le faire parler. Une ou deux fois seulement, il entrevit Mr. Fogg, qui restait volontiers dans le grand salon du {Rangoon}, soit qu’il tînt compagnie à Mrs. Aouda, soit qu’il jouât au whist, suivant son invariable habitude.



Quant à Passepartout, il s’était pris très sérieusement à méditer sur le singulier hasard qui avait mis, encore une fois, Fix sur la route de son maître. Et, en effet, on eût été étonné à moins. Ce gentleman, très aimable, très complaisant à coup sûr, que l’on rencontre d’abord à Suez, qui s’embarque sur le {Mongolia}, qui débarque à Bombay, où il dit devoir séjourner, que l’on retrouve sur le {Rangoon}, faisant route pour Hong-Kong, en un mot, suivant pas à pas l’itinéraire de Mr. Fogg, cela valait la peine qu’on y réfléchît. Il y avait là une concordance au moins bizarre. À qui en avait ce Fix? Passepartout était prêt a parier ses babouches – il les avait précieusement conservées – que le Fix quitterait Hong-Kong en même temps qu’eux, et probablement sur le même paquebot.



Passepartout eût réfléchi pendant un siècle, qu’il n’aurait jamais deviné de quelle mission l’agent avait été chargé. Jamais il n’eût imaginé que Phileas Fogg fût «filé», à la façon d’un voleur, autour du globe terrestre. Mais comme il est dans la nature humaine de donner une explication à toute chose, voici comment Passepartout, soudainement illuminé, interpréta la présence permanente de Fix, et, vraiment, son interprétation était fort plausible. En effet, suivant lui, Fix n’était et ne pouvait être qu’un agent lancé sur les traces de Mr. Fogg par ses collègues du Reform-Club, afin de constater que ce voyage s’accomplissait régulièrement autour du monde, suivant l’itinéraire convenu.



«C’est évident! c’est évident! se répétait l’honnête garçon, tout fier de sa perspicacité. C’est un espion que ces gentlemen ont mis à nos trousses! Voilà qui n’est pas digne! Mr. Fogg si probe, si honorable! Le faire épier par un agent! Ah! messieurs du Reform-Club, cela vous coûtera cher!»



Passepartout, enchanté de sa découverte, résolut cependant de n’en rien dire à son maître, craignant que celui-ci ne fût justement blessé de cette défiance que lui montraient ses adversaires. Mais il se promit bien de gouailler Fix à l’occasion, à mots couverts et sans se compromettre.



Le mercredi 30 octobre, dans l’après-midi, le {Rangoon} embouquait le détroit de Malacca, qui sépare la presqu’île de ce nom des terres de Sumatra. Des îlots montagneux très escarpés, très pittoresques dérobaient aux passagers la vue de la grande île.



Le lendemain, à quatre heures du matin, le {Rangoon}, ayant gagné une demi-journée sur sa traversée réglementaire, relâchait à Singapore, afin d’y renouveler sa provision de charbon.



Phileas Fogg inscrivit cette avance à la colonne des gains, et, cette fois, il descendit à terre, accompagnant Mrs. Aouda, qui avait manifesté le désir de se promener pendant quelques heures.



Fix, à qui toute action de Fogg paraissait suspecte, le suivit sans se laisser apercevoir. Quant à Passepartout, qui riait {in petto} à voir la manœuvre de Fix, il alla faire ses emplettes ordinaires.



L’île de Singapore n’est ni grande ni imposante l’aspect. Les montagnes, c’est-à-dire les profils, lui manquent. Toutefois, elle est charmante dans sa maigreur. C’est un parc coupé de belles routes. Un joli équipage, attelé de ces chevaux élégants qui ont été importés de la Nouvelle-Hollande, transporta Mrs. Aouda et Phileas Fogg au milieu des massifs de palmiers à l’éclatant feuillage, et de girofliers dont les clous sont formés du bouton même de la fleur entrouverte. Là, les buissons de poivriers remplaçaient les haies épineuses des campagnes européennes; des sagoutiers, de grandes fougères avec leur ramure superbe, variaient l’aspect de cette région tropicale; des muscadiers au feuillage verni saturaient l’air d’un parfum pénétrant. Les singes, bandes alertes et grimaçantes, ne manquaient pas dans les bois, ni peut-être les tigres dans les jungles. À qui s’étonnerait d’apprendre que dans cette île, si petite relativement, ces terribles carnassiers ne fussent pas détruits jusqu’au dernier, on répondra qu’ils viennent de Malacca, en traversant le détroit à la nage.



Après avoir parcouru la campagne pendant deux heures, Mrs. Aouda et son compagnon – qui regardait un peu sans voir – rentrèrent dans la ville, vaste agglomération de maisons lourdes et écrasées, qu’entourent de charmants jardins où poussent des mangoustes, des ananas et tous les meilleurs fruits du monde.



À dix heures, ils revenaient au paquebot, après avoir été suivis, sans s’en douter, par l’inspecteur, qui avait dû lui aussi se mettre en frais d’équipage.



Passepartout les attendait sur le pont du {Rangoon}. Le brave garçon avait acheté quelques douzaines de mangoustes, grosses comme des pommes moyennes, d’un brun foncé au-dehors, d’un rouge éclatant au-dedans, et dont le fruit blanc, en fondant entre les lèvres, procure aux vrais gourmets une jouissance sans pareille. Passepartout fut trop heureux de les offrir à Mrs. Aouda, qui le remercia avec beaucoup de grâce.



À onze heures, le {Rangoon}, ayant son plein de charbon, larguait ses amarres, et, quelques heures plus tard, les passagers perdaient de vue ces hautes montagnes de Malacca, dont les forêts abritent les plus beaux tigres de la terre.



Treize cents milles environ séparent Singapore de l’île de Hong-Kong, petit territoire anglais détaché de la côte chinoise. Phileas Fogg avait intérêt à les franchir en six jours au plus, afin de prendre à Hong-Kong le bateau qui devait partir le 6 novembre pour Yokohama, l’un des principaux ports du Japon.



Le {Rangoon} était fort chargé. De nombreux passagers s’étaient embarqués à Singapore, des Indous, des Ceylandais, des Chinois, des Malais, des Portugais, qui, pour la plupart, occupaient les secondes places.



Le temps, assez beau jusqu’alors, changea avec le dernier quartier de la lune. Il y eut grosse mer. Le vent souffla quelquefois en grande brise, mais très heureusement de la partie du sud-est, ce qui favorisait la marche du steamer. Quand il était maniable, le capitaine faisait établir la voilure. Le {Rangoon}, gréé en brick, navigua souvent avec ses deux huniers et sa misaine, et sa rapidité s’accrut sous la double action de la vapeur et du vent. C’est ainsi que l’on prolongea, sur une lame courte et parfois très fatigante, les côtes d’Annam et de Cochinchine.



Mais la faute en était plutôt au {Rangoon} qu’à la mer, et c’est à ce paquebot que les passagers, dont la plupart furent malades, durent s’en prendre de cette fatigue.



En effet, les navires de la Compagnie péninsulaire, qui font le service des mers de Chine, ont un sérieux défaut de construction. Le rapport de leur tirant d’eau en charge avec leur creux a été mal calculé, et, par suite, ils n’offrent qu’une faible résistance à la mer. Leur volume, clos, impénétrable à l’eau, est insuffisant. Ils sont «noyés», pour employer l’expression maritime, et, en conséquence de cette disposition, il ne faut que quelques paquets de mer, jetés à bord, pour modifier leur allure. Ces navires sont donc très inférieurs – sinon par le moteur et l’appareil évaporatoire, du moins par la construction, – aux types des Messageries françaises, tels que l’{Impératrice} et le {Cambodge}. Tandis que, suivant les calculs des ingénieurs, ceux-ci peuvent embarquer un poids d’eau égal à leur propre poids avant de sombrer, les bateaux de la Compagnie péninsulaire, le {Golgonda}, le {Corea}, et enfin le {Rangoon}, ne pourraient pas embarquer le sixième de leur poids sans couler par le fond.



Donc, par le mauvais temps, il convenait de prendre de grandes précautions. Il fallait quelquefois mettre à la cape sous petite vapeur. C’était une perte de temps qui ne paraissait affecter Phileas Fogg en aucune façon, mais dont Passepartout se montrait extrêmement irrité. Il accusait alors le capitaine, le mécanicien, la Compagnie, et envoyait au diable tous ceux qui se mêlent de transporter des voyageurs. Peut-être aussi la pensée de ce bec de gaz qui continuait de brûler à son compte dans la maison de Saville-row entrait-elle pour beaucoup dans son impatience.



«Mais vous êtes donc bien pressé d’arriver à Hong-Kong? lui demanda un jour le détective.



– Très pressé! répondit Passepartout.



– Vous pensez que Mr. Fogg a hâte de prendre le paquebot de Yokohama?



– Une hâte effroyable.



– Vous croyez donc maintenant à ce singulier voyage autour du monde?



– Absolument. Et vous, monsieur Fix?



– Moi? je n’y crois pas!



– Farceur!» répondit Passepartout en clignant de l’œil.



Ce mot laissa l’agent rêveur. Ce qualificatif l’inquiéta, sans qu’il sût trop pourquoi. Le Français l’avait-il deviné? Il ne savait trop que penser. Mais sa qualité de détective, dont seul il avait le secret, comment Passepartout aurait-il pu la reconnaître? Et cependant, en lui parlant ainsi, Passepartout avait certainement eu une arrière-pensée.



Il arriva même que le brave garçon alla plus loin, un autre jour, mais c’était plus fort que lui. Il ne pouvait tenir sa langue.



«Voyons, monsieur Fix, demanda-t-il à son compagnon d’un ton malicieux, est-ce que, une fois arrivés à Hong-Kong, nous aurons le malheur de vous y laisser?



– Mais, répondit Fix assez embarrassé, je ne sais!… Peut-être que…



– Ah! dit Passepartout, si vous nous accompagniez, ce serait un bonheur pour moi! Voyons! un agent de la Compagnie péninsulaire ne saurait s’arrêter en route! Vous n’alliez qu’à Bombay, et vous voici bientôt en Chine! L’Amérique n’est pas loin, et de l’Amérique à l’Europe il n’y a qu’un pas!»



Fix regardait attentivement son interlocuteur, qui lui montrait la figure la plus aimable du monde, et il prit le parti de rire avec lui. Mais celui-ci, qui était en veine, lui demanda si «ça lui rapportait beaucoup, ce métier-là?»



«Oui et non, répondit Fix sans sourciller. Il y a de bonnes et de mauvaises affaires. Mais vous comprenez bien que je ne voyage pas à mes frais!



– Oh! pour cela, j’en suis sûr!» s’écria Passepartout, riant de plus belle.



La conversation finie, Fix rentra dans sa cabine et se mit à réfléchir. Il était évidemment deviné. D’une façon ou d’une autre, le Français avait reconnu sa qualité de détective. Mais avait-il prévenu son maître? Quel rôle jouait-il dans tout ceci? Était-il complice ou non? L’affaire était-elle éventée, et par conséquent manquée? L’agent passa là quelques heures difficiles, tantôt croyant tout perdu, tantôt espérant que Fogg ignorait la situation, enfin ne sachant quel parti prendre.



Cependant le calme se rétablit dans son cerveau, et il résolut d’agir franchement avec Passepartout. S’il ne se trouvait pas dans les conditions voulues pour arrêter Fogg à Hong-Kong, et si Fogg se préparait à quitter définitivement cette fois le territoire anglais, lui, Fix, dirait tout à Passepartout. Ou le domestique était le complice de son maître – et celui-ci savait tout, et dans ce cas l’affaire était définitivement compromise – ou le domestique n’était pour rien dans le vol, et alors son intérêt serait d’abandonner le voleur.



Telle était donc la situation respective de ces deux hommes, et au-dessus d’eux Phileas Fogg planait dans sa majestueuse indifférence. Il accomplissait rationnellement son orbite autour du monde, sans s’inquiéter des astéroïdes qui gravitaient autour de lui.



Et cependant, dans le voisinage, il y avait – suivant l’expression des astronomes – un astre troublant qui aurait dû produire certaines perturbations sur le cœur de ce gentleman. Mais non! Le charme de Mrs. Aouda n’agissait point, à la grande surprise de Passepartout, et les perturbations, si elles existaient, eussent été plus difficiles à calculer que celles d’Uranus qui l’ont amené la découverte de Neptune.



Oui! c’était un étonnement de tous les jours pour Passepartout, qui lisait tant de reconnaissance envers son maître dans les yeux de la jeune femme! Décidément Phileas Fogg n’avait de cœur que ce qu’il en fallait pour se conduire héroïquement, mais amoureusement, non! Quant aux préoccupations que les chances de ce voyage pouvaient faire naître en lui, il n’y en avait pas trace. Mais Passepartout, lui, vivait dans des transes continuelles. Un jour, appuyé sur la rambarde de l’» engine-room», il regardait la puissante machine qui s’emportait parfois, quand dans un violent mouvement de tangage, l’hélice s’affolait hors des flots. La vapeur fusait alors par les soupapes, ce qui provoqua la colère du digne garçon.



«Elles ne sont pas assez chargées, ces soupapes! s’écria-t-il. On ne marche pas! Voilà bien ces Anglais! Ah! si c’était un navire américain, on sauterait peut-être, mais on irait plus vite!»




{{{XVIII
_ DANS LEQUEL PHILEAS FOGG, PASSEPARTOUT, FIX, CHACUN DE SON CÔTÉ, VA À SES AFFAIRES}}}


Pendant les derniers jours de la traversée, le temps fut assez mauvais. Le vent devint très fort. Fixé dans la partie du nord-ouest, il contraria la marche du paquebot. Le {Rangoon}, trop instable, roula considérablement, et les passagers furent en droit de garder rancune à ces longues lames affadissantes que le vent soulevait du large.



Pendant les journées du 3 et du 4 novembre, ce fut une sorte de tempête. La bourrasque battit la mer avec véhémence. Le {Rangoon} dut mettre à la cape pendant un demi-jour, se maintenant avec dix tours d’hélice seulement, de manière à biaiser avec les lames. Toutes les voiles avaient été serrées, et c’était encore trop de ces agrès qui sifflaient au milieu des rafales.



La vitesse du paquebot, on le conçoit, fut notablement diminuée, et l’on put estimer qu’il arriverait à Hong-Kong avec vingt heures de retard sur l’heure réglementaire, et plus même, si la tempête ne cessait pas.



Phileas Fogg assistait à ce spectacle d’une mer furieuse, qui semblait lutter directement contre lui, avec son habituelle impassibilité. Son front ne s’assombrit pas un instant, et, cependant, un retard de vingt heures pouvait compromettre son voyage en lui faisant manquer le départ du paquebot de Yokohama. Mais cet homme sans nerfs ne ressentait ni impatience ni ennui. Il semblait vraiment que cette tempête rentrât dans son programme, qu’elle fût prévue. Mrs. Aouda, qui s’entretint avec son compagnon de ce contretemps, le trouva aussi calme que par le passé.



Fix, lui, ne voyait pas ces choses du même œil. Bien au contraire. Cette tempête lui plaisait. Sa satisfaction aurait même été sans bornes, si le {Rangoon} eût été obligé de fuir devant la tourmente. Tous ces retards lui allaient, car ils obligeraient le sieur Fogg à rester quelques jours à Hong-Kong. Enfin, le ciel, avec ses rafales et ses bourrasques, entrait dans son jeu. Il était bien un peu malade, mais qu’importe! Il ne comptait pas ses nausées, et, quand son corps se tordait sous le mal de mer, son esprit s’ébaudissait d’une immense satisfaction.



Quant à Passepartout, on devine dans quelle colère peu dissimulée il passa ce temps d’épreuve. Jusqu’alors tout avait si bien marché! La terre et l’eau semblaient être à la dévotion de son maître. Steamers et railways lui obéissaient. Le vent et la vapeur s’unissaient pour favoriser son voyage. L’heure des mécomptes avait-elle donc enfin sonné? Passepartout, comme si les vingt mille livres du pari eussent dû sortir de sa bourse, ne vivait plus. Cette tempête l’exaspérait, cette rafale le mettait en fureur, et il eût volontiers fouetté cette mer désobéissante! Pauvre garçon! Fix lui cacha soigneusement sa satisfaction personnelle, et il fit bien, car si Passepartout eût deviné le secret contentement de Fix, Fix eût passé un mauvais quart d’heure.



Passepartout, pendant toute la durée de la bourrasque, demeura sur le pont du {Rangoon}. Il n’aurait pu rester en bas; il grimpait dans la mâture; il étonnait l’équipage et aidait à tout avec une adresse de singe. Cent fois il interrogea le capitaine, les officiers, les matelots, qui ne pouvaient s’empêcher de rire en voyant un garçon si décontenancé. Passepartout voulait absolument savoir combien de temps durerait la tempête. On le renvoyait alors au baromètre, qui ne se décidait pas à remonter. Passepartout secouait le baromètre, mais rien n’y faisait, ni les secousses, ni les injures dont il accablait l’irresponsable instrument.



Enfin la tourmente s’apaisa. L’état de la mer se modifia dans la journée du 4 novembre. Le vent sauta de deux quarts dans le sud et redevint favorable.



Passepartout se rasséréna avec le temps. Les huniers et les basses voiles purent être établis, et le {Rangoon} reprit sa route avec une merveilleuse vitesse.



Mais on ne pouvait regagner tout le temps perdu. Il fallait bien en prendre son parti, et la terre ne fut signalée que le 6, à cinq heures du matin. L’itinéraire de Phileas Fogg portait l’arrivée du paquebot au 5. Or, il n’arrivait que le 6. C’était donc vingt-quatre heures de retard, et le départ pour Yokohama serait nécessairement manqué.



À six heures, le pilote monta à bord du {Rangoon} et prit place sur la passerelle, afin de diriger le navire à travers les passes jusqu’au port de Hong-Kong.



Passepartout mourait du désir d’interroger cet homme, de lui demander si le paquebot de Yokohama avait quitté Hong-Kong. Mais il n’osait pas, aimant mieux conserver un peu d’espoir jusqu’au dernier instant. Il avait confié ses inquiétudes à Fix, qui – le fin renard – essayait de le consoler, en lui disant que Mr. Fogg en serait quitte pour prendre le prochain paquebot. Ce qui mettait Passepartout dans une colère bleue.



Mais si Passepartout ne se hasarda pas à interroger le pilote, Mr. Fogg, après avoir consulté son Bradshaw, demanda de son air tranquille audit pilote s’il savait quand il partirait un bateau de Hong-Kong pour Yokohama.



«Demain, à la marée du matin, répondit le pilote.



– Ah!» fit Mr. Fogg, sans manifester aucun étonnement.



Passepartout, qui était présent, eût volontiers embrassé le pilote, auquel Fix aurait voulu tordre le cou.



«Quel est le nom de ce steamer? demanda Mr. Fogg.



– Le {Carnatic}, répondit le pilote.



– N’était-ce pas hier qu’il devait partir?



– Oui, monsieur, mais on a dû réparer une de ses chaudières, et son départ a été remis à demain.



– Je vous remercie», répondit Mr. Fogg, qui de son pas automatique redescendit dans le salon du {Rangoon}.



Quant à Passepartout, il saisit la main du pilote et l’étreignit vigoureusement en disant:



«Vous, pilote, vous êtes un brave homme!»



Le pilote ne sut jamais, sans doute, pourquoi ses réponses lui valurent cette amicale expansion. À un coup de sifflet, il remonta sur la passerelle et dirigea le paquebot au milieu de cette flottille de jonques, de tankas, de bateaux-pêcheurs, de navires de toutes sortes, qui encombraient les pertuis de Hong-Kong.



À une heure, le {Rangoon} était à quai, et les passagers débarquaient.



En cette circonstance, le hasard avait singulièrement servi Phileas Fogg, il faut en convenir. Sans cette nécessité de réparer ses chaudières, le {Carnatic} fût parti à la date du 5 novembre, et les voyageurs pour le Japon auraient dû attendre pendant huit jours le départ du paquebot suivant. Mr. Fogg, il est vrai, était en retard de vingt-quatre heures, mais ce retard ne pouvait avoir de conséquences fâcheuses pour le reste du voyage.



En effet, le steamer qui fait de Yokohama à San Francisco la traversée du Pacifique était en correspondance directe avec le paquebot de Hong-Kong, et il ne pouvait partir avant que celui-ci fût arrivé. Évidemment il y aurait vingt-quatre heures de retard à Yokohama, mais, pendant les vingt-deux jours que dure la traversée du Pacifique, il serait facile de les regagner. Phileas Fogg se trouvait donc, à vingt-quatre heures près, dans les conditions de son programme, trente-cinq jours après avoir quitté Londres.

Le {Carnatic} ne devant partir que le lendemain matin à cinq heures, Mr. Fogg avait devant lui seize heures pour s’occuper de ses affaires, c’est-à-dire de celles qui concernaient Mrs. Aouda. Au débarqué du bateau, il offrit son bras à la jeune femme et la conduisit vers un palanquin. Il demanda aux porteurs de lui indiquer un hôtel, et ceux-ci lui désignèrent l’{Hôtel du Club}. Le palanquin se mit en route, suivi de Passepartout, et vingt minutes après il arrivait à destination.



Un appartement fut retenu pour la jeune femme et Phileas Fogg veilla à ce qu’elle ne manquât de rien. Puis il dit à Mrs. Aouda qu’il allait immédiatement se mettre à la recherche de ce parent aux soins duquel il devait la laisser à Hong-Kong. En même temps il donnait à Passepartout l’ordre de demeurer à l’hôtel jusqu’à son retour, afin que la jeune femme n’y restât pas seule.



Le gentleman se fit conduire à la Bourse. Là, on connaîtrait immanquablement un personnage tel que l’honorable Jejeeh, qui comptait parmi les plus riches commerçants de la ville.



Le courtier auquel s’adressa Mr. Fogg connaissait en effet le négociant parsi. Mais, depuis deux ans, celui-ci n’habitait plus la Chine. Sa fortune faite, il s’était établi en Europe – en Hollande, croyait-on –, ce qui s’expliquait par suite de nombreuses relations qu’il avait eues avec ce pays pendant son existence commerciale.



Phileas Fogg revint à l’{Hôtel du Club}. Aussitôt il fit demander à Mrs. Aouda la permission de se présenter devant elle, et, sans autre préambule, il lui apprit que l’honorable Jejeeh ne résidait plus à Hong-Kong, et qu’il habitait vraisemblablement la Hollande.



À cela, Mrs. Aouda ne répondit rien d’abord. Elle passa sa main sur son front, et resta quelques instants à réfléchir. Puis, de sa douce voix:



«Que dois-je faire, monsieur Fogg? dit-elle.



– C’est très simple, répondit le gentleman. Revenir en Europe.



– Mais je ne puis abuser…



– Vous n’abusez pas, et votre présence ne gêne en rien mon programme… Passepartout?



– Monsieur? répondit Passepartout.



– Allez au {Carnatic}, et retenez trois cabines.»



Passepartout, enchanté de continuer son voyage dans la compagnie de la jeune femme, qui était fort gracieuse pour lui, quitta aussitôt l’{Hôtel du Club}.




{{{XIX
_ OÙ PASSEPARTOUT PREND UN TROP VIF INTÉRÊT À SON MAÎTRE, ET CE QUI S’ENSUIT}}}


Hong-Kong n’est qu’un îlot, dont le traité de Nanking, après la guerre de 1842, assura la possession à l’Angleterre. En quelques années, le génie colonisateur de la Grande-Bretagne y avait fondé une ville importante et créé un port, le port Victoria. Cette île est située à l’embouchure de la rivière de Canton, et soixante milles seulement la séparent de la cité portugaise de Macao, bâtie sur l’autre rive. Hong-Kong devait nécessairement vaincre Macao dans une lutte commerciale, et maintenant la plus grande partie du transit chinois s’opère par la ville anglaise. Des docks, des hôpitaux, des wharfs, des entrepôts, une cathédrale gothique, un «government-house», des rues macadamisées, tout ferait croire qu’une des cités commerçantes des comtés de Kent ou de Surrey, traversant le sphéroïde terrestre, est venue ressortir en ce point de la Chine, presque à ses antipodes.



Passepartout, les mains dans les poches, se rendit donc vers le port Victoria, regardant les palanquins, les brouettes à voile, encore en faveur dans le Céleste Empire, et toute cette foule de Chinois, de Japonais et d’Européens, qui se pressait dans les rues. À peu de choses près, c’était encore Bombay, Calcutta ou Singapore, que le digne garçon retrouvait sur son parcours. Il y a ainsi comme une traînée de villes anglaises tout autour du monde.



Passepartout arriva au port Victoria. Là, à l’embouchure de la rivière de Canton, c’était un fourmillement de navires de toutes nations, des anglais, des français, des américains, des hollandais, bâtiments de guerre et de commerce, des embarcations japonaises ou chinoises, des jonques, des sempans, des tankas, et même des bateaux-fleurs qui formaient autant de parterres flottants sur les eaux. En se promenant, Passepartout remarqua un certain nombre d’indigènes vêtus de jaune, tous très avancés en âge. Étant entré chez un barbier chinois pour se faire raser «à la chinoise», il apprit par le Figaro de l’endroit, qui parlait un assez bon anglais, que ces vieillards avaient tous quatre-vingts ans au moins, et qu’à cet âge ils avaient le privilège de porter la couleur jaune, qui est la couleur impériale. Passepartout trouva cela fort drôle, sans trop savoir pourquoi.



Sa barbe faite, il se rendit au quai d’embarquement du {Carnatic}, et là il aperçut Fix qui se promenait de long en large, ce dont il ne fut point étonné. Mais l’inspecteur de police laissait voir sur son visage les marques d’un vif désappointement.



«Bon! se dit Passepartout, cela va mal pour les gentlemen du Reform-Club!»



Et il accosta Fix avec son joyeux sourire, sans vouloir remarquer l’air vexé de son compagnon.



Or, l’agent avait de bonnes raisons pour pester contre l’infernale chance qui le poursuivait. Pas de mandat! Il était évident que le mandat courait après lui, et ne pourrait l’atteindre que s’il séjournait quelques jours en cette ville. Or, Hong-Kong étant la dernière terre anglaise du parcours, le sieur Fogg allait lui échapper définitivement, s’il ne parvenait pas à l’y retenir.



«Eh bien, monsieur Fix, êtes-vous décidé à venir avec nous jusqu’en Amérique? demanda Passepartout.



– Oui, répondit Fix les dents serrées.



– Allons donc! s’écria Passepartout en faisant entendre un retentissant éclat de rire! Je savais bien que vous ne pourriez pas vous séparer de nous. Venez retenir votre place, venez!»



Et tous deux entrèrent au bureau des transports maritimes et arrêtèrent des cabines pour quatre personnes. Mais l’employé leur fit observer que les réparations du {Carnatic} étant terminées, le paquebot partirait le soir même à huit heures, et non le lendemain matin, comme il avait été annoncé.



«Très bien! répondit Passepartout, cela arrangera mon maître. Je vais le prévenir.»



À ce moment, Fix prit un parti extrême. Il résolut de tout dire à Passepartout. C’était le seul moyen peut-être qu’il eût de retenir Phileas Fogg pendant quelques jours à Hong-Kong.



En quittant le bureau, Fix offrit à son compagnon de se rafraîchir dans une taverne. Passepartout avait le temps. Il accepta l’invitation de Fix.



Une taverne s’ouvrait sur le quai. Elle avait un aspect engageant. Tous deux y entrèrent. C’était une vaste salle bien décorée, au fond de laquelle s’étendait un lit de camp, garni de coussins. Sur ce lit étaient rangés un certain nombre de dormeurs.



Une trentaine de consommateurs occupaient dans la grande salle de petites tables en jonc tressé. Quelques uns vidaient des pintes de bière anglaise, ale ou porter, d’autres, des brocs de liqueurs alcooliques, gin ou brandy. En outre, la plupart fumaient de longues pipes de terre rouge, bourrées de petites boulettes d’opium mélangé d’essence de rose. Puis, de temps en temps, quelque fumeur énervé glissait sous la table, et les garçons de l’établissement, le prenant par les pieds et par la tête, le portaient sur le lit de camp près d’un confrère. Une vingtaine de ces ivrognes étaient ainsi rangés côte à côte, dans le dernier degré d’abrutissement.



Fix et Passepartout comprirent qu’ils étaient entrés dans une tabagie hantée de ces misérables, hébétés, amaigris, idiots, auxquels la mercantile Angleterre vend annuellement pour deux cent soixante millions de francs de cette funeste drogue qui s’appelle l’opium! Tristes millions que ceux-là, prélevés sur un des plus funestes vices de la nature humaine.



Le gouvernement chinois a bien essayé de remédier à un tel abus par des lois sévères, mais en vain. De la classe riche, à laquelle l’usage de l’opium était d’abord formellement réservé, cet usage descendit jusqu’aux classes inférieures, et les ravages ne purent plus être arrêtés. On fume l’opium partout et toujours dans l’empire du Milieu. Hommes et femmes s’adonnent à cette passion déplorable, et lorsqu’ils sont accoutumés à cette inhalation, ils ne peuvent plus s’en passer, à moins d’éprouver d’horribles contractions de l’estomac. Un grand fumeur peut fumer jusqu’à huit pipes par jour mais il meurt en cinq ans.



Or, c’était dans une des nombreuses tabagies de ce genre, qui pullulent, même à Hong-Kong, que Fix et Passepartout étaient entrés avec l’intention de se rafraîchir. Passepartout n’avait pas d’argent, mais il accepta volontiers la «politesse» de son compagnon, quitte à la lui rendre en temps et lieu.



On demanda deux bouteilles de porto, auxquelles le Français fit largement honneur, tandis que Fix, plus réservé, observait son compagnon avec une extrême attention. On causa de choses et d’autres, et surtout de cette excellente idée qu’avait eue Fix de prendre passage sur le {Carnatic}. Et à propos de ce steamer, dont le départ se trouvait avancé de quelques heures, Passepartout, les bouteilles étant vides, se leva, afin d’aller prévenir son maître.



Fix le retint.



«Un instant, dit-il.



– Que voulez-vous, monsieur Fix?



– J’ai à vous parler de choses sérieuses.



– De choses sérieuses! s’écria Passepartout en vidant quelques gouttes de vin restées au fond au son verre. Eh bien, nous en parlerons demain. Je n’ai pas le temps aujourd’hui.



– Restez, répondit Fix. Il s’agit de votre maître!»



Passepartout, à ce mot, regarda attentivement son interlocuteur.



L’expression du visage de Fix lui parut singulière. Il se rassit.



«Qu’est-ce donc que vous avez à me dire» demanda-t-il.



Fix appuya sa main sur le bras de son compagnon et, baissant la voix:



«Vous avez deviné qui j’étais? lui demanda-t-il.



– Parbleu! dit Passepartout en souriant.



– Alors je vais tout vous avouer…



– Maintenant que je sais tout, mon compère! Ah! voilà qui n’est pas fort! Enfin, allez toujours. Mais auparavant, laissez-moi vous dire que ces gentlemen se sont mis en frais bien inutilement!



– Inutilement! dit Fix. Vous en parlez à votre aise! On voit bien que vous ne connaissez pas l’importance de la somme!



– Mais si, je la connais, répondit Passepartout. Vingt mille livres!



– Cinquante-cinq mille! reprit Fix, en serrant la main du Français.



– Quoi! s’écria Passepartout, Mr. Fogg aurait osé!… Cinquante-cinq mille livres!… Eh bien! raison de plus pour ne pas perdre un instant, ajouta-t-il en se levant de nouveau.



– Cinquante-cinq mille livres! reprit Fix, qui força Passepartout à se rasseoir, après avoir fait apporter un flacon de brandy, – et si je réussis, je gagne une prime de deux mille livres. En voulez-vous cinq cents (12 500 F) à la condition de m’aider?



– Vous aider? s’écria Passepartout, dont les yeux étaient démesurément ouverts.



– Oui, m’aider à retenir le sieur Fogg pendant quelques jours à Hong-Kong!



– Hein! fit Passepartout, que dites-vous là? Comment! non content de faire suivre mon maître, de suspecter sa loyauté, ces gentlemen veulent encore lui susciter des obstacles! J’en suis honteux pour eux!



– Ah çà! que voulez-vous dire? demanda Fix.



– Je veux dire que c’est de la pure indélicatesse. Autant dépouiller Mr. Fogg, et lui prendre l’argent dans la poche!



– Eh! c’est bien à cela que nous comptons arriver!



– Mais c’est un guet-apens! s’écria Passepartout, – qui s’animait alors sous l’influence du brandy que lui servait Fix, et qu’il buvait sans s’en apercevoir, – un guet-apens véritable! Des gentlemen! des collègues!»



Fix commençait à ne plus comprendre.



«Des collègues! s’écria Passepartout, des membres du Reform-Club! Sachez, monsieur Fix, que mon maître est un honnête homme, et que, quand il a fait un pari, c’est loyalement qu’il prétend le gagner.



– Mais qui croyez-vous donc que je sois? demanda Fix, en fixant son regard sur Passepartout.



– Parbleu! un agent des membres du Reform-Club, qui a mission de contrôler l’itinéraire de mon maître, ce qui est singulièrement humiliant! Aussi, bien que, depuis quelque temps déjà, j’aie deviné votre qualité, je me suis bien gardé de la révéler à Mr. Fogg!



– Il ne sait rien?… demanda vivement Fix.



– Rien», répondit Passepartout en vidant encore une fois son verre.



L’inspecteur de police passa sa main sur son front. Il hésitait avant de reprendre la parole. Que devait-il faire? L’erreur de Passepartout semblait sincère, mais elle rendait son projet plus difficile. Il était évident que ce garçon parlait avec une absolue bonne foi, et qu’il n’était point le complice de son maître, – ce que Fix aurait pu craindre.



«Eh bien, se dit-il, puisqu’il n’est pas son complice, il m’aidera.»



Le détective avait une seconde fois pris son parti. D’ailleurs, il n’avait plus le temps d’attendre. À tout prix, il fallait arrêter Fogg à Hong-Kong.



«Écoutez, dit Fix d’une voix brève, écoutez-moi bien. Je ne suis pas ce que vous croyez, c’est-à-dire un agent des membres du Reform-Club…



– Bah! dit Passepartout en le regardant d’un air goguenard.



– Je suis un inspecteur de police, chargé d’une mission par l’administration métropolitaine…



– Vous… inspecteur de police!…



– Oui, et je le prouve, reprit Fix. Voici ma commission.»



Et l’agent, tirant un papier de son portefeuille, montra à son compagnon une commission signée du directeur de la police centrale. Passepartout, abasourdi, regardait Fix, sans pouvoir articuler une parole.



«Le pari du sieur Fogg, reprit Fix, n’est qu’un prétexte dont vous êtes dupes, vous et ses collègues du Reform-Club, car il avait intérêt à s’assurer votre inconsciente complicité.



– Mais pourquoi?… s’écria Passepartout.



– Écoutez. Le 28 septembre dernier, un vol de cinquante-cinq mille livres a été commis à la Banque d’Angleterre par un individu dont le signalement a pu être relevé. Or, voici ce signalement, et c’est trait pour trait celui du sieur Fogg.



– Allons donc! s’écria Passepartout en frappant la table de son robuste poing. Mon maître est le plus honnête homme du monde!



– Qu’en savez-vous? répondit Fix. Vous ne le connaissez même pas! Vous êtes entré à son service le jour de son départ, et il est parti précipitamment sous un prétexte insensé, sans malles, emportant une grosse somme en bank-notes! Et vous osez soutenir que c’est un honnête homme!



– Oui! oui! répétait machinalement le pauvre garçon.



– Voulez-vous donc être arrêté comme son complice?»



Passepartout avait pris sa tête à deux mains. Il n’était plus reconnaissable. Il n’osait regarder l’inspecteur de police. Phileas Fogg un voleur, lui, le sauveur d’Aouda, l’homme généreux et brave! Et pourtant que de présomptions relevées contre lui! Passepartout essayait de repousser les soupçons qui se glissaient dans son esprit. Il ne voulait pas croire à la culpabilité de son maître.



«Enfin, que voulez-vous de moi? dit-il à l’agent de police, en se contenant par un suprême effort.



– Voici, répondit Fix. J’ai filé le sieur Fogg jusqu’ici, mais je n’ai pas encore reçu le mandat d’arrestation, que j’ai demandé à Londres. Il faut donc que vous m’aidiez à retenir à Hong-Kong…



– Moi! que je…



– Et je partage avec vous la prime de deux mille livres promise par la Banque d’Angleterre!



– Jamais!» répondit Passepartout, qui voulut se lever et retomba, sentant sa raison et ses forces lui échapper à la fois.



«Monsieur Fix, dit-il en balbutiant, quand bien même tout ce que vous m’avez dit serait vrai… quand mon maître serait le voleur que vous cherchez… ce que je nie… j’ai été… je suis à son service… je l’ai vu bon et généreux… le trahir… jamais… non, pour tout l’or du monde… Je suis d’un village où l’on ne mange pas de ce pain-là!…



– Vous refusez?



– Je refuse.



– Mettons que je n’ai rien dit, répondit Fix, et buvons.



– Oui, buvons!»



Passepartout se sentait de plus en plus envahir par l’ivresse. Fix, comprenant qu’il fallait à tout prix le séparer de son maître, voulut l’achever. Sur la table se trouvaient quelques pipes chargées d’opium. Fix en glissa une dans la main de Passepartout, qui la prit, la porta à ses lèvres, l’alluma, respira quelques bouffées, et retomba, la tête alourdie sous l’influence du narcotique.



«Enfin, dit Fix en voyant Passepartout anéanti, le sieur Fogg ne sera pas prévenu à temps du départ du {Carnatic}, et s’il part, du moins partira-t-il sans ce maudit Français!»



Puis il sortit, après avoir payé la dépense.




{{{XX
_ DANS LEQUEL FIX ENTRE DIRECTEMENT EN RELATION AVEC PHILEAS FOGG}}}


Pendant cette scène qui allait peut-être compromettre si gravement son avenir, Mr. Fogg, accompagnant Mrs. Aouda, se promenait dans les rues de la ville anglaise. Depuis que Mrs. Aouda avait accepté son offre de la conduire jusqu’en Europe, il avait dû songer à tous les détails que comporte un aussi long voyage. Qu’un Anglais comme lui fît le tour du monde un sac à la main, passe encore; mais une femme ne pouvait entreprendre une pareille traversée dans ces conditions. De là, nécessité d’acheter les vêtements et objets nécessaires au voyage. Mr. Fogg s’acquitta de sa tâche avec le calme qui le caractérisait, et à toutes les excuses ou objections de la jeune veuve, confuse de tant de complaisance:



«C’est dans l’intérêt de mon voyage, c’est dans mon programme», répondait-il invariablement.



Les acquisitions faites, Mr. Fogg et la jeune femme rentrèrent à l’hôtel et dînèrent à la table d’hôte, qui était somptueusement servie. Puis Mrs. Aouda, un peu fatiguée, remonta dans son appartement, après avoir «à l’anglaise» serré la main de son imperturbable sauveur.



L’honorable gentleman, lui, s’absorba pendant toute la soirée dans la lecture du {Times} et de l’{Illustrated London News}.



S’il avait été homme à s’étonner de quelque chose, c’eût été de ne point voir apparaître son domestique à l’heure du coucher. Mais, sachant que le paquebot de Yokohama ne devait pas quitter Hong-Kong avant le lendemain matin, il ne s’en préoccupa pas autrement. Le lendemain, Passepartout ne vint point au coup de sonnette de Mr. Fogg.



Ce que pensa l’honorable gentleman en apprenant que son domestique n’était pas rentré à l’hôtel nul n’aurait pu le dire. Mr. Fogg se contenta de prendre son sac, fit prévenir Mrs. Aouda, et envoya chercher un palanquin.



Il était alors huit heures, et la pleine mer, dont le {Carnatic} devait profiter pour sortir des passes, était indiquée pour neuf heures et demie.



Lorsque le palanquin fut arrivé à la porte de l’hôtel, Mr. Fogg et Mrs. Aouda montèrent dans ce confortable véhicule, et les bagages suivirent derrière sur une brouette.



Une demi-heure plus tard, les voyageurs descendaient sur le quai d’embarquement, et là Mr. Fogg apprenait que le {Carnatic} était parti depuis la veille.



Mr. Fogg, qui comptait trouver, à la fois, et le paquebot et son domestique, en était réduit à se passer de l’un et de l’autre. Mais aucune marque de désappointement ne parut sur son visage, et comme Mrs. Aouda le regardait avec inquiétude, il se contenta de répondre:



«C’est un incident, madame, rien de plus.»



En ce moment, un personnage qui l’observait avec attention s’approcha de lui. C’était l’inspecteur Fix, qui le salua et lui dit:



«N’êtes-vous pas comme moi, monsieur, un des passagers du {Rangoon}, arrivé hier?



– Oui, monsieur, répondit froidement Mr. Fogg, mais je n’ai pas l’honneur…



– Pardonnez-moi, mais je croyais trouver ici votre domestique.



– Savez-vous où il est, monsieur? demanda vivement la jeune femme.



– Quoi! répondit Fix, feignant la surprise, n’est-il pas avec vous?



– Non, répondit Mrs. Aouda. Depuis hier, il n’a pas reparu. Se serait-il embarqué sans nous à bord du {Carnatic}?



– Sans vous, madame?… répondit l’agent. Mais, excusez ma question, vous comptiez donc partir sur ce paquebot?



– Oui, monsieur.



– Moi aussi, madame, et vous me voyez très désappointé. Le {Carnatic}, ayant terminé ses réparations, a quitté Hong-Kong douze heures plus tôt sans prévenir personne, et maintenant il faudra attendre huit jours le prochain départ!»



En prononçant ces mots: «huit jours», Fix sentait son cœur bondir de joie. Huit jours! Fogg retenu huit jours à Hong-Kong! On aurait le temps de recevoir le mandat d’arrêt. Enfin, la chance se déclarait pour le représentant de la loi.



Que l’on juge donc du coup d’assommoir qu’il reçut, quand il entendit Phileas Fogg dire de sa voix calme:



«Mais il y a d’autres navires que le {Carnatic}, il me semble, dans le port de Hong-Kong.»



Et Mr. Fogg, offrant son bras à Mrs. Aouda, se dirigea vers les docks à la recherche d’un navire en partance.



Fix, abasourdi, suivait. On eût dit qu’un fil le rattachait à cet homme.



Toutefois, la chance sembla véritablement abandonner celui qu’elle avait si bien servi jusqu’alors. Phileas Fogg, pendant trois heures, parcourut le port en tous sens, décidé, s’il le fallait, à fréter un bâtiment pour le transporter à Yokohama; mais il ne vit que des navires en chargement ou en déchargement, et qui, par conséquent, ne pouvaient appareiller. Fix se reprit à espérer.



Cependant Mr. Fogg ne se déconcertait pas, et il allait continuer ses recherches, dût-il pousser jusqu’à Macao, quand il fut accosté par un marin sur l’avant-port.



«Votre Honneur cherche un bateau? lui dit le marin en se découvrant.



– Vous avez un bateau prêt à partir demanda Mr. Fogg.



– Oui, Votre Honneur, un bateau-pilote n° 43, le meilleur de la flottille.



– Il marche bien?



– Entre huit et neuf milles, au plus près. Voulez-vous le voir?



– Oui.



– Votre Honneur sera satisfait. Il s’agit d’une promenade en mer?



– Non. D’un voyage.



– Un voyage?



– Vous chargez-vous de me conduire à Yokohama?»



Le marin, à ces mots, demeura les bras ballants, les yeux écarquillés.



«Votre Honneur veut rire? dit-il.



– Non! j’ai manqué le départ du {Carnatic}, et il faut que je sois le 14, au plus tard, à Yokohama, pour prendre le paquebot de San Francisco.



– Je le regrette, répondit le pilote, mais c’est impossible.



– Je vous offre cent livres (2 500 F) par jour, et une prime de deux cents livres si j’arrive à temps.



– C’est sérieux? demanda le pilote.



– Très sérieux», répondit Mr. Fogg.



Le pilote s’était retiré à l’écart. Il regardait la mer, évidemment combattu entre le désir de gagner une somme énorme et la crainte de s’aventurer si loin. Fix était dans des transes mortelles.



Pendant ce temps, Mr. Fogg s’était retourné vers Mrs. Aouda.



«Vous n’aurez pas peur, madame? lui demanda-t-il.



– Avec vous, non, monsieur Fogg», répondit la jeune femme.



Le pilote s’était de nouveau avancé vers le gentleman, et tournait son chapeau entre ses mains.



«Eh bien, pilote? dit Mr. Fogg.



– Eh bien, Votre Honneur, répondit le pilote, je ne puis risquer ni mes hommes, ni moi, ni vous-même, dans une si longue traversée sur un bateau de vingt tonneaux à peine, et à cette époque de l’année. D’ailleurs, nous n’arriverions pas à temps, car il y a seize cent cinquante milles de Hong-Kong à Yokohama.



– Seize cents seulement, dit Mr. Fogg.



– C’est la même chose.»



Fix respira un bon coup d’air.



«Mais, ajouta le pilote, il y aurait peut-être moyen de s’arranger autrement.»



Fix ne respira plus.



«Comment? demanda Phileas Fogg.



– En allant à Nagasaki, l’extrémité sud du Japon, onze cents milles, ou seulement à Shangaï, à huit cents milles de Hong-Kong. Dans cette dernière traversée, on ne s’éloignerait pas de la côte chinoise, ce qui serait un grand avantage, d’autant plus que les courants y portent au nord.



– Pilote, répondit Phileas Fogg, c’est à Yokohama que je dois prendre la malle américaine, et non à Shangaï ou à Nagasaki.



– Pourquoi pas? répondit le pilote. Le paquebot de San Francisco ne part pas de Yokohama. Il fait escale à Yokohama et à Nagasaki, mais son port de départ est Shangaï.



– Vous êtes certain de ce vous dites?



– Certain.



– Et quand le paquebot quitte-t-il Shangaï?



– Le 11, à sept heures du soir. Nous avons donc quatre jours devant nous. Quatre jours, c’est quatre-vingt-seize heures, et avec une moyenne de huit milles à l’heure, si nous sommes bien servis, si le vent tient au sud-est, si la mer est calme, nous pouvons enlever les huit cents milles qui nous séparent de Shangaï.



– Et vous pourriez partir?…



– Dans une heure. Le temps d’acheter des vivres et d’appareiller.



– Affaire convenue… Vous êtes le patron du bateau?



– Oui, John Bunsby, patron de la {Tankadère}.



– Voulez-vous des arrhes?



– Si cela ne désoblige pas Votre Honneur.



– Voici deux cents livres à compte… Monsieur, ajouta Phileas Fogg en se retournant vers Fix, si vous voulez profiter…



– Monsieur, répondit résolument Fix, j’allais vous demander cette faveur.



– Bien. Dans une demi-heure nous serons à bord.



– Mais ce pauvre garçon… dit Mrs. Aouda, que la disparition de Passepartout préoccupait extrêmement.



– Je vais faire pour lui tout ce que je puis faire», répondit Phileas Fogg.



Et, tandis que Fix, nerveux, fiévreux, rageant, se rendait au bateau-pilote, tous deux se dirigèrent vers les bureaux de la police de Hong-Kong. Là, Phileas Fogg donna le signalement de Passepartout, et laissa une somme suffisante pour le rapatrier. Même formalité fut remplie chez l’agent consulaire français, et le palanquin, après avoir touché à l’hôtel, où les bagages furent pris, ramena les voyageurs à l’avant-port.



Trois heures sonnaient. Le bateau-pilote n° 43, son équipage à bord, ses vivres embarqués, était prêt à appareiller.



C’était une charmante petite goélette de vingt tonneaux que la {Tankadère}, bien pincée de l’avant, très dégagée dans ses façons, très allongée dans ses lignes d’eau. On eût dit un yacht de course. Ses cuivres brillants, ses ferrures galvanisées, son pont blanc comme de l’ivoire, indiquaient que le patron John Bunsby s’entendait à la tenir en bon état. Ses deux mâts s’inclinaient un peu sur l’arrière. Elle portait brigantine, misaine, trinquette, focs, flèches, et pouvait gréer une fortune pour le vent arrière. Elle devait merveilleusement marcher, et, de fait, elle avait déjà gagné plusieurs prix dans les «matches» de bateaux-pilotes.



L’équipage de la {Tankadère} se composait du patron John Bunsby et de quatre hommes. C’étaient de ces hardis marins qui, par tous les temps, s’aventurent à la recherche des navires, et connaissent admirablement ces mers. John Bunsby, un homme de quarante-cinq ans environ, vigoureux, noir de hâle, le regard vif, la figure énergique, bien d’aplomb, bien à son affaire, eût inspiré confiance aux plus craintifs.

Phileas Fogg et Mrs. Aouda passèrent à bord. Fix s’y trouvait déjà. Par le capot d’arrière de la goélette, on descendait dans une chambre carrée, dont les parois s’évidaient en forme de cadres, au dessus d’un divan circulaire. Au milieu, une table éclairée par une lampe de roulis. C’était petit, mais propre.



«Je regrette de n’avoir pas mieux à vous offrir», dit Mr. Fogg à Fix, qui s’inclina sans répondre.



L’inspecteur de police éprouvait comme une sorte d’humiliation à profiter ainsi des obligeances du sieur Fogg.



« À coup sûr, pensait-il, c’est un coquin fort poli, mais c’est un coquin!»



À trois heures dix minutes, les voiles furent hissées. Le pavillon d’Angleterre battait à la corne de la goélette. Les passagers étaient assis sur le pont. Mr. Fogg et Mrs. Aouda jetèrent un dernier regard sur le quai, afin de voir si Passepartout n’apparaîtrait pas.



Fix n’était pas sans appréhension, car le hasard aurait pu conduire en cet endroit même le malheureux garçon qu’il avait si indignement traité, et alors une explication eût éclaté, dont le détective ne se fût pas tiré à son avantage. Mais le Français ne se montra pas, et, sans doute, l’abrutissant narcotique le tenait encore sous son influence.



Enfin, le patron John Bunsby passa au large, et la {Tankadère}, prenant le vent sous sa brigantine, sa misaine et ses focs, s’élança en bondissant sur les flots.




{{{XXI
_ OÙ LE PATRON DE LA «TANKADÈRE» RISQUE FORT DE PERDRE UNE PRIME DE DEUX CENTS LIVRES}}}


C’était une aventureuse expédition que cette navigation de huit cents milles, sur une embarcation de vingt tonneaux, et surtout à cette époque de l’année. Elles sont généralement mauvaises, ces mers de la Chine, exposées à des coups de vent terribles, principalement pendant les équinoxes, et on était encore aux premiers jours de novembre.



C’eût été, bien évidemment, l’avantage du pilote de conduire ses passagers jusqu’à Yokohama, puisqu’il était payé tant par jour. Mais son imprudence aurait été grande de tenter une telle traversée dans ces conditions, et c’était déjà faire acte d’audace, sinon de témérité, que de remonter jusqu’à Shangaï. Mais John Bunsby avait confiance en sa {Tankadère}, qui s’élevait à la lame comme une mauve, et peut-être n’avait-il pas tort.



Pendant les dernières heures de cette journée, la {Tankadère} navigua dans les passes capricieuses de Hong-Kong, et sous toutes les allures, au plus près ou vent arrière, elle se comporta admirablement.



«Je n’ai pas besoin, pilote, dit Phileas Fogg au moment où la goélette donnait en pleine mer, de vous recommander toute la diligence possible.



– Que Votre Honneur s’en rapporte à moi, répondit John Bunsby. En fait de voiles, nous portons tout ce que le vent permet de porter. Nos flèches n’y ajouteraient rien, et ne serviraient qu’à assommer l’embarcation en nuisant à sa marche.



– C’est votre métier, et non le mien, pilote, et je me fie à vous.»



Phileas Fogg, le corps droit, les jambes écartées, d’aplomb comme un marin, regardait sans broncher la mer houleuse. La jeune femme, assise à l’arrière, se sentait émue en contemplant cet océan, assombri déjà par le crépuscule, qu’elle bravait sur une frêle embarcation. Au-dessus de sa tête se déployaient les voiles blanches, qui l’emportaient dans l’espace comme de grandes ailes. La goélette, soulevée par le vent, semblait voler dans l’air.



La nuit vint. La lune entrait dans son premier quartier, et son insuffisante lumière devait s’éteindre bientôt dans les brumes de l’horizon. Des nuages chassaient de l’est et envahissaient déjà une partie du ciel.



Le pilote avait disposé ses feux de position, – précaution indispensable à prendre dans ces mers très fréquentées aux approches des atterrages. Les rencontres de navires n’y étaient pas rares, et, avec la vitesse dont elle était animée, la goélette se fût brisée au moindre choc.



Fix rêvait à l’avant de l’embarcation. Il se tenait à l’écart, sachant Fogg d’un naturel peu causeur. D’ailleurs, il lui répugnait de parler à cet homme, dont il acceptait les services. Il songeait aussi à l’avenir. Cela lui paraissait certain que le sieur Fogg ne s’arrêterait pas à Yokohama, qu’il prendrait immédiatement le paquebot de San Francisco a